/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import org.commoncrawl.util.shared.FlexBuffer;

public class BitUtils {

    public static class BitStreamReader {
        BitStream _bitStream;
        int _currPos;

        public BitStreamReader(BitStream bitStream) {
            this._bitStream = bitStream;
            this._currPos = 0;
        }

        public boolean hasNext() {
            return this._currPos < this._bitStream.nbits;
        }

        public int getbit() {
            int bit = this._bitStream.bits.get()[this._bitStream.bits.getOffset() + (this._currPos >> 3)] >> (this._currPos & 7) & 1;
            ++this._currPos;
            return bit;
        }
    }

    public static class BitStream {
        public int nbits;
        public FlexBuffer bits = new FlexBuffer();

        public BitStream() {
            this.nbits = 0;
            this.bits.setCapacity(4);
        }

        public BitStream(byte[] bits, int nbits) {
            this.nbits = nbits;
            this.bits.set(bits, false);
        }

        public BitStream(byte[] bits, int offset, int length, int nbits) {
            this.nbits = nbits;
            this.bits.set(bits, offset, length, false);
        }

        public BitStream(FlexBuffer buffer, int nbits) {
            this.nbits = nbits;
            this.bits = buffer;
        }

        public void reset(FlexBuffer buffer, int nbits) {
            this.nbits = nbits;
            this.bits = buffer;
        }

        public BitStream addbit(int b) {
            int len = this.bits.getCapacity();
            if (this.nbits == len * 8) {
                int newlen = (int)((double)len * 1.5) + 1;
                byte[] tmp = new byte[newlen];
                System.arraycopy(this.bits.get(), this.bits.getOffset(), tmp, 0, this.bits.getCapacity());
                this.bits.set(tmp, false);
            }
            if (b == 1) {
                byte[] byArray = this.bits.get();
                int n = this.bits.getOffset() + (this.nbits >> 3);
                byArray[n] = (byte)(byArray[n] | 1 << (this.nbits & 7));
            }
            ++this.nbits;
            return this;
        }

        public int getBit(int index) {
            return this.bits.get()[this.bits.getOffset() + (index >> 3)] >> (index & 7) & 1;
        }
    }
}

