/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import org.commoncrawl.util.shared.BloomCalculations;
import org.commoncrawl.util.shared.Filter;
import org.commoncrawl.util.shared.ICompactSerializer;

public class BloomFilter
extends Filter {
    static ICompactSerializer<BloomFilter> serializer_ = new BloomFilterSerializer();
    private BitSet filter_;

    public static ICompactSerializer<BloomFilter> serializer() {
        return serializer_;
    }

    public BloomFilter(int numElements, int bucketsPerElement) {
        this(BloomCalculations.computeBestK(bucketsPerElement), new BitSet(numElements * bucketsPerElement + 20));
    }

    public BloomFilter(int numElements, double maxFalsePosProbability) {
        BloomCalculations.BloomSpecification spec = BloomCalculations.computeBucketsAndK(maxFalsePosProbability);
        this.filter_ = new BitSet(numElements * spec.bucketsPerElement + 20);
        this.hashCount = spec.K;
    }

    BloomFilter(int hashes, BitSet filter) {
        this.hashCount = hashes;
        this.filter_ = filter;
    }

    public void clear() {
        this.filter_.clear();
    }

    @Override
    int buckets() {
        return this.filter_.size();
    }

    BitSet filter() {
        return this.filter_;
    }

    @Override
    public boolean isPresent(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    public boolean isPresent(long key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            if (this.filter_.get(bucketIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(String key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public void add(long key) {
        for (int bucketIndex : this.getHashBuckets(key)) {
            this.filter_.set(bucketIndex);
        }
    }

    public String toString() {
        return this.filter_.toString();
    }

    ICompactSerializer tserializer() {
        return serializer_;
    }

    @Override
    int emptyBuckets() {
        int n = 0;
        for (int i = 0; i < this.buckets(); ++i) {
            if (this.filter_.get(i)) continue;
            ++n;
        }
        return n;
    }

    static class BitSetSerializer {
        BitSetSerializer() {
        }

        public static void serialize(BitSet bs, DataOutputStream dos) throws IOException {
            ObjectOutputStream oos = new ObjectOutputStream(dos);
            oos.writeObject(bs);
            oos.flush();
        }

        public static BitSet deserialize(DataInputStream dis) throws IOException {
            ObjectInputStream ois = new ObjectInputStream(dis);
            try {
                return (BitSet)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class BloomFilterSerializer
    implements ICompactSerializer<BloomFilter> {
        BloomFilterSerializer() {
        }

        @Override
        public void serialize(BloomFilter bf, DataOutputStream dos) throws IOException {
            dos.writeInt(bf.getHashCount());
            BitSetSerializer.serialize(bf.filter(), dos);
        }

        @Override
        public BloomFilter deserialize(DataInputStream dis) throws IOException {
            int hashes = dis.readInt();
            BitSet bs = BitSetSerializer.deserialize(dis);
            return new BloomFilter(hashes, bs);
        }
    }
}

