/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class BoundedRangeFileInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    static final Log LOG = LogFactory.getLog(BoundedRangeFileInputStream.class);
    private FSDataInputStream in;
    private long pos;
    private long end;
    private long mark;
    private final byte[] oneByte = new byte[1];
    private final boolean pread;

    public BoundedRangeFileInputStream(FSDataInputStream in, long offset, long length) {
        if (offset < 0L || length < 0L) {
            throw new IndexOutOfBoundsException("Invalid offset/length: " + offset + "/" + length);
        }
        this.in = in;
        this.pos = offset;
        this.end = offset + length;
        this.mark = -1L;
        this.pread = true;
    }

    @Override
    public int available() throws IOException {
        int avail = this.in.available();
        if (this.pos + (long)avail > this.end) {
            avail = (int)(this.end - this.pos);
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        int ret = this.read(this.oneByte);
        if (ret == 1) {
            return this.oneByte[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = (int)Math.min(Integer.MAX_VALUE, Math.min((long)len, this.end - this.pos));
        if (n == 0) {
            return -1;
        }
        int ret = 0;
        if (this.pread) {
            LOG.info((Object)("PREAD Reading at Pos:" + this.pos + " Bytes:" + n));
            ret = this.in.read(this.pos, b, off, n);
        } else {
            FSDataInputStream fSDataInputStream = this.in;
            synchronized (fSDataInputStream) {
                LOG.info((Object)("NONPREAD Reading at Pos:" + this.pos + " Bytes:" + n));
                this.in.seek(this.pos);
                ret = this.in.read(b, off, n);
            }
        }
        if (ret < 0) {
            this.end = this.pos;
            return -1;
        }
        this.pos += (long)ret;
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        long len = Math.min(n, this.end - this.pos);
        this.pos += len;
        return len;
    }

    @Override
    public void mark(int readlimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() throws IOException {
        if (this.mark < 0L) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.mark;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        this.in = null;
        this.pos = this.end;
        this.mark = -1L;
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void seek(long pos) throws IOException {
        this.pos = pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        return this.in.seekToNewSource(targetPos);
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        LOG.info((Object)("Reading at Pos:" + position + " Bytes:" + length));
        return this.in.read(position, buffer, offset, length);
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        LOG.info((Object)("Reading at Pos:" + position + " Bytes:" + buffer.length));
        this.in.readFully(position, buffer);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        LOG.info((Object)("Reading at Pos:" + position + " Bytes:" + length));
        this.in.readFully(position, buffer, offset, length);
    }
}

