/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends InputStream {
    InputStream source;
    long position;

    public CountingInputStream(InputStream source) {
        this.source = source;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public int read() throws IOException {
        int r = this.source.read();
        if (r > 0) {
            ++this.position;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.source.read(b);
        if (r > 0) {
            this.position += (long)r;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.source.read(b, off, len);
        if (r > 0) {
            this.position += (long)r;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.source.skip(n);
        if (r > 0L) {
            this.position += r;
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }
}

