/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;

public class DateUtils {
    static String[] kMonths = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    static String kDelimiters = "\t !\"#$%&'()*+,-./;<=>?@[\\]^_`{|}~";
    static Pattern timePattern = Pattern.compile("(\\d+):(\\d+):(\\d+).*");

    static boolean isASCIIDigit(char c) {
        return c >= '0' & c <= '9';
    }

    public static long parseHttpDate(String time_string) {
        int kMonthsLen = kMonths.length;
        TimeExploded exploded = new TimeExploded();
        StringTokenizer tokenizer = new StringTokenizer(time_string, kDelimiters);
        boolean found_day_of_month = false;
        boolean found_month = false;
        boolean found_time = false;
        boolean found_year = false;
        block6: while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean numerical = DateUtils.isASCIIDigit(token.charAt(0));
            if (!numerical) {
                if (found_month) continue;
                String tokenLowerCase = token.toLowerCase();
                for (int i = 0; i < kMonthsLen; ++i) {
                    if (!tokenLowerCase.startsWith(kMonths[i])) continue;
                    exploded.month = i + 1;
                    found_month = true;
                    continue block6;
                }
                continue;
            }
            if (token.indexOf(58) != -1) {
                Matcher m;
                if (found_time || !(m = timePattern.matcher(token)).matches()) continue;
                try {
                    short hour = Short.parseShort(m.group(1));
                    short minute = Short.parseShort(m.group(2));
                    short second = Short.parseShort(m.group(3));
                    exploded.hour = hour;
                    exploded.minute = minute;
                    exploded.second = second;
                    found_time = true;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (!found_day_of_month && token.length() <= 2) {
                try {
                    exploded.day_of_month = Integer.parseInt(token);
                    found_day_of_month = true;
                }
                catch (NumberFormatException e) {}
                continue;
            }
            if (found_year || token.length() > 5) continue;
            try {
                exploded.year = Integer.parseInt(token);
                found_year = true;
            }
            catch (NumberFormatException e) {
            }
        }
        if (!(found_day_of_month && found_month && found_time && found_year)) {
            return -1L;
        }
        if (exploded.year >= 69 && exploded.year <= 99) {
            exploded.year += 1900;
        }
        if (exploded.year >= 0 && exploded.year <= 68) {
            exploded.year += 2000;
        }
        if (exploded.day_of_month >= 1 && exploded.day_of_month <= 31 && exploded.month >= 1 && exploded.month <= 12 && exploded.year >= 1601 && exploded.year <= 30827 && exploded.hour <= 23 && exploded.minute <= 59 && exploded.second <= 59) {
            Calendar gmtCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            gmtCalendar.set(exploded.year, exploded.month - 1, exploded.day_of_month, exploded.hour, exploded.minute, exploded.second);
            gmtCalendar.set(14, 0);
            return gmtCalendar.getTimeInMillis();
        }
        return -1L;
    }

    public static void main(String[] args) {
        Assert.assertFalse((DateUtils.parseHttpDate("Sun, 22 Nov 2009 01:37:06GMT") == -1L ? 1 : 0) != 0);
        Assert.assertFalse((DateUtils.parseHttpDate("Sun, 22 Nov 2009 01:37:06 GMT") == -1L ? 1 : 0) != 0);
        Assert.assertFalse((DateUtils.parseHttpDate("Thu, 26 May 2011 03:40:51 GMT") == -1L ? 1 : 0) != 0);
    }

    static class TimeExploded {
        int year;
        int month;
        int day_of_week;
        int day_of_month;
        int hour;
        int minute;
        int second;
        int millisecond;

        TimeExploded() {
        }
    }

    public static class DateParser {
        SimpleDateFormat[] parsers = null;

        public DateParser(String[] patterns) {
            this.parsers = new SimpleDateFormat[patterns.length];
            int index = 0;
            for (String pattern : patterns) {
                this.parsers[index++] = new SimpleDateFormat(pattern);
            }
        }

        public Date parseDate(String str) throws ParseException {
            if (str == null) {
                throw new IllegalArgumentException("Date and Patterns must not be null");
            }
            ParsePosition pos = new ParsePosition(0);
            for (SimpleDateFormat parser : this.parsers) {
                Date date = parser.parse(str, pos);
                pos.setIndex(0);
                if (date == null || pos.getIndex() != str.length()) continue;
                return date;
            }
            throw new ParseException("Unable to parse the date: " + str, -1);
        }
    }
}

