/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.util.LinkedList;

public class EscapeUtils {
    public static final char ESCAPE = '\\';

    public static String escape(String s, char[] charsToEscape) {
        StringBuilder buf = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || EscapeUtils.hasChar(charsToEscape, c)) {
                buf.append('\\');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String unescape(String s, char[] charsToEscape) {
        StringBuilder buf = new StringBuilder(s.length());
        boolean inEscapeSequence = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inEscapeSequence) {
                if (c != '\\' && !EscapeUtils.hasChar(charsToEscape, c)) {
                    throw new IllegalArgumentException(c + " is not a valid escape sequence character");
                }
                buf.append(c);
                inEscapeSequence = false;
                continue;
            }
            if (EscapeUtils.hasChar(charsToEscape, c)) {
                throw new IllegalArgumentException(c + " must be escaped");
            }
            if (c == '\\') {
                inEscapeSequence = true;
                continue;
            }
            buf.append(c);
        }
        if (inEscapeSequence) {
            throw new IllegalArgumentException("Unterminated escape sequence");
        }
        return buf.toString();
    }

    private static boolean hasChar(char[] chars, char target) {
        for (char c : chars) {
            if (c != target) continue;
            return true;
        }
        return false;
    }

    public static String concatenate(char separator, String ... strings) {
        char[] charsToEscape = new char[]{separator};
        StringBuilder buf = new StringBuilder();
        for (String s : strings) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(EscapeUtils.escape(s, charsToEscape));
        }
        return buf.toString();
    }

    public static String[] split(char separator, String s) {
        char[] charsToEscape = new char[]{separator};
        LinkedList<String> strings = new LinkedList<String>();
        StringBuilder field = new StringBuilder();
        boolean inEscapeSequence = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!inEscapeSequence && c == separator) {
                strings.add(EscapeUtils.unescape(field.toString(), charsToEscape));
                field.setLength(0);
                continue;
            }
            field.append(c);
            inEscapeSequence = c == '\\' && !inEscapeSequence;
        }
        strings.add(EscapeUtils.unescape(field.toString(), charsToEscape));
        return strings.toArray(new String[strings.size()]);
    }
}

