/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.commoncrawl.util.shared.ByteBufferInputStream;

public class FSByteBufferInputStream
extends BufferedInputStream
implements Seekable,
PositionedReadable {
    ByteBuffer _source;

    public FSByteBufferInputStream(ByteBuffer in) {
        super((InputStream)((Object)new ByteBufferInputStream(in)), in.limit());
        this._source = in;
    }

    public long getPos() throws IOException {
        return this._source.position();
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this._source.position(this._source.position() + (int)n);
        return n;
    }

    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            return;
        }
        long end = this._source.position();
        long start = end - (long)this.count;
        if (pos >= start && pos < end) {
            this.pos = (int)(pos - start);
            return;
        }
        this.pos = 0;
        this.count = 0;
        this._source.position((int)pos);
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        this.pos = 0;
        this.count = 0;
        this._source.position((int)targetPos);
        return true;
    }

    public int read(long position, byte[] buffer, int offset, int length) throws IOException {
        this._source.mark();
        this._source.position((int)position);
        int bytesToRead = Math.min(length, this._source.remaining());
        this._source.get(buffer, offset, bytesToRead);
        this._source.reset();
        return bytesToRead;
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this._source.mark();
        this._source.position((int)position);
        this._source.get(buffer, offset, length);
        this._source.reset();
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        this._source.mark();
        this._source.position((int)position);
        this._source.get(buffer);
        this._source.reset();
    }
}

