/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import org.commoncrawl.util.shared.ICompactSerializer;
import org.commoncrawl.util.shared.MurmurHash;

public abstract class Filter {
    int hashCount;

    int getHashCount() {
        return this.hashCount;
    }

    public int[] getHashBuckets(String key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    public int[] getHashBuckets(long key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    abstract int buckets();

    public abstract void add(String var1);

    public abstract boolean isPresent(String var1);

    abstract int emptyBuckets();

    ICompactSerializer<Filter> getSerializer() {
        Method method = null;
        try {
            method = this.getClass().getMethod("serializer", new Class[0]);
            return (ICompactSerializer)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int[] getHashBuckets(String key, int hashCount, int max) {
        byte[] b;
        try {
            b = key.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int[] result = new int[hashCount];
        int hash1 = MurmurHash.hash(b, b.length, 0);
        int hash2 = MurmurHash.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }

    static int[] getHashBuckets(long key, int hashCount, int max) {
        byte[] b = new byte[]{(byte)(key >>> 56 & 0xFFL), (byte)(key >>> 48 & 0xFFL), (byte)(key >>> 40 & 0xFFL), (byte)(key >>> 32 & 0xFFL), (byte)(key >>> 24 & 0xFFL), (byte)(key >>> 16 & 0xFFL), (byte)(key >>> 8 & 0xFFL), (byte)(key & 0xFFL)};
        int[] result = new int[hashCount];
        int hash1 = MurmurHash.hash(b, b.length, 0);
        int hash2 = MurmurHash.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }
}

