/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.util.shared.CCStringUtils;

public class GZIPUtils {
    private static final Log LOG = LogFactory.getLog(GZIPUtils.class);
    private static final int EXPECTED_COMPRESSION_RATIO = 5;
    private static final int BUF_SIZE = 4096;

    public static final UnzipResult unzipBestEffort(byte[] in) {
        return GZIPUtils.unzipBestEffort(in, 0, in.length, Integer.MAX_VALUE);
    }

    public static final UnzipResult unzipBestEffort(byte[] in, int sizeLimit) {
        return GZIPUtils.unzipBestEffort(in, 0, in.length, sizeLimit);
    }

    public static final UnzipResult unzipBestEffort(byte[] in, int offset, int sizeIn, int sizeLimit) {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
            boolean truncated = false;
            GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(in, offset, sizeIn));
            byte[] buf = new byte[4096];
            int written = 0;
            try {
                int size;
                while ((size = inStream.read(buf)) > 0) {
                    if (written + size > sizeLimit) {
                        outStream.write(buf, 0, sizeLimit - written);
                        truncated = true;
                        break;
                    }
                    outStream.write(buf, 0, size);
                    written += size;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                outStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return new UnzipResult(outStream.toByteArray(), truncated);
        }
        catch (IOException e) {
            return null;
        }
        catch (OutOfMemoryError e) {
            LOG.fatal((Object)CCStringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public static final byte[] unzip(byte[] in) throws IOException {
        int size;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(5 * in.length);
        GZIPInputStream inStream = new GZIPInputStream(new ByteArrayInputStream(in));
        byte[] buf = new byte[4096];
        while ((size = inStream.read(buf)) > 0) {
            outStream.write(buf, 0, size);
        }
        outStream.close();
        return outStream.toByteArray();
    }

    public static final byte[] zip(byte[] in) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream(in.length / 5);
            GZIPOutputStream outStream = new GZIPOutputStream(byteOut);
            try {
                outStream.write(in);
            }
            catch (Exception e) {
                LOG.warn((Object)CCStringUtils.stringifyException((Throwable)e));
            }
            try {
                outStream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)CCStringUtils.stringifyException((Throwable)e));
            }
            return byteOut.toByteArray();
        }
        catch (IOException e) {
            LOG.warn((Object)CCStringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public static class UnzipResult {
        public byte[] data;
        public boolean wasTruncated = false;

        public UnzipResult(byte[] data, boolean truncated) {
            this.data = data;
            this.wasTruncated = truncated;
        }
    }
}

