/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

public class GoogleURL {
    public static final String emptyString = "";
    private boolean _isValid = false;
    private GoogleURLComponent _scheme = new GoogleURLComponent();
    private GoogleURLComponent _userName = new GoogleURLComponent();
    private GoogleURLComponent _password = new GoogleURLComponent();
    private GoogleURLComponent _host = new GoogleURLComponent();
    private GoogleURLComponent _port = new GoogleURLComponent();
    private GoogleURLComponent _path = new GoogleURLComponent();
    private GoogleURLComponent _query = new GoogleURLComponent();
    private GoogleURLComponent _ref = new GoogleURLComponent();
    private String _canonicalURL = null;

    private native void initializeFromURL(String var1);

    private static native void internal_init(Class var0);

    public GoogleURL(String urlString) {
        this.initializeFromURL(urlString);
    }

    public boolean isValid() {
        return this._isValid;
    }

    public boolean has_scheme() {
        return this._scheme.len >= 0;
    }

    public boolean has_username() {
        return this._userName.len >= 0;
    }

    public boolean has_password() {
        return this._password.len >= 0;
    }

    public boolean has_host() {
        return this._host.len > 0;
    }

    public boolean has_port() {
        return this._port.len >= 0;
    }

    public boolean has_path() {
        return this._path.len >= 0;
    }

    public boolean has_query() {
        return this._query.len >= 0;
    }

    public int getQueryOffset() {
        return this._query.begin;
    }

    public int getQueryLen() {
        return this._query.len;
    }

    public boolean has_ref() {
        return this._ref.len >= 0;
    }

    public String getScheme() {
        return this.getComponentString(this._scheme);
    }

    public String getUserName() {
        return this.getComponentString(this._userName);
    }

    public String getPassword() {
        return this.getComponentString(this._password);
    }

    public String getHost() {
        return this.getComponentString(this._host);
    }

    public GoogleURLComponent getHostComponent() {
        return this._host;
    }

    public String getPort() {
        return this.getComponentString(this._port);
    }

    public String getPath() {
        return this.getComponentString(this._path);
    }

    public String getQuery() {
        return this.getComponentString(this._query);
    }

    public String getRef() {
        return this.getComponentString(this._ref);
    }

    public GoogleURLComponent getRefComponent() {
        return this._ref;
    }

    public String getCanonicalURL() {
        return this._canonicalURL;
    }

    public void dump() {
        System.out.println("Scheme:" + this.getScheme());
        System.out.println("UserName:" + this.getUserName());
        System.out.println("Password:" + this.getPassword());
        System.out.println("Host:" + this.getHost());
        System.out.println("Port:" + this.getPort());
        System.out.println("Path:" + this.getPath());
        System.out.println("Query:" + this.getQuery());
        System.out.println("Ref:" + this.getRef());
    }

    private String getComponentString(GoogleURLComponent comp) {
        if (this._canonicalURL == null || comp.len <= 0) {
            return emptyString;
        }
        return this._canonicalURL.substring(comp.begin, comp.begin + comp.len);
    }

    public static void main(String[] args) {
        GoogleURL urlObject = new GoogleURL("http://www.test.co.uk/somethingelse");
        System.out.println(urlObject.getCanonicalURL());
    }

    static {
        System.loadLibrary("GoogleURL_jni");
        GoogleURL.internal_init(GoogleURLComponent.class);
    }

    public static class GoogleURLComponent {
        public int begin;
        public int len;

        public GoogleURLComponent() {
            this.begin = 0;
            this.len = -1;
        }

        public GoogleURLComponent(int b, int l) {
            this.begin = b;
            this.len = l;
        }

        public int end() {
            return this.begin + this.len;
        }

        public boolean is_valid() {
            return this.len != -1;
        }

        public boolean is_nonempty() {
            return this.len > 0;
        }

        public void reset() {
            this.begin = 0;
            this.len = -1;
        }
    }

    static enum ComponentType {
        SCHEME,
        USERNAME,
        PASSWORD,
        HOST,
        PORT,
        PATH,
        QUERY,
        REF;

    }
}

