/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.commoncrawl.util.shared.ByteBufferInputStream;
import org.commoncrawl.util.shared.CCStringUtils;

public class RiceCoder {
    static final Log LOG = LogFactory.getLog(RiceCoder.class);
    private int size;
    private int nbits;
    private int m;
    private byte[] bits;
    private boolean usesSignedEncoding = false;

    public RiceCoder(int mval, boolean usesSignedEncoding) {
        this.bits = new byte[4];
        this.m = mval;
        if (this.m < 0 || this.m > 64) {
            throw new RuntimeException("m < 0 || m > 64");
        }
        this.usesSignedEncoding = usesSignedEncoding;
    }

    public RiceCoder(int mval, int size, int bitCount, byte[] bits, boolean usesSignedEncoding) {
        this.m = mval;
        this.size = size;
        this.nbits = bitCount;
        this.bits = bits;
        this.usesSignedEncoding = usesSignedEncoding;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumBits() {
        return this.nbits;
    }

    public int getNumBitsAsBytes() {
        return (this.nbits + 7) / 8;
    }

    public int getMValue() {
        return this.m;
    }

    public byte[] getBits() {
        return this.bits;
    }

    public int addItem(long val) {
        long x = val;
        boolean extra = false;
        int bitsUsed = 0;
        if (this.usesSignedEncoding) {
            if (val < 0L) {
                this.addbit(1);
                ++bitsUsed;
                if (val != Long.MIN_VALUE) {
                    x = -val;
                }
            } else {
                this.addbit(0);
                ++bitsUsed;
            }
        }
        ++this.size;
        long q = Math.abs(x >> this.m);
        bitsUsed = (int)((long)bitsUsed + q);
        bitsUsed += this.m;
        long r = x & (1L << this.m) - 1L;
        while (q-- > 0L) {
            this.addbit(1);
        }
        if (extra) {
            this.addbit(1);
        }
        this.addbit(0);
        if (this.m > 0) {
            for (long mask = 1L << this.m - 1; mask != 0L; mask >>= 1) {
                this.addbit((r & mask) != 0L ? 1 : 0);
            }
        }
        return bitsUsed;
    }

    private final int getbit(int n) {
        return this.bits[n >> 3] >> (n & 7) & 1;
    }

    private final void addbit(int b) {
        int len = this.bits.length;
        if (this.nbits == len * 8) {
            int newlen = (int)((double)len * 1.5) + 1;
            byte[] tmp = new byte[newlen];
            System.arraycopy(this.bits, 0, tmp, 0, this.bits.length);
            this.bits = tmp;
        }
        if (b == 1) {
            int n = this.nbits >> 3;
            this.bits[n] = (byte)(this.bits[n] | 1 << (this.nbits & 7));
        }
        ++this.nbits;
    }

    public long[] getItems() {
        long[] items = new long[this.size];
        int currbit = 0;
        for (int i = 0; i < this.size; ++i) {
            int isNegative = 0;
            long unary = 0L;
            if (this.usesSignedEncoding) {
                isNegative = this.getbit(currbit++);
            }
            while (this.getbit(currbit) != 0) {
                ++unary;
                ++currbit;
            }
            ++currbit;
            long binary = 0L;
            for (int j = 1; j <= this.m; ++j) {
                binary = binary << 1 | (long)this.getbit(currbit++);
            }
            items[i] = isNegative == 0 ? (unary << this.m) + binary : -(unary << this.m) - binary;
        }
        return items;
    }

    private static double lg(double value) {
        return Math.log(value) / Math.log(2.0);
    }

    public static void main(String[] args) {
        long foo = Long.MIN_VALUE;
        RiceCoder test = new RiceCoder(54, true);
        test.addItem(0L);
        test.addItem(1L);
        test.addItem(-1L);
        test.addItem(Long.MAX_VALUE);
        test.addItem(0x7FFFFFFFFFFFFFFEL);
        test.addItem(-9223372036854775807L);
        test.addItem(Long.MIN_VALUE);
        RiceCodeReader testReader = new RiceCodeReader(54, test.nbits, ByteBuffer.wrap(test.bits), true);
        try {
            Assert.assertTrue((testReader.nextValue() == 0L ? 1 : 0) != 0);
            Assert.assertTrue((testReader.nextValue() == 1L ? 1 : 0) != 0);
            Assert.assertTrue((testReader.nextValue() == -1L ? 1 : 0) != 0);
            Assert.assertTrue((testReader.nextValue() == Long.MAX_VALUE ? 1 : 0) != 0);
            Assert.assertTrue((testReader.nextValue() == 0x7FFFFFFFFFFFFFFEL ? 1 : 0) != 0);
            Assert.assertTrue((testReader.nextValue() == -9223372036854775807L ? 1 : 0) != 0);
            Assert.assertTrue((testReader.nextValue() == Long.MIN_VALUE ? 1 : 0) != 0);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            RiceCodeReader newReader = new RiceCodeReader(54, test.nbits, new FSDataInputStream((InputStream)((Object)new ByteBufferInputStream(ByteBuffer.wrap(test.bits)))), 0L, true);
            try {
                Assert.assertTrue((newReader.nextValue() == 0L ? 1 : 0) != 0);
                Assert.assertTrue((newReader.nextValue() == 1L ? 1 : 0) != 0);
                Assert.assertTrue((newReader.nextValue() == -1L ? 1 : 0) != 0);
                Assert.assertTrue((newReader.nextValue() == Long.MAX_VALUE ? 1 : 0) != 0);
                Assert.assertTrue((newReader.nextValue() == 0x7FFFFFFFFFFFFFFEL ? 1 : 0) != 0);
                Assert.assertTrue((newReader.nextValue() == -9223372036854775807L ? 1 : 0) != 0);
                Assert.assertTrue((newReader.nextValue() == Long.MIN_VALUE ? 1 : 0) != 0);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
        }
    }

    public static final class RiceCodeReader {
        private int m;
        private int currbit = 0;
        private int nbits;
        private ByteBuffer bits;
        private boolean usesSignedEncoding = false;
        private FSDataInputStream stream;
        private long dataOffset;
        private int currByte;
        private int currByteNo = -1;

        public RiceCodeReader(int mValue, int totalBits, ByteBuffer array, boolean usesSignedEncoding) {
            this.m = mValue;
            this.nbits = totalBits;
            this.bits = array;
            this.currbit = 0;
            this.usesSignedEncoding = usesSignedEncoding;
        }

        public RiceCodeReader(int mValue, int totalBits, FSDataInputStream stream, long dataOffset, boolean usesSignedEncoding) {
            this.m = mValue;
            this.nbits = totalBits;
            this.bits = null;
            this.currbit = 0;
            this.usesSignedEncoding = usesSignedEncoding;
            this.stream = stream;
            this.dataOffset = dataOffset;
        }

        public void close() {
            if (this.stream != null) {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                }
                this.stream = null;
            }
        }

        public boolean hasNext() {
            return this.currbit < this.nbits;
        }

        public int getbit() throws IOException {
            return this.getbit(this.currbit++);
        }

        private int getbit(int bitNo) throws IOException {
            if (this.stream == null) {
                return this.bits.get(bitNo >> 3) >> (bitNo & 7) & 1;
            }
            int byteNo = bitNo >> 3;
            if (this.currByteNo != byteNo) {
                this.stream.seek(this.dataOffset + (long)byteNo);
                this.currByte = this.stream.read();
                this.currByteNo = byteNo;
            }
            return this.currByte >> (bitNo & 7) & 1;
        }

        public long nextValue() throws IOException {
            int isNegative = 0;
            long unary = 0L;
            if (this.usesSignedEncoding) {
                isNegative = this.getbit(this.currbit++);
            }
            while (this.getbit(this.currbit++) != 0) {
                ++unary;
            }
            long binary = 0L;
            for (int j = 1; j <= this.m; ++j) {
                binary = binary << 1 | (long)this.getbit(this.currbit++);
            }
            if (isNegative == 1) {
                return -(unary << this.m) - binary;
            }
            return (unary << this.m) + binary;
        }
    }
}

