/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.commoncrawl.async.EventLoop;
import org.commoncrawl.async.Timer;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOHttpConnection;
import org.commoncrawl.io.shared.NIOHttpHeaders;
import org.commoncrawl.util.shared.BandwidthUtils;
import org.commoncrawl.util.shared.S3Utils;

public class S3Downloader
implements NIOHttpConnection.Listener {
    private static final Log LOG = LogFactory.getLog(S3Downloader.class);
    private static final int MAX_FAILURES_PER_ITEM = 5;
    private static final int DEFAULT_MAX_PARALLEL_STREAMS = 20;
    private static final int DEFAULT_MIN_HTTP_BUFFER_SIZE = 32768;
    private static final int DEFAULT_MAX_HTTP_BUFFER_SIZE = 32768;
    private String _s3BucketName;
    private String _s3AccessId;
    private String _s3SecretKey;
    private LinkedList<S3DownloadItem> _queuedItems = new LinkedList();
    private LinkedList<NIOHttpConnection> _activeConnections = new LinkedList();
    private EventLoop _eventLoop = null;
    private boolean _ownsEventLoop = false;
    private S3Utils.CallingFormat _callingFormat = S3Utils.CallingFormat.getSubdomainCallingFormat();
    private Callback _callback;
    private boolean _freezeDownloads = false;
    private int _lastItemId = 0;
    private int _maxParallelStreams = 20;
    private BandwidthUtils.BandwidthHistory _downloaderStats = new BandwidthUtils.BandwidthHistory();
    private boolean _isRequesterPays = false;

    public S3Downloader(String s3BucketName, String s3AccessId, String s3SecretKey, boolean isRequesterPays) throws IOException {
        this._s3BucketName = s3BucketName;
        this._s3AccessId = s3AccessId;
        this._s3SecretKey = s3SecretKey;
        this._isRequesterPays = isRequesterPays;
        this._eventLoop = new EventLoop();
    }

    public EventLoop getEventLoop() {
        return this._eventLoop;
    }

    public void setMaxParallelStreams(int maxStreams) {
        this._maxParallelStreams = maxStreams;
    }

    public int getMaxParallelStreams() {
        return this._maxParallelStreams;
    }

    public void initialize(Callback listener) throws IOException {
        this.initialize(listener, null);
    }

    public void initialize(Callback listener, EventLoop externalEventLoop) throws IOException {
        if (externalEventLoop == null) {
            this._eventLoop = new EventLoop();
            this._ownsEventLoop = true;
        } else {
            this._eventLoop = externalEventLoop;
            this._ownsEventLoop = false;
        }
        if (this._callback != null) {
            throw new RuntimeException("Invalid State - start called on already active downloader");
        }
        if (listener == null) {
            throw new IOException("Null Listener is Invalid");
        }
        this._callback = listener;
        if (this._ownsEventLoop) {
            this._eventLoop.start();
        }
    }

    public void shutdown() {
        if (this._callback == null) {
            throw new RuntimeException("Invalid State - stop called on already inactive downloader");
        }
        this._freezeDownloads = true;
        Thread eventThread = this._ownsEventLoop ? this._eventLoop.getEventThread() : null;
        final Semaphore shutdownSemaphore = new Semaphore(0);
        this._eventLoop.setTimer(new Timer(1L, false, new Timer.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void timerFired(Timer timer) {
                try {
                    for (NIOHttpConnection connection : Lists.newArrayList((Iterable)S3Downloader.this._activeConnections)) {
                        S3DownloadItem item = (S3DownloadItem)connection.getContext();
                        if (item == null) continue;
                        S3Downloader.this.failDownload(item, NIOHttpConnection.ErrorType.UNKNOWN, connection, false);
                    }
                    S3Downloader.this._activeConnections.clear();
                    for (S3DownloadItem item : S3Downloader.this._queuedItems) {
                        S3Downloader.this.failDownload(item, NIOHttpConnection.ErrorType.UNKNOWN, null, false);
                    }
                    S3Downloader.this._queuedItems.clear();
                    S3Downloader.this._freezeDownloads = false;
                    S3Downloader.this._callback = null;
                    if (S3Downloader.this._ownsEventLoop) {
                        S3Downloader.this._eventLoop.stop();
                    }
                    S3Downloader.this._eventLoop = null;
                    S3Downloader.this._ownsEventLoop = false;
                }
                finally {
                    shutdownSemaphore.release();
                }
            }
        }));
        shutdownSemaphore.acquireUninterruptibly();
        try {
            if (eventThread != null) {
                eventThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void waitForCompletion() {
        try {
            this._eventLoop.getEventThread().join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int fetchItem(String itemKey) throws IOException {
        int itemId = -1;
        LinkedList<S3DownloadItem> linkedList = this._queuedItems;
        synchronized (linkedList) {
            itemId = ++this._lastItemId;
            this._queuedItems.addLast(new S3DownloadItem(itemKey, itemId));
        }
        this._eventLoop.setTimer(new Timer(1L, false, new Timer.Callback(){

            @Override
            public void timerFired(Timer timer) {
                S3Downloader.this.downloadNextItem();
            }
        }));
        return itemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int fetchPartialItem(String itemKey, int rangeStart, int bytesToFetch) throws IOException {
        int itemId = -1;
        S3DownloadItem downloadItem = new S3DownloadItem(itemKey, itemId);
        downloadItem.setLastReadPos(rangeStart);
        downloadItem.setContentLength(downloadItem.getLastReadPos() + bytesToFetch);
        LinkedList<S3DownloadItem> linkedList = this._queuedItems;
        synchronized (linkedList) {
            itemId = ++this._lastItemId;
            this._queuedItems.addLast(downloadItem);
        }
        this._eventLoop.setTimer(new Timer(1L, false, new Timer.Callback(){

            @Override
            public void timerFired(Timer timer) {
                S3Downloader.this.downloadNextItem();
            }
        }));
        return itemId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadNextItem() {
        if (this._activeConnections.size() < this._maxParallelStreams) {
            S3DownloadItem item = null;
            LinkedList<S3DownloadItem> linkedList = this._queuedItems;
            synchronized (linkedList) {
                if (this._queuedItems.size() != 0) {
                    item = this._queuedItems.removeFirst();
                }
            }
            if (item != null) {
                this.downloadItem(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadItem(S3DownloadItem item) {
        block10: {
            NIOHttpConnection connection = null;
            try {
                URL theURL = this._callingFormat.getURL(false, "s3.amazonaws.com", 80, this._s3BucketName, item.getKey(), null);
                connection = new NIOHttpConnection(theURL, this._eventLoop.getSelector(), this._eventLoop.getResolver(), null);
                connection.getContentBuffer().setMinBufferSize(32768);
                connection.getContentBuffer().setMaxBufferSize(32768);
                connection.setContext(item);
                connection.setPopulateDefaultHeaderItems(false);
                NIOHttpHeaders headers = connection.getRequestHeaders();
                headers.prepend("GET " + theURL.getFile() + " " + "HTTP/1.1", null);
                if (theURL.getPort() != -1 && theURL.getPort() != 80) {
                    headers.set("Host", theURL.getHost() + ":" + String.valueOf(theURL.getPort()));
                } else {
                    headers.set("Host", theURL.getHost());
                }
                TreeMap amazonHeaders = new TreeMap();
                String theDate = S3Downloader.httpDate();
                headers.set("Date", theDate);
                S3Downloader.addToAmazonHeader("Date", theDate, amazonHeaders);
                if (this._isRequesterPays) {
                    headers.set("x-amz-request-payer", "requester");
                    S3Downloader.addToAmazonHeader("x-amz-request-payer", "requester", amazonHeaders);
                }
                String canonicalString = S3Utils.makeCanonicalString("GET", this._s3BucketName, item.getKey(), null, amazonHeaders);
                String encodedCanonical = S3Utils.encode(this._s3SecretKey, canonicalString, false);
                headers.set("Authorization", "AWS " + this._s3AccessId + ":" + encodedCanonical);
                if (item.isContinuation()) {
                    String rangeString = "bytes=" + item.getLastReadPos() + "-" + item.getContentLength();
                    headers.set("Range", rangeString);
                    if (item.getLastKnownETag() != null) {
                        headers.set("If-match", item.getLastKnownETag());
                    }
                }
                headers.set("Connection", "close");
                headers.set("Cache-Control", "no-cache");
                headers.set("Pragma", "no-cache");
                headers.remove("Accept-Encoding");
                headers.set("Accept-Encoding", "identity");
                connection.setListener(this);
                connection.open();
                this._activeConnections.add(connection);
            }
            catch (IOException e) {
                LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                LOG.error((Object)("Failure Opening Connection For Key:" + item.getKey()));
                LinkedList<S3DownloadItem> linkedList = this._queuedItems;
                synchronized (linkedList) {
                    this._queuedItems.addLast(item);
                }
                if (connection == null) break block10;
                connection.setListener(null);
                connection.setContext(null);
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void requeueDownloadItem(S3DownloadItem item) {
        LinkedList<S3DownloadItem> linkedList = this._queuedItems;
        synchronized (linkedList) {
            this._queuedItems.addLast(item);
        }
    }

    private final void resetConnection(NIOHttpConnection theConnection) {
        theConnection.close();
        theConnection.setListener(null);
        theConnection.setContext(null);
        this._activeConnections.remove(theConnection);
    }

    private final void failDownload(S3DownloadItem item, NIOHttpConnection.ErrorType errorType, NIOHttpConnection theConnection, boolean potentiallyRetry) {
        int resultCode = -1;
        if (theConnection != null) {
            NIOHttpHeaders headers = theConnection.getResponseHeaders();
            resultCode = NIOHttpConnection.getHttpResponseCode(headers);
            if (item != null) {
                item.incrementFailureCount(errorType, resultCode);
            }
            this.resetConnection(theConnection);
        }
        if (item != null) {
            if (potentiallyRetry && item.isDownloadRecoverable()) {
                this.requeueDownloadItem(item);
            } else {
                LOG.error((Object)("Download Failed for Item:" + item.getKey()));
                if (this._callback != null) {
                    this._callback.downloadFailed(item.getId(), item.getKey(), "Failure Reason:" + errorType.toString() + " ResultCode:" + resultCode);
                }
            }
        }
        if (!this._freezeDownloads) {
            this.downloadNextItem();
        }
    }

    private final void completeDownload(S3DownloadItem item, NIOHttpConnection theConnection) {
        if (item != null && this._callback != null) {
            this._callback.downloadComplete(item.getId(), item.getKey());
        }
        this.resetConnection(theConnection);
        if (!this._freezeDownloads) {
            this.downloadNextItem();
        }
    }

    @Override
    public void HttpConnectionStateChanged(NIOHttpConnection theConnection, NIOHttpConnection.State oldState, NIOHttpConnection.State state) {
        if (oldState == NIOHttpConnection.State.PARSING_HEADERS && state == NIOHttpConnection.State.RECEIVING_CONTENT) {
            NIOHttpHeaders headers = theConnection.getResponseHeaders();
            LOG.info((Object)("*** S3 INCOMING HEADERS:" + headers.toString()));
            LOG.info((Object)("Content Length From Header for:" + theConnection.getURL() + " is:" + headers.findValue("Content-Length")));
        }
        LOG.info((Object)("S3Download Connection:" + theConnection.getURL() + " Old State:" + (Object)((Object)oldState) + " NewState:" + (Object)((Object)state)));
        S3DownloadItem item = (S3DownloadItem)theConnection.getContext();
        if (state == NIOHttpConnection.State.RECEIVING_CONTENT) {
            NIOHttpHeaders headers = theConnection.getResponseHeaders();
            int resultCode = NIOHttpConnection.getHttpResponseCode(headers);
            boolean continueDownloading = false;
            boolean isContinuation = false;
            if (item != null && resultCode >= 200 && resultCode < 300) {
                continueDownloading = true;
                String etagValue = headers.findValue("ETag");
                String contentLengthValue = headers.findValue("Content-Length");
                String rangeValue = headers.findValue("Content-Range");
                if (etagValue != null && contentLengthValue != null) {
                    try {
                        int contentLength;
                        if (rangeValue != null) {
                            isContinuation = true;
                            contentLengthValue = rangeValue.substring(rangeValue.indexOf(47) + 1);
                        }
                        if ((contentLength = Integer.parseInt(contentLengthValue)) != -1) {
                            item.setLastKnownETagAndContentLength(etagValue, contentLength);
                        }
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Object)StringUtils.stringifyException((Throwable)e));
                        continueDownloading = false;
                    }
                }
            }
            if (continueDownloading && !isContinuation && this._callback != null) {
                continueDownloading = this._callback.downloadStarting(item.getId(), item.getKey(), item.getContentLength());
            }
            if (!continueDownloading) {
                this.failDownload(item, NIOHttpConnection.ErrorType.UNKNOWN, theConnection, true);
            }
        }
        if (state == NIOHttpConnection.State.ERROR) {
            this.failDownload(item, theConnection.getErrorType(), theConnection, true);
        }
        if (state == NIOHttpConnection.State.DONE) {
            this.completeDownload(item, theConnection);
        }
    }

    @Override
    public void HttpContentAvailable(NIOHttpConnection theConnection, NIOBufferList contentBuffer) {
        S3DownloadItem item = (S3DownloadItem)theConnection.getContext();
        if (item != null) {
            item.getDownloadStats().update(contentBuffer.available());
            this._downloaderStats.update(contentBuffer.available());
            item.setLastReadPos(item.getLastReadPos() + contentBuffer.available());
            item.incrementDownloadedBytesCounter(contentBuffer.available());
            if (item.getDownloadedBytes() >= 100000) {
                BandwidthUtils.BandwidthStats stats = new BandwidthUtils.BandwidthStats();
                BandwidthUtils.BandwidthStats aggregateStats = new BandwidthUtils.BandwidthStats();
                item.getDownloadStats().calcSpeed(stats);
                this._downloaderStats.calcSpeed(aggregateStats);
                item.resetDownloadedBytes();
            }
            boolean continueDownload = true;
            if (this._callback != null) {
                continueDownload = this._callback.contentAvailable(theConnection, item.getId(), item.getKey(), contentBuffer);
            }
            if (!continueDownload) {
                LOG.info((Object)("Explicit Abort Received via contentAvailabe for Item:" + item.getKey()));
                this.failDownload(item, NIOHttpConnection.ErrorType.UNKNOWN, theConnection, false);
            }
        }
        try {
            while (contentBuffer.read() != null) {
            }
        }
        catch (IOException e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
        }
        contentBuffer.reset();
    }

    private static String httpDate() {
        String DateFormat2 = "EEE, dd MMM yyyy HH:mm:ss ";
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date()) + "GMT";
    }

    private static void addToAmazonHeader(String key, String value, Map amazonHeaders) {
        Vector<String> list = (Vector<String>)amazonHeaders.get(key);
        if (list == null) {
            list = new Vector<String>();
            amazonHeaders.put(key, list);
        }
        list.add(value);
    }

    private static class S3DownloadItem {
        private String _itemKey;
        private int _itemId = 0;
        private String _lastKnownETag = null;
        private int _lastKnownContentLength = -1;
        private short _failureCount = 0;
        private int _lastReadPos = 0;
        private NIOHttpConnection.ErrorType _lastErrorType = NIOHttpConnection.ErrorType.UNKNOWN;
        private int _lastKnownResultCode = -1;
        private int _downloadedBytes;
        private BandwidthUtils.BandwidthHistory _downloadStats = new BandwidthUtils.BandwidthHistory();

        public S3DownloadItem(String itemKey, int itemId) {
            this._itemKey = itemKey;
            this._itemId = itemId;
        }

        public void downloadComplete() {
        }

        public void downloadFailed() {
        }

        public String getKey() {
            return this._itemKey;
        }

        public int getId() {
            return this._itemId;
        }

        public void setLastReadPos(int lastReadPos) {
            this._lastReadPos = lastReadPos;
        }

        public int getLastReadPos() {
            return this._lastReadPos;
        }

        public int getFailureCount() {
            return this._failureCount;
        }

        public BandwidthUtils.BandwidthHistory getDownloadStats() {
            return this._downloadStats;
        }

        public boolean isDownloadRecoverable() {
            if (this._lastErrorType == NIOHttpConnection.ErrorType.UNKNOWN || this._lastErrorType == NIOHttpConnection.ErrorType.IOEXCEPTION || this._lastErrorType == NIOHttpConnection.ErrorType.TIMEOUT) {
                if (this._lastKnownResultCode >= 400 && this._lastKnownResultCode < 500) {
                    return false;
                }
                return this._failureCount < 5;
            }
            return false;
        }

        public void incrementFailureCount(NIOHttpConnection.ErrorType errorType, int lastKnownResultCode) {
            this._failureCount = (short)(this._failureCount + 1);
            this._lastErrorType = errorType;
            this._lastKnownResultCode = lastKnownResultCode;
        }

        public String getLastKnownETag() {
            return this._lastKnownETag;
        }

        public int getContentLength() {
            return this._lastKnownContentLength;
        }

        public void setContentLength(int contentLength) {
            this._lastKnownContentLength = contentLength;
        }

        public boolean isContinuation() {
            return this._lastReadPos != 0;
        }

        public int getDownloadedBytes() {
            return this._downloadedBytes;
        }

        public void resetDownloadedBytes() {
            this._downloadedBytes = 0;
        }

        public void incrementDownloadedBytesCounter(int newlyReceivedByteCount) {
            this._downloadedBytes += newlyReceivedByteCount;
        }

        public void setLastKnownETagAndContentLength(String etag, int contentLength) {
            this._lastKnownETag = etag;
            this._lastKnownContentLength = contentLength;
        }
    }

    public static interface Callback {
        public boolean downloadStarting(int var1, String var2, int var3);

        public boolean contentAvailable(NIOHttpConnection var1, int var2, String var3, NIOBufferList var4);

        public void downloadFailed(int var1, String var2, String var3);

        public void downloadComplete(int var1, String var2);
    }
}

