/*
 * Decompiled with CFR 0.152.
 */
package org.commoncrawl.util.shared;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.commoncrawl.async.Callbacks;
import org.commoncrawl.io.internal.NIOBufferList;
import org.commoncrawl.io.internal.NIOBufferListInputStream;
import org.commoncrawl.io.internal.NIOHttpConnection;
import org.commoncrawl.util.shared.CCStringUtils;
import org.commoncrawl.util.shared.S3Downloader;

public class S3InputStream
extends NIOBufferListInputStream
implements S3Downloader.Callback {
    private static final Log LOG = LogFactory.getLog(S3InputStream.class);
    URI uri;
    S3Downloader downloader = null;
    AtomicReference<Exception> _exception = new AtomicReference();
    ReentrantLock _writeLock = new ReentrantLock();
    AtomicReference<Condition> _writeEvent = new AtomicReference<Condition>(this._writeLock.newCondition());
    AtomicBoolean _eofCondition = new AtomicBoolean();
    AtomicReference<NIOHttpConnection> pausedConnection = new AtomicReference();
    int MAX_BUFFER_SIZE = 0x100000;

    public S3InputStream(URI uri, String s3AccessKey, String s3Secret, int bufferSize) throws IOException {
        super(new NIOBufferList());
        this.uri = uri;
        this.downloader = new S3Downloader(uri.getHost(), s3AccessKey, s3Secret, false);
        this.downloader.setMaxParallelStreams(1);
        this.downloader.initialize(this);
        LOG.info((Object)("Fetching:" + uri.getPath()));
        this.downloader.fetchItem(uri.getPath().substring(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureBuffer() throws IOException {
        super.ensureBuffer();
        while (this._activeBuf == null) {
            this._writeLock.lock();
            try {
                if (this._eofCondition.get()) {
                    if (this._exception.get() != null) {
                        LOG.error((Object)("Read from Main Thread for Path:" + this.uri + " detected Exception"));
                        throw new IOException(this._exception.get());
                    }
                    LOG.info((Object)("Read from Main Thread for Path:" + this.uri + " detected EOF"));
                    return;
                }
                this._writeEvent.set(this._writeLock.newCondition());
                try {
                    this._writeEvent.get().await();
                }
                catch (InterruptedException e) {
                    LOG.error((Object)("Read from Main Thread for Path:" + this.uri + " was Interrupted. Exiting"));
                    throw new IOException(e);
                }
            }
            finally {
                this._writeLock.unlock();
            }
            super.ensureBuffer();
        }
        if (this.pausedConnection.get() != null && this._bufferQueue.available() < this.MAX_BUFFER_SIZE) {
            final NIOHttpConnection connection = this.pausedConnection.get();
            this.pausedConnection.set(null);
            this.downloader.getEventLoop().queueAsyncCallback(new Callbacks.Callback(){

                @Override
                public void execute() {
                    System.out.println("*** RESUMING DOWNLOADS ***");
                    try {
                        connection.enableReads();
                    }
                    catch (IOException e) {
                        LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
                    }
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        this.downloader.shutdown();
    }

    @Override
    public boolean downloadStarting(int itemId, String itemKey, int contentLength) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contentAvailable(NIOHttpConnection theConnection, int itemId, String itemKey, NIOBufferList contentBuffer) {
        ByteBuffer buffer = null;
        IOException exception = null;
        try {
            while ((buffer = contentBuffer.read()) != null) {
                if (buffer.position() != 0) {
                    buffer = buffer.slice();
                }
                buffer.position(buffer.limit());
                this._bufferQueue.write(buffer);
            }
            this._bufferQueue.flush();
        }
        catch (IOException e) {
            LOG.error((Object)CCStringUtils.stringifyException((Throwable)e));
            exception = e;
        }
        if (this._bufferQueue.available() >= this.MAX_BUFFER_SIZE) {
            theConnection.disableReads();
            this.pausedConnection.set(theConnection);
        }
        this._writeLock.lock();
        try {
            Condition writeCondition = this._writeEvent.getAndSet(null);
            if (exception != null) {
                this._eofCondition.set(true);
                this._exception.set(exception);
            }
            if (writeCondition != null) {
                writeCondition.signal();
            }
        }
        finally {
            this._writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFailed(int itemId, String itemKey, String errorCode) {
        LOG.error((Object)("Download Failed for URI:" + this.uri));
        this._writeLock.lock();
        try {
            this._exception.set(new IOException(errorCode));
            this._eofCondition.set(true);
            Condition writeCondition = this._writeEvent.getAndSet(null);
            if (writeCondition != null) {
                writeCondition.signal();
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadComplete(int itemId, String itemKey) {
        LOG.info((Object)("Download Complete for URI:" + this.uri));
        this._writeLock.lock();
        try {
            this._exception.set(null);
            this._eofCondition.set(true);
            Condition writeCondition = this._writeEvent.getAndSet(null);
            if (writeCondition != null) {
                writeCondition.signal();
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }
}

