(ns convana.core
  (:require [bultitude.core :as b]
            [robert.hooke :as rh]))

(defn- pre-create-hook-fn
  [context k v]
  "pre create function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn- post-create-hook-fn
  [context k v]
  "post create function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn- do-create-hook-fn
  [context k v]
  "do create function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn create-it
  [context k v]
  (let [[pre-c pre-k pre-v] (pre-create-hook-fn context k v)]
    (if (:do-create pre-c)
      (let [[do-c do-k do-v] (do-create-hook-fn pre-c pre-k pre-v)]
        (post-create-hook-fn do-c do-k do-v))
      (post-create-hook-fn pre-c pre-k pre-v))))

(defn- pre-read-hook-fn
  [context k v]
  "pre read function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn- post-read-hook-fn
  [context k v]
  "post read function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn- do-read-hook-fn
  [context k v]
  "do read function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn read-it
  "returns the value of the configuration identified by k"
  [context k v]
  (let [[pre-c pre-k pre-v] (pre-read-hook-fn context k v)]
    (if (:do-read pre-c)
      (let [[do-c do-k do-v] (do-read-hook-fn pre-c pre-k pre-v)]
        (post-read-hook-fn do-c do-k do-v))
      (post-read-hook-fn pre-c pre-k pre-v))))


(defn- pre-update-hook-fn
  [context k v]
  "pre update function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn- post-update-hook-fn
  [context k v]
  "post update function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn- do-update-hook-fn
  [context k v]
  "do update function suitable for use as a hook with robert-hooke library."
  [context k v]
  )

(defn update-it
  "updates the value of configutation identified by k to value v"
  [context k v]
  (let [[pre-c pre-k pre-v] (pre-update-hook-fn context k v)]
    (if (:do-update pre-c)
      (let [[do-c do-k do-v] (do-update-hook-fn pre-c pre-k pre-v)]
        (post-update-hook-fn do-c do-k do-v))
      (post-update-hook-fn pre-c pre-k pre-v))))



(defn- pre-delete-hook-fn
  [context k]
  "pre delete function suitable for use as a hook with robert-hooke library."
  [context k]
  )

(defn- post-delete-hook-fn
  [context k]
  "post delete function suitable for use as a hook with robert-hooke library."
  [context k]
  )

(defn- do-delete-hook-fn
  [context k]
  "do delete function suitable for use as a hook with robert-hooke library."
  [context k]
  )

(defn delete-it
  "deletes configuration identified by k"
  [context k]
  (let [[pre-c pre-k] (pre-delete-hook-fn context k)]
    (if (:do-delete pre-c)
      (let [[do-c do-k] (do-delete-hook-fn pre-c pre-k)]
        (post-delete-hook-fn do-c do-k))
      (post-delete-hook-fn pre-c pre-k))))

; Hook definitions

(def pre-create-hook #'pre-create-hook-fn)
(def do-create-hook #'do-create-hook-fn)
(def post-create-hook #'post-create-hook-fn)

(def create-hooks
  [pre-create-hook
   do-create-hook
   post-create-hook])

(def pre-read-hook #'pre-read-hook-fn)
(def do-read-hook #'do-read-hook-fn)
(def post-read-hook #'post-read-hook-fn)

(def read-hooks
  [pre-read-hook
   do-read-hook
   post-read-hook])

(def pre-update-hook #'pre-update-hook-fn)
(def do-update-hook #'do-update-hook-fn)
(def post-update-hook #'post-update-hook-fn)

(def update-hooks
  [pre-update-hook
   do-update-hook
   post-update-hook])

(def pre-delete-hook #'pre-delete-hook-fn)
(def do-delete-hook #'do-delete-hook-fn)
(def post-delete-hook #'post-delete-hook-fn)

(def delete-hooks
  [pre-delete-hook
   do-delete-hook
   post-delete-hook])

(def all-hooks
  (conj create-hooks read-hooks update-hooks delete-hooks))

(defn reset-hooks
  [hooks]
  (doall
    (map rh/clear-hooks hooks)))
