(ns leiningen.new.convana-plugin
  (:use [leiningen.new.templates :only [renderer name-to-path ->files]])
  (:require [clj-time.core :as t]))

(def render (renderer "convana-plugin"))

(defn- to-file-name
  [name]
  (clojure.string/replace name #"-" "_"))

;(defn- plugin-name
;  [name]
;  (str name "-plugin"))

(defn convana-plugin
  "create a new convana-plugin project"
  [name]
  (let [ ;name (plugin-name name)
         data {:name name
              :filename (to-file-name name)
              :sanitized (name-to-path name)
              :year (t/year (t/now))}]
    (->files data
      [".gitignore" (render "gitignore")]
      ["LICENSE" (render "LICENSE")]
      ["project.clj" (render "project.clj" data)]
      ["src/convana/plugin/{{filename}}.clj" (render "hook.clj" data)]
      ["test/convana/plugin/{{filename}}_test.clj" (render "hook_test.clj" data)]
      ["test/docs/documentation.clj" (render "documentation.clj" data)]
      )))
