; Copyright {{year}} Thorben Stangenberg
;
; Licensed under the Apache License, Version 2.0 (the "License");
; You may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
; http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

(ns convana.plugin.{{name}}
  (:require [robert.hooke :as rh]
            [convana.core :as convana]))

(defn pre-create
  [f context k v]
  (apply f context k v))

(defn do-create
  [f context k v]
  (apply f context k v))

(defn post-create
  [f context k v]
  (apply f context k v))

(defn pre-read
  [f context k v]
  (apply f context k v))

(defn do-read
  [f context k v]
  (apply f context k v))

(defn post-read
  [f context k v]
  (apply f context k v))

(defn pre-update
  [f context k v]
  (apply f context k v))

(defn do-update
  [f context k v]
  (apply f context k v))

(defn post-update
  [f context k v]
  (apply f context k v))

(defn pre-delete
  [f context k]
  (apply f context k))

(defn do-delete
  [f context k]
  (apply f context k))

(defn post-delete
  [f context k]
  (apply f context k))

(rh/add-hook convana/pre-create-hook #'pre-create)
(rh/add-hook convana/do-create-hook #'do-create)
(rh/add-hook convana/post-create-hook #'post-create)

(rh/add-hook convana/pre-read-hook #'pre-read)
(rh/add-hook convana/do-read-hook #'do-read)
(rh/add-hook convana/post-read-hook #'post-read)

(rh/add-hook convana/pre-update-hook #'pre-update)
(rh/add-hook convana/do-update-hook #'do-update)
(rh/add-hook convana/post-update-hook #'post-update)

(rh/add-hook convana/pre-delete-hook #'pre-delete)
(rh/add-hook convana/do-delete-hook #'do-delete)
(rh/add-hook convana/post-delete-hook #'post-delete)
