(use '[clojure.java.shell :only (sh)])
(require '[clojure.string :as string])

(defn git-ref
  []
  (or (System/getenv "GIT_COMMIT")
      (string/trim (:out (sh "git" "rev-parse" "HEAD")))
      ""))

(defproject org.cyverse/event-messages "0.0.1-SNAPSHOT"
  :description "Code generated from the github.com/cyverse-de/proto-events project"
  :url "https://github.com/cyverse-de/java-events"
  :license {:name "BSD"
            :url "http://cyverse.org/sites/default/files/iPLANT-LICENSE.txt"}
  :manifest {:Git-Ref ~(git-ref)}
  :dependencies [[org.clojure/clojure "1.8.0"]
                 [com.google.protobuf/protobuf-java "3.1.0"]
                 [com.google.protobuf/protobuf-java-util "3.1.0"]]
  :java-source-paths ["src/java"]
  :min-lein-version "2.0.0")
