(ns facetious.core
  #?(:clj (:require [compojure.core :refer [defroutes routes GET POST]]
                    (facetious.authentication 
                     [twitter :as twitter]
                     [etsy :as etsy]
                     [ecwid :as ecwid]
                     [shopify :as shopify]
                     [bitly :as bitly]
                     [google :as google]))
     :cljs (:require [ajax.core :refer [GET POST]]
                     [om-flash-bootstrap.core :as f])))

#?(:clj
   (defroutes facetious
     (POST "twitter/authorize" [] twitter/authorize)
     (GET "/twitter/callback" [] twitter/callback)
     (POST "/etsy/authorize" [] etsy/authorize)
     (GET "/etsy/callback" [] etsy/callback)
     (GET "/shopify/install" [] shopify/app-store)
     (POST "/shopify/authorize" [] shopify/authorize)
     (GET "/shopify/callback" [] shopify/callback)
     (POST "/bitly/authorize" [] bitly/authorize)
     (GET "/bitly/callback" [] bitly/callback)
     (POST "/ecwid/authorize" [] ecwid/authorize)
     (GET "/ecwid/callback" [] ecwid/callback)
     (POST "/google/authorize" [] google/authorize)
     (GET "/google/callback" [] google/callback)
     (GET "/logout" [] helper/logout)))

#?(:cljs
   (defn post [opts]
     (POST (:url opts)
         {:headers {"X-CSRF-Token" (:csrf-token opts)}
          :params {:type (:type opts)
                   :domain (:domain opts)}
          :handler (fn [response] (set! (.-location js/window) (str response)))
          :error-handler (fn [{:keys [status status-text]}]
                           [let [message (str status ":" status-text)]]
                           (if (:flash opts)
                             (f/alert (:flash opts) message)
                             (println message)))})))
