(ns facetious.authentication.github
  (:require 
   [facetious.helpers :as helpers]
   [environ.core :refer [env]]
   [ring.util.response :as util]
   [clj-http.client :as client]
   [clojure.string :as str]))

(def oauth2-params
   {:authorize-uri  "https://github.com/login/oauth/authorize"
    :access-token-uri "https://github.com/login/oauth/access_token"
    :scopes ["user:email"]})

(defn authorize [{headers :headers session :session params :params :as req}]
  (let [state (helpers/rand-str 20)
        redirect-uri (str (:authorize-uri oauth2-params) "?client_id=" (:github-client env) "&state=" state "&redirect_uri=" (helpers/derive-callback headers "/github/callback") "&scope=" (str/join " " (or (:github-scopes env) (:scopes oauth2-params))))]
    {:status 200
     :session (assoc session :github {:state state}) 
     :body redirect-uri}))

(defn callback [{headers :headers session :session {state :state code :code} :params :as req}]
  (let [error-message {:message "There was a problem authorizing you" :level :danger}
        success-message {:message "Successfully authorized" :level :success}]
    (if (= state (:state (:github session)))
      (let [resp (client/post (:access-token-uri oauth2-params) {:form-params {:client_id (:github-client env)
                                                                               :client_secret (:github-secret env)
                                                                               :code code
                                                                               :state state
                                                                               :redirect_uri (helpers/derive-callback headers "/github/callback")}
                                                                 :as :auto})]
        (-> (util/redirect "/")
           (assoc :session (assoc session :github (:body resp)))
             (assoc :flash success-message)))
      (-> (util/redirect "/")
         (assoc :flash error-message)))))


