(ns facetious.authentication.dropbox
  (:require [environ.core :refer [env]]
            [crypto.random :as random]
            [ring.util.codec :as codec]
            [facetious.helpers :as helpers]
            [clj-http.client :as client]))

;; implicit grant

(def oauth2-params
  {:authorize-uri  "https://www.dropbox.com/1/oauth2/authorize"
   :response_type "token"})

(defn generate-authorize-uri []
  (let [dropboxing-key "oikbes4x17j4emt"
        csrf-token (random/base64 60)]
    (str (:authorize-uri oauth2-params) "?client_id=" dropboxing-key "&response_type=token" "&state=" (codec/url-encode csrf-token) "&redirect_uri=http://localhost/dropboxing/callback"))) ; vclsQRBP4cwAAAAAAAAwk2Jgy_ZogP3yNewPV9Cnw05OTBuWQBMeJq1buYALnnPL

(defn authorize [{headers :headers session :session params :params :as req}]
  (let [csrf-token (random/base64 60)
        redirect-uri (str (:authorize-uri oauth2-params) "?client_id=" (:dropbox-client env) "&response_type" (:reponse_type oauth2-params) "&state=" (codec/url-encode csrf-token) "&redirect_uri=" (helpers/derive-callback headers "/dropbox/callback"))]
    {:status 200
     :session (assoc session :dropbox {:state csrf-token})
     :body redirect-uri}))

(defn callback [{headers :headers session :session {access_token :access_token token_type :token_type uid :uid state :state account_id :account_id} :params :as req}]
  ;verify state
  ; that's it
  )
