(ns facetious.authentication.ecwid
  (:require 
   [facetious.helpers :as helpers]
   [environ.core :refer [env]]
   [ring.util.codec :as codec]
   [ring.util.response :as util]
   [clj-http.client :as client]
   [clojure.string :as str]))

(def oauth2-params
   {:authorize-uri  "https://my.ecwid.com/api/oauth/authorize"
    :access-token-uri "https://my.ecwid.com/api/oauth/token"
    :grant_type "authorization_code"
    :scopes ["read_store_profile" "read_catalog"]})

(defn authorize [{headers :headers session :session params :params :as req}]
  (let [redirect-uri (str (:authorize-uri oauth2-params) "?client_id=" (:ecwid-client env) "&response_type=code" "&scope=" (codec/url-encode (str/join " " (:scopes oauth2-params))) "&redirect_uri=" (helpers/derive-callback headers "/ecwid/install"))]
    {:status 200
     :session (assoc session :ecwid {:state :ongoing}) 
     :body redirect-uri}))

(defn callback [{headers :headers session :session params :params :as req}]
  (let [error-message {:message "There was a problem authorizing you with Ecwid." :level :danger}
        success-message {:message "Successfully authorized Ecwid." :level :success}]
    (if-let [code (:code params)]
      (let [ecwid-creds (:body (client/post (:access-token-uri oauth2-params) {:form-params {:client_id (:ecwid-client env)
                                                                                             :client_secret (:ecwid-secret env)
                                                                                             :code code
                                                                                             :redirect_uri (helpers/derive-callback headers (:ecwid-redirect env))
                                                                                             :grant_type "authorization_code"}
                                                                               :as :auto}))
            session (assoc session :ecwid ecwid-creds)]
        (-> (util/redirect "/")
            (assoc :session session)
            (assoc :flash success-message)))
      (-> (util/redirect "/")
          (assoc :flash error-message)))))

(def install callback)
