/*
 * Decompiled with CFR 0.152.
 */
package org.danielsz.shade.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.codehaus.plexus.util.IOUtil;
import us.bpsm.edn.EdnSyntaxException;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;

public class EdnDataReaderTransformer
implements ResourceTransformer {
    String resource;
    HashMap hm = new HashMap();

    public boolean canTransformResource(String r) {
        return this.resource != null && this.resource.equalsIgnoreCase(r);
    }

    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        String content = IOUtils.toString((InputStream)is, (Charset)Charset.forName("UTF-8"));
        try {
            Parseable pbr = Parsers.newParseable((CharSequence)content);
            Parser p = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
            this.hm.putAll((Map)p.nextValue(pbr));
        }
        catch (EdnSyntaxException e) {
            System.out.print(e.getMessage() + "\n" + content);
        }
        catch (ClassCastException e) {
            System.out.print(e.getMessage() + "\n" + content);
        }
    }

    public boolean hasTransformedResource() {
        return this.hm.size() > 0;
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        String out = this.hm.toString().replace("=", " ");
        jos.putNextEntry(new JarEntry(this.resource));
        IOUtil.copy((InputStream)new ByteArrayInputStream(out.getBytes(Charset.forName("UTF-8"))), (OutputStream)jos);
        System.out.print("Found and processed data readers:\n");
        System.out.print(out + "\n");
    }
}

