(ns winkel.api
  (:require [ring.util.response :refer [redirect]]
            [clojure.tools.logging :as log]
            [durable-queue :as q]
            [winkel.gateway.paypal :as paypal]))

(defn dispatch-job [queue payment session params]
  (try
    (q/put! queue :payment {:payment-id (:id payment) :uid (:uid session) :product-id (:id params)})
    (catch Exception e
      (log/error (.getMessage e)))))

(defn payment [{session :session params :params headers :headers :as req} queue]
  (let [payment (paypal/execute (:paymentId params) (:PayerID params))
        payload (case (:state payment)
                  "created" {:message "The transaction was successfully created." :level :success}
                  "approved" (do (dispatch-job queue payment session params)
                               {:message "The transaction was approved." :level :success})
                  "failed" {:message (:failure_reason payment) :level :danger}
                  "error" {:message (str "We've encountered an error of type " (:message payment) ".") :level :danger})]
    (-> (redirect "/")
        (assoc :flash payload))))




(defn payment-cancel [_]
  (log/info "Payment was cancelled")
  (-> (redirect "/")
      (assoc :flash {:message "You've cancelled the payment." :level :warning})))
