(ns winkel.core
  (:require [compojure.core :refer [routes GET POST]]
            [winkel.api :as api]))

(defmulti execute :type)
(defmethod execute :payment [plan] (api/session plan))
(defmethod execute :agreement [plan] (api/billing-agreement plan))
(defmethod execute :default [plan] (api/session plan))

(defn endpoint [{{queue :queue} :queue}]
  (routes
   (GET "/shop/payment" req (api/payment req queue))
   (GET "/shop/payment-cancel" req api/payment-cancel)
   (GET "/winkel/stripe/:id/payment" req (api/payment req queue))
   (GET "/winkel/stripe/:id/payment-cancel" req api/payment-cancel)
   (GET "/winkel/paypal/:id/payment" req (api/payment req queue))
   (GET "/winkel/paypal/:id/payment-cancel" req api/payment-cancel)
   (GET "/winkel/alipay/:id/payment" req (api/payment req queue))
   (GET "/winkel/paypal/:id/agreement" req (api/agreement req queue))
   (GET "/winkel/paypal/:id/agreement-cancel" req api/agreement-cancel)
   (GET "/winkel/stripe/:id/agreement" req (api/agreement req queue))
   (GET "/winkel/stripe/:id/agreement-cancel" req api/agreement-cancel)))

(defn webhook-endpoint [{{queue :queue} :queue}]
  (routes
   (POST "/shop/webhooks" req (api/process-events (assoc req :uri "/api/winkel/paypal/webhooks") queue)) ; just a temporary hack)
   (POST "/winkel/paypal/webhooks" req (api/process-events req queue))
   (POST "/winkel/stripe/webhooks" req (api/process-events req queue))))
