(ns cljs-cursor)


(deftype Cursor [state-atom paths]

  clojure.core/IReset
  (-reset! [this newval]
    (reset! state-atom
            (if (seq paths) (assoc-in @state-atom paths newval)
                newval)))

  clojure.core/ISwap
  (-swap! [this f] (swap! state-atom update-in paths f))
  (-swap! [this f a] (swap! state-atom update-in paths f a))
  (-swap! [this f a b] (swap! state-atom update-in paths f a b))
  (-swap! [this f a b xs] (swap! state-atom update-in paths #(apply f % a b xs)))

  clojure.core/IDeref
  (-deref [this] (get-in @state-atom paths))

  IFn
  (-invoke [this more-paths]
    (Cursor. state-atom (reduce conj paths more-paths)))

  IPrintWithWriter
  (-pr-writer [this writer opts]
    (-write writer (str "#<Cursor: " paths " " @state-atom ">"))))


(defn cursor [state-atom] (Cursor. state-atom []))


;; (defn map-cursor-vec
;;   "map over a cursor to collection, refining as we go"
;;   [f cur]
;;   (map-indexed (fn [ix item]
;;                  (f (cur [ix])))
;;                @cur))

;; (defn map-cursor [f cur]
;;   (map (fn [[k v]]
;;          (f (cur k))
;;          @cur)))

;; (comment
;;   (def cur (cljs-cursor/cursor (atom {:a [1 2 3]})))
;;   (map-cursor (fn [c] @c) (cur [:a]))
;;   )


(comment
  (def s (atom {:a 42}))
  (def c (cursor s))
  (assert (= @c {:a 42}))
  (reset! c {:a 43})
  (assert (= @c {:a 43}))
  (def ca (c [:a]))
  (assert (= @ca 43))
  (reset! ca 44)
  (assert (= @ca 44))


  )
