(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m4906]
  (clojure.core/let
   [bean4905
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/let
    [v4907
     (:use-previous-value
      m4906
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4907 :com.palletops.awaze.client-builder/undef)
     (. bean4905 setUsePreviousValue (clojure.core/boolean v4907))))
   (clojure.core/let
    [v4907
     (:parameter-key m4906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4907 :com.palletops.awaze.client-builder/undef)
     (. bean4905 setParameterKey (clojure.core/str v4907))))
   (clojure.core/let
    [v4907
     (:parameter-value
      m4906
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4907 :com.palletops.awaze.client-builder/undef)
     (. bean4905 setParameterValue (clojure.core/str v4907))))
   bean4905))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m4909]
  (clojure.core/let
   [bean4908 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/let
    [v4910 (:key m4909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4910 :com.palletops.awaze.client-builder/undef)
     (. bean4908 setKey (clojure.core/str v4910))))
   (clojure.core/let
    [v4910 (:value m4909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4910 :com.palletops.awaze.client-builder/undef)
     (. bean4908 setValue (clojure.core/str v4910))))
   bean4908))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ResourceSignalStatus}
resource-signal-status
  [m4912]
  (.
   com.amazonaws.services.cloudformation.model.ResourceSignalStatus
   fromValue
   (clojure.core/name m4912)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest}
continue-update-rollback-request
  [m4915]
  (clojure.core/let
   [bean4914
    (new
     com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest)]
   (clojure.core/let
    [v4916
     (:stack-name m4915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4916 :com.palletops.awaze.client-builder/undef)
     (. bean4914 setStackName (clojure.core/str v4916))))
   bean4914))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest}
describe-change-set-request
  [m4918]
  (clojure.core/let
   [bean4917
    (new
     com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest)]
   (clojure.core/let
    [v4919
     (:next-token m4918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4919 :com.palletops.awaze.client-builder/undef)
     (. bean4917 setNextToken (clojure.core/str v4919))))
   (clojure.core/let
    [v4919
     (:stack-name m4918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4919 :com.palletops.awaze.client-builder/undef)
     (. bean4917 setStackName (clojure.core/str v4919))))
   (clojure.core/let
    [v4919
     (:change-set-name
      m4918
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4919 :com.palletops.awaze.client-builder/undef)
     (. bean4917 setChangeSetName (clojure.core/str v4919))))
   bean4917))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m4921]
  (clojure.core/let
   [bean4920
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/let
    [v4922
     (:stack-name m4921 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4922 :com.palletops.awaze.client-builder/undef)
     (. bean4920 setStackName (clojure.core/str v4922))))
   (clojure.core/let
    [v4922
     (:stack-policy-body
      m4921
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4922 :com.palletops.awaze.client-builder/undef)
     (. bean4920 setStackPolicyBody (clojure.core/str v4922))))
   (clojure.core/let
    [v4922
     (:stack-policy-url
      m4921
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4922 :com.palletops.awaze.client-builder/undef)
     (. bean4920 setStackPolicyURL (clojure.core/str v4922))))
   bean4920))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m4924]
  (clojure.core/let
   [bean4923
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/let
    [v4925
     (:next-token m4924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4925 :com.palletops.awaze.client-builder/undef)
     (. bean4923 setNextToken (clojure.core/str v4925))))
   (clojure.core/let
    [v4925
     (:stack-name m4924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4925 :com.palletops.awaze.client-builder/undef)
     (. bean4923 setStackName (clojure.core/str v4925))))
   bean4923))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m4927]
  (clojure.core/let
   [bean4926
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/let
    [v4928
     (:use-previous-template
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setUsePreviousTemplate (clojure.core/boolean v4928))))
   (clojure.core/let
    [v4928
     (:stack-name m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setStackName (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:notification-arns
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4986] (clojure.core/str arg4986))
 v4928))))
   (clojure.core/let
    [v4928
     (:parameters m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4987] (cloudformation/parameter arg4987))
 v4928))))
   (clojure.core/let
    [v4928
     (:stack-policy-during-update-body
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setStackPolicyDuringUpdateBody
      (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:template-url m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setTemplateURL (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:stack-policy-url
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setStackPolicyURL (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:stack-policy-body
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setStackPolicyBody (clojure.core/str v4928))))
   (clojure.core/let
    [v4928 (:tags m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4988] (cloudformation/tag arg4988))
 v4928))))
   (clojure.core/let
    [v4928
     (:stack-policy-during-update-url
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setStackPolicyDuringUpdateURL
      (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:template-body m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setTemplateBody (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:resource-types m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4989] (clojure.core/str arg4989))
 v4928))))
   (clojure.core/let
    [v4928
     (:capabilities m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (.
      bean4926
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4990] (clojure.core/str arg4990))
 v4928))))
   bean4926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m4930]
  (clojure.core/let
   [bean4929
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/let
    [v4931
     (:template-body m4930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setTemplateBody (clojure.core/str v4931))))
   (clojure.core/let
    [v4931
     (:template-url m4930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setTemplateURL (clojure.core/str v4931))))
   (clojure.core/let
    [v4931
     (:parameters m4930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (.
      bean4929
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4991] (cloudformation/parameter arg4991))
 v4931))))
   bean4929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m4933]
  (clojure.core/let
   [bean4932
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/let
    [v4934
     (:next-token m4933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4934 :com.palletops.awaze.client-builder/undef)
     (. bean4932 setNextToken (clojure.core/str v4934))))
   (clojure.core/let
    [v4934
     (:stack-status-filters
      m4933
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4934 :com.palletops.awaze.client-builder/undef)
     (.
      bean4932
      setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4992] (clojure.core/str arg4992))
 v4934))))
   bean4932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m4936]
  (clojure.core/let
   [bean4935
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/let
    [v4937
     (:next-token m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setNextToken (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:stack-name m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setStackName (clojure.core/str v4937))))
   bean4935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m4939]
  (clojure.core/let
   [bean4938
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/let
    [v4940
     (:stack-name m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setStackName (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:retain-resources
      m4939
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (.
      bean4938
      setRetainResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4993] (clojure.core/str arg4993))
 v4940))))
   bean4938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m4942]
  (clojure.core/let
   [bean4941
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/let
    [v4943
     (:template-body m4942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setTemplateBody (clojure.core/str v4943))))
   (clojure.core/let
    [v4943
     (:template-url m4942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setTemplateURL (clojure.core/str v4943))))
   bean4941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m4945]
  (clojure.core/let
   [bean4944
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/let
    [v4946
     (:stack-name m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setStackName (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:logical-resource-id
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setLogicalResourceId (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:physical-resource-id
      m4945
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setPhysicalResourceId (clojure.core/str v4946))))
   bean4944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m4948]
  (clojure.core/let
   [bean4947
    (new
     com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest)]
   (clojure.core/let
    [v4949
     (:next-token m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setNextToken (clojure.core/str v4949))))
   bean4947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SignalResourceRequest}
signal-resource-request
  [m4951]
  (clojure.core/let
   [bean4950
    (new
     com.amazonaws.services.cloudformation.model.SignalResourceRequest)]
   (clojure.core/let
    [v4952 (:status m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (.
      bean4950
      setStatus
      (cloudformation/resource-signal-status v4952))))
   (clojure.core/let
    [v4952
     (:stack-name m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setStackName (clojure.core/str v4952))))
   (clojure.core/let
    [v4952
     (:unique-id m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setUniqueId (clojure.core/str v4952))))
   (clojure.core/let
    [v4952
     (:logical-resource-id
      m4951
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setLogicalResourceId (clojure.core/str v4952))))
   bean4950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m4954]
  (clojure.core/let
   [bean4953
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/let
    [v4955
     (:stack-name m4954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setStackName (clojure.core/str v4955))))
   bean4953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m4957]
  (clojure.core/let
   [bean4956
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/let
    [v4958
     (:stack-name m4957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4958 :com.palletops.awaze.client-builder/undef)
     (. bean4956 setStackName (clojure.core/str v4958))))
   bean4956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m4960]
  (clojure.core/let
   [bean4959
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/let
    [v4961
     (:stack-name m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setStackName (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:notification-arns
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5018] (clojure.core/str arg5018))
 v4961))))
   (clojure.core/let
    [v4961
     (:parameters m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5019] (cloudformation/parameter arg5019))
 v4961))))
   (clojure.core/let
    [v4961
     (:timeout-in-minutes
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setTimeoutInMinutes (clojure.core/int v4961))))
   (clojure.core/let
    [v4961
     (:disable-rollback
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setDisableRollback (clojure.core/boolean v4961))))
   (clojure.core/let
    [v4961
     (:template-url m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setTemplateURL (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:stack-policy-url
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setStackPolicyURL (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:stack-policy-body
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setStackPolicyBody (clojure.core/str v4961))))
   (clojure.core/let
    [v4961 (:tags m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5020] (cloudformation/tag arg5020))
 v4961))))
   (clojure.core/let
    [v4961
     (:template-body m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setTemplateBody (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:resource-types m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5021] (clojure.core/str arg5021))
 v4961))))
   (clojure.core/let
    [v4961
     (:capabilities m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5022] (clojure.core/str arg5022))
 v4961))))
   (clojure.core/let
    [v4961
     (:on-failure m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setOnFailure (clojure.core/str v4961))))
   bean4959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m4963]
  (clojure.core/let
   [bean4962
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/let
    [v4964
     (:next-token m4963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setNextToken (clojure.core/str v4964))))
   (clojure.core/let
    [v4964
     (:stack-name m4963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setStackName (clojure.core/str v4964))))
   bean4962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m4966]
  (clojure.core/let
   [bean4965
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/let
    [v4967
     (:stack-name m4966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setStackName (clojure.core/str v4967))))
   (clojure.core/let
    [v4967
     (:logical-resource-id
      m4966
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setLogicalResourceId (clojure.core/str v4967))))
   bean4965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListChangeSetsRequest}
list-change-sets-request
  [m4969]
  (clojure.core/let
   [bean4968
    (new
     com.amazonaws.services.cloudformation.model.ListChangeSetsRequest)]
   (clojure.core/let
    [v4970
     (:next-token m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setNextToken (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:stack-name m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setStackName (clojure.core/str v4970))))
   bean4968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m4972]
  (clojure.core/let
   [bean4971
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/let
    [v4973
     (:stack-name m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setStackName (clojure.core/str v4973))))
   bean4971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateChangeSetRequest}
create-change-set-request
  [m4975]
  (clojure.core/let
   [bean4974
    (new
     com.amazonaws.services.cloudformation.model.CreateChangeSetRequest)]
   (clojure.core/let
    [v4976
     (:description m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setDescription (clojure.core/str v4976))))
   (clojure.core/let
    [v4976
     (:use-previous-template
      m4975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setUsePreviousTemplate (clojure.core/boolean v4976))))
   (clojure.core/let
    [v4976
     (:stack-name m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setStackName (clojure.core/str v4976))))
   (clojure.core/let
    [v4976
     (:notification-arns
      m4975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (.
      bean4974
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5023] (clojure.core/str arg5023))
 v4976))))
   (clojure.core/let
    [v4976
     (:parameters m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (.
      bean4974
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5024] (cloudformation/parameter arg5024))
 v4976))))
   (clojure.core/let
    [v4976
     (:client-token m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setClientToken (clojure.core/str v4976))))
   (clojure.core/let
    [v4976
     (:template-url m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setTemplateURL (clojure.core/str v4976))))
   (clojure.core/let
    [v4976 (:tags m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (.
      bean4974
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5025] (cloudformation/tag arg5025))
 v4976))))
   (clojure.core/let
    [v4976
     (:change-set-name
      m4975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setChangeSetName (clojure.core/str v4976))))
   (clojure.core/let
    [v4976
     (:template-body m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setTemplateBody (clojure.core/str v4976))))
   (clojure.core/let
    [v4976
     (:resource-types m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (.
      bean4974
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5026] (clojure.core/str arg5026))
 v4976))))
   (clojure.core/let
    [v4976
     (:capabilities m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (.
      bean4974
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5027] (clojure.core/str arg5027))
 v4976))))
   bean4974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest}
execute-change-set-request
  [m4978]
  (clojure.core/let
   [bean4977
    (new
     com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest)]
   (clojure.core/let
    [v4979
     (:stack-name m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setStackName (clojure.core/str v4979))))
   (clojure.core/let
    [v4979
     (:change-set-name
      m4978
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setChangeSetName (clojure.core/str v4979))))
   bean4977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest}
delete-change-set-request
  [m4981]
  (clojure.core/let
   [bean4980
    (new
     com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest)]
   (clojure.core/let
    [v4982
     (:stack-name m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setStackName (clojure.core/str v4982))))
   (clojure.core/let
    [v4982
     (:change-set-name
      m4981
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setChangeSetName (clojure.core/str v4982))))
   bean4980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest}
get-template-summary-request
  [m4984]
  (clojure.core/let
   [bean4983
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest)]
   (clojure.core/let
    [v4985
     (:stack-name m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setStackName (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:template-body m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setTemplateBody (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:template-url m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setTemplateURL (clojure.core/str v4985))))
   bean4983))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :continue-update-rollback
   [m4994]
   (clojure.core/let
    [credentials4995 (:credentials m4994) args4996 (:args m4994)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client4997
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials4995)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client4997
       continueUpdateRollback
       (cloudformation/continue-update-rollback-request
        (clojure.core/nth args4996 0)))))))
  (clojure.core/defn
   continue-update-rollback-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for continueUpdateRollback"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :continue-update-rollback,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   continue-update-rollback
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call continueUpdateRollback"}
   [credentials4999 & args5000]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5001
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials4999)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5001
      continueUpdateRollback
      (cloudformation/continue-update-rollback-request
       (clojure.core/nth args5000 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-change-set
   [m5002]
   (clojure.core/let
    [credentials5003 (:credentials m5002) args5004 (:args m5002)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5005
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5003)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5005
       describeChangeSet
       (cloudformation/describe-change-set-request
        (clojure.core/nth args5004 0)))))))
  (clojure.core/defn
   describe-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeChangeSet"}
   [credentials5007 & args5008]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5009
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5007)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5009
      describeChangeSet
      (cloudformation/describe-change-set-request
       (clojure.core/nth args5008 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m5010]
   (clojure.core/let
    [credentials5011 (:credentials m5010) args5012 (:args m5010)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5013
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5011)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5013
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args5012 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call setStackPolicy"}
   [credentials5015 & args5016]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5017
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5015)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5017
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args5016 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m5028]
   (clojure.core/let
    [credentials5029 (:credentials m5028) args5030 (:args m5028)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5031
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5029)]
     (clojure.core/case
      (clojure.core/count args5030)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5031
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5031
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args5030 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials5033 & args5034]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5035
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5033)]
    (clojure.core/case
     (clojure.core/count args5034)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5035
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5035
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args5034 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m5036]
   (clojure.core/let
    [credentials5037 (:credentials m5036) args5038 (:args m5036)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5039
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5037)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5039
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args5038 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Call updateStack"}
   [credentials5041 & args5042]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5043
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5041)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5043
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args5042 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m5044]
   (clojure.core/let
    [credentials5045 (:credentials m5044) args5046 (:args m5044)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5047
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5045)]
     (clojure.core/case
      (clojure.core/count args5046)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5047
        estimateTemplateCost))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5047
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args5046 0))))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials5049 & args5050]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5051
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5049)]
    (clojure.core/case
     (clojure.core/count args5050)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5051
       estimateTemplateCost))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5051
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args5050 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m5052]
   (clojure.core/let
    [credentials5053 (:credentials m5052) args5054 (:args m5052)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5055
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5053)]
     (clojure.core/case
      (clojure.core/count args5054)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5055
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5055
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args5054 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStacks, listStacks"}
   [credentials5057 & args5058]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5059
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5057)]
    (clojure.core/case
     (clojure.core/count args5058)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5059
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5059
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args5058 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m5060]
   (clojure.core/let
    [credentials5061 (:credentials m5060) args5062 (:args m5060)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5063
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5061)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5063
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args5062 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-events,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStackEvents"}
   [credentials5065 & args5066]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5067
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5065)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5067
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args5066 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m5068]
   (clojure.core/let
    [credentials5069 (:credentials m5068) args5070 (:args m5068)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5071
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5069)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5071
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args5070 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStack"}
   [credentials5073 & args5074]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5075
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5073)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5075
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args5074 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m5076]
   (clojure.core/let
    [credentials5077 (:credentials m5076) args5078 (:args m5076)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5079
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5077)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5079
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args5078 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call validateTemplate"}
   [credentials5081 & args5082]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5083
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5081)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5083
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args5082 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m5084]
   (clojure.core/let
    [credentials5085 (:credentials m5084) args5086 (:args m5084)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5087
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5085)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5087
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args5086 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResources"}
   [credentials5089 & args5090]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5091
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5089)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5091
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args5090 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-account-limits
   [m5092]
   (clojure.core/let
    [credentials5093 (:credentials m5092) args5094 (:args m5092)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5095
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5093)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5095
       describeAccountLimits
       (cloudformation/describe-account-limits-request
        (clojure.core/nth args5094 0)))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAccountLimits"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAccountLimits"}
   [credentials5097 & args5098]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5099
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5097)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5099
      describeAccountLimits
      (cloudformation/describe-account-limits-request
       (clojure.core/nth args5098 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :signal-resource
   [m5100]
   (clojure.core/let
    [credentials5101 (:credentials m5100) args5102 (:args m5100)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5103
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5101)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5103
       signalResource
       (cloudformation/signal-resource-request
        (clojure.core/nth args5102 0)))))))
  (clojure.core/defn
   signal-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for signalResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :signal-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   signal-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call signalResource"}
   [credentials5105 & args5106]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5107
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5105)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5107
      signalResource
      (cloudformation/signal-resource-request
       (clojure.core/nth args5106 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m5108]
   (clojure.core/let
    [credentials5109 (:credentials m5108) args5110 (:args m5108)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5111
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5109)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5111
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args5110 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTemplate"}
   [credentials5113 & args5114]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5115
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5113)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5115
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args5114 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m5116]
   (clojure.core/let
    [credentials5117 (:credentials m5116) args5118 (:args m5116)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5119
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5117)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5119
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args5118 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStackPolicy"}
   [credentials5121 & args5122]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5123
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5121)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5123
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args5122 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m5124]
   (clojure.core/let
    [credentials5125 (:credentials m5124) args5126 (:args m5124)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5127
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5125)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5127
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args5126 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call createStack"}
   [credentials5129 & args5130]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5131
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5129)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5131
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args5130 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m5132]
   (clojure.core/let
    [credentials5133 (:credentials m5132) args5134 (:args m5132)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5135
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5133)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5135
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args5134 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStackResources"}
   [credentials5137 & args5138]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5139
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5137)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5139
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args5138 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m5140]
   (clojure.core/let
    [credentials5141 (:credentials m5140) args5142 (:args m5140)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5143
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5141)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5143
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args5142 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResource"}
   [credentials5145 & args5146]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5147
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5145)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5147
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args5146 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-change-sets
   [m5148]
   (clojure.core/let
    [credentials5149 (:credentials m5148) args5150 (:args m5148)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5151
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5149)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5151
       listChangeSets
       (cloudformation/list-change-sets-request
        (clojure.core/nth args5150 0)))))))
  (clojure.core/defn
   list-change-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listChangeSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-sets,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-change-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listChangeSets"}
   [credentials5153 & args5154]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5155
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5153)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5155
      listChangeSets
      (cloudformation/list-change-sets-request
       (clojure.core/nth args5154 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m5156]
   (clojure.core/let
    [credentials5157 (:credentials m5156) args5158 (:args m5156)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5159
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5157)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5159
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args5158 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials5161 & args5162]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5163
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5161)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5163
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args5162 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-change-set
   [m5164]
   (clojure.core/let
    [credentials5165 (:credentials m5164) args5166 (:args m5164)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5167
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5165)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5167
       createChangeSet
       (cloudformation/create-change-set-request
        (clojure.core/nth args5166 0)))))))
  (clojure.core/defn
   create-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Generate map for createChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-change-set
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Call createChangeSet"}
   [credentials5169 & args5170]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5171
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5169)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5171
      createChangeSet
      (cloudformation/create-change-set-request
       (clojure.core/nth args5170 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :execute-change-set
   [m5172]
   (clojure.core/let
    [credentials5173 (:credentials m5172) args5174 (:args m5172)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5175
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5173)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5175
       executeChangeSet
       (cloudformation/execute-change-set-request
        (clojure.core/nth args5174 0)))))))
  (clojure.core/defn
   execute-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for executeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   execute-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call executeChangeSet"}
   [credentials5177 & args5178]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5179
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5177)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5179
      executeChangeSet
      (cloudformation/execute-change-set-request
       (clojure.core/nth args5178 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-change-set
   [m5180]
   (clojure.core/let
    [credentials5181 (:credentials m5180) args5182 (:args m5180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5183
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5181)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5183
       deleteChangeSet
       (cloudformation/delete-change-set-request
        (clojure.core/nth args5182 0)))))))
  (clojure.core/defn
   delete-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteChangeSet"}
   [credentials5185 & args5186]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5187
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5185)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5187
      deleteChangeSet
      (cloudformation/delete-change-set-request
       (clojure.core/nth args5186 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template-summary
   [m5188]
   (clojure.core/let
    [credentials5189 (:credentials m5188) args5190 (:args m5188)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5191
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5189)]
     (clojure.core/case
      (clojure.core/count args5190)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5191
        getTemplateSummary))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5191
        getTemplateSummary
        (cloudformation/get-template-summary-request
         (clojure.core/nth args5190 0))))))))
  (clojure.core/defn
   get-template-summary-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for getTemplateSummary, getTemplateSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template-summary
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call getTemplateSummary, getTemplateSummary"}
   [credentials5193 & args5194]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5195
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5193)]
    (clojure.core/case
     (clojure.core/count args5194)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5195
       getTemplateSummary))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5195
       getTemplateSummary
       (cloudformation/get-template-summary-request
        (clojure.core/nth args5194 0)))))))))
