(ns
 com.palletops.awaze.cloudwatch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudwatch :as cloudwatch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudwatch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudwatch.AmazonCloudWatchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Dimension}
dimension
  [m10534]
  (clojure.core/let
   [bean10533 (new com.amazonaws.services.cloudwatch.model.Dimension)]
   (clojure.core/let
    [v10535 (:name m10534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10535 :com.palletops.awaze.client-builder/undef)
     (. bean10533 setName (clojure.core/str v10535))))
   (clojure.core/let
    [v10535 (:value m10534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10535 :com.palletops.awaze.client-builder/undef)
     (. bean10533 setValue (clojure.core/str v10535))))
   bean10533))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StandardUnit}
standard-unit
  [m10537]
  (.
   com.amazonaws.services.cloudwatch.model.StandardUnit
   fromValue
   (clojure.core/name m10537)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StatisticSet}
statistic-set
  [m10540]
  (clojure.core/let
   [bean10539
    (new com.amazonaws.services.cloudwatch.model.StatisticSet)]
   (clojure.core/let
    [v10541
     (:sample-count m10540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10541 :com.palletops.awaze.client-builder/undef)
     (. bean10539 setSampleCount (clojure.core/double v10541))))
   (clojure.core/let
    [v10541 (:sum m10540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10541 :com.palletops.awaze.client-builder/undef)
     (. bean10539 setSum (clojure.core/double v10541))))
   (clojure.core/let
    [v10541
     (:minimum m10540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10541 :com.palletops.awaze.client-builder/undef)
     (. bean10539 setMinimum (clojure.core/double v10541))))
   (clojure.core/let
    [v10541
     (:maximum m10540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10541 :com.palletops.awaze.client-builder/undef)
     (. bean10539 setMaximum (clojure.core/double v10541))))
   bean10539))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.StateValue}
state-value
  [m10543]
  (.
   com.amazonaws.services.cloudwatch.model.StateValue
   fromValue
   (clojure.core/name m10543)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.MetricDatum}
metric-datum
  [m10546]
  (clojure.core/let
   [bean10545
    (new com.amazonaws.services.cloudwatch.model.MetricDatum)]
   (clojure.core/let
    [v10547
     (:metric-name m10546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10547 :com.palletops.awaze.client-builder/undef)
     (. bean10545 setMetricName (clojure.core/str v10547))))
   (clojure.core/let
    [v10547
     (:dimensions m10546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10547 :com.palletops.awaze.client-builder/undef)
     (.
      bean10545
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10587] (cloudwatch/dimension arg10587))
 v10547))))
   (clojure.core/let
    [v10547 (:unit m10546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10547 :com.palletops.awaze.client-builder/undef)
     (. bean10545 setUnit (cloudwatch/standard-unit v10547))))
   (clojure.core/let
    [v10547
     (:statistic-values
      m10546
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10547 :com.palletops.awaze.client-builder/undef)
     (.
      bean10545
      setStatisticValues
      (cloudwatch/statistic-set v10547))))
   (clojure.core/let
    [v10547 (:value m10546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10547 :com.palletops.awaze.client-builder/undef)
     (. bean10545 setValue (clojure.core/double v10547))))
   (clojure.core/let
    [v10547
     (:timestamp m10546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10547 :com.palletops.awaze.client-builder/undef)
     (.
      bean10545
      setTimestamp
      (com.palletops.awaze.common/to-date v10547))))
   bean10545))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.Statistic}
statistic
  [m10549]
  (.
   com.amazonaws.services.cloudwatch.model.Statistic
   fromValue
   (clojure.core/name m10549)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DimensionFilter}
dimension-filter
  [m10552]
  (clojure.core/let
   [bean10551
    (new com.amazonaws.services.cloudwatch.model.DimensionFilter)]
   (clojure.core/let
    [v10553 (:name m10552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10553 :com.palletops.awaze.client-builder/undef)
     (. bean10551 setName (clojure.core/str v10553))))
   (clojure.core/let
    [v10553 (:value m10552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10553 :com.palletops.awaze.client-builder/undef)
     (. bean10551 setValue (clojure.core/str v10553))))
   bean10551))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest}
delete-alarms-request
  [m10555]
  (clojure.core/let
   [bean10554
    (new com.amazonaws.services.cloudwatch.model.DeleteAlarmsRequest)]
   (clojure.core/let
    [v10556
     (:alarm-names m10555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10556 :com.palletops.awaze.client-builder/undef)
     (.
      bean10554
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10588] (clojure.core/str arg10588))
 v10556))))
   bean10554))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest}
enable-alarm-actions-request
  [m10558]
  (clojure.core/let
   [bean10557
    (new
     com.amazonaws.services.cloudwatch.model.EnableAlarmActionsRequest)]
   (clojure.core/let
    [v10559
     (:alarm-names m10558 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10559 :com.palletops.awaze.client-builder/undef)
     (.
      bean10557
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10589] (clojure.core/str arg10589))
 v10559))))
   bean10557))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest}
disable-alarm-actions-request
  [m10561]
  (clojure.core/let
   [bean10560
    (new
     com.amazonaws.services.cloudwatch.model.DisableAlarmActionsRequest)]
   (clojure.core/let
    [v10562
     (:alarm-names m10561 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10562 :com.palletops.awaze.client-builder/undef)
     (.
      bean10560
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10590] (clojure.core/str arg10590))
 v10562))))
   bean10560))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest}
set-alarm-state-request
  [m10564]
  (clojure.core/let
   [bean10563
    (new com.amazonaws.services.cloudwatch.model.SetAlarmStateRequest)]
   (clojure.core/let
    [v10565
     (:state-reason m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setStateReason (clojure.core/str v10565))))
   (clojure.core/let
    [v10565
     (:state-reason-data
      m10564
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setStateReasonData (clojure.core/str v10565))))
   (clojure.core/let
    [v10565
     (:alarm-name m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setAlarmName (clojure.core/str v10565))))
   (clojure.core/let
    [v10565
     (:state-value m10564 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10565 :com.palletops.awaze.client-builder/undef)
     (. bean10563 setStateValue (cloudwatch/state-value v10565))))
   bean10563))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest}
describe-alarms-for-metric-request
  [m10567]
  (clojure.core/let
   [bean10566
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsForMetricRequest)]
   (clojure.core/let
    [v10568
     (:namespace m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (. bean10566 setNamespace (clojure.core/str v10568))))
   (clojure.core/let
    [v10568
     (:statistic m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (. bean10566 setStatistic (clojure.core/str v10568))))
   (clojure.core/let
    [v10568
     (:metric-name m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (. bean10566 setMetricName (clojure.core/str v10568))))
   (clojure.core/let
    [v10568
     (:dimensions m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (.
      bean10566
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10591] (cloudwatch/dimension arg10591))
 v10568))))
   (clojure.core/let
    [v10568
     (:period m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (. bean10566 setPeriod (clojure.core/int v10568))))
   (clojure.core/let
    [v10568 (:unit m10567 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10568 :com.palletops.awaze.client-builder/undef)
     (. bean10566 setUnit (cloudwatch/standard-unit v10568))))
   bean10566))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricDataRequest}
put-metric-data-request
  [m10570]
  (clojure.core/let
   [bean10569
    (new com.amazonaws.services.cloudwatch.model.PutMetricDataRequest)]
   (clojure.core/let
    [v10571
     (:namespace m10570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10571 :com.palletops.awaze.client-builder/undef)
     (. bean10569 setNamespace (clojure.core/str v10571))))
   (clojure.core/let
    [v10571
     (:metric-data m10570 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10571 :com.palletops.awaze.client-builder/undef)
     (.
      bean10569
      setMetricData
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10592] (cloudwatch/metric-datum arg10592))
 v10571))))
   bean10569))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest}
describe-alarms-request
  [m10573]
  (clojure.core/let
   [bean10572
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest)]
   (clojure.core/let
    [v10574
     (:alarm-name-prefix
      m10573
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setAlarmNamePrefix (clojure.core/str v10574))))
   (clojure.core/let
    [v10574
     (:state-value m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setStateValue (cloudwatch/state-value v10574))))
   (clojure.core/let
    [v10574
     (:action-prefix m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setActionPrefix (clojure.core/str v10574))))
   (clojure.core/let
    [v10574
     (:next-token m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setNextToken (clojure.core/str v10574))))
   (clojure.core/let
    [v10574
     (:alarm-names m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (.
      bean10572
      setAlarmNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10593] (clojure.core/str arg10593))
 v10574))))
   (clojure.core/let
    [v10574
     (:max-records m10573 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10574 :com.palletops.awaze.client-builder/undef)
     (. bean10572 setMaxRecords (clojure.core/int v10574))))
   bean10572))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest}
describe-alarm-history-request
  [m10576]
  (clojure.core/let
   [bean10575
    (new
     com.amazonaws.services.cloudwatch.model.DescribeAlarmHistoryRequest)]
   (clojure.core/let
    [v10577
     (:alarm-name m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setAlarmName (clojure.core/str v10577))))
   (clojure.core/let
    [v10577
     (:history-item-type
      m10576
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setHistoryItemType (clojure.core/str v10577))))
   (clojure.core/let
    [v10577
     (:next-token m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setNextToken (clojure.core/str v10577))))
   (clojure.core/let
    [v10577
     (:end-date m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (.
      bean10575
      setEndDate
      (com.palletops.awaze.common/to-date v10577))))
   (clojure.core/let
    [v10577
     (:start-date m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (.
      bean10575
      setStartDate
      (com.palletops.awaze.common/to-date v10577))))
   (clojure.core/let
    [v10577
     (:max-records m10576 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10577 :com.palletops.awaze.client-builder/undef)
     (. bean10575 setMaxRecords (clojure.core/int v10577))))
   bean10575))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest}
put-metric-alarm-request
  [m10579]
  (clojure.core/let
   [bean10578
    (new
     com.amazonaws.services.cloudwatch.model.PutMetricAlarmRequest)]
   (clojure.core/let
    [v10580
     (:alarm-name m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setAlarmName (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:alarm-description
      m10579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setAlarmDescription (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:okactions m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (.
      bean10578
      setOKActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10682] (clojure.core/str arg10682))
 v10580))))
   (clojure.core/let
    [v10580 (:unit m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setUnit (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:metric-name m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setMetricName (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:dimensions m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (.
      bean10578
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10683] (cloudwatch/dimension arg10683))
 v10580))))
   (clojure.core/let
    [v10580
     (:evaluation-periods
      m10579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setEvaluationPeriods (clojure.core/int v10580))))
   (clojure.core/let
    [v10580
     (:namespace m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setNamespace (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:period m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setPeriod (clojure.core/int v10580))))
   (clojure.core/let
    [v10580
     (:comparison-operator
      m10579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setComparisonOperator (clojure.core/str v10580))))
   (clojure.core/let
    [v10580
     (:actions-enabled
      m10579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setActionsEnabled (clojure.core/boolean v10580))))
   (clojure.core/let
    [v10580
     (:alarm-actions m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (.
      bean10578
      setAlarmActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10684] (clojure.core/str arg10684))
 v10580))))
   (clojure.core/let
    [v10580
     (:insufficient-data-actions
      m10579
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (.
      bean10578
      setInsufficientDataActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10685] (clojure.core/str arg10685))
 v10580))))
   (clojure.core/let
    [v10580
     (:threshold m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setThreshold (clojure.core/double v10580))))
   (clojure.core/let
    [v10580
     (:statistic m10579 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10580 :com.palletops.awaze.client-builder/undef)
     (. bean10578 setStatistic (cloudwatch/statistic v10580))))
   bean10578))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest}
get-metric-statistics-request
  [m10582]
  (clojure.core/let
   [bean10581
    (new
     com.amazonaws.services.cloudwatch.model.GetMetricStatisticsRequest)]
   (clojure.core/let
    [v10583
     (:namespace m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (. bean10581 setNamespace (clojure.core/str v10583))))
   (clojure.core/let
    [v10583
     (:statistics m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (.
      bean10581
      setStatistics
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10686] (clojure.core/str arg10686))
 v10583))))
   (clojure.core/let
    [v10583
     (:metric-name m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (. bean10581 setMetricName (clojure.core/str v10583))))
   (clojure.core/let
    [v10583
     (:dimensions m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (.
      bean10581
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10687] (cloudwatch/dimension arg10687))
 v10583))))
   (clojure.core/let
    [v10583
     (:period m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (. bean10581 setPeriod (clojure.core/int v10583))))
   (clojure.core/let
    [v10583 (:unit m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (. bean10581 setUnit (clojure.core/str v10583))))
   (clojure.core/let
    [v10583
     (:end-time m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (.
      bean10581
      setEndTime
      (com.palletops.awaze.common/to-date v10583))))
   (clojure.core/let
    [v10583
     (:start-time m10582 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10583 :com.palletops.awaze.client-builder/undef)
     (.
      bean10581
      setStartTime
      (com.palletops.awaze.common/to-date v10583))))
   bean10581))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudwatch.model.ListMetricsRequest}
list-metrics-request
  [m10585]
  (clojure.core/let
   [bean10584
    (new com.amazonaws.services.cloudwatch.model.ListMetricsRequest)]
   (clojure.core/let
    [v10586
     (:namespace m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setNamespace (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:metric-name m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setMetricName (clojure.core/str v10586))))
   (clojure.core/let
    [v10586
     (:dimensions m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (.
      bean10584
      setDimensions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10688] (cloudwatch/dimension-filter arg10688))
 v10586))))
   (clojure.core/let
    [v10586
     (:next-token m10585 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10586 :com.palletops.awaze.client-builder/undef)
     (. bean10584 setNextToken (clojure.core/str v10586))))
   bean10584))
 (clojure.core/defmulti
  cloudwatch
  (clojure.core/fn cloudwatch [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudwatch
   :delete-alarms
   [m10594]
   (clojure.core/let
    [credentials10595 (:credentials m10594) args10596 (:args m10594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10597
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10595)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10597
       deleteAlarms
       (cloudwatch/delete-alarms-request
        (clojure.core/nth args10596 0)))))))
  (clojure.core/defn
   delete-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteAlarms"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   delete-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteAlarms"}
   [credentials10599 & args10600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10601
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10599)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10601
      deleteAlarms
      (cloudwatch/delete-alarms-request
       (clojure.core/nth args10600 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :enable-alarm-actions
   [m10602]
   (clojure.core/let
    [credentials10603 (:credentials m10602) args10604 (:args m10602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10605
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10603)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10605
       enableAlarmActions
       (cloudwatch/enable-alarm-actions-request
        (clojure.core/nth args10604 0)))))))
  (clojure.core/defn
   enable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   enable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAlarmActions"}
   [credentials10607 & args10608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10609
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10607)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10609
      enableAlarmActions
      (cloudwatch/enable-alarm-actions-request
       (clojure.core/nth args10608 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :disable-alarm-actions
   [m10610]
   (clojure.core/let
    [credentials10611 (:credentials m10610) args10612 (:args m10610)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10613
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10611)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10613
       disableAlarmActions
       (cloudwatch/disable-alarm-actions-request
        (clojure.core/nth args10612 0)))))))
  (clojure.core/defn
   disable-alarm-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAlarmActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-alarm-actions,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   disable-alarm-actions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         alarm-names
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAlarmActions"}
   [credentials10615 & args10616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10617
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10615)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10617
      disableAlarmActions
      (cloudwatch/disable-alarm-actions-request
       (clojure.core/nth args10616 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :set-alarm-state
   [m10618]
   (clojure.core/let
    [credentials10619 (:credentials m10618) args10620 (:args m10618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10621
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10621
       setAlarmState
       (cloudwatch/set-alarm-state-request
        (clojure.core/nth args10620 0)))))))
  (clojure.core/defn
   set-alarm-state-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Generate map for setAlarmState"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-alarm-state,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   set-alarm-state
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         sdk-request-timeout
                         state-value
                         custom-query-parameters
                         state-reason
                         read-limit
                         general-progress-listener
                         clone-source
                         state-reason-data
                         clone-root]}]]),
    :doc "Call setAlarmState"}
   [credentials10623 & args10624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10625
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10625
      setAlarmState
      (cloudwatch/set-alarm-state-request
       (clojure.core/nth args10624 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms-for-metric
   [m10626]
   (clojure.core/let
    [credentials10627 (:credentials m10626) args10628 (:args m10626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10629
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10627)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10629
       describeAlarmsForMetric
       (cloudwatch/describe-alarms-for-metric-request
        (clojure.core/nth args10628 0)))))))
  (clojure.core/defn
   describe-alarms-for-metric-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for describeAlarmsForMetric"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms-for-metric,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms-for-metric
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call describeAlarmsForMetric"}
   [credentials10631 & args10632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10633
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10631)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10633
      describeAlarmsForMetric
      (cloudwatch/describe-alarms-for-metric-request
       (clojure.core/nth args10632 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-data
   [m10634]
   (clojure.core/let
    [credentials10635 (:credentials m10634) args10636 (:args m10634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10637
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10637
       putMetricData
       (cloudwatch/put-metric-data-request
        (clojure.core/nth args10636 0)))))))
  (clojure.core/defn
   put-metric-data-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricData"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-data,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-data
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         metric-data
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricData"}
   [credentials10639 & args10640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10641
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10639)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10641
      putMetricData
      (cloudwatch/put-metric-data-request
       (clojure.core/nth args10640 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarms
   [m10642]
   (clojure.core/let
    [credentials10643 (:credentials m10642) args10644 (:args m10642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10645
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10643)]
     (clojure.core/case
      (clojure.core/count args10644)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10645
        describeAlarms
        (cloudwatch/describe-alarms-request
         (clojure.core/nth args10644 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10645
        describeAlarms))))))
  (clojure.core/defn
   describe-alarms-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarms, describeAlarms"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarms,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarms
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         alarm-name-prefix
                         state-value
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         action-prefix
                         max-records
                         alarm-names
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarms, describeAlarms"}
   [credentials10647 & args10648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10649
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10647)]
    (clojure.core/case
     (clojure.core/count args10648)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10649
       describeAlarms
       (cloudwatch/describe-alarms-request
        (clojure.core/nth args10648 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10649
       describeAlarms))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :describe-alarm-history
   [m10650]
   (clojure.core/let
    [credentials10651 (:credentials m10650) args10652 (:args m10650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10653
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10651)]
     (clojure.core/case
      (clojure.core/count args10652)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10653
        describeAlarmHistory
        (cloudwatch/describe-alarm-history-request
         (clojure.core/nth args10652 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10653
        describeAlarmHistory))))))
  (clojure.core/defn
   describe-alarm-history-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeAlarmHistory, describeAlarmHistory"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-alarm-history,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   describe-alarm-history
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         alarm-name
                         end-date
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         history-item-type
                         max-records
                         clone-source
                         start-date
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeAlarmHistory, describeAlarmHistory"}
   [credentials10655 & args10656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10657
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10655)]
    (clojure.core/case
     (clojure.core/count args10656)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10657
       describeAlarmHistory
       (cloudwatch/describe-alarm-history-request
        (clojure.core/nth args10656 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10657
       describeAlarmHistory))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :put-metric-alarm
   [m10658]
   (clojure.core/let
    [credentials10659 (:credentials m10658) args10660 (:args m10658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10661
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10659)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10661
       putMetricAlarm
       (cloudwatch/put-metric-alarm-request
        (clojure.core/nth args10660 0)))))))
  (clojure.core/defn
   put-metric-alarm-map
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Generate map for putMetricAlarm"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-metric-alarm,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   put-metric-alarm
   {:arglists (quote
               [[credentials
                 {:keys [evaluation-periods
                         custom-request-headers
                         statistic
                         sdk-client-execution-timeout
                         alarm-name
                         actions-enabled
                         unit
                         sdk-request-timeout
                         insufficient-data-actions
                         alarm-actions
                         metric-name
                         custom-query-parameters
                         comparison-operator
                         threshold
                         dimensions
                         alarm-description
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         okactions
                         namespace
                         clone-root]}]]),
    :doc "Call putMetricAlarm"}
   [credentials10663 & args10664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10665
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10663)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10665
      putMetricAlarm
      (cloudwatch/put-metric-alarm-request
       (clojure.core/nth args10664 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :get-metric-statistics
   [m10666]
   (clojure.core/let
    [credentials10667 (:credentials m10666) args10668 (:args m10666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10669
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10667)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10669
       getMetricStatistics
       (cloudwatch/get-metric-statistics-request
        (clojure.core/nth args10668 0)))))))
  (clojure.core/defn
   get-metric-statistics-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Generate map for getMetricStatistics"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-metric-statistics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   get-metric-statistics
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unit
                         sdk-request-timeout
                         metric-name
                         start-time
                         custom-query-parameters
                         end-time
                         dimensions
                         statistics
                         read-limit
                         general-progress-listener
                         period
                         clone-source
                         namespace
                         clone-root]}]]),
    :doc "Call getMetricStatistics"}
   [credentials10671 & args10672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10673
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10671)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10673
      getMetricStatistics
      (cloudwatch/get-metric-statistics-request
       (clojure.core/nth args10672 0)))))))
 (do
  (clojure.core/defmethod
   cloudwatch
   :list-metrics
   [m10674]
   (clojure.core/let
    [credentials10675 (:credentials m10674) args10676 (:args m10674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
      client10677
      (com.palletops.awaze.common/aws-client
       :cloudwatch
       credentials10675)]
     (clojure.core/case
      (clojure.core/count args10676)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10677
        listMetrics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10677
        listMetrics
        (cloudwatch/list-metrics-request
         (clojure.core/nth args10676 0))))))))
  (clojure.core/defn
   list-metrics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listMetrics, listMetrics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-metrics,
     :credentials credentials__1842__auto__,
     :client :cloudwatch}))
  (clojure.core/defn
   list-metrics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         metric-name
                         custom-query-parameters
                         dimensions
                         read-limit
                         general-progress-listener
                         clone-source
                         namespace
                         clone-root
                         next-token]}]]),
    :doc "Call listMetrics, listMetrics"}
   [credentials10679 & args10680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
     client10681
     (com.palletops.awaze.common/aws-client
      :cloudwatch
      credentials10679)]
    (clojure.core/case
     (clojure.core/count args10680)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10681
       listMetrics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudwatch.AmazonCloudWatchClient}
client10681
       listMetrics
       (cloudwatch/list-metrics-request
        (clojure.core/nth args10680 0)))))))))
