(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.OperatorType}
operator-type
  [m7601]
  (.
   com.amazonaws.services.datapipeline.model.OperatorType
   fromValue
   (clojure.core/name m7601)))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m7604]
  (clojure.core/let
   [bean7603 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/let
    [v7605 (:values m7604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7605 :com.palletops.awaze.client-builder/undef)
     (.
      bean7603
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7693] (clojure.core/str arg7693))
 v7605))))
   (clojure.core/let
    [v7605 (:type m7604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7605 :com.palletops.awaze.client-builder/undef)
     (. bean7603 setType (datapipeline/operator-type v7605))))
   bean7603))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m7607]
  (clojure.core/let
   [bean7606 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/let
    [v7608
     (:ref-value m7607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7608 :com.palletops.awaze.client-builder/undef)
     (. bean7606 setRefValue (clojure.core/str v7608))))
   (clojure.core/let
    [v7608
     (:string-value m7607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7608 :com.palletops.awaze.client-builder/undef)
     (. bean7606 setStringValue (clojure.core/str v7608))))
   (clojure.core/let
    [v7608 (:key m7607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7608 :com.palletops.awaze.client-builder/undef)
     (. bean7606 setKey (clojure.core/str v7608))))
   bean7606))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterAttribute}
parameter-attribute
  [m7610]
  (clojure.core/let
   [bean7609
    (new com.amazonaws.services.datapipeline.model.ParameterAttribute)]
   (clojure.core/let
    [v7611
     (:string-value m7610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7611 :com.palletops.awaze.client-builder/undef)
     (. bean7609 setStringValue (clojure.core/str v7611))))
   (clojure.core/let
    [v7611 (:key m7610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7611 :com.palletops.awaze.client-builder/undef)
     (. bean7609 setKey (clojure.core/str v7611))))
   bean7609))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m7613]
  (clojure.core/let
   [bean7612 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/let
    [v7614
     (:field-name m7613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7614 :com.palletops.awaze.client-builder/undef)
     (. bean7612 setFieldName (clojure.core/str v7614))))
   (clojure.core/let
    [v7614
     (:operator m7613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7614 :com.palletops.awaze.client-builder/undef)
     (. bean7612 setOperator (datapipeline/operator v7614))))
   bean7612))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterValue}
parameter-value
  [m7616]
  (clojure.core/let
   [bean7615
    (new com.amazonaws.services.datapipeline.model.ParameterValue)]
   (clojure.core/let
    [v7617
     (:string-value m7616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7617 :com.palletops.awaze.client-builder/undef)
     (. bean7615 setStringValue (clojure.core/str v7617))))
   (clojure.core/let
    [v7617 (:id m7616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7617 :com.palletops.awaze.client-builder/undef)
     (. bean7615 setId (clojure.core/str v7617))))
   bean7615))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m7619]
  (clojure.core/let
   [bean7618
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/let
    [v7620 (:fields m7619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7620 :com.palletops.awaze.client-builder/undef)
     (.
      bean7618
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7694] (datapipeline/field arg7694))
 v7620))))
   (clojure.core/let
    [v7620 (:id m7619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7620 :com.palletops.awaze.client-builder/undef)
     (. bean7618 setId (clojure.core/str v7620))))
   (clojure.core/let
    [v7620 (:name m7619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7620 :com.palletops.awaze.client-builder/undef)
     (. bean7618 setName (clojure.core/str v7620))))
   bean7618))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterObject}
parameter-object
  [m7622]
  (clojure.core/let
   [bean7621
    (new com.amazonaws.services.datapipeline.model.ParameterObject)]
   (clojure.core/let
    [v7623
     (:attributes m7622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7623 :com.palletops.awaze.client-builder/undef)
     (.
      bean7621
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg7695]
  (datapipeline/parameter-attribute arg7695))
 v7623))))
   (clojure.core/let
    [v7623 (:id m7622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7623 :com.palletops.awaze.client-builder/undef)
     (. bean7621 setId (clojure.core/str v7623))))
   bean7621))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m7625]
  (clojure.core/let
   [bean7624
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/let
    [v7626
     (:document m7625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7626 :com.palletops.awaze.client-builder/undef)
     (. bean7624 setDocument (clojure.core/str v7626))))
   (clojure.core/let
    [v7626
     (:signature m7625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7626 :com.palletops.awaze.client-builder/undef)
     (. bean7624 setSignature (clojure.core/str v7626))))
   bean7624))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Tag}
tag
  [m7628]
  (clojure.core/let
   [bean7627 (new com.amazonaws.services.datapipeline.model.Tag)]
   (clojure.core/let
    [v7629 (:key m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (. bean7627 setKey (clojure.core/str v7629))))
   (clojure.core/let
    [v7629 (:value m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (. bean7627 setValue (clojure.core/str v7629))))
   bean7627))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m7631]
  (clojure.core/let
   [bean7630 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/let
    [v7632
     (:selectors m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (.
      bean7630
      setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7696] (datapipeline/selector arg7696))
 v7632))))
   bean7630))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.TaskStatus}
task-status
  [m7634]
  (.
   com.amazonaws.services.datapipeline.model.TaskStatus
   fromValue
   (clojure.core/name m7634)))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m7637]
  (clojure.core/let
   [bean7636
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/let
    [v7638 (:version m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setVersion (clojure.core/str v7638))))
   (clojure.core/let
    [v7638
     (:pipeline-id m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setPipelineId (clojure.core/str v7638))))
   bean7636))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m7640]
  (clojure.core/let
   [bean7639
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/let
    [v7641
     (:pipeline-id m7640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (. bean7639 setPipelineId (clojure.core/str v7641))))
   (clojure.core/let
    [v7641
     (:parameter-values
      m7640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (.
      bean7639
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7697] (datapipeline/parameter-value arg7697))
 v7641))))
   (clojure.core/let
    [v7641
     (:pipeline-objects
      m7640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (.
      bean7639
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7698] (datapipeline/pipeline-object arg7698))
 v7641))))
   (clojure.core/let
    [v7641
     (:parameter-objects
      m7640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (.
      bean7639
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7699] (datapipeline/parameter-object arg7699))
 v7641))))
   bean7639))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m7643]
  (clojure.core/let
   [bean7642
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/let
    [v7644 (:task-id m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (. bean7642 setTaskId (clojure.core/str v7644))))
   (clojure.core/let
    [v7644 (:fields m7643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7644 :com.palletops.awaze.client-builder/undef)
     (.
      bean7642
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7700] (datapipeline/field arg7700))
 v7644))))
   bean7642))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.RemoveTagsRequest}
remove-tags-request
  [m7646]
  (clojure.core/let
   [bean7645
    (new com.amazonaws.services.datapipeline.model.RemoveTagsRequest)]
   (clojure.core/let
    [v7647
     (:pipeline-id m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (. bean7645 setPipelineId (clojure.core/str v7647))))
   (clojure.core/let
    [v7647
     (:tag-keys m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (.
      bean7645
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7701] (clojure.core/str arg7701))
 v7647))))
   bean7645))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m7649]
  (clojure.core/let
   [bean7648
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/let
    [v7650
     (:pipeline-ids m7649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (.
      bean7648
      setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7702] (clojure.core/str arg7702))
 v7650))))
   bean7648))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m7652]
  (clojure.core/let
   [bean7651
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/let
    [v7653
     (:instance-identity
      m7652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (.
      bean7651
      setInstanceIdentity
      (datapipeline/instance-identity v7653))))
   (clojure.core/let
    [v7653
     (:worker-group m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setWorkerGroup (clojure.core/str v7653))))
   (clojure.core/let
    [v7653
     (:hostname m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setHostname (clojure.core/str v7653))))
   bean7651))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.AddTagsRequest}
add-tags-request
  [m7655]
  (clojure.core/let
   [bean7654
    (new com.amazonaws.services.datapipeline.model.AddTagsRequest)]
   (clojure.core/let
    [v7656
     (:pipeline-id m7655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7656 :com.palletops.awaze.client-builder/undef)
     (. bean7654 setPipelineId (clojure.core/str v7656))))
   (clojure.core/let
    [v7656 (:tags m7655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7656 :com.palletops.awaze.client-builder/undef)
     (.
      bean7654
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7703] (datapipeline/tag arg7703))
 v7656))))
   bean7654))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m7658]
  (clojure.core/let
   [bean7657
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/let
    [v7659 (:limit m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setLimit (clojure.core/int v7659))))
   (clojure.core/let
    [v7659 (:marker m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setMarker (clojure.core/str v7659))))
   (clojure.core/let
    [v7659
     (:pipeline-id m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setPipelineId (clojure.core/str v7659))))
   (clojure.core/let
    [v7659 (:query m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setQuery (datapipeline/query v7659))))
   (clojure.core/let
    [v7659 (:sphere m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (. bean7657 setSphere (clojure.core/str v7659))))
   bean7657))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m7661]
  (clojure.core/let
   [bean7660
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/let
    [v7662 (:marker m7661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (. bean7660 setMarker (clojure.core/str v7662))))
   bean7660))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m7664]
  (clojure.core/let
   [bean7663
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/let
    [v7665
     (:taskrunner-id m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (. bean7663 setTaskrunnerId (clojure.core/str v7665))))
   (clojure.core/let
    [v7665
     (:worker-group m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (. bean7663 setWorkerGroup (clojure.core/str v7665))))
   (clojure.core/let
    [v7665
     (:hostname m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (. bean7663 setHostname (clojure.core/str v7665))))
   bean7663))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m7667]
  (clojure.core/let
   [bean7666
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/let
    [v7668
     (:error-message m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setErrorMessage (clojure.core/str v7668))))
   (clojure.core/let
    [v7668
     (:error-stack-trace
      m7667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setErrorStackTrace (clojure.core/str v7668))))
   (clojure.core/let
    [v7668
     (:error-id m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setErrorId (clojure.core/str v7668))))
   (clojure.core/let
    [v7668 (:task-id m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setTaskId (clojure.core/str v7668))))
   (clojure.core/let
    [v7668
     (:task-status m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setTaskStatus (datapipeline/task-status v7668))))
   bean7666))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m7670]
  (clojure.core/let
   [bean7669
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/let
    [v7671
     (:description m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (. bean7669 setDescription (clojure.core/str v7671))))
   (clojure.core/let
    [v7671 (:tags m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (.
      bean7669
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7704] (datapipeline/tag arg7704))
 v7671))))
   (clojure.core/let
    [v7671
     (:unique-id m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (. bean7669 setUniqueId (clojure.core/str v7671))))
   (clojure.core/let
    [v7671 (:name m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (. bean7669 setName (clojure.core/str v7671))))
   bean7669))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m7673]
  (clojure.core/let
   [bean7672
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/let
    [v7674
     (:pipeline-id m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (. bean7672 setPipelineId (clojure.core/str v7674))))
   bean7672))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m7676]
  (clojure.core/let
   [bean7675
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/let
    [v7677
     (:pipeline-id m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setPipelineId (clojure.core/str v7677))))
   (clojure.core/let
    [v7677
     (:parameter-values
      m7676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (.
      bean7675
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7705] (datapipeline/parameter-value arg7705))
 v7677))))
   (clojure.core/let
    [v7677
     (:pipeline-objects
      m7676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (.
      bean7675
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7706] (datapipeline/pipeline-object arg7706))
 v7677))))
   (clojure.core/let
    [v7677
     (:parameter-objects
      m7676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (.
      bean7675
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7707] (datapipeline/parameter-object arg7707))
 v7677))))
   bean7675))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest}
deactivate-pipeline-request
  [m7679]
  (clojure.core/let
   [bean7678
    (new
     com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest)]
   (clojure.core/let
    [v7680
     (:pipeline-id m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setPipelineId (clojure.core/str v7680))))
   (clojure.core/let
    [v7680
     (:cancel-active m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setCancelActive (clojure.core/boolean v7680))))
   bean7678))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m7682]
  (clojure.core/let
   [bean7681
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/let
    [v7683 (:status m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setStatus (clojure.core/str v7683))))
   (clojure.core/let
    [v7683
     (:pipeline-id m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setPipelineId (clojure.core/str v7683))))
   (clojure.core/let
    [v7683
     (:object-ids m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (.
      bean7681
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7708] (clojure.core/str arg7708))
 v7683))))
   bean7681))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m7685]
  (clojure.core/let
   [bean7684
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/let
    [v7686
     (:pipeline-id m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setPipelineId (clojure.core/str v7686))))
   (clojure.core/let
    [v7686
     (:object-id m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setObjectId (clojure.core/str v7686))))
   (clojure.core/let
    [v7686
     (:expression m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setExpression (clojure.core/str v7686))))
   bean7684))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m7688]
  (clojure.core/let
   [bean7687
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/let
    [v7689 (:marker m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setMarker (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:pipeline-id m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setPipelineId (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:object-ids m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (.
      bean7687
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7709] (clojure.core/str arg7709))
 v7689))))
   (clojure.core/let
    [v7689
     (:evaluate-expressions
      m7688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setEvaluateExpressions (clojure.core/boolean v7689))))
   bean7687))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m7691]
  (clojure.core/let
   [bean7690
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/let
    [v7692
     (:pipeline-id m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setPipelineId (clojure.core/str v7692))))
   (clojure.core/let
    [v7692
     (:parameter-values
      m7691
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (.
      bean7690
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7830] (datapipeline/parameter-value arg7830))
 v7692))))
   (clojure.core/let
    [v7692
     (:start-timestamp
      m7691
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (.
      bean7690
      setStartTimestamp
      (com.palletops.awaze.common/to-date v7692))))
   bean7690))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m7710]
   (clojure.core/let
    [credentials7711 (:credentials m7710) args7712 (:args m7710)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7713
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7711)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7713
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args7712 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials7715 & args7716]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7717
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7715)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7717
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args7716 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m7718]
   (clojure.core/let
    [credentials7719 (:credentials m7718) args7720 (:args m7718)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7721
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7719)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7721
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args7720 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials7723 & args7724]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7725
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7723)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7725
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args7724 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m7726]
   (clojure.core/let
    [credentials7727 (:credentials m7726) args7728 (:args m7726)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7729
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7727)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7729
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args7728 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-progress,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskProgress"}
   [credentials7731 & args7732]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7733
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7731)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7733
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args7732 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :remove-tags
   [m7734]
   (clojure.core/let
    [credentials7735 (:credentials m7734) args7736 (:args m7734)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7737
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7735)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7737
       removeTags
       (datapipeline/remove-tags-request
        (clojure.core/nth args7736 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials7739 & args7740]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7741
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7739)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7741
      removeTags
      (datapipeline/remove-tags-request (clojure.core/nth args7740 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m7742]
   (clojure.core/let
    [credentials7743 (:credentials m7742) args7744 (:args m7742)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7745
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7743)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7745
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args7744 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Call describePipelines"}
   [credentials7747 & args7748]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7749
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7747)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7749
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args7748 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m7750]
   (clojure.core/let
    [credentials7751 (:credentials m7750) args7752 (:args m7750)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7753
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7751)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7753
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args7752 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :poll-for-task,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Call pollForTask"}
   [credentials7755 & args7756]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7757
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7755)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7757
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args7756 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :add-tags
   [m7758]
   (clojure.core/let
    [credentials7759 (:credentials m7758) args7760 (:args m7758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7761
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7761
       addTags
       (datapipeline/add-tags-request (clojure.core/nth args7760 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials7763 & args7764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7765
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7765
      addTags
      (datapipeline/add-tags-request (clojure.core/nth args7764 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m7766]
   (clojure.core/let
    [credentials7767 (:credentials m7766) args7768 (:args m7766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7769
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7767)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7769
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args7768 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :query-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Call queryObjects"}
   [credentials7771 & args7772]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7773
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7771)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7773
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args7772 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m7774]
   (clojure.core/let
    [credentials7775 (:credentials m7774) args7776 (:args m7774)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7777
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7775)]
     (clojure.core/case
      (clojure.core/count args7776)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7777
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args7776 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7777
        listPipelines))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials7779 & args7780]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7781
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7779)]
    (clojure.core/case
     (clojure.core/count args7780)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7781
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args7780 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7781
       listPipelines))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m7782]
   (clojure.core/let
    [credentials7783 (:credentials m7782) args7784 (:args m7782)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7785
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7783)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7785
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args7784 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials7787 & args7788]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7789
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7787)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7789
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args7788 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m7790]
   (clojure.core/let
    [credentials7791 (:credentials m7790) args7792 (:args m7790)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7793
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7791)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7793
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args7792 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-task-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Call setTaskStatus"}
   [credentials7795 & args7796]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7797
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7795)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7797
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args7796 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m7798]
   (clojure.core/let
    [credentials7799 (:credentials m7798) args7800 (:args m7798)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7801
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7799)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7801
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args7800 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Call createPipeline"}
   [credentials7803 & args7804]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7805
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7803)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7805
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args7804 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m7806]
   (clojure.core/let
    [credentials7807 (:credentials m7806) args7808 (:args m7806)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7809
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7807)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7809
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args7808 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deletePipeline"}
   [credentials7811 & args7812]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7813
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7811)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7813
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args7812 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m7814]
   (clojure.core/let
    [credentials7815 (:credentials m7814) args7816 (:args m7814)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7817
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7815)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7817
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args7816 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials7819 & args7820]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7821
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7819)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7821
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args7820 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :deactivate-pipeline
   [m7822]
   (clojure.core/let
    [credentials7823 (:credentials m7822) args7824 (:args m7822)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7825
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7823)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7825
       deactivatePipeline
       (datapipeline/deactivate-pipeline-request
        (clojure.core/nth args7824 0)))))))
  (clojure.core/defn
   deactivate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deactivatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   deactivate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deactivatePipeline"}
   [credentials7827 & args7828]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7829
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7827)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7829
      deactivatePipeline
      (datapipeline/deactivate-pipeline-request
       (clojure.core/nth args7828 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m7831]
   (clojure.core/let
    [credentials7832 (:credentials m7831) args7833 (:args m7831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7834
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7834
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args7833 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call setStatus"}
   [credentials7836 & args7837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7838
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7838
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args7837 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m7839]
   (clojure.core/let
    [credentials7840 (:credentials m7839) args7841 (:args m7839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7842
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7842
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args7841 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :evaluate-expression,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call evaluateExpression"}
   [credentials7844 & args7845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7846
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7846
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args7845 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m7847]
   (clojure.core/let
    [credentials7848 (:credentials m7847) args7849 (:args m7847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7850
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7848)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7850
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args7849 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Call describeObjects"}
   [credentials7852 & args7853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7854
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7852)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7854
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args7853 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m7855]
   (clojure.core/let
    [credentials7856 (:credentials m7855) args7857 (:args m7855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7858
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7856)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7858
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args7857 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call activatePipeline"}
   [credentials7860 & args7861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7862
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7860)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7862
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args7861 0))))))))
