(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m11716]
  (clojure.core/let
   [bean11715
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/let
    [v11717 (:cidr m11716 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11717 :com.palletops.awaze.client-builder/undef)
     (. bean11715 setCidr (clojure.core/str v11717))))
   bean11715))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m11719]
  (clojure.core/let
   [bean11718
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11720 (:vlan m11719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11720 :com.palletops.awaze.client-builder/undef)
     (. bean11718 setVlan (clojure.core/int v11720))))
   (clojure.core/let
    [v11720 (:asn m11719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11720 :com.palletops.awaze.client-builder/undef)
     (. bean11718 setAsn (clojure.core/int v11720))))
   (clojure.core/let
    [v11720
     (:virtual-interface-name
      m11719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11720 :com.palletops.awaze.client-builder/undef)
     (. bean11718 setVirtualInterfaceName (clojure.core/str v11720))))
   (clojure.core/let
    [v11720
     (:auth-key m11719 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11720 :com.palletops.awaze.client-builder/undef)
     (. bean11718 setAuthKey (clojure.core/str v11720))))
   (clojure.core/let
    [v11720
     (:amazon-address
      m11719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11720 :com.palletops.awaze.client-builder/undef)
     (. bean11718 setAmazonAddress (clojure.core/str v11720))))
   (clojure.core/let
    [v11720
     (:customer-address
      m11719
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11720 :com.palletops.awaze.client-builder/undef)
     (. bean11718 setCustomerAddress (clojure.core/str v11720))))
   bean11718))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m11722]
  (clojure.core/let
   [bean11721
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11723 (:vlan m11722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (. bean11721 setVlan (clojure.core/int v11723))))
   (clojure.core/let
    [v11723 (:asn m11722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (. bean11721 setAsn (clojure.core/int v11723))))
   (clojure.core/let
    [v11723
     (:route-filter-prefixes
      m11722
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (.
      bean11721
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11787]
  (directconnect/route-filter-prefix arg11787))
 v11723))))
   (clojure.core/let
    [v11723
     (:virtual-interface-name
      m11722
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (. bean11721 setVirtualInterfaceName (clojure.core/str v11723))))
   (clojure.core/let
    [v11723
     (:auth-key m11722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (. bean11721 setAuthKey (clojure.core/str v11723))))
   (clojure.core/let
    [v11723
     (:amazon-address
      m11722
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (. bean11721 setAmazonAddress (clojure.core/str v11723))))
   (clojure.core/let
    [v11723
     (:customer-address
      m11722
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11723 :com.palletops.awaze.client-builder/undef)
     (. bean11721 setCustomerAddress (clojure.core/str v11723))))
   bean11721))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m11725]
  (clojure.core/let
   [bean11724
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/let
    [v11726
     (:virtual-gateway-id
      m11725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setVirtualGatewayId (clojure.core/str v11726))))
   (clojure.core/let
    [v11726 (:vlan m11725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setVlan (clojure.core/int v11726))))
   (clojure.core/let
    [v11726 (:asn m11725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setAsn (clojure.core/int v11726))))
   (clojure.core/let
    [v11726
     (:virtual-interface-name
      m11725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setVirtualInterfaceName (clojure.core/str v11726))))
   (clojure.core/let
    [v11726
     (:auth-key m11725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setAuthKey (clojure.core/str v11726))))
   (clojure.core/let
    [v11726
     (:amazon-address
      m11725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setAmazonAddress (clojure.core/str v11726))))
   (clojure.core/let
    [v11726
     (:customer-address
      m11725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11726 :com.palletops.awaze.client-builder/undef)
     (. bean11724 setCustomerAddress (clojure.core/str v11726))))
   bean11724))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m11728]
  (clojure.core/let
   [bean11727
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/let
    [v11729 (:vlan m11728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (. bean11727 setVlan (clojure.core/int v11729))))
   (clojure.core/let
    [v11729 (:asn m11728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (. bean11727 setAsn (clojure.core/int v11729))))
   (clojure.core/let
    [v11729
     (:route-filter-prefixes
      m11728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (.
      bean11727
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11788]
  (directconnect/route-filter-prefix arg11788))
 v11729))))
   (clojure.core/let
    [v11729
     (:virtual-interface-name
      m11728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (. bean11727 setVirtualInterfaceName (clojure.core/str v11729))))
   (clojure.core/let
    [v11729
     (:auth-key m11728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (. bean11727 setAuthKey (clojure.core/str v11729))))
   (clojure.core/let
    [v11729
     (:amazon-address
      m11728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (. bean11727 setAmazonAddress (clojure.core/str v11729))))
   (clojure.core/let
    [v11729
     (:customer-address
      m11728
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11729 :com.palletops.awaze.client-builder/undef)
     (. bean11727 setCustomerAddress (clojure.core/str v11729))))
   bean11727))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m11731]
  (clojure.core/let
   [bean11730
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/let
    [v11732
     (:interconnect-id
      m11731
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11732 :com.palletops.awaze.client-builder/undef)
     (. bean11730 setInterconnectId (clojure.core/str v11732))))
   bean11730))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m11734]
  (clojure.core/let
   [bean11733
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11735
     (:connection-id m11734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setConnectionId (clojure.core/str v11735))))
   (clojure.core/let
    [v11735
     (:new-private-virtual-interface-allocation
      m11734
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (.
      bean11733
      setNewPrivateVirtualInterfaceAllocation
      (directconnect/new-private-virtual-interface-allocation v11735))))
   (clojure.core/let
    [v11735
     (:owner-account m11734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setOwnerAccount (clojure.core/str v11735))))
   bean11733))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m11737]
  (clojure.core/let
   [bean11736
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/let
    [v11738
     (:connection-id m11737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setConnectionId (clojure.core/str v11738))))
   (clojure.core/let
    [v11738
     (:virtual-interface-id
      m11737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setVirtualInterfaceId (clojure.core/str v11738))))
   bean11736))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m11740]
  (clojure.core/let
   [bean11739
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11741
     (:connection-id m11740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setConnectionId (clojure.core/str v11741))))
   (clojure.core/let
    [v11741
     (:new-public-virtual-interface-allocation
      m11740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (.
      bean11739
      setNewPublicVirtualInterfaceAllocation
      (directconnect/new-public-virtual-interface-allocation v11741))))
   (clojure.core/let
    [v11741
     (:owner-account m11740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setOwnerAccount (clojure.core/str v11741))))
   bean11739))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m11743]
  (clojure.core/let
   [bean11742
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/let
    [v11744
     (:interconnect-id
      m11743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setInterconnectId (clojure.core/str v11744))))
   bean11742))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m11746]
  (clojure.core/let
   [bean11745
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/let
    [v11747
     (:virtual-interface-id
      m11746
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11747 :com.palletops.awaze.client-builder/undef)
     (. bean11745 setVirtualInterfaceId (clojure.core/str v11747))))
   bean11745))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m11749]
  (clojure.core/let
   [bean11748
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean11748))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m11752]
  (clojure.core/let
   [bean11751
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/let
    [v11753
     (:bandwidth m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setBandwidth (clojure.core/str v11753))))
   (clojure.core/let
    [v11753
     (:connection-name
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setConnectionName (clojure.core/str v11753))))
   (clojure.core/let
    [v11753
     (:interconnect-id
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setInterconnectId (clojure.core/str v11753))))
   (clojure.core/let
    [v11753 (:vlan m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setVlan (clojure.core/int v11753))))
   (clojure.core/let
    [v11753
     (:owner-account m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setOwnerAccount (clojure.core/str v11753))))
   bean11751))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m11755]
  (clojure.core/let
   [bean11754
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/let
    [v11756
     (:bandwidth m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setBandwidth (clojure.core/str v11756))))
   (clojure.core/let
    [v11756
     (:interconnect-name
      m11755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setInterconnectName (clojure.core/str v11756))))
   (clojure.core/let
    [v11756
     (:location m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setLocation (clojure.core/str v11756))))
   bean11754))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m11758]
  (clojure.core/let
   [bean11757
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/let
    [v11759
     (:connection-id m11758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setConnectionId (clojure.core/str v11759))))
   bean11757))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m11761]
  (clojure.core/let
   [bean11760
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11762
     (:connection-id m11761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11762 :com.palletops.awaze.client-builder/undef)
     (. bean11760 setConnectionId (clojure.core/str v11762))))
   (clojure.core/let
    [v11762
     (:new-private-virtual-interface
      m11761
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11762 :com.palletops.awaze.client-builder/undef)
     (.
      bean11760
      setNewPrivateVirtualInterface
      (directconnect/new-private-virtual-interface v11762))))
   bean11760))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m11764]
  (clojure.core/let
   [bean11763
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/let
    [v11765
     (:interconnect-id
      m11764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11765 :com.palletops.awaze.client-builder/undef)
     (. bean11763 setInterconnectId (clojure.core/str v11765))))
   bean11763))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m11767]
  (clojure.core/let
   [bean11766
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11768
     (:connection-id m11767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setConnectionId (clojure.core/str v11768))))
   (clojure.core/let
    [v11768
     (:new-public-virtual-interface
      m11767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (.
      bean11766
      setNewPublicVirtualInterface
      (directconnect/new-public-virtual-interface v11768))))
   bean11766))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m11770]
  (clojure.core/let
   [bean11769
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/let
    [v11771
     (:bandwidth m11770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setBandwidth (clojure.core/str v11771))))
   (clojure.core/let
    [v11771
     (:connection-name
      m11770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setConnectionName (clojure.core/str v11771))))
   (clojure.core/let
    [v11771
     (:location m11770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setLocation (clojure.core/str v11771))))
   bean11769))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m11773]
  (clojure.core/let
   [bean11772
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/let
    [v11774
     (:connection-id m11773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11774 :com.palletops.awaze.client-builder/undef)
     (. bean11772 setConnectionId (clojure.core/str v11774))))
   bean11772))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m11776]
  (clojure.core/let
   [bean11775
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean11775))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m11779]
  (clojure.core/let
   [bean11778
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/let
    [v11780
     (:connection-id m11779 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setConnectionId (clojure.core/str v11780))))
   bean11778))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m11782]
  (clojure.core/let
   [bean11781
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11783
     (:virtual-interface-id
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setVirtualInterfaceId (clojure.core/str v11783))))
   bean11781))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m11785]
  (clojure.core/let
   [bean11784
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11786
     (:virtual-interface-id
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setVirtualInterfaceId (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:virtual-gateway-id
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setVirtualGatewayId (clojure.core/str v11786))))
   bean11784))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m11789]
   (clojure.core/let
    [credentials11790 (:credentials m11789) args11791 (:args m11789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11792
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11792
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args11791 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials11794 & args11795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11796
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11796
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args11795 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m11797]
   (clojure.core/let
    [credentials11798 (:credentials m11797) args11799 (:args m11797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11800
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11800
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args11799 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials11802 & args11803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11804
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11804
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args11803 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m11805]
   (clojure.core/let
    [credentials11806 (:credentials m11805) args11807 (:args m11805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11808
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11806)]
     (clojure.core/case
      (clojure.core/count args11807)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11808
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args11807 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11808
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials11810 & args11811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11812
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11810)]
    (clojure.core/case
     (clojure.core/count args11811)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11812
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args11811 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11812
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m11813]
   (clojure.core/let
    [credentials11814 (:credentials m11813) args11815 (:args m11813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11816
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11814)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11816
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args11815 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials11818 & args11819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11820
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11820
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args11819 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m11821]
   (clojure.core/let
    [credentials11822 (:credentials m11821) args11823 (:args m11821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11824
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11822)]
     (clojure.core/case
      (clojure.core/count args11823)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11824
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11824
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args11823 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials11826 & args11827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11828
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11826)]
    (clojure.core/case
     (clojure.core/count args11827)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11828
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11828
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args11827 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m11829]
   (clojure.core/let
    [credentials11830 (:credentials m11829) args11831 (:args m11829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11832
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11830)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11832
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args11831 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials11834 & args11835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11836
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11834)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11836
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args11835 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m11837]
   (clojure.core/let
    [credentials11838 (:credentials m11837) args11839 (:args m11837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11840
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11838)]
     (clojure.core/case
      (clojure.core/count args11839)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11840
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11840
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args11839 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials11842 & args11843]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11844
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11842)]
    (clojure.core/case
     (clojure.core/count args11843)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11844
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11844
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args11843 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m11845]
   (clojure.core/let
    [credentials11846 (:credentials m11845) args11847 (:args m11845)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11848
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11846)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11848
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args11847 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials11850 & args11851]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11852
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11850)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11852
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args11851 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m11853]
   (clojure.core/let
    [credentials11854 (:credentials m11853) args11855 (:args m11853)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11856
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11854)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11856
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args11855 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Call createInterconnect"}
   [credentials11858 & args11859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11860
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11858)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11860
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args11859 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m11861]
   (clojure.core/let
    [credentials11862 (:credentials m11861) args11863 (:args m11861)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11864
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11862)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11864
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args11863 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConnection"}
   [credentials11866 & args11867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11868
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11866)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11868
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args11867 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m11869]
   (clojure.core/let
    [credentials11870 (:credentials m11869) args11871 (:args m11869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11872
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11870)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11872
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args11871 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials11874 & args11875]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11876
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11874)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11876
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args11875 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m11877]
   (clojure.core/let
    [credentials11878 (:credentials m11877) args11879 (:args m11877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11880
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11880
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args11879 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInterconnect"}
   [credentials11882 & args11883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11884
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11884
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args11883 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m11885]
   (clojure.core/let
    [credentials11886 (:credentials m11885) args11887 (:args m11885)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11888
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11886)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11888
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args11887 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials11890 & args11891]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11892
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11890)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11892
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args11891 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m11893]
   (clojure.core/let
    [credentials11894 (:credentials m11893) args11895 (:args m11893)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11896
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11894)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11896
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args11895 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Call createConnection"}
   [credentials11898 & args11899]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11900
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11898)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11900
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args11899 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m11901]
   (clojure.core/let
    [credentials11902 (:credentials m11901) args11903 (:args m11901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11904
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11902)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11904
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args11903 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmConnection"}
   [credentials11906 & args11907]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11908
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11906)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11908
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args11907 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m11909]
   (clojure.core/let
    [credentials11910 (:credentials m11909) args11911 (:args m11909)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11912
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11910)]
     (clojure.core/case
      (clojure.core/count args11911)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11912
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11912
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args11911 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials11914 & args11915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11916
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11914)]
    (clojure.core/case
     (clojure.core/count args11915)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11916
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11916
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args11915 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m11917]
   (clojure.core/let
    [credentials11918 (:credentials m11917) args11919 (:args m11917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11920
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11918)]
     (clojure.core/case
      (clojure.core/count args11919)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11920
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args11919 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11920
        describeConnections))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials11922 & args11923]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11924
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11922)]
    (clojure.core/case
     (clojure.core/count args11923)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11924
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args11923 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11924
       describeConnections))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m11925]
   (clojure.core/let
    [credentials11926 (:credentials m11925) args11927 (:args m11925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11928
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11926)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11928
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args11927 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials11930 & args11931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11932
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11930)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11932
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args11931 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m11933]
   (clojure.core/let
    [credentials11934 (:credentials m11933) args11935 (:args m11933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11936
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11934)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11936
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args11935 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials11938 & args11939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11940
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11938)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11940
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args11939 0))))))))
