(ns
 com.palletops.awaze.elasticache
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticache :as elasticache]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticache
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticache.AmazonElastiCacheClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ParameterNameValue}
parameter-name-value
  [m14297]
  (clojure.core/let
   [bean14296
    (new com.amazonaws.services.elasticache.model.ParameterNameValue)]
   (clojure.core/let
    [v14298
     (:parameter-value
      m14297
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14298 :com.palletops.awaze.client-builder/undef)
     (. bean14296 setParameterValue (clojure.core/str v14298))))
   (clojure.core/let
    [v14298
     (:parameter-name
      m14297
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14298 :com.palletops.awaze.client-builder/undef)
     (. bean14296 setParameterName (clojure.core/str v14298))))
   bean14296))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.Tag}
tag
  [m14300]
  (clojure.core/let
   [bean14299 (new com.amazonaws.services.elasticache.model.Tag)]
   (clojure.core/let
    [v14301 (:key m14300 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14301 :com.palletops.awaze.client-builder/undef)
     (. bean14299 setKey (clojure.core/str v14301))))
   (clojure.core/let
    [v14301 (:value m14300 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14301 :com.palletops.awaze.client-builder/undef)
     (. bean14299 setValue (clojure.core/str v14301))))
   bean14299))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.SourceType}
source-type
  [m14303]
  (.
   com.amazonaws.services.elasticache.model.SourceType
   fromValue
   (clojure.core/name m14303)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest}
modify-cache-parameter-group-request
  [m14306]
  (clojure.core/let
   [bean14305
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest)]
   (clojure.core/let
    [v14307
     (:cache-parameter-group-name
      m14306
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14307 :com.palletops.awaze.client-builder/undef)
     (.
      bean14305
      setCacheParameterGroupName
      (clojure.core/str v14307))))
   (clojure.core/let
    [v14307
     (:parameter-name-values
      m14306
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14307 :com.palletops.awaze.client-builder/undef)
     (.
      bean14305
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14419]
  (elasticache/parameter-name-value arg14419))
 v14307))))
   bean14305))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest}
describe-replication-groups-request
  [m14309]
  (clojure.core/let
   [bean14308
    (new
     com.amazonaws.services.elasticache.model.DescribeReplicationGroupsRequest)]
   (clojure.core/let
    [v14310
     (:replication-group-id
      m14309
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14310 :com.palletops.awaze.client-builder/undef)
     (. bean14308 setReplicationGroupId (clojure.core/str v14310))))
   (clojure.core/let
    [v14310
     (:marker m14309 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14310 :com.palletops.awaze.client-builder/undef)
     (. bean14308 setMarker (clojure.core/str v14310))))
   (clojure.core/let
    [v14310
     (:max-records m14309 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14310 :com.palletops.awaze.client-builder/undef)
     (. bean14308 setMaxRecords (clojure.core/int v14310))))
   bean14308))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheClusterRequest}
create-cache-cluster-request
  [m14312]
  (clojure.core/let
   [bean14311
    (new
     com.amazonaws.services.elasticache.model.CreateCacheClusterRequest)]
   (clojure.core/let
    [v14313
     (:engine m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setEngine (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:preferred-availability-zones
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setPreferredAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14420] (clojure.core/str arg14420))
 v14313))))
   (clojure.core/let
    [v14313
     (:cache-subnet-group-name
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setCacheSubnetGroupName (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:replication-group-id
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setReplicationGroupId (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:security-group-ids
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14421] (clojure.core/str arg14421))
 v14313))))
   (clojure.core/let
    [v14313
     (:snapshot-retention-limit
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setSnapshotRetentionLimit (clojure.core/int v14313))))
   (clojure.core/let
    [v14313
     (:preferred-maintenance-window
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setPreferredMaintenanceWindow
      (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:azmode m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setAZMode (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:notification-topic-arn
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setNotificationTopicArn (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:cache-security-group-names
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14422] (clojure.core/str arg14422))
 v14313))))
   (clojure.core/let
    [v14313
     (:snapshot-name m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setSnapshotName (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:preferred-availability-zone
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setPreferredAvailabilityZone
      (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:snapshot-arns m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14423] (clojure.core/str arg14423))
 v14313))))
   (clojure.core/let
    [v14313 (:port m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setPort (clojure.core/int v14313))))
   (clojure.core/let
    [v14313 (:tags m14312 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14424] (elasticache/tag arg14424))
 v14313))))
   (clojure.core/let
    [v14313
     (:cache-parameter-group-name
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setCacheParameterGroupName
      (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:cache-cluster-id
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setCacheClusterId (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:num-cache-nodes
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setNumCacheNodes (clojure.core/int v14313))))
   (clojure.core/let
    [v14313
     (:auto-minor-version-upgrade
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (.
      bean14311
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14313))))
   (clojure.core/let
    [v14313
     (:snapshot-window
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setSnapshotWindow (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:engine-version
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setEngineVersion (clojure.core/str v14313))))
   (clojure.core/let
    [v14313
     (:cache-node-type
      m14312
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14313 :com.palletops.awaze.client-builder/undef)
     (. bean14311 setCacheNodeType (clojure.core/str v14313))))
   bean14311))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest}
describe-cache-parameter-groups-request
  [m14315]
  (clojure.core/let
   [bean14314
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest)]
   (clojure.core/let
    [v14316
     (:cache-parameter-group-name
      m14315
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14316 :com.palletops.awaze.client-builder/undef)
     (.
      bean14314
      setCacheParameterGroupName
      (clojure.core/str v14316))))
   (clojure.core/let
    [v14316
     (:marker m14315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14316 :com.palletops.awaze.client-builder/undef)
     (. bean14314 setMarker (clojure.core/str v14316))))
   (clojure.core/let
    [v14316
     (:max-records m14315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14316 :com.palletops.awaze.client-builder/undef)
     (. bean14314 setMaxRecords (clojure.core/int v14316))))
   bean14314))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest}
delete-cache-parameter-group-request
  [m14318]
  (clojure.core/let
   [bean14317
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest)]
   (clojure.core/let
    [v14319
     (:cache-parameter-group-name
      m14318
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14319 :com.palletops.awaze.client-builder/undef)
     (.
      bean14317
      setCacheParameterGroupName
      (clojure.core/str v14319))))
   bean14317))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest}
create-cache-security-group-request
  [m14321]
  (clojure.core/let
   [bean14320
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14322
     (:cache-security-group-name
      m14321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setCacheSecurityGroupName (clojure.core/str v14322))))
   (clojure.core/let
    [v14322
     (:description m14321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14322 :com.palletops.awaze.client-builder/undef)
     (. bean14320 setDescription (clojure.core/str v14322))))
   bean14320))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m14324]
  (clojure.core/let
   [bean14323
    (new
     com.amazonaws.services.elasticache.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v14325 (:tags m14324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (.
      bean14323
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14425] (elasticache/tag arg14425))
 v14325))))
   (clojure.core/let
    [v14325
     (:resource-name m14324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14325 :com.palletops.awaze.client-builder/undef)
     (. bean14323 setResourceName (clojure.core/str v14325))))
   bean14323))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEventsRequest}
describe-events-request
  [m14327]
  (clojure.core/let
   [bean14326
    (new
     com.amazonaws.services.elasticache.model.DescribeEventsRequest)]
   (clojure.core/let
    [v14328
     (:marker m14327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (. bean14326 setMarker (clojure.core/str v14328))))
   (clojure.core/let
    [v14328
     (:end-time m14327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (.
      bean14326
      setEndTime
      (com.palletops.awaze.common/to-date v14328))))
   (clojure.core/let
    [v14328
     (:start-time m14327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (.
      bean14326
      setStartTime
      (com.palletops.awaze.common/to-date v14328))))
   (clojure.core/let
    [v14328
     (:max-records m14327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (. bean14326 setMaxRecords (clojure.core/int v14328))))
   (clojure.core/let
    [v14328
     (:source-identifier
      m14327
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (. bean14326 setSourceIdentifier (clojure.core/str v14328))))
   (clojure.core/let
    [v14328
     (:source-type m14327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (. bean14326 setSourceType (elasticache/source-type v14328))))
   (clojure.core/let
    [v14328
     (:duration m14327 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14328 :com.palletops.awaze.client-builder/undef)
     (. bean14326 setDuration (clojure.core/int v14328))))
   bean14326))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest}
modify-cache-subnet-group-request
  [m14330]
  (clojure.core/let
   [bean14329
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14331
     (:cache-subnet-group-name
      m14330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (. bean14329 setCacheSubnetGroupName (clojure.core/str v14331))))
   (clojure.core/let
    [v14331
     (:cache-subnet-group-description
      m14330
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (.
      bean14329
      setCacheSubnetGroupDescription
      (clojure.core/str v14331))))
   (clojure.core/let
    [v14331
     (:subnet-ids m14330 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14331 :com.palletops.awaze.client-builder/undef)
     (.
      bean14329
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14426] (clojure.core/str arg14426))
 v14331))))
   bean14329))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest}
revoke-cache-security-group-ingress-request
  [m14333]
  (clojure.core/let
   [bean14332
    (new
     com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14334
     (:cache-security-group-name
      m14333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14334 :com.palletops.awaze.client-builder/undef)
     (. bean14332 setCacheSecurityGroupName (clojure.core/str v14334))))
   (clojure.core/let
    [v14334
     (:ec2security-group-name
      m14333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14334 :com.palletops.awaze.client-builder/undef)
     (. bean14332 setEC2SecurityGroupName (clojure.core/str v14334))))
   (clojure.core/let
    [v14334
     (:ec2security-group-owner-id
      m14333
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14334 :com.palletops.awaze.client-builder/undef)
     (.
      bean14332
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14334))))
   bean14332))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest}
describe-reserved-cache-nodes-request
  [m14336]
  (clojure.core/let
   [bean14335
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesRequest)]
   (clojure.core/let
    [v14337
     (:reserved-cache-node-id
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setReservedCacheNodeId (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:reserved-cache-nodes-offering-id
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (.
      bean14335
      setReservedCacheNodesOfferingId
      (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:cache-node-type
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setCacheNodeType (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:marker m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setMarker (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:offering-type m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setOfferingType (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:product-description
      m14336
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setProductDescription (clojure.core/str v14337))))
   (clojure.core/let
    [v14337
     (:max-records m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setMaxRecords (clojure.core/int v14337))))
   (clojure.core/let
    [v14337
     (:duration m14336 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14337 :com.palletops.awaze.client-builder/undef)
     (. bean14335 setDuration (clojure.core/str v14337))))
   bean14335))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RebootCacheClusterRequest}
reboot-cache-cluster-request
  [m14339]
  (clojure.core/let
   [bean14338
    (new
     com.amazonaws.services.elasticache.model.RebootCacheClusterRequest)]
   (clojure.core/let
    [v14340
     (:cache-cluster-id
      m14339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (. bean14338 setCacheClusterId (clojure.core/str v14340))))
   (clojure.core/let
    [v14340
     (:cache-node-ids-to-reboot
      m14339
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14340 :com.palletops.awaze.client-builder/undef)
     (.
      bean14338
      setCacheNodeIdsToReboot
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14427] (clojure.core/str arg14427))
 v14340))))
   bean14338))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest}
describe-cache-clusters-request
  [m14342]
  (clojure.core/let
   [bean14341
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest)]
   (clojure.core/let
    [v14343
     (:cache-cluster-id
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setCacheClusterId (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:show-cache-node-info
      m14342
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setShowCacheNodeInfo (clojure.core/boolean v14343))))
   (clojure.core/let
    [v14343
     (:marker m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setMarker (clojure.core/str v14343))))
   (clojure.core/let
    [v14343
     (:max-records m14342 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14343 :com.palletops.awaze.client-builder/undef)
     (. bean14341 setMaxRecords (clojure.core/int v14343))))
   bean14341))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CopySnapshotRequest}
copy-snapshot-request
  [m14345]
  (clojure.core/let
   [bean14344
    (new com.amazonaws.services.elasticache.model.CopySnapshotRequest)]
   (clojure.core/let
    [v14346
     (:source-snapshot-name
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setSourceSnapshotName (clojure.core/str v14346))))
   (clojure.core/let
    [v14346
     (:target-snapshot-name
      m14345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14346 :com.palletops.awaze.client-builder/undef)
     (. bean14344 setTargetSnapshotName (clojure.core/str v14346))))
   bean14344))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteSnapshotRequest}
delete-snapshot-request
  [m14348]
  (clojure.core/let
   [bean14347
    (new
     com.amazonaws.services.elasticache.model.DeleteSnapshotRequest)]
   (clojure.core/let
    [v14349
     (:snapshot-name m14348 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14349 :com.palletops.awaze.client-builder/undef)
     (. bean14347 setSnapshotName (clojure.core/str v14349))))
   bean14347))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest}
describe-cache-engine-versions-request
  [m14351]
  (clojure.core/let
   [bean14350
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheEngineVersionsRequest)]
   (clojure.core/let
    [v14352
     (:cache-parameter-group-family
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (.
      bean14350
      setCacheParameterGroupFamily
      (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:marker m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setMarker (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:max-records m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setMaxRecords (clojure.core/int v14352))))
   (clojure.core/let
    [v14352
     (:engine m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setEngine (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:engine-version
      m14351
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setEngineVersion (clojure.core/str v14352))))
   (clojure.core/let
    [v14352
     (:default-only m14351 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14352 :com.palletops.awaze.client-builder/undef)
     (. bean14350 setDefaultOnly (clojure.core/boolean v14352))))
   bean14350))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m14354]
  (clojure.core/let
   [bean14353
    (new
     com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v14355
     (:cache-parameter-group-family
      m14354
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (.
      bean14353
      setCacheParameterGroupFamily
      (clojure.core/str v14355))))
   (clojure.core/let
    [v14355
     (:marker m14354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (. bean14353 setMarker (clojure.core/str v14355))))
   (clojure.core/let
    [v14355
     (:max-records m14354 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14355 :com.palletops.awaze.client-builder/undef)
     (. bean14353 setMaxRecords (clojure.core/int v14355))))
   bean14353))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest}
delete-replication-group-request
  [m14357]
  (clojure.core/let
   [bean14356
    (new
     com.amazonaws.services.elasticache.model.DeleteReplicationGroupRequest)]
   (clojure.core/let
    [v14358
     (:final-snapshot-identifier
      m14357
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (.
      bean14356
      setFinalSnapshotIdentifier
      (clojure.core/str v14358))))
   (clojure.core/let
    [v14358
     (:replication-group-id
      m14357
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (. bean14356 setReplicationGroupId (clojure.core/str v14358))))
   (clojure.core/let
    [v14358
     (:retain-primary-cluster
      m14357
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14358 :com.palletops.awaze.client-builder/undef)
     (.
      bean14356
      setRetainPrimaryCluster
      (clojure.core/boolean v14358))))
   bean14356))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest}
create-cache-subnet-group-request
  [m14360]
  (clojure.core/let
   [bean14359
    (new
     com.amazonaws.services.elasticache.model.CreateCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14361
     (:cache-subnet-group-name
      m14360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (. bean14359 setCacheSubnetGroupName (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:cache-subnet-group-description
      m14360
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (.
      bean14359
      setCacheSubnetGroupDescription
      (clojure.core/str v14361))))
   (clojure.core/let
    [v14361
     (:subnet-ids m14360 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14361 :com.palletops.awaze.client-builder/undef)
     (.
      bean14359
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14428] (clojure.core/str arg14428))
 v14361))))
   bean14359))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest}
modify-cache-cluster-request
  [m14363]
  (clojure.core/let
   [bean14362
    (new
     com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest)]
   (clojure.core/let
    [v14364
     (:new-availability-zones
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setNewAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14429] (clojure.core/str arg14429))
 v14364))))
   (clojure.core/let
    [v14364
     (:security-group-ids
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14430] (clojure.core/str arg14430))
 v14364))))
   (clojure.core/let
    [v14364
     (:snapshot-retention-limit
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setSnapshotRetentionLimit (clojure.core/int v14364))))
   (clojure.core/let
    [v14364
     (:apply-immediately
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setApplyImmediately (clojure.core/boolean v14364))))
   (clojure.core/let
    [v14364
     (:preferred-maintenance-window
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setPreferredMaintenanceWindow
      (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:azmode m14363 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setAZMode (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:notification-topic-arn
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setNotificationTopicArn (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:cache-security-group-names
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14431] (clojure.core/str arg14431))
 v14364))))
   (clojure.core/let
    [v14364
     (:cache-parameter-group-name
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setCacheParameterGroupName
      (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:cache-cluster-id
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setCacheClusterId (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:notification-topic-status
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setNotificationTopicStatus
      (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:num-cache-nodes
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setNumCacheNodes (clojure.core/int v14364))))
   (clojure.core/let
    [v14364
     (:cache-node-ids-to-remove
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setCacheNodeIdsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14432] (clojure.core/str arg14432))
 v14364))))
   (clojure.core/let
    [v14364
     (:auto-minor-version-upgrade
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (.
      bean14362
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14364))))
   (clojure.core/let
    [v14364
     (:snapshot-window
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setSnapshotWindow (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:engine-version
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setEngineVersion (clojure.core/str v14364))))
   (clojure.core/let
    [v14364
     (:cache-node-type
      m14363
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14364 :com.palletops.awaze.client-builder/undef)
     (. bean14362 setCacheNodeType (clojure.core/str v14364))))
   bean14362))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest}
authorize-cache-security-group-ingress-request
  [m14366]
  (clojure.core/let
   [bean14365
    (new
     com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest)]
   (clojure.core/let
    [v14367
     (:cache-security-group-name
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setCacheSecurityGroupName (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:ec2security-group-name
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (. bean14365 setEC2SecurityGroupName (clojure.core/str v14367))))
   (clojure.core/let
    [v14367
     (:ec2security-group-owner-id
      m14366
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14367 :com.palletops.awaze.client-builder/undef)
     (.
      bean14365
      setEC2SecurityGroupOwnerId
      (clojure.core/str v14367))))
   bean14365))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest}
describe-cache-parameters-request
  [m14369]
  (clojure.core/let
   [bean14368
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest)]
   (clojure.core/let
    [v14370
     (:cache-parameter-group-name
      m14369
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (.
      bean14368
      setCacheParameterGroupName
      (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:marker m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setMarker (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:source m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setSource (clojure.core/str v14370))))
   (clojure.core/let
    [v14370
     (:max-records m14369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14370 :com.palletops.awaze.client-builder/undef)
     (. bean14368 setMaxRecords (clojure.core/int v14370))))
   bean14368))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest}
delete-cache-cluster-request
  [m14372]
  (clojure.core/let
   [bean14371
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest)]
   (clojure.core/let
    [v14373
     (:cache-cluster-id
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (. bean14371 setCacheClusterId (clojure.core/str v14373))))
   (clojure.core/let
    [v14373
     (:final-snapshot-identifier
      m14372
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14373 :com.palletops.awaze.client-builder/undef)
     (.
      bean14371
      setFinalSnapshotIdentifier
      (clojure.core/str v14373))))
   bean14371))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest}
list-allowed-node-type-modifications-request
  [m14375]
  (clojure.core/let
   [bean14374
    (new
     com.amazonaws.services.elasticache.model.ListAllowedNodeTypeModificationsRequest)]
   (clojure.core/let
    [v14376
     (:cache-cluster-id
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (. bean14374 setCacheClusterId (clojure.core/str v14376))))
   (clojure.core/let
    [v14376
     (:replication-group-id
      m14375
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14376 :com.palletops.awaze.client-builder/undef)
     (. bean14374 setReplicationGroupId (clojure.core/str v14376))))
   bean14374))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest}
create-cache-parameter-group-request
  [m14378]
  (clojure.core/let
   [bean14377
    (new
     com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest)]
   (clojure.core/let
    [v14379
     (:cache-parameter-group-family
      m14378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (.
      bean14377
      setCacheParameterGroupFamily
      (clojure.core/str v14379))))
   (clojure.core/let
    [v14379
     (:cache-parameter-group-name
      m14378
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (.
      bean14377
      setCacheParameterGroupName
      (clojure.core/str v14379))))
   (clojure.core/let
    [v14379
     (:description m14378 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14379 :com.palletops.awaze.client-builder/undef)
     (. bean14377 setDescription (clojure.core/str v14379))))
   bean14377))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest}
modify-replication-group-request
  [m14381]
  (clojure.core/let
   [bean14380
    (new
     com.amazonaws.services.elasticache.model.ModifyReplicationGroupRequest)]
   (clojure.core/let
    [v14382
     (:snapshotting-cluster-id
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setSnapshottingClusterId (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:replication-group-description
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setReplicationGroupDescription
      (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:replication-group-id
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setReplicationGroupId (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:security-group-ids
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14433] (clojure.core/str arg14433))
 v14382))))
   (clojure.core/let
    [v14382
     (:snapshot-retention-limit
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setSnapshotRetentionLimit (clojure.core/int v14382))))
   (clojure.core/let
    [v14382
     (:apply-immediately
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setApplyImmediately (clojure.core/boolean v14382))))
   (clojure.core/let
    [v14382
     (:primary-cluster-id
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setPrimaryClusterId (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:preferred-maintenance-window
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setPreferredMaintenanceWindow
      (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:notification-topic-arn
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setNotificationTopicArn (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:cache-security-group-names
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14434] (clojure.core/str arg14434))
 v14382))))
   (clojure.core/let
    [v14382
     (:cache-parameter-group-name
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setCacheParameterGroupName
      (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:notification-topic-status
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setNotificationTopicStatus
      (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:auto-minor-version-upgrade
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14382))))
   (clojure.core/let
    [v14382
     (:automatic-failover-enabled
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (.
      bean14380
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14382))))
   (clojure.core/let
    [v14382
     (:snapshot-window
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setSnapshotWindow (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:engine-version
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setEngineVersion (clojure.core/str v14382))))
   (clojure.core/let
    [v14382
     (:cache-node-type
      m14381
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14382 :com.palletops.awaze.client-builder/undef)
     (. bean14380 setCacheNodeType (clojure.core/str v14382))))
   bean14380))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m14384]
  (clojure.core/let
   [bean14383
    (new
     com.amazonaws.services.elasticache.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v14385
     (:tag-keys m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (.
      bean14383
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14435] (clojure.core/str arg14435))
 v14385))))
   (clojure.core/let
    [v14385
     (:resource-name m14384 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14385 :com.palletops.awaze.client-builder/undef)
     (. bean14383 setResourceName (clojure.core/str v14385))))
   bean14383))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest}
describe-reserved-cache-nodes-offerings-request
  [m14387]
  (clojure.core/let
   [bean14386
    (new
     com.amazonaws.services.elasticache.model.DescribeReservedCacheNodesOfferingsRequest)]
   (clojure.core/let
    [v14388
     (:reserved-cache-nodes-offering-id
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (.
      bean14386
      setReservedCacheNodesOfferingId
      (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:cache-node-type
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setCacheNodeType (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:marker m14387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setMarker (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:offering-type m14387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setOfferingType (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:product-description
      m14387
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setProductDescription (clojure.core/str v14388))))
   (clojure.core/let
    [v14388
     (:max-records m14387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setMaxRecords (clojure.core/int v14388))))
   (clojure.core/let
    [v14388
     (:duration m14387 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14388 :com.palletops.awaze.client-builder/undef)
     (. bean14386 setDuration (clojure.core/str v14388))))
   bean14386))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest}
describe-cache-security-groups-request
  [m14390]
  (clojure.core/let
   [bean14389
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest)]
   (clojure.core/let
    [v14391
     (:cache-security-group-name
      m14390
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setCacheSecurityGroupName (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:marker m14390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setMarker (clojure.core/str v14391))))
   (clojure.core/let
    [v14391
     (:max-records m14390 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14391 :com.palletops.awaze.client-builder/undef)
     (. bean14389 setMaxRecords (clojure.core/int v14391))))
   bean14389))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest}
create-replication-group-request
  [m14393]
  (clojure.core/let
   [bean14392
    (new
     com.amazonaws.services.elasticache.model.CreateReplicationGroupRequest)]
   (clojure.core/let
    [v14394
     (:preferred-cache-cluster-azs
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setPreferredCacheClusterAZs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14476] (clojure.core/str arg14476))
 v14394))))
   (clojure.core/let
    [v14394
     (:engine m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setEngine (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:replication-group-description
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setReplicationGroupDescription
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:cache-subnet-group-name
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setCacheSubnetGroupName (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:replication-group-id
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setReplicationGroupId (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:security-group-ids
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14477] (clojure.core/str arg14477))
 v14394))))
   (clojure.core/let
    [v14394
     (:snapshot-retention-limit
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setSnapshotRetentionLimit (clojure.core/int v14394))))
   (clojure.core/let
    [v14394
     (:primary-cluster-id
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setPrimaryClusterId (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:preferred-maintenance-window
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setPreferredMaintenanceWindow
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:notification-topic-arn
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setNotificationTopicArn (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:cache-security-group-names
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setCacheSecurityGroupNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14478] (clojure.core/str arg14478))
 v14394))))
   (clojure.core/let
    [v14394
     (:snapshot-name m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setSnapshotName (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:snapshot-arns m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setSnapshotArns
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14479] (clojure.core/str arg14479))
 v14394))))
   (clojure.core/let
    [v14394 (:port m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setPort (clojure.core/int v14394))))
   (clojure.core/let
    [v14394 (:tags m14393 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg14480] (elasticache/tag arg14480))
 v14394))))
   (clojure.core/let
    [v14394
     (:cache-parameter-group-name
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setCacheParameterGroupName
      (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:auto-minor-version-upgrade
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v14394))))
   (clojure.core/let
    [v14394
     (:automatic-failover-enabled
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (.
      bean14392
      setAutomaticFailoverEnabled
      (clojure.core/boolean v14394))))
   (clojure.core/let
    [v14394
     (:snapshot-window
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setSnapshotWindow (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:engine-version
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setEngineVersion (clojure.core/str v14394))))
   (clojure.core/let
    [v14394
     (:num-cache-clusters
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setNumCacheClusters (clojure.core/int v14394))))
   (clojure.core/let
    [v14394
     (:cache-node-type
      m14393
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14394 :com.palletops.awaze.client-builder/undef)
     (. bean14392 setCacheNodeType (clojure.core/str v14394))))
   bean14392))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m14396]
  (clojure.core/let
   [bean14395
    (new
     com.amazonaws.services.elasticache.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v14397
     (:resource-name m14396 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14397 :com.palletops.awaze.client-builder/undef)
     (. bean14395 setResourceName (clojure.core/str v14397))))
   bean14395))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest}
reset-cache-parameter-group-request
  [m14399]
  (clojure.core/let
   [bean14398
    (new
     com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest)]
   (clojure.core/let
    [v14400
     (:cache-parameter-group-name
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (.
      bean14398
      setCacheParameterGroupName
      (clojure.core/str v14400))))
   (clojure.core/let
    [v14400
     (:parameter-name-values
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (.
      bean14398
      setParameterNameValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg14481]
  (elasticache/parameter-name-value arg14481))
 v14400))))
   (clojure.core/let
    [v14400
     (:reset-all-parameters
      m14399
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14400 :com.palletops.awaze.client-builder/undef)
     (. bean14398 setResetAllParameters (clojure.core/boolean v14400))))
   bean14398))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest}
describe-snapshots-request
  [m14402]
  (clojure.core/let
   [bean14401
    (new
     com.amazonaws.services.elasticache.model.DescribeSnapshotsRequest)]
   (clojure.core/let
    [v14403
     (:cache-cluster-id
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setCacheClusterId (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:snapshot-name m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setSnapshotName (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:snapshot-source
      m14402
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setSnapshotSource (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:marker m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setMarker (clojure.core/str v14403))))
   (clojure.core/let
    [v14403
     (:max-records m14402 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14403 :com.palletops.awaze.client-builder/undef)
     (. bean14401 setMaxRecords (clojure.core/int v14403))))
   bean14401))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest}
delete-cache-subnet-group-request
  [m14405]
  (clojure.core/let
   [bean14404
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSubnetGroupRequest)]
   (clojure.core/let
    [v14406
     (:cache-subnet-group-name
      m14405
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14406 :com.palletops.awaze.client-builder/undef)
     (. bean14404 setCacheSubnetGroupName (clojure.core/str v14406))))
   bean14404))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.CreateSnapshotRequest}
create-snapshot-request
  [m14408]
  (clojure.core/let
   [bean14407
    (new
     com.amazonaws.services.elasticache.model.CreateSnapshotRequest)]
   (clojure.core/let
    [v14409
     (:cache-cluster-id
      m14408
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setCacheClusterId (clojure.core/str v14409))))
   (clojure.core/let
    [v14409
     (:snapshot-name m14408 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14409 :com.palletops.awaze.client-builder/undef)
     (. bean14407 setSnapshotName (clojure.core/str v14409))))
   bean14407))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest}
purchase-reserved-cache-nodes-offering-request
  [m14411]
  (clojure.core/let
   [bean14410
    (new
     com.amazonaws.services.elasticache.model.PurchaseReservedCacheNodesOfferingRequest)]
   (clojure.core/let
    [v14412
     (:reserved-cache-node-id
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setReservedCacheNodeId (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:reserved-cache-nodes-offering-id
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (.
      bean14410
      setReservedCacheNodesOfferingId
      (clojure.core/str v14412))))
   (clojure.core/let
    [v14412
     (:cache-node-count
      m14411
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14412 :com.palletops.awaze.client-builder/undef)
     (. bean14410 setCacheNodeCount (clojure.core/int v14412))))
   bean14410))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest}
delete-cache-security-group-request
  [m14414]
  (clojure.core/let
   [bean14413
    (new
     com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest)]
   (clojure.core/let
    [v14415
     (:cache-security-group-name
      m14414
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14415 :com.palletops.awaze.client-builder/undef)
     (. bean14413 setCacheSecurityGroupName (clojure.core/str v14415))))
   bean14413))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest}
describe-cache-subnet-groups-request
  [m14417]
  (clojure.core/let
   [bean14416
    (new
     com.amazonaws.services.elasticache.model.DescribeCacheSubnetGroupsRequest)]
   (clojure.core/let
    [v14418
     (:cache-subnet-group-name
      m14417
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setCacheSubnetGroupName (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:marker m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setMarker (clojure.core/str v14418))))
   (clojure.core/let
    [v14418
     (:max-records m14417 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v14418 :com.palletops.awaze.client-builder/undef)
     (. bean14416 setMaxRecords (clojure.core/int v14418))))
   bean14416))
 (clojure.core/defmulti
  elasticache
  (clojure.core/fn
   elasticache
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-parameter-group
   [m14436]
   (clojure.core/let
    [credentials14437 (:credentials m14436) args14438 (:args m14436)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14439
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14437)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14439
       modifyCacheParameterGroup
       (elasticache/modify-cache-parameter-group-request
        (clojure.core/nth args14438 0)))))))
  (clojure.core/defn
   modify-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for modifyCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call modifyCacheParameterGroup"}
   [credentials14441 & args14442]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14443
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14441)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14443
      modifyCacheParameterGroup
      (elasticache/modify-cache-parameter-group-request
       (clojure.core/nth args14442 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-replication-groups
   [m14444]
   (clojure.core/let
    [credentials14445 (:credentials m14444) args14446 (:args m14444)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14447
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14445)]
     (clojure.core/case
      (clojure.core/count args14446)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14447
        describeReplicationGroups
        (elasticache/describe-replication-groups-request
         (clojure.core/nth args14446 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14447
        describeReplicationGroups))))))
  (clojure.core/defn
   describe-replication-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReplicationGroups, describeReplicationGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-replication-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-replication-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReplicationGroups, describeReplicationGroups"}
   [credentials14449 & args14450]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14451
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14449)]
    (clojure.core/case
     (clojure.core/count args14450)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14451
       describeReplicationGroups
       (elasticache/describe-replication-groups-request
        (clojure.core/nth args14450 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14451
       describeReplicationGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-cluster
   [m14452]
   (clojure.core/let
    [credentials14453 (:credentials m14452) args14454 (:args m14452)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14455
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14453)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14455
       createCacheCluster
       (elasticache/create-cache-cluster-request
        (clojure.core/nth args14454 0)))))))
  (clojure.core/defn
   create-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [preferred-availability-zone
                         security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         preferred-availability-zones
                         port
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createCacheCluster"}
   [credentials14457 & args14458]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14459
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14457)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14459
      createCacheCluster
      (elasticache/create-cache-cluster-request
       (clojure.core/nth args14458 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameter-groups
   [m14460]
   (clojure.core/let
    [credentials14461 (:credentials m14460) args14462 (:args m14460)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14463
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14461)]
     (clojure.core/case
      (clojure.core/count args14462)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14463
        describeCacheParameterGroups
        (elasticache/describe-cache-parameter-groups-request
         (clojure.core/nth args14462 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14463
        describeCacheParameterGroups))))))
  (clojure.core/defn
   describe-cache-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheParameterGroups, describeCacheParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheParameterGroups, describeCacheParameterGroups"}
   [credentials14465 & args14466]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14467
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14465)]
    (clojure.core/case
     (clojure.core/count args14466)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14467
       describeCacheParameterGroups
       (elasticache/describe-cache-parameter-groups-request
        (clojure.core/nth args14466 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14467
       describeCacheParameterGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-parameter-group
   [m14468]
   (clojure.core/let
    [credentials14469 (:credentials m14468) args14470 (:args m14468)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14471
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14469)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14471
       deleteCacheParameterGroup
       (elasticache/delete-cache-parameter-group-request
        (clojure.core/nth args14470 0)))))))
  (clojure.core/defn
   delete-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for deleteCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call deleteCacheParameterGroup"}
   [credentials14473 & args14474]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14475
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14473)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14475
      deleteCacheParameterGroup
      (elasticache/delete-cache-parameter-group-request
       (clojure.core/nth args14474 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-security-group
   [m14482]
   (clojure.core/let
    [credentials14483 (:credentials m14482) args14484 (:args m14482)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14485
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14483)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14485
       createCacheSecurityGroup
       (elasticache/create-cache-security-group-request
        (clojure.core/nth args14484 0)))))))
  (clojure.core/defn
   create-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSecurityGroup"}
   [credentials14487 & args14488]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14489
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14487)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14489
      createCacheSecurityGroup
      (elasticache/create-cache-security-group-request
       (clojure.core/nth args14488 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :add-tags-to-resource
   [m14490]
   (clojure.core/let
    [credentials14491 (:credentials m14490) args14492 (:args m14490)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14493
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14491)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14493
       addTagsToResource
       (elasticache/add-tags-to-resource-request
        (clojure.core/nth args14492 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials14495 & args14496]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14497
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14495)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14497
      addTagsToResource
      (elasticache/add-tags-to-resource-request
       (clojure.core/nth args14496 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-events
   [m14498]
   (clojure.core/let
    [credentials14499 (:credentials m14498) args14500 (:args m14498)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14501
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14499)]
     (clojure.core/case
      (clojure.core/count args14500)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14501
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14501
        describeEvents
        (elasticache/describe-events-request
         (clojure.core/nth args14500 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials14503 & args14504]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14505
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14503)]
    (clojure.core/case
     (clojure.core/count args14504)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14505
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14505
       describeEvents
       (elasticache/describe-events-request
        (clojure.core/nth args14504 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-subnet-group
   [m14506]
   (clojure.core/let
    [credentials14507 (:credentials m14506) args14508 (:args m14506)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14509
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14507)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14509
       modifyCacheSubnetGroup
       (elasticache/modify-cache-subnet-group-request
        (clojure.core/nth args14508 0)))))))
  (clojure.core/defn
   modify-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyCacheSubnetGroup"}
   [credentials14511 & args14512]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14513
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14511)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14513
      modifyCacheSubnetGroup
      (elasticache/modify-cache-subnet-group-request
       (clojure.core/nth args14512 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :revoke-cache-security-group-ingress
   [m14514]
   (clojure.core/let
    [credentials14515 (:credentials m14514) args14516 (:args m14514)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14517
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14515)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14517
       revokeCacheSecurityGroupIngress
       (elasticache/revoke-cache-security-group-ingress-request
        (clojure.core/nth args14516 0)))))))
  (clojure.core/defn
   revoke-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   revoke-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeCacheSecurityGroupIngress"}
   [credentials14519 & args14520]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14521
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14519)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14521
      revokeCacheSecurityGroupIngress
      (elasticache/revoke-cache-security-group-ingress-request
       (clojure.core/nth args14520 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes
   [m14522]
   (clojure.core/let
    [credentials14523 (:credentials m14522) args14524 (:args m14522)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14525
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14523)]
     (clojure.core/case
      (clojure.core/count args14524)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14525
        describeReservedCacheNodes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14525
        describeReservedCacheNodes
        (elasticache/describe-reserved-cache-nodes-request
         (clojure.core/nth args14524 0))))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedCacheNodes, describeReservedCacheNodes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedCacheNodes, describeReservedCacheNodes"}
   [credentials14527 & args14528]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14529
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14527)]
    (clojure.core/case
     (clojure.core/count args14528)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14529
       describeReservedCacheNodes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14529
       describeReservedCacheNodes
       (elasticache/describe-reserved-cache-nodes-request
        (clojure.core/nth args14528 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reboot-cache-cluster
   [m14530]
   (clojure.core/let
    [credentials14531 (:credentials m14530) args14532 (:args m14530)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14533
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14531)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14533
       rebootCacheCluster
       (elasticache/reboot-cache-cluster-request
        (clojure.core/nth args14532 0)))))))
  (clojure.core/defn
   reboot-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for rebootCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reboot-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-node-ids-to-reboot
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call rebootCacheCluster"}
   [credentials14535 & args14536]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14537
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14535)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14537
      rebootCacheCluster
      (elasticache/reboot-cache-cluster-request
       (clojure.core/nth args14536 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-clusters
   [m14538]
   (clojure.core/let
    [credentials14539 (:credentials m14538) args14540 (:args m14538)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14541
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14539)]
     (clojure.core/case
      (clojure.core/count args14540)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14541
        describeCacheClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14541
        describeCacheClusters
        (elasticache/describe-cache-clusters-request
         (clojure.core/nth args14540 0))))))))
  (clojure.core/defn
   describe-cache-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheClusters, describeCacheClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         show-cache-node-info
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheClusters, describeCacheClusters"}
   [credentials14543 & args14544]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14545
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14543)]
    (clojure.core/case
     (clojure.core/count args14544)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14545
       describeCacheClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14545
       describeCacheClusters
       (elasticache/describe-cache-clusters-request
        (clojure.core/nth args14544 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :copy-snapshot
   [m14546]
   (clojure.core/let
    [credentials14547 (:credentials m14546) args14548 (:args m14546)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14549
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14547)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14549
       copySnapshot
       (elasticache/copy-snapshot-request
        (clojure.core/nth args14548 0)))))))
  (clojure.core/defn
   copy-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Generate map for copySnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   copy-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-snapshot-name
                         read-limit
                         general-progress-listener
                         clone-source
                         target-snapshot-name
                         clone-root]}]]),
    :doc "Call copySnapshot"}
   [credentials14551 & args14552]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14553
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14551)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14553
      copySnapshot
      (elasticache/copy-snapshot-request
       (clojure.core/nth args14552 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-snapshot
   [m14554]
   (clojure.core/let
    [credentials14555 (:credentials m14554) args14556 (:args m14554)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14557
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14555)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14557
       deleteSnapshot
       (elasticache/delete-snapshot-request
        (clojure.core/nth args14556 0)))))))
  (clojure.core/defn
   delete-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteSnapshot"}
   [credentials14559 & args14560]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14561
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14559)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14561
      deleteSnapshot
      (elasticache/delete-snapshot-request
       (clojure.core/nth args14560 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-engine-versions
   [m14562]
   (clojure.core/let
    [credentials14563 (:credentials m14562) args14564 (:args m14562)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14565
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14563)]
     (clojure.core/case
      (clojure.core/count args14564)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14565
        describeCacheEngineVersions
        (elasticache/describe-cache-engine-versions-request
         (clojure.core/nth args14564 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14565
        describeCacheEngineVersions))))))
  (clojure.core/defn
   describe-cache-engine-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Generate map for describeCacheEngineVersions, describeCacheEngineVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-engine-versions,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-engine-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]
                [credentials]]),
    :doc "Call describeCacheEngineVersions, describeCacheEngineVersions"}
   [credentials14567 & args14568]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14569
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14567)]
    (clojure.core/case
     (clojure.core/count args14568)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14569
       describeCacheEngineVersions
       (elasticache/describe-cache-engine-versions-request
        (clojure.core/nth args14568 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14569
       describeCacheEngineVersions))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-engine-default-parameters
   [m14570]
   (clojure.core/let
    [credentials14571 (:credentials m14570) args14572 (:args m14570)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14573
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14571)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14573
       describeEngineDefaultParameters
       (elasticache/describe-engine-default-parameters-request
        (clojure.core/nth args14572 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-engine-default-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials14575 & args14576]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14577
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14575)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14577
      describeEngineDefaultParameters
      (elasticache/describe-engine-default-parameters-request
       (clojure.core/nth args14576 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-replication-group
   [m14578]
   (clojure.core/let
    [credentials14579 (:credentials m14578) args14580 (:args m14578)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14581
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14579)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14581
       deleteReplicationGroup
       (elasticache/delete-replication-group-request
        (clojure.core/nth args14580 0)))))))
  (clojure.core/defn
   delete-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [retain-primary-cluster
                         custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReplicationGroup"}
   [credentials14583 & args14584]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14585
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14583)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14585
      deleteReplicationGroup
      (elasticache/delete-replication-group-request
       (clojure.core/nth args14584 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-subnet-group
   [m14586]
   (clojure.core/let
    [credentials14587 (:credentials m14586) args14588 (:args m14586)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14589
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14587)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14589
       createCacheSubnetGroup
       (elasticache/create-cache-subnet-group-request
        (clojure.core/nth args14588 0)))))))
  (clojure.core/defn
   create-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         subnet-ids
                         general-progress-listener
                         cache-subnet-group-description
                         clone-source
                         clone-root]}]]),
    :doc "Call createCacheSubnetGroup"}
   [credentials14591 & args14592]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14593
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14591)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14593
      createCacheSubnetGroup
      (elasticache/create-cache-subnet-group-request
       (clojure.core/nth args14592 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-cache-cluster
   [m14594]
   (clojure.core/let
    [credentials14595 (:credentials m14594) args14596 (:args m14594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14597
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14595)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14597
       modifyCacheCluster
       (elasticache/modify-cache-cluster-request
        (clojure.core/nth args14596 0)))))))
  (clojure.core/defn
   modify-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         azmode
                         num-cache-nodes
                         sdk-request-timeout
                         notification-topic-arn
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         cache-cluster-id
                         read-limit
                         cache-node-ids-to-remove
                         apply-immediately
                         general-progress-listener
                         snapshot-window
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         new-availability-zones
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyCacheCluster"}
   [credentials14599 & args14600]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14601
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14599)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14601
      modifyCacheCluster
      (elasticache/modify-cache-cluster-request
       (clojure.core/nth args14600 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :authorize-cache-security-group-ingress
   [m14602]
   (clojure.core/let
    [credentials14603 (:credentials m14602) args14604 (:args m14602)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14605
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14603)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14605
       authorizeCacheSecurityGroupIngress
       (elasticache/authorize-cache-security-group-ingress-request
        (clojure.core/nth args14604 0)))))))
  (clojure.core/defn
   authorize-cache-security-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeCacheSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-cache-security-group-ingress,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   authorize-cache-security-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeCacheSecurityGroupIngress"}
   [credentials14607 & args14608]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14609
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14607)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14609
      authorizeCacheSecurityGroupIngress
      (elasticache/authorize-cache-security-group-ingress-request
       (clojure.core/nth args14608 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-parameters
   [m14610]
   (clojure.core/let
    [credentials14611 (:credentials m14610) args14612 (:args m14610)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14613
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14611)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14613
       describeCacheParameters
       (elasticache/describe-cache-parameters-request
        (clojure.core/nth args14612 0)))))))
  (clojure.core/defn
   describe-cache-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for describeCacheParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-parameters,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call describeCacheParameters"}
   [credentials14615 & args14616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14617
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14615)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14617
      describeCacheParameters
      (elasticache/describe-cache-parameters-request
       (clojure.core/nth args14616 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-cluster
   [m14618]
   (clojure.core/let
    [credentials14619 (:credentials m14618) args14620 (:args m14618)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14621
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14619)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14621
       deleteCacheCluster
       (elasticache/delete-cache-cluster-request
        (clojure.core/nth args14620 0)))))))
  (clojure.core/defn
   delete-cache-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-cluster
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         final-snapshot-identifier
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheCluster"}
   [credentials14623 & args14624]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14625
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14623)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14625
      deleteCacheCluster
      (elasticache/delete-cache-cluster-request
       (clojure.core/nth args14624 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-allowed-node-type-modifications
   [m14626]
   (clojure.core/let
    [credentials14627 (:credentials m14626) args14628 (:args m14626)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14629
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14627)]
     (clojure.core/case
      (clojure.core/count args14628)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14629
        listAllowedNodeTypeModifications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14629
        listAllowedNodeTypeModifications
        (elasticache/list-allowed-node-type-modifications-request
         (clojure.core/nth args14628 0))))))))
  (clojure.core/defn
   list-allowed-node-type-modifications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-allowed-node-type-modifications,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-allowed-node-type-modifications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         replication-group-id
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAllowedNodeTypeModifications, listAllowedNodeTypeModifications"}
   [credentials14631 & args14632]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14633
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14631)]
    (clojure.core/case
     (clojure.core/count args14632)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14633
       listAllowedNodeTypeModifications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14633
       listAllowedNodeTypeModifications
       (elasticache/list-allowed-node-type-modifications-request
        (clojure.core/nth args14632 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-cache-parameter-group
   [m14634]
   (clojure.core/let
    [credentials14635 (:credentials m14634) args14636 (:args m14634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14637
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14637
       createCacheParameterGroup
       (elasticache/create-cache-parameter-group-request
        (clojure.core/nth args14636 0)))))))
  (clojure.core/defn
   create-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for createCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-parameter-group-family
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call createCacheParameterGroup"}
   [credentials14639 & args14640]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14641
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14639)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14641
      createCacheParameterGroup
      (elasticache/create-cache-parameter-group-request
       (clojure.core/nth args14640 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :modify-replication-group
   [m14642]
   (clojure.core/let
    [credentials14643 (:credentials m14642) args14644 (:args m14642)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14645
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14643)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14645
       modifyReplicationGroup
       (elasticache/modify-replication-group-request
        (clojure.core/nth args14644 0)))))))
  (clojure.core/defn
   modify-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for modifyReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   modify-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         custom-query-parameters
                         notification-topic-status
                         snapshotting-cluster-id
                         read-limit
                         apply-immediately
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         replication-group-description
                         cache-node-type
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         engine-version]}]]),
    :doc "Call modifyReplicationGroup"}
   [credentials14647 & args14648]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14649
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14647)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14649
      modifyReplicationGroup
      (elasticache/modify-replication-group-request
       (clojure.core/nth args14648 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :remove-tags-from-resource
   [m14650]
   (clojure.core/let
    [credentials14651 (:credentials m14650) args14652 (:args m14650)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14653
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14651)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14653
       removeTagsFromResource
       (elasticache/remove-tags-from-resource-request
        (clojure.core/nth args14652 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials14655 & args14656]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14657
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14655)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14657
      removeTagsFromResource
      (elasticache/remove-tags-from-resource-request
       (clojure.core/nth args14656 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-reserved-cache-nodes-offerings
   [m14658]
   (clojure.core/let
    [credentials14659 (:credentials m14658) args14660 (:args m14658)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14661
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14659)]
     (clojure.core/case
      (clojure.core/count args14660)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14661
        describeReservedCacheNodesOfferings
        (elasticache/describe-reserved-cache-nodes-offerings-request
         (clojure.core/nth args14660 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14661
        describeReservedCacheNodesOfferings))))))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-cache-nodes-offerings,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-reserved-cache-nodes-offerings
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         sdk-request-timeout
                         marker
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         duration
                         read-limit
                         product-description
                         general-progress-listener
                         cache-node-type
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeReservedCacheNodesOfferings, describeReservedCacheNodesOfferings"}
   [credentials14663 & args14664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14665
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14663)]
    (clojure.core/case
     (clojure.core/count args14664)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14665
       describeReservedCacheNodesOfferings
       (elasticache/describe-reserved-cache-nodes-offerings-request
        (clojure.core/nth args14664 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14665
       describeReservedCacheNodesOfferings))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-security-groups
   [m14666]
   (clojure.core/let
    [credentials14667 (:credentials m14666) args14668 (:args m14666)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14669
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14667)]
     (clojure.core/case
      (clojure.core/count args14668)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14669
        describeCacheSecurityGroups
        (elasticache/describe-cache-security-groups-request
         (clojure.core/nth args14668 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14669
        describeCacheSecurityGroups))))))
  (clojure.core/defn
   describe-cache-security-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeCacheSecurityGroups, describeCacheSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-security-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-security-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeCacheSecurityGroups, describeCacheSecurityGroups"}
   [credentials14671 & args14672]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14673
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14671)]
    (clojure.core/case
     (clojure.core/count args14672)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14673
       describeCacheSecurityGroups
       (elasticache/describe-cache-security-groups-request
        (clojure.core/nth args14672 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14673
       describeCacheSecurityGroups))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-replication-group
   [m14674]
   (clojure.core/let
    [credentials14675 (:credentials m14674) args14676 (:args m14674)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14677
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14675)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14677
       createReplicationGroup
       (elasticache/create-replication-group-request
        (clojure.core/nth args14676 0)))))))
  (clojure.core/defn
   create-replication-group-map
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Generate map for createReplicationGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-replication-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-replication-group
   {:arglists (quote
               [[credentials
                 {:keys [automatic-failover-enabled
                         security-group-ids
                         tags
                         preferred-cache-cluster-azs
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         notification-topic-arn
                         replication-group-id
                         cache-security-group-names
                         cache-subnet-group-name
                         custom-query-parameters
                         port
                         read-limit
                         snapshot-name
                         general-progress-listener
                         primary-cluster-id
                         snapshot-window
                         num-cache-clusters
                         replication-group-description
                         cache-node-type
                         engine
                         snapshot-retention-limit
                         clone-source
                         cache-parameter-group-name
                         auto-minor-version-upgrade
                         clone-root
                         snapshot-arns
                         engine-version]}]]),
    :doc "Call createReplicationGroup"}
   [credentials14679 & args14680]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14681
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14679)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14681
      createReplicationGroup
      (elasticache/create-replication-group-request
       (clojure.core/nth args14680 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :list-tags-for-resource
   [m14682]
   (clojure.core/let
    [credentials14683 (:credentials m14682) args14684 (:args m14682)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14685
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14683)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14685
       listTagsForResource
       (elasticache/list-tags-for-resource-request
        (clojure.core/nth args14684 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials14687 & args14688]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14689
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14687)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14689
      listTagsForResource
      (elasticache/list-tags-for-resource-request
       (clojure.core/nth args14688 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :reset-cache-parameter-group
   [m14690]
   (clojure.core/let
    [credentials14691 (:credentials m14690) args14692 (:args m14690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14693
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14691)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14693
       resetCacheParameterGroup
       (elasticache/reset-cache-parameter-group-request
        (clojure.core/nth args14692 0)))))))
  (clojure.core/defn
   reset-cache-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Generate map for resetCacheParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-cache-parameter-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   reset-cache-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         parameter-name-values
                         clone-source
                         reset-all-parameters
                         cache-parameter-group-name
                         clone-root]}]]),
    :doc "Call resetCacheParameterGroup"}
   [credentials14695 & args14696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14697
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14695)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14697
      resetCacheParameterGroup
      (elasticache/reset-cache-parameter-group-request
       (clojure.core/nth args14696 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-snapshots
   [m14698]
   (clojure.core/let
    [credentials14699 (:credentials m14698) args14700 (:args m14698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14701
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14699)]
     (clojure.core/case
      (clojure.core/count args14700)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14701
        describeSnapshots))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14701
        describeSnapshots
        (elasticache/describe-snapshots-request
         (clojure.core/nth args14700 0))))))))
  (clojure.core/defn
   describe-snapshots-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Generate map for describeSnapshots, describeSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-snapshots,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-snapshots
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root
                         snapshot-source]}]]),
    :doc "Call describeSnapshots, describeSnapshots"}
   [credentials14703 & args14704]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14705
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14703)]
    (clojure.core/case
     (clojure.core/count args14704)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14705
       describeSnapshots))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14705
       describeSnapshots
       (elasticache/describe-snapshots-request
        (clojure.core/nth args14704 0))))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-subnet-group
   [m14706]
   (clojure.core/let
    [credentials14707 (:credentials m14706) args14708 (:args m14706)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14709
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14707)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14709
       deleteCacheSubnetGroup
       (elasticache/delete-cache-subnet-group-request
        (clojure.core/nth args14708 0)))))))
  (clojure.core/defn
   delete-cache-subnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-subnet-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-subnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSubnetGroup"}
   [credentials14711 & args14712]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14713
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14711)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14713
      deleteCacheSubnetGroup
      (elasticache/delete-cache-subnet-group-request
       (clojure.core/nth args14712 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :create-snapshot
   [m14714]
   (clojure.core/let
    [credentials14715 (:credentials m14714) args14716 (:args m14714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14717
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14717
       createSnapshot
       (elasticache/create-snapshot-request
        (clojure.core/nth args14716 0)))))))
  (clojure.core/defn
   create-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-snapshot,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   create-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         cache-cluster-id
                         read-limit
                         snapshot-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createSnapshot"}
   [credentials14719 & args14720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14721
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14721
      createSnapshot
      (elasticache/create-snapshot-request
       (clojure.core/nth args14720 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :purchase-reserved-cache-nodes-offering
   [m14722]
   (clojure.core/let
    [credentials14723 (:credentials m14722) args14724 (:args m14722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14725
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14725
       purchaseReservedCacheNodesOffering
       (elasticache/purchase-reserved-cache-nodes-offering-request
        (clojure.core/nth args14724 0)))))))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedCacheNodesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-cache-nodes-offering,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   purchase-reserved-cache-nodes-offering
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-cache-node-id
                         cache-node-count
                         sdk-request-timeout
                         reserved-cache-nodes-offering-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedCacheNodesOffering"}
   [credentials14727 & args14728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14729
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14729
      purchaseReservedCacheNodesOffering
      (elasticache/purchase-reserved-cache-nodes-offering-request
       (clojure.core/nth args14728 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :delete-cache-security-group
   [m14730]
   (clojure.core/let
    [credentials14731 (:credentials m14730) args14732 (:args m14730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14733
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14731)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14733
       deleteCacheSecurityGroup
       (elasticache/delete-cache-security-group-request
        (clojure.core/nth args14732 0)))))))
  (clojure.core/defn
   delete-cache-security-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCacheSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cache-security-group,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   delete-cache-security-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         cache-security-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCacheSecurityGroup"}
   [credentials14735 & args14736]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14737
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14735)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14737
      deleteCacheSecurityGroup
      (elasticache/delete-cache-security-group-request
       (clojure.core/nth args14736 0)))))))
 (do
  (clojure.core/defmethod
   elasticache
   :describe-cache-subnet-groups
   [m14738]
   (clojure.core/let
    [credentials14739 (:credentials m14738) args14740 (:args m14738)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
      client14741
      (com.palletops.awaze.common/aws-client
       :elasticache
       credentials14739)]
     (clojure.core/case
      (clojure.core/count args14740)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14741
        describeCacheSubnetGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14741
        describeCacheSubnetGroups
        (elasticache/describe-cache-subnet-groups-request
         (clojure.core/nth args14740 0))))))))
  (clojure.core/defn
   describe-cache-subnet-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCacheSubnetGroups, describeCacheSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cache-subnet-groups,
     :credentials credentials__1842__auto__,
     :client :elasticache}))
  (clojure.core/defn
   describe-cache-subnet-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         cache-subnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCacheSubnetGroups, describeCacheSubnetGroups"}
   [credentials14743 & args14744]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
     client14745
     (com.palletops.awaze.common/aws-client
      :elasticache
      credentials14743)]
    (clojure.core/case
     (clojure.core/count args14744)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14745
       describeCacheSubnetGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticache.AmazonElastiCacheClient}
client14745
       describeCacheSubnetGroups
       (elasticache/describe-cache-subnet-groups-request
        (clojure.core/nth args14744 0)))))))))
