(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m10690]
  (clojure.core/let
   [bean10689
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/let
    [v10691
     (:namespace m10690 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10691 :com.palletops.awaze.client-builder/undef)
     (. bean10689 setNamespace (clojure.core/str v10691))))
   (clojure.core/let
    [v10691
     (:option-name m10690 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10691 :com.palletops.awaze.client-builder/undef)
     (. bean10689 setOptionName (clojure.core/str v10691))))
   (clojure.core/let
    [v10691
     (:resource-name m10690 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10691 :com.palletops.awaze.client-builder/undef)
     (. bean10689 setResourceName (clojure.core/str v10691))))
   bean10689))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m10693]
  (clojure.core/let
   [bean10692
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/let
    [v10694
     (:namespace m10693 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10694 :com.palletops.awaze.client-builder/undef)
     (. bean10692 setNamespace (clojure.core/str v10694))))
   (clojure.core/let
    [v10694
     (:option-name m10693 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10694 :com.palletops.awaze.client-builder/undef)
     (. bean10692 setOptionName (clojure.core/str v10694))))
   (clojure.core/let
    [v10694
     (:resource-name m10693 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10694 :com.palletops.awaze.client-builder/undef)
     (. bean10692 setResourceName (clojure.core/str v10694))))
   (clojure.core/let
    [v10694 (:value m10693 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10694 :com.palletops.awaze.client-builder/undef)
     (. bean10692 setValue (clojure.core/str v10694))))
   bean10692))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m10696]
  (clojure.core/let
   [bean10695
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/let
    [v10697
     (:application-name
      m10696
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10697 :com.palletops.awaze.client-builder/undef)
     (. bean10695 setApplicationName (clojure.core/str v10697))))
   (clojure.core/let
    [v10697
     (:template-name m10696 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10697 :com.palletops.awaze.client-builder/undef)
     (. bean10695 setTemplateName (clojure.core/str v10697))))
   bean10695))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m10699]
  (clojure.core/let
   [bean10698
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/let
    [v10700
     (:version m10699 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10700 :com.palletops.awaze.client-builder/undef)
     (. bean10698 setVersion (clojure.core/str v10700))))
   (clojure.core/let
    [v10700 (:type m10699 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10700 :com.palletops.awaze.client-builder/undef)
     (. bean10698 setType (clojure.core/str v10700))))
   (clojure.core/let
    [v10700 (:name m10699 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10700 :com.palletops.awaze.client-builder/undef)
     (. bean10698 setName (clojure.core/str v10700))))
   bean10698))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m10702]
  (clojure.core/let
   [bean10701
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/let
    [v10703
     (:s3bucket m10702 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10703 :com.palletops.awaze.client-builder/undef)
     (. bean10701 setS3Bucket (clojure.core/str v10703))))
   (clojure.core/let
    [v10703 (:s3key m10702 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10703 :com.palletops.awaze.client-builder/undef)
     (. bean10701 setS3Key (clojure.core/str v10703))))
   bean10701))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m10705]
  (clojure.core/let
   [bean10704 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/let
    [v10706 (:key m10705 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10706 :com.palletops.awaze.client-builder/undef)
     (. bean10704 setKey (clojure.core/str v10706))))
   (clojure.core/let
    [v10706 (:value m10705 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10706 :com.palletops.awaze.client-builder/undef)
     (. bean10704 setValue (clojure.core/str v10706))))
   bean10704))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m10708]
  (clojure.core/let
   [bean10707
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/let
    [v10709
     (:application-name
      m10708
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10709 :com.palletops.awaze.client-builder/undef)
     (. bean10707 setApplicationName (clojure.core/str v10709))))
   (clojure.core/let
    [v10709
     (:version-labels
      m10708
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10709 :com.palletops.awaze.client-builder/undef)
     (.
      bean10707
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10806] (clojure.core/str arg10806))
 v10709))))
   bean10707))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest}
compose-environments-request
  [m10711]
  (clojure.core/let
   [bean10710
    (new
     com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest)]
   (clojure.core/let
    [v10712
     (:application-name
      m10711
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (. bean10710 setApplicationName (clojure.core/str v10712))))
   (clojure.core/let
    [v10712
     (:version-labels
      m10711
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (.
      bean10710
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10807] (clojure.core/str arg10807))
 v10712))))
   (clojure.core/let
    [v10712
     (:group-name m10711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (. bean10710 setGroupName (clojure.core/str v10712))))
   bean10710))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m10714]
  (clojure.core/let
   [bean10713
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/let
    [v10715
     (:environment-name
      m10714
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setEnvironmentName (clojure.core/str v10715))))
   (clojure.core/let
    [v10715
     (:environment-id
      m10714
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setEnvironmentId (clojure.core/str v10715))))
   bean10713))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m10717]
  (clojure.core/let
   [bean10716
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/let
    [v10718
     (:application-name
      m10717
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setApplicationName (clojure.core/str v10718))))
   (clojure.core/let
    [v10718
     (:version-label m10717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setVersionLabel (clojure.core/str v10718))))
   (clojure.core/let
    [v10718
     (:description m10717 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10718 :com.palletops.awaze.client-builder/undef)
     (. bean10716 setDescription (clojure.core/str v10718))))
   bean10716))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m10720]
  (clojure.core/let
   [bean10719
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/let
    [v10721
     (:application-name
      m10720
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10721 :com.palletops.awaze.client-builder/undef)
     (. bean10719 setApplicationName (clojure.core/str v10721))))
   (clojure.core/let
    [v10721
     (:environment-name
      m10720
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10721 :com.palletops.awaze.client-builder/undef)
     (. bean10719 setEnvironmentName (clojure.core/str v10721))))
   bean10719))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m10723]
  (clojure.core/let
   [bean10722
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/let
    [v10724
     (:start-time m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (.
      bean10722
      setStartTime
      (com.palletops.awaze.common/to-date v10724))))
   (clojure.core/let
    [v10724
     (:version-label m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setVersionLabel (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:template-name m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setTemplateName (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:environment-name
      m10723
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setEnvironmentName (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:max-records m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setMaxRecords (clojure.core/int v10724))))
   (clojure.core/let
    [v10724
     (:severity m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setSeverity (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:end-time m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (.
      bean10722
      setEndTime
      (com.palletops.awaze.common/to-date v10724))))
   (clojure.core/let
    [v10724
     (:request-id m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setRequestId (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:environment-id
      m10723
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setEnvironmentId (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:next-token m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setNextToken (clojure.core/str v10724))))
   (clojure.core/let
    [v10724
     (:application-name
      m10723
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setApplicationName (clojure.core/str v10724))))
   bean10722))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m10726]
  (clojure.core/let
   [bean10725
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/let
    [v10727
     (:application-name
      m10726
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10727 :com.palletops.awaze.client-builder/undef)
     (. bean10725 setApplicationName (clojure.core/str v10727))))
   (clojure.core/let
    [v10727
     (:template-name m10726 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10727 :com.palletops.awaze.client-builder/undef)
     (. bean10725 setTemplateName (clojure.core/str v10727))))
   (clojure.core/let
    [v10727
     (:environment-name
      m10726
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10727 :com.palletops.awaze.client-builder/undef)
     (. bean10725 setEnvironmentName (clojure.core/str v10727))))
   bean10725))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m10729]
  (clojure.core/let
   [bean10728
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/let
    [v10730
     (:environment-name
      m10729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setEnvironmentName (clojure.core/str v10730))))
   (clojure.core/let
    [v10730
     (:terminate-resources
      m10729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setTerminateResources (clojure.core/boolean v10730))))
   (clojure.core/let
    [v10730
     (:force-terminate
      m10729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setForceTerminate (clojure.core/boolean v10730))))
   (clojure.core/let
    [v10730
     (:environment-id
      m10729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setEnvironmentId (clojure.core/str v10730))))
   bean10728))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m10732]
  (clojure.core/let
   [bean10731
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/let
    [v10733
     (:application-name
      m10732
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setApplicationName (clojure.core/str v10733))))
   (clojure.core/let
    [v10733
     (:template-name m10732 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setTemplateName (clojure.core/str v10733))))
   (clojure.core/let
    [v10733
     (:environment-name
      m10732
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setEnvironmentName (clojure.core/str v10733))))
   (clojure.core/let
    [v10733
     (:solution-stack-name
      m10732
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setSolutionStackName (clojure.core/str v10733))))
   (clojure.core/let
    [v10733
     (:options m10732 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (.
      bean10731
      setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10808]
  (elasticbeanstalk/option-specification arg10808))
 v10733))))
   bean10731))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m10735]
  (clojure.core/let
   [bean10734
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10736
     (:option-settings
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (.
      bean10734
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10809]
  (elasticbeanstalk/configuration-option-setting arg10809))
 v10736))))
   (clojure.core/let
    [v10736
     (:application-name
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setApplicationName (clojure.core/str v10736))))
   (clojure.core/let
    [v10736
     (:template-name m10735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setTemplateName (clojure.core/str v10736))))
   (clojure.core/let
    [v10736
     (:solution-stack-name
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setSolutionStackName (clojure.core/str v10736))))
   (clojure.core/let
    [v10736
     (:source-configuration
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (.
      bean10734
      setSourceConfiguration
      (elasticbeanstalk/source-configuration v10736))))
   (clojure.core/let
    [v10736
     (:description m10735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setDescription (clojure.core/str v10736))))
   (clojure.core/let
    [v10736
     (:environment-id
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setEnvironmentId (clojure.core/str v10736))))
   bean10734))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m10738]
  (clojure.core/let
   [bean10737
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/let
    [v10739
     (:option-settings
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (.
      bean10737
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10810]
  (elasticbeanstalk/configuration-option-setting arg10810))
 v10739))))
   (clojure.core/let
    [v10739
     (:description m10738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setDescription (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:solution-stack-name
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setSolutionStackName (clojure.core/str v10739))))
   (clojure.core/let
    [v10739 (:tier m10738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setTier (elasticbeanstalk/environment-tier v10739))))
   (clojure.core/let
    [v10739
     (:version-label m10738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setVersionLabel (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:template-name m10738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setTemplateName (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:environment-name
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setEnvironmentName (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:options-to-remove
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (.
      bean10737
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10811]
  (elasticbeanstalk/option-specification arg10811))
 v10739))))
   (clojure.core/let
    [v10739
     (:group-name m10738 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setGroupName (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:environment-id
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setEnvironmentId (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:application-name
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setApplicationName (clojure.core/str v10739))))
   bean10737))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m10741]
  (clojure.core/let
   [bean10740
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/let
    [v10742
     (:application-names
      m10741
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (.
      bean10740
      setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10812] (clojure.core/str arg10812))
 v10742))))
   bean10740))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m10744]
  (clojure.core/let
   [bean10743
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean10743))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m10747]
  (clojure.core/let
   [bean10746
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/let
    [v10748
     (:environment-name
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setEnvironmentName (clojure.core/str v10748))))
   (clojure.core/let
    [v10748
     (:environment-id
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setEnvironmentId (clojure.core/str v10748))))
   bean10746))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m10750]
  (clojure.core/let
   [bean10749
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/let
    [v10751
     (:application-name
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setApplicationName (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:terminate-env-by-force
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (.
      bean10749
      setTerminateEnvByForce
      (clojure.core/boolean v10751))))
   bean10749))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m10753]
  (clojure.core/let
   [bean10752
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/let
    [v10754
     (:application-name
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setApplicationName (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:description m10753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setDescription (clojure.core/str v10754))))
   bean10752))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m10756]
  (clojure.core/let
   [bean10755
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/let
    [v10757
     (:application-name
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setApplicationName (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:template-name m10756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setTemplateName (clojure.core/str v10757))))
   bean10755))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m10759]
  (clojure.core/let
   [bean10758
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/let
    [v10760
     (:source-environment-id
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (. bean10758 setSourceEnvironmentId (clojure.core/str v10760))))
   (clojure.core/let
    [v10760
     (:source-environment-name
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (. bean10758 setSourceEnvironmentName (clojure.core/str v10760))))
   (clojure.core/let
    [v10760
     (:destination-environment-id
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (.
      bean10758
      setDestinationEnvironmentId
      (clojure.core/str v10760))))
   (clojure.core/let
    [v10760
     (:destination-environment-name
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (.
      bean10758
      setDestinationEnvironmentName
      (clojure.core/str v10760))))
   bean10758))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest}
describe-environment-health-request
  [m10762]
  (clojure.core/let
   [bean10761
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest)]
   (clojure.core/let
    [v10763
     (:environment-name
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setEnvironmentName (clojure.core/str v10763))))
   (clojure.core/let
    [v10763
     (:attribute-names
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (.
      bean10761
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10813] (clojure.core/str arg10813))
 v10763))))
   (clojure.core/let
    [v10763
     (:environment-id
      m10762
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10763 :com.palletops.awaze.client-builder/undef)
     (. bean10761 setEnvironmentId (clojure.core/str v10763))))
   bean10761))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest}
abort-environment-update-request
  [m10765]
  (clojure.core/let
   [bean10764
    (new
     com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest)]
   (clojure.core/let
    [v10766
     (:environment-name
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setEnvironmentName (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:environment-id
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setEnvironmentId (clojure.core/str v10766))))
   bean10764))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m10768]
  (clojure.core/let
   [bean10767
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/let
    [v10769
     (:cnameprefix m10768 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10769 :com.palletops.awaze.client-builder/undef)
     (. bean10767 setCNAMEPrefix (clojure.core/str v10769))))
   bean10767))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m10771]
  (clojure.core/let
   [bean10770
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/let
    [v10772
     (:environment-name
      m10771
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10772 :com.palletops.awaze.client-builder/undef)
     (. bean10770 setEnvironmentName (clojure.core/str v10772))))
   (clojure.core/let
    [v10772
     (:info-type m10771 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10772 :com.palletops.awaze.client-builder/undef)
     (. bean10770 setInfoType (clojure.core/str v10772))))
   (clojure.core/let
    [v10772
     (:environment-id
      m10771
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10772 :com.palletops.awaze.client-builder/undef)
     (. bean10770 setEnvironmentId (clojure.core/str v10772))))
   bean10770))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m10774]
  (clojure.core/let
   [bean10773
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/let
    [v10775
     (:application-name
      m10774
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setApplicationName (clojure.core/str v10775))))
   (clojure.core/let
    [v10775
     (:version-label m10774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setVersionLabel (clojure.core/str v10775))))
   (clojure.core/let
    [v10775
     (:process m10774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setProcess (clojure.core/boolean v10775))))
   (clojure.core/let
    [v10775
     (:source-bundle m10774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (.
      bean10773
      setSourceBundle
      (elasticbeanstalk/s3location v10775))))
   (clojure.core/let
    [v10775
     (:auto-create-application
      m10774
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (.
      bean10773
      setAutoCreateApplication
      (clojure.core/boolean v10775))))
   (clojure.core/let
    [v10775
     (:description m10774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setDescription (clojure.core/str v10775))))
   bean10773))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m10777]
  (clojure.core/let
   [bean10776
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/let
    [v10778
     (:application-name
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (. bean10776 setApplicationName (clojure.core/str v10778))))
   (clojure.core/let
    [v10778
     (:version-label m10777 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (. bean10776 setVersionLabel (clojure.core/str v10778))))
   (clojure.core/let
    [v10778
     (:environment-ids
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (.
      bean10776
      setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10814] (clojure.core/str arg10814))
 v10778))))
   (clojure.core/let
    [v10778
     (:environment-names
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (.
      bean10776
      setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10815] (clojure.core/str arg10815))
 v10778))))
   (clojure.core/let
    [v10778
     (:include-deleted
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (. bean10776 setIncludeDeleted (clojure.core/boolean v10778))))
   (clojure.core/let
    [v10778
     (:included-deleted-back-to
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (.
      bean10776
      setIncludedDeletedBackTo
      (com.palletops.awaze.common/to-date v10778))))
   bean10776))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m10780]
  (clojure.core/let
   [bean10779
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10781
     (:option-settings
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (.
      bean10779
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10872]
  (elasticbeanstalk/configuration-option-setting arg10872))
 v10781))))
   (clojure.core/let
    [v10781
     (:application-name
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setApplicationName (clojure.core/str v10781))))
   (clojure.core/let
    [v10781
     (:template-name m10780 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setTemplateName (clojure.core/str v10781))))
   (clojure.core/let
    [v10781
     (:description m10780 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setDescription (clojure.core/str v10781))))
   (clojure.core/let
    [v10781
     (:options-to-remove
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (.
      bean10779
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10873]
  (elasticbeanstalk/option-specification arg10873))
 v10781))))
   bean10779))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m10783]
  (clojure.core/let
   [bean10782
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/let
    [v10784
     (:environment-name
      m10783
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10784 :com.palletops.awaze.client-builder/undef)
     (. bean10782 setEnvironmentName (clojure.core/str v10784))))
   (clojure.core/let
    [v10784
     (:environment-id
      m10783
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10784 :com.palletops.awaze.client-builder/undef)
     (. bean10782 setEnvironmentId (clojure.core/str v10784))))
   bean10782))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m10786]
  (clojure.core/let
   [bean10785
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean10785))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m10789]
  (clojure.core/let
   [bean10788
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/let
    [v10790
     (:option-settings
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (.
      bean10788
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10874]
  (elasticbeanstalk/configuration-option-setting arg10874))
 v10790))))
   (clojure.core/let
    [v10790
     (:application-name
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setApplicationName (clojure.core/str v10790))))
   (clojure.core/let
    [v10790
     (:template-name m10789 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setTemplateName (clojure.core/str v10790))))
   (clojure.core/let
    [v10790
     (:environment-name
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setEnvironmentName (clojure.core/str v10790))))
   bean10788))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest}
describe-instances-health-request
  [m10792]
  (clojure.core/let
   [bean10791
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest)]
   (clojure.core/let
    [v10793
     (:environment-name
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setEnvironmentName (clojure.core/str v10793))))
   (clojure.core/let
    [v10793
     (:attribute-names
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (.
      bean10791
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10875] (clojure.core/str arg10875))
 v10793))))
   (clojure.core/let
    [v10793
     (:next-token m10792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setNextToken (clojure.core/str v10793))))
   (clojure.core/let
    [v10793
     (:environment-id
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setEnvironmentId (clojure.core/str v10793))))
   bean10791))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m10795]
  (clojure.core/let
   [bean10794
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/let
    [v10796
     (:application-name
      m10795
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (. bean10794 setApplicationName (clojure.core/str v10796))))
   (clojure.core/let
    [v10796
     (:description m10795 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (. bean10794 setDescription (clojure.core/str v10796))))
   bean10794))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m10798]
  (clojure.core/let
   [bean10797
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/let
    [v10799
     (:environment-name
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setEnvironmentName (clojure.core/str v10799))))
   (clojure.core/let
    [v10799
     (:info-type m10798 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setInfoType (clojure.core/str v10799))))
   (clojure.core/let
    [v10799
     (:environment-id
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setEnvironmentId (clojure.core/str v10799))))
   bean10797))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m10801]
  (clojure.core/let
   [bean10800
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/let
    [v10802
     (:option-settings
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (.
      bean10800
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10876]
  (elasticbeanstalk/configuration-option-setting arg10876))
 v10802))))
   (clojure.core/let
    [v10802
     (:description m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setDescription (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:cnameprefix m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setCNAMEPrefix (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:solution-stack-name
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setSolutionStackName (clojure.core/str v10802))))
   (clojure.core/let
    [v10802 (:tier m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setTier (elasticbeanstalk/environment-tier v10802))))
   (clojure.core/let
    [v10802
     (:version-label m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setVersionLabel (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:template-name m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setTemplateName (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:environment-name
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setEnvironmentName (clojure.core/str v10802))))
   (clojure.core/let
    [v10802 (:tags m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (.
      bean10800
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10877] (elasticbeanstalk/tag arg10877))
 v10802))))
   (clojure.core/let
    [v10802
     (:options-to-remove
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (.
      bean10800
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10878]
  (elasticbeanstalk/option-specification arg10878))
 v10802))))
   (clojure.core/let
    [v10802
     (:group-name m10801 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setGroupName (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:application-name
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setApplicationName (clojure.core/str v10802))))
   bean10800))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m10804]
  (clojure.core/let
   [bean10803
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/let
    [v10805
     (:application-name
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (. bean10803 setApplicationName (clojure.core/str v10805))))
   (clojure.core/let
    [v10805
     (:version-label m10804 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (. bean10803 setVersionLabel (clojure.core/str v10805))))
   (clojure.core/let
    [v10805
     (:delete-source-bundle
      m10804
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10805 :com.palletops.awaze.client-builder/undef)
     (. bean10803 setDeleteSourceBundle (clojure.core/boolean v10805))))
   bean10803))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m10816]
   (clojure.core/let
    [credentials10817 (:credentials m10816) args10818 (:args m10816)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10819
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10817)]
     (clojure.core/case
      (clojure.core/count args10818)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10819
        describeApplicationVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10819
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args10818 0))))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials10821 & args10822]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10823
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10821)]
    (clojure.core/case
     (clojure.core/count args10822)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10823
       describeApplicationVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10823
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args10822 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :compose-environments
   [m10824]
   (clojure.core/let
    [credentials10825 (:credentials m10824) args10826 (:args m10824)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10827
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10825)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10827
       composeEnvironments
       (elasticbeanstalk/compose-environments-request
        (clojure.core/nth args10826 0)))))))
  (clojure.core/defn
   compose-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for composeEnvironments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :compose-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   compose-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call composeEnvironments"}
   [credentials10829 & args10830]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10831
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10829)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10831
      composeEnvironments
      (elasticbeanstalk/compose-environments-request
       (clojure.core/nth args10830 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m10832]
   (clojure.core/let
    [credentials10833 (:credentials m10832) args10834 (:args m10832)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10835
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10833)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10835
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args10834 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rebuild-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials10837 & args10838]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10839
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10837)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10839
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args10838 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m10840]
   (clojure.core/let
    [credentials10841 (:credentials m10840) args10842 (:args m10840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10843
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10841)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10843
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args10842 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials10845 & args10846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10847
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10847
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args10846 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m10848]
   (clojure.core/let
    [credentials10849 (:credentials m10848) args10850 (:args m10848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10851
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10849)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10851
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args10850 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-environment-configuration,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials10853 & args10854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10855
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10853)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10855
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args10854 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m10856]
   (clojure.core/let
    [credentials10857 (:credentials m10856) args10858 (:args m10856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10859
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10857)]
     (clojure.core/case
      (clojure.core/count args10858)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10859
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args10858 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10859
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials10861 & args10862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10863
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10861)]
    (clojure.core/case
     (clojure.core/count args10862)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10863
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args10862 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10863
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m10864]
   (clojure.core/let
    [credentials10865 (:credentials m10864) args10866 (:args m10864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10867
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10867
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args10866 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials10869 & args10870]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10871
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10869)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10871
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args10870 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m10879]
   (clojure.core/let
    [credentials10880 (:credentials m10879) args10881 (:args m10879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10882
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10880)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10882
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args10881 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call terminateEnvironment"}
   [credentials10884 & args10885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10886
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10884)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10886
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args10885 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m10887]
   (clojure.core/let
    [credentials10888 (:credentials m10887) args10889 (:args m10887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10890
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10888)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10890
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args10889 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-options,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials10892 & args10893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10894
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10892)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10894
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args10893 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m10895]
   (clojure.core/let
    [credentials10896 (:credentials m10895) args10897 (:args m10895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10898
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10896)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10898
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args10897 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials10900 & args10901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10902
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10900)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10902
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args10901 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m10903]
   (clojure.core/let
    [credentials10904 (:credentials m10903) args10905 (:args m10903)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10906
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10904)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10906
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args10905 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call updateEnvironment"}
   [credentials10908 & args10909]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10910
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10908)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10910
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args10909 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m10911]
   (clojure.core/let
    [credentials10912 (:credentials m10911) args10913 (:args m10911)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10914
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10912)]
     (clojure.core/case
      (clojure.core/count args10913)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10914
        describeApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10914
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args10913 0))))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials10916 & args10917]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10918
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10916)]
    (clojure.core/case
     (clojure.core/count args10917)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10918
       describeApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10918
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args10917 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m10919]
   (clojure.core/let
    [credentials10920 (:credentials m10919) args10921 (:args m10919)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10922
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10920)]
     (clojure.core/case
      (clojure.core/count args10921)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10922
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args10921 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10922
        createStorageLocation))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials10924 & args10925]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10926
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10924)]
    (clojure.core/case
     (clojure.core/count args10925)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10926
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args10925 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10926
       createStorageLocation))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m10927]
   (clojure.core/let
    [credentials10928 (:credentials m10927) args10929 (:args m10927)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10930
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10928)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10930
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args10929 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restart-app-server,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call restartAppServer"}
   [credentials10932 & args10933]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10934
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10932)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10934
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args10933 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m10935]
   (clojure.core/let
    [credentials10936 (:credentials m10935) args10937 (:args m10935)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10938
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10936)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10938
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args10937 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplication"}
   [credentials10940 & args10941]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10942
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10940)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10942
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args10941 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m10943]
   (clojure.core/let
    [credentials10944 (:credentials m10943) args10945 (:args m10943)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10946
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10944)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10946
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args10945 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createApplication"}
   [credentials10948 & args10949]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10950
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10948)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10950
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args10949 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m10951]
   (clojure.core/let
    [credentials10952 (:credentials m10951) args10953 (:args m10951)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10954
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10952)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10954
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args10953 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials10956 & args10957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10958
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10956)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10958
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args10957 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m10959]
   (clojure.core/let
    [credentials10960 (:credentials m10959) args10961 (:args m10959)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10962
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10960)]
     (clojure.core/case
      (clojure.core/count args10961)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10962
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args10961 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10962
        swapEnvironmentCNAMEs))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]
                [credentials]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]
                [credentials]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials10964 & args10965]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10966
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10964)]
    (clojure.core/case
     (clojure.core/count args10965)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10966
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args10965 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10966
       swapEnvironmentCNAMEs))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-health
   [m10967]
   (clojure.core/let
    [credentials10968 (:credentials m10967) args10969 (:args m10967)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10970
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10968)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10970
       describeEnvironmentHealth
       (elasticbeanstalk/describe-environment-health-request
        (clojure.core/nth args10969 0)))))))
  (clojure.core/defn
   describe-environment-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentHealth"}
   [credentials10972 & args10973]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10974
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10972)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10974
      describeEnvironmentHealth
      (elasticbeanstalk/describe-environment-health-request
       (clojure.core/nth args10973 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :abort-environment-update
   [m10975]
   (clojure.core/let
    [credentials10976 (:credentials m10975) args10977 (:args m10975)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10978
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10976)]
     (clojure.core/case
      (clojure.core/count args10977)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10978
        abortEnvironmentUpdate))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10978
        abortEnvironmentUpdate
        (elasticbeanstalk/abort-environment-update-request
         (clojure.core/nth args10977 0))))))))
  (clojure.core/defn
   abort-environment-update-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for abortEnvironmentUpdate, abortEnvironmentUpdate"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   abort-environment-update
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call abortEnvironmentUpdate, abortEnvironmentUpdate"}
   [credentials10980 & args10981]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10982
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10980)]
    (clojure.core/case
     (clojure.core/count args10981)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10982
       abortEnvironmentUpdate))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10982
       abortEnvironmentUpdate
       (elasticbeanstalk/abort-environment-update-request
        (clojure.core/nth args10981 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m10983]
   (clojure.core/let
    [credentials10984 (:credentials m10983) args10985 (:args m10983)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10986
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10984)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10986
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args10985 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :check-dnsavailability,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials10988 & args10989]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10990
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10988)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10990
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args10989 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m10991]
   (clojure.core/let
    [credentials10992 (:credentials m10991) args10993 (:args m10991)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10994
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10992)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10994
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args10993 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials10996 & args10997]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10998
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10996)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10998
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args10997 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m10999]
   (clojure.core/let
    [credentials11000 (:credentials m10999) args11001 (:args m10999)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11002
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11000)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11002
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args11001 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Call createApplicationVersion"}
   [credentials11004 & args11005]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11006
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11004)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11006
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args11005 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m11007]
   (clojure.core/let
    [credentials11008 (:credentials m11007) args11009 (:args m11007)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11010
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11008)]
     (clojure.core/case
      (clojure.core/count args11009)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11010
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args11009 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11010
        describeEnvironments))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]
                [credentials]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]
                [credentials]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials11012 & args11013]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11014
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11012)]
    (clojure.core/case
     (clojure.core/count args11013)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11014
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args11013 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11014
       describeEnvironments))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m11015]
   (clojure.core/let
    [credentials11016 (:credentials m11015) args11017 (:args m11015)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11018
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11016)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11018
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args11017 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials11020 & args11021]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11022
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11020)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11022
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args11021 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m11023]
   (clojure.core/let
    [credentials11024 (:credentials m11023) args11025 (:args m11023)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11026
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11024)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11026
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args11025 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-resources,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials11028 & args11029]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11030
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11028)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11030
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args11029 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m11031]
   (clojure.core/let
    [credentials11032 (:credentials m11031) args11033 (:args m11031)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11034
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11032)]
     (clojure.core/case
      (clojure.core/count args11033)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11034
        listAvailableSolutionStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11034
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args11033 0))))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials11036 & args11037]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11038
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11036)]
    (clojure.core/case
     (clojure.core/count args11037)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11038
       listAvailableSolutionStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11038
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args11037 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m11039]
   (clojure.core/let
    [credentials11040 (:credentials m11039) args11041 (:args m11039)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11042
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11040)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11042
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args11041 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials11044 & args11045]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11046
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11044)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11046
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args11045 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-instances-health
   [m11047]
   (clojure.core/let
    [credentials11048 (:credentials m11047) args11049 (:args m11047)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11050
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11048)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11050
       describeInstancesHealth
       (elasticbeanstalk/describe-instances-health-request
        (clojure.core/nth args11049 0)))))))
  (clojure.core/defn
   describe-instances-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstancesHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-instances-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstancesHealth"}
   [credentials11052 & args11053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11054
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11052)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11054
      describeInstancesHealth
      (elasticbeanstalk/describe-instances-health-request
       (clojure.core/nth args11053 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m11055]
   (clojure.core/let
    [credentials11056 (:credentials m11055) args11057 (:args m11055)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11058
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11056)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11058
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args11057 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplication"}
   [credentials11060 & args11061]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11062
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11060)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11062
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args11061 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m11063]
   (clojure.core/let
    [credentials11064 (:credentials m11063) args11065 (:args m11063)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11066
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11064)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11066
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args11065 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials11068 & args11069]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11070
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11068)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11070
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args11069 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m11071]
   (clojure.core/let
    [credentials11072 (:credentials m11071) args11073 (:args m11071)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11074
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11072)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11074
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args11073 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call createEnvironment"}
   [credentials11076 & args11077]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11078
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11076)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11078
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args11077 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m11079]
   (clojure.core/let
    [credentials11080 (:credentials m11079) args11081 (:args m11079)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11082
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11080)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11082
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args11081 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials11084 & args11085]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11086
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11084)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11086
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args11085 0))))))))
