(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4535]
  (clojure.core/let
   [bean4534
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/let
    [v4536 (:enabled m4535 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4536 :com.palletops.awaze.client-builder/undef)
     (. bean4534 setEnabled (clojure.core/boolean v4536))))
   bean4534))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4538]
  (clojure.core/let
   [bean4537
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/let
    [v4539
     (:s3bucket-name m4538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4539 :com.palletops.awaze.client-builder/undef)
     (. bean4537 setS3BucketName (clojure.core/str v4539))))
   (clojure.core/let
    [v4539
     (:emit-interval m4538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4539 :com.palletops.awaze.client-builder/undef)
     (. bean4537 setEmitInterval (clojure.core/int v4539))))
   (clojure.core/let
    [v4539
     (:s3bucket-prefix
      m4538
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4539 :com.palletops.awaze.client-builder/undef)
     (. bean4537 setS3BucketPrefix (clojure.core/str v4539))))
   (clojure.core/let
    [v4539 (:enabled m4538 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4539 :com.palletops.awaze.client-builder/undef)
     (. bean4537 setEnabled (clojure.core/boolean v4539))))
   bean4537))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4541]
  (clojure.core/let
   [bean4540
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/let
    [v4542 (:timeout m4541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4542 :com.palletops.awaze.client-builder/undef)
     (. bean4540 setTimeout (clojure.core/int v4542))))
   (clojure.core/let
    [v4542 (:enabled m4541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4542 :com.palletops.awaze.client-builder/undef)
     (. bean4540 setEnabled (clojure.core/boolean v4542))))
   bean4540))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings}
connection-settings
  [m4544]
  (clojure.core/let
   [bean4543
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings)]
   (clojure.core/let
    [v4545
     (:idle-timeout m4544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (. bean4543 setIdleTimeout (clojure.core/int v4545))))
   bean4543))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute}
additional-attribute
  [m4547]
  (clojure.core/let
   [bean4546
    (new
     com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute)]
   (clojure.core/let
    [v4548 (:key m4547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4548 :com.palletops.awaze.client-builder/undef)
     (. bean4546 setKey (clojure.core/str v4548))))
   (clojure.core/let
    [v4548 (:value m4547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4548 :com.palletops.awaze.client-builder/undef)
     (. bean4546 setValue (clojure.core/str v4548))))
   bean4546))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Tag}
tag
  [m4550]
  (clojure.core/let
   [bean4549
    (new com.amazonaws.services.elasticloadbalancing.model.Tag)]
   (clojure.core/let
    [v4551 (:key m4550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4551 :com.palletops.awaze.client-builder/undef)
     (. bean4549 setKey (clojure.core/str v4551))))
   (clojure.core/let
    [v4551 (:value m4550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4551 :com.palletops.awaze.client-builder/undef)
     (. bean4549 setValue (clojure.core/str v4551))))
   bean4549))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4553]
  (clojure.core/let
   [bean4552
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/let
    [v4554
     (:protocol m4553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setProtocol (clojure.core/str v4554))))
   (clojure.core/let
    [v4554
     (:load-balancer-port
      m4553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setLoadBalancerPort (clojure.core/int v4554))))
   (clojure.core/let
    [v4554
     (:sslcertificate-id
      m4553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setSSLCertificateId (clojure.core/str v4554))))
   (clojure.core/let
    [v4554
     (:instance-port m4553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setInstancePort (clojure.core/int v4554))))
   (clojure.core/let
    [v4554
     (:instance-protocol
      m4553
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setInstanceProtocol (clojure.core/str v4554))))
   bean4552))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly}
tag-key-only
  [m4556]
  (clojure.core/let
   [bean4555
    (new com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly)]
   (clojure.core/let
    [v4557 (:key m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setKey (clojure.core/str v4557))))
   bean4555))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4559]
  (clojure.core/let
   [bean4558
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/let
    [v4560
     (:attribute-name m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setAttributeName (clojure.core/str v4560))))
   (clojure.core/let
    [v4560
     (:attribute-value
      m4559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setAttributeValue (clojure.core/str v4560))))
   bean4558))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4562]
  (clojure.core/let
   [bean4561
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/let
    [v4563
     (:instance-id m4562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4563 :com.palletops.awaze.client-builder/undef)
     (. bean4561 setInstanceId (clojure.core/str v4563))))
   bean4561))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4565]
  (clojure.core/let
   [bean4564
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/let
    [v4566
     (:cross-zone-load-balancing
      m4565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (.
      bean4564
      setCrossZoneLoadBalancing
      (elasticloadbalancing/cross-zone-load-balancing v4566))))
   (clojure.core/let
    [v4566
     (:access-log m4565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setAccessLog (elasticloadbalancing/access-log v4566))))
   (clojure.core/let
    [v4566
     (:connection-draining
      m4565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (.
      bean4564
      setConnectionDraining
      (elasticloadbalancing/connection-draining v4566))))
   (clojure.core/let
    [v4566
     (:connection-settings
      m4565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (.
      bean4564
      setConnectionSettings
      (elasticloadbalancing/connection-settings v4566))))
   (clojure.core/let
    [v4566
     (:additional-attributes
      m4565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (.
      bean4564
      setAdditionalAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4654]
  (elasticloadbalancing/additional-attribute arg4654))
 v4566))))
   bean4564))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4568]
  (clojure.core/let
   [bean4567
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/let
    [v4569 (:timeout m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setTimeout (clojure.core/int v4569))))
   (clojure.core/let
    [v4569
     (:unhealthy-threshold
      m4568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setUnhealthyThreshold (clojure.core/int v4569))))
   (clojure.core/let
    [v4569
     (:healthy-threshold
      m4568
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setHealthyThreshold (clojure.core/int v4569))))
   (clojure.core/let
    [v4569
     (:interval m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setInterval (clojure.core/int v4569))))
   (clojure.core/let
    [v4569 (:target m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setTarget (clojure.core/str v4569))))
   bean4567))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4571]
  (clojure.core/let
   [bean4570
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/let
    [v4572
     (:security-groups
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4655] (clojure.core/str arg4655))
 v4572))))
   (clojure.core/let
    [v4572 (:tags m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4656] (elasticloadbalancing/tag arg4656))
 v4572))))
   (clojure.core/let
    [v4572
     (:listeners m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4657] (elasticloadbalancing/listener arg4657))
 v4572))))
   (clojure.core/let
    [v4572 (:scheme m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setScheme (clojure.core/str v4572))))
   (clojure.core/let
    [v4572 (:subnets m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4658] (clojure.core/str arg4658))
 v4572))))
   (clojure.core/let
    [v4572
     (:load-balancer-name
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setLoadBalancerName (clojure.core/str v4572))))
   (clojure.core/let
    [v4572
     (:availability-zones
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4659] (clojure.core/str arg4659))
 v4572))))
   bean4570))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4574]
  (clojure.core/let
   [bean4573
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4575
     (:load-balancer-ports
      m4574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (.
      bean4573
      setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4660] (clojure.core/int arg4660))
 v4575))))
   (clojure.core/let
    [v4575
     (:load-balancer-name
      m4574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setLoadBalancerName (clojure.core/str v4575))))
   bean4573))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4577]
  (clojure.core/let
   [bean4576
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4578
     (:load-balancer-name
      m4577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (. bean4576 setLoadBalancerName (clojure.core/str v4578))))
   (clojure.core/let
    [v4578
     (:availability-zones
      m4577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (.
      bean4576
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4661] (clojure.core/str arg4661))
 v4578))))
   bean4576))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4580]
  (clojure.core/let
   [bean4579
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v4581 (:marker m4580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (. bean4579 setMarker (clojure.core/str v4581))))
   (clojure.core/let
    [v4581
     (:load-balancer-names
      m4580
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (.
      bean4579
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4662] (clojure.core/str arg4662))
 v4581))))
   (clojure.core/let
    [v4581
     (:page-size m4580 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (. bean4579 setPageSize (clojure.core/int v4581))))
   bean4579))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4583]
  (clojure.core/let
   [bean4582
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4584
     (:policy-name m4583 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (. bean4582 setPolicyName (clojure.core/str v4584))))
   (clojure.core/let
    [v4584
     (:load-balancer-name
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (. bean4582 setLoadBalancerName (clojure.core/str v4584))))
   bean4582))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4586]
  (clojure.core/let
   [bean4585
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/let
    [v4587
     (:policy-names m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (.
      bean4585
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4663] (clojure.core/str arg4663))
 v4587))))
   (clojure.core/let
    [v4587
     (:load-balancer-name
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setLoadBalancerName (clojure.core/str v4587))))
   bean4585))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest}
remove-tags-request
  [m4589]
  (clojure.core/let
   [bean4588
    (new
     com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest)]
   (clojure.core/let
    [v4590 (:tags m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4664]
  (elasticloadbalancing/tag-key-only arg4664))
 v4590))))
   (clojure.core/let
    [v4590
     (:load-balancer-names
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (.
      bean4588
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4665] (clojure.core/str arg4665))
 v4590))))
   bean4588))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4592]
  (clojure.core/let
   [bean4591
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4593
     (:policy-type-name
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setPolicyTypeName (clojure.core/str v4593))))
   (clojure.core/let
    [v4593
     (:policy-attributes
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4666]
  (elasticloadbalancing/policy-attribute arg4666))
 v4593))))
   (clojure.core/let
    [v4593
     (:policy-name m4592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setPolicyName (clojure.core/str v4593))))
   (clojure.core/let
    [v4593
     (:load-balancer-name
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setLoadBalancerName (clojure.core/str v4593))))
   bean4591))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4595]
  (clojure.core/let
   [bean4594
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4596
     (:listeners m4595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (.
      bean4594
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4667] (elasticloadbalancing/listener arg4667))
 v4596))))
   (clojure.core/let
    [v4596
     (:load-balancer-name
      m4595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (. bean4594 setLoadBalancerName (clojure.core/str v4596))))
   bean4594))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4598]
  (clojure.core/let
   [bean4597
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/let
    [v4599
     (:policy-names m4598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (.
      bean4597
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4668] (clojure.core/str arg4668))
 v4599))))
   (clojure.core/let
    [v4599
     (:instance-port m4598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setInstancePort (clojure.core/int v4599))))
   (clojure.core/let
    [v4599
     (:load-balancer-name
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setLoadBalancerName (clojure.core/str v4599))))
   bean4597))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4601]
  (clojure.core/let
   [bean4600
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/let
    [v4602
     (:instances m4601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (.
      bean4600
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4669] (elasticloadbalancing/instance arg4669))
 v4602))))
   (clojure.core/let
    [v4602
     (:load-balancer-name
      m4601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (. bean4600 setLoadBalancerName (clojure.core/str v4602))))
   bean4600))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4604]
  (clojure.core/let
   [bean4603
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/let
    [v4605
     (:load-balancer-name
      m4604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (. bean4603 setLoadBalancerName (clojure.core/str v4605))))
   bean4603))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4607]
  (clojure.core/let
   [bean4606
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/let
    [v4608 (:subnets m4607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (.
      bean4606
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4670] (clojure.core/str arg4670))
 v4608))))
   (clojure.core/let
    [v4608
     (:load-balancer-name
      m4607
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (. bean4606 setLoadBalancerName (clojure.core/str v4608))))
   bean4606))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4610]
  (clojure.core/let
   [bean4609
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4611
     (:load-balancer-name
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (. bean4609 setLoadBalancerName (clojure.core/str v4611))))
   (clojure.core/let
    [v4611
     (:availability-zones
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (.
      bean4609
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4671] (clojure.core/str arg4671))
 v4611))))
   bean4609))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4613]
  (clojure.core/let
   [bean4612
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/let
    [v4614
     (:policy-names m4613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (.
      bean4612
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4672] (clojure.core/str arg4672))
 v4614))))
   (clojure.core/let
    [v4614
     (:load-balancer-port
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setLoadBalancerPort (clojure.core/int v4614))))
   (clojure.core/let
    [v4614
     (:load-balancer-name
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setLoadBalancerName (clojure.core/str v4614))))
   bean4612))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest}
add-tags-request
  [m4616]
  (clojure.core/let
   [bean4615
    (new
     com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest)]
   (clojure.core/let
    [v4617 (:tags m4616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (.
      bean4615
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4673] (elasticloadbalancing/tag arg4673))
 v4617))))
   (clojure.core/let
    [v4617
     (:load-balancer-names
      m4616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (.
      bean4615
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4674] (clojure.core/str arg4674))
 v4617))))
   bean4615))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4619]
  (clojure.core/let
   [bean4618
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/let
    [v4620
     (:instances m4619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (.
      bean4618
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4675] (elasticloadbalancing/instance arg4675))
 v4620))))
   (clojure.core/let
    [v4620
     (:load-balancer-name
      m4619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (. bean4618 setLoadBalancerName (clojure.core/str v4620))))
   bean4618))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest}
describe-tags-request
  [m4622]
  (clojure.core/let
   [bean4621
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest)]
   (clojure.core/let
    [v4623
     (:load-balancer-names
      m4622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4623 :com.palletops.awaze.client-builder/undef)
     (.
      bean4621
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4676] (clojure.core/str arg4676))
 v4623))))
   bean4621))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4625]
  (clojure.core/let
   [bean4624
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4626
     (:cookie-name m4625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (. bean4624 setCookieName (clojure.core/str v4626))))
   (clojure.core/let
    [v4626
     (:policy-name m4625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (. bean4624 setPolicyName (clojure.core/str v4626))))
   (clojure.core/let
    [v4626
     (:load-balancer-name
      m4625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (. bean4624 setLoadBalancerName (clojure.core/str v4626))))
   bean4624))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4628]
  (clojure.core/let
   [bean4627
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4629
     (:load-balancer-attributes
      m4628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (.
      bean4627
      setLoadBalancerAttributes
      (elasticloadbalancing/load-balancer-attributes v4629))))
   (clojure.core/let
    [v4629
     (:load-balancer-name
      m4628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (. bean4627 setLoadBalancerName (clojure.core/str v4629))))
   bean4627))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4631]
  (clojure.core/let
   [bean4630
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/let
    [v4632
     (:load-balancer-port
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setLoadBalancerPort (clojure.core/int v4632))))
   (clojure.core/let
    [v4632
     (:sslcertificate-id
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setSSLCertificateId (clojure.core/str v4632))))
   (clojure.core/let
    [v4632
     (:load-balancer-name
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setLoadBalancerName (clojure.core/str v4632))))
   bean4630))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4634]
  (clojure.core/let
   [bean4633
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4635
     (:load-balancer-name
      m4634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (. bean4633 setLoadBalancerName (clojure.core/str v4635))))
   bean4633))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4637]
  (clojure.core/let
   [bean4636
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/let
    [v4638
     (:health-check m4637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (.
      bean4636
      setHealthCheck
      (elasticloadbalancing/health-check v4638))))
   (clojure.core/let
    [v4638
     (:load-balancer-name
      m4637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (. bean4636 setLoadBalancerName (clojure.core/str v4638))))
   bean4636))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4640]
  (clojure.core/let
   [bean4639
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/let
    [v4641 (:subnets m4640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4641 :com.palletops.awaze.client-builder/undef)
     (.
      bean4639
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4725] (clojure.core/str arg4725))
 v4641))))
   (clojure.core/let
    [v4641
     (:load-balancer-name
      m4640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4641 :com.palletops.awaze.client-builder/undef)
     (. bean4639 setLoadBalancerName (clojure.core/str v4641))))
   bean4639))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4643]
  (clojure.core/let
   [bean4642
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/let
    [v4644
     (:policy-type-names
      m4643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (.
      bean4642
      setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4726] (clojure.core/str arg4726))
 v4644))))
   bean4642))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4646]
  (clojure.core/let
   [bean4645
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/let
    [v4647
     (:instances m4646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (.
      bean4645
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4727] (elasticloadbalancing/instance arg4727))
 v4647))))
   (clojure.core/let
    [v4647
     (:load-balancer-name
      m4646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (. bean4645 setLoadBalancerName (clojure.core/str v4647))))
   bean4645))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4649]
  (clojure.core/let
   [bean4648
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/let
    [v4650
     (:security-groups
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (.
      bean4648
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4728] (clojure.core/str arg4728))
 v4650))))
   (clojure.core/let
    [v4650
     (:load-balancer-name
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (. bean4648 setLoadBalancerName (clojure.core/str v4650))))
   bean4648))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4652]
  (clojure.core/let
   [bean4651
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4653
     (:cookie-expiration-period
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setCookieExpirationPeriod (clojure.core/long v4653))))
   (clojure.core/let
    [v4653
     (:policy-name m4652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setPolicyName (clojure.core/str v4653))))
   (clojure.core/let
    [v4653
     (:load-balancer-name
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setLoadBalancerName (clojure.core/str v4653))))
   bean4651))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4677]
   (clojure.core/let
    [credentials4678 (:credentials m4677) args4679 (:args m4677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4680
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4678)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4680
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4679 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4682 & args4683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4684
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4682)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4684
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4683 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4685]
   (clojure.core/let
    [credentials4686 (:credentials m4685) args4687 (:args m4685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4688
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4688
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4687 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4690 & args4691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4692
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4692
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4691 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4693]
   (clojure.core/let
    [credentials4694 (:credentials m4693) args4695 (:args m4693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4696
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4694)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4696
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4695 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4698 & args4699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4700
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4698)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4700
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4699 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4701]
   (clojure.core/let
    [credentials4702 (:credentials m4701) args4703 (:args m4701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4704
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4702)]
     (clojure.core/case
      (clojure.core/count args4703)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4704
        describeLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4704
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4703 0))))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4706 & args4707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4708
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4706)]
    (clojure.core/case
     (clojure.core/count args4707)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4708
       describeLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4708
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4707 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4709]
   (clojure.core/let
    [credentials4710 (:credentials m4709) args4711 (:args m4709)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4712
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4710)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4712
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4711 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4714 & args4715]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4716
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4714)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4716
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4715 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4717]
   (clojure.core/let
    [credentials4718 (:credentials m4717) args4719 (:args m4717)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4720
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4718)]
     (clojure.core/case
      (clojure.core/count args4719)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4720
        describeLoadBalancerPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4720
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4719 0))))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4722 & args4723]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4724
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4722)]
    (clojure.core/case
     (clojure.core/count args4723)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4724
       describeLoadBalancerPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4724
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4723 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :remove-tags
   [m4729]
   (clojure.core/let
    [credentials4730 (:credentials m4729) args4731 (:args m4729)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4732
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4730)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4732
       removeTags
       (elasticloadbalancing/remove-tags-request
        (clojure.core/nth args4731 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials4734 & args4735]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4736
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4734)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4736
      removeTags
      (elasticloadbalancing/remove-tags-request
       (clojure.core/nth args4735 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4737]
   (clojure.core/let
    [credentials4738 (:credentials m4737) args4739 (:args m4737)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4740
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4738)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4740
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4739 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4742 & args4743]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4744
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4742)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4744
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4743 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4745]
   (clojure.core/let
    [credentials4746 (:credentials m4745) args4747 (:args m4745)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4748
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4746)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4748
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4747 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4750 & args4751]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4752
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4750)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4752
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4751 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4753]
   (clojure.core/let
    [credentials4754 (:credentials m4753) args4755 (:args m4753)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4756
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4754)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4756
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4755 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4758 & args4759]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4760
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4758)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4760
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4759 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4761]
   (clojure.core/let
    [credentials4762 (:credentials m4761) args4763 (:args m4761)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4764
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4762)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4764
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4763 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-health,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4766 & args4767]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4768
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4766)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4768
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4767 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4769]
   (clojure.core/let
    [credentials4770 (:credentials m4769) args4771 (:args m4769)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4772
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4770)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4772
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4771 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4774 & args4775]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4776
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4774)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4776
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4775 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4777]
   (clojure.core/let
    [credentials4778 (:credentials m4777) args4779 (:args m4777)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4780
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4778)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4780
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4779 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4782 & args4783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4784
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4782)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4784
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4783 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4785]
   (clojure.core/let
    [credentials4786 (:credentials m4785) args4787 (:args m4785)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4788
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4786)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4788
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4787 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4790 & args4791]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4792
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4790)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4792
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4791 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4793]
   (clojure.core/let
    [credentials4794 (:credentials m4793) args4795 (:args m4793)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4796
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4794)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4796
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4795 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4798 & args4799]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4800
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4798)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4800
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4799 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :add-tags
   [m4801]
   (clojure.core/let
    [credentials4802 (:credentials m4801) args4803 (:args m4801)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4804
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4802)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4804
       addTags
       (elasticloadbalancing/add-tags-request
        (clojure.core/nth args4803 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials4806 & args4807]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4808
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4806)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4808
      addTags
      (elasticloadbalancing/add-tags-request
       (clojure.core/nth args4807 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4809]
   (clojure.core/let
    [credentials4810 (:credentials m4809) args4811 (:args m4809)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4812
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4810)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4812
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4811 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4814 & args4815]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4816
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4814)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4816
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4815 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-tags
   [m4817]
   (clojure.core/let
    [credentials4818 (:credentials m4817) args4819 (:args m4817)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4820
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4818)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4820
       describeTags
       (elasticloadbalancing/describe-tags-request
        (clojure.core/nth args4819 0)))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags"}
   [credentials4822 & args4823]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4824
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4822)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4824
      describeTags
      (elasticloadbalancing/describe-tags-request
       (clojure.core/nth args4823 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4825]
   (clojure.core/let
    [credentials4826 (:credentials m4825) args4827 (:args m4825)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4828
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4826)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4828
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4827 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4830 & args4831]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4832
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4830)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4832
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4831 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4833]
   (clojure.core/let
    [credentials4834 (:credentials m4833) args4835 (:args m4833)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4836
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4834)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4836
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4835 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4838 & args4839]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4840
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4838)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4840
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4839 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4841]
   (clojure.core/let
    [credentials4842 (:credentials m4841) args4843 (:args m4841)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4844
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4842)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4844
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4843 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4846 & args4847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4848
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4846)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4848
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4847 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4849]
   (clojure.core/let
    [credentials4850 (:credentials m4849) args4851 (:args m4849)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4852
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4850)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4852
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4851 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4854 & args4855]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4856
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4854)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4856
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4855 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4857]
   (clojure.core/let
    [credentials4858 (:credentials m4857) args4859 (:args m4857)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4860
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4858)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4860
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4859 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :configure-health-check,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4862 & args4863]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4864
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4862)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4864
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4863 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4865]
   (clojure.core/let
    [credentials4866 (:credentials m4865) args4867 (:args m4865)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4868
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4866)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4868
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4867 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4870 & args4871]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4872
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4870)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4872
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4871 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4873]
   (clojure.core/let
    [credentials4874 (:credentials m4873) args4875 (:args m4873)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4876
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4874)]
     (clojure.core/case
      (clojure.core/count args4875)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4876
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4875 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4876
        describeLoadBalancerPolicyTypes))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4878 & args4879]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4880
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4878)]
    (clojure.core/case
     (clojure.core/count args4879)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4880
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4879 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4880
       describeLoadBalancerPolicyTypes))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4881]
   (clojure.core/let
    [credentials4882 (:credentials m4881) args4883 (:args m4881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4884
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4882)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4884
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4883 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4886 & args4887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4888
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4886)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4888
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4887 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4889]
   (clojure.core/let
    [credentials4890 (:credentials m4889) args4891 (:args m4889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4892
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4892
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4891 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4894 & args4895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4896
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4896
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4895 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4897]
   (clojure.core/let
    [credentials4898 (:credentials m4897) args4899 (:args m4897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4900
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4900
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4899 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4902 & args4903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4904
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4904
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4903 0))))))))
