(ns
 com.palletops.awaze.elasticmapreduce
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticmapreduce :as elasticmapreduce]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticmapreduce
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Configuration}
configuration
  [m8144]
  (clojure.core/let
   [bean8143
    (new com.amazonaws.services.elasticmapreduce.model.Configuration)]
   (clojure.core/let
    [v8145
     (:configurations m8144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8145 :com.palletops.awaze.client-builder/undef)
     (.
      bean8143
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8248] (elasticmapreduce/configuration arg8248))
 v8145))))
   (clojure.core/let
    [v8145
     (:classification m8144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8145 :com.palletops.awaze.client-builder/undef)
     (. bean8143 setClassification (clojure.core/str v8145))))
   (clojure.core/let
    [v8145
     (:properties m8144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8145 :com.palletops.awaze.client-builder/undef)
     (.
      bean8143
      setProperties
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8249] (clojure.core/str arg8249))
  (clojure.core/keys v8145))
 (clojure.core/map
  (clojure.core/fn [arg8249] (clojure.core/str arg8249))
  (clojure.core/vals v8145))))))
   bean8143))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.VolumeSpecification}
volume-specification
  [m8147]
  (clojure.core/let
   [bean8146
    (new
     com.amazonaws.services.elasticmapreduce.model.VolumeSpecification)]
   (clojure.core/let
    [v8148
     (:size-in-gb m8147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8148 :com.palletops.awaze.client-builder/undef)
     (. bean8146 setSizeInGB (clojure.core/int v8148))))
   (clojure.core/let
    [v8148
     (:volume-type m8147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8148 :com.palletops.awaze.client-builder/undef)
     (. bean8146 setVolumeType (clojure.core/str v8148))))
   (clojure.core/let
    [v8148 (:iops m8147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8148 :com.palletops.awaze.client-builder/undef)
     (. bean8146 setIops (clojure.core/int v8148))))
   bean8146))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig}
ebs-block-device-config
  [m8150]
  (clojure.core/let
   [bean8149
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsBlockDeviceConfig)]
   (clojure.core/let
    [v8151
     (:volume-specification
      m8150
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8151 :com.palletops.awaze.client-builder/undef)
     (.
      bean8149
      setVolumeSpecification
      (elasticmapreduce/volume-specification v8151))))
   (clojure.core/let
    [v8151
     (:volumes-per-instance
      m8150
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8151 :com.palletops.awaze.client-builder/undef)
     (. bean8149 setVolumesPerInstance (clojure.core/int v8151))))
   bean8149))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.MarketType}
market-type
  [m8153]
  (.
   com.amazonaws.services.elasticmapreduce.model.MarketType
   fromValue
   (clojure.core/name m8153)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.EbsConfiguration}
ebs-configuration
  [m8156]
  (clojure.core/let
   [bean8155
    (new
     com.amazonaws.services.elasticmapreduce.model.EbsConfiguration)]
   (clojure.core/let
    [v8157
     (:ebs-optimized m8156 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8157 :com.palletops.awaze.client-builder/undef)
     (. bean8155 setEbsOptimized (clojure.core/boolean v8157))))
   (clojure.core/let
    [v8157
     (:ebs-block-device-configs
      m8156
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8157 :com.palletops.awaze.client-builder/undef)
     (.
      bean8155
      setEbsBlockDeviceConfigs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8250]
  (elasticmapreduce/ebs-block-device-config arg8250))
 v8157))))
   bean8155))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.KeyValue}
key-value
  [m8159]
  (clojure.core/let
   [bean8158
    (new com.amazonaws.services.elasticmapreduce.model.KeyValue)]
   (clojure.core/let
    [v8160 (:key m8159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (. bean8158 setKey (clojure.core/str v8160))))
   (clojure.core/let
    [v8160 (:value m8159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8160 :com.palletops.awaze.client-builder/undef)
     (. bean8158 setValue (clojure.core/str v8160))))
   bean8158))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.PlacementType}
placement-type
  [m8162]
  (clojure.core/let
   [bean8161
    (new com.amazonaws.services.elasticmapreduce.model.PlacementType)]
   (clojure.core/let
    [v8163
     (:availability-zone
      m8162
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8163 :com.palletops.awaze.client-builder/undef)
     (. bean8161 setAvailabilityZone (clojure.core/str v8163))))
   bean8161))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig}
instance-group-config
  [m8165]
  (clojure.core/let
   [bean8164
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig)]
   (clojure.core/let
    [v8166
     (:configurations m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (.
      bean8164
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8251] (elasticmapreduce/configuration arg8251))
 v8166))))
   (clojure.core/let
    [v8166 (:market m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setMarket (elasticmapreduce/market-type v8166))))
   (clojure.core/let
    [v8166
     (:bid-price m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setBidPrice (clojure.core/str v8166))))
   (clojure.core/let
    [v8166
     (:ebs-configuration
      m8165
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (.
      bean8164
      setEbsConfiguration
      (elasticmapreduce/ebs-configuration v8166))))
   (clojure.core/let
    [v8166
     (:instance-role m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setInstanceRole (clojure.core/str v8166))))
   (clojure.core/let
    [v8166
     (:instance-count m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setInstanceCount (clojure.core/int v8166))))
   (clojure.core/let
    [v8166
     (:instance-type m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setInstanceType (clojure.core/str v8166))))
   (clojure.core/let
    [v8166 (:name m8165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8166 :com.palletops.awaze.client-builder/undef)
     (. bean8164 setName (clojure.core/str v8166))))
   bean8164))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig}
hadoop-jar-step-config
  [m8168]
  (clojure.core/let
   [bean8167
    (new
     com.amazonaws.services.elasticmapreduce.model.HadoopJarStepConfig)]
   (clojure.core/let
    [v8169 (:args m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (.
      bean8167
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8252] (clojure.core/str arg8252))
 v8169))))
   (clojure.core/let
    [v8169 (:jar m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (. bean8167 setJar (clojure.core/str v8169))))
   (clojure.core/let
    [v8169
     (:main-class m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (. bean8167 setMainClass (clojure.core/str v8169))))
   (clojure.core/let
    [v8169
     (:properties m8168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8169 :com.palletops.awaze.client-builder/undef)
     (.
      bean8167
      setProperties
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8253] (elasticmapreduce/key-value arg8253))
 v8169))))
   bean8167))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ActionOnFailure}
action-on-failure
  [m8171]
  (.
   com.amazonaws.services.elasticmapreduce.model.ActionOnFailure
   fromValue
   (clojure.core/name m8171)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig}
script-bootstrap-action-config
  [m8174]
  (clojure.core/let
   [bean8173
    (new
     com.amazonaws.services.elasticmapreduce.model.ScriptBootstrapActionConfig)]
   (clojure.core/let
    [v8175 (:args m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (.
      bean8173
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8254] (clojure.core/str arg8254))
 v8175))))
   (clojure.core/let
    [v8175 (:path m8174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8175 :com.palletops.awaze.client-builder/undef)
     (. bean8173 setPath (clojure.core/str v8175))))
   bean8173))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig}
instance-group-modify-config
  [m8177]
  (clojure.core/let
   [bean8176
    (new
     com.amazonaws.services.elasticmapreduce.model.InstanceGroupModifyConfig)]
   (clojure.core/let
    [v8178
     (:instance-group-id
      m8177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (. bean8176 setInstanceGroupId (clojure.core/str v8178))))
   (clojure.core/let
    [v8178
     (:ec2instance-ids-to-terminate
      m8177
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (.
      bean8176
      setEC2InstanceIdsToTerminate
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8255] (clojure.core/str arg8255))
 v8178))))
   (clojure.core/let
    [v8178
     (:instance-count m8177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8178 :com.palletops.awaze.client-builder/undef)
     (. bean8176 setInstanceCount (clojure.core/int v8178))))
   bean8176))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Tag}
tag
  [m8180]
  (clojure.core/let
   [bean8179 (new com.amazonaws.services.elasticmapreduce.model.Tag)]
   (clojure.core/let
    [v8181 (:key m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setKey (clojure.core/str v8181))))
   (clojure.core/let
    [v8181 (:value m8180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8181 :com.palletops.awaze.client-builder/undef)
     (. bean8179 setValue (clojure.core/str v8181))))
   bean8179))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig}
job-flow-instances-config
  [m8183]
  (clojure.core/let
   [bean8182
    (new
     com.amazonaws.services.elasticmapreduce.model.JobFlowInstancesConfig)]
   (clojure.core/let
    [v8184
     (:additional-master-security-groups
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setAdditionalMasterSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8256] (clojure.core/str arg8256))
 v8184))))
   (clojure.core/let
    [v8184
     (:keep-job-flow-alive-when-no-steps
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setKeepJobFlowAliveWhenNoSteps
      (clojure.core/boolean v8184))))
   (clojure.core/let
    [v8184
     (:placement m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setPlacement (elasticmapreduce/placement-type v8184))))
   (clojure.core/let
    [v8184
     (:hadoop-version m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setHadoopVersion (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:ec2subnet-id m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setEc2SubnetId (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:master-instance-type
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setMasterInstanceType (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:slave-instance-type
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setSlaveInstanceType (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:termination-protected
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setTerminationProtected (clojure.core/boolean v8184))))
   (clojure.core/let
    [v8184
     (:emr-managed-master-security-group
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setEmrManagedMasterSecurityGroup
      (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:additional-slave-security-groups
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setAdditionalSlaveSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8257] (clojure.core/str arg8257))
 v8184))))
   (clojure.core/let
    [v8184
     (:ec2key-name m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setEc2KeyName (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:instance-count m8183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (. bean8182 setInstanceCount (clojure.core/int v8184))))
   (clojure.core/let
    [v8184
     (:instance-groups
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8258]
  (elasticmapreduce/instance-group-config arg8258))
 v8184))))
   (clojure.core/let
    [v8184
     (:service-access-security-group
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setServiceAccessSecurityGroup
      (clojure.core/str v8184))))
   (clojure.core/let
    [v8184
     (:emr-managed-slave-security-group
      m8183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8184 :com.palletops.awaze.client-builder/undef)
     (.
      bean8182
      setEmrManagedSlaveSecurityGroup
      (clojure.core/str v8184))))
   bean8182))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.Application}
application
  [m8186]
  (clojure.core/let
   [bean8185
    (new com.amazonaws.services.elasticmapreduce.model.Application)]
   (clojure.core/let
    [v8187 (:version m8186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (. bean8185 setVersion (clojure.core/str v8187))))
   (clojure.core/let
    [v8187
     (:additional-info
      m8186
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (.
      bean8185
      setAdditionalInfo
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8259] (clojure.core/str arg8259))
  (clojure.core/keys v8187))
 (clojure.core/map
  (clojure.core/fn [arg8259] (clojure.core/str arg8259))
  (clojure.core/vals v8187))))))
   (clojure.core/let
    [v8187 (:args m8186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (.
      bean8185
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8260] (clojure.core/str arg8260))
 v8187))))
   (clojure.core/let
    [v8187 (:name m8186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8187 :com.palletops.awaze.client-builder/undef)
     (. bean8185 setName (clojure.core/str v8187))))
   bean8185))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.StepConfig}
step-config
  [m8189]
  (clojure.core/let
   [bean8188
    (new com.amazonaws.services.elasticmapreduce.model.StepConfig)]
   (clojure.core/let
    [v8190
     (:hadoop-jar-step
      m8189
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (.
      bean8188
      setHadoopJarStep
      (elasticmapreduce/hadoop-jar-step-config v8190))))
   (clojure.core/let
    [v8190
     (:action-on-failure
      m8189
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (.
      bean8188
      setActionOnFailure
      (elasticmapreduce/action-on-failure v8190))))
   (clojure.core/let
    [v8190 (:name m8189 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8190 :com.palletops.awaze.client-builder/undef)
     (. bean8188 setName (clojure.core/str v8190))))
   bean8188))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig}
supported-product-config
  [m8192]
  (clojure.core/let
   [bean8191
    (new
     com.amazonaws.services.elasticmapreduce.model.SupportedProductConfig)]
   (clojure.core/let
    [v8193 (:args m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (.
      bean8191
      setArgs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8261] (clojure.core/str arg8261))
 v8193))))
   (clojure.core/let
    [v8193 (:name m8192 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8193 :com.palletops.awaze.client-builder/undef)
     (. bean8191 setName (clojure.core/str v8193))))
   bean8191))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig}
bootstrap-action-config
  [m8195]
  (clojure.core/let
   [bean8194
    (new
     com.amazonaws.services.elasticmapreduce.model.BootstrapActionConfig)]
   (clojure.core/let
    [v8196
     (:script-bootstrap-action
      m8195
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (.
      bean8194
      setScriptBootstrapAction
      (elasticmapreduce/script-bootstrap-action-config v8196))))
   (clojure.core/let
    [v8196 (:name m8195 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8196 :com.palletops.awaze.client-builder/undef)
     (. bean8194 setName (clojure.core/str v8196))))
   bean8194))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest}
modify-instance-groups-request
  [m8198]
  (clojure.core/let
   [bean8197
    (new
     com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest)]
   (clojure.core/let
    [v8199
     (:instance-groups
      m8198
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8199 :com.palletops.awaze.client-builder/undef)
     (.
      bean8197
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8262]
  (elasticmapreduce/instance-group-modify-config arg8262))
 v8199))))
   bean8197))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest}
list-instance-groups-request
  [m8201]
  (clojure.core/let
   [bean8200
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest)]
   (clojure.core/let
    [v8202 (:marker m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (. bean8200 setMarker (clojure.core/str v8202))))
   (clojure.core/let
    [v8202
     (:cluster-id m8201 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8202 :com.palletops.awaze.client-builder/undef)
     (. bean8200 setClusterId (clojure.core/str v8202))))
   bean8200))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListClustersRequest}
list-clusters-request
  [m8204]
  (clojure.core/let
   [bean8203
    (new
     com.amazonaws.services.elasticmapreduce.model.ListClustersRequest)]
   (clojure.core/let
    [v8205 (:marker m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (. bean8203 setMarker (clojure.core/str v8205))))
   (clojure.core/let
    [v8205
     (:created-after m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8205))))
   (clojure.core/let
    [v8205
     (:created-before m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8205))))
   (clojure.core/let
    [v8205
     (:cluster-states m8204 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8205 :com.palletops.awaze.client-builder/undef)
     (.
      bean8203
      setClusterStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8263] (clojure.core/str arg8263))
 v8205))))
   bean8203))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest}
remove-tags-request
  [m8207]
  (clojure.core/let
   [bean8206
    (new
     com.amazonaws.services.elasticmapreduce.model.RemoveTagsRequest)]
   (clojure.core/let
    [v8208
     (:resource-id m8207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (. bean8206 setResourceId (clojure.core/str v8208))))
   (clojure.core/let
    [v8208
     (:tag-keys m8207 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8208 :com.palletops.awaze.client-builder/undef)
     (.
      bean8206
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8264] (clojure.core/str arg8264))
 v8208))))
   bean8206))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddTagsRequest}
add-tags-request
  [m8210]
  (clojure.core/let
   [bean8209
    (new com.amazonaws.services.elasticmapreduce.model.AddTagsRequest)]
   (clojure.core/let
    [v8211
     (:resource-id m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (. bean8209 setResourceId (clojure.core/str v8211))))
   (clojure.core/let
    [v8211 (:tags m8210 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8211 :com.palletops.awaze.client-builder/undef)
     (.
      bean8209
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8265] (elasticmapreduce/tag arg8265))
 v8211))))
   bean8209))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest}
set-visible-to-all-users-request
  [m8213]
  (clojure.core/let
   [bean8212
    (new
     com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest)]
   (clojure.core/let
    [v8214
     (:job-flow-ids m8213 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (.
      bean8212
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8266] (clojure.core/str arg8266))
 v8214))))
   (clojure.core/let
    [v8214
     (:visible-to-all-users
      m8213
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8214 :com.palletops.awaze.client-builder/undef)
     (. bean8212 setVisibleToAllUsers (clojure.core/boolean v8214))))
   bean8212))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest}
list-instances-request
  [m8216]
  (clojure.core/let
   [bean8215
    (new
     com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest)]
   (clojure.core/let
    [v8217 (:marker m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setMarker (clojure.core/str v8217))))
   (clojure.core/let
    [v8217
     (:instance-group-id
      m8216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setInstanceGroupId (clojure.core/str v8217))))
   (clojure.core/let
    [v8217
     (:instance-group-types
      m8216
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (.
      bean8215
      setInstanceGroupTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8267] (clojure.core/str arg8267))
 v8217))))
   (clojure.core/let
    [v8217
     (:cluster-id m8216 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8217 :com.palletops.awaze.client-builder/undef)
     (. bean8215 setClusterId (clojure.core/str v8217))))
   bean8215))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest}
describe-cluster-request
  [m8219]
  (clojure.core/let
   [bean8218
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest)]
   (clojure.core/let
    [v8220
     (:cluster-id m8219 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8220 :com.palletops.awaze.client-builder/undef)
     (. bean8218 setClusterId (clojure.core/str v8220))))
   bean8218))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest}
list-bootstrap-actions-request
  [m8222]
  (clojure.core/let
   [bean8221
    (new
     com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest)]
   (clojure.core/let
    [v8223 (:marker m8222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (. bean8221 setMarker (clojure.core/str v8223))))
   (clojure.core/let
    [v8223
     (:cluster-id m8222 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8223 :com.palletops.awaze.client-builder/undef)
     (. bean8221 setClusterId (clojure.core/str v8223))))
   bean8221))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest}
terminate-job-flows-request
  [m8225]
  (clojure.core/let
   [bean8224
    (new
     com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest)]
   (clojure.core/let
    [v8226
     (:job-flow-ids m8225 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8226 :com.palletops.awaze.client-builder/undef)
     (.
      bean8224
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8268] (clojure.core/str arg8268))
 v8226))))
   bean8224))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest}
describe-job-flows-request
  [m8228]
  (clojure.core/let
   [bean8227
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest)]
   (clojure.core/let
    [v8229
     (:job-flow-ids m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (.
      bean8227
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8269] (clojure.core/str arg8269))
 v8229))))
   (clojure.core/let
    [v8229
     (:created-after m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (.
      bean8227
      setCreatedAfter
      (com.palletops.awaze.common/to-date v8229))))
   (clojure.core/let
    [v8229
     (:created-before m8228 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (.
      bean8227
      setCreatedBefore
      (com.palletops.awaze.common/to-date v8229))))
   (clojure.core/let
    [v8229
     (:job-flow-states
      m8228
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8229 :com.palletops.awaze.client-builder/undef)
     (.
      bean8227
      setJobFlowStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8270] (clojure.core/str arg8270))
 v8229))))
   bean8227))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest}
run-job-flow-request
  [m8231]
  (clojure.core/let
   [bean8230
    (new
     com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest)]
   (clojure.core/let
    [v8232
     (:job-flow-role m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setJobFlowRole (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:instances m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setInstances
      (elasticmapreduce/job-flow-instances-config v8232))))
   (clojure.core/let
    [v8232
     (:additional-info
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setAdditionalInfo (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:visible-to-all-users
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setVisibleToAllUsers (clojure.core/boolean v8232))))
   (clojure.core/let
    [v8232 (:name m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setName (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:applications m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setApplications
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8271] (elasticmapreduce/application arg8271))
 v8232))))
   (clojure.core/let
    [v8232
     (:service-role m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setServiceRole (clojure.core/str v8232))))
   (clojure.core/let
    [v8232 (:steps m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8272] (elasticmapreduce/step-config arg8272))
 v8232))))
   (clojure.core/let
    [v8232
     (:supported-products
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8273] (clojure.core/str arg8273))
 v8232))))
   (clojure.core/let
    [v8232
     (:ami-version m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setAmiVersion (clojure.core/str v8232))))
   (clojure.core/let
    [v8232 (:tags m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8274] (elasticmapreduce/tag arg8274))
 v8232))))
   (clojure.core/let
    [v8232 (:log-uri m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setLogUri (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:configurations m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8275] (elasticmapreduce/configuration arg8275))
 v8232))))
   (clojure.core/let
    [v8232
     (:release-label m8231 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (. bean8230 setReleaseLabel (clojure.core/str v8232))))
   (clojure.core/let
    [v8232
     (:new-supported-products
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setNewSupportedProducts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8276]
  (elasticmapreduce/supported-product-config arg8276))
 v8232))))
   (clojure.core/let
    [v8232
     (:bootstrap-actions
      m8231
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8232 :com.palletops.awaze.client-builder/undef)
     (.
      bean8230
      setBootstrapActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8277]
  (elasticmapreduce/bootstrap-action-config arg8277))
 v8232))))
   bean8230))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest}
add-instance-groups-request
  [m8234]
  (clojure.core/let
   [bean8233
    (new
     com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest)]
   (clojure.core/let
    [v8235
     (:instance-groups
      m8234
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8235 :com.palletops.awaze.client-builder/undef)
     (.
      bean8233
      setInstanceGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8366]
  (elasticmapreduce/instance-group-config arg8366))
 v8235))))
   (clojure.core/let
    [v8235
     (:job-flow-id m8234 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8235 :com.palletops.awaze.client-builder/undef)
     (. bean8233 setJobFlowId (clojure.core/str v8235))))
   bean8233))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.ListStepsRequest}
list-steps-request
  [m8237]
  (clojure.core/let
   [bean8236
    (new
     com.amazonaws.services.elasticmapreduce.model.ListStepsRequest)]
   (clojure.core/let
    [v8238 (:marker m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (. bean8236 setMarker (clojure.core/str v8238))))
   (clojure.core/let
    [v8238
     (:step-states m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setStepStates
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8367] (clojure.core/str arg8367))
 v8238))))
   (clojure.core/let
    [v8238
     (:step-ids m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (.
      bean8236
      setStepIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8368] (clojure.core/str arg8368))
 v8238))))
   (clojure.core/let
    [v8238
     (:cluster-id m8237 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8238 :com.palletops.awaze.client-builder/undef)
     (. bean8236 setClusterId (clojure.core/str v8238))))
   bean8236))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest}
add-job-flow-steps-request
  [m8240]
  (clojure.core/let
   [bean8239
    (new
     com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest)]
   (clojure.core/let
    [v8241
     (:job-flow-id m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (. bean8239 setJobFlowId (clojure.core/str v8241))))
   (clojure.core/let
    [v8241 (:steps m8240 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8241 :com.palletops.awaze.client-builder/undef)
     (.
      bean8239
      setSteps
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8369] (elasticmapreduce/step-config arg8369))
 v8241))))
   bean8239))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest}
set-termination-protection-request
  [m8243]
  (clojure.core/let
   [bean8242
    (new
     com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest)]
   (clojure.core/let
    [v8244
     (:job-flow-ids m8243 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (.
      bean8242
      setJobFlowIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8370] (clojure.core/str arg8370))
 v8244))))
   (clojure.core/let
    [v8244
     (:termination-protected
      m8243
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8244 :com.palletops.awaze.client-builder/undef)
     (. bean8242 setTerminationProtected (clojure.core/boolean v8244))))
   bean8242))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest}
describe-step-request
  [m8246]
  (clojure.core/let
   [bean8245
    (new
     com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest)]
   (clojure.core/let
    [v8247 (:step-id m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setStepId (clojure.core/str v8247))))
   (clojure.core/let
    [v8247
     (:cluster-id m8246 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8247 :com.palletops.awaze.client-builder/undef)
     (. bean8245 setClusterId (clojure.core/str v8247))))
   bean8245))
 (clojure.core/defmulti
  elasticmapreduce
  (clojure.core/fn
   elasticmapreduce
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :modify-instance-groups
   [m8278]
   (clojure.core/let
    [credentials8279 (:credentials m8278) args8280 (:args m8278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8281
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8279)]
     (clojure.core/case
      (clojure.core/count args8280)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8281
        modifyInstanceGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8281
        modifyInstanceGroups
        (elasticmapreduce/modify-instance-groups-request
         (clojure.core/nth args8280 0))))))))
  (clojure.core/defn
   modify-instance-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyInstanceGroups, modifyInstanceGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   modify-instance-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyInstanceGroups, modifyInstanceGroups"}
   [credentials8283 & args8284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8285
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8283)]
    (clojure.core/case
     (clojure.core/count args8284)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8285
       modifyInstanceGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8285
       modifyInstanceGroups
       (elasticmapreduce/modify-instance-groups-request
        (clojure.core/nth args8284 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instance-groups
   [m8286]
   (clojure.core/let
    [credentials8287 (:credentials m8286) args8288 (:args m8286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8289
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8287)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8289
       listInstanceGroups
       (elasticmapreduce/list-instance-groups-request
        (clojure.core/nth args8288 0)))))))
  (clojure.core/defn
   list-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstanceGroups"}
   [credentials8291 & args8292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8293
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8291)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8293
      listInstanceGroups
      (elasticmapreduce/list-instance-groups-request
       (clojure.core/nth args8292 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-clusters
   [m8294]
   (clojure.core/let
    [credentials8295 (:credentials m8294) args8296 (:args m8294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8297
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8295)]
     (clojure.core/case
      (clojure.core/count args8296)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8297
        listClusters))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8297
        listClusters
        (elasticmapreduce/list-clusters-request
         (clojure.core/nth args8296 0))))))))
  (clojure.core/defn
   list-clusters-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Generate map for listClusters, listClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-clusters,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-clusters
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         cluster-states
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]]),
    :doc "Call listClusters, listClusters"}
   [credentials8299 & args8300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8301
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8299)]
    (clojure.core/case
     (clojure.core/count args8300)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8301
       listClusters))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8301
       listClusters
       (elasticmapreduce/list-clusters-request
        (clojure.core/nth args8300 0))))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :remove-tags
   [m8302]
   (clojure.core/let
    [credentials8303 (:credentials m8302) args8304 (:args m8302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8305
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8303)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8305
       removeTags
       (elasticmapreduce/remove-tags-request
        (clojure.core/nth args8304 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials8307 & args8308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8309
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8307)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8309
      removeTags
      (elasticmapreduce/remove-tags-request
       (clojure.core/nth args8308 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-tags
   [m8310]
   (clojure.core/let
    [credentials8311 (:credentials m8310) args8312 (:args m8310)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8313
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8311)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8313
       addTags
       (elasticmapreduce/add-tags-request
        (clojure.core/nth args8312 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials8315 & args8316]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8317
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8315)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8317
      addTags
      (elasticmapreduce/add-tags-request
       (clojure.core/nth args8316 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-visible-to-all-users
   [m8318]
   (clojure.core/let
    [credentials8319 (:credentials m8318) args8320 (:args m8318)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8321
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8319)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8321
       setVisibleToAllUsers
       (elasticmapreduce/set-visible-to-all-users-request
        (clojure.core/nth args8320 0)))))))
  (clojure.core/defn
   set-visible-to-all-users-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVisibleToAllUsers"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-visible-to-all-users,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-visible-to-all-users
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         visible-to-all-users
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVisibleToAllUsers"}
   [credentials8323 & args8324]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8325
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8323)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8325
      setVisibleToAllUsers
      (elasticmapreduce/set-visible-to-all-users-request
       (clojure.core/nth args8324 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-instances
   [m8326]
   (clojure.core/let
    [credentials8327 (:credentials m8326) args8328 (:args m8326)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8329
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8327)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8329
       listInstances
       (elasticmapreduce/list-instances-request
        (clojure.core/nth args8328 0)))))))
  (clojure.core/defn
   list-instances-map
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInstances"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-instances,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-instances
   {:arglists (quote
               [[credentials
                 {:keys [instance-group-types
                         cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         instance-group-id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInstances"}
   [credentials8331 & args8332]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8333
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8331)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8333
      listInstances
      (elasticmapreduce/list-instances-request
       (clojure.core/nth args8332 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-cluster
   [m8334]
   (clojure.core/let
    [credentials8335 (:credentials m8334) args8336 (:args m8334)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8337
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8335)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8337
       describeCluster
       (elasticmapreduce/describe-cluster-request
        (clojure.core/nth args8336 0)))))))
  (clojure.core/defn
   describe-cluster-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-cluster,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-cluster
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCluster"}
   [credentials8339 & args8340]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8341
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8339)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8341
      describeCluster
      (elasticmapreduce/describe-cluster-request
       (clojure.core/nth args8340 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-bootstrap-actions
   [m8342]
   (clojure.core/let
    [credentials8343 (:credentials m8342) args8344 (:args m8342)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8345
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8343)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8345
       listBootstrapActions
       (elasticmapreduce/list-bootstrap-actions-request
        (clojure.core/nth args8344 0)))))))
  (clojure.core/defn
   list-bootstrap-actions-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listBootstrapActions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-bootstrap-actions,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-bootstrap-actions
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listBootstrapActions"}
   [credentials8347 & args8348]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8349
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8347)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8349
      listBootstrapActions
      (elasticmapreduce/list-bootstrap-actions-request
       (clojure.core/nth args8348 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :terminate-job-flows
   [m8350]
   (clojure.core/let
    [credentials8351 (:credentials m8350) args8352 (:args m8350)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8353
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8351)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8353
       terminateJobFlows
       (elasticmapreduce/terminate-job-flows-request
        (clojure.core/nth args8352 0)))))))
  (clojure.core/defn
   terminate-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for terminateJobFlows"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   terminate-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call terminateJobFlows"}
   [credentials8355 & args8356]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8357
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8355)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8357
      terminateJobFlows
      (elasticmapreduce/terminate-job-flows-request
       (clojure.core/nth args8356 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-job-flows
   [m8358]
   (clojure.core/let
    [credentials8359 (:credentials m8358) args8360 (:args m8358)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8361
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8359)]
     (clojure.core/case
      (clojure.core/count args8360)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8361
        describeJobFlows
        (elasticmapreduce/describe-job-flows-request
         (clojure.core/nth args8360 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8361
        describeJobFlows))))))
  (clojure.core/defn
   describe-job-flows-map
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeJobFlows, describeJobFlows"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job-flows,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-job-flows
   {:arglists (quote
               [[credentials
                 {:keys [created-after
                         custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         job-flow-states
                         general-progress-listener
                         clone-source
                         created-before
                         clone-root]}]
                [credentials]]),
    :doc "Call describeJobFlows, describeJobFlows"}
   [credentials8363 & args8364]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8365
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8363)]
    (clojure.core/case
     (clojure.core/count args8364)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8365
       describeJobFlows
       (elasticmapreduce/describe-job-flows-request
        (clojure.core/nth args8364 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8365
       describeJobFlows))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :run-job-flow
   [m8371]
   (clojure.core/let
    [credentials8372 (:credentials m8371) args8373 (:args m8371)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8374
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8372)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8374
       runJobFlow
       (elasticmapreduce/run-job-flow-request
        (clojure.core/nth args8373 0)))))))
  (clojure.core/defn
   run-job-flow-map
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Generate map for runJobFlow"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :run-job-flow,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   run-job-flow
   {:arglists (quote
               [[credentials
                 {:keys [ami-version
                         new-supported-products
                         tags
                         custom-request-headers
                         release-label
                         sdk-client-execution-timeout
                         visible-to-all-users
                         applications
                         sdk-request-timeout
                         service-role
                         name
                         configurations
                         steps
                         custom-query-parameters
                         bootstrap-actions
                         log-uri
                         supported-products
                         additional-info
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root
                         job-flow-role]}]]),
    :doc "Call runJobFlow"}
   [credentials8376 & args8377]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8378
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8376)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8378
      runJobFlow
      (elasticmapreduce/run-job-flow-request
       (clojure.core/nth args8377 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-instance-groups
   [m8379]
   (clojure.core/let
    [credentials8380 (:credentials m8379) args8381 (:args m8379)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8382
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8380)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8382
       addInstanceGroups
       (elasticmapreduce/add-instance-groups-request
        (clojure.core/nth args8381 0)))))))
  (clojure.core/defn
   add-instance-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addInstanceGroups"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-instance-groups,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-instance-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         instance-groups
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addInstanceGroups"}
   [credentials8384 & args8385]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8386
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8384)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8386
      addInstanceGroups
      (elasticmapreduce/add-instance-groups-request
       (clojure.core/nth args8385 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :list-steps
   [m8387]
   (clojure.core/let
    [credentials8388 (:credentials m8387) args8389 (:args m8387)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8390
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8388)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8390
       listSteps
       (elasticmapreduce/list-steps-request
        (clojure.core/nth args8389 0)))))))
  (clojure.core/defn
   list-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Generate map for listSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   list-steps
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         step-ids
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-states
                         clone-root]}]]),
    :doc "Call listSteps"}
   [credentials8392 & args8393]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8394
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8392)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8394
      listSteps
      (elasticmapreduce/list-steps-request
       (clojure.core/nth args8393 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :add-job-flow-steps
   [m8395]
   (clojure.core/let
    [credentials8396 (:credentials m8395) args8397 (:args m8395)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8398
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8396)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8398
       addJobFlowSteps
       (elasticmapreduce/add-job-flow-steps-request
        (clojure.core/nth args8397 0)))))))
  (clojure.core/defn
   add-job-flow-steps-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addJobFlowSteps"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-job-flow-steps,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   add-job-flow-steps
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         steps
                         custom-query-parameters
                         job-flow-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addJobFlowSteps"}
   [credentials8400 & args8401]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8402
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8400)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8402
      addJobFlowSteps
      (elasticmapreduce/add-job-flow-steps-request
       (clojure.core/nth args8401 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :set-termination-protection
   [m8403]
   (clojure.core/let
    [credentials8404 (:credentials m8403) args8405 (:args m8403)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8406
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8404)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8406
       setTerminationProtection
       (elasticmapreduce/set-termination-protection-request
        (clojure.core/nth args8405 0)))))))
  (clojure.core/defn
   set-termination-protection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTerminationProtection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-termination-protection,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   set-termination-protection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-flow-ids
                         termination-protected
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTerminationProtection"}
   [credentials8408 & args8409]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8410
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8408)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8410
      setTerminationProtection
      (elasticmapreduce/set-termination-protection-request
       (clojure.core/nth args8409 0)))))))
 (do
  (clojure.core/defmethod
   elasticmapreduce
   :describe-step
   [m8411]
   (clojure.core/let
    [credentials8412 (:credentials m8411) args8413 (:args m8411)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
      client8414
      (com.palletops.awaze.common/aws-client
       :elasticmapreduce
       credentials8412)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8414
       describeStep
       (elasticmapreduce/describe-step-request
        (clojure.core/nth args8413 0)))))))
  (clojure.core/defn
   describe-step-map
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Generate map for describeStep"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-step,
     :credentials credentials__1842__auto__,
     :client :elasticmapreduce}))
  (clojure.core/defn
   describe-step
   {:arglists (quote
               [[credentials
                 {:keys [cluster-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         step-id
                         clone-root]}]]),
    :doc "Call describeStep"}
   [credentials8416 & args8417]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
     client8418
     (com.palletops.awaze.common/aws-client
      :elasticmapreduce
      credentials8416)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduceClient}
client8418
      describeStep
      (elasticmapreduce/describe-step-request
       (clojure.core/nth args8417 0))))))))
