(ns
 com.palletops.awaze.glacier
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.glacier :as glacier]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :glacier
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.glacier.AmazonGlacierClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InventoryRetrievalJobInput}
inventory-retrieval-job-input
  [m5736]
  (clojure.core/let
   [bean5735
    (new
     com.amazonaws.services.glacier.model.InventoryRetrievalJobInput)]
   (clojure.core/let
    [v5737 (:limit m5736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5737 :com.palletops.awaze.client-builder/undef)
     (. bean5735 setLimit (clojure.core/str v5737))))
   (clojure.core/let
    [v5737 (:marker m5736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5737 :com.palletops.awaze.client-builder/undef)
     (. bean5735 setMarker (clojure.core/str v5737))))
   (clojure.core/let
    [v5737
     (:end-date m5736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5737 :com.palletops.awaze.client-builder/undef)
     (. bean5735 setEndDate (clojure.core/str v5737))))
   (clojure.core/let
    [v5737
     (:start-date m5736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5737 :com.palletops.awaze.client-builder/undef)
     (. bean5735 setStartDate (clojure.core/str v5737))))
   bean5735))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalRule}
data-retrieval-rule
  [m5739]
  (clojure.core/let
   [bean5738
    (new com.amazonaws.services.glacier.model.DataRetrievalRule)]
   (clojure.core/let
    [v5740
     (:strategy m5739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5740 :com.palletops.awaze.client-builder/undef)
     (. bean5738 setStrategy (clojure.core/str v5740))))
   (clojure.core/let
    [v5740
     (:bytes-per-hour m5739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5740 :com.palletops.awaze.client-builder/undef)
     (. bean5738 setBytesPerHour (clojure.core/long v5740))))
   bean5738))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.JobParameters}
job-parameters
  [m5742]
  (clojure.core/let
   [bean5741 (new com.amazonaws.services.glacier.model.JobParameters)]
   (clojure.core/let
    [v5743 (:format m5742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (. bean5741 setFormat (clojure.core/str v5743))))
   (clojure.core/let
    [v5743
     (:description m5742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (. bean5741 setDescription (clojure.core/str v5743))))
   (clojure.core/let
    [v5743 (:type m5742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (. bean5741 setType (clojure.core/str v5743))))
   (clojure.core/let
    [v5743
     (:archive-id m5742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (. bean5741 setArchiveId (clojure.core/str v5743))))
   (clojure.core/let
    [v5743
     (:snstopic m5742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (. bean5741 setSNSTopic (clojure.core/str v5743))))
   (clojure.core/let
    [v5743
     (:retrieval-byte-range
      m5742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (. bean5741 setRetrievalByteRange (clojure.core/str v5743))))
   (clojure.core/let
    [v5743
     (:inventory-retrieval-parameters
      m5742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5743 :com.palletops.awaze.client-builder/undef)
     (.
      bean5741
      setInventoryRetrievalParameters
      (glacier/inventory-retrieval-job-input v5743))))
   bean5741))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultNotificationConfig}
vault-notification-config
  [m5745]
  (clojure.core/let
   [bean5744
    (new com.amazonaws.services.glacier.model.VaultNotificationConfig)]
   (clojure.core/let
    [v5746 (:events m5745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5746 :com.palletops.awaze.client-builder/undef)
     (.
      bean5744
      setEvents
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5849] (clojure.core/str arg5849))
 v5746))))
   (clojure.core/let
    [v5746
     (:snstopic m5745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5746 :com.palletops.awaze.client-builder/undef)
     (. bean5744 setSNSTopic (clojure.core/str v5746))))
   bean5744))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultAccessPolicy}
vault-access-policy
  [m5748]
  (clojure.core/let
   [bean5747
    (new com.amazonaws.services.glacier.model.VaultAccessPolicy)]
   (clojure.core/let
    [v5749 (:policy m5748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5749 :com.palletops.awaze.client-builder/undef)
     (. bean5747 setPolicy (clojure.core/str v5749))))
   bean5747))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultLockPolicy}
vault-lock-policy
  [m5751]
  (clojure.core/let
   [bean5750
    (new com.amazonaws.services.glacier.model.VaultLockPolicy)]
   (clojure.core/let
    [v5752 (:policy m5751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setPolicy (clojure.core/str v5752))))
   bean5750))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalPolicy}
data-retrieval-policy
  [m5754]
  (clojure.core/let
   [bean5753
    (new com.amazonaws.services.glacier.model.DataRetrievalPolicy)]
   (clojure.core/let
    [v5755 (:rules m5754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5755 :com.palletops.awaze.client-builder/undef)
     (.
      bean5753
      setRules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5850] (glacier/data-retrieval-rule arg5850))
 v5755))))
   bean5753))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m5757]
  (clojure.core/let
   [bean5756
    (new
     com.amazonaws.services.glacier.model.ListMultipartUploadsRequest)]
   (clojure.core/let
    [v5758 (:limit m5757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5758 :com.palletops.awaze.client-builder/undef)
     (. bean5756 setLimit (clojure.core/str v5758))))
   (clojure.core/let
    [v5758
     (:account-id m5757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5758 :com.palletops.awaze.client-builder/undef)
     (. bean5756 setAccountId (clojure.core/str v5758))))
   (clojure.core/let
    [v5758
     (:vault-name m5757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5758 :com.palletops.awaze.client-builder/undef)
     (. bean5756 setVaultName (clojure.core/str v5758))))
   (clojure.core/let
    [v5758
     (:upload-id-marker
      m5757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5758 :com.palletops.awaze.client-builder/undef)
     (. bean5756 setUploadIdMarker (clojure.core/str v5758))))
   bean5756))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultRequest}
delete-vault-request
  [m5760]
  (clojure.core/let
   [bean5759
    (new com.amazonaws.services.glacier.model.DeleteVaultRequest)]
   (clojure.core/let
    [v5761
     (:account-id m5760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5761 :com.palletops.awaze.client-builder/undef)
     (. bean5759 setAccountId (clojure.core/str v5761))))
   (clojure.core/let
    [v5761
     (:vault-name m5760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5761 :com.palletops.awaze.client-builder/undef)
     (. bean5759 setVaultName (clojure.core/str v5761))))
   bean5759))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteVaultLockRequest}
complete-vault-lock-request
  [m5763]
  (clojure.core/let
   [bean5762
    (new
     com.amazonaws.services.glacier.model.CompleteVaultLockRequest)]
   (clojure.core/let
    [v5764
     (:account-id m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setAccountId (clojure.core/str v5764))))
   (clojure.core/let
    [v5764
     (:vault-name m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setVaultName (clojure.core/str v5764))))
   (clojure.core/let
    [v5764 (:lock-id m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (. bean5762 setLockId (clojure.core/str v5764))))
   bean5762))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest}
delete-vault-notifications-request
  [m5766]
  (clojure.core/let
   [bean5765
    (new
     com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest)]
   (clojure.core/let
    [v5767
     (:account-id m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setAccountId (clojure.core/str v5767))))
   (clojure.core/let
    [v5767
     (:vault-name m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setVaultName (clojure.core/str v5767))))
   bean5765))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest}
delete-vault-access-policy-request
  [m5769]
  (clojure.core/let
   [bean5768
    (new
     com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5770
     (:account-id m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setAccountId (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:vault-name m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setVaultName (clojure.core/str v5770))))
   bean5768))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest}
remove-tags-from-vault-request
  [m5772]
  (clojure.core/let
   [bean5771
    (new
     com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest)]
   (clojure.core/let
    [v5773
     (:account-id m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (. bean5771 setAccountId (clojure.core/str v5773))))
   (clojure.core/let
    [v5773
     (:vault-name m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (. bean5771 setVaultName (clojure.core/str v5773))))
   (clojure.core/let
    [v5773
     (:tag-keys m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (.
      bean5771
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5851] (clojure.core/str arg5851))
 v5773))))
   bean5771))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m5775]
  (clojure.core/let
   [bean5774
    (new
     com.amazonaws.services.glacier.model.AbortMultipartUploadRequest)]
   (clojure.core/let
    [v5776
     (:account-id m5775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5776 :com.palletops.awaze.client-builder/undef)
     (. bean5774 setAccountId (clojure.core/str v5776))))
   (clojure.core/let
    [v5776
     (:vault-name m5775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5776 :com.palletops.awaze.client-builder/undef)
     (. bean5774 setVaultName (clojure.core/str v5776))))
   (clojure.core/let
    [v5776
     (:upload-id m5775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5776 :com.palletops.awaze.client-builder/undef)
     (. bean5774 setUploadId (clojure.core/str v5776))))
   bean5774))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadMultipartPartRequest}
upload-multipart-part-request
  [m5778]
  (clojure.core/let
   [bean5777
    (new
     com.amazonaws.services.glacier.model.UploadMultipartPartRequest)]
   (clojure.core/let
    [v5779 (:body m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setBody (clojure.java.io/input-stream v5779))))
   (clojure.core/let
    [v5779
     (:account-id m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setAccountId (clojure.core/str v5779))))
   (clojure.core/let
    [v5779
     (:vault-name m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setVaultName (clojure.core/str v5779))))
   (clojure.core/let
    [v5779
     (:checksum m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setChecksum (clojure.core/str v5779))))
   (clojure.core/let
    [v5779
     (:upload-id m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setUploadId (clojure.core/str v5779))))
   (clojure.core/let
    [v5779 (:range m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setRange (clojure.core/str v5779))))
   bean5777))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListVaultsRequest}
list-vaults-request
  [m5781]
  (clojure.core/let
   [bean5780
    (new com.amazonaws.services.glacier.model.ListVaultsRequest)]
   (clojure.core/let
    [v5782 (:limit m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (. bean5780 setLimit (clojure.core/str v5782))))
   (clojure.core/let
    [v5782 (:marker m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (. bean5780 setMarker (clojure.core/str v5782))))
   (clojure.core/let
    [v5782
     (:account-id m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (. bean5780 setAccountId (clojure.core/str v5782))))
   bean5780))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateJobRequest}
initiate-job-request
  [m5784]
  (clojure.core/let
   [bean5783
    (new com.amazonaws.services.glacier.model.InitiateJobRequest)]
   (clojure.core/let
    [v5785
     (:account-id m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setAccountId (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:vault-name m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setVaultName (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:job-parameters m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setJobParameters (glacier/job-parameters v5785))))
   bean5783))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListPartsRequest}
list-parts-request
  [m5787]
  (clojure.core/let
   [bean5786
    (new com.amazonaws.services.glacier.model.ListPartsRequest)]
   (clojure.core/let
    [v5788 (:limit m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setLimit (clojure.core/str v5788))))
   (clojure.core/let
    [v5788 (:marker m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setMarker (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:account-id m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setAccountId (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:vault-name m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setVaultName (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:upload-id m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setUploadId (clojure.core/str v5788))))
   bean5786))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultNotificationsRequest}
get-vault-notifications-request
  [m5790]
  (clojure.core/let
   [bean5789
    (new
     com.amazonaws.services.glacier.model.GetVaultNotificationsRequest)]
   (clojure.core/let
    [v5791
     (:account-id m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setAccountId (clojure.core/str v5791))))
   (clojure.core/let
    [v5791
     (:vault-name m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setVaultName (clojure.core/str v5791))))
   bean5789))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetJobOutputRequest}
get-job-output-request
  [m5793]
  (clojure.core/let
   [bean5792
    (new com.amazonaws.services.glacier.model.GetJobOutputRequest)]
   (clojure.core/let
    [v5794
     (:account-id m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setAccountId (clojure.core/str v5794))))
   (clojure.core/let
    [v5794
     (:vault-name m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setVaultName (clojure.core/str v5794))))
   (clojure.core/let
    [v5794 (:job-id m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setJobId (clojure.core/str v5794))))
   (clojure.core/let
    [v5794 (:range m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setRange (clojure.core/str v5794))))
   bean5792))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeJobRequest}
describe-job-request
  [m5796]
  (clojure.core/let
   [bean5795
    (new com.amazonaws.services.glacier.model.DescribeJobRequest)]
   (clojure.core/let
    [v5797
     (:account-id m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setAccountId (clojure.core/str v5797))))
   (clojure.core/let
    [v5797
     (:vault-name m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setVaultName (clojure.core/str v5797))))
   (clojure.core/let
    [v5797 (:job-id m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setJobId (clojure.core/str v5797))))
   bean5795))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultNotificationsRequest}
set-vault-notifications-request
  [m5799]
  (clojure.core/let
   [bean5798
    (new
     com.amazonaws.services.glacier.model.SetVaultNotificationsRequest)]
   (clojure.core/let
    [v5800
     (:account-id m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (. bean5798 setAccountId (clojure.core/str v5800))))
   (clojure.core/let
    [v5800
     (:vault-name m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (. bean5798 setVaultName (clojure.core/str v5800))))
   (clojure.core/let
    [v5800
     (:vault-notification-config
      m5799
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (.
      bean5798
      setVaultNotificationConfig
      (glacier/vault-notification-config v5800))))
   bean5798))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeVaultRequest}
describe-vault-request
  [m5802]
  (clojure.core/let
   [bean5801
    (new com.amazonaws.services.glacier.model.DescribeVaultRequest)]
   (clojure.core/let
    [v5803
     (:account-id m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setAccountId (clojure.core/str v5803))))
   (clojure.core/let
    [v5803
     (:vault-name m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setVaultName (clojure.core/str v5803))))
   bean5801))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortVaultLockRequest}
abort-vault-lock-request
  [m5805]
  (clojure.core/let
   [bean5804
    (new com.amazonaws.services.glacier.model.AbortVaultLockRequest)]
   (clojure.core/let
    [v5806
     (:account-id m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setAccountId (clojure.core/str v5806))))
   (clojure.core/let
    [v5806
     (:vault-name m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setVaultName (clojure.core/str v5806))))
   bean5804))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AddTagsToVaultRequest}
add-tags-to-vault-request
  [m5808]
  (clojure.core/let
   [bean5807
    (new com.amazonaws.services.glacier.model.AddTagsToVaultRequest)]
   (clojure.core/let
    [v5809
     (:account-id m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setAccountId (clojure.core/str v5809))))
   (clojure.core/let
    [v5809 (:tags m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (.
      bean5807
      setTags
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg5852] (clojure.core/str arg5852))
  (clojure.core/keys v5809))
 (clojure.core/map
  (clojure.core/fn [arg5852] (clojure.core/str arg5852))
  (clojure.core/vals v5809))))))
   (clojure.core/let
    [v5809
     (:vault-name m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setVaultName (clojure.core/str v5809))))
   bean5807))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest}
set-vault-access-policy-request
  [m5811]
  (clojure.core/let
   [bean5810
    (new
     com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5812
     (:account-id m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setAccountId (clojure.core/str v5812))))
   (clojure.core/let
    [v5812 (:policy m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setPolicy (glacier/vault-access-policy v5812))))
   (clojure.core/let
    [v5812
     (:vault-name m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setVaultName (clojure.core/str v5812))))
   bean5810))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m5814]
  (clojure.core/let
   [bean5813
    (new
     com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v5815
     (:account-id m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setAccountId (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:vault-name m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setVaultName (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:checksum m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setChecksum (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:upload-id m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setUploadId (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:archive-size m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setArchiveSize (clojure.core/str v5815))))
   bean5813))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest}
get-data-retrieval-policy-request
  [m5817]
  (clojure.core/let
   [bean5816
    (new
     com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5818
     (:account-id m5817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5818 :com.palletops.awaze.client-builder/undef)
     (. bean5816 setAccountId (clojure.core/str v5818))))
   bean5816))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateVaultLockRequest}
initiate-vault-lock-request
  [m5820]
  (clojure.core/let
   [bean5819
    (new
     com.amazonaws.services.glacier.model.InitiateVaultLockRequest)]
   (clojure.core/let
    [v5821
     (:account-id m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setAccountId (clojure.core/str v5821))))
   (clojure.core/let
    [v5821 (:policy m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setPolicy (glacier/vault-lock-policy v5821))))
   (clojure.core/let
    [v5821
     (:vault-name m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setVaultName (clojure.core/str v5821))))
   bean5819))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteArchiveRequest}
delete-archive-request
  [m5823]
  (clojure.core/let
   [bean5822
    (new com.amazonaws.services.glacier.model.DeleteArchiveRequest)]
   (clojure.core/let
    [v5824
     (:account-id m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setAccountId (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:vault-name m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setVaultName (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:archive-id m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setArchiveId (clojure.core/str v5824))))
   bean5822))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest}
set-data-retrieval-policy-request
  [m5826]
  (clojure.core/let
   [bean5825
    (new
     com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5827
     (:account-id m5826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5827 :com.palletops.awaze.client-builder/undef)
     (. bean5825 setAccountId (clojure.core/str v5827))))
   (clojure.core/let
    [v5827 (:policy m5826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5827 :com.palletops.awaze.client-builder/undef)
     (. bean5825 setPolicy (glacier/data-retrieval-policy v5827))))
   bean5825))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultLockRequest}
get-vault-lock-request
  [m5829]
  (clojure.core/let
   [bean5828
    (new com.amazonaws.services.glacier.model.GetVaultLockRequest)]
   (clojure.core/let
    [v5830
     (:account-id m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setAccountId (clojure.core/str v5830))))
   (clojure.core/let
    [v5830
     (:vault-name m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setVaultName (clojure.core/str v5830))))
   bean5828))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListJobsRequest}
list-jobs-request
  [m5832]
  (clojure.core/let
   [bean5831
    (new com.amazonaws.services.glacier.model.ListJobsRequest)]
   (clojure.core/let
    [v5833 (:limit m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setLimit (clojure.core/str v5833))))
   (clojure.core/let
    [v5833 (:marker m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setMarker (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:account-id m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setAccountId (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:vault-name m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setVaultName (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:statuscode m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setStatuscode (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:completed m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setCompleted (clojure.core/str v5833))))
   bean5831))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m5835]
  (clojure.core/let
   [bean5834
    (new
     com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest)]
   (clojure.core/let
    [v5836
     (:account-id m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setAccountId (clojure.core/str v5836))))
   (clojure.core/let
    [v5836
     (:vault-name m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setVaultName (clojure.core/str v5836))))
   (clojure.core/let
    [v5836
     (:archive-description
      m5835
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setArchiveDescription (clojure.core/str v5836))))
   (clojure.core/let
    [v5836
     (:part-size m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setPartSize (clojure.core/str v5836))))
   bean5834))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListTagsForVaultRequest}
list-tags-for-vault-request
  [m5838]
  (clojure.core/let
   [bean5837
    (new com.amazonaws.services.glacier.model.ListTagsForVaultRequest)]
   (clojure.core/let
    [v5839
     (:account-id m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setAccountId (clojure.core/str v5839))))
   (clojure.core/let
    [v5839
     (:vault-name m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setVaultName (clojure.core/str v5839))))
   bean5837))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CreateVaultRequest}
create-vault-request
  [m5841]
  (clojure.core/let
   [bean5840
    (new com.amazonaws.services.glacier.model.CreateVaultRequest)]
   (clojure.core/let
    [v5842
     (:account-id m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setAccountId (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:vault-name m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setVaultName (clojure.core/str v5842))))
   bean5840))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest}
get-vault-access-policy-request
  [m5844]
  (clojure.core/let
   [bean5843
    (new
     com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5845
     (:account-id m5844 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setAccountId (clojure.core/str v5845))))
   (clojure.core/let
    [v5845
     (:vault-name m5844 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setVaultName (clojure.core/str v5845))))
   bean5843))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadArchiveRequest}
upload-archive-request
  [m5847]
  (clojure.core/let
   [bean5846
    (new com.amazonaws.services.glacier.model.UploadArchiveRequest)]
   (clojure.core/let
    [v5848
     (:content-length m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setContentLength (clojure.core/long v5848))))
   (clojure.core/let
    [v5848 (:body m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setBody (clojure.java.io/input-stream v5848))))
   (clojure.core/let
    [v5848
     (:account-id m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setAccountId (clojure.core/str v5848))))
   (clojure.core/let
    [v5848
     (:vault-name m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setVaultName (clojure.core/str v5848))))
   (clojure.core/let
    [v5848
     (:archive-description
      m5847
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setArchiveDescription (clojure.core/str v5848))))
   (clojure.core/let
    [v5848
     (:checksum m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setChecksum (clojure.core/str v5848))))
   bean5846))
 (clojure.core/defmulti
  glacier
  (clojure.core/fn glacier [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   glacier
   :list-multipart-uploads
   [m5853]
   (clojure.core/let
    [credentials5854 (:credentials m5853) args5855 (:args m5853)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5856
      (com.palletops.awaze.common/aws-client :glacier credentials5854)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5856
       listMultipartUploads
       (glacier/list-multipart-uploads-request
        (clojure.core/nth args5855 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listMultipartUploads"}
   [credentials5858 & args5859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5860
     (com.palletops.awaze.common/aws-client :glacier credentials5858)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5860
      listMultipartUploads
      (glacier/list-multipart-uploads-request
       (clojure.core/nth args5859 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault
   [m5861]
   (clojure.core/let
    [credentials5862 (:credentials m5861) args5863 (:args m5861)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5864
      (com.palletops.awaze.common/aws-client :glacier credentials5862)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5864
       deleteVault
       (glacier/delete-vault-request (clojure.core/nth args5863 0)))))))
  (clojure.core/defn
   delete-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVault"}
   [credentials5866 & args5867]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5868
     (com.palletops.awaze.common/aws-client :glacier credentials5866)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5868
      deleteVault
      (glacier/delete-vault-request (clojure.core/nth args5867 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-vault-lock
   [m5869]
   (clojure.core/let
    [credentials5870 (:credentials m5869) args5871 (:args m5869)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5872
      (com.palletops.awaze.common/aws-client :glacier credentials5870)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5872
       completeVaultLock
       (glacier/complete-vault-lock-request
        (clojure.core/nth args5871 0)))))))
  (clojure.core/defn
   complete-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for completeVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call completeVaultLock"}
   [credentials5874 & args5875]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5876
     (com.palletops.awaze.common/aws-client :glacier credentials5874)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5876
      completeVaultLock
      (glacier/complete-vault-lock-request
       (clojure.core/nth args5875 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-notifications
   [m5877]
   (clojure.core/let
    [credentials5878 (:credentials m5877) args5879 (:args m5877)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5880
      (com.palletops.awaze.common/aws-client :glacier credentials5878)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5880
       deleteVaultNotifications
       (glacier/delete-vault-notifications-request
        (clojure.core/nth args5879 0)))))))
  (clojure.core/defn
   delete-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultNotifications"}
   [credentials5882 & args5883]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5884
     (com.palletops.awaze.common/aws-client :glacier credentials5882)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5884
      deleteVaultNotifications
      (glacier/delete-vault-notifications-request
       (clojure.core/nth args5883 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-access-policy
   [m5885]
   (clojure.core/let
    [credentials5886 (:credentials m5885) args5887 (:args m5885)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5888
      (com.palletops.awaze.common/aws-client :glacier credentials5886)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5888
       deleteVaultAccessPolicy
       (glacier/delete-vault-access-policy-request
        (clojure.core/nth args5887 0)))))))
  (clojure.core/defn
   delete-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultAccessPolicy"}
   [credentials5890 & args5891]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5892
     (com.palletops.awaze.common/aws-client :glacier credentials5890)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5892
      deleteVaultAccessPolicy
      (glacier/delete-vault-access-policy-request
       (clojure.core/nth args5891 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :remove-tags-from-vault
   [m5893]
   (clojure.core/let
    [credentials5894 (:credentials m5893) args5895 (:args m5893)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5896
      (com.palletops.awaze.common/aws-client :glacier credentials5894)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5896
       removeTagsFromVault
       (glacier/remove-tags-from-vault-request
        (clojure.core/nth args5895 0)))))))
  (clojure.core/defn
   remove-tags-from-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   remove-tags-from-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromVault"}
   [credentials5898 & args5899]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5900
     (com.palletops.awaze.common/aws-client :glacier credentials5898)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5900
      removeTagsFromVault
      (glacier/remove-tags-from-vault-request
       (clojure.core/nth args5899 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-multipart-upload
   [m5901]
   (clojure.core/let
    [credentials5902 (:credentials m5901) args5903 (:args m5901)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5904
      (com.palletops.awaze.common/aws-client :glacier credentials5902)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5904
       abortMultipartUpload
       (glacier/abort-multipart-upload-request
        (clojure.core/nth args5903 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials5906 & args5907]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5908
     (com.palletops.awaze.common/aws-client :glacier credentials5906)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5908
      abortMultipartUpload
      (glacier/abort-multipart-upload-request
       (clojure.core/nth args5907 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-multipart-part
   [m5909]
   (clojure.core/let
    [credentials5910 (:credentials m5909) args5911 (:args m5909)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5912
      (com.palletops.awaze.common/aws-client :glacier credentials5910)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5912
       uploadMultipartPart
       (glacier/upload-multipart-part-request
        (clojure.core/nth args5911 0)))))))
  (clojure.core/defn
   upload-multipart-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Generate map for uploadMultipartPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-multipart-part,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-multipart-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Call uploadMultipartPart"}
   [credentials5914 & args5915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5916
     (com.palletops.awaze.common/aws-client :glacier credentials5914)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5916
      uploadMultipartPart
      (glacier/upload-multipart-part-request
       (clojure.core/nth args5915 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-vaults
   [m5917]
   (clojure.core/let
    [credentials5918 (:credentials m5917) args5919 (:args m5917)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5920
      (com.palletops.awaze.common/aws-client :glacier credentials5918)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5920
       listVaults
       (glacier/list-vaults-request (clojure.core/nth args5919 0)))))))
  (clojure.core/defn
   list-vaults-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVaults"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-vaults,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-vaults
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVaults"}
   [credentials5922 & args5923]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5924
     (com.palletops.awaze.common/aws-client :glacier credentials5922)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5924
      listVaults
      (glacier/list-vaults-request (clojure.core/nth args5923 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-job
   [m5925]
   (clojure.core/let
    [credentials5926 (:credentials m5925) args5927 (:args m5925)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5928
      (com.palletops.awaze.common/aws-client :glacier credentials5926)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5928
       initiateJob
       (glacier/initiate-job-request (clojure.core/nth args5927 0)))))))
  (clojure.core/defn
   initiate-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Generate map for initiateJob"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-job,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Call initiateJob"}
   [credentials5930 & args5931]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5932
     (com.palletops.awaze.common/aws-client :glacier credentials5930)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5932
      initiateJob
      (glacier/initiate-job-request (clojure.core/nth args5931 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-parts
   [m5933]
   (clojure.core/let
    [credentials5934 (:credentials m5933) args5935 (:args m5933)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5936
      (com.palletops.awaze.common/aws-client :glacier credentials5934)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5936
       listParts
       (glacier/list-parts-request (clojure.core/nth args5935 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listParts"}
   [credentials5938 & args5939]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5940
     (com.palletops.awaze.common/aws-client :glacier credentials5938)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5940
      listParts
      (glacier/list-parts-request (clojure.core/nth args5939 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-notifications
   [m5941]
   (clojure.core/let
    [credentials5942 (:credentials m5941) args5943 (:args m5941)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5944
      (com.palletops.awaze.common/aws-client :glacier credentials5942)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5944
       getVaultNotifications
       (glacier/get-vault-notifications-request
        (clojure.core/nth args5943 0)))))))
  (clojure.core/defn
   get-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultNotifications"}
   [credentials5946 & args5947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5948
     (com.palletops.awaze.common/aws-client :glacier credentials5946)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5948
      getVaultNotifications
      (glacier/get-vault-notifications-request
       (clojure.core/nth args5947 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-job-output
   [m5949]
   (clojure.core/let
    [credentials5950 (:credentials m5949) args5951 (:args m5949)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5952
      (com.palletops.awaze.common/aws-client :glacier credentials5950)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5952
       getJobOutput
       (glacier/get-job-output-request (clojure.core/nth args5951 0)))))))
  (clojure.core/defn
   get-job-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Generate map for getJobOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-job-output,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-job-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Call getJobOutput"}
   [credentials5954 & args5955]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5956
     (com.palletops.awaze.common/aws-client :glacier credentials5954)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5956
      getJobOutput
      (glacier/get-job-output-request (clojure.core/nth args5955 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-job
   [m5957]
   (clojure.core/let
    [credentials5958 (:credentials m5957) args5959 (:args m5957)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5960
      (com.palletops.awaze.common/aws-client :glacier credentials5958)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5960
       describeJob
       (glacier/describe-job-request (clojure.core/nth args5959 0)))))))
  (clojure.core/defn
   describe-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeJob"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeJob"}
   [credentials5962 & args5963]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5964
     (com.palletops.awaze.common/aws-client :glacier credentials5962)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5964
      describeJob
      (glacier/describe-job-request (clojure.core/nth args5963 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-notifications
   [m5965]
   (clojure.core/let
    [credentials5966 (:credentials m5965) args5967 (:args m5965)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5968
      (com.palletops.awaze.common/aws-client :glacier credentials5966)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5968
       setVaultNotifications
       (glacier/set-vault-notifications-request
        (clojure.core/nth args5967 0)))))))
  (clojure.core/defn
   set-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultNotifications"}
   [credentials5970 & args5971]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5972
     (com.palletops.awaze.common/aws-client :glacier credentials5970)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5972
      setVaultNotifications
      (glacier/set-vault-notifications-request
       (clojure.core/nth args5971 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-vault
   [m5973]
   (clojure.core/let
    [credentials5974 (:credentials m5973) args5975 (:args m5973)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5976
      (com.palletops.awaze.common/aws-client :glacier credentials5974)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5976
       describeVault
       (glacier/describe-vault-request (clojure.core/nth args5975 0)))))))
  (clojure.core/defn
   describe-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVault"}
   [credentials5978 & args5979]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5980
     (com.palletops.awaze.common/aws-client :glacier credentials5978)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5980
      describeVault
      (glacier/describe-vault-request (clojure.core/nth args5979 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-vault-lock
   [m5981]
   (clojure.core/let
    [credentials5982 (:credentials m5981) args5983 (:args m5981)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5984
      (com.palletops.awaze.common/aws-client :glacier credentials5982)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5984
       abortVaultLock
       (glacier/abort-vault-lock-request
        (clojure.core/nth args5983 0)))))))
  (clojure.core/defn
   abort-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortVaultLock"}
   [credentials5986 & args5987]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5988
     (com.palletops.awaze.common/aws-client :glacier credentials5986)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5988
      abortVaultLock
      (glacier/abort-vault-lock-request (clojure.core/nth args5987 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :add-tags-to-vault
   [m5989]
   (clojure.core/let
    [credentials5990 (:credentials m5989) args5991 (:args m5989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5992
      (com.palletops.awaze.common/aws-client :glacier credentials5990)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5992
       addTagsToVault
       (glacier/add-tags-to-vault-request
        (clojure.core/nth args5991 0)))))))
  (clojure.core/defn
   add-tags-to-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   add-tags-to-vault
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToVault"}
   [credentials5994 & args5995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5996
     (com.palletops.awaze.common/aws-client :glacier credentials5994)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5996
      addTagsToVault
      (glacier/add-tags-to-vault-request
       (clojure.core/nth args5995 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-access-policy
   [m5997]
   (clojure.core/let
    [credentials5998 (:credentials m5997) args5999 (:args m5997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6000
      (com.palletops.awaze.common/aws-client :glacier credentials5998)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6000
       setVaultAccessPolicy
       (glacier/set-vault-access-policy-request
        (clojure.core/nth args5999 0)))))))
  (clojure.core/defn
   set-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultAccessPolicy"}
   [credentials6002 & args6003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6004
     (com.palletops.awaze.common/aws-client :glacier credentials6002)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6004
      setVaultAccessPolicy
      (glacier/set-vault-access-policy-request
       (clojure.core/nth args6003 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-multipart-upload
   [m6005]
   (clojure.core/let
    [credentials6006 (:credentials m6005) args6007 (:args m6005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6008
      (com.palletops.awaze.common/aws-client :glacier credentials6006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6008
       completeMultipartUpload
       (glacier/complete-multipart-upload-request
        (clojure.core/nth args6007 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials6010 & args6011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6012
     (com.palletops.awaze.common/aws-client :glacier credentials6010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6012
      completeMultipartUpload
      (glacier/complete-multipart-upload-request
       (clojure.core/nth args6011 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-data-retrieval-policy
   [m6013]
   (clojure.core/let
    [credentials6014 (:credentials m6013) args6015 (:args m6013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6016
      (com.palletops.awaze.common/aws-client :glacier credentials6014)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6016
       getDataRetrievalPolicy
       (glacier/get-data-retrieval-policy-request
        (clojure.core/nth args6015 0)))))))
  (clojure.core/defn
   get-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDataRetrievalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-data-retrieval-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDataRetrievalPolicy"}
   [credentials6018 & args6019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6020
     (com.palletops.awaze.common/aws-client :glacier credentials6018)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6020
      getDataRetrievalPolicy
      (glacier/get-data-retrieval-policy-request
       (clojure.core/nth args6019 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-vault-lock
   [m6021]
   (clojure.core/let
    [credentials6022 (:credentials m6021) args6023 (:args m6021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6024
      (com.palletops.awaze.common/aws-client :glacier credentials6022)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6024
       initiateVaultLock
       (glacier/initiate-vault-lock-request
        (clojure.core/nth args6023 0)))))))
  (clojure.core/defn
   initiate-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for initiateVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call initiateVaultLock"}
   [credentials6026 & args6027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6028
     (com.palletops.awaze.common/aws-client :glacier credentials6026)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6028
      initiateVaultLock
      (glacier/initiate-vault-lock-request
       (clojure.core/nth args6027 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-archive
   [m6029]
   (clojure.core/let
    [credentials6030 (:credentials m6029) args6031 (:args m6029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6032
      (com.palletops.awaze.common/aws-client :glacier credentials6030)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6032
       deleteArchive
       (glacier/delete-archive-request (clojure.core/nth args6031 0)))))))
  (clojure.core/defn
   delete-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-archive,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteArchive"}
   [credentials6034 & args6035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6036
     (com.palletops.awaze.common/aws-client :glacier credentials6034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6036
      deleteArchive
      (glacier/delete-archive-request (clojure.core/nth args6035 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-data-retrieval-policy
   [m6037]
   (clojure.core/let
    [credentials6038 (:credentials m6037) args6039 (:args m6037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6040
      (com.palletops.awaze.common/aws-client :glacier credentials6038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6040
       setDataRetrievalPolicy
       (glacier/set-data-retrieval-policy-request
        (clojure.core/nth args6039 0)))))))
  (clojure.core/defn
   set-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDataRetrievalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-data-retrieval-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setDataRetrievalPolicy"}
   [credentials6042 & args6043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6044
     (com.palletops.awaze.common/aws-client :glacier credentials6042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6044
      setDataRetrievalPolicy
      (glacier/set-data-retrieval-policy-request
       (clojure.core/nth args6043 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-lock
   [m6045]
   (clojure.core/let
    [credentials6046 (:credentials m6045) args6047 (:args m6045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6048
      (com.palletops.awaze.common/aws-client :glacier credentials6046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6048
       getVaultLock
       (glacier/get-vault-lock-request (clojure.core/nth args6047 0)))))))
  (clojure.core/defn
   get-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultLock"}
   [credentials6050 & args6051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6052
     (com.palletops.awaze.common/aws-client :glacier credentials6050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6052
      getVaultLock
      (glacier/get-vault-lock-request (clojure.core/nth args6051 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-jobs
   [m6053]
   (clojure.core/let
    [credentials6054 (:credentials m6053) args6055 (:args m6053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6056
      (com.palletops.awaze.common/aws-client :glacier credentials6054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6056
       listJobs
       (glacier/list-jobs-request (clojure.core/nth args6055 0)))))))
  (clojure.core/defn
   list-jobs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listJobs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-jobs,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-jobs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listJobs"}
   [credentials6058 & args6059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6060
     (com.palletops.awaze.common/aws-client :glacier credentials6058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6060
      listJobs
      (glacier/list-jobs-request (clojure.core/nth args6059 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-multipart-upload
   [m6061]
   (clojure.core/let
    [credentials6062 (:credentials m6061) args6063 (:args m6061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6064
      (com.palletops.awaze.common/aws-client :glacier credentials6062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6064
       initiateMultipartUpload
       (glacier/initiate-multipart-upload-request
        (clojure.core/nth args6063 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials6066 & args6067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6068
     (com.palletops.awaze.common/aws-client :glacier credentials6066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6068
      initiateMultipartUpload
      (glacier/initiate-multipart-upload-request
       (clojure.core/nth args6067 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-tags-for-vault
   [m6069]
   (clojure.core/let
    [credentials6070 (:credentials m6069) args6071 (:args m6069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6072
      (com.palletops.awaze.common/aws-client :glacier credentials6070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6072
       listTagsForVault
       (glacier/list-tags-for-vault-request
        (clojure.core/nth args6071 0)))))))
  (clojure.core/defn
   list-tags-for-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-tags-for-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForVault"}
   [credentials6074 & args6075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6076
     (com.palletops.awaze.common/aws-client :glacier credentials6074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6076
      listTagsForVault
      (glacier/list-tags-for-vault-request
       (clojure.core/nth args6075 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :create-vault
   [m6077]
   (clojure.core/let
    [credentials6078 (:credentials m6077) args6079 (:args m6077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6080
      (com.palletops.awaze.common/aws-client :glacier credentials6078)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6080
       createVault
       (glacier/create-vault-request (clojure.core/nth args6079 0)))))))
  (clojure.core/defn
   create-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   create-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVault"}
   [credentials6082 & args6083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6084
     (com.palletops.awaze.common/aws-client :glacier credentials6082)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6084
      createVault
      (glacier/create-vault-request (clojure.core/nth args6083 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-access-policy
   [m6085]
   (clojure.core/let
    [credentials6086 (:credentials m6085) args6087 (:args m6085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6088
      (com.palletops.awaze.common/aws-client :glacier credentials6086)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6088
       getVaultAccessPolicy
       (glacier/get-vault-access-policy-request
        (clojure.core/nth args6087 0)))))))
  (clojure.core/defn
   get-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultAccessPolicy"}
   [credentials6090 & args6091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6092
     (com.palletops.awaze.common/aws-client :glacier credentials6090)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6092
      getVaultAccessPolicy
      (glacier/get-vault-access-policy-request
       (clojure.core/nth args6091 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-archive
   [m6093]
   (clojure.core/let
    [credentials6094 (:credentials m6093) args6095 (:args m6093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6096
      (com.palletops.awaze.common/aws-client :glacier credentials6094)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6096
       uploadArchive
       (glacier/upload-archive-request (clojure.core/nth args6095 0)))))))
  (clojure.core/defn
   upload-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Generate map for uploadArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-archive,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Call uploadArchive"}
   [credentials6098 & args6099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6100
     (com.palletops.awaze.common/aws-client :glacier credentials6098)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6100
      uploadArchive
      (glacier/upload-archive-request (clojure.core/nth args6099 0))))))))
