(ns
 com.palletops.awaze.rds
 (:refer-clojure :exclude [filter])
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.rds :as rds]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :rds
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.rds.AmazonRDSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ApplyMethod}
apply-method
  [m9583]
  (.
   com.amazonaws.services.rds.model.ApplyMethod
   fromValue
   (clojure.core/name m9583)))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionSetting}
option-setting
  [m9586]
  (clojure.core/let
   [bean9585 (new com.amazonaws.services.rds.model.OptionSetting)]
   (clojure.core/let
    [v9587
     (:description m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setDescription (clojure.core/str v9587))))
   (clojure.core/let
    [v9587
     (:data-type m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setDataType (clojure.core/str v9587))))
   (clojure.core/let
    [v9587 (:name m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setName (clojure.core/str v9587))))
   (clojure.core/let
    [v9587
     (:is-modifiable m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setIsModifiable (clojure.core/boolean v9587))))
   (clojure.core/let
    [v9587
     (:default-value m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setDefaultValue (clojure.core/str v9587))))
   (clojure.core/let
    [v9587
     (:is-collection m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setIsCollection (clojure.core/boolean v9587))))
   (clojure.core/let
    [v9587 (:value m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setValue (clojure.core/str v9587))))
   (clojure.core/let
    [v9587
     (:apply-type m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setApplyType (clojure.core/str v9587))))
   (clojure.core/let
    [v9587
     (:allowed-values m9586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9587 :com.palletops.awaze.client-builder/undef)
     (. bean9585 setAllowedValues (clojure.core/str v9587))))
   bean9585))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Filter}
filter
  [m9589]
  (clojure.core/let
   [bean9588 (new com.amazonaws.services.rds.model.Filter)]
   (clojure.core/let
    [v9590 (:values m9589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9590 :com.palletops.awaze.client-builder/undef)
     (.
      bean9588
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9834] (clojure.core/str arg9834))
 v9590))))
   (clojure.core/let
    [v9590 (:name m9589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9590 :com.palletops.awaze.client-builder/undef)
     (. bean9588 setName (clojure.core/str v9590))))
   bean9588))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Tag}
tag
  [m9592]
  (clojure.core/let
   [bean9591 (new com.amazonaws.services.rds.model.Tag)]
   (clojure.core/let
    [v9593 (:key m9592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9593 :com.palletops.awaze.client-builder/undef)
     (. bean9591 setKey (clojure.core/str v9593))))
   (clojure.core/let
    [v9593 (:value m9592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9593 :com.palletops.awaze.client-builder/undef)
     (. bean9591 setValue (clojure.core/str v9593))))
   bean9591))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.Parameter}
parameter
  [m9595]
  (clojure.core/let
   [bean9594 (new com.amazonaws.services.rds.model.Parameter)]
   (clojure.core/let
    [v9596
     (:description m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setDescription (clojure.core/str v9596))))
   (clojure.core/let
    [v9596
     (:data-type m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setDataType (clojure.core/str v9596))))
   (clojure.core/let
    [v9596
     (:parameter-value
      m9595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setParameterValue (clojure.core/str v9596))))
   (clojure.core/let
    [v9596
     (:parameter-name m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setParameterName (clojure.core/str v9596))))
   (clojure.core/let
    [v9596
     (:is-modifiable m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setIsModifiable (clojure.core/boolean v9596))))
   (clojure.core/let
    [v9596
     (:minimum-engine-version
      m9595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setMinimumEngineVersion (clojure.core/str v9596))))
   (clojure.core/let
    [v9596
     (:apply-method m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setApplyMethod (rds/apply-method v9596))))
   (clojure.core/let
    [v9596
     (:apply-type m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setApplyType (clojure.core/str v9596))))
   (clojure.core/let
    [v9596
     (:allowed-values m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setAllowedValues (clojure.core/str v9596))))
   (clojure.core/let
    [v9596 (:source m9595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9596 :com.palletops.awaze.client-builder/undef)
     (. bean9594 setSource (clojure.core/str v9596))))
   bean9594))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.OptionConfiguration}
option-configuration
  [m9598]
  (clojure.core/let
   [bean9597
    (new com.amazonaws.services.rds.model.OptionConfiguration)]
   (clojure.core/let
    [v9599
     (:option-name m9598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9599 :com.palletops.awaze.client-builder/undef)
     (. bean9597 setOptionName (clojure.core/str v9599))))
   (clojure.core/let
    [v9599
     (:dbsecurity-group-memberships
      m9598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9599 :com.palletops.awaze.client-builder/undef)
     (.
      bean9597
      setDBSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9835] (clojure.core/str arg9835))
 v9599))))
   (clojure.core/let
    [v9599
     (:vpc-security-group-memberships
      m9598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9599 :com.palletops.awaze.client-builder/undef)
     (.
      bean9597
      setVpcSecurityGroupMemberships
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9836] (clojure.core/str arg9836))
 v9599))))
   (clojure.core/let
    [v9599
     (:option-settings
      m9598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9599 :com.palletops.awaze.client-builder/undef)
     (.
      bean9597
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9837] (rds/option-setting arg9837))
 v9599))))
   (clojure.core/let
    [v9599 (:port m9598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9599 :com.palletops.awaze.client-builder/undef)
     (. bean9597 setPort (clojure.core/int v9599))))
   bean9597))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBClusterParametersRequest}
describe-dbcluster-parameters-request
  [m9601]
  (clojure.core/let
   [bean9600
    (new
     com.amazonaws.services.rds.model.DescribeDBClusterParametersRequest)]
   (clojure.core/let
    [v9602 (:marker m9601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9602 :com.palletops.awaze.client-builder/undef)
     (. bean9600 setMarker (clojure.core/str v9602))))
   (clojure.core/let
    [v9602 (:source m9601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9602 :com.palletops.awaze.client-builder/undef)
     (. bean9600 setSource (clojure.core/str v9602))))
   (clojure.core/let
    [v9602 (:filters m9601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9602 :com.palletops.awaze.client-builder/undef)
     (.
      bean9600
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9838] (rds/filter arg9838))
 v9602))))
   (clojure.core/let
    [v9602
     (:max-records m9601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9602 :com.palletops.awaze.client-builder/undef)
     (. bean9600 setMaxRecords (clojure.core/int v9602))))
   (clojure.core/let
    [v9602
     (:dbcluster-parameter-group-name
      m9601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9602 :com.palletops.awaze.client-builder/undef)
     (.
      bean9600
      setDBClusterParameterGroupName
      (clojure.core/str v9602))))
   bean9600))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest}
create-dbinstance-read-replica-request
  [m9604]
  (clojure.core/let
   [bean9603
    (new
     com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest)]
   (clojure.core/let
    [v9605
     (:copy-tags-to-snapshot
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setCopyTagsToSnapshot (clojure.core/boolean v9605))))
   (clojure.core/let
    [v9605
     (:dbinstance-class
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setDBInstanceClass (clojure.core/str v9605))))
   (clojure.core/let
    [v9605
     (:storage-type m9604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setStorageType (clojure.core/str v9605))))
   (clojure.core/let
    [v9605 (:iops m9604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setIops (clojure.core/int v9605))))
   (clojure.core/let
    [v9605
     (:availability-zone
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setAvailabilityZone (clojure.core/str v9605))))
   (clojure.core/let
    [v9605
     (:source-dbinstance-identifier
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (.
      bean9603
      setSourceDBInstanceIdentifier
      (clojure.core/str v9605))))
   (clojure.core/let
    [v9605
     (:option-group-name
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setOptionGroupName (clojure.core/str v9605))))
   (clojure.core/let
    [v9605
     (:publicly-accessible
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setPubliclyAccessible (clojure.core/boolean v9605))))
   (clojure.core/let
    [v9605 (:port m9604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setPort (clojure.core/int v9605))))
   (clojure.core/let
    [v9605 (:tags m9604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (.
      bean9603
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9839] (rds/tag arg9839)) v9605))))
   (clojure.core/let
    [v9605
     (:dbsubnet-group-name
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setDBSubnetGroupName (clojure.core/str v9605))))
   (clojure.core/let
    [v9605
     (:monitoring-interval
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setMonitoringInterval (clojure.core/int v9605))))
   (clojure.core/let
    [v9605
     (:dbinstance-identifier
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setDBInstanceIdentifier (clojure.core/str v9605))))
   (clojure.core/let
    [v9605
     (:auto-minor-version-upgrade
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (.
      bean9603
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v9605))))
   (clojure.core/let
    [v9605
     (:monitoring-role-arn
      m9604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9605 :com.palletops.awaze.client-builder/undef)
     (. bean9603 setMonitoringRoleArn (clojure.core/str v9605))))
   bean9603))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest}
modify-dbparameter-group-request
  [m9607]
  (clojure.core/let
   [bean9606
    (new
     com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest)]
   (clojure.core/let
    [v9608
     (:dbparameter-group-name
      m9607
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9608 :com.palletops.awaze.client-builder/undef)
     (. bean9606 setDBParameterGroupName (clojure.core/str v9608))))
   (clojure.core/let
    [v9608
     (:parameters m9607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9608 :com.palletops.awaze.client-builder/undef)
     (.
      bean9606
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9840] (rds/parameter arg9840))
 v9608))))
   bean9606))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSnapshotRequest}
create-dbsnapshot-request
  [m9610]
  (clojure.core/let
   [bean9609
    (new com.amazonaws.services.rds.model.CreateDBSnapshotRequest)]
   (clojure.core/let
    [v9611 (:tags m9610 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9611 :com.palletops.awaze.client-builder/undef)
     (.
      bean9609
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9841] (rds/tag arg9841)) v9611))))
   (clojure.core/let
    [v9611
     (:dbinstance-identifier
      m9610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9611 :com.palletops.awaze.client-builder/undef)
     (. bean9609 setDBInstanceIdentifier (clojure.core/str v9611))))
   (clojure.core/let
    [v9611
     (:dbsnapshot-identifier
      m9610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9611 :com.palletops.awaze.client-builder/undef)
     (. bean9609 setDBSnapshotIdentifier (clojure.core/str v9611))))
   bean9609))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBClusterRequest}
modify-dbcluster-request
  [m9613]
  (clojure.core/let
   [bean9612
    (new com.amazonaws.services.rds.model.ModifyDBClusterRequest)]
   (clojure.core/let
    [v9614
     (:dbcluster-parameter-group-name
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (.
      bean9612
      setDBClusterParameterGroupName
      (clojure.core/str v9614))))
   (clojure.core/let
    [v9614
     (:new-dbcluster-identifier
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setNewDBClusterIdentifier (clojure.core/str v9614))))
   (clojure.core/let
    [v9614
     (:option-group-name
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setOptionGroupName (clojure.core/str v9614))))
   (clojure.core/let
    [v9614
     (:master-user-password
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setMasterUserPassword (clojure.core/str v9614))))
   (clojure.core/let
    [v9614
     (:backup-retention-period
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setBackupRetentionPeriod (clojure.core/int v9614))))
   (clojure.core/let
    [v9614
     (:apply-immediately
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setApplyImmediately (clojure.core/boolean v9614))))
   (clojure.core/let
    [v9614
     (:preferred-maintenance-window
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (.
      bean9612
      setPreferredMaintenanceWindow
      (clojure.core/str v9614))))
   (clojure.core/let
    [v9614 (:port m9613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setPort (clojure.core/int v9614))))
   (clojure.core/let
    [v9614
     (:dbcluster-identifier
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setDBClusterIdentifier (clojure.core/str v9614))))
   (clojure.core/let
    [v9614
     (:preferred-backup-window
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (. bean9612 setPreferredBackupWindow (clojure.core/str v9614))))
   (clojure.core/let
    [v9614
     (:vpc-security-group-ids
      m9613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9614 :com.palletops.awaze.client-builder/undef)
     (.
      bean9612
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9842] (clojure.core/str arg9842))
 v9614))))
   bean9612))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest}
describe-reserved-dbinstances-request
  [m9616]
  (clojure.core/let
   [bean9615
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest)]
   (clojure.core/let
    [v9617
     (:dbinstance-class
      m9616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setDBInstanceClass (clojure.core/str v9617))))
   (clojure.core/let
    [v9617
     (:duration m9616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setDuration (clojure.core/str v9617))))
   (clojure.core/let
    [v9617
     (:product-description
      m9616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setProductDescription (clojure.core/str v9617))))
   (clojure.core/let
    [v9617
     (:reserved-dbinstance-id
      m9616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setReservedDBInstanceId (clojure.core/str v9617))))
   (clojure.core/let
    [v9617 (:marker m9616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setMarker (clojure.core/str v9617))))
   (clojure.core/let
    [v9617
     (:multi-az m9616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setMultiAZ (clojure.core/boolean v9617))))
   (clojure.core/let
    [v9617 (:filters m9616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (.
      bean9615
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9843] (rds/filter arg9843))
 v9617))))
   (clojure.core/let
    [v9617
     (:offering-type m9616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setOfferingType (clojure.core/str v9617))))
   (clojure.core/let
    [v9617
     (:max-records m9616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (. bean9615 setMaxRecords (clojure.core/int v9617))))
   (clojure.core/let
    [v9617
     (:reserved-dbinstances-offering-id
      m9616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9617 :com.palletops.awaze.client-builder/undef)
     (.
      bean9615
      setReservedDBInstancesOfferingId
      (clojure.core/str v9617))))
   bean9615))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBClustersRequest}
describe-dbclusters-request
  [m9619]
  (clojure.core/let
   [bean9618
    (new com.amazonaws.services.rds.model.DescribeDBClustersRequest)]
   (clojure.core/let
    [v9620 (:marker m9619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9620 :com.palletops.awaze.client-builder/undef)
     (. bean9618 setMarker (clojure.core/str v9620))))
   (clojure.core/let
    [v9620 (:filters m9619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9620 :com.palletops.awaze.client-builder/undef)
     (.
      bean9618
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9844] (rds/filter arg9844))
 v9620))))
   (clojure.core/let
    [v9620
     (:max-records m9619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9620 :com.palletops.awaze.client-builder/undef)
     (. bean9618 setMaxRecords (clojure.core/int v9620))))
   (clojure.core/let
    [v9620
     (:dbcluster-identifier
      m9619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9620 :com.palletops.awaze.client-builder/undef)
     (. bean9618 setDBClusterIdentifier (clojure.core/str v9620))))
   bean9618))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddTagsToResourceRequest}
add-tags-to-resource-request
  [m9622]
  (clojure.core/let
   [bean9621
    (new com.amazonaws.services.rds.model.AddTagsToResourceRequest)]
   (clojure.core/let
    [v9623 (:tags m9622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9623 :com.palletops.awaze.client-builder/undef)
     (.
      bean9621
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9845] (rds/tag arg9845)) v9623))))
   (clojure.core/let
    [v9623
     (:resource-name m9622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9623 :com.palletops.awaze.client-builder/undef)
     (. bean9621 setResourceName (clojure.core/str v9623))))
   bean9621))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventsRequest}
describe-events-request
  [m9625]
  (clojure.core/let
   [bean9624
    (new com.amazonaws.services.rds.model.DescribeEventsRequest)]
   (clojure.core/let
    [v9626
     (:duration m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (. bean9624 setDuration (clojure.core/int v9626))))
   (clojure.core/let
    [v9626
     (:event-categories
      m9625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (.
      bean9624
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9846] (clojure.core/str arg9846))
 v9626))))
   (clojure.core/let
    [v9626 (:marker m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (. bean9624 setMarker (clojure.core/str v9626))))
   (clojure.core/let
    [v9626
     (:source-identifier
      m9625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (. bean9624 setSourceIdentifier (clojure.core/str v9626))))
   (clojure.core/let
    [v9626
     (:start-time m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (.
      bean9624
      setStartTime
      (com.palletops.awaze.common/to-date v9626))))
   (clojure.core/let
    [v9626
     (:source-type m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (. bean9624 setSourceType (clojure.core/str v9626))))
   (clojure.core/let
    [v9626 (:filters m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (.
      bean9624
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9847] (rds/filter arg9847))
 v9626))))
   (clojure.core/let
    [v9626
     (:max-records m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (. bean9624 setMaxRecords (clojure.core/int v9626))))
   (clojure.core/let
    [v9626
     (:end-time m9625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9626 :com.palletops.awaze.client-builder/undef)
     (.
      bean9624
      setEndTime
      (com.palletops.awaze.common/to-date v9626))))
   bean9624))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest}
remove-source-identifier-from-subscription-request
  [m9628]
  (clojure.core/let
   [bean9627
    (new
     com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest)]
   (clojure.core/let
    [v9629
     (:source-identifier
      m9628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9629 :com.palletops.awaze.client-builder/undef)
     (. bean9627 setSourceIdentifier (clojure.core/str v9629))))
   (clojure.core/let
    [v9629
     (:subscription-name
      m9628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9629 :com.palletops.awaze.client-builder/undef)
     (. bean9627 setSubscriptionName (clojure.core/str v9629))))
   bean9627))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyDBParameterGroupRequest}
copy-dbparameter-group-request
  [m9631]
  (clojure.core/let
   [bean9630
    (new com.amazonaws.services.rds.model.CopyDBParameterGroupRequest)]
   (clojure.core/let
    [v9632 (:tags m9631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9632 :com.palletops.awaze.client-builder/undef)
     (.
      bean9630
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9848] (rds/tag arg9848)) v9632))))
   (clojure.core/let
    [v9632
     (:source-dbparameter-group-identifier
      m9631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9632 :com.palletops.awaze.client-builder/undef)
     (.
      bean9630
      setSourceDBParameterGroupIdentifier
      (clojure.core/str v9632))))
   (clojure.core/let
    [v9632
     (:target-dbparameter-group-identifier
      m9631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9632 :com.palletops.awaze.client-builder/undef)
     (.
      bean9630
      setTargetDBParameterGroupIdentifier
      (clojure.core/str v9632))))
   (clojure.core/let
    [v9632
     (:target-dbparameter-group-description
      m9631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9632 :com.palletops.awaze.client-builder/undef)
     (.
      bean9630
      setTargetDBParameterGroupDescription
      (clojure.core/str v9632))))
   bean9630))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyDBSnapshotRequest}
copy-dbsnapshot-request
  [m9634]
  (clojure.core/let
   [bean9633
    (new com.amazonaws.services.rds.model.CopyDBSnapshotRequest)]
   (clojure.core/let
    [v9635
     (:kms-key-id m9634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9635 :com.palletops.awaze.client-builder/undef)
     (. bean9633 setKmsKeyId (clojure.core/str v9635))))
   (clojure.core/let
    [v9635 (:tags m9634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9635 :com.palletops.awaze.client-builder/undef)
     (.
      bean9633
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9849] (rds/tag arg9849)) v9635))))
   (clojure.core/let
    [v9635
     (:source-dbsnapshot-identifier
      m9634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9635 :com.palletops.awaze.client-builder/undef)
     (.
      bean9633
      setSourceDBSnapshotIdentifier
      (clojure.core/str v9635))))
   (clojure.core/let
    [v9635
     (:copy-tags m9634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9635 :com.palletops.awaze.client-builder/undef)
     (. bean9633 setCopyTags (clojure.core/boolean v9635))))
   (clojure.core/let
    [v9635
     (:target-dbsnapshot-identifier
      m9634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9635 :com.palletops.awaze.client-builder/undef)
     (.
      bean9633
      setTargetDBSnapshotIdentifier
      (clojure.core/str v9635))))
   bean9633))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest}
delete-event-subscription-request
  [m9637]
  (clojure.core/let
   [bean9636
    (new
     com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest)]
   (clojure.core/let
    [v9638
     (:subscription-name
      m9637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9638 :com.palletops.awaze.client-builder/undef)
     (. bean9636 setSubscriptionName (clojure.core/str v9638))))
   bean9636))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest}
create-dbsecurity-group-request
  [m9640]
  (clojure.core/let
   [bean9639
    (new
     com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest)]
   (clojure.core/let
    [v9641 (:tags m9640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9641 :com.palletops.awaze.client-builder/undef)
     (.
      bean9639
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9850] (rds/tag arg9850)) v9641))))
   (clojure.core/let
    [v9641
     (:dbsecurity-group-name
      m9640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9641 :com.palletops.awaze.client-builder/undef)
     (. bean9639 setDBSecurityGroupName (clojure.core/str v9641))))
   (clojure.core/let
    [v9641
     (:dbsecurity-group-description
      m9640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9641 :com.palletops.awaze.client-builder/undef)
     (.
      bean9639
      setDBSecurityGroupDescription
      (clojure.core/str v9641))))
   bean9639))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest}
create-dbsubnet-group-request
  [m9643]
  (clojure.core/let
   [bean9642
    (new com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest)]
   (clojure.core/let
    [v9644 (:tags m9643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9644 :com.palletops.awaze.client-builder/undef)
     (.
      bean9642
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9851] (rds/tag arg9851)) v9644))))
   (clojure.core/let
    [v9644
     (:subnet-ids m9643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9644 :com.palletops.awaze.client-builder/undef)
     (.
      bean9642
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9852] (clojure.core/str arg9852))
 v9644))))
   (clojure.core/let
    [v9644
     (:dbsubnet-group-name
      m9643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9644 :com.palletops.awaze.client-builder/undef)
     (. bean9642 setDBSubnetGroupName (clojure.core/str v9644))))
   (clojure.core/let
    [v9644
     (:dbsubnet-group-description
      m9643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9644 :com.palletops.awaze.client-builder/undef)
     (. bean9642 setDBSubnetGroupDescription (clojure.core/str v9644))))
   bean9642))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeCertificatesRequest}
describe-certificates-request
  [m9646]
  (clojure.core/let
   [bean9645
    (new com.amazonaws.services.rds.model.DescribeCertificatesRequest)]
   (clojure.core/let
    [v9647 (:marker m9646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9647 :com.palletops.awaze.client-builder/undef)
     (. bean9645 setMarker (clojure.core/str v9647))))
   (clojure.core/let
    [v9647 (:filters m9646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9647 :com.palletops.awaze.client-builder/undef)
     (.
      bean9645
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9853] (rds/filter arg9853))
 v9647))))
   (clojure.core/let
    [v9647
     (:max-records m9646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9647 :com.palletops.awaze.client-builder/undef)
     (. bean9645 setMaxRecords (clojure.core/int v9647))))
   (clojure.core/let
    [v9647
     (:certificate-identifier
      m9646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9647 :com.palletops.awaze.client-builder/undef)
     (. bean9645 setCertificateIdentifier (clojure.core/str v9647))))
   bean9645))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest}
modify-dbsubnet-group-request
  [m9649]
  (clojure.core/let
   [bean9648
    (new com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest)]
   (clojure.core/let
    [v9650
     (:subnet-ids m9649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9650 :com.palletops.awaze.client-builder/undef)
     (.
      bean9648
      setSubnetIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9854] (clojure.core/str arg9854))
 v9650))))
   (clojure.core/let
    [v9650
     (:dbsubnet-group-name
      m9649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9650 :com.palletops.awaze.client-builder/undef)
     (. bean9648 setDBSubnetGroupName (clojure.core/str v9650))))
   (clojure.core/let
    [v9650
     (:dbsubnet-group-description
      m9649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9650 :com.palletops.awaze.client-builder/undef)
     (. bean9648 setDBSubnetGroupDescription (clojure.core/str v9650))))
   bean9648))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEngineDefaultClusterParametersRequest}
describe-engine-default-cluster-parameters-request
  [m9652]
  (clojure.core/let
   [bean9651
    (new
     com.amazonaws.services.rds.model.DescribeEngineDefaultClusterParametersRequest)]
   (clojure.core/let
    [v9653 (:marker m9652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9653 :com.palletops.awaze.client-builder/undef)
     (. bean9651 setMarker (clojure.core/str v9653))))
   (clojure.core/let
    [v9653 (:filters m9652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9653 :com.palletops.awaze.client-builder/undef)
     (.
      bean9651
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9855] (rds/filter arg9855))
 v9653))))
   (clojure.core/let
    [v9653
     (:max-records m9652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9653 :com.palletops.awaze.client-builder/undef)
     (. bean9651 setMaxRecords (clojure.core/int v9653))))
   (clojure.core/let
    [v9653
     (:dbparameter-group-family
      m9652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9653 :com.palletops.awaze.client-builder/undef)
     (. bean9651 setDBParameterGroupFamily (clojure.core/str v9653))))
   bean9651))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest}
delete-dbsubnet-group-request
  [m9655]
  (clojure.core/let
   [bean9654
    (new com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest)]
   (clojure.core/let
    [v9656
     (:dbsubnet-group-name
      m9655
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9656 :com.palletops.awaze.client-builder/undef)
     (. bean9654 setDBSubnetGroupName (clojure.core/str v9656))))
   bean9654))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSnapshotRequest}
delete-dbsnapshot-request
  [m9658]
  (clojure.core/let
   [bean9657
    (new com.amazonaws.services.rds.model.DeleteDBSnapshotRequest)]
   (clojure.core/let
    [v9659
     (:dbsnapshot-identifier
      m9658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9659 :com.palletops.awaze.client-builder/undef)
     (. bean9657 setDBSnapshotIdentifier (clojure.core/str v9659))))
   bean9657))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ResetDBParameterGroupRequest}
reset-dbparameter-group-request
  [m9661]
  (clojure.core/let
   [bean9660
    (new
     com.amazonaws.services.rds.model.ResetDBParameterGroupRequest)]
   (clojure.core/let
    [v9662
     (:dbparameter-group-name
      m9661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9662 :com.palletops.awaze.client-builder/undef)
     (. bean9660 setDBParameterGroupName (clojure.core/str v9662))))
   (clojure.core/let
    [v9662
     (:parameters m9661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9662 :com.palletops.awaze.client-builder/undef)
     (.
      bean9660
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9856] (rds/parameter arg9856))
 v9662))))
   (clojure.core/let
    [v9662
     (:reset-all-parameters
      m9661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9662 :com.palletops.awaze.client-builder/undef)
     (. bean9660 setResetAllParameters (clojure.core/boolean v9662))))
   bean9660))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest}
describe-dbengine-versions-request
  [m9664]
  (clojure.core/let
   [bean9663
    (new
     com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest)]
   (clojure.core/let
    [v9665 (:marker m9664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (. bean9663 setMarker (clojure.core/str v9665))))
   (clojure.core/let
    [v9665 (:filters m9664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (.
      bean9663
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9857] (rds/filter arg9857))
 v9665))))
   (clojure.core/let
    [v9665
     (:max-records m9664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (. bean9663 setMaxRecords (clojure.core/int v9665))))
   (clojure.core/let
    [v9665 (:engine m9664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (. bean9663 setEngine (clojure.core/str v9665))))
   (clojure.core/let
    [v9665
     (:engine-version m9664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (. bean9663 setEngineVersion (clojure.core/str v9665))))
   (clojure.core/let
    [v9665
     (:dbparameter-group-family
      m9664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (. bean9663 setDBParameterGroupFamily (clojure.core/str v9665))))
   (clojure.core/let
    [v9665
     (:default-only m9664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (. bean9663 setDefaultOnly (clojure.core/boolean v9665))))
   (clojure.core/let
    [v9665
     (:list-supported-character-sets
      m9664
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9665 :com.palletops.awaze.client-builder/undef)
     (.
      bean9663
      setListSupportedCharacterSets
      (clojure.core/boolean v9665))))
   bean9663))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest}
add-source-identifier-to-subscription-request
  [m9667]
  (clojure.core/let
   [bean9666
    (new
     com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest)]
   (clojure.core/let
    [v9668
     (:source-identifier
      m9667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9668 :com.palletops.awaze.client-builder/undef)
     (. bean9666 setSourceIdentifier (clojure.core/str v9668))))
   (clojure.core/let
    [v9668
     (:subscription-name
      m9667
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9668 :com.palletops.awaze.client-builder/undef)
     (. bean9666 setSubscriptionName (clojure.core/str v9668))))
   bean9666))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsRequest}
describe-pending-maintenance-actions-request
  [m9670]
  (clojure.core/let
   [bean9669
    (new
     com.amazonaws.services.rds.model.DescribePendingMaintenanceActionsRequest)]
   (clojure.core/let
    [v9671 (:marker m9670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9671 :com.palletops.awaze.client-builder/undef)
     (. bean9669 setMarker (clojure.core/str v9671))))
   (clojure.core/let
    [v9671 (:filters m9670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9671 :com.palletops.awaze.client-builder/undef)
     (.
      bean9669
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9858] (rds/filter arg9858))
 v9671))))
   (clojure.core/let
    [v9671
     (:max-records m9670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9671 :com.palletops.awaze.client-builder/undef)
     (. bean9669 setMaxRecords (clojure.core/int v9671))))
   (clojure.core/let
    [v9671
     (:resource-identifier
      m9670
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9671 :com.palletops.awaze.client-builder/undef)
     (. bean9669 setResourceIdentifier (clojure.core/str v9671))))
   bean9669))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBClusterSnapshotRequest}
delete-dbcluster-snapshot-request
  [m9673]
  (clojure.core/let
   [bean9672
    (new
     com.amazonaws.services.rds.model.DeleteDBClusterSnapshotRequest)]
   (clojure.core/let
    [v9674
     (:dbcluster-snapshot-identifier
      m9673
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9674 :com.palletops.awaze.client-builder/undef)
     (.
      bean9672
      setDBClusterSnapshotIdentifier
      (clojure.core/str v9674))))
   bean9672))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest}
delete-dbsecurity-group-request
  [m9676]
  (clojure.core/let
   [bean9675
    (new
     com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest)]
   (clojure.core/let
    [v9677
     (:dbsecurity-group-name
      m9676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9677 :com.palletops.awaze.client-builder/undef)
     (. bean9675 setDBSecurityGroupName (clojure.core/str v9677))))
   bean9675))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateOptionGroupRequest}
create-option-group-request
  [m9679]
  (clojure.core/let
   [bean9678
    (new com.amazonaws.services.rds.model.CreateOptionGroupRequest)]
   (clojure.core/let
    [v9680 (:tags m9679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9680 :com.palletops.awaze.client-builder/undef)
     (.
      bean9678
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9859] (rds/tag arg9859)) v9680))))
   (clojure.core/let
    [v9680
     (:option-group-name
      m9679
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9680 :com.palletops.awaze.client-builder/undef)
     (. bean9678 setOptionGroupName (clojure.core/str v9680))))
   (clojure.core/let
    [v9680
     (:engine-name m9679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9680 :com.palletops.awaze.client-builder/undef)
     (. bean9678 setEngineName (clojure.core/str v9680))))
   (clojure.core/let
    [v9680
     (:major-engine-version
      m9679
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9680 :com.palletops.awaze.client-builder/undef)
     (. bean9678 setMajorEngineVersion (clojure.core/str v9680))))
   (clojure.core/let
    [v9680
     (:option-group-description
      m9679
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9680 :com.palletops.awaze.client-builder/undef)
     (. bean9678 setOptionGroupDescription (clojure.core/str v9680))))
   bean9678))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBClusterToPointInTimeRequest}
restore-dbcluster-to-point-in-time-request
  [m9682]
  (clojure.core/let
   [bean9681
    (new
     com.amazonaws.services.rds.model.RestoreDBClusterToPointInTimeRequest)]
   (clojure.core/let
    [v9683
     (:option-group-name
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (. bean9681 setOptionGroupName (clojure.core/str v9683))))
   (clojure.core/let
    [v9683
     (:use-latest-restorable-time
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (.
      bean9681
      setUseLatestRestorableTime
      (clojure.core/boolean v9683))))
   (clojure.core/let
    [v9683
     (:source-dbcluster-identifier
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (.
      bean9681
      setSourceDBClusterIdentifier
      (clojure.core/str v9683))))
   (clojure.core/let
    [v9683
     (:restore-to-time
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (.
      bean9681
      setRestoreToTime
      (com.palletops.awaze.common/to-date v9683))))
   (clojure.core/let
    [v9683 (:port m9682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (. bean9681 setPort (clojure.core/int v9683))))
   (clojure.core/let
    [v9683 (:tags m9682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (.
      bean9681
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9860] (rds/tag arg9860)) v9683))))
   (clojure.core/let
    [v9683
     (:dbsubnet-group-name
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (. bean9681 setDBSubnetGroupName (clojure.core/str v9683))))
   (clojure.core/let
    [v9683
     (:dbcluster-identifier
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (. bean9681 setDBClusterIdentifier (clojure.core/str v9683))))
   (clojure.core/let
    [v9683
     (:vpc-security-group-ids
      m9682
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (.
      bean9681
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9861] (clojure.core/str arg9861))
 v9683))))
   (clojure.core/let
    [v9683
     (:kms-key-id m9682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9683 :com.palletops.awaze.client-builder/undef)
     (. bean9681 setKmsKeyId (clojure.core/str v9683))))
   bean9681))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBClusterRequest}
create-dbcluster-request
  [m9685]
  (clojure.core/let
   [bean9684
    (new com.amazonaws.services.rds.model.CreateDBClusterRequest)]
   (clojure.core/let
    [v9686
     (:database-name m9685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setDatabaseName (clojure.core/str v9686))))
   (clojure.core/let
    [v9686 (:engine m9685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setEngine (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:dbcluster-parameter-group-name
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (.
      bean9684
      setDBClusterParameterGroupName
      (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:option-group-name
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setOptionGroupName (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:master-user-password
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setMasterUserPassword (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:backup-retention-period
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setBackupRetentionPeriod (clojure.core/int v9686))))
   (clojure.core/let
    [v9686
     (:availability-zones
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (.
      bean9684
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9862] (clojure.core/str arg9862))
 v9686))))
   (clojure.core/let
    [v9686
     (:preferred-maintenance-window
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (.
      bean9684
      setPreferredMaintenanceWindow
      (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:storage-encrypted
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setStorageEncrypted (clojure.core/boolean v9686))))
   (clojure.core/let
    [v9686 (:port m9685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setPort (clojure.core/int v9686))))
   (clojure.core/let
    [v9686 (:tags m9685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (.
      bean9684
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9863] (rds/tag arg9863)) v9686))))
   (clojure.core/let
    [v9686
     (:dbsubnet-group-name
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setDBSubnetGroupName (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:dbcluster-identifier
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setDBClusterIdentifier (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:preferred-backup-window
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setPreferredBackupWindow (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:character-set-name
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setCharacterSetName (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:vpc-security-group-ids
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (.
      bean9684
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9864] (clojure.core/str arg9864))
 v9686))))
   (clojure.core/let
    [v9686
     (:master-username
      m9685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setMasterUsername (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:kms-key-id m9685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setKmsKeyId (clojure.core/str v9686))))
   (clojure.core/let
    [v9686
     (:engine-version m9685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9686 :com.palletops.awaze.client-builder/undef)
     (. bean9684 setEngineVersion (clojure.core/str v9686))))
   bean9684))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest}
describe-reserved-dbinstances-offerings-request
  [m9688]
  (clojure.core/let
   [bean9687
    (new
     com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest)]
   (clojure.core/let
    [v9689
     (:dbinstance-class
      m9688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setDBInstanceClass (clojure.core/str v9689))))
   (clojure.core/let
    [v9689
     (:duration m9688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setDuration (clojure.core/str v9689))))
   (clojure.core/let
    [v9689
     (:product-description
      m9688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setProductDescription (clojure.core/str v9689))))
   (clojure.core/let
    [v9689 (:marker m9688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setMarker (clojure.core/str v9689))))
   (clojure.core/let
    [v9689
     (:multi-az m9688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setMultiAZ (clojure.core/boolean v9689))))
   (clojure.core/let
    [v9689 (:filters m9688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (.
      bean9687
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9865] (rds/filter arg9865))
 v9689))))
   (clojure.core/let
    [v9689
     (:offering-type m9688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setOfferingType (clojure.core/str v9689))))
   (clojure.core/let
    [v9689
     (:max-records m9688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (. bean9687 setMaxRecords (clojure.core/int v9689))))
   (clojure.core/let
    [v9689
     (:reserved-dbinstances-offering-id
      m9688
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9689 :com.palletops.awaze.client-builder/undef)
     (.
      bean9687
      setReservedDBInstancesOfferingId
      (clojure.core/str v9689))))
   bean9687))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest}
delete-dbparameter-group-request
  [m9691]
  (clojure.core/let
   [bean9690
    (new
     com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest)]
   (clojure.core/let
    [v9692
     (:dbparameter-group-name
      m9691
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9692 :com.palletops.awaze.client-builder/undef)
     (. bean9690 setDBParameterGroupName (clojure.core/str v9692))))
   bean9690))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest}
describe-engine-default-parameters-request
  [m9694]
  (clojure.core/let
   [bean9693
    (new
     com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest)]
   (clojure.core/let
    [v9695 (:marker m9694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9695 :com.palletops.awaze.client-builder/undef)
     (. bean9693 setMarker (clojure.core/str v9695))))
   (clojure.core/let
    [v9695 (:filters m9694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9695 :com.palletops.awaze.client-builder/undef)
     (.
      bean9693
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9866] (rds/filter arg9866))
 v9695))))
   (clojure.core/let
    [v9695
     (:max-records m9694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9695 :com.palletops.awaze.client-builder/undef)
     (. bean9693 setMaxRecords (clojure.core/int v9695))))
   (clojure.core/let
    [v9695
     (:dbparameter-group-family
      m9694
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9695 :com.palletops.awaze.client-builder/undef)
     (. bean9693 setDBParameterGroupFamily (clojure.core/str v9695))))
   bean9693))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PromoteReadReplicaRequest}
promote-read-replica-request
  [m9697]
  (clojure.core/let
   [bean9696
    (new com.amazonaws.services.rds.model.PromoteReadReplicaRequest)]
   (clojure.core/let
    [v9698
     (:dbinstance-identifier
      m9697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9698 :com.palletops.awaze.client-builder/undef)
     (. bean9696 setDBInstanceIdentifier (clojure.core/str v9698))))
   (clojure.core/let
    [v9698
     (:backup-retention-period
      m9697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9698 :com.palletops.awaze.client-builder/undef)
     (. bean9696 setBackupRetentionPeriod (clojure.core/int v9698))))
   (clojure.core/let
    [v9698
     (:preferred-backup-window
      m9697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9698 :com.palletops.awaze.client-builder/undef)
     (. bean9696 setPreferredBackupWindow (clojure.core/str v9698))))
   bean9696))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventCategoriesRequest}
describe-event-categories-request
  [m9700]
  (clojure.core/let
   [bean9699
    (new
     com.amazonaws.services.rds.model.DescribeEventCategoriesRequest)]
   (clojure.core/let
    [v9701 (:filters m9700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9701 :com.palletops.awaze.client-builder/undef)
     (.
      bean9699
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9867] (rds/filter arg9867))
 v9701))))
   (clojure.core/let
    [v9701
     (:source-type m9700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9701 :com.palletops.awaze.client-builder/undef)
     (. bean9699 setSourceType (clojure.core/str v9701))))
   bean9699))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSnapshotAttributesRequest}
describe-dbsnapshot-attributes-request
  [m9703]
  (clojure.core/let
   [bean9702
    (new
     com.amazonaws.services.rds.model.DescribeDBSnapshotAttributesRequest)]
   (clojure.core/let
    [v9704
     (:dbsnapshot-identifier
      m9703
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9704 :com.palletops.awaze.client-builder/undef)
     (. bean9702 setDBSnapshotIdentifier (clojure.core/str v9704))))
   bean9702))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBClusterSnapshotsRequest}
describe-dbcluster-snapshots-request
  [m9706]
  (clojure.core/let
   [bean9705
    (new
     com.amazonaws.services.rds.model.DescribeDBClusterSnapshotsRequest)]
   (clojure.core/let
    [v9707 (:marker m9706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9707 :com.palletops.awaze.client-builder/undef)
     (. bean9705 setMarker (clojure.core/str v9707))))
   (clojure.core/let
    [v9707 (:filters m9706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9707 :com.palletops.awaze.client-builder/undef)
     (.
      bean9705
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9868] (rds/filter arg9868))
 v9707))))
   (clojure.core/let
    [v9707
     (:max-records m9706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9707 :com.palletops.awaze.client-builder/undef)
     (. bean9705 setMaxRecords (clojure.core/int v9707))))
   (clojure.core/let
    [v9707
     (:dbcluster-snapshot-identifier
      m9706
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9707 :com.palletops.awaze.client-builder/undef)
     (.
      bean9705
      setDBClusterSnapshotIdentifier
      (clojure.core/str v9707))))
   (clojure.core/let
    [v9707
     (:dbcluster-identifier
      m9706
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9707 :com.palletops.awaze.client-builder/undef)
     (. bean9705 setDBClusterIdentifier (clojure.core/str v9707))))
   (clojure.core/let
    [v9707
     (:snapshot-type m9706 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9707 :com.palletops.awaze.client-builder/undef)
     (. bean9705 setSnapshotType (clojure.core/str v9707))))
   bean9705))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest}
describe-dbparameter-groups-request
  [m9709]
  (clojure.core/let
   [bean9708
    (new
     com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest)]
   (clojure.core/let
    [v9710 (:marker m9709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9710 :com.palletops.awaze.client-builder/undef)
     (. bean9708 setMarker (clojure.core/str v9710))))
   (clojure.core/let
    [v9710 (:filters m9709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9710 :com.palletops.awaze.client-builder/undef)
     (.
      bean9708
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9869] (rds/filter arg9869))
 v9710))))
   (clojure.core/let
    [v9710
     (:max-records m9709 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9710 :com.palletops.awaze.client-builder/undef)
     (. bean9708 setMaxRecords (clojure.core/int v9710))))
   (clojure.core/let
    [v9710
     (:dbparameter-group-name
      m9709
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9710 :com.palletops.awaze.client-builder/undef)
     (. bean9708 setDBParameterGroupName (clojure.core/str v9710))))
   bean9708))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBSnapshotAttributeRequest}
modify-dbsnapshot-attribute-request
  [m9712]
  (clojure.core/let
   [bean9711
    (new
     com.amazonaws.services.rds.model.ModifyDBSnapshotAttributeRequest)]
   (clojure.core/let
    [v9713
     (:attribute-name m9712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9713 :com.palletops.awaze.client-builder/undef)
     (. bean9711 setAttributeName (clojure.core/str v9713))))
   (clojure.core/let
    [v9713
     (:dbsnapshot-identifier
      m9712
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9713 :com.palletops.awaze.client-builder/undef)
     (. bean9711 setDBSnapshotIdentifier (clojure.core/str v9713))))
   (clojure.core/let
    [v9713
     (:values-to-add m9712 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9713 :com.palletops.awaze.client-builder/undef)
     (.
      bean9711
      setValuesToAdd
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9870] (clojure.core/str arg9870))
 v9713))))
   (clojure.core/let
    [v9713
     (:values-to-remove
      m9712
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9713 :com.palletops.awaze.client-builder/undef)
     (.
      bean9711
      setValuesToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9871] (clojure.core/str arg9871))
 v9713))))
   bean9711))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest}
restore-dbinstance-to-point-in-time-request
  [m9715]
  (clojure.core/let
   [bean9714
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest)]
   (clojure.core/let
    [v9716 (:engine m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setEngine (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:license-model m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setLicenseModel (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:copy-tags-to-snapshot
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setCopyTagsToSnapshot (clojure.core/boolean v9716))))
   (clojure.core/let
    [v9716
     (:dbinstance-class
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setDBInstanceClass (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:storage-type m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setStorageType (clojure.core/str v9716))))
   (clojure.core/let
    [v9716 (:iops m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setIops (clojure.core/int v9716))))
   (clojure.core/let
    [v9716
     (:availability-zone
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setAvailabilityZone (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:source-dbinstance-identifier
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (.
      bean9714
      setSourceDBInstanceIdentifier
      (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:tde-credential-arn
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setTdeCredentialArn (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:target-dbinstance-identifier
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (.
      bean9714
      setTargetDBInstanceIdentifier
      (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:option-group-name
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setOptionGroupName (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:use-latest-restorable-time
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (.
      bean9714
      setUseLatestRestorableTime
      (clojure.core/boolean v9716))))
   (clojure.core/let
    [v9716
     (:publicly-accessible
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setPubliclyAccessible (clojure.core/boolean v9716))))
   (clojure.core/let
    [v9716
     (:multi-az m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setMultiAZ (clojure.core/boolean v9716))))
   (clojure.core/let
    [v9716
     (:restore-time m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (.
      bean9714
      setRestoreTime
      (com.palletops.awaze.common/to-date v9716))))
   (clojure.core/let
    [v9716 (:port m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setPort (clojure.core/int v9716))))
   (clojure.core/let
    [v9716 (:tags m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (.
      bean9714
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9872] (rds/tag arg9872)) v9716))))
   (clojure.core/let
    [v9716
     (:dbsubnet-group-name
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setDBSubnetGroupName (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:tde-credential-password
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setTdeCredentialPassword (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:auto-minor-version-upgrade
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (.
      bean9714
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v9716))))
   (clojure.core/let
    [v9716 (:domain m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setDomain (clojure.core/str v9716))))
   (clojure.core/let
    [v9716 (:dbname m9715 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setDBName (clojure.core/str v9716))))
   (clojure.core/let
    [v9716
     (:domain-iamrole-name
      m9715
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9716 :com.palletops.awaze.client-builder/undef)
     (. bean9714 setDomainIAMRoleName (clojure.core/str v9716))))
   bean9714))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBClusterParameterGroupsRequest}
describe-dbcluster-parameter-groups-request
  [m9718]
  (clojure.core/let
   [bean9717
    (new
     com.amazonaws.services.rds.model.DescribeDBClusterParameterGroupsRequest)]
   (clojure.core/let
    [v9719 (:marker m9718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9719 :com.palletops.awaze.client-builder/undef)
     (. bean9717 setMarker (clojure.core/str v9719))))
   (clojure.core/let
    [v9719 (:filters m9718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9719 :com.palletops.awaze.client-builder/undef)
     (.
      bean9717
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9873] (rds/filter arg9873))
 v9719))))
   (clojure.core/let
    [v9719
     (:max-records m9718 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9719 :com.palletops.awaze.client-builder/undef)
     (. bean9717 setMaxRecords (clojure.core/int v9719))))
   (clojure.core/let
    [v9719
     (:dbcluster-parameter-group-name
      m9718
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9719 :com.palletops.awaze.client-builder/undef)
     (.
      bean9717
      setDBClusterParameterGroupName
      (clojure.core/str v9719))))
   bean9717))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest}
restore-dbinstance-from-dbsnapshot-request
  [m9721]
  (clojure.core/let
   [bean9720
    (new
     com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest)]
   (clojure.core/let
    [v9722 (:engine m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setEngine (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:license-model m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setLicenseModel (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:copy-tags-to-snapshot
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setCopyTagsToSnapshot (clojure.core/boolean v9722))))
   (clojure.core/let
    [v9722
     (:dbinstance-class
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDBInstanceClass (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:storage-type m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setStorageType (clojure.core/str v9722))))
   (clojure.core/let
    [v9722 (:iops m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setIops (clojure.core/int v9722))))
   (clojure.core/let
    [v9722
     (:availability-zone
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setAvailabilityZone (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:tde-credential-arn
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setTdeCredentialArn (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:option-group-name
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setOptionGroupName (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:publicly-accessible
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setPubliclyAccessible (clojure.core/boolean v9722))))
   (clojure.core/let
    [v9722
     (:multi-az m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setMultiAZ (clojure.core/boolean v9722))))
   (clojure.core/let
    [v9722 (:port m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setPort (clojure.core/int v9722))))
   (clojure.core/let
    [v9722 (:tags m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (.
      bean9720
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9874] (rds/tag arg9874)) v9722))))
   (clojure.core/let
    [v9722
     (:dbsubnet-group-name
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDBSubnetGroupName (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:tde-credential-password
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setTdeCredentialPassword (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:dbinstance-identifier
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDBInstanceIdentifier (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:auto-minor-version-upgrade
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (.
      bean9720
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v9722))))
   (clojure.core/let
    [v9722
     (:dbsnapshot-identifier
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDBSnapshotIdentifier (clojure.core/str v9722))))
   (clojure.core/let
    [v9722 (:domain m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDomain (clojure.core/str v9722))))
   (clojure.core/let
    [v9722 (:dbname m9721 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDBName (clojure.core/str v9722))))
   (clojure.core/let
    [v9722
     (:domain-iamrole-name
      m9721
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9722 :com.palletops.awaze.client-builder/undef)
     (. bean9720 setDomainIAMRoleName (clojure.core/str v9722))))
   bean9720))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RestoreDBClusterFromSnapshotRequest}
restore-dbcluster-from-snapshot-request
  [m9724]
  (clojure.core/let
   [bean9723
    (new
     com.amazonaws.services.rds.model.RestoreDBClusterFromSnapshotRequest)]
   (clojure.core/let
    [v9725
     (:database-name m9724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setDatabaseName (clojure.core/str v9725))))
   (clojure.core/let
    [v9725 (:engine m9724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setEngine (clojure.core/str v9725))))
   (clojure.core/let
    [v9725
     (:option-group-name
      m9724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setOptionGroupName (clojure.core/str v9725))))
   (clojure.core/let
    [v9725
     (:availability-zones
      m9724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (.
      bean9723
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9875] (clojure.core/str arg9875))
 v9725))))
   (clojure.core/let
    [v9725 (:port m9724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setPort (clojure.core/int v9725))))
   (clojure.core/let
    [v9725 (:tags m9724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (.
      bean9723
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9876] (rds/tag arg9876)) v9725))))
   (clojure.core/let
    [v9725
     (:dbsubnet-group-name
      m9724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setDBSubnetGroupName (clojure.core/str v9725))))
   (clojure.core/let
    [v9725
     (:dbcluster-identifier
      m9724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setDBClusterIdentifier (clojure.core/str v9725))))
   (clojure.core/let
    [v9725
     (:snapshot-identifier
      m9724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setSnapshotIdentifier (clojure.core/str v9725))))
   (clojure.core/let
    [v9725
     (:vpc-security-group-ids
      m9724
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (.
      bean9723
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9877] (clojure.core/str arg9877))
 v9725))))
   (clojure.core/let
    [v9725
     (:kms-key-id m9724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setKmsKeyId (clojure.core/str v9725))))
   (clojure.core/let
    [v9725
     (:engine-version m9724 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9725 :com.palletops.awaze.client-builder/undef)
     (. bean9723 setEngineVersion (clojure.core/str v9725))))
   bean9723))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBClusterParameterGroupRequest}
modify-dbcluster-parameter-group-request
  [m9727]
  (clojure.core/let
   [bean9726
    (new
     com.amazonaws.services.rds.model.ModifyDBClusterParameterGroupRequest)]
   (clojure.core/let
    [v9728
     (:dbcluster-parameter-group-name
      m9727
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9728 :com.palletops.awaze.client-builder/undef)
     (.
      bean9726
      setDBClusterParameterGroupName
      (clojure.core/str v9728))))
   (clojure.core/let
    [v9728
     (:parameters m9727 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9728 :com.palletops.awaze.client-builder/undef)
     (.
      bean9726
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9878] (rds/parameter arg9878))
 v9728))))
   bean9726))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ApplyPendingMaintenanceActionRequest}
apply-pending-maintenance-action-request
  [m9730]
  (clojure.core/let
   [bean9729
    (new
     com.amazonaws.services.rds.model.ApplyPendingMaintenanceActionRequest)]
   (clojure.core/let
    [v9731
     (:resource-identifier
      m9730
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9731 :com.palletops.awaze.client-builder/undef)
     (. bean9729 setResourceIdentifier (clojure.core/str v9731))))
   (clojure.core/let
    [v9731
     (:apply-action m9730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9731 :com.palletops.awaze.client-builder/undef)
     (. bean9729 setApplyAction (clojure.core/str v9731))))
   (clojure.core/let
    [v9731
     (:opt-in-type m9730 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9731 :com.palletops.awaze.client-builder/undef)
     (. bean9729 setOptInType (clojure.core/str v9731))))
   bean9729))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBParametersRequest}
describe-dbparameters-request
  [m9733]
  (clojure.core/let
   [bean9732
    (new com.amazonaws.services.rds.model.DescribeDBParametersRequest)]
   (clojure.core/let
    [v9734 (:marker m9733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9734 :com.palletops.awaze.client-builder/undef)
     (. bean9732 setMarker (clojure.core/str v9734))))
   (clojure.core/let
    [v9734 (:source m9733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9734 :com.palletops.awaze.client-builder/undef)
     (. bean9732 setSource (clojure.core/str v9734))))
   (clojure.core/let
    [v9734 (:filters m9733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9734 :com.palletops.awaze.client-builder/undef)
     (.
      bean9732
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9879] (rds/filter arg9879))
 v9734))))
   (clojure.core/let
    [v9734
     (:max-records m9733 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9734 :com.palletops.awaze.client-builder/undef)
     (. bean9732 setMaxRecords (clojure.core/int v9734))))
   (clojure.core/let
    [v9734
     (:dbparameter-group-name
      m9733
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9734 :com.palletops.awaze.client-builder/undef)
     (. bean9732 setDBParameterGroupName (clojure.core/str v9734))))
   bean9732))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest}
describe-option-group-options-request
  [m9736]
  (clojure.core/let
   [bean9735
    (new
     com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest)]
   (clojure.core/let
    [v9737 (:marker m9736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9737 :com.palletops.awaze.client-builder/undef)
     (. bean9735 setMarker (clojure.core/str v9737))))
   (clojure.core/let
    [v9737 (:filters m9736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9737 :com.palletops.awaze.client-builder/undef)
     (.
      bean9735
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9880] (rds/filter arg9880))
 v9737))))
   (clojure.core/let
    [v9737
     (:max-records m9736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9737 :com.palletops.awaze.client-builder/undef)
     (. bean9735 setMaxRecords (clojure.core/int v9737))))
   (clojure.core/let
    [v9737
     (:engine-name m9736 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9737 :com.palletops.awaze.client-builder/undef)
     (. bean9735 setEngineName (clojure.core/str v9737))))
   (clojure.core/let
    [v9737
     (:major-engine-version
      m9736
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9737 :com.palletops.awaze.client-builder/undef)
     (. bean9735 setMajorEngineVersion (clojure.core/str v9737))))
   bean9735))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBClusterParameterGroupRequest}
create-dbcluster-parameter-group-request
  [m9739]
  (clojure.core/let
   [bean9738
    (new
     com.amazonaws.services.rds.model.CreateDBClusterParameterGroupRequest)]
   (clojure.core/let
    [v9740
     (:description m9739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9740 :com.palletops.awaze.client-builder/undef)
     (. bean9738 setDescription (clojure.core/str v9740))))
   (clojure.core/let
    [v9740 (:tags m9739 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9740 :com.palletops.awaze.client-builder/undef)
     (.
      bean9738
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9881] (rds/tag arg9881)) v9740))))
   (clojure.core/let
    [v9740
     (:dbcluster-parameter-group-name
      m9739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9740 :com.palletops.awaze.client-builder/undef)
     (.
      bean9738
      setDBClusterParameterGroupName
      (clojure.core/str v9740))))
   (clojure.core/let
    [v9740
     (:dbparameter-group-family
      m9739
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9740 :com.palletops.awaze.client-builder/undef)
     (. bean9738 setDBParameterGroupFamily (clojure.core/str v9740))))
   bean9738))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBParameterGroupRequest}
create-dbparameter-group-request
  [m9742]
  (clojure.core/let
   [bean9741
    (new
     com.amazonaws.services.rds.model.CreateDBParameterGroupRequest)]
   (clojure.core/let
    [v9743
     (:description m9742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9743 :com.palletops.awaze.client-builder/undef)
     (. bean9741 setDescription (clojure.core/str v9743))))
   (clojure.core/let
    [v9743 (:tags m9742 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9743 :com.palletops.awaze.client-builder/undef)
     (.
      bean9741
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9882] (rds/tag arg9882)) v9743))))
   (clojure.core/let
    [v9743
     (:dbparameter-group-family
      m9742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9743 :com.palletops.awaze.client-builder/undef)
     (. bean9741 setDBParameterGroupFamily (clojure.core/str v9743))))
   (clojure.core/let
    [v9743
     (:dbparameter-group-name
      m9742
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9743 :com.palletops.awaze.client-builder/undef)
     (. bean9741 setDBParameterGroupName (clojure.core/str v9743))))
   bean9741))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOptionGroupsRequest}
describe-option-groups-request
  [m9745]
  (clojure.core/let
   [bean9744
    (new com.amazonaws.services.rds.model.DescribeOptionGroupsRequest)]
   (clojure.core/let
    [v9746 (:marker m9745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9746 :com.palletops.awaze.client-builder/undef)
     (. bean9744 setMarker (clojure.core/str v9746))))
   (clojure.core/let
    [v9746 (:filters m9745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9746 :com.palletops.awaze.client-builder/undef)
     (.
      bean9744
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9883] (rds/filter arg9883))
 v9746))))
   (clojure.core/let
    [v9746
     (:max-records m9745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9746 :com.palletops.awaze.client-builder/undef)
     (. bean9744 setMaxRecords (clojure.core/int v9746))))
   (clojure.core/let
    [v9746
     (:option-group-name
      m9745
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9746 :com.palletops.awaze.client-builder/undef)
     (. bean9744 setOptionGroupName (clojure.core/str v9746))))
   (clojure.core/let
    [v9746
     (:engine-name m9745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9746 :com.palletops.awaze.client-builder/undef)
     (. bean9744 setEngineName (clojure.core/str v9746))))
   (clojure.core/let
    [v9746
     (:major-engine-version
      m9745
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9746 :com.palletops.awaze.client-builder/undef)
     (. bean9744 setMajorEngineVersion (clojure.core/str v9746))))
   bean9744))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest}
authorize-dbsecurity-group-ingress-request
  [m9748]
  (clojure.core/let
   [bean9747
    (new
     com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest)]
   (clojure.core/let
    [v9749
     (:dbsecurity-group-name
      m9748
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9749 :com.palletops.awaze.client-builder/undef)
     (. bean9747 setDBSecurityGroupName (clojure.core/str v9749))))
   (clojure.core/let
    [v9749
     (:ec2security-group-id
      m9748
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9749 :com.palletops.awaze.client-builder/undef)
     (. bean9747 setEC2SecurityGroupId (clojure.core/str v9749))))
   (clojure.core/let
    [v9749 (:cidrip m9748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9749 :com.palletops.awaze.client-builder/undef)
     (. bean9747 setCIDRIP (clojure.core/str v9749))))
   (clojure.core/let
    [v9749
     (:ec2security-group-name
      m9748
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9749 :com.palletops.awaze.client-builder/undef)
     (. bean9747 setEC2SecurityGroupName (clojure.core/str v9749))))
   (clojure.core/let
    [v9749
     (:ec2security-group-owner-id
      m9748
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9749 :com.palletops.awaze.client-builder/undef)
     (. bean9747 setEC2SecurityGroupOwnerId (clojure.core/str v9749))))
   bean9747))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteOptionGroupRequest}
delete-option-group-request
  [m9751]
  (clojure.core/let
   [bean9750
    (new com.amazonaws.services.rds.model.DeleteOptionGroupRequest)]
   (clojure.core/let
    [v9752
     (:option-group-name
      m9751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9752 :com.palletops.awaze.client-builder/undef)
     (. bean9750 setOptionGroupName (clojure.core/str v9752))))
   bean9750))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest}
describe-dbsubnet-groups-request
  [m9754]
  (clojure.core/let
   [bean9753
    (new
     com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest)]
   (clojure.core/let
    [v9755 (:marker m9754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9755 :com.palletops.awaze.client-builder/undef)
     (. bean9753 setMarker (clojure.core/str v9755))))
   (clojure.core/let
    [v9755 (:filters m9754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9755 :com.palletops.awaze.client-builder/undef)
     (.
      bean9753
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9884] (rds/filter arg9884))
 v9755))))
   (clojure.core/let
    [v9755
     (:max-records m9754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9755 :com.palletops.awaze.client-builder/undef)
     (. bean9753 setMaxRecords (clojure.core/int v9755))))
   (clojure.core/let
    [v9755
     (:dbsubnet-group-name
      m9754
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9755 :com.palletops.awaze.client-builder/undef)
     (. bean9753 setDBSubnetGroupName (clojure.core/str v9755))))
   bean9753))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RebootDBInstanceRequest}
reboot-dbinstance-request
  [m9757]
  (clojure.core/let
   [bean9756
    (new com.amazonaws.services.rds.model.RebootDBInstanceRequest)]
   (clojure.core/let
    [v9758
     (:dbinstance-identifier
      m9757
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9758 :com.palletops.awaze.client-builder/undef)
     (. bean9756 setDBInstanceIdentifier (clojure.core/str v9758))))
   (clojure.core/let
    [v9758
     (:force-failover m9757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9758 :com.palletops.awaze.client-builder/undef)
     (. bean9756 setForceFailover (clojure.core/boolean v9758))))
   bean9756))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest}
remove-tags-from-resource-request
  [m9760]
  (clojure.core/let
   [bean9759
    (new
     com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest)]
   (clojure.core/let
    [v9761
     (:tag-keys m9760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9761 :com.palletops.awaze.client-builder/undef)
     (.
      bean9759
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9885] (clojure.core/str arg9885))
 v9761))))
   (clojure.core/let
    [v9761
     (:resource-name m9760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9761 :com.palletops.awaze.client-builder/undef)
     (. bean9759 setResourceName (clojure.core/str v9761))))
   bean9759))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest}
revoke-dbsecurity-group-ingress-request
  [m9763]
  (clojure.core/let
   [bean9762
    (new
     com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest)]
   (clojure.core/let
    [v9764
     (:dbsecurity-group-name
      m9763
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9764 :com.palletops.awaze.client-builder/undef)
     (. bean9762 setDBSecurityGroupName (clojure.core/str v9764))))
   (clojure.core/let
    [v9764
     (:ec2security-group-id
      m9763
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9764 :com.palletops.awaze.client-builder/undef)
     (. bean9762 setEC2SecurityGroupId (clojure.core/str v9764))))
   (clojure.core/let
    [v9764 (:cidrip m9763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9764 :com.palletops.awaze.client-builder/undef)
     (. bean9762 setCIDRIP (clojure.core/str v9764))))
   (clojure.core/let
    [v9764
     (:ec2security-group-name
      m9763
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9764 :com.palletops.awaze.client-builder/undef)
     (. bean9762 setEC2SecurityGroupName (clojure.core/str v9764))))
   (clojure.core/let
    [v9764
     (:ec2security-group-owner-id
      m9763
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9764 :com.palletops.awaze.client-builder/undef)
     (. bean9762 setEC2SecurityGroupOwnerId (clojure.core/str v9764))))
   bean9762))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBClusterSnapshotRequest}
create-dbcluster-snapshot-request
  [m9766]
  (clojure.core/let
   [bean9765
    (new
     com.amazonaws.services.rds.model.CreateDBClusterSnapshotRequest)]
   (clojure.core/let
    [v9767 (:tags m9766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9767 :com.palletops.awaze.client-builder/undef)
     (.
      bean9765
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9886] (rds/tag arg9886)) v9767))))
   (clojure.core/let
    [v9767
     (:dbcluster-snapshot-identifier
      m9766
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9767 :com.palletops.awaze.client-builder/undef)
     (.
      bean9765
      setDBClusterSnapshotIdentifier
      (clojure.core/str v9767))))
   (clojure.core/let
    [v9767
     (:dbcluster-identifier
      m9766
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9767 :com.palletops.awaze.client-builder/undef)
     (. bean9765 setDBClusterIdentifier (clojure.core/str v9767))))
   bean9765))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBInstanceRequest}
delete-dbinstance-request
  [m9769]
  (clojure.core/let
   [bean9768
    (new com.amazonaws.services.rds.model.DeleteDBInstanceRequest)]
   (clojure.core/let
    [v9770
     (:dbinstance-identifier
      m9769
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9770 :com.palletops.awaze.client-builder/undef)
     (. bean9768 setDBInstanceIdentifier (clojure.core/str v9770))))
   (clojure.core/let
    [v9770
     (:skip-final-snapshot
      m9769
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9770 :com.palletops.awaze.client-builder/undef)
     (. bean9768 setSkipFinalSnapshot (clojure.core/boolean v9770))))
   (clojure.core/let
    [v9770
     (:final-dbsnapshot-identifier
      m9769
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9770 :com.palletops.awaze.client-builder/undef)
     (.
      bean9768
      setFinalDBSnapshotIdentifier
      (clojure.core/str v9770))))
   bean9768))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ListTagsForResourceRequest}
list-tags-for-resource-request
  [m9772]
  (clojure.core/let
   [bean9771
    (new com.amazonaws.services.rds.model.ListTagsForResourceRequest)]
   (clojure.core/let
    [v9773 (:filters m9772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9773 :com.palletops.awaze.client-builder/undef)
     (.
      bean9771
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9887] (rds/filter arg9887))
 v9773))))
   (clojure.core/let
    [v9773
     (:resource-name m9772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9773 :com.palletops.awaze.client-builder/undef)
     (. bean9771 setResourceName (clojure.core/str v9773))))
   bean9771))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateDBInstanceRequest}
create-dbinstance-request
  [m9775]
  (clojure.core/let
   [bean9774
    (new com.amazonaws.services.rds.model.CreateDBInstanceRequest)]
   (clojure.core/let
    [v9776 (:engine m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setEngine (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:license-model m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setLicenseModel (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:copy-tags-to-snapshot
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setCopyTagsToSnapshot (clojure.core/boolean v9776))))
   (clojure.core/let
    [v9776
     (:dbparameter-group-name
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDBParameterGroupName (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:dbinstance-class
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDBInstanceClass (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:storage-type m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setStorageType (clojure.core/str v9776))))
   (clojure.core/let
    [v9776 (:iops m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setIops (clojure.core/int v9776))))
   (clojure.core/let
    [v9776
     (:availability-zone
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setAvailabilityZone (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:promotion-tier m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setPromotionTier (clojure.core/int v9776))))
   (clojure.core/let
    [v9776
     (:tde-credential-arn
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setTdeCredentialArn (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:option-group-name
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setOptionGroupName (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:master-user-password
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setMasterUserPassword (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:backup-retention-period
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setBackupRetentionPeriod (clojure.core/int v9776))))
   (clojure.core/let
    [v9776
     (:publicly-accessible
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setPubliclyAccessible (clojure.core/boolean v9776))))
   (clojure.core/let
    [v9776
     (:multi-az m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setMultiAZ (clojure.core/boolean v9776))))
   (clojure.core/let
    [v9776
     (:preferred-maintenance-window
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (.
      bean9774
      setPreferredMaintenanceWindow
      (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:allocated-storage
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setAllocatedStorage (clojure.core/int v9776))))
   (clojure.core/let
    [v9776
     (:dbsecurity-groups
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (.
      bean9774
      setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9888] (clojure.core/str arg9888))
 v9776))))
   (clojure.core/let
    [v9776
     (:storage-encrypted
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setStorageEncrypted (clojure.core/boolean v9776))))
   (clojure.core/let
    [v9776 (:port m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setPort (clojure.core/int v9776))))
   (clojure.core/let
    [v9776 (:tags m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (.
      bean9774
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9889] (rds/tag arg9889)) v9776))))
   (clojure.core/let
    [v9776
     (:dbsubnet-group-name
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDBSubnetGroupName (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:tde-credential-password
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setTdeCredentialPassword (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:dbcluster-identifier
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDBClusterIdentifier (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:monitoring-interval
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setMonitoringInterval (clojure.core/int v9776))))
   (clojure.core/let
    [v9776
     (:preferred-backup-window
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setPreferredBackupWindow (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:dbinstance-identifier
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDBInstanceIdentifier (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:character-set-name
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setCharacterSetName (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:vpc-security-group-ids
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (.
      bean9774
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9890] (clojure.core/str arg9890))
 v9776))))
   (clojure.core/let
    [v9776
     (:auto-minor-version-upgrade
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (.
      bean9774
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v9776))))
   (clojure.core/let
    [v9776
     (:master-username
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setMasterUsername (clojure.core/str v9776))))
   (clojure.core/let
    [v9776 (:domain m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDomain (clojure.core/str v9776))))
   (clojure.core/let
    [v9776 (:dbname m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDBName (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:kms-key-id m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setKmsKeyId (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:engine-version m9775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setEngineVersion (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:domain-iamrole-name
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setDomainIAMRoleName (clojure.core/str v9776))))
   (clojure.core/let
    [v9776
     (:monitoring-role-arn
      m9775
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9776 :com.palletops.awaze.client-builder/undef)
     (. bean9774 setMonitoringRoleArn (clojure.core/str v9776))))
   bean9774))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest}
modify-event-subscription-request
  [m9778]
  (clojure.core/let
   [bean9777
    (new
     com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest)]
   (clojure.core/let
    [v9779 (:enabled m9778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9779 :com.palletops.awaze.client-builder/undef)
     (. bean9777 setEnabled (clojure.core/boolean v9779))))
   (clojure.core/let
    [v9779
     (:source-type m9778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9779 :com.palletops.awaze.client-builder/undef)
     (. bean9777 setSourceType (clojure.core/str v9779))))
   (clojure.core/let
    [v9779
     (:sns-topic-arn m9778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9779 :com.palletops.awaze.client-builder/undef)
     (. bean9777 setSnsTopicArn (clojure.core/str v9779))))
   (clojure.core/let
    [v9779
     (:event-categories
      m9778
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9779 :com.palletops.awaze.client-builder/undef)
     (.
      bean9777
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9891] (clojure.core/str arg9891))
 v9779))))
   (clojure.core/let
    [v9779
     (:subscription-name
      m9778
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9779 :com.palletops.awaze.client-builder/undef)
     (. bean9777 setSubscriptionName (clojure.core/str v9779))))
   bean9777))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest}
describe-dbsnapshots-request
  [m9781]
  (clojure.core/let
   [bean9780
    (new com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest)]
   (clojure.core/let
    [v9782 (:marker m9781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setMarker (clojure.core/str v9782))))
   (clojure.core/let
    [v9782 (:filters m9781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (.
      bean9780
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9892] (rds/filter arg9892))
 v9782))))
   (clojure.core/let
    [v9782
     (:max-records m9781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setMaxRecords (clojure.core/int v9782))))
   (clojure.core/let
    [v9782
     (:dbinstance-identifier
      m9781
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setDBInstanceIdentifier (clojure.core/str v9782))))
   (clojure.core/let
    [v9782
     (:dbsnapshot-identifier
      m9781
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setDBSnapshotIdentifier (clojure.core/str v9782))))
   (clojure.core/let
    [v9782
     (:include-shared m9781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setIncludeShared (clojure.core/boolean v9782))))
   (clojure.core/let
    [v9782
     (:include-public m9781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setIncludePublic (clojure.core/boolean v9782))))
   (clojure.core/let
    [v9782
     (:snapshot-type m9781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9782 :com.palletops.awaze.client-builder/undef)
     (. bean9780 setSnapshotType (clojure.core/str v9782))))
   bean9780))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyDBInstanceRequest}
modify-dbinstance-request
  [m9784]
  (clojure.core/let
   [bean9783
    (new com.amazonaws.services.rds.model.ModifyDBInstanceRequest)]
   (clojure.core/let
    [v9785
     (:copy-tags-to-snapshot
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setCopyTagsToSnapshot (clojure.core/boolean v9785))))
   (clojure.core/let
    [v9785
     (:dbparameter-group-name
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setDBParameterGroupName (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:dbinstance-class
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setDBInstanceClass (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:storage-type m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setStorageType (clojure.core/str v9785))))
   (clojure.core/let
    [v9785 (:iops m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setIops (clojure.core/int v9785))))
   (clojure.core/let
    [v9785
     (:promotion-tier m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setPromotionTier (clojure.core/int v9785))))
   (clojure.core/let
    [v9785
     (:tde-credential-arn
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setTdeCredentialArn (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:option-group-name
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setOptionGroupName (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:master-user-password
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setMasterUserPassword (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:backup-retention-period
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setBackupRetentionPeriod (clojure.core/int v9785))))
   (clojure.core/let
    [v9785
     (:apply-immediately
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setApplyImmediately (clojure.core/boolean v9785))))
   (clojure.core/let
    [v9785
     (:allow-major-version-upgrade
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (.
      bean9783
      setAllowMajorVersionUpgrade
      (clojure.core/boolean v9785))))
   (clojure.core/let
    [v9785
     (:publicly-accessible
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setPubliclyAccessible (clojure.core/boolean v9785))))
   (clojure.core/let
    [v9785
     (:multi-az m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setMultiAZ (clojure.core/boolean v9785))))
   (clojure.core/let
    [v9785
     (:preferred-maintenance-window
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (.
      bean9783
      setPreferredMaintenanceWindow
      (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:allocated-storage
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setAllocatedStorage (clojure.core/int v9785))))
   (clojure.core/let
    [v9785
     (:new-dbinstance-identifier
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setNewDBInstanceIdentifier (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:dbsecurity-groups
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (.
      bean9783
      setDBSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9893] (clojure.core/str arg9893))
 v9785))))
   (clojure.core/let
    [v9785
     (:tde-credential-password
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setTdeCredentialPassword (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:monitoring-interval
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setMonitoringInterval (clojure.core/int v9785))))
   (clojure.core/let
    [v9785
     (:preferred-backup-window
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setPreferredBackupWindow (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:dbinstance-identifier
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setDBInstanceIdentifier (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:vpc-security-group-ids
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (.
      bean9783
      setVpcSecurityGroupIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9894] (clojure.core/str arg9894))
 v9785))))
   (clojure.core/let
    [v9785
     (:auto-minor-version-upgrade
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (.
      bean9783
      setAutoMinorVersionUpgrade
      (clojure.core/boolean v9785))))
   (clojure.core/let
    [v9785
     (:dbport-number m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setDBPortNumber (clojure.core/int v9785))))
   (clojure.core/let
    [v9785 (:domain m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setDomain (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:engine-version m9784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setEngineVersion (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:domain-iamrole-name
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setDomainIAMRoleName (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:cacertificate-identifier
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setCACertificateIdentifier (clojure.core/str v9785))))
   (clojure.core/let
    [v9785
     (:monitoring-role-arn
      m9784
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9785 :com.palletops.awaze.client-builder/undef)
     (. bean9783 setMonitoringRoleArn (clojure.core/str v9785))))
   bean9783))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBClusterRequest}
delete-dbcluster-request
  [m9787]
  (clojure.core/let
   [bean9786
    (new com.amazonaws.services.rds.model.DeleteDBClusterRequest)]
   (clojure.core/let
    [v9788
     (:dbcluster-identifier
      m9787
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9788 :com.palletops.awaze.client-builder/undef)
     (. bean9786 setDBClusterIdentifier (clojure.core/str v9788))))
   (clojure.core/let
    [v9788
     (:skip-final-snapshot
      m9787
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9788 :com.palletops.awaze.client-builder/undef)
     (. bean9786 setSkipFinalSnapshot (clojure.core/boolean v9788))))
   (clojure.core/let
    [v9788
     (:final-dbsnapshot-identifier
      m9787
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9788 :com.palletops.awaze.client-builder/undef)
     (.
      bean9786
      setFinalDBSnapshotIdentifier
      (clojure.core/str v9788))))
   bean9786))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeAccountAttributesRequest}
describe-account-attributes-request
  [m9790]
  (clojure.core/let
   [bean9789
    (new
     com.amazonaws.services.rds.model.DescribeAccountAttributesRequest)]
   bean9789))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DeleteDBClusterParameterGroupRequest}
delete-dbcluster-parameter-group-request
  [m9793]
  (clojure.core/let
   [bean9792
    (new
     com.amazonaws.services.rds.model.DeleteDBClusterParameterGroupRequest)]
   (clojure.core/let
    [v9794
     (:dbcluster-parameter-group-name
      m9793
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9794 :com.palletops.awaze.client-builder/undef)
     (.
      bean9792
      setDBClusterParameterGroupName
      (clojure.core/str v9794))))
   bean9792))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBInstancesRequest}
describe-dbinstances-request
  [m9796]
  (clojure.core/let
   [bean9795
    (new com.amazonaws.services.rds.model.DescribeDBInstancesRequest)]
   (clojure.core/let
    [v9797 (:marker m9796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9797 :com.palletops.awaze.client-builder/undef)
     (. bean9795 setMarker (clojure.core/str v9797))))
   (clojure.core/let
    [v9797 (:filters m9796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9797 :com.palletops.awaze.client-builder/undef)
     (.
      bean9795
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9895] (rds/filter arg9895))
 v9797))))
   (clojure.core/let
    [v9797
     (:max-records m9796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9797 :com.palletops.awaze.client-builder/undef)
     (. bean9795 setMaxRecords (clojure.core/int v9797))))
   (clojure.core/let
    [v9797
     (:dbinstance-identifier
      m9796
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9797 :com.palletops.awaze.client-builder/undef)
     (. bean9795 setDBInstanceIdentifier (clojure.core/str v9797))))
   bean9795))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyOptionGroupRequest}
copy-option-group-request
  [m9799]
  (clojure.core/let
   [bean9798
    (new com.amazonaws.services.rds.model.CopyOptionGroupRequest)]
   (clojure.core/let
    [v9800 (:tags m9799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9800 :com.palletops.awaze.client-builder/undef)
     (.
      bean9798
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9896] (rds/tag arg9896)) v9800))))
   (clojure.core/let
    [v9800
     (:target-option-group-description
      m9799
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9800 :com.palletops.awaze.client-builder/undef)
     (.
      bean9798
      setTargetOptionGroupDescription
      (clojure.core/str v9800))))
   (clojure.core/let
    [v9800
     (:source-option-group-identifier
      m9799
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9800 :com.palletops.awaze.client-builder/undef)
     (.
      bean9798
      setSourceOptionGroupIdentifier
      (clojure.core/str v9800))))
   (clojure.core/let
    [v9800
     (:target-option-group-identifier
      m9799
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9800 :com.palletops.awaze.client-builder/undef)
     (.
      bean9798
      setTargetOptionGroupIdentifier
      (clojure.core/str v9800))))
   bean9798))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.FailoverDBClusterRequest}
failover-dbcluster-request
  [m9802]
  (clojure.core/let
   [bean9801
    (new com.amazonaws.services.rds.model.FailoverDBClusterRequest)]
   (clojure.core/let
    [v9803
     (:dbcluster-identifier
      m9802
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9803 :com.palletops.awaze.client-builder/undef)
     (. bean9801 setDBClusterIdentifier (clojure.core/str v9803))))
   bean9801))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest}
purchase-reserved-dbinstances-offering-request
  [m9805]
  (clojure.core/let
   [bean9804
    (new
     com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest)]
   (clojure.core/let
    [v9806 (:tags m9805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9806 :com.palletops.awaze.client-builder/undef)
     (.
      bean9804
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9897] (rds/tag arg9897)) v9806))))
   (clojure.core/let
    [v9806
     (:reserved-dbinstances-offering-id
      m9805
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9806 :com.palletops.awaze.client-builder/undef)
     (.
      bean9804
      setReservedDBInstancesOfferingId
      (clojure.core/str v9806))))
   (clojure.core/let
    [v9806
     (:reserved-dbinstance-id
      m9805
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9806 :com.palletops.awaze.client-builder/undef)
     (. bean9804 setReservedDBInstanceId (clojure.core/str v9806))))
   (clojure.core/let
    [v9806
     (:dbinstance-count
      m9805
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9806 :com.palletops.awaze.client-builder/undef)
     (. bean9804 setDBInstanceCount (clojure.core/int v9806))))
   bean9804))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest}
download-dblog-file-portion-request
  [m9808]
  (clojure.core/let
   [bean9807
    (new
     com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest)]
   (clojure.core/let
    [v9809 (:marker m9808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9809 :com.palletops.awaze.client-builder/undef)
     (. bean9807 setMarker (clojure.core/str v9809))))
   (clojure.core/let
    [v9809
     (:dbinstance-identifier
      m9808
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9809 :com.palletops.awaze.client-builder/undef)
     (. bean9807 setDBInstanceIdentifier (clojure.core/str v9809))))
   (clojure.core/let
    [v9809
     (:log-file-name m9808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9809 :com.palletops.awaze.client-builder/undef)
     (. bean9807 setLogFileName (clojure.core/str v9809))))
   (clojure.core/let
    [v9809
     (:number-of-lines
      m9808
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9809 :com.palletops.awaze.client-builder/undef)
     (. bean9807 setNumberOfLines (clojure.core/int v9809))))
   bean9807))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest}
describe-orderable-dbinstance-options-request
  [m9811]
  (clojure.core/let
   [bean9810
    (new
     com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest)]
   (clojure.core/let
    [v9812 (:marker m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setMarker (clojure.core/str v9812))))
   (clojure.core/let
    [v9812 (:filters m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (.
      bean9810
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9898] (rds/filter arg9898))
 v9812))))
   (clojure.core/let
    [v9812
     (:max-records m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setMaxRecords (clojure.core/int v9812))))
   (clojure.core/let
    [v9812 (:engine m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setEngine (clojure.core/str v9812))))
   (clojure.core/let
    [v9812
     (:engine-version m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setEngineVersion (clojure.core/str v9812))))
   (clojure.core/let
    [v9812
     (:dbinstance-class
      m9811
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setDBInstanceClass (clojure.core/str v9812))))
   (clojure.core/let
    [v9812
     (:license-model m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setLicenseModel (clojure.core/str v9812))))
   (clojure.core/let
    [v9812 (:vpc m9811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9812 :com.palletops.awaze.client-builder/undef)
     (. bean9810 setVpc (clojure.core/boolean v9812))))
   bean9810))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBLogFilesRequest}
describe-dblog-files-request
  [m9814]
  (clojure.core/let
   [bean9813
    (new com.amazonaws.services.rds.model.DescribeDBLogFilesRequest)]
   (clojure.core/let
    [v9815 (:marker m9814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (. bean9813 setMarker (clojure.core/str v9815))))
   (clojure.core/let
    [v9815 (:filters m9814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (.
      bean9813
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9899] (rds/filter arg9899))
 v9815))))
   (clojure.core/let
    [v9815
     (:max-records m9814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (. bean9813 setMaxRecords (clojure.core/int v9815))))
   (clojure.core/let
    [v9815
     (:dbinstance-identifier
      m9814
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (. bean9813 setDBInstanceIdentifier (clojure.core/str v9815))))
   (clojure.core/let
    [v9815
     (:file-size m9814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (. bean9813 setFileSize (clojure.core/long v9815))))
   (clojure.core/let
    [v9815
     (:filename-contains
      m9814
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (. bean9813 setFilenameContains (clojure.core/str v9815))))
   (clojure.core/let
    [v9815
     (:file-last-written
      m9814
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9815 :com.palletops.awaze.client-builder/undef)
     (. bean9813 setFileLastWritten (clojure.core/long v9815))))
   bean9813))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ResetDBClusterParameterGroupRequest}
reset-dbcluster-parameter-group-request
  [m9817]
  (clojure.core/let
   [bean9816
    (new
     com.amazonaws.services.rds.model.ResetDBClusterParameterGroupRequest)]
   (clojure.core/let
    [v9818
     (:dbcluster-parameter-group-name
      m9817
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9818 :com.palletops.awaze.client-builder/undef)
     (.
      bean9816
      setDBClusterParameterGroupName
      (clojure.core/str v9818))))
   (clojure.core/let
    [v9818
     (:parameters m9817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9818 :com.palletops.awaze.client-builder/undef)
     (.
      bean9816
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9980] (rds/parameter arg9980))
 v9818))))
   (clojure.core/let
    [v9818
     (:reset-all-parameters
      m9817
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9818 :com.palletops.awaze.client-builder/undef)
     (. bean9816 setResetAllParameters (clojure.core/boolean v9818))))
   bean9816))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest}
describe-event-subscriptions-request
  [m9820]
  (clojure.core/let
   [bean9819
    (new
     com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest)]
   (clojure.core/let
    [v9821 (:marker m9820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9821 :com.palletops.awaze.client-builder/undef)
     (. bean9819 setMarker (clojure.core/str v9821))))
   (clojure.core/let
    [v9821 (:filters m9820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9821 :com.palletops.awaze.client-builder/undef)
     (.
      bean9819
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9981] (rds/filter arg9981))
 v9821))))
   (clojure.core/let
    [v9821
     (:max-records m9820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9821 :com.palletops.awaze.client-builder/undef)
     (. bean9819 setMaxRecords (clojure.core/int v9821))))
   (clojure.core/let
    [v9821
     (:subscription-name
      m9820
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9821 :com.palletops.awaze.client-builder/undef)
     (. bean9819 setSubscriptionName (clojure.core/str v9821))))
   bean9819))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.ModifyOptionGroupRequest}
modify-option-group-request
  [m9823]
  (clojure.core/let
   [bean9822
    (new com.amazonaws.services.rds.model.ModifyOptionGroupRequest)]
   (clojure.core/let
    [v9824
     (:apply-immediately
      m9823
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9824 :com.palletops.awaze.client-builder/undef)
     (. bean9822 setApplyImmediately (clojure.core/boolean v9824))))
   (clojure.core/let
    [v9824
     (:option-group-name
      m9823
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9824 :com.palletops.awaze.client-builder/undef)
     (. bean9822 setOptionGroupName (clojure.core/str v9824))))
   (clojure.core/let
    [v9824
     (:options-to-include
      m9823
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9824 :com.palletops.awaze.client-builder/undef)
     (.
      bean9822
      setOptionsToInclude
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9982] (rds/option-configuration arg9982))
 v9824))))
   (clojure.core/let
    [v9824
     (:options-to-remove
      m9823
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9824 :com.palletops.awaze.client-builder/undef)
     (.
      bean9822
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9983] (clojure.core/str arg9983))
 v9824))))
   bean9822))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CopyDBClusterSnapshotRequest}
copy-dbcluster-snapshot-request
  [m9826]
  (clojure.core/let
   [bean9825
    (new
     com.amazonaws.services.rds.model.CopyDBClusterSnapshotRequest)]
   (clojure.core/let
    [v9827 (:tags m9826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9827 :com.palletops.awaze.client-builder/undef)
     (.
      bean9825
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9984] (rds/tag arg9984)) v9827))))
   (clojure.core/let
    [v9827
     (:source-dbcluster-snapshot-identifier
      m9826
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9827 :com.palletops.awaze.client-builder/undef)
     (.
      bean9825
      setSourceDBClusterSnapshotIdentifier
      (clojure.core/str v9827))))
   (clojure.core/let
    [v9827
     (:target-dbcluster-snapshot-identifier
      m9826
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9827 :com.palletops.awaze.client-builder/undef)
     (.
      bean9825
      setTargetDBClusterSnapshotIdentifier
      (clojure.core/str v9827))))
   bean9825))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.CreateEventSubscriptionRequest}
create-event-subscription-request
  [m9829]
  (clojure.core/let
   [bean9828
    (new
     com.amazonaws.services.rds.model.CreateEventSubscriptionRequest)]
   (clojure.core/let
    [v9830 (:tags m9829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (.
      bean9828
      setTags
^{:tag java.util.Collection}
(clojure.core/map (clojure.core/fn [arg9985] (rds/tag arg9985)) v9830))))
   (clojure.core/let
    [v9830 (:enabled m9829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (. bean9828 setEnabled (clojure.core/boolean v9830))))
   (clojure.core/let
    [v9830
     (:source-type m9829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (. bean9828 setSourceType (clojure.core/str v9830))))
   (clojure.core/let
    [v9830
     (:sns-topic-arn m9829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (. bean9828 setSnsTopicArn (clojure.core/str v9830))))
   (clojure.core/let
    [v9830
     (:source-ids m9829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (.
      bean9828
      setSourceIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9986] (clojure.core/str arg9986))
 v9830))))
   (clojure.core/let
    [v9830
     (:event-categories
      m9829
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (.
      bean9828
      setEventCategories
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9987] (clojure.core/str arg9987))
 v9830))))
   (clojure.core/let
    [v9830
     (:subscription-name
      m9829
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9830 :com.palletops.awaze.client-builder/undef)
     (. bean9828 setSubscriptionName (clojure.core/str v9830))))
   bean9828))
 (clojure.core/defn
^{:tag com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest}
describe-dbsecurity-groups-request
  [m9832]
  (clojure.core/let
   [bean9831
    (new
     com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest)]
   (clojure.core/let
    [v9833 (:marker m9832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9833 :com.palletops.awaze.client-builder/undef)
     (. bean9831 setMarker (clojure.core/str v9833))))
   (clojure.core/let
    [v9833 (:filters m9832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9833 :com.palletops.awaze.client-builder/undef)
     (.
      bean9831
      setFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9988] (rds/filter arg9988))
 v9833))))
   (clojure.core/let
    [v9833
     (:max-records m9832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9833 :com.palletops.awaze.client-builder/undef)
     (. bean9831 setMaxRecords (clojure.core/int v9833))))
   (clojure.core/let
    [v9833
     (:dbsecurity-group-name
      m9832
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v9833 :com.palletops.awaze.client-builder/undef)
     (. bean9831 setDBSecurityGroupName (clojure.core/str v9833))))
   bean9831))
 (clojure.core/defmulti
  rds
  (clojure.core/fn rds [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbcluster-parameters
   [m9900]
   (clojure.core/let
    [credentials9901 (:credentials m9900) args9902 (:args m9900)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9903
      (com.palletops.awaze.common/aws-client :rds credentials9901)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9903
       describeDBClusterParameters
       (rds/describe-dbcluster-parameters-request
        (clojure.core/nth args9902 0)))))))
  (clojure.core/defn
   describe-dbcluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDBClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbcluster-parameters,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbcluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDBClusterParameters"}
   [credentials9905 & args9906]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9907
     (com.palletops.awaze.common/aws-client :rds credentials9905)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9907
      describeDBClusterParameters
      (rds/describe-dbcluster-parameters-request
       (clojure.core/nth args9906 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance-read-replica
   [m9908]
   (clojure.core/let
    [credentials9909 (:credentials m9908) args9910 (:args m9908)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9911
      (com.palletops.awaze.common/aws-client :rds credentials9909)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9911
       createDBInstanceReadReplica
       (rds/create-dbinstance-read-replica-request
        (clojure.core/nth args9910 0)))))))
  (clojure.core/defn
   create-dbinstance-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [source-dbinstance-identifier
                         tags
                         monitoring-role-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         dbsubnet-group-name
                         custom-query-parameters
                         iops
                         availability-zone
                         port
                         option-group-name
                         publicly-accessible
                         read-limit
                         dbinstance-class
                         general-progress-listener
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root
                         monitoring-interval]}]]),
    :doc "Generate map for createDBInstanceReadReplica"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbinstance-read-replica,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbinstance-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [source-dbinstance-identifier
                         tags
                         monitoring-role-arn
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         dbsubnet-group-name
                         custom-query-parameters
                         iops
                         availability-zone
                         port
                         option-group-name
                         publicly-accessible
                         read-limit
                         dbinstance-class
                         general-progress-listener
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root
                         monitoring-interval]}]]),
    :doc "Call createDBInstanceReadReplica"}
   [credentials9913 & args9914]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9915
     (com.palletops.awaze.common/aws-client :rds credentials9913)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9915
      createDBInstanceReadReplica
      (rds/create-dbinstance-read-replica-request
       (clojure.core/nth args9914 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbparameter-group
   [m9916]
   (clojure.core/let
    [credentials9917 (:credentials m9916) args9918 (:args m9916)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9919
      (com.palletops.awaze.common/aws-client :rds credentials9917)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9919
       modifyDBParameterGroup
       (rds/modify-dbparameter-group-request
        (clojure.core/nth args9918 0)))))))
  (clojure.core/defn
   modify-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyDBParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-dbparameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyDBParameterGroup"}
   [credentials9921 & args9922]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9923
     (com.palletops.awaze.common/aws-client :rds credentials9921)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9923
      modifyDBParameterGroup
      (rds/modify-dbparameter-group-request
       (clojure.core/nth args9922 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsnapshot
   [m9924]
   (clojure.core/let
    [credentials9925 (:credentials m9924) args9926 (:args m9924)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9927
      (com.palletops.awaze.common/aws-client :rds credentials9925)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9927
       createDBSnapshot
       (rds/create-dbsnapshot-request (clojure.core/nth args9926 0)))))))
  (clojure.core/defn
   create-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Generate map for createDBSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbsnapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Call createDBSnapshot"}
   [credentials9929 & args9930]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9931
     (com.palletops.awaze.common/aws-client :rds credentials9929)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9931
      createDBSnapshot
      (rds/create-dbsnapshot-request (clojure.core/nth args9930 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbcluster
   [m9932]
   (clojure.core/let
    [credentials9933 (:credentials m9932) args9934 (:args m9932)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9935
      (com.palletops.awaze.common/aws-client :rds credentials9933)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9935
       modifyDBCluster
       (rds/modify-dbcluster-request (clojure.core/nth args9934 0)))))))
  (clojure.core/defn
   modify-dbcluster-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         vpc-security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         preferred-backup-window
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         option-group-name
                         read-limit
                         new-dbcluster-identifier
                         apply-immediately
                         general-progress-listener
                         backup-retention-period
                         dbcluster-parameter-group-name
                         master-user-password
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyDBCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-dbcluster,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-dbcluster
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         vpc-security-group-ids
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         preferred-backup-window
                         sdk-request-timeout
                         custom-query-parameters
                         port
                         option-group-name
                         read-limit
                         new-dbcluster-identifier
                         apply-immediately
                         general-progress-listener
                         backup-retention-period
                         dbcluster-parameter-group-name
                         master-user-password
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyDBCluster"}
   [credentials9937 & args9938]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9939
     (com.palletops.awaze.common/aws-client :rds credentials9937)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9939
      modifyDBCluster
      (rds/modify-dbcluster-request (clojure.core/nth args9938 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances
   [m9940]
   (clojure.core/let
    [credentials9941 (:credentials m9940) args9942 (:args m9940)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9943
      (com.palletops.awaze.common/aws-client :rds credentials9941)]
     (clojure.core/case
      (clojure.core/count args9942)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9943
        describeReservedDBInstances))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9943
        describeReservedDBInstances
        (rds/describe-reserved-dbinstances-request
         (clojure.core/nth args9942 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-dbinstance-id
                         offering-type
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         duration
                         reserved-dbinstances-offering-id
                         read-limit
                         dbinstance-class
                         product-description
                         multi-az
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedDBInstances, describeReservedDBInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-dbinstances,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-reserved-dbinstances
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         reserved-dbinstance-id
                         offering-type
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         duration
                         reserved-dbinstances-offering-id
                         read-limit
                         dbinstance-class
                         product-description
                         multi-az
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedDBInstances, describeReservedDBInstances"}
   [credentials9945 & args9946]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9947
     (com.palletops.awaze.common/aws-client :rds credentials9945)]
    (clojure.core/case
     (clojure.core/count args9946)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9947
       describeReservedDBInstances))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9947
       describeReservedDBInstances
       (rds/describe-reserved-dbinstances-request
        (clojure.core/nth args9946 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbclusters
   [m9948]
   (clojure.core/let
    [credentials9949 (:credentials m9948) args9950 (:args m9948)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9951
      (com.palletops.awaze.common/aws-client :rds credentials9949)]
     (clojure.core/case
      (clojure.core/count args9950)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9951
        describeDBClusters
        (rds/describe-dbclusters-request
         (clojure.core/nth args9950 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9951
        describeDBClusters))))))
  (clojure.core/defn
   describe-dbclusters-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBClusters, describeDBClusters"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbclusters,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbclusters,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbclusters
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBClusters, describeDBClusters"}
   [credentials9953 & args9954]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9955
     (com.palletops.awaze.common/aws-client :rds credentials9953)]
    (clojure.core/case
     (clojure.core/count args9954)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9955
       describeDBClusters
       (rds/describe-dbclusters-request (clojure.core/nth args9954 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9955
       describeDBClusters))))))
 (do
  (clojure.core/defmethod
   rds
   :add-tags-to-resource
   [m9956]
   (clojure.core/let
    [credentials9957 (:credentials m9956) args9958 (:args m9956)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9959
      (com.palletops.awaze.common/aws-client :rds credentials9957)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9959
       addTagsToResource
       (rds/add-tags-to-resource-request
        (clojure.core/nth args9958 0)))))))
  (clojure.core/defn
   add-tags-to-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-resource,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   add-tags-to-resource
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToResource"}
   [credentials9961 & args9962]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9963
     (com.palletops.awaze.common/aws-client :rds credentials9961)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9963
      addTagsToResource
      (rds/add-tags-to-resource-request (clojure.core/nth args9962 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-events
   [m9964]
   (clojure.core/let
    [credentials9965 (:credentials m9964) args9966 (:args m9964)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9967
      (com.palletops.awaze.common/aws-client :rds credentials9965)]
     (clojure.core/case
      (clojure.core/count args9966)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9967
        describeEvents))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9967
        describeEvents
        (rds/describe-events-request (clojure.core/nth args9966 0))))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         event-categories
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         source-type
                         start-time
                         custom-query-parameters
                         end-time
                         duration
                         read-limit
                         source-identifier
                         general-progress-listener
                         max-records
                         event-categories
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials9969 & args9970]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9971
     (com.palletops.awaze.common/aws-client :rds credentials9969)]
    (clojure.core/case
     (clojure.core/count args9970)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9971
       describeEvents))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9971
       describeEvents
       (rds/describe-events-request (clojure.core/nth args9970 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-source-identifier-from-subscription
   [m9972]
   (clojure.core/let
    [credentials9973 (:credentials m9972) args9974 (:args m9972)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9975
      (com.palletops.awaze.common/aws-client :rds credentials9973)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9975
       removeSourceIdentifierFromSubscription
       (rds/remove-source-identifier-from-subscription-request
        (clojure.core/nth args9974 0)))))))
  (clojure.core/defn
   remove-source-identifier-from-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-identifier
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeSourceIdentifierFromSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-source-identifier-from-subscription,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   remove-source-identifier-from-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-identifier
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeSourceIdentifierFromSubscription"}
   [credentials9977 & args9978]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9979
     (com.palletops.awaze.common/aws-client :rds credentials9977)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9979
      removeSourceIdentifierFromSubscription
      (rds/remove-source-identifier-from-subscription-request
       (clojure.core/nth args9978 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbparameter-group
   [m9989]
   (clojure.core/let
    [credentials9990 (:credentials m9989) args9991 (:args m9989)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client9992
      (com.palletops.awaze.common/aws-client :rds credentials9990)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9992
       copyDBParameterGroup
       (rds/copy-dbparameter-group-request
        (clojure.core/nth args9991 0)))))))
  (clojure.core/defn
   copy-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         target-dbparameter-group-description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-dbparameter-group-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         source-dbparameter-group-identifier]}]]),
    :doc "Generate map for copyDBParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-dbparameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   copy-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         target-dbparameter-group-description
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         target-dbparameter-group-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         source-dbparameter-group-identifier]}]]),
    :doc "Call copyDBParameterGroup"}
   [credentials9994 & args9995]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client9996
     (com.palletops.awaze.common/aws-client :rds credentials9994)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client9996
      copyDBParameterGroup
      (rds/copy-dbparameter-group-request
       (clojure.core/nth args9995 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbsnapshot
   [m9997]
   (clojure.core/let
    [credentials9998 (:credentials m9997) args9999 (:args m9997)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10000
      (com.palletops.awaze.common/aws-client :rds credentials9998)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10000
       copyDBSnapshot
       (rds/copy-dbsnapshot-request (clojure.core/nth args9999 0)))))))
  (clojure.core/defn
   copy-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         copy-tags
                         sdk-request-timeout
                         custom-query-parameters
                         source-dbsnapshot-identifier
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         clone-root
                         target-dbsnapshot-identifier]}]]),
    :doc "Generate map for copyDBSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-dbsnapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   copy-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         copy-tags
                         sdk-request-timeout
                         custom-query-parameters
                         source-dbsnapshot-identifier
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         clone-root
                         target-dbsnapshot-identifier]}]]),
    :doc "Call copyDBSnapshot"}
   [credentials10002 & args10003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10004
     (com.palletops.awaze.common/aws-client :rds credentials10002)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10004
      copyDBSnapshot
      (rds/copy-dbsnapshot-request (clojure.core/nth args10003 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-event-subscription
   [m10005]
   (clojure.core/let
    [credentials10006 (:credentials m10005) args10007 (:args m10005)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10008
      (com.palletops.awaze.common/aws-client :rds credentials10006)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10008
       deleteEventSubscription
       (rds/delete-event-subscription-request
        (clojure.core/nth args10007 0)))))))
  (clojure.core/defn
   delete-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-event-subscription,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEventSubscription"}
   [credentials10010 & args10011]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10012
     (com.palletops.awaze.common/aws-client :rds credentials10010)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10012
      deleteEventSubscription
      (rds/delete-event-subscription-request
       (clojure.core/nth args10011 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsecurity-group
   [m10013]
   (clojure.core/let
    [credentials10014 (:credentials m10013) args10015 (:args m10013)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10016
      (com.palletops.awaze.common/aws-client :rds credentials10014)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10016
       createDBSecurityGroup
       (rds/create-dbsecurity-group-request
        (clojure.core/nth args10015 0)))))))
  (clojure.core/defn
   create-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-description
                         dbsecurity-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDBSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbsecurity-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-description
                         dbsecurity-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDBSecurityGroup"}
   [credentials10018 & args10019]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10020
     (com.palletops.awaze.common/aws-client :rds credentials10018)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10020
      createDBSecurityGroup
      (rds/create-dbsecurity-group-request
       (clojure.core/nth args10019 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbsubnet-group
   [m10021]
   (clojure.core/let
    [credentials10022 (:credentials m10021) args10023 (:args m10021)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10024
      (com.palletops.awaze.common/aws-client :rds credentials10022)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10024
       createDBSubnetGroup
       (rds/create-dbsubnet-group-request
        (clojure.core/nth args10023 0)))))))
  (clojure.core/defn
   create-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsubnet-group-name
                         custom-query-parameters
                         dbsubnet-group-description
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDBSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbsubnet-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsubnet-group-name
                         custom-query-parameters
                         dbsubnet-group-description
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDBSubnetGroup"}
   [credentials10026 & args10027]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10028
     (com.palletops.awaze.common/aws-client :rds credentials10026)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10028
      createDBSubnetGroup
      (rds/create-dbsubnet-group-request
       (clojure.core/nth args10027 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-certificates
   [m10029]
   (clojure.core/let
    [credentials10030 (:credentials m10029) args10031 (:args m10029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10032
      (com.palletops.awaze.common/aws-client :rds credentials10030)]
     (clojure.core/case
      (clojure.core/count args10031)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10032
        describeCertificates))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10032
        describeCertificates
        (rds/describe-certificates-request
         (clojure.core/nth args10031 0))))))))
  (clojure.core/defn
   describe-certificates-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [certificate-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeCertificates, describeCertificates"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-certificates,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-certificates,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-certificates
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [certificate-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeCertificates, describeCertificates"}
   [credentials10034 & args10035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10036
     (com.palletops.awaze.common/aws-client :rds credentials10034)]
    (clojure.core/case
     (clojure.core/count args10035)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10036
       describeCertificates))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10036
       describeCertificates
       (rds/describe-certificates-request
        (clojure.core/nth args10035 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbsubnet-group
   [m10037]
   (clojure.core/let
    [credentials10038 (:credentials m10037) args10039 (:args m10037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10040
      (com.palletops.awaze.common/aws-client :rds credentials10038)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10040
       modifyDBSubnetGroup
       (rds/modify-dbsubnet-group-request
        (clojure.core/nth args10039 0)))))))
  (clojure.core/defn
   modify-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsubnet-group-name
                         custom-query-parameters
                         dbsubnet-group-description
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyDBSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-dbsubnet-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsubnet-group-name
                         custom-query-parameters
                         dbsubnet-group-description
                         read-limit
                         subnet-ids
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyDBSubnetGroup"}
   [credentials10042 & args10043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10044
     (com.palletops.awaze.common/aws-client :rds credentials10042)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10044
      modifyDBSubnetGroup
      (rds/modify-dbsubnet-group-request
       (clojure.core/nth args10043 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-engine-default-cluster-parameters
   [m10045]
   (clojure.core/let
    [credentials10046 (:credentials m10045) args10047 (:args m10045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10048
      (com.palletops.awaze.common/aws-client :rds credentials10046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10048
       describeEngineDefaultClusterParameters
       (rds/describe-engine-default-cluster-parameters-request
        (clojure.core/nth args10047 0)))))))
  (clojure.core/defn
   describe-engine-default-cluster-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultClusterParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-engine-default-cluster-parameters,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-engine-default-cluster-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultClusterParameters"}
   [credentials10050 & args10051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10052
     (com.palletops.awaze.common/aws-client :rds credentials10050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10052
      describeEngineDefaultClusterParameters
      (rds/describe-engine-default-cluster-parameters-request
       (clojure.core/nth args10051 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsubnet-group
   [m10053]
   (clojure.core/let
    [credentials10054 (:credentials m10053) args10055 (:args m10053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10056
      (com.palletops.awaze.common/aws-client :rds credentials10054)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10056
       deleteDBSubnetGroup
       (rds/delete-dbsubnet-group-request
        (clojure.core/nth args10055 0)))))))
  (clojure.core/defn
   delete-dbsubnet-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsubnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBSubnetGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbsubnet-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbsubnet-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsubnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBSubnetGroup"}
   [credentials10058 & args10059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10060
     (com.palletops.awaze.common/aws-client :rds credentials10058)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10060
      deleteDBSubnetGroup
      (rds/delete-dbsubnet-group-request
       (clojure.core/nth args10059 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsnapshot
   [m10061]
   (clojure.core/let
    [credentials10062 (:credentials m10061) args10063 (:args m10061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10064
      (com.palletops.awaze.common/aws-client :rds credentials10062)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10064
       deleteDBSnapshot
       (rds/delete-dbsnapshot-request (clojure.core/nth args10063 0)))))))
  (clojure.core/defn
   delete-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbsnapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBSnapshot"}
   [credentials10066 & args10067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10068
     (com.palletops.awaze.common/aws-client :rds credentials10066)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10068
      deleteDBSnapshot
      (rds/delete-dbsnapshot-request (clojure.core/nth args10067 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :reset-dbparameter-group
   [m10069]
   (clojure.core/let
    [credentials10070 (:credentials m10069) args10071 (:args m10069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10072
      (com.palletops.awaze.common/aws-client :rds credentials10070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10072
       resetDBParameterGroup
       (rds/reset-dbparameter-group-request
        (clojure.core/nth args10071 0)))))))
  (clojure.core/defn
   reset-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetDBParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-dbparameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   reset-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetDBParameterGroup"}
   [credentials10074 & args10075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10076
     (com.palletops.awaze.common/aws-client :rds credentials10074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10076
      resetDBParameterGroup
      (rds/reset-dbparameter-group-request
       (clojure.core/nth args10075 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbengine-versions
   [m10077]
   (clojure.core/let
    [credentials10078 (:credentials m10077) args10079 (:args m10077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10080
      (com.palletops.awaze.common/aws-client :rds credentials10078)]
     (clojure.core/case
      (clojure.core/count args10079)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10080
        describeDBEngineVersions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10080
        describeDBEngineVersions
        (rds/describe-dbengine-versions-request
         (clojure.core/nth args10079 0))))))))
  (clojure.core/defn
   describe-dbengine-versions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         max-records
                         list-supported-character-sets
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for describeDBEngineVersions, describeDBEngineVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbengine-versions,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbengine-versions,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbengine-versions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         default-only
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         max-records
                         list-supported-character-sets
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Call describeDBEngineVersions, describeDBEngineVersions"}
   [credentials10082 & args10083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10084
     (com.palletops.awaze.common/aws-client :rds credentials10082)]
    (clojure.core/case
     (clojure.core/count args10083)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10084
       describeDBEngineVersions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10084
       describeDBEngineVersions
       (rds/describe-dbengine-versions-request
        (clojure.core/nth args10083 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :add-source-identifier-to-subscription
   [m10085]
   (clojure.core/let
    [credentials10086 (:credentials m10085) args10087 (:args m10085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10088
      (com.palletops.awaze.common/aws-client :rds credentials10086)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10088
       addSourceIdentifierToSubscription
       (rds/add-source-identifier-to-subscription-request
        (clojure.core/nth args10087 0)))))))
  (clojure.core/defn
   add-source-identifier-to-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-identifier
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addSourceIdentifierToSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-source-identifier-to-subscription,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   add-source-identifier-to-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-identifier
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addSourceIdentifierToSubscription"}
   [credentials10090 & args10091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10092
     (com.palletops.awaze.common/aws-client :rds credentials10090)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10092
      addSourceIdentifierToSubscription
      (rds/add-source-identifier-to-subscription-request
       (clojure.core/nth args10091 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-pending-maintenance-actions
   [m10093]
   (clojure.core/let
    [credentials10094 (:credentials m10093) args10095 (:args m10093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10096
      (com.palletops.awaze.common/aws-client :rds credentials10094)]
     (clojure.core/case
      (clojure.core/count args10095)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10096
        describePendingMaintenanceActions))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10096
        describePendingMaintenanceActions
        (rds/describe-pending-maintenance-actions-request
         (clojure.core/nth args10095 0))))))))
  (clojure.core/defn
   describe-pending-maintenance-actions-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         resource-identifier
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describePendingMaintenanceActions, describePendingMaintenanceActions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-pending-maintenance-actions,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-pending-maintenance-actions,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-pending-maintenance-actions
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         resource-identifier
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describePendingMaintenanceActions, describePendingMaintenanceActions"}
   [credentials10098 & args10099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10100
     (com.palletops.awaze.common/aws-client :rds credentials10098)]
    (clojure.core/case
     (clojure.core/count args10099)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10100
       describePendingMaintenanceActions))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10100
       describePendingMaintenanceActions
       (rds/describe-pending-maintenance-actions-request
        (clojure.core/nth args10099 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbcluster-snapshot
   [m10101]
   (clojure.core/let
    [credentials10102 (:credentials m10101) args10103 (:args m10101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10104
      (com.palletops.awaze.common/aws-client :rds credentials10102)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10104
       deleteDBClusterSnapshot
       (rds/delete-dbcluster-snapshot-request
        (clojure.core/nth args10103 0)))))))
  (clojure.core/defn
   delete-dbcluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbcluster-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbcluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbcluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbcluster-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBClusterSnapshot"}
   [credentials10106 & args10107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10108
     (com.palletops.awaze.common/aws-client :rds credentials10106)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10108
      deleteDBClusterSnapshot
      (rds/delete-dbcluster-snapshot-request
       (clojure.core/nth args10107 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbsecurity-group
   [m10109]
   (clojure.core/let
    [credentials10110 (:credentials m10109) args10111 (:args m10109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10112
      (com.palletops.awaze.common/aws-client :rds credentials10110)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10112
       deleteDBSecurityGroup
       (rds/delete-dbsecurity-group-request
        (clojure.core/nth args10111 0)))))))
  (clojure.core/defn
   delete-dbsecurity-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBSecurityGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbsecurity-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbsecurity-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBSecurityGroup"}
   [credentials10114 & args10115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10116
     (com.palletops.awaze.common/aws-client :rds credentials10114)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10116
      deleteDBSecurityGroup
      (rds/delete-dbsecurity-group-request
       (clojure.core/nth args10115 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-option-group
   [m10117]
   (clojure.core/let
    [credentials10118 (:credentials m10117) args10119 (:args m10117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10120
      (com.palletops.awaze.common/aws-client :rds credentials10118)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10120
       createOptionGroup
       (rds/create-option-group-request
        (clojure.core/nth args10119 0)))))))
  (clojure.core/defn
   create-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         major-engine-version
                         engine-name
                         sdk-request-timeout
                         custom-query-parameters
                         option-group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         option-group-description
                         clone-root]}]]),
    :doc "Generate map for createOptionGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-option-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-option-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         major-engine-version
                         engine-name
                         sdk-request-timeout
                         custom-query-parameters
                         option-group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         option-group-description
                         clone-root]}]]),
    :doc "Call createOptionGroup"}
   [credentials10122 & args10123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10124
     (com.palletops.awaze.common/aws-client :rds credentials10122)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10124
      createOptionGroup
      (rds/create-option-group-request (clojure.core/nth args10123 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbcluster-to-point-in-time
   [m10125]
   (clojure.core/let
    [credentials10126 (:credentials m10125) args10127 (:args m10125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10128
      (com.palletops.awaze.common/aws-client :rds credentials10126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10128
       restoreDBClusterToPointInTime
       (rds/restore-dbcluster-to-point-in-time-request
        (clojure.core/nth args10127 0)))))))
  (clojure.core/defn
   restore-dbcluster-to-point-in-time-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         vpc-security-group-ids
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         restore-to-time
                         dbsubnet-group-name
                         use-latest-restorable-time
                         custom-query-parameters
                         source-dbcluster-identifier
                         port
                         option-group-name
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for restoreDBClusterToPointInTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-dbcluster-to-point-in-time,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   restore-dbcluster-to-point-in-time
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         vpc-security-group-ids
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         restore-to-time
                         dbsubnet-group-name
                         use-latest-restorable-time
                         custom-query-parameters
                         source-dbcluster-identifier
                         port
                         option-group-name
                         read-limit
                         general-progress-listener
                         kms-key-id
                         clone-source
                         clone-root]}]]),
    :doc "Call restoreDBClusterToPointInTime"}
   [credentials10130 & args10131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10132
     (com.palletops.awaze.common/aws-client :rds credentials10130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10132
      restoreDBClusterToPointInTime
      (rds/restore-dbcluster-to-point-in-time-request
       (clojure.core/nth args10131 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbcluster
   [m10133]
   (clojure.core/let
    [credentials10134 (:credentials m10133) args10135 (:args m10133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10136
      (com.palletops.awaze.common/aws-client :rds credentials10134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10136
       createDBCluster
       (rds/create-dbcluster-request (clojure.core/nth args10135 0)))))))
  (clojure.core/defn
   create-dbcluster-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         database-name
                         vpc-security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         master-username
                         preferred-backup-window
                         sdk-request-timeout
                         availability-zones
                         dbsubnet-group-name
                         custom-query-parameters
                         storage-encrypted
                         port
                         option-group-name
                         read-limit
                         character-set-name
                         general-progress-listener
                         backup-retention-period
                         dbcluster-parameter-group-name
                         kms-key-id
                         engine
                         master-user-password
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for createDBCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbcluster,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbcluster
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         database-name
                         vpc-security-group-ids
                         tags
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         master-username
                         preferred-backup-window
                         sdk-request-timeout
                         availability-zones
                         dbsubnet-group-name
                         custom-query-parameters
                         storage-encrypted
                         port
                         option-group-name
                         read-limit
                         character-set-name
                         general-progress-listener
                         backup-retention-period
                         dbcluster-parameter-group-name
                         kms-key-id
                         engine
                         master-user-password
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Call createDBCluster"}
   [credentials10138 & args10139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10140
     (com.palletops.awaze.common/aws-client :rds credentials10138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10140
      createDBCluster
      (rds/create-dbcluster-request (clojure.core/nth args10139 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-reserved-dbinstances-offerings
   [m10141]
   (clojure.core/let
    [credentials10142 (:credentials m10141) args10143 (:args m10141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10144
      (com.palletops.awaze.common/aws-client :rds credentials10142)]
     (clojure.core/case
      (clojure.core/count args10143)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10144
        describeReservedDBInstancesOfferings))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10144
        describeReservedDBInstancesOfferings
        (rds/describe-reserved-dbinstances-offerings-request
         (clojure.core/nth args10143 0))))))))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         duration
                         reserved-dbinstances-offering-id
                         read-limit
                         dbinstance-class
                         product-description
                         multi-az
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-reserved-dbinstances-offerings,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-reserved-dbinstances-offerings
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         offering-type
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         duration
                         reserved-dbinstances-offering-id
                         read-limit
                         dbinstance-class
                         product-description
                         multi-az
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReservedDBInstancesOfferings, describeReservedDBInstancesOfferings"}
   [credentials10146 & args10147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10148
     (com.palletops.awaze.common/aws-client :rds credentials10146)]
    (clojure.core/case
     (clojure.core/count args10147)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10148
       describeReservedDBInstancesOfferings))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10148
       describeReservedDBInstancesOfferings
       (rds/describe-reserved-dbinstances-offerings-request
        (clojure.core/nth args10147 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbparameter-group
   [m10149]
   (clojure.core/let
    [credentials10150 (:credentials m10149) args10151 (:args m10149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10152
      (com.palletops.awaze.common/aws-client :rds credentials10150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10152
       deleteDBParameterGroup
       (rds/delete-dbparameter-group-request
        (clojure.core/nth args10151 0)))))))
  (clojure.core/defn
   delete-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbparameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBParameterGroup"}
   [credentials10154 & args10155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10156
     (com.palletops.awaze.common/aws-client :rds credentials10154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10156
      deleteDBParameterGroup
      (rds/delete-dbparameter-group-request
       (clojure.core/nth args10155 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-engine-default-parameters
   [m10157]
   (clojure.core/let
    [credentials10158 (:credentials m10157) args10159 (:args m10157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10160
      (com.palletops.awaze.common/aws-client :rds credentials10158)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10160
       describeEngineDefaultParameters
       (rds/describe-engine-default-parameters-request
        (clojure.core/nth args10159 0)))))))
  (clojure.core/defn
   describe-engine-default-parameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEngineDefaultParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-engine-default-parameters,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-engine-default-parameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEngineDefaultParameters"}
   [credentials10162 & args10163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10164
     (com.palletops.awaze.common/aws-client :rds credentials10162)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10164
      describeEngineDefaultParameters
      (rds/describe-engine-default-parameters-request
       (clojure.core/nth args10163 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :promote-read-replica
   [m10165]
   (clojure.core/let
    [credentials10166 (:credentials m10165) args10167 (:args m10165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10168
      (com.palletops.awaze.common/aws-client :rds credentials10166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10168
       promoteReadReplica
       (rds/promote-read-replica-request
        (clojure.core/nth args10167 0)))))))
  (clojure.core/defn
   promote-read-replica-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         preferred-backup-window
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         backup-retention-period
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Generate map for promoteReadReplica"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :promote-read-replica,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   promote-read-replica
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         preferred-backup-window
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         backup-retention-period
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Call promoteReadReplica"}
   [credentials10170 & args10171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10172
     (com.palletops.awaze.common/aws-client :rds credentials10170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10172
      promoteReadReplica
      (rds/promote-read-replica-request
       (clojure.core/nth args10171 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-categories
   [m10173]
   (clojure.core/let
    [credentials10174 (:credentials m10173) args10175 (:args m10173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10176
      (com.palletops.awaze.common/aws-client :rds credentials10174)]
     (clojure.core/case
      (clojure.core/count args10175)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10176
        describeEventCategories))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10176
        describeEventCategories
        (rds/describe-event-categories-request
         (clojure.core/nth args10175 0))))))))
  (clojure.core/defn
   describe-event-categories-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeEventCategories, describeEventCategories"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-categories,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-event-categories
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeEventCategories, describeEventCategories"}
   [credentials10178 & args10179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10180
     (com.palletops.awaze.common/aws-client :rds credentials10178)]
    (clojure.core/case
     (clojure.core/count args10179)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10180
       describeEventCategories))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10180
       describeEventCategories
       (rds/describe-event-categories-request
        (clojure.core/nth args10179 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsnapshot-attributes
   [m10181]
   (clojure.core/let
    [credentials10182 (:credentials m10181) args10183 (:args m10181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10184
      (com.palletops.awaze.common/aws-client :rds credentials10182)]
     (clojure.core/case
      (clojure.core/count args10183)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10184
        describeDBSnapshotAttributes
        (rds/describe-dbsnapshot-attributes-request
         (clojure.core/nth args10183 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10184
        describeDBSnapshotAttributes))))))
  (clojure.core/defn
   describe-dbsnapshot-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBSnapshotAttributes, describeDBSnapshotAttributes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbsnapshot-attributes,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbsnapshot-attributes,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbsnapshot-attributes
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBSnapshotAttributes, describeDBSnapshotAttributes"}
   [credentials10186 & args10187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10188
     (com.palletops.awaze.common/aws-client :rds credentials10186)]
    (clojure.core/case
     (clojure.core/count args10187)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10188
       describeDBSnapshotAttributes
       (rds/describe-dbsnapshot-attributes-request
        (clojure.core/nth args10187 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10188
       describeDBSnapshotAttributes))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbcluster-snapshots
   [m10189]
   (clojure.core/let
    [credentials10190 (:credentials m10189) args10191 (:args m10189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10192
      (com.palletops.awaze.common/aws-client :rds credentials10190)]
     (clojure.core/case
      (clojure.core/count args10191)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10192
        describeDBClusterSnapshots
        (rds/describe-dbcluster-snapshots-request
         (clojure.core/nth args10191 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10192
        describeDBClusterSnapshots))))))
  (clojure.core/defn
   describe-dbcluster-snapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         dbcluster-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBClusterSnapshots, describeDBClusterSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbcluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbcluster-snapshots,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbcluster-snapshots
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         dbcluster-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-type
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBClusterSnapshots, describeDBClusterSnapshots"}
   [credentials10194 & args10195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10196
     (com.palletops.awaze.common/aws-client :rds credentials10194)]
    (clojure.core/case
     (clojure.core/count args10195)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10196
       describeDBClusterSnapshots
       (rds/describe-dbcluster-snapshots-request
        (clojure.core/nth args10195 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10196
       describeDBClusterSnapshots))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameter-groups
   [m10197]
   (clojure.core/let
    [credentials10198 (:credentials m10197) args10199 (:args m10197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10200
      (com.palletops.awaze.common/aws-client :rds credentials10198)]
     (clojure.core/case
      (clojure.core/count args10199)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10200
        describeDBParameterGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10200
        describeDBParameterGroups
        (rds/describe-dbparameter-groups-request
         (clojure.core/nth args10199 0))))))))
  (clojure.core/defn
   describe-dbparameter-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDBParameterGroups, describeDBParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbparameter-groups,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbparameter-groups,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbparameter-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDBParameterGroups, describeDBParameterGroups"}
   [credentials10202 & args10203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10204
     (com.palletops.awaze.common/aws-client :rds credentials10202)]
    (clojure.core/case
     (clojure.core/count args10203)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10204
       describeDBParameterGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10204
       describeDBParameterGroups
       (rds/describe-dbparameter-groups-request
        (clojure.core/nth args10203 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbsnapshot-attribute
   [m10205]
   (clojure.core/let
    [credentials10206 (:credentials m10205) args10207 (:args m10205)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10208
      (com.palletops.awaze.common/aws-client :rds credentials10206)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10208
       modifyDBSnapshotAttribute
       (rds/modify-dbsnapshot-attribute-request
        (clojure.core/nth args10207 0)))))))
  (clojure.core/defn
   modify-dbsnapshot-attribute-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         values-to-add
                         custom-query-parameters
                         read-limit
                         values-to-remove
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyDBSnapshotAttribute"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-dbsnapshot-attribute,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-dbsnapshot-attribute
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         values-to-add
                         custom-query-parameters
                         read-limit
                         values-to-remove
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyDBSnapshotAttribute"}
   [credentials10210 & args10211]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10212
     (com.palletops.awaze.common/aws-client :rds credentials10210)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10212
      modifyDBSnapshotAttribute
      (rds/modify-dbsnapshot-attribute-request
       (clojure.core/nth args10211 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-to-point-in-time
   [m10213]
   (clojure.core/let
    [credentials10214 (:credentials m10213) args10215 (:args m10213)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10216
      (com.palletops.awaze.common/aws-client :rds credentials10214)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10216
       restoreDBInstanceToPointInTime
       (rds/restore-dbinstance-to-point-in-time-request
        (clojure.core/nth args10215 0)))))))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time-map
   {:arglists (quote
               [[credentials
                 {:keys [source-dbinstance-identifier
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         domain-iamrole-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         restore-time
                         dbsubnet-group-name
                         use-latest-restorable-time
                         custom-query-parameters
                         iops
                         availability-zone
                         port
                         option-group-name
                         publicly-accessible
                         dbname
                         license-model
                         target-dbinstance-identifier
                         read-limit
                         dbinstance-class
                         multi-az
                         tde-credential-password
                         general-progress-listener
                         tde-credential-arn
                         engine
                         domain
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         clone-root]}]]),
    :doc "Generate map for restoreDBInstanceToPointInTime"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-dbinstance-to-point-in-time,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   restore-dbinstance-to-point-in-time
   {:arglists (quote
               [[credentials
                 {:keys [source-dbinstance-identifier
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         domain-iamrole-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         restore-time
                         dbsubnet-group-name
                         use-latest-restorable-time
                         custom-query-parameters
                         iops
                         availability-zone
                         port
                         option-group-name
                         publicly-accessible
                         dbname
                         license-model
                         target-dbinstance-identifier
                         read-limit
                         dbinstance-class
                         multi-az
                         tde-credential-password
                         general-progress-listener
                         tde-credential-arn
                         engine
                         domain
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         clone-root]}]]),
    :doc "Call restoreDBInstanceToPointInTime"}
   [credentials10218 & args10219]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10220
     (com.palletops.awaze.common/aws-client :rds credentials10218)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10220
      restoreDBInstanceToPointInTime
      (rds/restore-dbinstance-to-point-in-time-request
       (clojure.core/nth args10219 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbcluster-parameter-groups
   [m10221]
   (clojure.core/let
    [credentials10222 (:credentials m10221) args10223 (:args m10221)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10224
      (com.palletops.awaze.common/aws-client :rds credentials10222)]
     (clojure.core/case
      (clojure.core/count args10223)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10224
        describeDBClusterParameterGroups
        (rds/describe-dbcluster-parameter-groups-request
         (clojure.core/nth args10223 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10224
        describeDBClusterParameterGroups))))))
  (clojure.core/defn
   describe-dbcluster-parameter-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBClusterParameterGroups, describeDBClusterParameterGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbcluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbcluster-parameter-groups,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbcluster-parameter-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBClusterParameterGroups, describeDBClusterParameterGroups"}
   [credentials10226 & args10227]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10228
     (com.palletops.awaze.common/aws-client :rds credentials10226)]
    (clojure.core/case
     (clojure.core/count args10227)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10228
       describeDBClusterParameterGroups
       (rds/describe-dbcluster-parameter-groups-request
        (clojure.core/nth args10227 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10228
       describeDBClusterParameterGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbinstance-from-dbsnapshot
   [m10229]
   (clojure.core/let
    [credentials10230 (:credentials m10229) args10231 (:args m10229)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10232
      (com.palletops.awaze.common/aws-client :rds credentials10230)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10232
       restoreDBInstanceFromDBSnapshot
       (rds/restore-dbinstance-from-dbsnapshot-request
        (clojure.core/nth args10231 0)))))))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         domain-iamrole-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         dbsubnet-group-name
                         custom-query-parameters
                         iops
                         availability-zone
                         port
                         option-group-name
                         publicly-accessible
                         dbname
                         license-model
                         read-limit
                         dbinstance-class
                         multi-az
                         tde-credential-password
                         general-progress-listener
                         tde-credential-arn
                         engine
                         domain
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Generate map for restoreDBInstanceFromDBSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-dbinstance-from-dbsnapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   restore-dbinstance-from-dbsnapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         domain-iamrole-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         dbsubnet-group-name
                         custom-query-parameters
                         iops
                         availability-zone
                         port
                         option-group-name
                         publicly-accessible
                         dbname
                         license-model
                         read-limit
                         dbinstance-class
                         multi-az
                         tde-credential-password
                         general-progress-listener
                         tde-credential-arn
                         engine
                         domain
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Call restoreDBInstanceFromDBSnapshot"}
   [credentials10234 & args10235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10236
     (com.palletops.awaze.common/aws-client :rds credentials10234)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10236
      restoreDBInstanceFromDBSnapshot
      (rds/restore-dbinstance-from-dbsnapshot-request
       (clojure.core/nth args10235 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :restore-dbcluster-from-snapshot
   [m10237]
   (clojure.core/let
    [credentials10238 (:credentials m10237) args10239 (:args m10237)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10240
      (com.palletops.awaze.common/aws-client :rds credentials10238)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10240
       restoreDBClusterFromSnapshot
       (rds/restore-dbcluster-from-snapshot-request
        (clojure.core/nth args10239 0)))))))
  (clojure.core/defn
   restore-dbcluster-from-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         database-name
                         vpc-security-group-ids
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         dbsubnet-group-name
                         custom-query-parameters
                         port
                         option-group-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         kms-key-id
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for restoreDBClusterFromSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-dbcluster-from-snapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   restore-dbcluster-from-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         database-name
                         vpc-security-group-ids
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         dbsubnet-group-name
                         custom-query-parameters
                         port
                         option-group-name
                         snapshot-identifier
                         read-limit
                         general-progress-listener
                         kms-key-id
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Call restoreDBClusterFromSnapshot"}
   [credentials10242 & args10243]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10244
     (com.palletops.awaze.common/aws-client :rds credentials10242)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10244
      restoreDBClusterFromSnapshot
      (rds/restore-dbcluster-from-snapshot-request
       (clojure.core/nth args10243 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbcluster-parameter-group
   [m10245]
   (clojure.core/let
    [credentials10246 (:credentials m10245) args10247 (:args m10245)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10248
      (com.palletops.awaze.common/aws-client :rds credentials10246)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10248
       modifyDBClusterParameterGroup
       (rds/modify-dbcluster-parameter-group-request
        (clojure.core/nth args10247 0)))))))
  (clojure.core/defn
   modify-dbcluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Generate map for modifyDBClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-dbcluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-dbcluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         clone-source
                         parameters
                         clone-root]}]]),
    :doc "Call modifyDBClusterParameterGroup"}
   [credentials10250 & args10251]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10252
     (com.palletops.awaze.common/aws-client :rds credentials10250)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10252
      modifyDBClusterParameterGroup
      (rds/modify-dbcluster-parameter-group-request
       (clojure.core/nth args10251 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :apply-pending-maintenance-action
   [m10253]
   (clojure.core/let
    [credentials10254 (:credentials m10253) args10255 (:args m10253)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10256
      (com.palletops.awaze.common/aws-client :rds credentials10254)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10256
       applyPendingMaintenanceAction
       (rds/apply-pending-maintenance-action-request
        (clojure.core/nth args10255 0)))))))
  (clojure.core/defn
   apply-pending-maintenance-action-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         resource-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         opt-in-type
                         apply-action
                         clone-root]}]]),
    :doc "Generate map for applyPendingMaintenanceAction"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :apply-pending-maintenance-action,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   apply-pending-maintenance-action
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         resource-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         opt-in-type
                         apply-action
                         clone-root]}]]),
    :doc "Call applyPendingMaintenanceAction"}
   [credentials10258 & args10259]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10260
     (com.palletops.awaze.common/aws-client :rds credentials10258)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10260
      applyPendingMaintenanceAction
      (rds/apply-pending-maintenance-action-request
       (clojure.core/nth args10259 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbparameters
   [m10261]
   (clojure.core/let
    [credentials10262 (:credentials m10261) args10263 (:args m10261)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10264
      (com.palletops.awaze.common/aws-client :rds credentials10262)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10264
       describeDBParameters
       (rds/describe-dbparameters-request
        (clojure.core/nth args10263 0)))))))
  (clojure.core/defn
   describe-dbparameters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDBParameters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbparameters,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbparameters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         source
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDBParameters"}
   [credentials10266 & args10267]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10268
     (com.palletops.awaze.common/aws-client :rds credentials10266)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10268
      describeDBParameters
      (rds/describe-dbparameters-request
       (clojure.core/nth args10267 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-group-options
   [m10269]
   (clojure.core/let
    [credentials10270 (:credentials m10269) args10271 (:args m10269)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10272
      (com.palletops.awaze.common/aws-client :rds credentials10270)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10272
       describeOptionGroupOptions
       (rds/describe-option-group-options-request
        (clojure.core/nth args10271 0)))))))
  (clojure.core/defn
   describe-option-group-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         major-engine-version
                         engine-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeOptionGroupOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-option-group-options,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-option-group-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         major-engine-version
                         engine-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeOptionGroupOptions"}
   [credentials10274 & args10275]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10276
     (com.palletops.awaze.common/aws-client :rds credentials10274)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10276
      describeOptionGroupOptions
      (rds/describe-option-group-options-request
       (clojure.core/nth args10275 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbcluster-parameter-group
   [m10277]
   (clojure.core/let
    [credentials10278 (:credentials m10277) args10279 (:args m10277)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10280
      (com.palletops.awaze.common/aws-client :rds credentials10278)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10280
       createDBClusterParameterGroup
       (rds/create-dbcluster-parameter-group-request
        (clojure.core/nth args10279 0)))))))
  (clojure.core/defn
   create-dbcluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         dbcluster-parameter-group-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDBClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbcluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbcluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         dbcluster-parameter-group-name
                         clone-source
                         clone-root]}]]),
    :doc "Call createDBClusterParameterGroup"}
   [credentials10282 & args10283]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10284
     (com.palletops.awaze.common/aws-client :rds credentials10282)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10284
      createDBClusterParameterGroup
      (rds/create-dbcluster-parameter-group-request
       (clojure.core/nth args10283 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbparameter-group
   [m10285]
   (clojure.core/let
    [credentials10286 (:credentials m10285) args10287 (:args m10285)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10288
      (com.palletops.awaze.common/aws-client :rds credentials10286)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10288
       createDBParameterGroup
       (rds/create-dbparameter-group-request
        (clojure.core/nth args10287 0)))))))
  (clojure.core/defn
   create-dbparameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDBParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbparameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbparameter-group
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         dbparameter-group-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbparameter-group-family
                         clone-source
                         clone-root]}]]),
    :doc "Call createDBParameterGroup"}
   [credentials10290 & args10291]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10292
     (com.palletops.awaze.common/aws-client :rds credentials10290)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10292
      createDBParameterGroup
      (rds/create-dbparameter-group-request
       (clojure.core/nth args10291 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-option-groups
   [m10293]
   (clojure.core/let
    [credentials10294 (:credentials m10293) args10295 (:args m10293)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10296
      (com.palletops.awaze.common/aws-client :rds credentials10294)]
     (clojure.core/case
      (clojure.core/count args10295)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10296
        describeOptionGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10296
        describeOptionGroups
        (rds/describe-option-groups-request
         (clojure.core/nth args10295 0))))))))
  (clojure.core/defn
   describe-option-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         major-engine-version
                         engine-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         option-group-name
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeOptionGroups, describeOptionGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-option-groups,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-option-groups,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-option-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         major-engine-version
                         engine-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         option-group-name
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeOptionGroups, describeOptionGroups"}
   [credentials10298 & args10299]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10300
     (com.palletops.awaze.common/aws-client :rds credentials10298)]
    (clojure.core/case
     (clojure.core/count args10299)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10300
       describeOptionGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10300
       describeOptionGroups
       (rds/describe-option-groups-request
        (clojure.core/nth args10299 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :authorize-dbsecurity-group-ingress
   [m10301]
   (clojure.core/let
    [credentials10302 (:credentials m10301) args10303 (:args m10301)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10304
      (com.palletops.awaze.common/aws-client :rds credentials10302)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10304
       authorizeDBSecurityGroupIngress
       (rds/authorize-dbsecurity-group-ingress-request
        (clojure.core/nth args10303 0)))))))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-name
                         custom-query-parameters
                         ec2security-group-id
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for authorizeDBSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :authorize-dbsecurity-group-ingress,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   authorize-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-name
                         custom-query-parameters
                         ec2security-group-id
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call authorizeDBSecurityGroupIngress"}
   [credentials10306 & args10307]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10308
     (com.palletops.awaze.common/aws-client :rds credentials10306)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10308
      authorizeDBSecurityGroupIngress
      (rds/authorize-dbsecurity-group-ingress-request
       (clojure.core/nth args10307 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-option-group
   [m10309]
   (clojure.core/let
    [credentials10310 (:credentials m10309) args10311 (:args m10309)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10312
      (com.palletops.awaze.common/aws-client :rds credentials10310)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10312
       deleteOptionGroup
       (rds/delete-option-group-request
        (clojure.core/nth args10311 0)))))))
  (clojure.core/defn
   delete-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         option-group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteOptionGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-option-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-option-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         option-group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteOptionGroup"}
   [credentials10314 & args10315]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10316
     (com.palletops.awaze.common/aws-client :rds credentials10314)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10316
      deleteOptionGroup
      (rds/delete-option-group-request (clojure.core/nth args10315 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsubnet-groups
   [m10317]
   (clojure.core/let
    [credentials10318 (:credentials m10317) args10319 (:args m10317)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10320
      (com.palletops.awaze.common/aws-client :rds credentials10318)]
     (clojure.core/case
      (clojure.core/count args10319)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10320
        describeDBSubnetGroups
        (rds/describe-dbsubnet-groups-request
         (clojure.core/nth args10319 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10320
        describeDBSubnetGroups))))))
  (clojure.core/defn
   describe-dbsubnet-groups-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         dbsubnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBSubnetGroups, describeDBSubnetGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbsubnet-groups,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbsubnet-groups
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         dbsubnet-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBSubnetGroups, describeDBSubnetGroups"}
   [credentials10322 & args10323]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10324
     (com.palletops.awaze.common/aws-client :rds credentials10322)]
    (clojure.core/case
     (clojure.core/count args10323)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10324
       describeDBSubnetGroups
       (rds/describe-dbsubnet-groups-request
        (clojure.core/nth args10323 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10324
       describeDBSubnetGroups))))))
 (do
  (clojure.core/defmethod
   rds
   :reboot-dbinstance
   [m10325]
   (clojure.core/let
    [credentials10326 (:credentials m10325) args10327 (:args m10325)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10328
      (com.palletops.awaze.common/aws-client :rds credentials10326)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10328
       rebootDBInstance
       (rds/reboot-dbinstance-request (clojure.core/nth args10327 0)))))))
  (clojure.core/defn
   reboot-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         force-failover
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Generate map for rebootDBInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reboot-dbinstance,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   reboot-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         force-failover
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Call rebootDBInstance"}
   [credentials10330 & args10331]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10332
     (com.palletops.awaze.common/aws-client :rds credentials10330)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10332
      rebootDBInstance
      (rds/reboot-dbinstance-request (clojure.core/nth args10331 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :remove-tags-from-resource
   [m10333]
   (clojure.core/let
    [credentials10334 (:credentials m10333) args10335 (:args m10333)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10336
      (com.palletops.awaze.common/aws-client :rds credentials10334)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10336
       removeTagsFromResource
       (rds/remove-tags-from-resource-request
        (clojure.core/nth args10335 0)))))))
  (clojure.core/defn
   remove-tags-from-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-resource,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   remove-tags-from-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromResource"}
   [credentials10338 & args10339]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10340
     (com.palletops.awaze.common/aws-client :rds credentials10338)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10340
      removeTagsFromResource
      (rds/remove-tags-from-resource-request
       (clojure.core/nth args10339 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :revoke-dbsecurity-group-ingress
   [m10341]
   (clojure.core/let
    [credentials10342 (:credentials m10341) args10343 (:args m10341)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10344
      (com.palletops.awaze.common/aws-client :rds credentials10342)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10344
       revokeDBSecurityGroupIngress
       (rds/revoke-dbsecurity-group-ingress-request
        (clojure.core/nth args10343 0)))))))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-name
                         custom-query-parameters
                         ec2security-group-id
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Generate map for revokeDBSecurityGroupIngress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :revoke-dbsecurity-group-ingress,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   revoke-dbsecurity-group-ingress
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbsecurity-group-name
                         custom-query-parameters
                         ec2security-group-id
                         cidrip
                         read-limit
                         general-progress-listener
                         ec2security-group-owner-id
                         clone-source
                         clone-root
                         ec2security-group-name]}]]),
    :doc "Call revokeDBSecurityGroupIngress"}
   [credentials10346 & args10347]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10348
     (com.palletops.awaze.common/aws-client :rds credentials10346)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10348
      revokeDBSecurityGroupIngress
      (rds/revoke-dbsecurity-group-ingress-request
       (clojure.core/nth args10347 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbcluster-snapshot
   [m10349]
   (clojure.core/let
    [credentials10350 (:credentials m10349) args10351 (:args m10349)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10352
      (com.palletops.awaze.common/aws-client :rds credentials10350)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10352
       createDBClusterSnapshot
       (rds/create-dbcluster-snapshot-request
        (clojure.core/nth args10351 0)))))))
  (clojure.core/defn
   create-dbcluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbcluster-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDBClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbcluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbcluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         dbcluster-snapshot-identifier
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDBClusterSnapshot"}
   [credentials10354 & args10355]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10356
     (com.palletops.awaze.common/aws-client :rds credentials10354)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10356
      createDBClusterSnapshot
      (rds/create-dbcluster-snapshot-request
       (clojure.core/nth args10355 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbinstance
   [m10357]
   (clojure.core/let
    [credentials10358 (:credentials m10357) args10359 (:args m10357)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10360
      (com.palletops.awaze.common/aws-client :rds credentials10358)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10360
       deleteDBInstance
       (rds/delete-dbinstance-request (clojure.core/nth args10359 0)))))))
  (clojure.core/defn
   delete-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         skip-final-snapshot
                         custom-query-parameters
                         final-dbsnapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Generate map for deleteDBInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbinstance,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         skip-final-snapshot
                         custom-query-parameters
                         final-dbsnapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Call deleteDBInstance"}
   [credentials10362 & args10363]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10364
     (com.palletops.awaze.common/aws-client :rds credentials10362)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10364
      deleteDBInstance
      (rds/delete-dbinstance-request (clojure.core/nth args10363 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :list-tags-for-resource
   [m10365]
   (clojure.core/let
    [credentials10366 (:credentials m10365) args10367 (:args m10365)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10368
      (com.palletops.awaze.common/aws-client :rds credentials10366)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10368
       listTagsForResource
       (rds/list-tags-for-resource-request
        (clojure.core/nth args10367 0)))))))
  (clojure.core/defn
   list-tags-for-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-resource,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   list-tags-for-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         resource-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForResource"}
   [credentials10370 & args10371]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10372
     (com.palletops.awaze.common/aws-client :rds credentials10370)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10372
      listTagsForResource
      (rds/list-tags-for-resource-request
       (clojure.core/nth args10371 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-dbinstance
   [m10373]
   (clojure.core/let
    [credentials10374 (:credentials m10373) args10375 (:args m10373)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10376
      (com.palletops.awaze.common/aws-client :rds credentials10374)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10376
       createDBInstance
       (rds/create-dbinstance-request (clojure.core/nth args10375 0)))))))
  (clojure.core/defn
   create-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         vpc-security-group-ids
                         tags
                         monitoring-role-arn
                         dbsecurity-groups
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         domain-iamrole-name
                         master-username
                         preferred-backup-window
                         dbparameter-group-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         dbsubnet-group-name
                         custom-query-parameters
                         iops
                         availability-zone
                         storage-encrypted
                         port
                         option-group-name
                         allocated-storage
                         publicly-accessible
                         dbname
                         license-model
                         read-limit
                         character-set-name
                         dbinstance-class
                         multi-az
                         promotion-tier
                         tde-credential-password
                         general-progress-listener
                         tde-credential-arn
                         backup-retention-period
                         kms-key-id
                         engine
                         domain
                         master-user-password
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root
                         monitoring-interval
                         engine-version]}]]),
    :doc "Generate map for createDBInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-dbinstance,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         vpc-security-group-ids
                         tags
                         monitoring-role-arn
                         dbsecurity-groups
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         domain-iamrole-name
                         master-username
                         preferred-backup-window
                         dbparameter-group-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         dbsubnet-group-name
                         custom-query-parameters
                         iops
                         availability-zone
                         storage-encrypted
                         port
                         option-group-name
                         allocated-storage
                         publicly-accessible
                         dbname
                         license-model
                         read-limit
                         character-set-name
                         dbinstance-class
                         multi-az
                         promotion-tier
                         tde-credential-password
                         general-progress-listener
                         tde-credential-arn
                         backup-retention-period
                         kms-key-id
                         engine
                         domain
                         master-user-password
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root
                         monitoring-interval
                         engine-version]}]]),
    :doc "Call createDBInstance"}
   [credentials10378 & args10379]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10380
     (com.palletops.awaze.common/aws-client :rds credentials10378)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10380
      createDBInstance
      (rds/create-dbinstance-request (clojure.core/nth args10379 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-event-subscription
   [m10381]
   (clojure.core/let
    [credentials10382 (:credentials m10381) args10383 (:args m10381)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10384
      (com.palletops.awaze.common/aws-client :rds credentials10382)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10384
       modifyEventSubscription
       (rds/modify-event-subscription-request
        (clojure.core/nth args10383 0)))))))
  (clojure.core/defn
   modify-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for modifyEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-event-subscription,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call modifyEventSubscription"}
   [credentials10386 & args10387]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10388
     (com.palletops.awaze.common/aws-client :rds credentials10386)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10388
      modifyEventSubscription
      (rds/modify-event-subscription-request
       (clojure.core/nth args10387 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsnapshots
   [m10389]
   (clojure.core/let
    [credentials10390 (:credentials m10389) args10391 (:args m10389)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10392
      (com.palletops.awaze.common/aws-client :rds credentials10390)]
     (clojure.core/case
      (clojure.core/count args10391)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10392
        describeDBSnapshots
        (rds/describe-dbsnapshots-request
         (clojure.core/nth args10391 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10392
        describeDBSnapshots))))))
  (clojure.core/defn
   describe-dbsnapshots-map
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         include-public
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         include-shared
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-type
                         dbinstance-identifier
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBSnapshots, describeDBSnapshots"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbsnapshots,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbsnapshots,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbsnapshots
   {:arglists (quote
               [[credentials
                 {:keys [dbsnapshot-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         include-public
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         include-shared
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         snapshot-type
                         dbinstance-identifier
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBSnapshots, describeDBSnapshots"}
   [credentials10394 & args10395]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10396
     (com.palletops.awaze.common/aws-client :rds credentials10394)]
    (clojure.core/case
     (clojure.core/count args10395)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10396
       describeDBSnapshots
       (rds/describe-dbsnapshots-request
        (clojure.core/nth args10395 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10396
       describeDBSnapshots))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-dbinstance
   [m10397]
   (clojure.core/let
    [credentials10398 (:credentials m10397) args10399 (:args m10397)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10400
      (com.palletops.awaze.common/aws-client :rds credentials10398)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10400
       modifyDBInstance
       (rds/modify-dbinstance-request (clojure.core/nth args10399 0)))))))
  (clojure.core/defn
   modify-dbinstance-map
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         monitoring-role-arn
                         dbsecurity-groups
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         dbport-number
                         domain-iamrole-name
                         preferred-backup-window
                         dbparameter-group-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         custom-query-parameters
                         iops
                         option-group-name
                         allocated-storage
                         publicly-accessible
                         allow-major-version-upgrade
                         cacertificate-identifier
                         read-limit
                         dbinstance-class
                         multi-az
                         promotion-tier
                         tde-credential-password
                         apply-immediately
                         general-progress-listener
                         tde-credential-arn
                         backup-retention-period
                         new-dbinstance-identifier
                         domain
                         master-user-password
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root
                         monitoring-interval
                         engine-version]}]]),
    :doc "Generate map for modifyDBInstance"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-dbinstance,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-dbinstance
   {:arglists (quote
               [[credentials
                 {:keys [vpc-security-group-ids
                         monitoring-role-arn
                         dbsecurity-groups
                         custom-request-headers
                         preferred-maintenance-window
                         sdk-client-execution-timeout
                         dbport-number
                         domain-iamrole-name
                         preferred-backup-window
                         dbparameter-group-name
                         sdk-request-timeout
                         copy-tags-to-snapshot
                         custom-query-parameters
                         iops
                         option-group-name
                         allocated-storage
                         publicly-accessible
                         allow-major-version-upgrade
                         cacertificate-identifier
                         read-limit
                         dbinstance-class
                         multi-az
                         promotion-tier
                         tde-credential-password
                         apply-immediately
                         general-progress-listener
                         tde-credential-arn
                         backup-retention-period
                         new-dbinstance-identifier
                         domain
                         master-user-password
                         clone-source
                         storage-type
                         auto-minor-version-upgrade
                         dbinstance-identifier
                         clone-root
                         monitoring-interval
                         engine-version]}]]),
    :doc "Call modifyDBInstance"}
   [credentials10402 & args10403]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10404
     (com.palletops.awaze.common/aws-client :rds credentials10402)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10404
      modifyDBInstance
      (rds/modify-dbinstance-request (clojure.core/nth args10403 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbcluster
   [m10405]
   (clojure.core/let
    [credentials10406 (:credentials m10405) args10407 (:args m10405)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10408
      (com.palletops.awaze.common/aws-client :rds credentials10406)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10408
       deleteDBCluster
       (rds/delete-dbcluster-request (clojure.core/nth args10407 0)))))))
  (clojure.core/defn
   delete-dbcluster-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         skip-final-snapshot
                         custom-query-parameters
                         final-dbsnapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBCluster"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbcluster,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbcluster
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         skip-final-snapshot
                         custom-query-parameters
                         final-dbsnapshot-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBCluster"}
   [credentials10410 & args10411]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10412
     (com.palletops.awaze.common/aws-client :rds credentials10410)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10412
      deleteDBCluster
      (rds/delete-dbcluster-request (clojure.core/nth args10411 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-account-attributes
   [m10413]
   (clojure.core/let
    [credentials10414 (:credentials m10413) args10415 (:args m10413)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10416
      (com.palletops.awaze.common/aws-client :rds credentials10414)]
     (clojure.core/case
      (clojure.core/count args10415)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10416
        describeAccountAttributes))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10416
        describeAccountAttributes
        (rds/describe-account-attributes-request
         (clojure.core/nth args10415 0))))))))
  (clojure.core/defn
   describe-account-attributes-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAccountAttributes, describeAccountAttributes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-attributes,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-account-attributes
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAccountAttributes, describeAccountAttributes"}
   [credentials10418 & args10419]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10420
     (com.palletops.awaze.common/aws-client :rds credentials10418)]
    (clojure.core/case
     (clojure.core/count args10419)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10420
       describeAccountAttributes))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10420
       describeAccountAttributes
       (rds/describe-account-attributes-request
        (clojure.core/nth args10419 0))))))))
 (do
  (clojure.core/defmethod
   rds
   :delete-dbcluster-parameter-group
   [m10421]
   (clojure.core/let
    [credentials10422 (:credentials m10421) args10423 (:args m10421)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10424
      (com.palletops.awaze.common/aws-client :rds credentials10422)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10424
       deleteDBClusterParameterGroup
       (rds/delete-dbcluster-parameter-group-request
        (clojure.core/nth args10423 0)))))))
  (clojure.core/defn
   delete-dbcluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDBClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-dbcluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   delete-dbcluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDBClusterParameterGroup"}
   [credentials10426 & args10427]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10428
     (com.palletops.awaze.common/aws-client :rds credentials10426)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10428
      deleteDBClusterParameterGroup
      (rds/delete-dbcluster-parameter-group-request
       (clojure.core/nth args10427 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbinstances
   [m10429]
   (clojure.core/let
    [credentials10430 (:credentials m10429) args10431 (:args m10429)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10432
      (com.palletops.awaze.common/aws-client :rds credentials10430)]
     (clojure.core/case
      (clojure.core/count args10431)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10432
        describeDBInstances
        (rds/describe-dbinstances-request
         (clojure.core/nth args10431 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10432
        describeDBInstances))))))
  (clojure.core/defn
   describe-dbinstances-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         dbinstance-identifier
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDBInstances, describeDBInstances"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbinstances,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbinstances,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbinstances
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         dbinstance-identifier
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDBInstances, describeDBInstances"}
   [credentials10434 & args10435]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10436
     (com.palletops.awaze.common/aws-client :rds credentials10434)]
    (clojure.core/case
     (clojure.core/count args10435)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10436
       describeDBInstances
       (rds/describe-dbinstances-request
        (clojure.core/nth args10435 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10436
       describeDBInstances))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-option-group
   [m10437]
   (clojure.core/let
    [credentials10438 (:credentials m10437) args10439 (:args m10437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10440
      (com.palletops.awaze.common/aws-client :rds credentials10438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10440
       copyOptionGroup
       (rds/copy-option-group-request (clojure.core/nth args10439 0)))))))
  (clojure.core/defn
   copy-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         target-option-group-description
                         sdk-request-timeout
                         custom-query-parameters
                         target-option-group-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         source-option-group-identifier
                         clone-root]}]]),
    :doc "Generate map for copyOptionGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-option-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   copy-option-group
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         target-option-group-description
                         sdk-request-timeout
                         custom-query-parameters
                         target-option-group-identifier
                         read-limit
                         general-progress-listener
                         clone-source
                         source-option-group-identifier
                         clone-root]}]]),
    :doc "Call copyOptionGroup"}
   [credentials10442 & args10443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10444
     (com.palletops.awaze.common/aws-client :rds credentials10442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10444
      copyOptionGroup
      (rds/copy-option-group-request (clojure.core/nth args10443 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :failover-dbcluster
   [m10445]
   (clojure.core/let
    [credentials10446 (:credentials m10445) args10447 (:args m10445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10448
      (com.palletops.awaze.common/aws-client :rds credentials10446)]
     (clojure.core/case
      (clojure.core/count args10447)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10448
        failoverDBCluster
        (rds/failover-dbcluster-request
         (clojure.core/nth args10447 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10448
        failoverDBCluster))))))
  (clojure.core/defn
   failover-dbcluster-map
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for failoverDBCluster, failoverDBCluster"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :failover-dbcluster,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :failover-dbcluster,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   failover-dbcluster
   {:arglists (quote
               [[credentials
                 {:keys [dbcluster-identifier
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call failoverDBCluster, failoverDBCluster"}
   [credentials10450 & args10451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10452
     (com.palletops.awaze.common/aws-client :rds credentials10450)]
    (clojure.core/case
     (clojure.core/count args10451)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10452
       failoverDBCluster
       (rds/failover-dbcluster-request (clojure.core/nth args10451 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10452
       failoverDBCluster))))))
 (do
  (clojure.core/defmethod
   rds
   :purchase-reserved-dbinstances-offering
   [m10453]
   (clojure.core/let
    [credentials10454 (:credentials m10453) args10455 (:args m10453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10456
      (com.palletops.awaze.common/aws-client :rds credentials10454)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10456
       purchaseReservedDBInstancesOffering
       (rds/purchase-reserved-dbinstances-offering-request
        (clojure.core/nth args10455 0)))))))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         dbinstance-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-dbinstance-id
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-dbinstances-offering-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for purchaseReservedDBInstancesOffering"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purchase-reserved-dbinstances-offering,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   purchase-reserved-dbinstances-offering
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         dbinstance-count
                         custom-request-headers
                         sdk-client-execution-timeout
                         reserved-dbinstance-id
                         sdk-request-timeout
                         custom-query-parameters
                         reserved-dbinstances-offering-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call purchaseReservedDBInstancesOffering"}
   [credentials10458 & args10459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10460
     (com.palletops.awaze.common/aws-client :rds credentials10458)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10460
      purchaseReservedDBInstancesOffering
      (rds/purchase-reserved-dbinstances-offering-request
       (clojure.core/nth args10459 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :download-dblog-file-portion
   [m10461]
   (clojure.core/let
    [credentials10462 (:credentials m10461) args10463 (:args m10461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10464
      (com.palletops.awaze.common/aws-client :rds credentials10462)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10464
       downloadDBLogFilePortion
       (rds/download-dblog-file-portion-request
        (clojure.core/nth args10463 0)))))))
  (clojure.core/defn
   download-dblog-file-portion-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root
                         number-of-lines
                         log-file-name]}]]),
    :doc "Generate map for downloadDBLogFilePortion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :download-dblog-file-portion,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   download-dblog-file-portion
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dbinstance-identifier
                         clone-root
                         number-of-lines
                         log-file-name]}]]),
    :doc "Call downloadDBLogFilePortion"}
   [credentials10466 & args10467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10468
     (com.palletops.awaze.common/aws-client :rds credentials10466)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10468
      downloadDBLogFilePortion
      (rds/download-dblog-file-portion-request
       (clojure.core/nth args10467 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-orderable-dbinstance-options
   [m10469]
   (clojure.core/let
    [credentials10470 (:credentials m10469) args10471 (:args m10469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10472
      (com.palletops.awaze.common/aws-client :rds credentials10470)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10472
       describeOrderableDBInstanceOptions
       (rds/describe-orderable-dbinstance-options-request
        (clojure.core/nth args10471 0)))))))
  (clojure.core/defn
   describe-orderable-dbinstance-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         license-model
                         read-limit
                         dbinstance-class
                         vpc
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Generate map for describeOrderableDBInstanceOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-orderable-dbinstance-options,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-orderable-dbinstance-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         license-model
                         read-limit
                         dbinstance-class
                         vpc
                         general-progress-listener
                         max-records
                         engine
                         clone-source
                         clone-root
                         engine-version]}]]),
    :doc "Call describeOrderableDBInstanceOptions"}
   [credentials10474 & args10475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10476
     (com.palletops.awaze.common/aws-client :rds credentials10474)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10476
      describeOrderableDBInstanceOptions
      (rds/describe-orderable-dbinstance-options-request
       (clojure.core/nth args10475 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dblog-files
   [m10477]
   (clojure.core/let
    [credentials10478 (:credentials m10477) args10479 (:args m10477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10480
      (com.palletops.awaze.common/aws-client :rds credentials10478)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10480
       describeDBLogFiles
       (rds/describe-dblog-files-request
        (clojure.core/nth args10479 0)))))))
  (clojure.core/defn
   describe-dblog-files-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         file-size
                         read-limit
                         filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Generate map for describeDBLogFiles"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dblog-files,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dblog-files
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         file-size
                         read-limit
                         filename-contains
                         general-progress-listener
                         file-last-written
                         max-records
                         clone-source
                         dbinstance-identifier
                         clone-root]}]]),
    :doc "Call describeDBLogFiles"}
   [credentials10482 & args10483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10484
     (com.palletops.awaze.common/aws-client :rds credentials10482)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10484
      describeDBLogFiles
      (rds/describe-dblog-files-request
       (clojure.core/nth args10483 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :reset-dbcluster-parameter-group
   [m10485]
   (clojure.core/let
    [credentials10486 (:credentials m10485) args10487 (:args m10485)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10488
      (com.palletops.awaze.common/aws-client :rds credentials10486)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10488
       resetDBClusterParameterGroup
       (rds/reset-dbcluster-parameter-group-request
        (clojure.core/nth args10487 0)))))))
  (clojure.core/defn
   reset-dbcluster-parameter-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Generate map for resetDBClusterParameterGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reset-dbcluster-parameter-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   reset-dbcluster-parameter-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         dbcluster-parameter-group-name
                         clone-source
                         reset-all-parameters
                         parameters
                         clone-root]}]]),
    :doc "Call resetDBClusterParameterGroup"}
   [credentials10490 & args10491]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10492
     (com.palletops.awaze.common/aws-client :rds credentials10490)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10492
      resetDBClusterParameterGroup
      (rds/reset-dbcluster-parameter-group-request
       (clojure.core/nth args10491 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-event-subscriptions
   [m10493]
   (clojure.core/let
    [credentials10494 (:credentials m10493) args10495 (:args m10493)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10496
      (com.palletops.awaze.common/aws-client :rds credentials10494)]
     (clojure.core/case
      (clojure.core/count args10495)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10496
        describeEventSubscriptions
        (rds/describe-event-subscriptions-request
         (clojure.core/nth args10495 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10496
        describeEventSubscriptions))))))
  (clojure.core/defn
   describe-event-subscriptions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeEventSubscriptions, describeEventSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-event-subscriptions,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-event-subscriptions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         filters
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeEventSubscriptions, describeEventSubscriptions"}
   [credentials10498 & args10499]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10500
     (com.palletops.awaze.common/aws-client :rds credentials10498)]
    (clojure.core/case
     (clojure.core/count args10499)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10500
       describeEventSubscriptions
       (rds/describe-event-subscriptions-request
        (clojure.core/nth args10499 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10500
       describeEventSubscriptions))))))
 (do
  (clojure.core/defmethod
   rds
   :modify-option-group
   [m10501]
   (clojure.core/let
    [credentials10502 (:credentials m10501) args10503 (:args m10501)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10504
      (com.palletops.awaze.common/aws-client :rds credentials10502)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10504
       modifyOptionGroup
       (rds/modify-option-group-request
        (clojure.core/nth args10503 0)))))))
  (clojure.core/defn
   modify-option-group-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         option-group-name
                         options-to-include
                         read-limit
                         apply-immediately
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyOptionGroup"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-option-group,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   modify-option-group
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         option-group-name
                         options-to-include
                         read-limit
                         apply-immediately
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyOptionGroup"}
   [credentials10506 & args10507]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10508
     (com.palletops.awaze.common/aws-client :rds credentials10506)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10508
      modifyOptionGroup
      (rds/modify-option-group-request (clojure.core/nth args10507 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :copy-dbcluster-snapshot
   [m10509]
   (clojure.core/let
    [credentials10510 (:credentials m10509) args10511 (:args m10509)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10512
      (com.palletops.awaze.common/aws-client :rds credentials10510)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10512
       copyDBClusterSnapshot
       (rds/copy-dbcluster-snapshot-request
        (clojure.core/nth args10511 0)))))))
  (clojure.core/defn
   copy-dbcluster-snapshot-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-dbcluster-snapshot-identifier
                         read-limit
                         target-dbcluster-snapshot-identifier
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for copyDBClusterSnapshot"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-dbcluster-snapshot,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   copy-dbcluster-snapshot
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source-dbcluster-snapshot-identifier
                         read-limit
                         target-dbcluster-snapshot-identifier
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call copyDBClusterSnapshot"}
   [credentials10514 & args10515]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10516
     (com.palletops.awaze.common/aws-client :rds credentials10514)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10516
      copyDBClusterSnapshot
      (rds/copy-dbcluster-snapshot-request
       (clojure.core/nth args10515 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :create-event-subscription
   [m10517]
   (clojure.core/let
    [credentials10518 (:credentials m10517) args10519 (:args m10517)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10520
      (com.palletops.awaze.common/aws-client :rds credentials10518)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10520
       createEventSubscription
       (rds/create-event-subscription-request
        (clojure.core/nth args10519 0)))))))
  (clojure.core/defn
   create-event-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Generate map for createEventSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-event-subscription,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   create-event-subscription
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         subscription-name
                         sdk-request-timeout
                         source-type
                         custom-query-parameters
                         source-ids
                         read-limit
                         general-progress-listener
                         event-categories
                         clone-source
                         sns-topic-arn
                         enabled
                         clone-root]}]]),
    :doc "Call createEventSubscription"}
   [credentials10522 & args10523]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10524
     (com.palletops.awaze.common/aws-client :rds credentials10522)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10524
      createEventSubscription
      (rds/create-event-subscription-request
       (clojure.core/nth args10523 0)))))))
 (do
  (clojure.core/defmethod
   rds
   :describe-dbsecurity-groups
   [m10525]
   (clojure.core/let
    [credentials10526 (:credentials m10525) args10527 (:args m10525)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
      client10528
      (com.palletops.awaze.common/aws-client :rds credentials10526)]
     (clojure.core/case
      (clojure.core/count args10527)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10528
        describeDBSecurityGroups))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10528
        describeDBSecurityGroups
        (rds/describe-dbsecurity-groups-request
         (clojure.core/nth args10527 0))))))))
  (clojure.core/defn
   describe-dbsecurity-groups-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         dbsecurity-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDBSecurityGroups, describeDBSecurityGroups"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1842__auto__,
     :client :rds})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-dbsecurity-groups,
     :credentials credentials__1842__auto__,
     :client :rds}))
  (clojure.core/defn
   describe-dbsecurity-groups
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filters
                         sdk-request-timeout
                         marker
                         dbsecurity-group-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-records
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDBSecurityGroups, describeDBSecurityGroups"}
   [credentials10530 & args10531]
   (clojure.core/let
    [^{:tag com.amazonaws.services.rds.AmazonRDSClient}
     client10532
     (com.palletops.awaze.common/aws-client :rds credentials10530)]
    (clojure.core/case
     (clojure.core/count args10531)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10532
       describeDBSecurityGroups))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.rds.AmazonRDSClient}
client10532
       describeDBSecurityGroups
       (rds/describe-dbsecurity-groups-request
        (clojure.core/nth args10531 0)))))))))
