(ns
 com.palletops.awaze.s3
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.s3 :as s3]
  [com.palletops.awaze.beans.root :as root]
  [com.palletops.awaze.beans.metrics :as metrics]
  [com.palletops.awaze.beans.regions :as regions]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :s3
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.s3.AmazonS3Client
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.StorageClass}
storage-class
  [m13206]
  (.
   com.amazonaws.services.s3.model.StorageClass
   fromValue
   (clojure.core/name m13206)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule$AllowedMethods}
corsrule-allowed-methods
  [m13209]
  (.
   com.amazonaws.services.s3.model.CORSRule$AllowedMethods
   fromValue
   (clojure.core/name m13209)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition}
bucket-lifecycle-configuration-noncurrent-version-transition
  [m13212]
  (clojure.core/let
   [bean13211
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$NoncurrentVersionTransition)]
   (clojure.core/let
    [v13213
     (:storage-class m13212 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13213 :com.palletops.awaze.client-builder/undef)
     (. bean13211 setStorageClass (s3/storage-class v13213))))
   (clojure.core/let
    [v13213 (:days m13212 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13213 :com.palletops.awaze.client-builder/undef)
     (. bean13211 setDays (clojure.core/int v13213))))
   bean13211))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition}
bucket-lifecycle-configuration-transition
  [m13215]
  (clojure.core/let
   [bean13214
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Transition)]
   (clojure.core/let
    [v13216 (:date m13215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13216 :com.palletops.awaze.client-builder/undef)
     (. bean13214 setDate (com.palletops.awaze.common/to-date v13216))))
   (clojure.core/let
    [v13216
     (:storage-class m13215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13216 :com.palletops.awaze.client-builder/undef)
     (. bean13214 setStorageClass (s3/storage-class v13216))))
   (clojure.core/let
    [v13216 (:days m13215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13216 :com.palletops.awaze.client-builder/undef)
     (. bean13214 setDays (clojure.core/int v13216))))
   bean13214))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload}
abort-incomplete-multipart-upload
  [m13218]
  (clojure.core/let
   [bean13217
    (new
     com.amazonaws.services.s3.model.AbortIncompleteMultipartUpload)]
   (clojure.core/let
    [v13219
     (:days-after-initiation
      m13218
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13219 :com.palletops.awaze.client-builder/undef)
     (. bean13217 setDaysAfterInitiation (clojure.core/int v13219))))
   bean13217))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Owner}
owner
  [m13221]
  (clojure.core/let
   [bean13220 (new com.amazonaws.services.s3.model.Owner)]
   (clojure.core/let
    [v13222
     (:display-name m13221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13222 :com.palletops.awaze.client-builder/undef)
     (. bean13220 setDisplayName (clojure.core/str v13222))))
   (clojure.core/let
    [v13222 (:id m13221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13222 :com.palletops.awaze.client-builder/undef)
     (. bean13220 setId (clojure.core/str v13222))))
   bean13220))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationDestinationConfig}
replication-destination-config
  [m13224]
  (clojure.core/let
   [bean13223
    (new com.amazonaws.services.s3.model.ReplicationDestinationConfig)]
   (clojure.core/let
    [v13225
     (:storage-class m13224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13225 :com.palletops.awaze.client-builder/undef)
     (. bean13223 setStorageClass (clojure.core/str v13225))))
   (clojure.core/let
    [v13225
     (:bucket-arn m13224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13225 :com.palletops.awaze.client-builder/undef)
     (. bean13223 setBucketARN (clojure.core/str v13225))))
   bean13223))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RedirectRule}
redirect-rule
  [m13227]
  (clojure.core/let
   [bean13226 (new com.amazonaws.services.s3.model.RedirectRule)]
   (clojure.core/let
    [v13228
     (:host-name m13227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13228 :com.palletops.awaze.client-builder/undef)
     (. bean13226 setHostName (clojure.core/str v13228))))
   (clojure.core/let
    [v13228
     (:replace-key-prefix-with
      m13227
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13228 :com.palletops.awaze.client-builder/undef)
     (. bean13226 setReplaceKeyPrefixWith (clojure.core/str v13228))))
   (clojure.core/let
    [v13228
     (:replace-key-with
      m13227
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13228 :com.palletops.awaze.client-builder/undef)
     (. bean13226 setReplaceKeyWith (clojure.core/str v13228))))
   (clojure.core/let
    [v13228
     (:http-redirect-code
      m13227
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13228 :com.palletops.awaze.client-builder/undef)
     (. bean13226 setHttpRedirectCode (clojure.core/str v13228))))
   (clojure.core/let
    [v13228
     (:protocol m13227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13228 :com.palletops.awaze.client-builder/undef)
     (. bean13226 setProtocol (clojure.core/str v13228))))
   bean13226))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRuleCondition}
routing-rule-condition
  [m13230]
  (clojure.core/let
   [bean13229
    (new com.amazonaws.services.s3.model.RoutingRuleCondition)]
   (clojure.core/let
    [v13231
     (:key-prefix-equals
      m13230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13231 :com.palletops.awaze.client-builder/undef)
     (. bean13229 setKeyPrefixEquals (clojure.core/str v13231))))
   (clojure.core/let
    [v13231
     (:http-error-code-returned-equals
      m13230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13231 :com.palletops.awaze.client-builder/undef)
     (.
      bean13229
      setHttpErrorCodeReturnedEquals
      (clojure.core/str v13231))))
   bean13229))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CORSRule}
corsrule
  [m13233]
  (clojure.core/let
   [bean13232 (new com.amazonaws.services.s3.model.CORSRule)]
   (clojure.core/let
    [v13234
     (:allowed-methods
      m13233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (.
      bean13232
      setAllowedMethods
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13569] (s3/corsrule-allowed-methods arg13569))
 v13234))))
   (clojure.core/let
    [v13234
     (:allowed-origins
      m13233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (.
      bean13232
      setAllowedOrigins
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13570] (clojure.core/str arg13570))
 v13234))))
   (clojure.core/let
    [v13234
     (:max-age-seconds
      m13233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (. bean13232 setMaxAgeSeconds (clojure.core/int v13234))))
   (clojure.core/let
    [v13234
     (:exposed-headers
      m13233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (.
      bean13232
      setExposedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13571] (clojure.core/str arg13571))
 v13234))))
   (clojure.core/let
    [v13234
     (:allowed-headers
      m13233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (.
      bean13232
      setAllowedHeaders
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13572] (clojure.core/str arg13572))
 v13234))))
   (clojure.core/let
    [v13234 (:id m13233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13234 :com.palletops.awaze.client-builder/undef)
     (. bean13232 setId (clojure.core/str v13234))))
   bean13232))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule}
bucket-lifecycle-configuration-rule
  [m13236]
  (clojure.core/let
   [bean13235
    (new
     com.amazonaws.services.s3.model.BucketLifecycleConfiguration$Rule)]
   (clojure.core/let
    [v13237
     (:prefix m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setPrefix (clojure.core/str v13237))))
   (clojure.core/let
    [v13237
     (:noncurrent-version-transition
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setNoncurrentVersionTransition
      (s3/bucket-lifecycle-configuration-noncurrent-version-transition
       v13237))))
   (clojure.core/let
    [v13237
     (:transitions m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13573]
  (s3/bucket-lifecycle-configuration-transition arg13573))
 v13237))))
   (clojure.core/let
    [v13237
     (:abort-incomplete-multipart-upload
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setAbortIncompleteMultipartUpload
      (s3/abort-incomplete-multipart-upload v13237))))
   (clojure.core/let
    [v13237 (:id m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setId (clojure.core/str v13237))))
   (clojure.core/let
    [v13237
     (:noncurrent-version-expiration-in-days
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setNoncurrentVersionExpirationInDays
      (clojure.core/int v13237))))
   (clojure.core/let
    [v13237
     (:expiration-in-days
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setExpirationInDays (clojure.core/int v13237))))
   (clojure.core/let
    [v13237
     (:noncurrent-version-transitions
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setNoncurrentVersionTransitions
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13574]
  (s3/bucket-lifecycle-configuration-noncurrent-version-transition
   arg13574))
 v13237))))
   (clojure.core/let
    [v13237
     (:expiration-date
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setExpirationDate
      (com.palletops.awaze.common/to-date v13237))))
   (clojure.core/let
    [v13237
     (:expired-object-delete-marker
      m13236
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setExpiredObjectDeleteMarker
      (clojure.core/boolean v13237))))
   (clojure.core/let
    [v13237
     (:transition m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (.
      bean13235
      setTransition
      (s3/bucket-lifecycle-configuration-transition v13237))))
   (clojure.core/let
    [v13237
     (:status m13236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13237 :com.palletops.awaze.client-builder/undef)
     (. bean13235 setStatus (clojure.core/str v13237))))
   bean13235))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration}
bucket-notification-configuration-topic-configuration
  [m13239]
  (clojure.core/let
   [arg13241
    nil
    arg13242
    nil
    bean13238
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration$TopicConfiguration
     arg13241
     arg13242)]
   bean13238))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3VersionSummary}
s3version-summary
  [m13244]
  (clojure.core/let
   [bean13243 (new com.amazonaws.services.s3.model.S3VersionSummary)]
   (clojure.core/let
    [v13245
     (:bucket-name m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setBucketName (clojure.core/str v13245))))
   (clojure.core/let
    [v13245 (:owner m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setOwner (s3/owner v13245))))
   (clojure.core/let
    [v13245
     (:storage-class m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setStorageClass (clojure.core/str v13245))))
   (clojure.core/let
    [v13245
     (:is-latest m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setIsLatest (clojure.core/boolean v13245))))
   (clojure.core/let
    [v13245
     (:last-modified m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (.
      bean13243
      setLastModified
      (com.palletops.awaze.common/to-date v13245))))
   (clojure.core/let
    [v13245 (:key m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setKey (clojure.core/str v13245))))
   (clojure.core/let
    [v13245 (:etag m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setETag (clojure.core/str v13245))))
   (clojure.core/let
    [v13245 (:size m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setSize (clojure.core/long v13245))))
   (clojure.core/let
    [v13245
     (:version-id m13244 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setVersionId (clojure.core/str v13245))))
   (clojure.core/let
    [v13245
     (:is-delete-marker
      m13244
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13245 :com.palletops.awaze.client-builder/undef)
     (. bean13243 setIsDeleteMarker (clojure.core/boolean v13245))))
   bean13243))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ReplicationRule}
replication-rule
  [m13247]
  (clojure.core/let
   [bean13246 (new com.amazonaws.services.s3.model.ReplicationRule)]
   (clojure.core/let
    [v13248
     (:destination-config
      m13247
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13248 :com.palletops.awaze.client-builder/undef)
     (.
      bean13246
      setDestinationConfig
      (s3/replication-destination-config v13248))))
   (clojure.core/let
    [v13248
     (:status m13247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13248 :com.palletops.awaze.client-builder/undef)
     (. bean13246 setStatus (clojure.core/str v13248))))
   (clojure.core/let
    [v13248
     (:prefix m13247 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13248 :com.palletops.awaze.client-builder/undef)
     (. bean13246 setPrefix (clojure.core/str v13248))))
   bean13246))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.TagSet}
tag-set
  [m13250]
  (clojure.core/let
   [bean13249 (new com.amazonaws.services.s3.model.TagSet)]
   bean13249))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RoutingRule}
routing-rule
  [m13253]
  (clojure.core/let
   [bean13252 (new com.amazonaws.services.s3.model.RoutingRule)]
   (clojure.core/let
    [v13254
     (:redirect m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setRedirect (s3/redirect-rule v13254))))
   (clojure.core/let
    [v13254
     (:condition m13253 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13254 :com.palletops.awaze.client-builder/undef)
     (. bean13252 setCondition (s3/routing-rule-condition v13254))))
   bean13252))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSECustomerKey}
ssecustomer-key
  [m13256]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13258
    nil
    bean13255
    (new
     com.amazonaws.services.s3.model.SSECustomerKey
^{:tag java.lang.String}
arg13258)]
   (clojure.core/let
    [v13257 (:md5 m13256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13257 :com.palletops.awaze.client-builder/undef)
     (. bean13255 setMd5 (clojure.core/str v13257))))
   (clojure.core/let
    [v13257
     (:algorithm m13256 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13257 :com.palletops.awaze.client-builder/undef)
     (. bean13255 setAlgorithm (clojure.core/str v13257))))
   bean13255))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketCrossOriginConfiguration}
bucket-cross-origin-configuration
  [m13260]
  (clojure.core/let
   [bean13259
    (new
     com.amazonaws.services.s3.model.BucketCrossOriginConfiguration)]
   (clojure.core/let
    [v13261 (:rules m13260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13261 :com.palletops.awaze.client-builder/undef)
     (.
      bean13259
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13575] (s3/corsrule arg13575))
 v13261))))
   bean13259))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLifecycleConfiguration}
bucket-lifecycle-configuration
  [m13263]
  (clojure.core/let
   [bean13262
    (new com.amazonaws.services.s3.model.BucketLifecycleConfiguration)]
   (clojure.core/let
    [v13264 (:rules m13263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13264 :com.palletops.awaze.client-builder/undef)
     (.
      bean13262
      setRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13576]
  (s3/bucket-lifecycle-configuration-rule arg13576))
 v13264))))
   bean13262))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
bucket-notification-configuration
  [m13266]
  (clojure.core/let
   [bean13265
    (new
     com.amazonaws.services.s3.model.BucketNotificationConfiguration)]
   (clojure.core/let
    [v13267
     (:topic-configurations
      m13266
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13267 :com.palletops.awaze.client-builder/undef)
     (.
      bean13265
      setTopicConfigurations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg13577]
  (s3/bucket-notification-configuration-topic-configuration arg13577))
 v13267))))
   (clojure.core/let
    [v13267
     (:configurations
      m13266
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13267 :com.palletops.awaze.client-builder/undef)
     (.
      bean13265
      setConfigurations
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13578] (clojure.core/str arg13578))
  (clojure.core/keys v13267))
 (clojure.core/map
  (clojure.core/fn [arg13578] arg13578)
  (clojure.core/vals v13267))))))
   bean13265))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.VersionListing}
version-listing
  [m13269]
  (clojure.core/let
   [bean13268 (new com.amazonaws.services.s3.model.VersionListing)]
   (clojure.core/let
    [v13270
     (:prefix m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setPrefix (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:next-version-id-marker
      m13269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setNextVersionIdMarker (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:version-summaries
      m13269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (.
      bean13268
      setVersionSummaries
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13579] (s3/s3version-summary arg13579))
 v13270))))
   (clojure.core/let
    [v13270
     (:bucket-name m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setBucketName (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:encoding-type m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setEncodingType (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:next-key-marker
      m13269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setNextKeyMarker (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:max-keys m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setMaxKeys (clojure.core/int v13270))))
   (clojure.core/let
    [v13270
     (:truncated m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setTruncated (clojure.core/boolean v13270))))
   (clojure.core/let
    [v13270
     (:version-id-marker
      m13269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setVersionIdMarker (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:common-prefixes
      m13269
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (.
      bean13268
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13580] (clojure.core/str arg13580))
 v13270))))
   (clojure.core/let
    [v13270
     (:key-marker m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setKeyMarker (clojure.core/str v13270))))
   (clojure.core/let
    [v13270
     (:delimiter m13269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13270 :com.palletops.awaze.client-builder/undef)
     (. bean13268 setDelimiter (clojure.core/str v13270))))
   bean13268))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAlgorithm}
ssealgorithm
  [m13272]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.SSEAlgorithm
   (clojure.core/name m13272)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ResponseHeaderOverrides}
response-header-overrides
  [m13275]
  (clojure.core/let
   [bean13274
    (new com.amazonaws.services.s3.model.ResponseHeaderOverrides)]
   (clojure.core/let
    [v13276
     (:content-type m13275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setContentType (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:content-encoding
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setContentEncoding (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:cache-control m13275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setCacheControl (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:content-disposition
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setContentDisposition (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:content-language
      m13275
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setContentLanguage (clojure.core/str v13276))))
   (clojure.core/let
    [v13276
     (:expires m13275 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13276 :com.palletops.awaze.client-builder/undef)
     (. bean13274 setExpires (clojure.core/str v13276))))
   bean13274))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
canned-access-control-list
  [m13278]
  (java.lang.Enum/valueOf
   com.amazonaws.services.s3.model.CannedAccessControlList
   (clojure.core/name m13278)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AccessControlList}
access-control-list
  [m13281]
  (clojure.core/let
   [bean13280 (new com.amazonaws.services.s3.model.AccessControlList)]
   (clojure.core/let
    [v13282 (:owner m13281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setOwner (s3/owner v13282))))
   (clojure.core/let
    [v13282
     (:requester-charged
      m13281
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13282 :com.palletops.awaze.client-builder/undef)
     (. bean13280 setRequesterCharged (clojure.core/boolean v13282))))
   bean13280))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SSEAwsKeyManagementParams}
sseaws-key-management-params
  [m13284]
  (clojure.core/let
   [bean13283
    (new com.amazonaws.services.s3.model.SSEAwsKeyManagementParams)]
   bean13283))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectMetadata}
object-metadata
  [m13287]
  (clojure.core/let
   [bean13286 (new com.amazonaws.services.s3.model.ObjectMetadata)]
   (clojure.core/let
    [v13288
     (:content-encoding
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setContentEncoding (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:expiration-time-rule-id
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setExpirationTimeRuleId (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:cache-control m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setCacheControl (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:requester-charged
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setRequesterCharged (clojure.core/boolean v13288))))
   (clojure.core/let
    [v13288
     (:restore-expiration-time
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setRestoreExpirationTime
      (com.palletops.awaze.common/to-date v13288))))
   (clojure.core/let
    [v13288
     (:content-type m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setContentType (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:content-length
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setContentLength (clojure.core/long v13288))))
   (clojure.core/let
    [v13288
     (:ssecustomer-key-md5
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setSSECustomerKeyMd5 (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:ongoing-restore
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setOngoingRestore (clojure.core/boolean v13288))))
   (clojure.core/let
    [v13288
     (:expiration-time
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setExpirationTime
      (com.palletops.awaze.common/to-date v13288))))
   (clojure.core/let
    [v13288
     (:user-metadata m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setUserMetadata
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13581] (clojure.core/str arg13581))
  (clojure.core/keys v13288))
 (clojure.core/map
  (clojure.core/fn [arg13581] (clojure.core/str arg13581))
  (clojure.core/vals v13288))))))
   (clojure.core/let
    [v13288
     (:last-modified m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setLastModified
      (com.palletops.awaze.common/to-date v13288))))
   (clojure.core/let
    [v13288
     (:content-md5 m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setContentMD5 (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:content-disposition
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setContentDisposition (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:server-side-encryption
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setServerSideEncryption (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:ssealgorithm m13287 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setSSEAlgorithm (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:ssecustomer-algorithm
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (. bean13286 setSSECustomerAlgorithm (clojure.core/str v13288))))
   (clojure.core/let
    [v13288
     (:http-expires-date
      m13287
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13288 :com.palletops.awaze.client-builder/undef)
     (.
      bean13286
      setHttpExpiresDate
      (com.palletops.awaze.common/to-date v13288))))
   bean13286))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.MultiFactorAuthentication}
multi-factor-authentication
  [m13290]
  (clojure.core/let
   [arg13292
    nil
    arg13293
    nil
    bean13289
    (new
     com.amazonaws.services.s3.model.MultiFactorAuthentication
     arg13292
     arg13293)]
   (clojure.core/let
    [v13291
     (:device-serial-number
      m13290
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setDeviceSerialNumber (clojure.core/str v13291))))
   (clojure.core/let
    [v13291 (:token m13290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13291 :com.palletops.awaze.client-builder/undef)
     (. bean13289 setToken (clojure.core/str v13291))))
   bean13289))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion}
delete-objects-request-key-version
  [m13295]
  (clojure.core/let
   [arg13297
    nil
    bean13294
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest$KeyVersion
     arg13297)]
   bean13294))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketVersioningConfiguration}
bucket-versioning-configuration
  [m13299]
  (clojure.core/let
   [bean13298
    (new
     com.amazonaws.services.s3.model.BucketVersioningConfiguration)]
   (clojure.core/let
    [v13300
     (:mfa-delete-enabled
      m13299
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13300 :com.palletops.awaze.client-builder/undef)
     (. bean13298 setMfaDeleteEnabled (clojure.core/boolean v13300))))
   (clojure.core/let
    [v13300
     (:status m13299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13300 :com.palletops.awaze.client-builder/undef)
     (. bean13298 setStatus (clojure.core/str v13300))))
   bean13298))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketLoggingConfiguration}
bucket-logging-configuration
  [m13302]
  (clojure.core/let
   [bean13301
    (new com.amazonaws.services.s3.model.BucketLoggingConfiguration)]
   (clojure.core/let
    [v13303
     (:destination-bucket-name
      m13302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setDestinationBucketName (clojure.core/str v13303))))
   (clojure.core/let
    [v13303
     (:log-file-prefix
      m13302
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13303 :com.palletops.awaze.client-builder/undef)
     (. bean13301 setLogFilePrefix (clojure.core/str v13303))))
   bean13301))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.S3ObjectId}
s3object-id
  [m13305]
  (clojure.core/let
   [arg13307
    nil
    arg13308
    nil
    bean13304
    (new com.amazonaws.services.s3.model.S3ObjectId arg13307 arg13308)]
   bean13304))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PartETag}
part-etag
  [m13310]
  (clojure.core/let
   [arg13312
    0
    arg13313
    nil
    bean13309
    (new com.amazonaws.services.s3.model.PartETag arg13312 arg13313)]
   (clojure.core/let
    [v13311 (:etag m13310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13311 :com.palletops.awaze.client-builder/undef)
     (. bean13309 setETag (clojure.core/str v13311))))
   (clojure.core/let
    [v13311
     (:part-number m13310 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13311 :com.palletops.awaze.client-builder/undef)
     (. bean13309 setPartNumber (clojure.core/int v13311))))
   bean13309))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketReplicationConfiguration}
bucket-replication-configuration
  [m13315]
  (clojure.core/let
   [bean13314
    (new
     com.amazonaws.services.s3.model.BucketReplicationConfiguration)]
   (clojure.core/let
    [v13316 (:rules m13315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13316 :com.palletops.awaze.client-builder/undef)
     (.
      bean13314
      setRules
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg13582] (clojure.core/str arg13582))
  (clojure.core/keys v13316))
 (clojure.core/map
  (clojure.core/fn [arg13582] (s3/replication-rule arg13582))
  (clojure.core/vals v13316))))))
   (clojure.core/let
    [v13316
     (:role-arn m13315 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13316 :com.palletops.awaze.client-builder/undef)
     (. bean13314 setRoleARN (clojure.core/str v13316))))
   bean13314))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketTaggingConfiguration}
bucket-tagging-configuration
  [m13318]
  (clojure.core/let
   [bean13317
    (new com.amazonaws.services.s3.model.BucketTaggingConfiguration)]
   (clojure.core/let
    [v13319
     (:tag-sets m13318 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13319 :com.palletops.awaze.client-builder/undef)
     (.
      bean13317
      setTagSets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg13583] (s3/tag-set arg13583))
 v13319))))
   bean13317))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ObjectListing}
object-listing
  [m13321]
  (clojure.core/let
   [bean13320 (new com.amazonaws.services.s3.model.ObjectListing)]
   (clojure.core/let
    [v13322
     (:prefix m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setPrefix (clojure.core/str v13322))))
   (clojure.core/let
    [v13322
     (:bucket-name m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setBucketName (clojure.core/str v13322))))
   (clojure.core/let
    [v13322
     (:encoding-type m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setEncodingType (clojure.core/str v13322))))
   (clojure.core/let
    [v13322
     (:max-keys m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setMaxKeys (clojure.core/int v13322))))
   (clojure.core/let
    [v13322
     (:marker m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setMarker (clojure.core/str v13322))))
   (clojure.core/let
    [v13322
     (:next-marker m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setNextMarker (clojure.core/str v13322))))
   (clojure.core/let
    [v13322
     (:truncated m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setTruncated (clojure.core/boolean v13322))))
   (clojure.core/let
    [v13322
     (:common-prefixes
      m13321
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (.
      bean13320
      setCommonPrefixes
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13584] (clojure.core/str arg13584))
 v13322))))
   (clojure.core/let
    [v13322
     (:delimiter m13321 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13322 :com.palletops.awaze.client-builder/undef)
     (. bean13320 setDelimiter (clojure.core/str v13322))))
   bean13320))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.BucketWebsiteConfiguration}
bucket-website-configuration
  [m13324]
  (clojure.core/let
   [bean13323
    (new com.amazonaws.services.s3.model.BucketWebsiteConfiguration)]
   (clojure.core/let
    [v13325
     (:index-document-suffix
      m13324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (. bean13323 setIndexDocumentSuffix (clojure.core/str v13325))))
   (clojure.core/let
    [v13325
     (:error-document
      m13324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (. bean13323 setErrorDocument (clojure.core/str v13325))))
   (clojure.core/let
    [v13325
     (:redirect-all-requests-to
      m13324
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (. bean13323 setRedirectAllRequestsTo (s3/redirect-rule v13325))))
   (clojure.core/let
    [v13325
     (:routing-rules m13324 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13325 :com.palletops.awaze.client-builder/undef)
     (.
      bean13323
      setRoutingRules
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13585] (s3/routing-rule arg13585))
 v13325))))
   bean13323))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
delete-bucket-website-configuration-request
  [m13327]
  (clojure.core/let
   [arg13329
    nil
    bean13326
    (new
     com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
     arg13329)]
   bean13326))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetObjectAclRequest}
set-object-acl-request
  [m13331]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13333
    nil
^{:tag java.lang.String}
arg13334
    nil
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13335
    (access-control-list {})
    bean13330
    (new
     com.amazonaws.services.s3.model.SetObjectAclRequest
^{:tag java.lang.String}
arg13333
^{:tag java.lang.String}
arg13334
^{:tag com.amazonaws.services.s3.model.AccessControlList}
arg13335)]
   (clojure.core/let
    [v13332
     (:requester-pays
      m13331
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13332 :com.palletops.awaze.client-builder/undef)
     (. bean13330 setRequesterPays (clojure.core/boolean v13332))))
   bean13330))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
get-bucket-lifecycle-configuration-request
  [m13337]
  (clojure.core/let
   [arg13339
    nil
    bean13336
    (new
     com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
     arg13339)]
   bean13336))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m13341]
  (clojure.core/let
   [arg13343
    nil
    bean13340
    (new
     com.amazonaws.services.s3.model.ListMultipartUploadsRequest
     arg13343)]
   (clojure.core/let
    [v13342
     (:max-uploads m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setMaxUploads (clojure.core/int v13342))))
   (clojure.core/let
    [v13342
     (:delimiter m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setDelimiter (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:key-marker m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setKeyMarker (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:encoding-type m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setEncodingType (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:bucket-name m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setBucketName (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:prefix m13341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setPrefix (clojure.core/str v13342))))
   (clojure.core/let
    [v13342
     (:upload-id-marker
      m13341
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13342 :com.palletops.awaze.client-builder/undef)
     (. bean13340 setUploadIdMarker (clojure.core/str v13342))))
   bean13340))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectMetadataRequest}
get-object-metadata-request
  [m13345]
  (clojure.core/let
   [arg13347
    nil
    arg13348
    nil
    bean13344
    (new
     com.amazonaws.services.s3.model.GetObjectMetadataRequest
     arg13347
     arg13348)]
   (clojure.core/let
    [v13346
     (:version-id m13345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13346 :com.palletops.awaze.client-builder/undef)
     (. bean13344 setVersionId (clojure.core/str v13346))))
   (clojure.core/let
    [v13346
     (:ssecustomer-key
      m13345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13346 :com.palletops.awaze.client-builder/undef)
     (. bean13344 setSSECustomerKey (s3/ssecustomer-key v13346))))
   (clojure.core/let
    [v13346
     (:requester-pays
      m13345
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13346 :com.palletops.awaze.client-builder/undef)
     (. bean13344 setRequesterPays (clojure.core/boolean v13346))))
   (clojure.core/let
    [v13346
     (:bucket-name m13345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13346 :com.palletops.awaze.client-builder/undef)
     (. bean13344 setBucketName (clojure.core/str v13346))))
   (clojure.core/let
    [v13346 (:key m13345 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13346 :com.palletops.awaze.client-builder/undef)
     (. bean13344 setKey (clojure.core/str v13346))))
   bean13344))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest}
set-bucket-cross-origin-configuration-request
  [m13350]
  (clojure.core/let
   [arg13352
    nil
    arg13353
    (bucket-cross-origin-configuration {})
    bean13349
    (new
     com.amazonaws.services.s3.model.SetBucketCrossOriginConfigurationRequest
     arg13352
     arg13353)]
   (clojure.core/let
    [v13351
     (:cross-origin-configuration
      m13350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (.
      bean13349
      setCrossOriginConfiguration
      (s3/bucket-cross-origin-configuration v13351))))
   (clojure.core/let
    [v13351
     (:bucket-name m13350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13351 :com.palletops.awaze.client-builder/undef)
     (. bean13349 setBucketName (clojure.core/str v13351))))
   bean13349))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
delete-bucket-replication-configuration-request
  [m13355]
  (clojure.core/let
   [arg13357
    nil
    bean13354
    (new
     com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
     arg13357)]
   bean13354))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest}
set-bucket-lifecycle-configuration-request
  [m13359]
  (clojure.core/let
   [arg13361
    nil
    arg13362
    (bucket-lifecycle-configuration {})
    bean13358
    (new
     com.amazonaws.services.s3.model.SetBucketLifecycleConfigurationRequest
     arg13361
     arg13362)]
   (clojure.core/let
    [v13360
     (:lifecycle-configuration
      m13359
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13360 :com.palletops.awaze.client-builder/undef)
     (.
      bean13358
      setLifecycleConfiguration
      (s3/bucket-lifecycle-configuration v13360))))
   (clojure.core/let
    [v13360
     (:bucket-name m13359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13360 :com.palletops.awaze.client-builder/undef)
     (. bean13358 setBucketName (clojure.core/str v13360))))
   bean13358))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest}
set-bucket-notification-configuration-request
  [m13364]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13366
    nil
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13367
    (bucket-notification-configuration {})
    bean13363
    (new
     com.amazonaws.services.s3.model.SetBucketNotificationConfigurationRequest
^{:tag java.lang.String}
arg13366
^{:tag com.amazonaws.services.s3.model.BucketNotificationConfiguration}
arg13367)]
   (clojure.core/let
    [v13365
     (:notification-configuration
      m13364
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13365 :com.palletops.awaze.client-builder/undef)
     (.
      bean13363
      setNotificationConfiguration
      (s3/bucket-notification-configuration v13365))))
   (clojure.core/let
    [v13365
     (:bucket-notification-configuration
      m13364
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13365 :com.palletops.awaze.client-builder/undef)
     (.
      bean13363
      setBucketNotificationConfiguration
      (s3/bucket-notification-configuration v13365))))
   (clojure.core/let
    [v13365
     (:bucket-name m13364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13365 :com.palletops.awaze.client-builder/undef)
     (. bean13363 setBucketName (clojure.core/str v13365))))
   (clojure.core/let
    [v13365
     (:bucket m13364 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13365 :com.palletops.awaze.client-builder/undef)
     (. bean13363 setBucket (clojure.core/str v13365))))
   bean13363))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
delete-bucket-policy-request
  [m13369]
  (clojure.core/let
   [arg13371
    nil
    bean13368
    (new
     com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
     arg13371)]
   (clojure.core/let
    [v13370
     (:bucket-name m13369 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13370 :com.palletops.awaze.client-builder/undef)
     (. bean13368 setBucketName (clojure.core/str v13370))))
   bean13368))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.HeadBucketRequest}
head-bucket-request
  [m13373]
  (clojure.core/let
   [arg13375
    nil
    bean13372
    (new com.amazonaws.services.s3.model.HeadBucketRequest arg13375)]
   (clojure.core/let
    [v13374
     (:bucket-name m13373 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13374 :com.palletops.awaze.client-builder/undef)
     (. bean13372 setBucketName (clojure.core/str v13374))))
   bean13372))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.S3ClientOptions}
s3client-options
  [m13377]
  (clojure.core/let
   [bean13376 (new com.amazonaws.services.s3.S3ClientOptions)]
   (clojure.core/let
    [v13378
     (:path-style-access
      m13377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13378 :com.palletops.awaze.client-builder/undef)
     (. bean13376 setPathStyleAccess (clojure.core/boolean v13378))))
   (clojure.core/let
    [v13378
     (:chunked-encoding-disabled
      m13377
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13378 :com.palletops.awaze.client-builder/undef)
     (.
      bean13376
      setChunkedEncodingDisabled
      (clojure.core/boolean v13378))))
   bean13376))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
get-bucket-notification-configuration-request
  [m13380]
  (clojure.core/let
   [arg13382
    nil
    bean13379
    (new
     com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
     arg13382)]
   bean13379))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
delete-bucket-lifecycle-configuration-request
  [m13384]
  (clojure.core/let
   [arg13386
    nil
    bean13383
    (new
     com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
     arg13386)]
   bean13383))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
list-objects-request
  [m13388]
  (clojure.core/let
   [bean13387
    (new com.amazonaws.services.s3.model.ListObjectsRequest)]
   (clojure.core/let
    [v13389
     (:delimiter m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setDelimiter (clojure.core/str v13389))))
   (clojure.core/let
    [v13389
     (:max-keys m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setMaxKeys (clojure.core/int v13389))))
   (clojure.core/let
    [v13389
     (:encoding-type m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setEncodingType (clojure.core/str v13389))))
   (clojure.core/let
    [v13389
     (:marker m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setMarker (clojure.core/str v13389))))
   (clojure.core/let
    [v13389
     (:bucket-name m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setBucketName (clojure.core/str v13389))))
   (clojure.core/let
    [v13389
     (:prefix m13388 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13389 :com.palletops.awaze.client-builder/undef)
     (. bean13387 setPrefix (clojure.core/str v13389))))
   bean13387))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m13391]
  (clojure.core/let
   [arg13393
    nil
    arg13394
    nil
    arg13395
    nil
    bean13390
    (new
     com.amazonaws.services.s3.model.AbortMultipartUploadRequest
     arg13393
     arg13394
     arg13395)]
   (clojure.core/let
    [v13392
     (:requester-pays
      m13391
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (. bean13390 setRequesterPays (clojure.core/boolean v13392))))
   (clojure.core/let
    [v13392
     (:bucket-name m13391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (. bean13390 setBucketName (clojure.core/str v13392))))
   (clojure.core/let
    [v13392
     (:upload-id m13391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (. bean13390 setUploadId (clojure.core/str v13392))))
   (clojure.core/let
    [v13392 (:key m13391 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13392 :com.palletops.awaze.client-builder/undef)
     (. bean13390 setKey (clojure.core/str v13392))))
   bean13390))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetS3AccountOwnerRequest}
get-s3account-owner-request
  [m13397]
  (clojure.core/let
   [bean13396
    (new com.amazonaws.services.s3.model.GetS3AccountOwnerRequest)]
   bean13396))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListBucketsRequest}
list-buckets-request
  [m13400]
  (clojure.core/let
   [bean13399
    (new com.amazonaws.services.s3.model.ListBucketsRequest)]
   bean13399))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
get-bucket-website-configuration-request
  [m13403]
  (clojure.core/let
   [arg13405
    nil
    bean13402
    (new
     com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
     arg13405)]
   (clojure.core/let
    [v13404
     (:bucket-name m13403 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13404 :com.palletops.awaze.client-builder/undef)
     (. bean13402 setBucketName (clojure.core/str v13404))))
   bean13402))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListPartsRequest}
list-parts-request
  [m13407]
  (clojure.core/let
   [arg13409
    nil
    arg13410
    nil
    arg13411
    nil
    bean13406
    (new
     com.amazonaws.services.s3.model.ListPartsRequest
     arg13409
     arg13410
     arg13411)]
   (clojure.core/let
    [v13408
     (:requester-pays
      m13407
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setRequesterPays (clojure.core/boolean v13408))))
   (clojure.core/let
    [v13408
     (:max-parts m13407 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setMaxParts (clojure.core/int v13408))))
   (clojure.core/let
    [v13408
     (:part-number-marker
      m13407
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setPartNumberMarker (clojure.core/int v13408))))
   (clojure.core/let
    [v13408
     (:encoding-type m13407 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setEncodingType (clojure.core/str v13408))))
   (clojure.core/let
    [v13408
     (:bucket-name m13407 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setBucketName (clojure.core/str v13408))))
   (clojure.core/let
    [v13408
     (:upload-id m13407 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setUploadId (clojure.core/str v13408))))
   (clojure.core/let
    [v13408 (:key m13407 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13408 :com.palletops.awaze.client-builder/undef)
     (. bean13406 setKey (clojure.core/str v13408))))
   bean13406))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketAclRequest}
set-bucket-acl-request
  [m13413]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13415
    nil
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13416
    (canned-access-control-list {})
    bean13412
    (new
     com.amazonaws.services.s3.model.SetBucketAclRequest
^{:tag java.lang.String}
arg13415
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
arg13416)]
   bean13412))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyPartRequest}
copy-part-request
  [m13418]
  (clojure.core/let
   [bean13417 (new com.amazonaws.services.s3.model.CopyPartRequest)]
   (clojure.core/let
    [v13419
     (:first-byte m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setFirstByte (clojure.core/long v13419))))
   (clojure.core/let
    [v13419
     (:source-version-id
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setSourceVersionId (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:source-bucket-name
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setSourceBucketName (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:last-byte m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setLastByte (clojure.core/long v13419))))
   (clojure.core/let
    [v13419
     (:unmodified-since-constraint
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13419))))
   (clojure.core/let
    [v13419
     (:modified-since-constraint
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13419))))
   (clojure.core/let
    [v13419
     (:destination-ssecustomer-key
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13419))))
   (clojure.core/let
    [v13419
     (:destination-bucket-name
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setDestinationBucketName (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:part-number m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setPartNumber (clojure.core/int v13419))))
   (clojure.core/let
    [v13419
     (:destination-key
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setDestinationKey (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:matching-etag-constraints
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13586] (clojure.core/str arg13586))
 v13419))))
   (clojure.core/let
    [v13419
     (:source-key m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setSourceKey (clojure.core/str v13419))))
   (clojure.core/let
    [v13419
     (:source-ssecustomer-key
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setSourceSSECustomerKey (s3/ssecustomer-key v13419))))
   (clojure.core/let
    [v13419
     (:nonmatching-etag-constraints
      m13418
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (.
      bean13417
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13587] (clojure.core/str arg13587))
 v13419))))
   (clojure.core/let
    [v13419
     (:upload-id m13418 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13419 :com.palletops.awaze.client-builder/undef)
     (. bean13417 setUploadId (clojure.core/str v13419))))
   bean13417))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
get-bucket-replication-configuration-request
  [m13421]
  (clojure.core/let
   [arg13423
    nil
    bean13420
    (new
     com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
     arg13423)]
   bean13420))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
get-bucket-versioning-configuration-request
  [m13425]
  (clojure.core/let
   [arg13427
    nil
    bean13424
    (new
     com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
     arg13427)]
   bean13424))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
list-next-batch-of-versions-request
  [m13429]
  (clojure.core/let
   [arg13431
    (version-listing {})
    bean13428
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
     arg13431)]
   (clojure.core/let
    [v13430
     (:previous-version-listing
      m13429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13430 :com.palletops.awaze.client-builder/undef)
     (.
      bean13428
      setPreviousVersionListing
      (s3/version-listing v13430))))
   bean13428))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
get-bucket-acl-request
  [m13433]
  (clojure.core/let
   [arg13435
    nil
    bean13432
    (new com.amazonaws.services.s3.model.GetBucketAclRequest arg13435)]
   bean13432))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectRequest}
delete-object-request
  [m13437]
  (clojure.core/let
   [arg13439
    nil
    arg13440
    nil
    bean13436
    (new
     com.amazonaws.services.s3.model.DeleteObjectRequest
     arg13439
     arg13440)]
   (clojure.core/let
    [v13438
     (:requester-pays
      m13437
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13438 :com.palletops.awaze.client-builder/undef)
     (. bean13436 setRequesterPays (clojure.core/boolean v13438))))
   (clojure.core/let
    [v13438
     (:bucket-name m13437 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13438 :com.palletops.awaze.client-builder/undef)
     (. bean13436 setBucketName (clojure.core/str v13438))))
   (clojure.core/let
    [v13438 (:key m13437 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13438 :com.palletops.awaze.client-builder/undef)
     (. bean13436 setKey (clojure.core/str v13438))))
   bean13436))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
delete-bucket-tagging-configuration-request
  [m13442]
  (clojure.core/let
   [arg13444
    nil
    bean13441
    (new
     com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
     arg13444)]
   bean13441))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
get-bucket-logging-configuration-request
  [m13446]
  (clojure.core/let
   [arg13448
    nil
    bean13445
    (new
     com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
     arg13448)]
   bean13445))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GeneratePresignedUrlRequest}
generate-presigned-url-request
  [m13450]
  (clojure.core/let
   [arg13452
    nil
    arg13453
    nil
    bean13449
    (new
     com.amazonaws.services.s3.model.GeneratePresignedUrlRequest
     arg13452
     arg13453)]
   (clojure.core/let
    [v13451
     (:expiration m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (.
      bean13449
      setExpiration
      (com.palletops.awaze.common/to-date v13451))))
   (clojure.core/let
    [v13451
     (:kms-cmk-id m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setKmsCmkId (clojure.core/str v13451))))
   (clojure.core/let
    [v13451
     (:content-type m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setContentType (clojure.core/str v13451))))
   (clojure.core/let
    [v13451
     (:bucket-name m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setBucketName (clojure.core/str v13451))))
   (clojure.core/let
    [v13451
     (:ssecustomer-key
      m13450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setSSECustomerKey (s3/ssecustomer-key v13451))))
   (clojure.core/let
    [v13451
     (:method m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setMethod (root/http-method v13451))))
   (clojure.core/let
    [v13451
     (:ssecustomer-key-algorithm
      m13450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setSSECustomerKeyAlgorithm (s3/ssealgorithm v13451))))
   (clojure.core/let
    [v13451
     (:response-headers
      m13450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (.
      bean13449
      setResponseHeaders
      (s3/response-header-overrides v13451))))
   (clojure.core/let
    [v13451
     (:zero-byte-content
      m13450
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setZeroByteContent (clojure.core/boolean v13451))))
   (clojure.core/let
    [v13451 (:key m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setKey (clojure.core/str v13451))))
   (clojure.core/let
    [v13451
     (:ssealgorithm m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setSSEAlgorithm (s3/ssealgorithm v13451))))
   (clojure.core/let
    [v13451
     (:content-md5 m13450 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13451 :com.palletops.awaze.client-builder/undef)
     (. bean13449 setContentMd5 (clojure.core/str v13451))))
   bean13449))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CopyObjectRequest}
copy-object-request
  [m13455]
  (clojure.core/let
   [arg13457
    nil
    arg13458
    nil
    arg13459
    nil
    arg13460
    nil
    bean13454
    (new
     com.amazonaws.services.s3.model.CopyObjectRequest
     arg13457
     arg13458
     arg13459
     arg13460)]
   (clojure.core/let
    [v13456
     (:canned-access-control-list
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setCannedAccessControlList
      (s3/canned-access-control-list v13456))))
   (clojure.core/let
    [v13456
     (:source-version-id
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setSourceVersionId (clojure.core/str v13456))))
   (clojure.core/let
    [v13456
     (:source-bucket-name
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setSourceBucketName (clojure.core/str v13456))))
   (clojure.core/let
    [v13456
     (:unmodified-since-constraint
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13456))))
   (clojure.core/let
    [v13456
     (:modified-since-constraint
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13456))))
   (clojure.core/let
    [v13456
     (:storage-class m13455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setStorageClass (s3/storage-class v13456))))
   (clojure.core/let
    [v13456
     (:destination-ssecustomer-key
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setDestinationSSECustomerKey
      (s3/ssecustomer-key v13456))))
   (clojure.core/let
    [v13456
     (:destination-bucket-name
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setDestinationBucketName (clojure.core/str v13456))))
   (clojure.core/let
    [v13456
     (:redirect-location
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setRedirectLocation (clojure.core/str v13456))))
   (clojure.core/let
    [v13456
     (:requester-pays
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setRequesterPays (clojure.core/boolean v13456))))
   (clojure.core/let
    [v13456
     (:access-control-list
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setAccessControlList
      (s3/access-control-list v13456))))
   (clojure.core/let
    [v13456
     (:sseaws-key-management-params
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13456))))
   (clojure.core/let
    [v13456
     (:destination-key
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setDestinationKey (clojure.core/str v13456))))
   (clojure.core/let
    [v13456
     (:matching-etag-constraints
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13588] (clojure.core/str arg13588))
 v13456))))
   (clojure.core/let
    [v13456
     (:source-key m13455 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setSourceKey (clojure.core/str v13456))))
   (clojure.core/let
    [v13456
     (:source-ssecustomer-key
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setSourceSSECustomerKey (s3/ssecustomer-key v13456))))
   (clojure.core/let
    [v13456
     (:new-object-metadata
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (. bean13454 setNewObjectMetadata (s3/object-metadata v13456))))
   (clojure.core/let
    [v13456
     (:nonmatching-etag-constraints
      m13455
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13456 :com.palletops.awaze.client-builder/undef)
     (.
      bean13454
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13589] (clojure.core/str arg13589))
 v13456))))
   bean13454))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteObjectsRequest}
delete-objects-request
  [m13462]
  (clojure.core/let
   [arg13464
    nil
    bean13461
    (new
     com.amazonaws.services.s3.model.DeleteObjectsRequest
     arg13464)]
   (clojure.core/let
    [v13463
     (:requester-pays
      m13462
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13463 :com.palletops.awaze.client-builder/undef)
     (. bean13461 setRequesterPays (clojure.core/boolean v13463))))
   (clojure.core/let
    [v13463 (:mfa m13462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13463 :com.palletops.awaze.client-builder/undef)
     (. bean13461 setMfa (s3/multi-factor-authentication v13463))))
   (clojure.core/let
    [v13463 (:quiet m13462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13463 :com.palletops.awaze.client-builder/undef)
     (. bean13461 setQuiet (clojure.core/boolean v13463))))
   (clojure.core/let
    [v13463 (:keys m13462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13463 :com.palletops.awaze.client-builder/undef)
     (.
      bean13461
      setKeys
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg13590]
  (s3/delete-objects-request-key-version arg13590))
 v13463))))
   (clojure.core/let
    [v13463
     (:bucket-name m13462 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13463 :com.palletops.awaze.client-builder/undef)
     (. bean13461 setBucketName (clojure.core/str v13463))))
   bean13461))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest}
set-bucket-versioning-configuration-request
  [m13466]
  (clojure.core/let
   [arg13468
    nil
    arg13469
    (bucket-versioning-configuration {})
    bean13465
    (new
     com.amazonaws.services.s3.model.SetBucketVersioningConfigurationRequest
     arg13468
     arg13469)]
   (clojure.core/let
    [v13467
     (:versioning-configuration
      m13466
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13467 :com.palletops.awaze.client-builder/undef)
     (.
      bean13465
      setVersioningConfiguration
      (s3/bucket-versioning-configuration v13467))))
   (clojure.core/let
    [v13467 (:mfa m13466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13467 :com.palletops.awaze.client-builder/undef)
     (. bean13465 setMfa (s3/multi-factor-authentication v13467))))
   (clojure.core/let
    [v13467
     (:bucket-name m13466 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13467 :com.palletops.awaze.client-builder/undef)
     (. bean13465 setBucketName (clojure.core/str v13467))))
   bean13465))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest}
set-bucket-logging-configuration-request
  [m13471]
  (clojure.core/let
   [arg13473
    nil
    arg13474
    (bucket-logging-configuration {})
    bean13470
    (new
     com.amazonaws.services.s3.model.SetBucketLoggingConfigurationRequest
     arg13473
     arg13474)]
   (clojure.core/let
    [v13472
     (:logging-configuration
      m13471
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (.
      bean13470
      setLoggingConfiguration
      (s3/bucket-logging-configuration v13472))))
   (clojure.core/let
    [v13472
     (:bucket-name m13471 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13472 :com.palletops.awaze.client-builder/undef)
     (. bean13470 setBucketName (clojure.core/str v13472))))
   bean13470))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
get-object-request
  [m13476]
  (clojure.core/let
   [arg13478
    nil
    arg13479
    nil
    bean13475
    (new
     com.amazonaws.services.s3.model.GetObjectRequest
     arg13478
     arg13479)]
   (clojure.core/let
    [v13477
     (:progress-listener
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setProgressListener v13477)))
   (clojure.core/let
    [v13477
     (:bucket-name m13476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setBucketName (clojure.core/str v13477))))
   (clojure.core/let
    [v13477
     (:ssecustomer-key
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setSSECustomerKey (s3/ssecustomer-key v13477))))
   (clojure.core/let
    [v13477
     (:unmodified-since-constraint
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (.
      bean13475
      setUnmodifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13477))))
   (clojure.core/let
    [v13477
     (:modified-since-constraint
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (.
      bean13475
      setModifiedSinceConstraint
      (com.palletops.awaze.common/to-date v13477))))
   (clojure.core/let
    [v13477 (:range m13476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setRange (clojure.core/long v13477))))
   (clojure.core/let
    [v13477
     (:s3object-id m13476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setS3ObjectId (s3/s3object-id v13477))))
   (clojure.core/let
    [v13477
     (:response-headers
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (.
      bean13475
      setResponseHeaders
      (s3/response-header-overrides v13477))))
   (clojure.core/let
    [v13477
     (:requester-pays
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setRequesterPays (clojure.core/boolean v13477))))
   (clojure.core/let
    [v13477 (:key m13476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setKey (clojure.core/str v13477))))
   (clojure.core/let
    [v13477
     (:matching-etag-constraints
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (.
      bean13475
      setMatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13591] (clojure.core/str arg13591))
 v13477))))
   (clojure.core/let
    [v13477
     (:version-id m13476 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (. bean13475 setVersionId (clojure.core/str v13477))))
   (clojure.core/let
    [v13477
     (:nonmatching-etag-constraints
      m13476
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13477 :com.palletops.awaze.client-builder/undef)
     (.
      bean13475
      setNonmatchingETagConstraints
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13592] (clojure.core/str arg13592))
 v13477))))
   bean13475))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
delete-bucket-cross-origin-configuration-request
  [m13481]
  (clojure.core/let
   [arg13483
    nil
    bean13480
    (new
     com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
     arg13483)]
   bean13480))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m13485]
  (clojure.core/let
   [bean13484
    (new
     com.amazonaws.services.s3.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v13486
     (:requester-pays
      m13485
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setRequesterPays (clojure.core/boolean v13486))))
   (clojure.core/let
    [v13486
     (:part-etags m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (.
      bean13484
      setPartETags
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg13593] (s3/part-etag arg13593))
 v13486))))
   (clojure.core/let
    [v13486
     (:bucket-name m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setBucketName (clojure.core/str v13486))))
   (clojure.core/let
    [v13486
     (:upload-id m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setUploadId (clojure.core/str v13486))))
   (clojure.core/let
    [v13486 (:key m13485 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13486 :com.palletops.awaze.client-builder/undef)
     (. bean13484 setKey (clojure.core/str v13486))))
   bean13484))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.RestoreObjectRequest}
restore-object-request
  [m13488]
  (clojure.core/let
   [arg13490
    nil
    arg13491
    nil
    bean13487
    (new
     com.amazonaws.services.s3.model.RestoreObjectRequest
     arg13490
     arg13491)]
   (clojure.core/let
    [v13489
     (:version-id m13488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13489 :com.palletops.awaze.client-builder/undef)
     (. bean13487 setVersionId (clojure.core/str v13489))))
   (clojure.core/let
    [v13489
     (:requester-pays
      m13488
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13489 :com.palletops.awaze.client-builder/undef)
     (. bean13487 setRequesterPays (clojure.core/boolean v13489))))
   (clojure.core/let
    [v13489
     (:expiration-in-days
      m13488
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13489 :com.palletops.awaze.client-builder/undef)
     (. bean13487 setExpirationInDays (clojure.core/int v13489))))
   (clojure.core/let
    [v13489
     (:bucket-name m13488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13489 :com.palletops.awaze.client-builder/undef)
     (. bean13487 setBucketName (clojure.core/str v13489))))
   (clojure.core/let
    [v13489 (:key m13488 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13489 :com.palletops.awaze.client-builder/undef)
     (. bean13487 setKey (clojure.core/str v13489))))
   bean13487))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
get-bucket-policy-request
  [m13493]
  (clojure.core/let
   [arg13495
    nil
    bean13492
    (new
     com.amazonaws.services.s3.model.GetBucketPolicyRequest
     arg13495)]
   (clojure.core/let
    [v13494
     (:bucket-name m13493 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13494 :com.palletops.awaze.client-builder/undef)
     (. bean13492 setBucketName (clojure.core/str v13494))))
   bean13492))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest}
set-bucket-replication-configuration-request
  [m13497]
  (clojure.core/let
   [bean13496
    (new
     com.amazonaws.services.s3.model.SetBucketReplicationConfigurationRequest)]
   (clojure.core/let
    [v13498
     (:replication-configuration
      m13497
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (.
      bean13496
      setReplicationConfiguration
      (s3/bucket-replication-configuration v13498))))
   (clojure.core/let
    [v13498
     (:bucket-name m13497 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13498 :com.palletops.awaze.client-builder/undef)
     (. bean13496 setBucketName (clojure.core/str v13498))))
   bean13496))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.Region}
region
  [m13500]
  (.
   com.amazonaws.services.s3.model.Region
   fromValue
   (clojure.core/name m13500)))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
create-bucket-request
  [m13503]
  (clojure.core/let
   [arg13505
    nil
    bean13502
    (new com.amazonaws.services.s3.model.CreateBucketRequest arg13505)]
   (clojure.core/let
    [v13504
     (:canned-acl m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setCannedAcl (s3/canned-access-control-list v13504))))
   (clojure.core/let
    [v13504
     (:access-control-list
      m13503
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (.
      bean13502
      setAccessControlList
      (s3/access-control-list v13504))))
   (clojure.core/let
    [v13504
     (:bucket-name m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setBucketName (clojure.core/str v13504))))
   (clojure.core/let
    [v13504
     (:region m13503 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13504 :com.palletops.awaze.client-builder/undef)
     (. bean13502 setRegion (clojure.core/str v13504))))
   bean13502))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteVersionRequest}
delete-version-request
  [m13507]
  (clojure.core/let
   [arg13509
    nil
    arg13510
    nil
    arg13511
    nil
    bean13506
    (new
     com.amazonaws.services.s3.model.DeleteVersionRequest
     arg13509
     arg13510
     arg13511)]
   (clojure.core/let
    [v13508
     (:version-id m13507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13508 :com.palletops.awaze.client-builder/undef)
     (. bean13506 setVersionId (clojure.core/str v13508))))
   (clojure.core/let
    [v13508 (:mfa m13507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13508 :com.palletops.awaze.client-builder/undef)
     (. bean13506 setMfa (s3/multi-factor-authentication v13508))))
   (clojure.core/let
    [v13508
     (:bucket-name m13507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13508 :com.palletops.awaze.client-builder/undef)
     (. bean13506 setBucketName (clojure.core/str v13508))))
   (clojure.core/let
    [v13508 (:key m13507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13508 :com.palletops.awaze.client-builder/undef)
     (. bean13506 setKey (clojure.core/str v13508))))
   bean13506))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.PutObjectRequest}
put-object-request
  [m13513]
  (clojure.core/let
   [^{:tag java.lang.String}
    arg13515
    nil
^{:tag java.lang.String}
arg13516
    nil
^{:tag java.lang.String}
arg13517
    nil
    bean13512
    (new
     com.amazonaws.services.s3.model.PutObjectRequest
^{:tag java.lang.String}
arg13515
^{:tag java.lang.String}
arg13516
^{:tag java.lang.String}
arg13517)]
   (clojure.core/let
    [v13514
     (:requester-pays
      m13513
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13514 :com.palletops.awaze.client-builder/undef)
     (. bean13512 setRequesterPays (clojure.core/boolean v13514))))
   bean13512))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListVersionsRequest}
list-versions-request
  [m13519]
  (clojure.core/let
   [bean13518
    (new com.amazonaws.services.s3.model.ListVersionsRequest)]
   (clojure.core/let
    [v13520
     (:delimiter m13519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setDelimiter (clojure.core/str v13520))))
   (clojure.core/let
    [v13520
     (:key-marker m13519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setKeyMarker (clojure.core/str v13520))))
   (clojure.core/let
    [v13520
     (:version-id-marker
      m13519
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setVersionIdMarker (clojure.core/str v13520))))
   (clojure.core/let
    [v13520
     (:encoding-type m13519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setEncodingType (clojure.core/str v13520))))
   (clojure.core/let
    [v13520
     (:bucket-name m13519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setBucketName (clojure.core/str v13520))))
   (clojure.core/let
    [v13520
     (:prefix m13519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setPrefix (clojure.core/str v13520))))
   (clojure.core/let
    [v13520
     (:max-results m13519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13520 :com.palletops.awaze.client-builder/undef)
     (. bean13518 setMaxResults (clojure.core/int v13520))))
   bean13518))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest}
set-bucket-tagging-configuration-request
  [m13522]
  (clojure.core/let
   [arg13524
    nil
    arg13525
    (bucket-tagging-configuration {})
    bean13521
    (new
     com.amazonaws.services.s3.model.SetBucketTaggingConfigurationRequest
     arg13524
     arg13525)]
   (clojure.core/let
    [v13523
     (:tagging-configuration
      m13522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13523 :com.palletops.awaze.client-builder/undef)
     (.
      bean13521
      setTaggingConfiguration
      (s3/bucket-tagging-configuration v13523))))
   (clojure.core/let
    [v13523
     (:bucket-name m13522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13523 :com.palletops.awaze.client-builder/undef)
     (. bean13521 setBucketName (clojure.core/str v13523))))
   bean13521))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
get-bucket-cross-origin-configuration-request
  [m13527]
  (clojure.core/let
   [arg13529
    nil
    bean13526
    (new
     com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
     arg13529)]
   bean13526))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketPolicyRequest}
set-bucket-policy-request
  [m13531]
  (clojure.core/let
   [arg13533
    nil
    arg13534
    nil
    bean13530
    (new
     com.amazonaws.services.s3.model.SetBucketPolicyRequest
     arg13533
     arg13534)]
   (clojure.core/let
    [v13532
     (:policy-text m13531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13532 :com.palletops.awaze.client-builder/undef)
     (. bean13530 setPolicyText (clojure.core/str v13532))))
   (clojure.core/let
    [v13532
     (:bucket-name m13531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13532 :com.palletops.awaze.client-builder/undef)
     (. bean13530 setBucketName (clojure.core/str v13532))))
   bean13530))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
list-next-batch-of-objects-request
  [m13536]
  (clojure.core/let
   [arg13538
    (object-listing {})
    bean13535
    (new
     com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
     arg13538)]
   (clojure.core/let
    [v13537
     (:previous-object-listing
      m13536
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13537 :com.palletops.awaze.client-builder/undef)
     (. bean13535 setPreviousObjectListing (s3/object-listing v13537))))
   bean13535))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m13540]
  (clojure.core/let
   [arg13542
    nil
    arg13543
    nil
    bean13539
    (new
     com.amazonaws.services.s3.model.InitiateMultipartUploadRequest
     arg13542
     arg13543)]
   (clojure.core/let
    [v13541
     (:bucket-name m13540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setBucketName (clojure.core/str v13541))))
   (clojure.core/let
    [v13541
     (:ssecustomer-key
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setSSECustomerKey (s3/ssecustomer-key v13541))))
   (clojure.core/let
    [v13541
     (:canned-acl m13540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setCannedACL (s3/canned-access-control-list v13541))))
   (clojure.core/let
    [v13541
     (:storage-class m13540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setStorageClass (s3/storage-class v13541))))
   (clojure.core/let
    [v13541
     (:redirect-location
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setRedirectLocation (clojure.core/str v13541))))
   (clojure.core/let
    [v13541
     (:requester-pays
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setRequesterPays (clojure.core/boolean v13541))))
   (clojure.core/let
    [v13541
     (:object-metadata
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setObjectMetadata (s3/object-metadata v13541))))
   (clojure.core/let
    [v13541
     (:access-control-list
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (.
      bean13539
      setAccessControlList
      (s3/access-control-list v13541))))
   (clojure.core/let
    [v13541 (:key m13540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (. bean13539 setKey (clojure.core/str v13541))))
   (clojure.core/let
    [v13541
     (:sseaws-key-management-params
      m13540
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13541 :com.palletops.awaze.client-builder/undef)
     (.
      bean13539
      setSSEAwsKeyManagementParams
      (s3/sseaws-key-management-params v13541))))
   bean13539))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
delete-bucket-request
  [m13545]
  (clojure.core/let
   [arg13547
    nil
    bean13544
    (new com.amazonaws.services.s3.model.DeleteBucketRequest arg13547)]
   (clojure.core/let
    [v13546
     (:bucket-name m13545 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13546 :com.palletops.awaze.client-builder/undef)
     (. bean13544 setBucketName (clojure.core/str v13546))))
   bean13544))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
get-bucket-tagging-configuration-request
  [m13549]
  (clojure.core/let
   [arg13551
    nil
    bean13548
    (new
     com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
     arg13551)]
   bean13548))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
get-bucket-location-request
  [m13553]
  (clojure.core/let
   [arg13555
    nil
    bean13552
    (new
     com.amazonaws.services.s3.model.GetBucketLocationRequest
     arg13555)]
   (clojure.core/let
    [v13554
     (:bucket-name m13553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13554 :com.palletops.awaze.client-builder/undef)
     (. bean13552 setBucketName (clojure.core/str v13554))))
   bean13552))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.GetObjectAclRequest}
get-object-acl-request
  [m13557]
  (clojure.core/let
   [arg13559
    nil
    arg13560
    nil
    bean13556
    (new
     com.amazonaws.services.s3.model.GetObjectAclRequest
     arg13559
     arg13560)]
   (clojure.core/let
    [v13558
     (:version-id m13557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setVersionId (clojure.core/str v13558))))
   (clojure.core/let
    [v13558
     (:requester-pays
      m13557
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setRequesterPays (clojure.core/boolean v13558))))
   (clojure.core/let
    [v13558
     (:bucket-name m13557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setBucketName (clojure.core/str v13558))))
   (clojure.core/let
    [v13558 (:key m13557 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13558 :com.palletops.awaze.client-builder/undef)
     (. bean13556 setKey (clojure.core/str v13558))))
   bean13556))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.UploadPartRequest}
upload-part-request
  [m13562]
  (clojure.core/let
   [bean13561 (new com.amazonaws.services.s3.model.UploadPartRequest)]
   (clojure.core/let
    [v13563
     (:file-offset m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setFileOffset (clojure.core/long v13563))))
   (clojure.core/let
    [v13563
     (:progress-listener
      m13562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setProgressListener v13563)))
   (clojure.core/let
    [v13563
     (:bucket-name m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setBucketName (clojure.core/str v13563))))
   (clojure.core/let
    [v13563
     (:ssecustomer-key
      m13562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setSSECustomerKey (s3/ssecustomer-key v13563))))
   (clojure.core/let
    [v13563
     (:input-stream m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (.
      bean13561
      setInputStream
      (clojure.java.io/input-stream v13563))))
   (clojure.core/let
    [v13563
     (:md5digest m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setMd5Digest (clojure.core/str v13563))))
   (clojure.core/let
    [v13563
     (:part-size m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setPartSize (clojure.core/long v13563))))
   (clojure.core/let
    [v13563
     (:requester-pays
      m13562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setRequesterPays (clojure.core/boolean v13563))))
   (clojure.core/let
    [v13563
     (:object-metadata
      m13562
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setObjectMetadata (s3/object-metadata v13563))))
   (clojure.core/let
    [v13563 (:key m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setKey (clojure.core/str v13563))))
   (clojure.core/let
    [v13563
     (:part-number m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setPartNumber (clojure.core/int v13563))))
   (clojure.core/let
    [v13563 (:file m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setFile (clojure.java.io/file v13563))))
   (clojure.core/let
    [v13563
     (:last-part m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setLastPart (clojure.core/boolean v13563))))
   (clojure.core/let
    [v13563
     (:upload-id m13562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13563 :com.palletops.awaze.client-builder/undef)
     (. bean13561 setUploadId (clojure.core/str v13563))))
   bean13561))
 (clojure.core/defn
^{:tag com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest}
set-bucket-website-configuration-request
  [m13565]
  (clojure.core/let
   [arg13567
    nil
    arg13568
    (bucket-website-configuration {})
    bean13564
    (new
     com.amazonaws.services.s3.model.SetBucketWebsiteConfigurationRequest
     arg13567
     arg13568)]
   (clojure.core/let
    [v13566
     (:configuration m13565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13566 :com.palletops.awaze.client-builder/undef)
     (.
      bean13564
      setConfiguration
      (s3/bucket-website-configuration v13566))))
   (clojure.core/let
    [v13566
     (:bucket-name m13565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v13566 :com.palletops.awaze.client-builder/undef)
     (. bean13564 setBucketName (clojure.core/str v13566))))
   bean13564))
 (clojure.core/defmulti
  s3
  (clojure.core/fn s3 [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-website-configuration
   [m13594]
   (clojure.core/let
    [credentials13595 (:credentials m13594) args13596 (:args m13594)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13597
      (com.palletops.awaze.common/aws-client :s3 credentials13595)]
     (clojure.core/case
      (clojure.core/count args13596)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13596 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13597
           deleteBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
               (clojure.core/nth args13596 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13597
               deleteBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketWebsiteConfiguration")
                {:args args13596}))))))))))))))
  (clojure.core/defn
   delete-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketWebsiteConfiguration, deleteBucketWebsiteConfiguration"}
   [credentials13600 & args13601]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13603
     (com.palletops.awaze.common/aws-client :s3 credentials13600)]
    (clojure.core/case
     (clojure.core/count args13601)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13601 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13603
          deleteBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketWebsiteConfigurationRequest
              (clojure.core/nth args13601 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13603
              deleteBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketWebsiteConfiguration")
               {:args args13601}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-acl
   [m13604]
   (clojure.core/let
    [credentials13605 (:credentials m13604) args13606 (:args m13604)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13607
      (com.palletops.awaze.common/aws-client :s3 credentials13605)]
     (clojure.core/case
      (clojure.core/count args13606)
      5
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13606 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13606 4))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
           setObjectAcl
           a
           b
           c
           d
           e)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13606 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13606 4))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
               setObjectAcl
               a
               b
               c
               d
               e)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13606}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
        setObjectAcl
        (s3/set-object-acl-request (clojure.core/nth args13606 0))))
      4
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 1))
^{:tag java.lang.String}
c
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13606 3))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
           setObjectAcl
           a
           b
           c
           d)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 1))
^{:tag java.lang.String}
c
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13606 3))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
               setObjectAcl
               a
               b
               c
               d)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13606}))))))))))
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13606 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13606 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
           setObjectAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13606 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13606 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13607
               setObjectAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setObjectAcl")
                {:args args13606}))))))))))))))
  (clojure.core/defn
   set-object-acl-map
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Generate map for setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e]
    {:args [a b c d e],
     :fn :set-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-acl
   {:arglists (quote
               [[credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-4]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3
                 request-metric-collector-4]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 string-2
                 canned-access-control-list-3]
                [credentials
                 string-0
                 string-1
                 string-2
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 string-1
                 canned-access-control-list-2]
                [credentials
                 string-0
                 string-1
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]]),
    :doc "Call setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl, setObjectAcl"}
   [credentials13615 & args13616]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13623
     (com.palletops.awaze.common/aws-client :s3 credentials13615)]
    (clojure.core/case
     (clojure.core/count args13616)
     5
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13616 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13616 4))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
          setObjectAcl
          a
          b
          c
          d
          e)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13616 3))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
e
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13616 4))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
              setObjectAcl
              a
              b
              c
              d
              e)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13616}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
       setObjectAcl
       (s3/set-object-acl-request (clojure.core/nth args13616 0))))
     4
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 1))
^{:tag java.lang.String}
c
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 2))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
d
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13616 3))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
          setObjectAcl
          a
          b
          c
          d)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 1))
^{:tag java.lang.String}
c
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 2))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
d
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13616 3))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
              setObjectAcl
              a
              b
              c
              d)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13616}))))))))))
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13616 1))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13616 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
          setObjectAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13616 1))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13616 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13623
              setObjectAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setObjectAcl")
               {:args args13616}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-lifecycle-configuration
   [m13624]
   (clojure.core/let
    [credentials13625 (:credentials m13624) args13626 (:args m13624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13627
      (com.palletops.awaze.common/aws-client :s3 credentials13625)]
     (clojure.core/case
      (clojure.core/count args13626)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
           (clojure.core/nth args13626 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13627
           getBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13626 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13627
               getBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLifecycleConfiguration")
                {:args args13626}))))))))))))))
  (clojure.core/defn
   get-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketLifecycleConfiguration, getBucketLifecycleConfiguration"}
   [credentials13630 & args13631]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13633
     (com.palletops.awaze.common/aws-client :s3 credentials13630)]
    (clojure.core/case
     (clojure.core/count args13631)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLifecycleConfigurationRequest
          (clojure.core/nth args13631 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13633
          getBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13631 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13633
              getBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLifecycleConfiguration")
               {:args args13631}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-multipart-uploads
   [m13634]
   (clojure.core/let
    [credentials13635 (:credentials m13634) args13636 (:args m13634)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13637
      (com.palletops.awaze.common/aws-client :s3 credentials13635)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13637
       listMultipartUploads
       (s3/list-multipart-uploads-request
        (clojure.core/nth args13636 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         upload-id-marker
                         sdk-request-timeout
                         custom-query-parameters
                         max-uploads
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listMultipartUploads"}
   [credentials13640 & args13641]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13643
     (com.palletops.awaze.common/aws-client :s3 credentials13640)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13643
      listMultipartUploads
      (s3/list-multipart-uploads-request
       (clojure.core/nth args13641 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-metadata
   [m13644]
   (clojure.core/let
    [credentials13645 (:credentials m13644) args13646 (:args m13644)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13647
      (com.palletops.awaze.common/aws-client :s3 credentials13645)]
     (clojure.core/case
      (clojure.core/count args13646)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13647
        getObjectMetadata
        (clojure.core/str (clojure.core/nth args13646 0))
        (clojure.core/str (clojure.core/nth args13646 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13647
        getObjectMetadata
        (s3/get-object-metadata-request
         (clojure.core/nth args13646 0))))))))
  (clojure.core/defn
   get-object-metadata-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for getObjectMetadata, getObjectMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-metadata,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-metadata
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call getObjectMetadata, getObjectMetadata"}
   [credentials13651 & args13652]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13655
     (com.palletops.awaze.common/aws-client :s3 credentials13651)]
    (clojure.core/case
     (clojure.core/count args13652)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13655
       getObjectMetadata
       (clojure.core/str (clojure.core/nth args13652 0))
       (clojure.core/str (clojure.core/nth args13652 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13655
       getObjectMetadata
       (s3/get-object-metadata-request (clojure.core/nth args13652 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-cross-origin-configuration
   [m13656]
   (clojure.core/let
    [credentials13657 (:credentials m13656) args13658 (:args m13656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13659
      (com.palletops.awaze.common/aws-client :s3 credentials13657)]
     (clojure.core/case
      (clojure.core/count args13658)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13659
        setBucketCrossOriginConfiguration
        (s3/set-bucket-cross-origin-configuration-request
         (clojure.core/nth args13658 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13659
        setBucketCrossOriginConfiguration
        (clojure.core/str (clojure.core/nth args13658 0))
        (s3/bucket-cross-origin-configuration
         (clojure.core/nth args13658 1))))))))
  (clojure.core/defn
   set-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         cross-origin-configuration
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketCrossOriginConfiguration, setBucketCrossOriginConfiguration"}
   [credentials13663 & args13664]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13667
     (com.palletops.awaze.common/aws-client :s3 credentials13663)]
    (clojure.core/case
     (clojure.core/count args13664)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13667
       setBucketCrossOriginConfiguration
       (s3/set-bucket-cross-origin-configuration-request
        (clojure.core/nth args13664 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13667
       setBucketCrossOriginConfiguration
       (clojure.core/str (clojure.core/nth args13664 0))
       (s3/bucket-cross-origin-configuration
        (clojure.core/nth args13664 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-replication-configuration
   [m13668]
   (clojure.core/let
    [credentials13669 (:credentials m13668) args13670 (:args m13668)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13671
      (com.palletops.awaze.common/aws-client :s3 credentials13669)]
     (clojure.core/case
      (clojure.core/count args13670)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13670 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13671
           deleteBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
               (clojure.core/nth args13670 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13671
               deleteBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketReplicationConfiguration")
                {:args args13670}))))))))))))))
  (clojure.core/defn
   delete-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketReplicationConfiguration, deleteBucketReplicationConfiguration"}
   [credentials13674 & args13675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13677
     (com.palletops.awaze.common/aws-client :s3 credentials13674)]
    (clojure.core/case
     (clojure.core/count args13675)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13675 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
          deleteBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketReplicationConfigurationRequest
              (clojure.core/nth args13675 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13677
              deleteBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketReplicationConfiguration")
               {:args args13675}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-lifecycle-configuration
   [m13678]
   (clojure.core/let
    [credentials13679 (:credentials m13678) args13680 (:args m13678)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13681
      (com.palletops.awaze.common/aws-client :s3 credentials13679)]
     (clojure.core/case
      (clojure.core/count args13680)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13681
        setBucketLifecycleConfiguration
        (s3/set-bucket-lifecycle-configuration-request
         (clojure.core/nth args13680 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13681
        setBucketLifecycleConfiguration
        (clojure.core/str (clojure.core/nth args13680 0))
        (s3/bucket-lifecycle-configuration
         (clojure.core/nth args13680 1))))))))
  (clojure.core/defn
   set-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Generate map for setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         lifecycle-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 {:keys [rules]}]]),
    :doc "Call setBucketLifecycleConfiguration, setBucketLifecycleConfiguration"}
   [credentials13685 & args13686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13689
     (com.palletops.awaze.common/aws-client :s3 credentials13685)]
    (clojure.core/case
     (clojure.core/count args13686)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13689
       setBucketLifecycleConfiguration
       (s3/set-bucket-lifecycle-configuration-request
        (clojure.core/nth args13686 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13689
       setBucketLifecycleConfiguration
       (clojure.core/str (clojure.core/nth args13686 0))
       (s3/bucket-lifecycle-configuration
        (clojure.core/nth args13686 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-object-exist
   [m13690]
   (clojure.core/let
    [credentials13691 (:credentials m13690) args13692 (:args m13690)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13693
      (com.palletops.awaze.common/aws-client :s3 credentials13691)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13693
       doesObjectExist
       (clojure.core/str (clojure.core/nth args13692 0))
       (clojure.core/str (clojure.core/nth args13692 1)))))))
  (clojure.core/defn
   does-object-exist-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for doesObjectExist"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :does-object-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-object-exist
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call doesObjectExist"}
   [credentials13695 & args13696]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13697
     (com.palletops.awaze.common/aws-client :s3 credentials13695)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13697
      doesObjectExist
      (clojure.core/str (clojure.core/nth args13696 0))
      (clojure.core/str (clojure.core/nth args13696 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-notification-configuration
   [m13698]
   (clojure.core/let
    [credentials13699 (:credentials m13698) args13700 (:args m13698)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13701
      (com.palletops.awaze.common/aws-client :s3 credentials13699)]
     (clojure.core/case
      (clojure.core/count args13700)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13701
        setBucketNotificationConfiguration
        (s3/set-bucket-notification-configuration-request
         (clojure.core/nth args13700 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13701
        setBucketNotificationConfiguration
        (clojure.core/str (clojure.core/nth args13700 0))
        (s3/bucket-notification-configuration
         (clojure.core/nth args13700 1))))))))
  (clojure.core/defn
   set-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Generate map for setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         notification-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         bucket-notification-configuration
                         clone-root
                         bucket]}]
                [credentials
                 string-0
                 {:keys [configurations topic-configurations]}]]),
    :doc "Call setBucketNotificationConfiguration, setBucketNotificationConfiguration"}
   [credentials13707 & args13708]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13713
     (com.palletops.awaze.common/aws-client :s3 credentials13707)]
    (clojure.core/case
     (clojure.core/count args13708)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13713
       setBucketNotificationConfiguration
       (s3/set-bucket-notification-configuration-request
        (clojure.core/nth args13708 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13713
       setBucketNotificationConfiguration
       (clojure.core/str (clojure.core/nth args13708 0))
       (s3/bucket-notification-configuration
        (clojure.core/nth args13708 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-object-redirect-location
   [m13714]
   (clojure.core/let
    [credentials13715 (:credentials m13714) args13716 (:args m13714)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13717
      (com.palletops.awaze.common/aws-client :s3 credentials13715)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13717
       setObjectRedirectLocation
       (clojure.core/str (clojure.core/nth args13716 0))
       (clojure.core/str (clojure.core/nth args13716 1))
       (clojure.core/str (clojure.core/nth args13716 2)))))))
  (clojure.core/defn
   set-object-redirect-location-map
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Generate map for setObjectRedirectLocation"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-object-redirect-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-object-redirect-location
   {:arglists (quote [[credentials string-0 string-1 string-2]]),
    :doc "Call setObjectRedirectLocation"}
   [credentials13719 & args13720]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13721
     (com.palletops.awaze.common/aws-client :s3 credentials13719)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13721
      setObjectRedirectLocation
      (clojure.core/str (clojure.core/nth args13720 0))
      (clojure.core/str (clojure.core/nth args13720 1))
      (clojure.core/str (clojure.core/nth args13720 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-url
   [m13722]
   (clojure.core/let
    [credentials13723 (:credentials m13722) args13724 (:args m13722)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13725
      (com.palletops.awaze.common/aws-client :s3 credentials13723)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13725
       getUrl
       (clojure.core/str (clojure.core/nth args13724 0))
       (clojure.core/str (clojure.core/nth args13724 1)))))))
  (clojure.core/defn
   get-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getUrl"}
   [credentials13727 & args13728]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13729
     (com.palletops.awaze.common/aws-client :s3 credentials13727)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13729
      getUrl
      (clojure.core/str (clojure.core/nth args13728 0))
      (clojure.core/str (clojure.core/nth args13728 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-policy
   [m13730]
   (clojure.core/let
    [credentials13731 (:credentials m13730) args13732 (:args m13730)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13733
      (com.palletops.awaze.common/aws-client :s3 credentials13731)]
     (clojure.core/case
      (clojure.core/count args13732)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13732 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13733
           deleteBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
               (clojure.core/nth args13732 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13733
               deleteBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketPolicy")
                {:args args13732}))))))))))))))
  (clojure.core/defn
   delete-bucket-policy-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucketPolicy, deleteBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-policy
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucketPolicy, deleteBucketPolicy"}
   [credentials13736 & args13737]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13739
     (com.palletops.awaze.common/aws-client :s3 credentials13736)]
    (clojure.core/case
     (clojure.core/count args13737)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13737 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13739
          deleteBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketPolicyRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketPolicyRequest
              (clojure.core/nth args13737 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13739
              deleteBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketPolicy")
               {:args args13737}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :disable-requester-pays
   [m13740]
   (clojure.core/let
    [credentials13741 (:credentials m13740) args13742 (:args m13740)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13743
      (com.palletops.awaze.common/aws-client :s3 credentials13741)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13743
       disableRequesterPays
       (clojure.core/str (clojure.core/nth args13742 0)))))))
  (clojure.core/defn
   disable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for disableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   disable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call disableRequesterPays"}
   [credentials13745 & args13746]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13747
     (com.palletops.awaze.common/aws-client :s3 credentials13745)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13747
      disableRequesterPays
      (clojure.core/str (clojure.core/nth args13746 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :head-bucket
   [m13748]
   (clojure.core/let
    [credentials13749 (:credentials m13748) args13750 (:args m13748)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13751
      (com.palletops.awaze.common/aws-client :s3 credentials13749)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13751
       headBucket
       (s3/head-bucket-request (clojure.core/nth args13750 0)))))))
  (clojure.core/defn
   head-bucket-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for headBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :head-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   head-bucket
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call headBucket"}
   [credentials13754 & args13755]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13757
     (com.palletops.awaze.common/aws-client :s3 credentials13754)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13757
      headBucket
      (s3/head-bucket-request (clojure.core/nth args13755 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-s3client-options
   [m13758]
   (clojure.core/let
    [credentials13759 (:credentials m13758) args13760 (:args m13758)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13761
      (com.palletops.awaze.common/aws-client :s3 credentials13759)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13761
       setS3ClientOptions
       (s3/s3client-options (clojure.core/nth args13760 0)))))))
  (clojure.core/defn
   set-s3client-options-map
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Generate map for setS3ClientOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-s3client-options,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-s3client-options
   {:arglists (quote
               [[credentials
                 {:keys [chunked-encoding-disabled path-style-access]}]]),
    :doc "Call setS3ClientOptions"}
   [credentials13763 & args13764]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13765
     (com.palletops.awaze.common/aws-client :s3 credentials13763)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13765
      setS3ClientOptions
      (s3/s3client-options (clojure.core/nth args13764 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-notification-configuration
   [m13766]
   (clojure.core/let
    [credentials13767 (:credentials m13766) args13768 (:args m13766)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13769
      (com.palletops.awaze.common/aws-client :s3 credentials13767)]
     (clojure.core/case
      (clojure.core/count args13768)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
           (clojure.core/nth args13768 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13769
           getBucketNotificationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13768 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13769
               getBucketNotificationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketNotificationConfiguration")
                {:args args13768}))))))))))))))
  (clojure.core/defn
   get-bucket-notification-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-notification-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-notification-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketNotificationConfiguration, getBucketNotificationConfiguration"}
   [credentials13772 & args13773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13775
     (com.palletops.awaze.common/aws-client :s3 credentials13772)]
    (clojure.core/case
     (clojure.core/count args13773)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketNotificationConfigurationRequest
          (clojure.core/nth args13773 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13775
          getBucketNotificationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13773 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13775
              getBucketNotificationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketNotificationConfiguration")
               {:args args13773}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-lifecycle-configuration
   [m13776]
   (clojure.core/let
    [credentials13777 (:credentials m13776) args13778 (:args m13776)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13779
      (com.palletops.awaze.common/aws-client :s3 credentials13777)]
     (clojure.core/case
      (clojure.core/count args13778)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
           (clojure.core/nth args13778 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13779
           deleteBucketLifecycleConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13778 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13779
               deleteBucketLifecycleConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketLifecycleConfiguration")
                {:args args13778}))))))))))))))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-lifecycle-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-lifecycle-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketLifecycleConfiguration, deleteBucketLifecycleConfiguration"}
   [credentials13782 & args13783]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13785
     (com.palletops.awaze.common/aws-client :s3 credentials13782)]
    (clojure.core/case
     (clojure.core/count args13783)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketLifecycleConfigurationRequest
          (clojure.core/nth args13783 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13785
          deleteBucketLifecycleConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13783 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13785
              deleteBucketLifecycleConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketLifecycleConfiguration")
               {:args args13783}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-objects
   [m13786]
   (clojure.core/let
    [credentials13787 (:credentials m13786) args13788 (:args m13786)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13789
      (com.palletops.awaze.common/aws-client :s3 credentials13787)]
     (clojure.core/case
      (clojure.core/count args13788)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ListObjectsRequest
           (clojure.core/nth args13788 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13789
           listObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13788 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13789
               listObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listObjects")
                {:args args13788}))))))))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13789
        listObjects
        (clojure.core/str (clojure.core/nth args13788 0))
        (clojure.core/str (clojure.core/nth args13788 1))))))))
  (clojure.core/defn
   list-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Generate map for listObjects, listObjects, listObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         marker
                         max-keys
                         custom-query-parameters
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]
                [credentials string-0]]),
    :doc "Call listObjects, listObjects, listObjects"}
   [credentials13791 & args13792]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13793
     (com.palletops.awaze.common/aws-client :s3 credentials13791)]
    (clojure.core/case
     (clojure.core/count args13792)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ListObjectsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ListObjectsRequest
          (clojure.core/nth args13792 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13793
          listObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13792 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13793
              listObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listObjects")
               {:args args13792}))))))))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13793
       listObjects
       (clojure.core/str (clojure.core/nth args13792 0))
       (clojure.core/str (clojure.core/nth args13792 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-resource-url
   [m13794]
   (clojure.core/let
    [credentials13795 (:credentials m13794) args13796 (:args m13794)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13797
      (com.palletops.awaze.common/aws-client :s3 credentials13795)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13797
       getResourceUrl
       (clojure.core/str (clojure.core/nth args13796 0))
       (clojure.core/str (clojure.core/nth args13796 1)))))))
  (clojure.core/defn
   get-resource-url-map
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Generate map for getResourceUrl"}
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-resource-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-resource-url
   {:arglists (quote [[credentials string-0 string-1]]),
    :doc "Call getResourceUrl"}
   [credentials13799 & args13800]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13801
     (com.palletops.awaze.common/aws-client :s3 credentials13799)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13801
      getResourceUrl
      (clojure.core/str (clojure.core/nth args13800 0))
      (clojure.core/str (clojure.core/nth args13800 1)))))))
 (do
  (clojure.core/defmethod
   s3
   :enable-requester-pays
   [m13802]
   (clojure.core/let
    [credentials13803 (:credentials m13802) args13804 (:args m13802)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13805
      (com.palletops.awaze.common/aws-client :s3 credentials13803)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13805
       enableRequesterPays
       (clojure.core/str (clojure.core/nth args13804 0)))))))
  (clojure.core/defn
   enable-requester-pays-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for enableRequesterPays"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-requester-pays,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   enable-requester-pays
   {:arglists (quote [[credentials string-0]]),
    :doc "Call enableRequesterPays"}
   [credentials13807 & args13808]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13809
     (com.palletops.awaze.common/aws-client :s3 credentials13807)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13809
      enableRequesterPays
      (clojure.core/str (clojure.core/nth args13808 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :abort-multipart-upload
   [m13810]
   (clojure.core/let
    [credentials13811 (:credentials m13810) args13812 (:args m13810)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13813
      (com.palletops.awaze.common/aws-client :s3 credentials13811)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13813
       abortMultipartUpload
       (s3/abort-multipart-upload-request
        (clojure.core/nth args13812 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials13818 & args13819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13823
     (com.palletops.awaze.common/aws-client :s3 credentials13818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13823
      abortMultipartUpload
      (s3/abort-multipart-upload-request
       (clojure.core/nth args13819 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-s3account-owner
   [m13824]
   (clojure.core/let
    [credentials13825 (:credentials m13824) args13826 (:args m13824)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13827
      (com.palletops.awaze.common/aws-client :s3 credentials13825)]
     (clojure.core/case
      (clojure.core/count args13826)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13827
        getS3AccountOwner))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13827
        getS3AccountOwner
        (s3/get-s3account-owner-request
         (clojure.core/nth args13826 0))))))))
  (clojure.core/defn
   get-s3account-owner-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getS3AccountOwner, getS3AccountOwner"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-s3account-owner,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-s3account-owner
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getS3AccountOwner, getS3AccountOwner"}
   [credentials13829 & args13830]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13831
     (com.palletops.awaze.common/aws-client :s3 credentials13829)]
    (clojure.core/case
     (clojure.core/count args13830)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13831
       getS3AccountOwner))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13831
       getS3AccountOwner
       (s3/get-s3account-owner-request (clojure.core/nth args13830 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-buckets
   [m13832]
   (clojure.core/let
    [credentials13833 (:credentials m13832) args13834 (:args m13832)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13835
      (com.palletops.awaze.common/aws-client :s3 credentials13833)]
     (clojure.core/case
      (clojure.core/count args13834)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13835
        listBuckets
        (s3/list-buckets-request (clojure.core/nth args13834 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13835
        listBuckets))))))
  (clojure.core/defn
   list-buckets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listBuckets, listBuckets"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-buckets,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-buckets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listBuckets, listBuckets"}
   [credentials13837 & args13838]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13839
     (com.palletops.awaze.common/aws-client :s3 credentials13837)]
    (clojure.core/case
     (clojure.core/count args13838)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13839
       listBuckets
       (s3/list-buckets-request (clojure.core/nth args13838 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13839
       listBuckets))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-website-configuration
   [m13840]
   (clojure.core/let
    [credentials13841 (:credentials m13840) args13842 (:args m13840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13843
      (com.palletops.awaze.common/aws-client :s3 credentials13841)]
     (clojure.core/case
      (clojure.core/count args13842)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13842 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13843
           getBucketWebsiteConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
               (clojure.core/nth args13842 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13843
               getBucketWebsiteConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketWebsiteConfiguration")
                {:args args13842}))))))))))))))
  (clojure.core/defn
   get-bucket-website-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-website-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketWebsiteConfiguration, getBucketWebsiteConfiguration"}
   [credentials13846 & args13847]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13849
     (com.palletops.awaze.common/aws-client :s3 credentials13846)]
    (clojure.core/case
     (clojure.core/count args13847)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13847 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13849
          getBucketWebsiteConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketWebsiteConfigurationRequest
              (clojure.core/nth args13847 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13849
              getBucketWebsiteConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketWebsiteConfiguration")
               {:args args13847}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-parts
   [m13850]
   (clojure.core/let
    [credentials13851 (:credentials m13850) args13852 (:args m13850)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13853
      (com.palletops.awaze.common/aws-client :s3 credentials13851)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13853
       listParts
       (s3/list-parts-request (clojure.core/nth args13852 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         part-number-marker
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         max-parts
                         clone-root
                         requester-pays]}]]),
    :doc "Call listParts"}
   [credentials13858 & args13859]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13863
     (com.palletops.awaze.common/aws-client :s3 credentials13858)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13863
      listParts
      (s3/list-parts-request (clojure.core/nth args13859 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-acl
   [m13864]
   (clojure.core/let
    [credentials13865 (:credentials m13864) args13866 (:args m13864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13867
      (com.palletops.awaze.common/aws-client :s3 credentials13865)]
     (clojure.core/case
      (clojure.core/count args13866)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13867
        setBucketAcl
        (s3/set-bucket-acl-request (clojure.core/nth args13866 0))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13866 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.CannedAccessControlList
           (clojure.core/nth args13866 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13867
           setBucketAcl
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13866 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.AccessControlList
               (clojure.core/nth args13866 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13867
               setBucketAcl
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13866}))))))))))
      3
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13866 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.AccessControlList
           (clojure.core/nth args13866 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.metrics.RequestMetricCollector
           (clojure.core/nth args13866 2))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13867
           setBucketAcl
           a
           b
           c)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13866 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CannedAccessControlList
               (clojure.core/nth args13866 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.metrics.RequestMetricCollector
               (clojure.core/nth args13866 2))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13867
               setBucketAcl
               a
               b
               c)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "setBucketAcl")
                {:args args13866}))))))))))))))
  (clojure.core/defn
   set-bucket-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0 canned-access-control-list-1]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]]),
    :doc "Generate map for setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         acl
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]
                [credentials string-0 canned-access-control-list-1]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}]
                [credentials
                 string-0
                 {:keys [grants
                         grants-as-list
                         owner
                         requester-charged]}
                 request-metric-collector-2]
                [credentials
                 string-0
                 canned-access-control-list-1
                 request-metric-collector-2]]),
    :doc "Call setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl, setBucketAcl"}
   [credentials13873 & args13874]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13879
     (com.palletops.awaze.common/aws-client :s3 credentials13873)]
    (clojure.core/case
     (clojure.core/count args13874)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13879
       setBucketAcl
       (s3/set-bucket-acl-request (clojure.core/nth args13874 0))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13874 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.CannedAccessControlList
          (clojure.core/nth args13874 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13879
          setBucketAcl
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13874 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.AccessControlList
              (clojure.core/nth args13874 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13879
              setBucketAcl
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13874}))))))))))
     3
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13874 0))
^{:tag com.amazonaws.services.s3.model.AccessControlList}
b
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.AccessControlList
          (clojure.core/nth args13874 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.metrics.RequestMetricCollector
          (clojure.core/nth args13874 2))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13879
          setBucketAcl
          a
          b
          c)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13874 0))
^{:tag com.amazonaws.services.s3.model.CannedAccessControlList}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CannedAccessControlList
              (clojure.core/nth args13874 1))
^{:tag com.amazonaws.metrics.RequestMetricCollector}
c
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.metrics.RequestMetricCollector
              (clojure.core/nth args13874 2))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13879
              setBucketAcl
              a
              b
              c)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "setBucketAcl")
               {:args args13874}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-part
   [m13880]
   (clojure.core/let
    [credentials13881 (:credentials m13880) args13882 (:args m13880)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13883
      (com.palletops.awaze.common/aws-client :s3 credentials13881)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13883
       copyPart
       (s3/copy-part-request (clojure.core/nth args13882 0)))))))
  (clojure.core/defn
   copy-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Generate map for copyPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         unmodified-since-constraint
                         sdk-request-timeout
                         nonmatching-etag-constraints
                         upload-id
                         source-key
                         modified-since-constraint
                         first-byte
                         custom-query-parameters
                         destination-ssecustomer-key
                         read-limit
                         last-byte
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         part-number
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         source-ssecustomer-key
                         destination-key]}]]),
    :doc "Call copyPart"}
   [credentials13885 & args13886]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13887
     (com.palletops.awaze.common/aws-client :s3 credentials13885)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13887
      copyPart
      (s3/copy-part-request (clojure.core/nth args13886 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-replication-configuration
   [m13888]
   (clojure.core/let
    [credentials13889 (:credentials m13888) args13890 (:args m13888)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13891
      (com.palletops.awaze.common/aws-client :s3 credentials13889)]
     (clojure.core/case
      (clojure.core/count args13890)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
           (clojure.core/nth args13890 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13891
           getBucketReplicationConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13890 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13891
               getBucketReplicationConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketReplicationConfiguration")
                {:args args13890}))))))))))))))
  (clojure.core/defn
   get-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-replication-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketReplicationConfiguration, getBucketReplicationConfiguration"}
   [credentials13894 & args13895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13897
     (com.palletops.awaze.common/aws-client :s3 credentials13894)]
    (clojure.core/case
     (clojure.core/count args13895)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketReplicationConfigurationRequest
          (clojure.core/nth args13895 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13897
          getBucketReplicationConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13895 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13897
              getBucketReplicationConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketReplicationConfiguration")
               {:args args13895}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-versioning-configuration
   [m13898]
   (clojure.core/let
    [credentials13899 (:credentials m13898) args13900 (:args m13898)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13901
      (com.palletops.awaze.common/aws-client :s3 credentials13899)]
     (clojure.core/case
      (clojure.core/count args13900)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13900 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13901
           getBucketVersioningConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
               (clojure.core/nth args13900 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13901
               getBucketVersioningConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketVersioningConfiguration")
                {:args args13900}))))))))))))))
  (clojure.core/defn
   get-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-versioning-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call getBucketVersioningConfiguration, getBucketVersioningConfiguration"}
   [credentials13904 & args13905]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13907
     (com.palletops.awaze.common/aws-client :s3 credentials13904)]
    (clojure.core/case
     (clojure.core/count args13905)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13905 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13907
          getBucketVersioningConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketVersioningConfigurationRequest
              (clojure.core/nth args13905 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13907
              getBucketVersioningConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketVersioningConfiguration")
               {:args args13905}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-versions
   [m13908]
   (clojure.core/let
    [credentials13909 (:credentials m13908) args13910 (:args m13908)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13911
      (com.palletops.awaze.common/aws-client :s3 credentials13909)]
     (clojure.core/case
      (clojure.core/count args13910)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
           (clojure.core/nth args13910 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13911
           listNextBatchOfVersions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.VersionListing}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.VersionListing
               (clojure.core/nth args13910 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13911
               listNextBatchOfVersions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfVersions")
                {:args args13910}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]
                [credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]]),
    :doc "Generate map for listNextBatchOfVersions, listNextBatchOfVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         previous-version-listing
                         clone-source
                         clone-root]}]
                [credentials
                 {:keys [encoding-type
                         common-prefixes
                         max-keys
                         next-key-marker
                         version-id-marker
                         prefix
                         delimiter
                         version-summaries
                         truncated
                         bucket-name
                         next-version-id-marker
                         key-marker]}]]),
    :doc "Call listNextBatchOfVersions, listNextBatchOfVersions"}
   [credentials13914 & args13915]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13917
     (com.palletops.awaze.common/aws-client :s3 credentials13914)]
    (clojure.core/case
     (clojure.core/count args13915)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ListNextBatchOfVersionsRequest
          (clojure.core/nth args13915 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13917
          listNextBatchOfVersions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.VersionListing}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.VersionListing
              (clojure.core/nth args13915 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13917
              listNextBatchOfVersions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfVersions")
               {:args args13915}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-acl
   [m13918]
   (clojure.core/let
    [credentials13919 (:credentials m13918) args13920 (:args m13918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13921
      (com.palletops.awaze.common/aws-client :s3 credentials13919)]
     (clojure.core/case
      (clojure.core/count args13920)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13920 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
           getBucketAcl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketAclRequest
               (clojure.core/nth args13920 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13921
               getBucketAcl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketAcl")
                {:args args13920}))))))))))))))
  (clojure.core/defn
   get-bucket-acl-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketAcl, getBucketAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-acl
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketAcl, getBucketAcl"}
   [credentials13924 & args13925]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13927
     (com.palletops.awaze.common/aws-client :s3 credentials13924)]
    (clojure.core/case
     (clojure.core/count args13925)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13925 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13927
          getBucketAcl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketAclRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketAclRequest
              (clojure.core/nth args13925 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13927
              getBucketAcl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketAcl")
               {:args args13925}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-object
   [m13928]
   (clojure.core/let
    [credentials13929 (:credentials m13928) args13930 (:args m13928)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13931
      (com.palletops.awaze.common/aws-client :s3 credentials13929)]
     (clojure.core/case
      (clojure.core/count args13930)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13931
        deleteObject
        (s3/delete-object-request (clojure.core/nth args13930 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13931
        deleteObject
        (clojure.core/str (clojure.core/nth args13930 0))
        (clojure.core/str (clojure.core/nth args13930 1))))))))
  (clojure.core/defn
   delete-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for deleteObject, deleteObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1]]),
    :doc "Call deleteObject, deleteObject"}
   [credentials13935 & args13936]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13939
     (com.palletops.awaze.common/aws-client :s3 credentials13935)]
    (clojure.core/case
     (clojure.core/count args13936)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13939
       deleteObject
       (s3/delete-object-request (clojure.core/nth args13936 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13939
       deleteObject
       (clojure.core/str (clojure.core/nth args13936 0))
       (clojure.core/str (clojure.core/nth args13936 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-tagging-configuration
   [m13940]
   (clojure.core/let
    [credentials13941 (:credentials m13940) args13942 (:args m13940)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13943
      (com.palletops.awaze.common/aws-client :s3 credentials13941)]
     (clojure.core/case
      (clojure.core/count args13942)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args13942 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13943
           deleteBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
               (clojure.core/nth args13942 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13943
               deleteBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketTaggingConfiguration")
                {:args args13942}))))))))))))))
  (clojure.core/defn
   delete-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Generate map for deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]]),
    :doc "Call deleteBucketTaggingConfiguration, deleteBucketTaggingConfiguration"}
   [credentials13946 & args13947]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13949
     (com.palletops.awaze.common/aws-client :s3 credentials13946)]
    (clojure.core/case
     (clojure.core/count args13947)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args13947 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13949
          deleteBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketTaggingConfigurationRequest
              (clojure.core/nth args13947 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13949
              deleteBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketTaggingConfiguration")
               {:args args13947}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-logging-configuration
   [m13950]
   (clojure.core/let
    [credentials13951 (:credentials m13950) args13952 (:args m13950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13953
      (com.palletops.awaze.common/aws-client :s3 credentials13951)]
     (clojure.core/case
      (clojure.core/count args13952)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
           (clojure.core/nth args13952 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13953
           getBucketLoggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args13952 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13953
               getBucketLoggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLoggingConfiguration")
                {:args args13952}))))))))))))))
  (clojure.core/defn
   get-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketLoggingConfiguration, getBucketLoggingConfiguration"}
   [credentials13956 & args13957]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13959
     (com.palletops.awaze.common/aws-client :s3 credentials13956)]
    (clojure.core/case
     (clojure.core/count args13957)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketLoggingConfigurationRequest
          (clojure.core/nth args13957 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13959
          getBucketLoggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args13957 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13959
              getBucketLoggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLoggingConfiguration")
               {:args args13957}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :generate-presigned-url
   [m13960]
   (clojure.core/let
    [credentials13961 (:credentials m13960) args13962 (:args m13960)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13963
      (com.palletops.awaze.common/aws-client :s3 credentials13961)]
     (clojure.core/case
      (clojure.core/count args13962)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13963
        generatePresignedUrl
        (s3/generate-presigned-url-request
         (clojure.core/nth args13962 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13963
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13962 0))
        (clojure.core/str (clojure.core/nth args13962 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13962 2))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13963
        generatePresignedUrl
        (clojure.core/str (clojure.core/nth args13962 0))
        (clojure.core/str (clojure.core/nth args13962 1))
        (com.palletops.awaze.common/to-date
         (clojure.core/nth args13962 2))
        (root/http-method (clojure.core/nth args13962 3))))))))
  (clojure.core/defn
   generate-presigned-url-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2]
                [credentials string-0 string-1 date-2 http-method-3]]),
    :doc "Generate map for generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :generate-presigned-url,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   generate-presigned-url
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         kms-cmk-id
                         key
                         method
                         sdk-request-timeout
                         expiration
                         custom-query-parameters
                         ssealgorithm
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         content-type
                         bucket-name
                         content-md5
                         clone-source
                         clone-root
                         request-parameters
                         response-headers
                         zero-byte-content]}]
                [credentials string-0 string-1 date-2]
                [credentials string-0 string-1 date-2 http-method-3]]),
    :doc "Call generatePresignedUrl, generatePresignedUrl, generatePresignedUrl"}
   [credentials13967 & args13968]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13971
     (com.palletops.awaze.common/aws-client :s3 credentials13967)]
    (clojure.core/case
     (clojure.core/count args13968)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13971
       generatePresignedUrl
       (s3/generate-presigned-url-request
        (clojure.core/nth args13968 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13971
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13968 0))
       (clojure.core/str (clojure.core/nth args13968 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13968 2))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13971
       generatePresignedUrl
       (clojure.core/str (clojure.core/nth args13968 0))
       (clojure.core/str (clojure.core/nth args13968 1))
       (com.palletops.awaze.common/to-date
        (clojure.core/nth args13968 2))
       (root/http-method (clojure.core/nth args13968 3))))))))
 (do
  (clojure.core/defmethod
   s3
   :is-requester-pays-enabled
   [m13972]
   (clojure.core/let
    [credentials13973 (:credentials m13972) args13974 (:args m13972)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13975
      (com.palletops.awaze.common/aws-client :s3 credentials13973)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13975
       isRequesterPaysEnabled
       (clojure.core/str (clojure.core/nth args13974 0)))))))
  (clojure.core/defn
   is-requester-pays-enabled-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for isRequesterPaysEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :is-requester-pays-enabled,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   is-requester-pays-enabled
   {:arglists (quote [[credentials string-0]]),
    :doc "Call isRequesterPaysEnabled"}
   [credentials13977 & args13978]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13979
     (com.palletops.awaze.common/aws-client :s3 credentials13977)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13979
      isRequesterPaysEnabled
      (clojure.core/str (clojure.core/nth args13978 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :copy-object
   [m13980]
   (clojure.core/let
    [credentials13981 (:credentials m13980) args13982 (:args m13980)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13983
      (com.palletops.awaze.common/aws-client :s3 credentials13981)]
     (clojure.core/case
      (clojure.core/count args13982)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13983
        copyObject
        (clojure.core/str (clojure.core/nth args13982 0))
        (clojure.core/str (clojure.core/nth args13982 1))
        (clojure.core/str (clojure.core/nth args13982 2))
        (clojure.core/str (clojure.core/nth args13982 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13983
        copyObject
        (s3/copy-object-request (clojure.core/nth args13982 0))))))))
  (clojure.core/defn
   copy-object-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Generate map for copyObject, copyObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :copy-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   copy-object
   {:arglists (quote
               [[credentials string-0 string-1 string-2 string-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         storage-class
                         unmodified-since-constraint
                         sdk-request-timeout
                         sseaws-key-management-params
                         nonmatching-etag-constraints
                         access-control-list
                         source-key
                         modified-since-constraint
                         custom-query-parameters
                         destination-ssecustomer-key
                         redirect-location
                         read-limit
                         destination-bucket-name
                         general-progress-listener
                         source-version-id
                         clone-source
                         matching-etag-constraints
                         source-bucket-name
                         clone-root
                         canned-access-control-list
                         new-object-metadata
                         source-ssecustomer-key
                         destination-key
                         requester-pays]}]]),
    :doc "Call copyObject, copyObject"}
   [credentials13989 & args13990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client13995
     (com.palletops.awaze.common/aws-client :s3 credentials13989)]
    (clojure.core/case
     (clojure.core/count args13990)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13995
       copyObject
       (clojure.core/str (clojure.core/nth args13990 0))
       (clojure.core/str (clojure.core/nth args13990 1))
       (clojure.core/str (clojure.core/nth args13990 2))
       (clojure.core/str (clojure.core/nth args13990 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13995
       copyObject
       (s3/copy-object-request (clojure.core/nth args13990 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-objects
   [m13996]
   (clojure.core/let
    [credentials13997 (:credentials m13996) args13998 (:args m13996)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client13999
      (com.palletops.awaze.common/aws-client :s3 credentials13997)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client13999
       deleteObjects
       (s3/delete-objects-request (clojure.core/nth args13998 0)))))))
  (clojure.core/defn
   delete-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for deleteObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         quiet
                         sdk-request-timeout
                         custom-query-parameters
                         keys
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call deleteObjects"}
   [credentials14002 & args14003]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14005
     (com.palletops.awaze.common/aws-client :s3 credentials14002)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14005
      deleteObjects
      (s3/delete-objects-request (clojure.core/nth args14003 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-versioning-configuration
   [m14006]
   (clojure.core/let
    [credentials14007 (:credentials m14006) args14008 (:args m14006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14009
      (com.palletops.awaze.common/aws-client :s3 credentials14007)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14009
       setBucketVersioningConfiguration
       (s3/set-bucket-versioning-configuration-request
        (clojure.core/nth args14008 0)))))))
  (clojure.core/defn
   set-bucket-versioning-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketVersioningConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-versioning-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-versioning-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         versioning-configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketVersioningConfiguration"}
   [credentials14013 & args14014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14017
     (com.palletops.awaze.common/aws-client :s3 credentials14013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14017
      setBucketVersioningConfiguration
      (s3/set-bucket-versioning-configuration-request
       (clojure.core/nth args14014 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-logging-configuration
   [m14018]
   (clojure.core/let
    [credentials14019 (:credentials m14018) args14020 (:args m14018)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14021
      (com.palletops.awaze.common/aws-client :s3 credentials14019)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14021
       setBucketLoggingConfiguration
       (s3/set-bucket-logging-configuration-request
        (clojure.core/nth args14020 0)))))))
  (clojure.core/defn
   set-bucket-logging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketLoggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-logging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-logging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         logging-configuration
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketLoggingConfiguration"}
   [credentials14025 & args14026]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14029
     (com.palletops.awaze.common/aws-client :s3 credentials14025)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14029
      setBucketLoggingConfiguration
      (s3/set-bucket-logging-configuration-request
       (clojure.core/nth args14026 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object
   [m14030]
   (clojure.core/let
    [credentials14031 (:credentials m14030) args14032 (:args m14030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14033
      (com.palletops.awaze.common/aws-client :s3 credentials14031)]
     (clojure.core/case
      (clojure.core/count args14032)
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetObjectRequest
           (clojure.core/nth args14032 0))
^{:tag java.io.File}
b
          (com.palletops.awaze.common/coerce-value-form
           java.io.File
           (clojure.core/nth args14032 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14033
           getObject
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14032 0))
^{:tag java.lang.String}
b
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14032 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14033
               getObject
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getObject")
                {:args args14032}))))))))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14033
        getObject
        (s3/get-object-request (clojure.core/nth args14032 0))))))))
  (clojure.core/defn
   get-object-map
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Generate map for getObject, getObject, getObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object
   {:arglists (quote
               [[credentials {:keys []} file-1]
                [credentials string-0 string-1]
                [credentials {:keys []}]]),
    :doc "Call getObject, getObject, getObject"}
   [credentials14039 & args14040]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14045
     (com.palletops.awaze.common/aws-client :s3 credentials14039)]
    (clojure.core/case
     (clojure.core/count args14040)
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetObjectRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetObjectRequest
          (clojure.core/nth args14040 0))
^{:tag java.io.File}
b
         (com.palletops.awaze.common/coerce-value-form
          java.io.File
          (clojure.core/nth args14040 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14045
          getObject
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14040 0))
^{:tag java.lang.String}
b
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14040 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14045
              getObject
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getObject")
               {:args args14040}))))))))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14045
       getObject
       (s3/get-object-request (clojure.core/nth args14040 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket-cross-origin-configuration
   [m14046]
   (clojure.core/let
    [credentials14047 (:credentials m14046) args14048 (:args m14046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14049
      (com.palletops.awaze.common/aws-client :s3 credentials14047)]
     (clojure.core/case
      (clojure.core/count args14048)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
           (clojure.core/nth args14048 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14049
           deleteBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14048 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14049
               deleteBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucketCrossOriginConfiguration")
                {:args args14048}))))))))))))))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call deleteBucketCrossOriginConfiguration, deleteBucketCrossOriginConfiguration"}
   [credentials14052 & args14053]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14055
     (com.palletops.awaze.common/aws-client :s3 credentials14052)]
    (clojure.core/case
     (clojure.core/count args14053)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.DeleteBucketCrossOriginConfigurationRequest
          (clojure.core/nth args14053 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14055
          deleteBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14053 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14055
              deleteBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucketCrossOriginConfiguration")
               {:args args14053}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :complete-multipart-upload
   [m14056]
   (clojure.core/let
    [credentials14057 (:credentials m14056) args14058 (:args m14056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14059
      (com.palletops.awaze.common/aws-client :s3 credentials14057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14059
       completeMultipartUpload
       (s3/complete-multipart-upload-request
        (clojure.core/nth args14058 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         upload-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         part-etags
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials14061 & args14062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14063
     (com.palletops.awaze.common/aws-client :s3 credentials14061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14063
      completeMultipartUpload
      (s3/complete-multipart-upload-request
       (clojure.core/nth args14062 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :restore-object
   [m14064]
   (clojure.core/let
    [credentials14065 (:credentials m14064) args14066 (:args m14064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14067
      (com.palletops.awaze.common/aws-client :s3 credentials14065)]
     (clojure.core/case
      (clojure.core/count args14066)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14067
        restoreObject
        (s3/restore-object-request (clojure.core/nth args14066 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14067
        restoreObject
        (clojure.core/str (clojure.core/nth args14066 0))
        (clojure.core/str (clojure.core/nth args14066 1))
        (clojure.core/int (clojure.core/nth args14066 2))))))))
  (clojure.core/defn
   restore-object-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Generate map for restoreObject, restoreObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :restore-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   restore-object
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         expiration-in-days
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 int-2]]),
    :doc "Call restoreObject, restoreObject"}
   [credentials14071 & args14072]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14075
     (com.palletops.awaze.common/aws-client :s3 credentials14071)]
    (clojure.core/case
     (clojure.core/count args14072)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14075
       restoreObject
       (s3/restore-object-request (clojure.core/nth args14072 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14075
       restoreObject
       (clojure.core/str (clojure.core/nth args14072 0))
       (clojure.core/str (clojure.core/nth args14072 1))
       (clojure.core/int (clojure.core/nth args14072 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-policy
   [m14076]
   (clojure.core/let
    [credentials14077 (:credentials m14076) args14078 (:args m14076)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14079
      (com.palletops.awaze.common/aws-client :s3 credentials14077)]
     (clojure.core/case
      (clojure.core/count args14078)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketPolicyRequest
           (clojure.core/nth args14078 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14079
           getBucketPolicy
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14078 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14079
               getBucketPolicy
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketPolicy")
                {:args args14078}))))))))))))))
  (clojure.core/defn
   get-bucket-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketPolicy, getBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getBucketPolicy, getBucketPolicy"}
   [credentials14082 & args14083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14085
     (com.palletops.awaze.common/aws-client :s3 credentials14082)]
    (clojure.core/case
     (clojure.core/count args14083)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketPolicyRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketPolicyRequest
          (clojure.core/nth args14083 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14085
          getBucketPolicy
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14083 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14085
              getBucketPolicy
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketPolicy")
               {:args args14083}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-replication-configuration
   [m14086]
   (clojure.core/let
    [credentials14087 (:credentials m14086) args14088 (:args m14086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14089
      (com.palletops.awaze.common/aws-client :s3 credentials14087)]
     (clojure.core/case
      (clojure.core/count args14088)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14089
        setBucketReplicationConfiguration
        (clojure.core/str (clojure.core/nth args14088 0))
        (s3/bucket-replication-configuration
         (clojure.core/nth args14088 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14089
        setBucketReplicationConfiguration
        (s3/set-bucket-replication-configuration-request
         (clojure.core/nth args14088 0))))))))
  (clojure.core/defn
   set-bucket-replication-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys [role-arn rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-replication-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-replication-configuration
   {:arglists (quote
               [[credentials string-0 {:keys [role-arn rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         replication-configuration
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketReplicationConfiguration, setBucketReplicationConfiguration"}
   [credentials14091 & args14092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14093
     (com.palletops.awaze.common/aws-client :s3 credentials14091)]
    (clojure.core/case
     (clojure.core/count args14092)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14093
       setBucketReplicationConfiguration
       (clojure.core/str (clojure.core/nth args14092 0))
       (s3/bucket-replication-configuration
        (clojure.core/nth args14092 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14093
       setBucketReplicationConfiguration
       (s3/set-bucket-replication-configuration-request
        (clojure.core/nth args14092 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :create-bucket
   [m14094]
   (clojure.core/let
    [credentials14095 (:credentials m14094) args14096 (:args m14094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14097
      (com.palletops.awaze.common/aws-client :s3 credentials14095)]
     (clojure.core/case
      (clojure.core/count args14096)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14096 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14097
           createBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.CreateBucketRequest
               (clojure.core/nth args14096 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14097
               createBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14096}))))))))))
      2
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14096 0))
^{:tag java.lang.String}
b
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14096 1))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14097
           createBucket
           a
           b)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14096 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.Region
               (clojure.core/nth args14096 1))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14097
               createBucket
               a
               b)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createBucket")
                {:args args14096}))))))))))))))
  (clojure.core/defn
   create-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 string-1]
                [credentials string-0 region-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]]),
    :doc "Generate map for createBucket, createBucket, createBucket, createBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :create-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   create-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials string-0 string-1]
                [credentials string-0 region-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         access-control-list
                         custom-query-parameters
                         region
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         canned-acl]}]]),
    :doc "Call createBucket, createBucket, createBucket, createBucket"}
   [credentials14100 & args14101]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14103
     (com.palletops.awaze.common/aws-client :s3 credentials14100)]
    (clojure.core/case
     (clojure.core/count args14101)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14101 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14103
          createBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.CreateBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.CreateBucketRequest
              (clojure.core/nth args14101 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14103
              createBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14101}))))))))))
     2
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14101 0))
^{:tag java.lang.String}
b
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14101 1))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14103
          createBucket
          a
          b)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14101 0))
^{:tag com.amazonaws.services.s3.model.Region}
b
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.Region
              (clojure.core/nth args14101 1))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14103
              createBucket
              a
              b)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createBucket")
               {:args args14101}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-version
   [m14104]
   (clojure.core/let
    [credentials14105 (:credentials m14104) args14106 (:args m14104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14107
      (com.palletops.awaze.common/aws-client :s3 credentials14105)]
     (clojure.core/case
      (clojure.core/count args14106)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14107
        deleteVersion
        (s3/delete-version-request (clojure.core/nth args14106 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14107
        deleteVersion
        (clojure.core/str (clojure.core/nth args14106 0))
        (clojure.core/str (clojure.core/nth args14106 1))
        (clojure.core/str (clojure.core/nth args14106 2))))))))
  (clojure.core/defn
   delete-version-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for deleteVersion, deleteVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :delete-version,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-version
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         mfa
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call deleteVersion, deleteVersion"}
   [credentials14112 & args14113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14117
     (com.palletops.awaze.common/aws-client :s3 credentials14112)]
    (clojure.core/case
     (clojure.core/count args14113)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14117
       deleteVersion
       (s3/delete-version-request (clojure.core/nth args14113 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14117
       deleteVersion
       (clojure.core/str (clojure.core/nth args14113 0))
       (clojure.core/str (clojure.core/nth args14113 1))
       (clojure.core/str (clojure.core/nth args14113 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :put-object
   [m14118]
   (clojure.core/let
    [credentials14119 (:credentials m14118) args14120 (:args m14118)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14121
      (com.palletops.awaze.common/aws-client :s3 credentials14119)]
     (clojure.core/case
      (clojure.core/count args14120)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14121
        putObject
        (s3/put-object-request (clojure.core/nth args14120 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14121
        putObject
        (clojure.core/str (clojure.core/nth args14120 0))
        (clojure.core/str (clojure.core/nth args14120 1))
        (clojure.java.io/input-stream (clojure.core/nth args14120 2))
        (s3/object-metadata (clojure.core/nth args14120 3))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14121
        putObject
        (clojure.core/str (clojure.core/nth args14120 0))
        (clojure.core/str (clojure.core/nth args14120 1))
        (clojure.java.io/file (clojure.core/nth args14120 2))))))))
  (clojure.core/defn
   put-object-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Generate map for putObject, putObject, putObject"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :put-object,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   put-object
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         file
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         metadata
                         clone-root
                         requester-pays
                         canned-acl]}]
                [credentials
                 string-0
                 string-1
                 input-stream-2
                 {:keys [raw-metadata
                         sseaws-kms-key-id
                         content-disposition
                         expiration-time-rule-id
                         user-metadata
                         storage-class
                         instance-length
                         ssecustomer-key-md5
                         ssecustomer-algorithm
                         version-id
                         server-side-encryption
                         requester-charged
                         etag
                         last-modified
                         ssealgorithm
                         cache-control
                         http-expires-date
                         content-length
                         content-type
                         restore-expiration-time
                         content-encoding
                         expiration-time
                         content-md5
                         ongoing-restore]}]
                [credentials string-0 string-1 file-2]]),
    :doc "Call putObject, putObject, putObject"}
   [credentials14129 & args14130]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14137
     (com.palletops.awaze.common/aws-client :s3 credentials14129)]
    (clojure.core/case
     (clojure.core/count args14130)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14137
       putObject
       (s3/put-object-request (clojure.core/nth args14130 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14137
       putObject
       (clojure.core/str (clojure.core/nth args14130 0))
       (clojure.core/str (clojure.core/nth args14130 1))
       (clojure.java.io/input-stream (clojure.core/nth args14130 2))
       (s3/object-metadata (clojure.core/nth args14130 3))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14137
       putObject
       (clojure.core/str (clojure.core/nth args14130 0))
       (clojure.core/str (clojure.core/nth args14130 1))
       (clojure.java.io/file (clojure.core/nth args14130 2))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-versions
   [m14138]
   (clojure.core/let
    [credentials14139 (:credentials m14138) args14140 (:args m14138)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14141
      (com.palletops.awaze.common/aws-client :s3 credentials14139)]
     (clojure.core/case
      (clojure.core/count args14140)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14141
        listVersions
        (clojure.core/str (clojure.core/nth args14140 0))
        (clojure.core/str (clojure.core/nth args14140 1))))
      6
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14141
        listVersions
        (clojure.core/str (clojure.core/nth args14140 0))
        (clojure.core/str (clojure.core/nth args14140 1))
        (clojure.core/str (clojure.core/nth args14140 2))
        (clojure.core/str (clojure.core/nth args14140 3))
        (clojure.core/str (clojure.core/nth args14140 4))
        (clojure.core/int (clojure.core/nth args14140 5))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14141
        listVersions
        (s3/list-versions-request (clojure.core/nth args14140 0))))))))
  (clojure.core/defn
   list-versions-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Generate map for listVersions, listVersions, listVersions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c d e f]
    {:args [a b c d e f],
     :fn :list-versions,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-versions
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 string-0
                 string-1
                 string-2
                 string-3
                 string-4
                 integer-5]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoding-type
                         sdk-request-timeout
                         max-results
                         custom-query-parameters
                         version-id-marker
                         prefix
                         delimiter
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         key-marker]}]]),
    :doc "Call listVersions, listVersions, listVersions"}
   [credentials14143 & args14144]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14145
     (com.palletops.awaze.common/aws-client :s3 credentials14143)]
    (clojure.core/case
     (clojure.core/count args14144)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14145
       listVersions
       (clojure.core/str (clojure.core/nth args14144 0))
       (clojure.core/str (clojure.core/nth args14144 1))))
     6
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14145
       listVersions
       (clojure.core/str (clojure.core/nth args14144 0))
       (clojure.core/str (clojure.core/nth args14144 1))
       (clojure.core/str (clojure.core/nth args14144 2))
       (clojure.core/str (clojure.core/nth args14144 3))
       (clojure.core/str (clojure.core/nth args14144 4))
       (clojure.core/int (clojure.core/nth args14144 5))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14145
       listVersions
       (s3/list-versions-request (clojure.core/nth args14144 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-tagging-configuration
   [m14146]
   (clojure.core/let
    [credentials14147 (:credentials m14146) args14148 (:args m14146)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14149
      (com.palletops.awaze.common/aws-client :s3 credentials14147)]
     (clojure.core/case
      (clojure.core/count args14148)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14149
        setBucketTaggingConfiguration
        (clojure.core/str (clojure.core/nth args14148 0))
        (s3/bucket-tagging-configuration
         (clojure.core/nth args14148 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14149
        setBucketTaggingConfiguration
        (s3/set-bucket-tagging-configuration-request
         (clojure.core/nth args14148 0))))))))
  (clojure.core/defn
   set-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Generate map for setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-tagging-configuration
   {:arglists (quote
               [[credentials string-0 {:keys []}]
                [credentials {:keys []}]]),
    :doc "Call setBucketTaggingConfiguration, setBucketTaggingConfiguration"}
   [credentials14153 & args14154]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14157
     (com.palletops.awaze.common/aws-client :s3 credentials14153)]
    (clojure.core/case
     (clojure.core/count args14154)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14157
       setBucketTaggingConfiguration
       (clojure.core/str (clojure.core/nth args14154 0))
       (s3/bucket-tagging-configuration
        (clojure.core/nth args14154 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14157
       setBucketTaggingConfiguration
       (s3/set-bucket-tagging-configuration-request
        (clojure.core/nth args14154 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-cross-origin-configuration
   [m14158]
   (clojure.core/let
    [credentials14159 (:credentials m14158) args14160 (:args m14158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14161
      (com.palletops.awaze.common/aws-client :s3 credentials14159)]
     (clojure.core/case
      (clojure.core/count args14160)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
           (clojure.core/nth args14160 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14161
           getBucketCrossOriginConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14160 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14161
               getBucketCrossOriginConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketCrossOriginConfiguration")
                {:args args14160}))))))))))))))
  (clojure.core/defn
   get-bucket-cross-origin-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-cross-origin-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-cross-origin-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketCrossOriginConfiguration, getBucketCrossOriginConfiguration"}
   [credentials14164 & args14165]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14167
     (com.palletops.awaze.common/aws-client :s3 credentials14164)]
    (clojure.core/case
     (clojure.core/count args14165)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketCrossOriginConfigurationRequest
          (clojure.core/nth args14165 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14167
          getBucketCrossOriginConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14165 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14167
              getBucketCrossOriginConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketCrossOriginConfiguration")
               {:args args14165}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-policy
   [m14168]
   (clojure.core/let
    [credentials14169 (:credentials m14168) args14170 (:args m14168)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14171
      (com.palletops.awaze.common/aws-client :s3 credentials14169)]
     (clojure.core/case
      (clojure.core/count args14170)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14171
        setBucketPolicy
        (clojure.core/str (clojure.core/nth args14170 0))
        (clojure.core/str (clojure.core/nth args14170 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14171
        setBucketPolicy
        (s3/set-bucket-policy-request (clojure.core/nth args14170 0))))))))
  (clojure.core/defn
   set-bucket-policy-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketPolicy, setBucketPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-policy,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-policy
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-text
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketPolicy, setBucketPolicy"}
   [credentials14175 & args14176]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14179
     (com.palletops.awaze.common/aws-client :s3 credentials14175)]
    (clojure.core/case
     (clojure.core/count args14176)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14179
       setBucketPolicy
       (clojure.core/str (clojure.core/nth args14176 0))
       (clojure.core/str (clojure.core/nth args14176 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14179
       setBucketPolicy
       (s3/set-bucket-policy-request (clojure.core/nth args14176 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :list-next-batch-of-objects
   [m14180]
   (clojure.core/let
    [credentials14181 (:credentials m14180) args14182 (:args m14180)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14183
      (com.palletops.awaze.common/aws-client :s3 credentials14181)]
     (clojure.core/case
      (clojure.core/count args14182)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
           (clojure.core/nth args14182 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14183
           listNextBatchOfObjects
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.ObjectListing}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.ObjectListing
               (clojure.core/nth args14182 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14183
               listNextBatchOfObjects
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listNextBatchOfObjects")
                {:args args14182}))))))))))))))
  (clojure.core/defn
   list-next-batch-of-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]]),
    :doc "Generate map for listNextBatchOfObjects, listNextBatchOfObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-next-batch-of-objects,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   list-next-batch-of-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         previous-object-listing
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials
                 {:keys [encoding-type
                         common-prefixes
                         marker
                         max-keys
                         object-summaries
                         prefix
                         delimiter
                         next-marker
                         truncated
                         bucket-name]}]]),
    :doc "Call listNextBatchOfObjects, listNextBatchOfObjects"}
   [credentials14186 & args14187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14189
     (com.palletops.awaze.common/aws-client :s3 credentials14186)]
    (clojure.core/case
     (clojure.core/count args14187)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest
          (clojure.core/nth args14187 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14189
          listNextBatchOfObjects
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.ObjectListing}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.ObjectListing
              (clojure.core/nth args14187 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14189
              listNextBatchOfObjects
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listNextBatchOfObjects")
               {:args args14187}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :change-object-storage-class
   [m14190]
   (clojure.core/let
    [credentials14191 (:credentials m14190) args14192 (:args m14190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14193
      (com.palletops.awaze.common/aws-client :s3 credentials14191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14193
       changeObjectStorageClass
       (clojure.core/str (clojure.core/nth args14192 0))
       (clojure.core/str (clojure.core/nth args14192 1))
       (s3/storage-class (clojure.core/nth args14192 2)))))))
  (clojure.core/defn
   change-object-storage-class-map
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Generate map for changeObjectStorageClass"}
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-object-storage-class,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   change-object-storage-class
   {:arglists (quote
               [[credentials string-0 string-1 storage-class-2]]),
    :doc "Call changeObjectStorageClass"}
   [credentials14195 & args14196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14197
     (com.palletops.awaze.common/aws-client :s3 credentials14195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14197
      changeObjectStorageClass
      (clojure.core/str (clojure.core/nth args14196 0))
      (clojure.core/str (clojure.core/nth args14196 1))
      (s3/storage-class (clojure.core/nth args14196 2)))))))
 (do
  (clojure.core/defmethod
   s3
   :initiate-multipart-upload
   [m14198]
   (clojure.core/let
    [credentials14199 (:credentials m14198) args14200 (:args m14198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14201
      (com.palletops.awaze.common/aws-client :s3 credentials14199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14201
       initiateMultipartUpload
       (s3/initiate-multipart-upload-request
        (clojure.core/nth args14200 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         storage-class
                         sdk-request-timeout
                         sseaws-key-management-params
                         access-control-list
                         object-metadata
                         custom-query-parameters
                         redirect-location
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays
                         canned-acl]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials14205 & args14206]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14209
     (com.palletops.awaze.common/aws-client :s3 credentials14205)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14209
      initiateMultipartUpload
      (s3/initiate-multipart-upload-request
       (clojure.core/nth args14206 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-region
   [m14210]
   (clojure.core/let
    [credentials14211 (:credentials m14210) args14212 (:args m14210)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14213
      (com.palletops.awaze.common/aws-client :s3 credentials14211)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14213
       setRegion
       (regions/region (clojure.core/nth args14212 0)))))))
  (clojure.core/defn
   set-region-map
   {:arglists (quote [[credentials region-0]]),
    :doc "Generate map for setRegion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-region
   {:arglists (quote [[credentials region-0]]), :doc "Call setRegion"}
   [credentials14215 & args14216]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14217
     (com.palletops.awaze.common/aws-client :s3 credentials14215)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14217
      setRegion
      (regions/region (clojure.core/nth args14216 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :delete-bucket
   [m14218]
   (clojure.core/let
    [credentials14219 (:credentials m14218) args14220 (:args m14218)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14221
      (com.palletops.awaze.common/aws-client :s3 credentials14219)]
     (clojure.core/case
      (clojure.core/count args14220)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14220 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14221
           deleteBucket
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.DeleteBucketRequest
               (clojure.core/nth args14220 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14221
               deleteBucket
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteBucket")
                {:args args14220}))))))))))))))
  (clojure.core/defn
   delete-bucket-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteBucket, deleteBucket"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-bucket,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   delete-bucket
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteBucket, deleteBucket"}
   [credentials14224 & args14225]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14227
     (com.palletops.awaze.common/aws-client :s3 credentials14224)]
    (clojure.core/case
     (clojure.core/count args14225)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14225 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14227
          deleteBucket
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.DeleteBucketRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.DeleteBucketRequest
              (clojure.core/nth args14225 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14227
              deleteBucket
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteBucket")
               {:args args14225}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-tagging-configuration
   [m14228]
   (clojure.core/let
    [credentials14229 (:credentials m14228) args14230 (:args m14228)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14231
      (com.palletops.awaze.common/aws-client :s3 credentials14229)]
     (clojure.core/case
      (clojure.core/count args14230)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
           (clojure.core/nth args14230 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14231
           getBucketTaggingConfiguration
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args14230 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14231
               getBucketTaggingConfiguration
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketTaggingConfiguration")
                {:args args14230}))))))))))))))
  (clojure.core/defn
   get-bucket-tagging-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Generate map for getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-tagging-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-tagging-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         bucket]}]
                [credentials string-0]]),
    :doc "Call getBucketTaggingConfiguration, getBucketTaggingConfiguration"}
   [credentials14234 & args14235]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14237
     (com.palletops.awaze.common/aws-client :s3 credentials14234)]
    (clojure.core/case
     (clojure.core/count args14235)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.s3.model.GetBucketTaggingConfigurationRequest
          (clojure.core/nth args14235 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14237
          getBucketTaggingConfiguration
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args14235 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14237
              getBucketTaggingConfiguration
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketTaggingConfiguration")
               {:args args14235}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-bucket-location
   [m14238]
   (clojure.core/let
    [credentials14239 (:credentials m14238) args14240 (:args m14238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14241
      (com.palletops.awaze.common/aws-client :s3 credentials14239)]
     (clojure.core/case
      (clojure.core/count args14240)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args14240 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14241
           getBucketLocation
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.s3.model.GetBucketLocationRequest
               (clojure.core/nth args14240 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14241
               getBucketLocation
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getBucketLocation")
                {:args args14240}))))))))))))))
  (clojure.core/defn
   get-bucket-location-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getBucketLocation, getBucketLocation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-bucket-location,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-bucket-location
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call getBucketLocation, getBucketLocation"}
   [credentials14244 & args14245]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14247
     (com.palletops.awaze.common/aws-client :s3 credentials14244)]
    (clojure.core/case
     (clojure.core/count args14245)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args14245 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14247
          getBucketLocation
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.s3.model.GetBucketLocationRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.s3.model.GetBucketLocationRequest
              (clojure.core/nth args14245 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14247
              getBucketLocation
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getBucketLocation")
               {:args args14245}))))))))))))))
 (do
  (clojure.core/defmethod
   s3
   :does-bucket-exist
   [m14248]
   (clojure.core/let
    [credentials14249 (:credentials m14248) args14250 (:args m14248)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14251
      (com.palletops.awaze.common/aws-client :s3 credentials14249)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14251
       doesBucketExist
       (clojure.core/str (clojure.core/nth args14250 0)))))))
  (clojure.core/defn
   does-bucket-exist-map
   {:arglists (quote [[credentials string-0]]),
    :doc "Generate map for doesBucketExist"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :does-bucket-exist,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   does-bucket-exist
   {:arglists (quote [[credentials string-0]]),
    :doc "Call doesBucketExist"}
   [credentials14253 & args14254]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14255
     (com.palletops.awaze.common/aws-client :s3 credentials14253)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14255
      doesBucketExist
      (clojure.core/str (clojure.core/nth args14254 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :get-object-acl
   [m14256]
   (clojure.core/let
    [credentials14257 (:credentials m14256) args14258 (:args m14256)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14259
      (com.palletops.awaze.common/aws-client :s3 credentials14257)]
     (clojure.core/case
      (clojure.core/count args14258)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14259
        getObjectAcl
        (s3/get-object-acl-request (clojure.core/nth args14258 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14259
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14258 0))
        (clojure.core/str (clojure.core/nth args14258 1))
        (clojure.core/str (clojure.core/nth args14258 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14259
        getObjectAcl
        (clojure.core/str (clojure.core/nth args14258 0))
        (clojure.core/str (clojure.core/nth args14258 1))))))))
  (clojure.core/defn
   get-object-acl-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Generate map for getObjectAcl, getObjectAcl, getObjectAcl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :get-object-acl,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-object-acl
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         key
                         sdk-request-timeout
                         version-id
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         bucket-name
                         clone-source
                         clone-root
                         requester-pays]}]
                [credentials string-0 string-1 string-2]
                [credentials string-0 string-1]]),
    :doc "Call getObjectAcl, getObjectAcl, getObjectAcl"}
   [credentials14263 & args14264]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14267
     (com.palletops.awaze.common/aws-client :s3 credentials14263)]
    (clojure.core/case
     (clojure.core/count args14264)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14267
       getObjectAcl
       (s3/get-object-acl-request (clojure.core/nth args14264 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14267
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14264 0))
       (clojure.core/str (clojure.core/nth args14264 1))
       (clojure.core/str (clojure.core/nth args14264 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14267
       getObjectAcl
       (clojure.core/str (clojure.core/nth args14264 0))
       (clojure.core/str (clojure.core/nth args14264 1))))))))
 (do
  (clojure.core/defmethod
   s3
   :upload-part
   [m14268]
   (clojure.core/let
    [credentials14269 (:credentials m14268) args14270 (:args m14268)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14271
      (com.palletops.awaze.common/aws-client :s3 credentials14269)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14271
       uploadPart
       (s3/upload-part-request (clojure.core/nth args14270 0)))))))
  (clojure.core/defn
   upload-part-map
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Generate map for uploadPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-part,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   upload-part
   {:arglists (quote
               [[credentials
                 {:keys [input-stream
                         custom-request-headers
                         sdk-client-execution-timeout
                         key
                         progress-listener
                         last-part
                         sdk-request-timeout
                         upload-id
                         file
                         object-metadata
                         custom-query-parameters
                         md5digest
                         read-limit
                         ssecustomer-key
                         general-progress-listener
                         file-offset
                         part-number
                         bucket-name
                         clone-source
                         part-size
                         clone-root
                         requester-pays]}]]),
    :doc "Call uploadPart"}
   [credentials14273 & args14274]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14275
     (com.palletops.awaze.common/aws-client :s3 credentials14273)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14275
      uploadPart
      (s3/upload-part-request (clojure.core/nth args14274 0)))))))
 (do
  (clojure.core/defmethod
   s3
   :set-bucket-website-configuration
   [m14276]
   (clojure.core/let
    [credentials14277 (:credentials m14276) args14278 (:args m14276)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14279
      (com.palletops.awaze.common/aws-client :s3 credentials14277)]
     (clojure.core/case
      (clojure.core/count args14278)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14279
        setBucketWebsiteConfiguration
        (clojure.core/str (clojure.core/nth args14278 0))
        (s3/bucket-website-configuration
         (clojure.core/nth args14278 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14279
        setBucketWebsiteConfiguration
        (s3/set-bucket-website-configuration-request
         (clojure.core/nth args14278 0))))))))
  (clojure.core/defn
   set-bucket-website-configuration-map
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-bucket-website-configuration,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   set-bucket-website-configuration
   {:arglists (quote
               [[credentials
                 string-0
                 {:keys [error-document
                         index-document-suffix
                         redirect-all-requests-to
                         routing-rules]}]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         configuration
                         bucket-name
                         clone-source
                         clone-root]}]]),
    :doc "Call setBucketWebsiteConfiguration, setBucketWebsiteConfiguration"}
   [credentials14283 & args14284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14287
     (com.palletops.awaze.common/aws-client :s3 credentials14283)]
    (clojure.core/case
     (clojure.core/count args14284)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14287
       setBucketWebsiteConfiguration
       (clojure.core/str (clojure.core/nth args14284 0))
       (s3/bucket-website-configuration
        (clojure.core/nth args14284 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14287
       setBucketWebsiteConfiguration
       (s3/set-bucket-website-configuration-request
        (clojure.core/nth args14284 0))))))))
 (do
  (clojure.core/defmethod
   s3
   :get-region
   [m14288]
   (clojure.core/let
    [credentials14289 (:credentials m14288) args14290 (:args m14288)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.s3.AmazonS3Client}
      client14291
      (com.palletops.awaze.common/aws-client :s3 credentials14289)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14291
       getRegion)))))
  (clojure.core/defn
   get-region-map
   {:arglists (quote [[credentials]]),
    :doc "Generate map for getRegion"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-region,
     :credentials credentials__1842__auto__,
     :client :s3}))
  (clojure.core/defn
   get-region
   {:arglists (quote [[credentials]]), :doc "Call getRegion"}
   [credentials14293 & args14294]
   (clojure.core/let
    [^{:tag com.amazonaws.services.s3.AmazonS3Client}
     client14295
     (com.palletops.awaze.common/aws-client :s3 credentials14293)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.s3.AmazonS3Client}
client14295
      getRegion))))))
