(ns
 com.palletops.awaze.securitytoken
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.securitytoken :as securitytoken]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :securitytoken
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleRequest}
assume-role-request
  [m8420]
  (clojure.core/let
   [bean8419
    (new com.amazonaws.services.securitytoken.model.AssumeRoleRequest)]
   (clojure.core/let
    [v8421
     (:role-arn m8420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setRoleArn (clojure.core/str v8421))))
   (clojure.core/let
    [v8421
     (:role-session-name
      m8420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setRoleSessionName (clojure.core/str v8421))))
   (clojure.core/let
    [v8421
     (:external-id m8420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setExternalId (clojure.core/str v8421))))
   (clojure.core/let
    [v8421
     (:duration-seconds
      m8420
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setDurationSeconds (clojure.core/int v8421))))
   (clojure.core/let
    [v8421
     (:serial-number m8420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setSerialNumber (clojure.core/str v8421))))
   (clojure.core/let
    [v8421
     (:token-code m8420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setTokenCode (clojure.core/str v8421))))
   (clojure.core/let
    [v8421 (:policy m8420 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8421 :com.palletops.awaze.client-builder/undef)
     (. bean8419 setPolicy (clojure.core/str v8421))))
   bean8419))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest}
assume-role-with-samlrequest
  [m8423]
  (clojure.core/let
   [bean8422
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest)]
   (clojure.core/let
    [v8424
     (:role-arn m8423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8424 :com.palletops.awaze.client-builder/undef)
     (. bean8422 setRoleArn (clojure.core/str v8424))))
   (clojure.core/let
    [v8424
     (:samlassertion m8423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8424 :com.palletops.awaze.client-builder/undef)
     (. bean8422 setSAMLAssertion (clojure.core/str v8424))))
   (clojure.core/let
    [v8424
     (:duration-seconds
      m8423
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8424 :com.palletops.awaze.client-builder/undef)
     (. bean8422 setDurationSeconds (clojure.core/int v8424))))
   (clojure.core/let
    [v8424
     (:principal-arn m8423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8424 :com.palletops.awaze.client-builder/undef)
     (. bean8422 setPrincipalArn (clojure.core/str v8424))))
   (clojure.core/let
    [v8424 (:policy m8423 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8424 :com.palletops.awaze.client-builder/undef)
     (. bean8422 setPolicy (clojure.core/str v8424))))
   bean8422))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest}
assume-role-with-web-identity-request
  [m8426]
  (clojure.core/let
   [bean8425
    (new
     com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest)]
   (clojure.core/let
    [v8427
     (:role-arn m8426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8427 :com.palletops.awaze.client-builder/undef)
     (. bean8425 setRoleArn (clojure.core/str v8427))))
   (clojure.core/let
    [v8427
     (:role-session-name
      m8426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8427 :com.palletops.awaze.client-builder/undef)
     (. bean8425 setRoleSessionName (clojure.core/str v8427))))
   (clojure.core/let
    [v8427
     (:duration-seconds
      m8426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8427 :com.palletops.awaze.client-builder/undef)
     (. bean8425 setDurationSeconds (clojure.core/int v8427))))
   (clojure.core/let
    [v8427
     (:web-identity-token
      m8426
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8427 :com.palletops.awaze.client-builder/undef)
     (. bean8425 setWebIdentityToken (clojure.core/str v8427))))
   (clojure.core/let
    [v8427
     (:provider-id m8426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8427 :com.palletops.awaze.client-builder/undef)
     (. bean8425 setProviderId (clojure.core/str v8427))))
   (clojure.core/let
    [v8427 (:policy m8426 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8427 :com.palletops.awaze.client-builder/undef)
     (. bean8425 setPolicy (clojure.core/str v8427))))
   bean8425))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest}
decode-authorization-message-request
  [m8429]
  (clojure.core/let
   [bean8428
    (new
     com.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest)]
   (clojure.core/let
    [v8430
     (:encoded-message
      m8429
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8430 :com.palletops.awaze.client-builder/undef)
     (. bean8428 setEncodedMessage (clojure.core/str v8430))))
   bean8428))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetFederationTokenRequest}
get-federation-token-request
  [m8432]
  (clojure.core/let
   [bean8431
    (new
     com.amazonaws.services.securitytoken.model.GetFederationTokenRequest)]
   (clojure.core/let
    [v8433
     (:duration-seconds
      m8432
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setDurationSeconds (clojure.core/int v8433))))
   (clojure.core/let
    [v8433 (:policy m8432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setPolicy (clojure.core/str v8433))))
   (clojure.core/let
    [v8433 (:name m8432 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8433 :com.palletops.awaze.client-builder/undef)
     (. bean8431 setName (clojure.core/str v8433))))
   bean8431))
 (clojure.core/defn
^{:tag com.amazonaws.services.securitytoken.model.GetSessionTokenRequest}
get-session-token-request
  [m8435]
  (clojure.core/let
   [bean8434
    (new
     com.amazonaws.services.securitytoken.model.GetSessionTokenRequest)]
   (clojure.core/let
    [v8436
     (:duration-seconds
      m8435
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setDurationSeconds (clojure.core/int v8436))))
   (clojure.core/let
    [v8436
     (:serial-number m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setSerialNumber (clojure.core/str v8436))))
   (clojure.core/let
    [v8436
     (:token-code m8435 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8436 :com.palletops.awaze.client-builder/undef)
     (. bean8434 setTokenCode (clojure.core/str v8436))))
   bean8434))
 (clojure.core/defmulti
  securitytoken
  (clojure.core/fn
   securitytoken
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role
   [m8437]
   (clojure.core/let
    [credentials8438 (:credentials m8437) args8439 (:args m8437)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8440
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8438)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8440
       assumeRole
       (securitytoken/assume-role-request
        (clojure.core/nth args8439 0)))))))
  (clojure.core/defn
   assume-role-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRole"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         external-id
                         read-limit
                         general-progress-listener
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRole"}
   [credentials8442 & args8443]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8444
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8442)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8444
      assumeRole
      (securitytoken/assume-role-request
       (clojure.core/nth args8443 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-saml
   [m8445]
   (clojure.core/let
    [credentials8446 (:credentials m8445) args8447 (:args m8445)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8448
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8446)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8448
       assumeRoleWithSAML
       (securitytoken/assume-role-with-samlrequest
        (clojure.core/nth args8447 0)))))))
  (clojure.core/defn
   assume-role-with-saml-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithSAML"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-saml,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-saml
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         principal-arn
                         sdk-request-timeout
                         custom-query-parameters
                         samlassertion
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call assumeRoleWithSAML"}
   [credentials8450 & args8451]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8452
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8450)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8452
      assumeRoleWithSAML
      (securitytoken/assume-role-with-samlrequest
       (clojure.core/nth args8451 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :assume-role-with-web-identity
   [m8453]
   (clojure.core/let
    [credentials8454 (:credentials m8453) args8455 (:args m8453)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8456
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8454)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8456
       assumeRoleWithWebIdentity
       (securitytoken/assume-role-with-web-identity-request
        (clojure.core/nth args8455 0)))))))
  (clojure.core/defn
   assume-role-with-web-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Generate map for assumeRoleWithWebIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :assume-role-with-web-identity,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   assume-role-with-web-identity
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         provider-id
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         role-arn
                         read-limit
                         general-progress-listener
                         web-identity-token
                         clone-source
                         role-session-name
                         clone-root]}]]),
    :doc "Call assumeRoleWithWebIdentity"}
   [credentials8458 & args8459]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8460
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8458)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8460
      assumeRoleWithWebIdentity
      (securitytoken/assume-role-with-web-identity-request
       (clojure.core/nth args8459 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :decode-authorization-message
   [m8461]
   (clojure.core/let
    [credentials8462 (:credentials m8461) args8463 (:args m8461)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8464
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8462)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8464
       decodeAuthorizationMessage
       (securitytoken/decode-authorization-message-request
        (clojure.core/nth args8463 0)))))))
  (clojure.core/defn
   decode-authorization-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for decodeAuthorizationMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :decode-authorization-message,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   decode-authorization-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         encoded-message
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call decodeAuthorizationMessage"}
   [credentials8466 & args8467]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8468
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8466)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8468
      decodeAuthorizationMessage
      (securitytoken/decode-authorization-message-request
       (clojure.core/nth args8467 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-federation-token
   [m8469]
   (clojure.core/let
    [credentials8470 (:credentials m8469) args8471 (:args m8469)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8472
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8470)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8472
       getFederationToken
       (securitytoken/get-federation-token-request
        (clojure.core/nth args8471 0)))))))
  (clojure.core/defn
   get-federation-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getFederationToken"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-federation-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-federation-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         policy
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getFederationToken"}
   [credentials8474 & args8475]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8476
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8474)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8476
      getFederationToken
      (securitytoken/get-federation-token-request
       (clojure.core/nth args8475 0)))))))
 (do
  (clojure.core/defmethod
   securitytoken
   :get-session-token
   [m8477]
   (clojure.core/let
    [credentials8478 (:credentials m8477) args8479 (:args m8477)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
      client8480
      (com.palletops.awaze.common/aws-client
       :securitytoken
       credentials8478)]
     (clojure.core/case
      (clojure.core/count args8479)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8480
        getSessionToken
        (securitytoken/get-session-token-request
         (clojure.core/nth args8479 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8480
        getSessionToken))))))
  (clojure.core/defn
   get-session-token-map
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getSessionToken, getSessionToken"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-session-token,
     :credentials credentials__1842__auto__,
     :client :securitytoken}))
  (clojure.core/defn
   get-session-token
   {:arglists (quote
               [[credentials
                 {:keys [duration-seconds
                         serial-number
                         custom-request-headers
                         sdk-client-execution-timeout
                         token-code
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call getSessionToken, getSessionToken"}
   [credentials8482 & args8483]
   (clojure.core/let
    [^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
     client8484
     (com.palletops.awaze.common/aws-client
      :securitytoken
      credentials8482)]
    (clojure.core/case
     (clojure.core/count args8483)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8484
       getSessionToken
       (securitytoken/get-session-token-request
        (clojure.core/nth args8483 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient}
client8484
       getSessionToken)))))))
