(ns
 com.palletops.awaze.cloudformation
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudformation :as cloudformation]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudformation
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudformation.AmazonCloudFormationClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Parameter}
parameter
  [m4912]
  (clojure.core/let
   [bean4911
    (new com.amazonaws.services.cloudformation.model.Parameter)]
   (clojure.core/let
    [v4913
     (:parameter-value
      m4912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4913 :com.palletops.awaze.client-builder/undef)
     (. bean4911 setParameterValue (clojure.core/str v4913))))
   (clojure.core/let
    [v4913
     (:use-previous-value
      m4912
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4913 :com.palletops.awaze.client-builder/undef)
     (. bean4911 setUsePreviousValue (clojure.core/boolean v4913))))
   (clojure.core/let
    [v4913
     (:parameter-key m4912 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4913 :com.palletops.awaze.client-builder/undef)
     (. bean4911 setParameterKey (clojure.core/str v4913))))
   bean4911))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.Tag}
tag
  [m4915]
  (clojure.core/let
   [bean4914 (new com.amazonaws.services.cloudformation.model.Tag)]
   (clojure.core/let
    [v4916 (:key m4915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4916 :com.palletops.awaze.client-builder/undef)
     (. bean4914 setKey (clojure.core/str v4916))))
   (clojure.core/let
    [v4916 (:value m4915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4916 :com.palletops.awaze.client-builder/undef)
     (. bean4914 setValue (clojure.core/str v4916))))
   bean4914))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ResourceSignalStatus}
resource-signal-status
  [m4918]
  (.
   com.amazonaws.services.cloudformation.model.ResourceSignalStatus
   fromValue
   (clojure.core/name m4918)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.OnFailure}
on-failure
  [m4921]
  (.
   com.amazonaws.services.cloudformation.model.OnFailure
   fromValue
   (clojure.core/name m4921)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest}
continue-update-rollback-request
  [m4924]
  (clojure.core/let
   [bean4923
    (new
     com.amazonaws.services.cloudformation.model.ContinueUpdateRollbackRequest)]
   (clojure.core/let
    [v4925
     (:stack-name m4924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4925 :com.palletops.awaze.client-builder/undef)
     (. bean4923 setStackName (clojure.core/str v4925))))
   bean4923))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest}
describe-change-set-request
  [m4927]
  (clojure.core/let
   [bean4926
    (new
     com.amazonaws.services.cloudformation.model.DescribeChangeSetRequest)]
   (clojure.core/let
    [v4928
     (:change-set-name
      m4927
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setChangeSetName (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:next-token m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setNextToken (clojure.core/str v4928))))
   (clojure.core/let
    [v4928
     (:stack-name m4927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4928 :com.palletops.awaze.client-builder/undef)
     (. bean4926 setStackName (clojure.core/str v4928))))
   bean4926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SetStackPolicyRequest}
set-stack-policy-request
  [m4930]
  (clojure.core/let
   [bean4929
    (new
     com.amazonaws.services.cloudformation.model.SetStackPolicyRequest)]
   (clojure.core/let
    [v4931
     (:stack-policy-body
      m4930
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setStackPolicyBody (clojure.core/str v4931))))
   (clojure.core/let
    [v4931
     (:stack-policy-url
      m4930
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setStackPolicyURL (clojure.core/str v4931))))
   (clojure.core/let
    [v4931
     (:stack-name m4930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4931 :com.palletops.awaze.client-builder/undef)
     (. bean4929 setStackName (clojure.core/str v4931))))
   bean4929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStacksRequest}
describe-stacks-request
  [m4933]
  (clojure.core/let
   [bean4932
    (new
     com.amazonaws.services.cloudformation.model.DescribeStacksRequest)]
   (clojure.core/let
    [v4934
     (:next-token m4933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4934 :com.palletops.awaze.client-builder/undef)
     (. bean4932 setNextToken (clojure.core/str v4934))))
   (clojure.core/let
    [v4934
     (:stack-name m4933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4934 :com.palletops.awaze.client-builder/undef)
     (. bean4932 setStackName (clojure.core/str v4934))))
   bean4932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.UpdateStackRequest}
update-stack-request
  [m4936]
  (clojure.core/let
   [bean4935
    (new
     com.amazonaws.services.cloudformation.model.UpdateStackRequest)]
   (clojure.core/let
    [v4937
     (:use-previous-template
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setUsePreviousTemplate (clojure.core/boolean v4937))))
   (clojure.core/let
    [v4937
     (:stack-name m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setStackName (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:notification-arns
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4995] (clojure.core/str arg4995))
 v4937))))
   (clojure.core/let
    [v4937
     (:parameters m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4996] (cloudformation/parameter arg4996))
 v4937))))
   (clojure.core/let
    [v4937
     (:stack-policy-during-update-body
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setStackPolicyDuringUpdateBody
      (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:template-url m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setTemplateURL (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:stack-policy-url
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setStackPolicyURL (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:stack-policy-body
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setStackPolicyBody (clojure.core/str v4937))))
   (clojure.core/let
    [v4937 (:tags m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4997] (cloudformation/tag arg4997))
 v4937))))
   (clojure.core/let
    [v4937
     (:stack-policy-during-update-url
      m4936
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setStackPolicyDuringUpdateURL
      (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:template-body m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (. bean4935 setTemplateBody (clojure.core/str v4937))))
   (clojure.core/let
    [v4937
     (:resource-types m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4998] (clojure.core/str arg4998))
 v4937))))
   (clojure.core/let
    [v4937
     (:capabilities m4936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4937 :com.palletops.awaze.client-builder/undef)
     (.
      bean4935
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4999] (clojure.core/str arg4999))
 v4937))))
   bean4935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest}
estimate-template-cost-request
  [m4939]
  (clojure.core/let
   [bean4938
    (new
     com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest)]
   (clojure.core/let
    [v4940
     (:template-body m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setTemplateBody (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:template-url m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (. bean4938 setTemplateURL (clojure.core/str v4940))))
   (clojure.core/let
    [v4940
     (:parameters m4939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4940 :com.palletops.awaze.client-builder/undef)
     (.
      bean4938
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5000] (cloudformation/parameter arg5000))
 v4940))))
   bean4938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStacksRequest}
list-stacks-request
  [m4942]
  (clojure.core/let
   [bean4941
    (new
     com.amazonaws.services.cloudformation.model.ListStacksRequest)]
   (clojure.core/let
    [v4943
     (:stack-status-filters
      m4942
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (.
      bean4941
      setStackStatusFilters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5001] (clojure.core/str arg5001))
 v4943))))
   (clojure.core/let
    [v4943
     (:next-token m4942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4943 :com.palletops.awaze.client-builder/undef)
     (. bean4941 setNextToken (clojure.core/str v4943))))
   bean4941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest}
describe-stack-events-request
  [m4945]
  (clojure.core/let
   [bean4944
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest)]
   (clojure.core/let
    [v4946
     (:next-token m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setNextToken (clojure.core/str v4946))))
   (clojure.core/let
    [v4946
     (:stack-name m4945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4946 :com.palletops.awaze.client-builder/undef)
     (. bean4944 setStackName (clojure.core/str v4946))))
   bean4944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteStackRequest}
delete-stack-request
  [m4948]
  (clojure.core/let
   [bean4947
    (new
     com.amazonaws.services.cloudformation.model.DeleteStackRequest)]
   (clojure.core/let
    [v4949
     (:retain-resources
      m4948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (.
      bean4947
      setRetainResources
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5002] (clojure.core/str arg5002))
 v4949))))
   (clojure.core/let
    [v4949
     (:stack-name m4948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4949 :com.palletops.awaze.client-builder/undef)
     (. bean4947 setStackName (clojure.core/str v4949))))
   bean4947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ValidateTemplateRequest}
validate-template-request
  [m4951]
  (clojure.core/let
   [bean4950
    (new
     com.amazonaws.services.cloudformation.model.ValidateTemplateRequest)]
   (clojure.core/let
    [v4952
     (:template-body m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setTemplateBody (clojure.core/str v4952))))
   (clojure.core/let
    [v4952
     (:template-url m4951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4952 :com.palletops.awaze.client-builder/undef)
     (. bean4950 setTemplateURL (clojure.core/str v4952))))
   bean4950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest}
describe-stack-resources-request
  [m4954]
  (clojure.core/let
   [bean4953
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest)]
   (clojure.core/let
    [v4955
     (:logical-resource-id
      m4954
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setLogicalResourceId (clojure.core/str v4955))))
   (clojure.core/let
    [v4955
     (:physical-resource-id
      m4954
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setPhysicalResourceId (clojure.core/str v4955))))
   (clojure.core/let
    [v4955
     (:stack-name m4954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4955 :com.palletops.awaze.client-builder/undef)
     (. bean4953 setStackName (clojure.core/str v4955))))
   bean4953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest}
describe-account-limits-request
  [m4957]
  (clojure.core/let
   [bean4956
    (new
     com.amazonaws.services.cloudformation.model.DescribeAccountLimitsRequest)]
   (clojure.core/let
    [v4958
     (:next-token m4957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4958 :com.palletops.awaze.client-builder/undef)
     (. bean4956 setNextToken (clojure.core/str v4958))))
   bean4956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.SignalResourceRequest}
signal-resource-request
  [m4960]
  (clojure.core/let
   [bean4959
    (new
     com.amazonaws.services.cloudformation.model.SignalResourceRequest)]
   (clojure.core/let
    [v4961 (:status m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (.
      bean4959
      setStatus
      (cloudformation/resource-signal-status v4961))))
   (clojure.core/let
    [v4961
     (:logical-resource-id
      m4960
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setLogicalResourceId (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:unique-id m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setUniqueId (clojure.core/str v4961))))
   (clojure.core/let
    [v4961
     (:stack-name m4960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4961 :com.palletops.awaze.client-builder/undef)
     (. bean4959 setStackName (clojure.core/str v4961))))
   bean4959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateRequest}
get-template-request
  [m4963]
  (clojure.core/let
   [bean4962
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateRequest)]
   (clojure.core/let
    [v4964
     (:stack-name m4963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4964 :com.palletops.awaze.client-builder/undef)
     (. bean4962 setStackName (clojure.core/str v4964))))
   bean4962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetStackPolicyRequest}
get-stack-policy-request
  [m4966]
  (clojure.core/let
   [bean4965
    (new
     com.amazonaws.services.cloudformation.model.GetStackPolicyRequest)]
   (clojure.core/let
    [v4967
     (:stack-name m4966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4967 :com.palletops.awaze.client-builder/undef)
     (. bean4965 setStackName (clojure.core/str v4967))))
   bean4965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateStackRequest}
create-stack-request
  [m4969]
  (clojure.core/let
   [bean4968
    (new
     com.amazonaws.services.cloudformation.model.CreateStackRequest)]
   (clojure.core/let
    [v4970
     (:stack-name m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setStackName (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:notification-arns
      m4969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (.
      bean4968
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5019] (clojure.core/str arg5019))
 v4970))))
   (clojure.core/let
    [v4970
     (:parameters m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (.
      bean4968
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5020] (cloudformation/parameter arg5020))
 v4970))))
   (clojure.core/let
    [v4970
     (:timeout-in-minutes
      m4969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setTimeoutInMinutes (clojure.core/int v4970))))
   (clojure.core/let
    [v4970
     (:disable-rollback
      m4969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setDisableRollback (clojure.core/boolean v4970))))
   (clojure.core/let
    [v4970
     (:template-url m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setTemplateURL (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:stack-policy-url
      m4969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setStackPolicyURL (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:stack-policy-body
      m4969
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setStackPolicyBody (clojure.core/str v4970))))
   (clojure.core/let
    [v4970 (:tags m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (.
      bean4968
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5021] (cloudformation/tag arg5021))
 v4970))))
   (clojure.core/let
    [v4970
     (:template-body m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setTemplateBody (clojure.core/str v4970))))
   (clojure.core/let
    [v4970
     (:resource-types m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (.
      bean4968
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5022] (clojure.core/str arg5022))
 v4970))))
   (clojure.core/let
    [v4970
     (:capabilities m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (.
      bean4968
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5023] (clojure.core/str arg5023))
 v4970))))
   (clojure.core/let
    [v4970
     (:on-failure m4969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4970 :com.palletops.awaze.client-builder/undef)
     (. bean4968 setOnFailure (cloudformation/on-failure v4970))))
   bean4968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListStackResourcesRequest}
list-stack-resources-request
  [m4972]
  (clojure.core/let
   [bean4971
    (new
     com.amazonaws.services.cloudformation.model.ListStackResourcesRequest)]
   (clojure.core/let
    [v4973
     (:next-token m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setNextToken (clojure.core/str v4973))))
   (clojure.core/let
    [v4973
     (:stack-name m4972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4973 :com.palletops.awaze.client-builder/undef)
     (. bean4971 setStackName (clojure.core/str v4973))))
   bean4971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest}
describe-stack-resource-request
  [m4975]
  (clojure.core/let
   [bean4974
    (new
     com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest)]
   (clojure.core/let
    [v4976
     (:logical-resource-id
      m4975
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setLogicalResourceId (clojure.core/str v4976))))
   (clojure.core/let
    [v4976
     (:stack-name m4975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4976 :com.palletops.awaze.client-builder/undef)
     (. bean4974 setStackName (clojure.core/str v4976))))
   bean4974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ListChangeSetsRequest}
list-change-sets-request
  [m4978]
  (clojure.core/let
   [bean4977
    (new
     com.amazonaws.services.cloudformation.model.ListChangeSetsRequest)]
   (clojure.core/let
    [v4979
     (:next-token m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setNextToken (clojure.core/str v4979))))
   (clojure.core/let
    [v4979
     (:stack-name m4978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4979 :com.palletops.awaze.client-builder/undef)
     (. bean4977 setStackName (clojure.core/str v4979))))
   bean4977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest}
cancel-update-stack-request
  [m4981]
  (clojure.core/let
   [bean4980
    (new
     com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest)]
   (clojure.core/let
    [v4982
     (:stack-name m4981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4982 :com.palletops.awaze.client-builder/undef)
     (. bean4980 setStackName (clojure.core/str v4982))))
   bean4980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.CreateChangeSetRequest}
create-change-set-request
  [m4984]
  (clojure.core/let
   [bean4983
    (new
     com.amazonaws.services.cloudformation.model.CreateChangeSetRequest)]
   (clojure.core/let
    [v4985
     (:description m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setDescription (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:use-previous-template
      m4984
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setUsePreviousTemplate (clojure.core/boolean v4985))))
   (clojure.core/let
    [v4985
     (:stack-name m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setStackName (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:notification-arns
      m4984
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (.
      bean4983
      setNotificationARNs
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5024] (clojure.core/str arg5024))
 v4985))))
   (clojure.core/let
    [v4985
     (:parameters m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (.
      bean4983
      setParameters
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5025] (cloudformation/parameter arg5025))
 v4985))))
   (clojure.core/let
    [v4985
     (:client-token m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setClientToken (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:template-url m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setTemplateURL (clojure.core/str v4985))))
   (clojure.core/let
    [v4985 (:tags m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (.
      bean4983
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5026] (cloudformation/tag arg5026))
 v4985))))
   (clojure.core/let
    [v4985
     (:change-set-name
      m4984
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setChangeSetName (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:template-body m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (. bean4983 setTemplateBody (clojure.core/str v4985))))
   (clojure.core/let
    [v4985
     (:resource-types m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (.
      bean4983
      setResourceTypes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5027] (clojure.core/str arg5027))
 v4985))))
   (clojure.core/let
    [v4985
     (:capabilities m4984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4985 :com.palletops.awaze.client-builder/undef)
     (.
      bean4983
      setCapabilities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5028] (clojure.core/str arg5028))
 v4985))))
   bean4983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest}
execute-change-set-request
  [m4987]
  (clojure.core/let
   [bean4986
    (new
     com.amazonaws.services.cloudformation.model.ExecuteChangeSetRequest)]
   (clojure.core/let
    [v4988
     (:change-set-name
      m4987
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4988 :com.palletops.awaze.client-builder/undef)
     (. bean4986 setChangeSetName (clojure.core/str v4988))))
   (clojure.core/let
    [v4988
     (:stack-name m4987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4988 :com.palletops.awaze.client-builder/undef)
     (. bean4986 setStackName (clojure.core/str v4988))))
   bean4986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest}
delete-change-set-request
  [m4990]
  (clojure.core/let
   [bean4989
    (new
     com.amazonaws.services.cloudformation.model.DeleteChangeSetRequest)]
   (clojure.core/let
    [v4991
     (:change-set-name
      m4990
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4991 :com.palletops.awaze.client-builder/undef)
     (. bean4989 setChangeSetName (clojure.core/str v4991))))
   (clojure.core/let
    [v4991
     (:stack-name m4990 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4991 :com.palletops.awaze.client-builder/undef)
     (. bean4989 setStackName (clojure.core/str v4991))))
   bean4989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest}
get-template-summary-request
  [m4993]
  (clojure.core/let
   [bean4992
    (new
     com.amazonaws.services.cloudformation.model.GetTemplateSummaryRequest)]
   (clojure.core/let
    [v4994
     (:template-body m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setTemplateBody (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:template-url m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setTemplateURL (clojure.core/str v4994))))
   (clojure.core/let
    [v4994
     (:stack-name m4993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4994 :com.palletops.awaze.client-builder/undef)
     (. bean4992 setStackName (clojure.core/str v4994))))
   bean4992))
 (clojure.core/defmulti
  cloudformation
  (clojure.core/fn
   cloudformation
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudformation
   :continue-update-rollback
   [m5003]
   (clojure.core/let
    [credentials5004 (:credentials m5003) args5005 (:args m5003)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5006
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5004)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5006
       continueUpdateRollback
       (cloudformation/continue-update-rollback-request
        (clojure.core/nth args5005 0)))))))
  (clojure.core/defn
   continue-update-rollback-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for continueUpdateRollback"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :continue-update-rollback,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   continue-update-rollback
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call continueUpdateRollback"}
   [credentials5008 & args5009]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5010
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5008)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5010
      continueUpdateRollback
      (cloudformation/continue-update-rollback-request
       (clojure.core/nth args5009 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-change-set
   [m5011]
   (clojure.core/let
    [credentials5012 (:credentials m5011) args5013 (:args m5011)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5014
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5012)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5014
       describeChangeSet
       (cloudformation/describe-change-set-request
        (clojure.core/nth args5013 0)))))))
  (clojure.core/defn
   describe-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeChangeSet"}
   [credentials5016 & args5017]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5018
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5016)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5018
      describeChangeSet
      (cloudformation/describe-change-set-request
       (clojure.core/nth args5017 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :set-stack-policy
   [m5029]
   (clojure.core/let
    [credentials5030 (:credentials m5029) args5031 (:args m5029)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5032
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5030)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5032
       setStackPolicy
       (cloudformation/set-stack-policy-request
        (clojure.core/nth args5031 0)))))))
  (clojure.core/defn
   set-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for setStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   set-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call setStackPolicy"}
   [credentials5034 & args5035]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5036
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5034)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5036
      setStackPolicy
      (cloudformation/set-stack-policy-request
       (clojure.core/nth args5035 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stacks
   [m5037]
   (clojure.core/let
    [credentials5038 (:credentials m5037) args5039 (:args m5037)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5040
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5038)]
     (clojure.core/case
      (clojure.core/count args5039)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5040
        describeStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5040
        describeStacks
        (cloudformation/describe-stacks-request
         (clojure.core/nth args5039 0))))))))
  (clojure.core/defn
   describe-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStacks, describeStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStacks, describeStacks"}
   [credentials5042 & args5043]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5044
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5042)]
    (clojure.core/case
     (clojure.core/count args5043)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5044
       describeStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5044
       describeStacks
       (cloudformation/describe-stacks-request
        (clojure.core/nth args5043 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :update-stack
   [m5045]
   (clojure.core/let
    [credentials5046 (:credentials m5045) args5047 (:args m5045)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5048
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5046)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5048
       updateStack
       (cloudformation/update-stack-request
        (clojure.core/nth args5047 0)))))))
  (clojure.core/defn
   update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Generate map for updateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   update-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         stack-policy-during-update-body
                         clone-root
                         stack-policy-url
                         stack-policy-during-update-url]}]]),
    :doc "Call updateStack"}
   [credentials5050 & args5051]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5052
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5050)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5052
      updateStack
      (cloudformation/update-stack-request
       (clojure.core/nth args5051 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :estimate-template-cost
   [m5053]
   (clojure.core/let
    [credentials5054 (:credentials m5053) args5055 (:args m5053)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5056
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5054)]
     (clojure.core/case
      (clojure.core/count args5055)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5056
        estimateTemplateCost))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5056
        estimateTemplateCost
        (cloudformation/estimate-template-cost-request
         (clojure.core/nth args5055 0))))))))
  (clojure.core/defn
   estimate-template-cost-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Generate map for estimateTemplateCost, estimateTemplateCost"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :estimate-template-cost,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   estimate-template-cost
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root]}]]),
    :doc "Call estimateTemplateCost, estimateTemplateCost"}
   [credentials5058 & args5059]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5060
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5058)]
    (clojure.core/case
     (clojure.core/count args5059)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5060
       estimateTemplateCost))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5060
       estimateTemplateCost
       (cloudformation/estimate-template-cost-request
        (clojure.core/nth args5059 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stacks
   [m5061]
   (clojure.core/let
    [credentials5062 (:credentials m5061) args5063 (:args m5061)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5064
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5062)]
     (clojure.core/case
      (clojure.core/count args5063)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5064
        listStacks))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5064
        listStacks
        (cloudformation/list-stacks-request
         (clojure.core/nth args5063 0))))))))
  (clojure.core/defn
   list-stacks-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStacks, listStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stacks,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stacks
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         stack-status-filters
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStacks, listStacks"}
   [credentials5066 & args5067]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5068
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5066)]
    (clojure.core/case
     (clojure.core/count args5067)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5068
       listStacks))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5068
       listStacks
       (cloudformation/list-stacks-request
        (clojure.core/nth args5067 0))))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-events
   [m5069]
   (clojure.core/let
    [credentials5070 (:credentials m5069) args5071 (:args m5069)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5072
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5070)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5072
       describeStackEvents
       (cloudformation/describe-stack-events-request
        (clojure.core/nth args5071 0)))))))
  (clojure.core/defn
   describe-stack-events-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeStackEvents"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-events,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-events
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeStackEvents"}
   [credentials5074 & args5075]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5076
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5074)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5076
      describeStackEvents
      (cloudformation/describe-stack-events-request
       (clojure.core/nth args5075 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-stack
   [m5077]
   (clojure.core/let
    [credentials5078 (:credentials m5077) args5079 (:args m5077)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5080
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5078)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5080
       deleteStack
       (cloudformation/delete-stack-request
        (clojure.core/nth args5079 0)))))))
  (clojure.core/defn
   delete-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         retain-resources
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStack"}
   [credentials5082 & args5083]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5084
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5082)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5084
      deleteStack
      (cloudformation/delete-stack-request
       (clojure.core/nth args5083 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :validate-template
   [m5085]
   (clojure.core/let
    [credentials5086 (:credentials m5085) args5087 (:args m5085)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5088
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5086)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5088
       validateTemplate
       (cloudformation/validate-template-request
        (clojure.core/nth args5087 0)))))))
  (clojure.core/defn
   validate-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Generate map for validateTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   validate-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]]),
    :doc "Call validateTemplate"}
   [credentials5090 & args5091]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5092
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5090)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5092
      validateTemplate
      (cloudformation/validate-template-request
       (clojure.core/nth args5091 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resources
   [m5093]
   (clojure.core/let
    [credentials5094 (:credentials m5093) args5095 (:args m5093)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5096
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5094)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5096
       describeStackResources
       (cloudformation/describe-stack-resources-request
        (clojure.core/nth args5095 0)))))))
  (clojure.core/defn
   describe-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         physical-resource-id
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResources"}
   [credentials5098 & args5099]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5100
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5098)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5100
      describeStackResources
      (cloudformation/describe-stack-resources-request
       (clojure.core/nth args5099 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-account-limits
   [m5101]
   (clojure.core/let
    [credentials5102 (:credentials m5101) args5103 (:args m5101)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5104
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5102)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5104
       describeAccountLimits
       (cloudformation/describe-account-limits-request
        (clojure.core/nth args5103 0)))))))
  (clojure.core/defn
   describe-account-limits-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeAccountLimits"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-account-limits,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-account-limits
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call describeAccountLimits"}
   [credentials5106 & args5107]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5108
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5106)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5108
      describeAccountLimits
      (cloudformation/describe-account-limits-request
       (clojure.core/nth args5107 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :signal-resource
   [m5109]
   (clojure.core/let
    [credentials5110 (:credentials m5109) args5111 (:args m5109)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5112
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5110)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5112
       signalResource
       (cloudformation/signal-resource-request
        (clojure.core/nth args5111 0)))))))
  (clojure.core/defn
   signal-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for signalResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :signal-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   signal-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         unique-id
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call signalResource"}
   [credentials5114 & args5115]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5116
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5114)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5116
      signalResource
      (cloudformation/signal-resource-request
       (clojure.core/nth args5115 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template
   [m5117]
   (clojure.core/let
    [credentials5118 (:credentials m5117) args5119 (:args m5117)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5120
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5118)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5120
       getTemplate
       (cloudformation/get-template-request
        (clojure.core/nth args5119 0)))))))
  (clojure.core/defn
   get-template-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTemplate"}
   [credentials5122 & args5123]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5124
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5122)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5124
      getTemplate
      (cloudformation/get-template-request
       (clojure.core/nth args5123 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-stack-policy
   [m5125]
   (clojure.core/let
    [credentials5126 (:credentials m5125) args5127 (:args m5125)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5128
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5126)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5128
       getStackPolicy
       (cloudformation/get-stack-policy-request
        (clojure.core/nth args5127 0)))))))
  (clojure.core/defn
   get-stack-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStackPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-stack-policy,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-stack-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStackPolicy"}
   [credentials5130 & args5131]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5132
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5130)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5132
      getStackPolicy
      (cloudformation/get-stack-policy-request
       (clojure.core/nth args5131 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-stack
   [m5133]
   (clojure.core/let
    [credentials5134 (:credentials m5133) args5135 (:args m5133)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5136
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5134)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5136
       createStack
       (cloudformation/create-stack-request
        (clojure.core/nth args5135 0)))))))
  (clojure.core/defn
   create-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Generate map for createStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-stack
   {:arglists (quote
               [[credentials
                 {:keys [capabilities
                         tags
                         disable-rollback
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         stack-policy-body
                         template-body
                         resource-types
                         timeout-in-minutes
                         read-limit
                         on-failure
                         general-progress-listener
                         clone-source
                         template-url
                         parameters
                         clone-root
                         stack-policy-url]}]]),
    :doc "Call createStack"}
   [credentials5138 & args5139]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5140
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5138)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5140
      createStack
      (cloudformation/create-stack-request
       (clojure.core/nth args5139 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-stack-resources
   [m5141]
   (clojure.core/let
    [credentials5142 (:credentials m5141) args5143 (:args m5141)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5144
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5142)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5144
       listStackResources
       (cloudformation/list-stack-resources-request
        (clojure.core/nth args5143 0)))))))
  (clojure.core/defn
   list-stack-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listStackResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-stack-resources,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-stack-resources
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listStackResources"}
   [credentials5146 & args5147]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5148
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5146)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5148
      listStackResources
      (cloudformation/list-stack-resources-request
       (clojure.core/nth args5147 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :describe-stack-resource
   [m5149]
   (clojure.core/let
    [credentials5150 (:credentials m5149) args5151 (:args m5149)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5152
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5150)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5152
       describeStackResource
       (cloudformation/describe-stack-resource-request
        (clojure.core/nth args5151 0)))))))
  (clojure.core/defn
   describe-stack-resource-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStackResource"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stack-resource,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   describe-stack-resource
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         logical-resource-id
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStackResource"}
   [credentials5154 & args5155]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5156
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5154)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5156
      describeStackResource
      (cloudformation/describe-stack-resource-request
       (clojure.core/nth args5155 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :list-change-sets
   [m5157]
   (clojure.core/let
    [credentials5158 (:credentials m5157) args5159 (:args m5157)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5160
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5158)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5160
       listChangeSets
       (cloudformation/list-change-sets-request
        (clojure.core/nth args5159 0)))))))
  (clojure.core/defn
   list-change-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listChangeSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-change-sets,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   list-change-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listChangeSets"}
   [credentials5162 & args5163]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5164
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5162)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5164
      listChangeSets
      (cloudformation/list-change-sets-request
       (clojure.core/nth args5163 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :cancel-update-stack
   [m5165]
   (clojure.core/let
    [credentials5166 (:credentials m5165) args5167 (:args m5165)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5168
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5166)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5168
       cancelUpdateStack
       (cloudformation/cancel-update-stack-request
        (clojure.core/nth args5167 0)))))))
  (clojure.core/defn
   cancel-update-stack-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cancelUpdateStack"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :cancel-update-stack,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   cancel-update-stack
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cancelUpdateStack"}
   [credentials5170 & args5171]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5172
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5170)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5172
      cancelUpdateStack
      (cloudformation/cancel-update-stack-request
       (clojure.core/nth args5171 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :create-change-set
   [m5173]
   (clojure.core/let
    [credentials5174 (:credentials m5173) args5175 (:args m5173)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5176
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5174)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5176
       createChangeSet
       (cloudformation/create-change-set-request
        (clojure.core/nth args5175 0)))))))
  (clojure.core/defn
   create-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Generate map for createChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   create-change-set
   {:arglists (quote
               [[credentials
                 {:keys [description
                         capabilities
                         use-previous-template
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         notification-arns
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         resource-types
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         template-url
                         client-token
                         parameters
                         clone-root]}]]),
    :doc "Call createChangeSet"}
   [credentials5178 & args5179]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5180
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5178)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5180
      createChangeSet
      (cloudformation/create-change-set-request
       (clojure.core/nth args5179 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :execute-change-set
   [m5181]
   (clojure.core/let
    [credentials5182 (:credentials m5181) args5183 (:args m5181)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5184
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5182)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5184
       executeChangeSet
       (cloudformation/execute-change-set-request
        (clojure.core/nth args5183 0)))))))
  (clojure.core/defn
   execute-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for executeChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :execute-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   execute-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call executeChangeSet"}
   [credentials5186 & args5187]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5188
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5186)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5188
      executeChangeSet
      (cloudformation/execute-change-set-request
       (clojure.core/nth args5187 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :delete-change-set
   [m5189]
   (clojure.core/let
    [credentials5190 (:credentials m5189) args5191 (:args m5189)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5192
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5190)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5192
       deleteChangeSet
       (cloudformation/delete-change-set-request
        (clojure.core/nth args5191 0)))))))
  (clojure.core/defn
   delete-change-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteChangeSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-change-set,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   delete-change-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         read-limit
                         change-set-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteChangeSet"}
   [credentials5194 & args5195]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5196
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5194)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5196
      deleteChangeSet
      (cloudformation/delete-change-set-request
       (clojure.core/nth args5195 0)))))))
 (do
  (clojure.core/defmethod
   cloudformation
   :get-template-summary
   [m5197]
   (clojure.core/let
    [credentials5198 (:credentials m5197) args5199 (:args m5197)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
      client5200
      (com.palletops.awaze.common/aws-client
       :cloudformation
       credentials5198)]
     (clojure.core/case
      (clojure.core/count args5199)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5200
        getTemplateSummary
        (cloudformation/get-template-summary-request
         (clojure.core/nth args5199 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5200
        getTemplateSummary))))))
  (clojure.core/defn
   get-template-summary-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for getTemplateSummary, getTemplateSummary"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-template-summary,
     :credentials credentials__1842__auto__,
     :client :cloudformation}))
  (clojure.core/defn
   get-template-summary
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         stack-name
                         custom-query-parameters
                         template-body
                         read-limit
                         general-progress-listener
                         clone-source
                         template-url
                         clone-root]}]
                [credentials]]),
    :doc "Call getTemplateSummary, getTemplateSummary"}
   [credentials5202 & args5203]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
     client5204
     (com.palletops.awaze.common/aws-client
      :cloudformation
      credentials5202)]
    (clojure.core/case
     (clojure.core/count args5203)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5204
       getTemplateSummary
       (cloudformation/get-template-summary-request
        (clojure.core/nth args5203 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudformation.AmazonCloudFormationClient}
client5204
       getTemplateSummary)))))))
