(ns
 com.palletops.awaze.cloudfront
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudfront :as cloudfront]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudfront
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudfront.AmazonCloudFrontClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ItemSelection}
item-selection
  [m11957]
  (.
   com.amazonaws.services.cloudfront.model.ItemSelection
   fromValue
   (clojure.core/name m11957)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookieNames}
cookie-names
  [m11960]
  (clojure.core/let
   [bean11959
    (new com.amazonaws.services.cloudfront.model.CookieNames)]
   (clojure.core/let
    [v11961
     (:quantity m11960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11961 :com.palletops.awaze.client-builder/undef)
     (. bean11959 setQuantity (clojure.core/int v11961))))
   (clojure.core/let
    [v11961 (:items m11960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11961 :com.palletops.awaze.client-builder/undef)
     (.
      bean11959
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12121] (clojure.core/str arg12121))
 v11961))))
   bean11959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CookiePreference}
cookie-preference
  [m11963]
  (clojure.core/let
   [bean11962
    (new com.amazonaws.services.cloudfront.model.CookiePreference)]
   (clojure.core/let
    [v11964
     (:forward m11963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11964 :com.palletops.awaze.client-builder/undef)
     (. bean11962 setForward (cloudfront/item-selection v11964))))
   (clojure.core/let
    [v11964
     (:whitelisted-names
      m11963
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11964 :com.palletops.awaze.client-builder/undef)
     (.
      bean11962
      setWhitelistedNames
      (cloudfront/cookie-names v11964))))
   bean11962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Headers}
headers
  [m11966]
  (clojure.core/let
   [bean11965 (new com.amazonaws.services.cloudfront.model.Headers)]
   (clojure.core/let
    [v11967
     (:quantity m11966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11967 :com.palletops.awaze.client-builder/undef)
     (. bean11965 setQuantity (clojure.core/int v11967))))
   (clojure.core/let
    [v11967 (:items m11966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11967 :com.palletops.awaze.client-builder/undef)
     (.
      bean11965
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12122] (clojure.core/str arg12122))
 v11967))))
   bean11965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CachedMethods}
cached-methods
  [m11969]
  (clojure.core/let
   [bean11968
    (new com.amazonaws.services.cloudfront.model.CachedMethods)]
   (clojure.core/let
    [v11970
     (:quantity m11969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11970 :com.palletops.awaze.client-builder/undef)
     (. bean11968 setQuantity (clojure.core/int v11970))))
   (clojure.core/let
    [v11970 (:items m11969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11970 :com.palletops.awaze.client-builder/undef)
     (.
      bean11968
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12123] (clojure.core/str arg12123))
 v11970))))
   bean11968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginCustomHeader}
origin-custom-header
  [m11972]
  (clojure.core/let
   [bean11971
    (new com.amazonaws.services.cloudfront.model.OriginCustomHeader)]
   (clojure.core/let
    [v11973
     (:header-name m11972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11973 :com.palletops.awaze.client-builder/undef)
     (. bean11971 setHeaderName (clojure.core/str v11973))))
   (clojure.core/let
    [v11973
     (:header-value m11972 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11973 :com.palletops.awaze.client-builder/undef)
     (. bean11971 setHeaderValue (clojure.core/str v11973))))
   bean11971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.OriginSslProtocols}
origin-ssl-protocols
  [m11975]
  (clojure.core/let
   [bean11974
    (new com.amazonaws.services.cloudfront.model.OriginSslProtocols)]
   (clojure.core/let
    [v11976
     (:quantity m11975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11976 :com.palletops.awaze.client-builder/undef)
     (. bean11974 setQuantity (clojure.core/int v11976))))
   (clojure.core/let
    [v11976 (:items m11975 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11976 :com.palletops.awaze.client-builder/undef)
     (.
      bean11974
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12124] (clojure.core/str arg12124))
 v11976))))
   bean11974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ForwardedValues}
forwarded-values
  [m11978]
  (clojure.core/let
   [bean11977
    (new com.amazonaws.services.cloudfront.model.ForwardedValues)]
   (clojure.core/let
    [v11979
     (:query-string m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setQueryString (clojure.core/boolean v11979))))
   (clojure.core/let
    [v11979
     (:cookies m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setCookies (cloudfront/cookie-preference v11979))))
   (clojure.core/let
    [v11979
     (:headers m11978 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11979 :com.palletops.awaze.client-builder/undef)
     (. bean11977 setHeaders (cloudfront/headers v11979))))
   bean11977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.TrustedSigners}
trusted-signers
  [m11981]
  (clojure.core/let
   [bean11980
    (new com.amazonaws.services.cloudfront.model.TrustedSigners)]
   (clojure.core/let
    [v11982
     (:quantity m11981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (. bean11980 setQuantity (clojure.core/int v11982))))
   (clojure.core/let
    [v11982
     (:enabled m11981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (. bean11980 setEnabled (clojure.core/boolean v11982))))
   (clojure.core/let
    [v11982 (:items m11981 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11982 :com.palletops.awaze.client-builder/undef)
     (.
      bean11980
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12125] (clojure.core/str arg12125))
 v11982))))
   bean11980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.AllowedMethods}
allowed-methods
  [m11984]
  (clojure.core/let
   [bean11983
    (new com.amazonaws.services.cloudfront.model.AllowedMethods)]
   (clojure.core/let
    [v11985
     (:cached-methods
      m11984
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (. bean11983 setCachedMethods (cloudfront/cached-methods v11985))))
   (clojure.core/let
    [v11985
     (:quantity m11984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (. bean11983 setQuantity (clojure.core/int v11985))))
   (clojure.core/let
    [v11985 (:items m11984 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11985 :com.palletops.awaze.client-builder/undef)
     (.
      bean11983
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12126] (clojure.core/str arg12126))
 v11985))))
   bean11983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomHeaders}
custom-headers
  [m11987]
  (clojure.core/let
   [bean11986
    (new com.amazonaws.services.cloudfront.model.CustomHeaders)]
   (clojure.core/let
    [v11988
     (:quantity m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (. bean11986 setQuantity (clojure.core/int v11988))))
   (clojure.core/let
    [v11988 (:items m11987 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11988 :com.palletops.awaze.client-builder/undef)
     (.
      bean11986
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12127]
  (cloudfront/origin-custom-header arg12127))
 v11988))))
   bean11986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3OriginConfig}
s3origin-config
  [m11990]
  (clojure.core/let
   [bean11989
    (new com.amazonaws.services.cloudfront.model.S3OriginConfig)]
   (clojure.core/let
    [v11991
     (:origin-access-identity
      m11990
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11991 :com.palletops.awaze.client-builder/undef)
     (. bean11989 setOriginAccessIdentity (clojure.core/str v11991))))
   bean11989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomOriginConfig}
custom-origin-config
  [m11993]
  (clojure.core/let
   [bean11992
    (new com.amazonaws.services.cloudfront.model.CustomOriginConfig)]
   (clojure.core/let
    [v11994
     (:httpport m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setHTTPPort (clojure.core/int v11994))))
   (clojure.core/let
    [v11994
     (:httpsport m11993 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setHTTPSPort (clojure.core/int v11994))))
   (clojure.core/let
    [v11994
     (:origin-protocol-policy
      m11993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (. bean11992 setOriginProtocolPolicy (clojure.core/str v11994))))
   (clojure.core/let
    [v11994
     (:origin-ssl-protocols
      m11993
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11994 :com.palletops.awaze.client-builder/undef)
     (.
      bean11992
      setOriginSslProtocols
      (cloudfront/origin-ssl-protocols v11994))))
   bean11992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GeoRestriction}
geo-restriction
  [m11996]
  (clojure.core/let
   [bean11995
    (new com.amazonaws.services.cloudfront.model.GeoRestriction)]
   (clojure.core/let
    [v11997
     (:restriction-type
      m11996
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setRestrictionType (clojure.core/str v11997))))
   (clojure.core/let
    [v11997
     (:quantity m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (. bean11995 setQuantity (clojure.core/int v11997))))
   (clojure.core/let
    [v11997 (:items m11996 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11997 :com.palletops.awaze.client-builder/undef)
     (.
      bean11995
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12128] (clojure.core/str arg12128))
 v11997))))
   bean11995))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehavior}
cache-behavior
  [m11999]
  (clojure.core/let
   [bean11998
    (new com.amazonaws.services.cloudfront.model.CacheBehavior)]
   (clojure.core/let
    [v12000
     (:smooth-streaming
      m11999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setSmoothStreaming (clojure.core/boolean v12000))))
   (clojure.core/let
    [v12000
     (:path-pattern m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setPathPattern (clojure.core/str v12000))))
   (clojure.core/let
    [v12000
     (:forwarded-values
      m11999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (.
      bean11998
      setForwardedValues
      (cloudfront/forwarded-values v12000))))
   (clojure.core/let
    [v12000
     (:trusted-signers
      m11999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (.
      bean11998
      setTrustedSigners
      (cloudfront/trusted-signers v12000))))
   (clojure.core/let
    [v12000
     (:max-ttl m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setMaxTTL (clojure.core/long v12000))))
   (clojure.core/let
    [v12000
     (:viewer-protocol-policy
      m11999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setViewerProtocolPolicy (clojure.core/str v12000))))
   (clojure.core/let
    [v12000
     (:target-origin-id
      m11999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setTargetOriginId (clojure.core/str v12000))))
   (clojure.core/let
    [v12000
     (:default-ttl m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setDefaultTTL (clojure.core/long v12000))))
   (clojure.core/let
    [v12000
     (:compress m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setCompress (clojure.core/boolean v12000))))
   (clojure.core/let
    [v12000
     (:allowed-methods
      m11999
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (.
      bean11998
      setAllowedMethods
      (cloudfront/allowed-methods v12000))))
   (clojure.core/let
    [v12000
     (:min-ttl m11999 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12000 :com.palletops.awaze.client-builder/undef)
     (. bean11998 setMinTTL (clojure.core/long v12000))))
   bean11998))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origin}
origin
  [m12002]
  (clojure.core/let
   [bean12001 (new com.amazonaws.services.cloudfront.model.Origin)]
   (clojure.core/let
    [v12003
     (:origin-path m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setOriginPath (clojure.core/str v12003))))
   (clojure.core/let
    [v12003
     (:custom-headers
      m12002
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setCustomHeaders (cloudfront/custom-headers v12003))))
   (clojure.core/let
    [v12003
     (:s3origin-config
      m12002
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (.
      bean12001
      setS3OriginConfig
      (cloudfront/s3origin-config v12003))))
   (clojure.core/let
    [v12003
     (:custom-origin-config
      m12002
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (.
      bean12001
      setCustomOriginConfig
      (cloudfront/custom-origin-config v12003))))
   (clojure.core/let
    [v12003
     (:domain-name m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setDomainName (clojure.core/str v12003))))
   (clojure.core/let
    [v12003 (:id m12002 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12003 :com.palletops.awaze.client-builder/undef)
     (. bean12001 setId (clojure.core/str v12003))))
   bean12001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponse}
custom-error-response
  [m12005]
  (clojure.core/let
   [bean12004
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponse)]
   (clojure.core/let
    [v12006
     (:response-page-path
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setResponsePagePath (clojure.core/str v12006))))
   (clojure.core/let
    [v12006
     (:response-code m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setResponseCode (clojure.core/str v12006))))
   (clojure.core/let
    [v12006
     (:error-caching-min-ttl
      m12005
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setErrorCachingMinTTL (clojure.core/long v12006))))
   (clojure.core/let
    [v12006
     (:error-code m12005 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12006 :com.palletops.awaze.client-builder/undef)
     (. bean12004 setErrorCode (clojure.core/int v12006))))
   bean12004))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Paths}
paths
  [m12008]
  (clojure.core/let
   [bean12007 (new com.amazonaws.services.cloudfront.model.Paths)]
   (clojure.core/let
    [v12009
     (:quantity m12008 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (. bean12007 setQuantity (clojure.core/int v12009))))
   (clojure.core/let
    [v12009 (:items m12008 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12009 :com.palletops.awaze.client-builder/undef)
     (.
      bean12007
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12129] (clojure.core/str arg12129))
 v12009))))
   bean12007))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Restrictions}
restrictions
  [m12011]
  (clojure.core/let
   [bean12010
    (new com.amazonaws.services.cloudfront.model.Restrictions)]
   (clojure.core/let
    [v12012
     (:geo-restriction
      m12011
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12012 :com.palletops.awaze.client-builder/undef)
     (.
      bean12010
      setGeoRestriction
      (cloudfront/geo-restriction v12012))))
   bean12010))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DefaultCacheBehavior}
default-cache-behavior
  [m12014]
  (clojure.core/let
   [bean12013
    (new com.amazonaws.services.cloudfront.model.DefaultCacheBehavior)]
   (clojure.core/let
    [v12015
     (:smooth-streaming
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setSmoothStreaming (clojure.core/boolean v12015))))
   (clojure.core/let
    [v12015
     (:forwarded-values
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (.
      bean12013
      setForwardedValues
      (cloudfront/forwarded-values v12015))))
   (clojure.core/let
    [v12015
     (:trusted-signers
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (.
      bean12013
      setTrustedSigners
      (cloudfront/trusted-signers v12015))))
   (clojure.core/let
    [v12015
     (:max-ttl m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setMaxTTL (clojure.core/long v12015))))
   (clojure.core/let
    [v12015
     (:viewer-protocol-policy
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setViewerProtocolPolicy (clojure.core/str v12015))))
   (clojure.core/let
    [v12015
     (:target-origin-id
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setTargetOriginId (clojure.core/str v12015))))
   (clojure.core/let
    [v12015
     (:default-ttl m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setDefaultTTL (clojure.core/long v12015))))
   (clojure.core/let
    [v12015
     (:compress m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setCompress (clojure.core/boolean v12015))))
   (clojure.core/let
    [v12015
     (:allowed-methods
      m12014
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (.
      bean12013
      setAllowedMethods
      (cloudfront/allowed-methods v12015))))
   (clojure.core/let
    [v12015
     (:min-ttl m12014 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12015 :com.palletops.awaze.client-builder/undef)
     (. bean12013 setMinTTL (clojure.core/long v12015))))
   bean12013))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CacheBehaviors}
cache-behaviors
  [m12017]
  (clojure.core/let
   [bean12016
    (new com.amazonaws.services.cloudfront.model.CacheBehaviors)]
   (clojure.core/let
    [v12018
     (:quantity m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (. bean12016 setQuantity (clojure.core/int v12018))))
   (clojure.core/let
    [v12018 (:items m12017 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12018 :com.palletops.awaze.client-builder/undef)
     (.
      bean12016
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12130] (cloudfront/cache-behavior arg12130))
 v12018))))
   bean12016))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ViewerCertificate}
viewer-certificate
  [m12020]
  (clojure.core/let
   [bean12019
    (new com.amazonaws.services.cloudfront.model.ViewerCertificate)]
   (clojure.core/let
    [v12021
     (:cloud-front-default-certificate
      m12020
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (.
      bean12019
      setCloudFrontDefaultCertificate
      (clojure.core/boolean v12021))))
   (clojure.core/let
    [v12021
     (:iamcertificate-id
      m12020
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setIAMCertificateId (clojure.core/str v12021))))
   (clojure.core/let
    [v12021
     (:acmcertificate-arn
      m12020
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setACMCertificateArn (clojure.core/str v12021))))
   (clojure.core/let
    [v12021
     (:sslsupport-method
      m12020
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setSSLSupportMethod (clojure.core/str v12021))))
   (clojure.core/let
    [v12021
     (:minimum-protocol-version
      m12020
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setMinimumProtocolVersion (clojure.core/str v12021))))
   (clojure.core/let
    [v12021
     (:certificate m12020 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setCertificate (clojure.core/str v12021))))
   (clojure.core/let
    [v12021
     (:certificate-source
      m12020
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12021 :com.palletops.awaze.client-builder/undef)
     (. bean12019 setCertificateSource (clojure.core/str v12021))))
   bean12019))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Aliases}
aliases
  [m12023]
  (clojure.core/let
   [bean12022 (new com.amazonaws.services.cloudfront.model.Aliases)]
   (clojure.core/let
    [v12024
     (:quantity m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (. bean12022 setQuantity (clojure.core/int v12024))))
   (clojure.core/let
    [v12024 (:items m12023 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12024 :com.palletops.awaze.client-builder/undef)
     (.
      bean12022
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12131] (clojure.core/str arg12131))
 v12024))))
   bean12022))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.PriceClass}
price-class
  [m12026]
  (.
   com.amazonaws.services.cloudfront.model.PriceClass
   fromValue
   (clojure.core/name m12026)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.Origins}
origins
  [m12029]
  (clojure.core/let
   [bean12028 (new com.amazonaws.services.cloudfront.model.Origins)]
   (clojure.core/let
    [v12030
     (:quantity m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (. bean12028 setQuantity (clojure.core/int v12030))))
   (clojure.core/let
    [v12030 (:items m12029 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12030 :com.palletops.awaze.client-builder/undef)
     (.
      bean12028
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg12132] (cloudfront/origin arg12132))
 v12030))))
   bean12028))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.LoggingConfig}
logging-config
  [m12032]
  (clojure.core/let
   [bean12031
    (new com.amazonaws.services.cloudfront.model.LoggingConfig)]
   (clojure.core/let
    [v12033
     (:include-cookies
      m12032
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setIncludeCookies (clojure.core/boolean v12033))))
   (clojure.core/let
    [v12033
     (:prefix m12032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setPrefix (clojure.core/str v12033))))
   (clojure.core/let
    [v12033
     (:bucket m12032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setBucket (clojure.core/str v12033))))
   (clojure.core/let
    [v12033
     (:enabled m12032 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12033 :com.palletops.awaze.client-builder/undef)
     (. bean12031 setEnabled (clojure.core/boolean v12033))))
   bean12031))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CustomErrorResponses}
custom-error-responses
  [m12035]
  (clojure.core/let
   [bean12034
    (new com.amazonaws.services.cloudfront.model.CustomErrorResponses)]
   (clojure.core/let
    [v12036
     (:quantity m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (. bean12034 setQuantity (clojure.core/int v12036))))
   (clojure.core/let
    [v12036 (:items m12035 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12036 :com.palletops.awaze.client-builder/undef)
     (.
      bean12034
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg12133]
  (cloudfront/custom-error-response arg12133))
 v12036))))
   bean12034))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingLoggingConfig}
streaming-logging-config
  [m12038]
  (clojure.core/let
   [bean12037
    (new
     com.amazonaws.services.cloudfront.model.StreamingLoggingConfig)]
   (clojure.core/let
    [v12039
     (:prefix m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setPrefix (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:bucket m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setBucket (clojure.core/str v12039))))
   (clojure.core/let
    [v12039
     (:enabled m12038 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12039 :com.palletops.awaze.client-builder/undef)
     (. bean12037 setEnabled (clojure.core/boolean v12039))))
   bean12037))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.S3Origin}
s3origin
  [m12041]
  (clojure.core/let
   [bean12040 (new com.amazonaws.services.cloudfront.model.S3Origin)]
   (clojure.core/let
    [v12042
     (:origin-access-identity
      m12041
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setOriginAccessIdentity (clojure.core/str v12042))))
   (clojure.core/let
    [v12042
     (:domain-name m12041 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12042 :com.palletops.awaze.client-builder/undef)
     (. bean12040 setDomainName (clojure.core/str v12042))))
   bean12040))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.InvalidationBatch}
invalidation-batch
  [m12044]
  (clojure.core/let
   [bean12043
    (new com.amazonaws.services.cloudfront.model.InvalidationBatch)]
   (clojure.core/let
    [v12045
     (:caller-reference
      m12044
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setCallerReference (clojure.core/str v12045))))
   (clojure.core/let
    [v12045 (:paths m12044 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12045 :com.palletops.awaze.client-builder/undef)
     (. bean12043 setPaths (cloudfront/paths v12045))))
   bean12043))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DistributionConfig}
distribution-config
  [m12047]
  (clojure.core/let
   [bean12046
    (new com.amazonaws.services.cloudfront.model.DistributionConfig)]
   (clojure.core/let
    [v12048
     (:restrictions m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setRestrictions (cloudfront/restrictions v12048))))
   (clojure.core/let
    [v12048
     (:default-root-object
      m12047
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setDefaultRootObject (clojure.core/str v12048))))
   (clojure.core/let
    [v12048
     (:default-cache-behavior
      m12047
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (.
      bean12046
      setDefaultCacheBehavior
      (cloudfront/default-cache-behavior v12048))))
   (clojure.core/let
    [v12048
     (:comment m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setComment (clojure.core/str v12048))))
   (clojure.core/let
    [v12048
     (:cache-behaviors
      m12047
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (.
      bean12046
      setCacheBehaviors
      (cloudfront/cache-behaviors v12048))))
   (clojure.core/let
    [v12048
     (:viewer-certificate
      m12047
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (.
      bean12046
      setViewerCertificate
      (cloudfront/viewer-certificate v12048))))
   (clojure.core/let
    [v12048
     (:aliases m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setAliases (cloudfront/aliases v12048))))
   (clojure.core/let
    [v12048
     (:enabled m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setEnabled (clojure.core/boolean v12048))))
   (clojure.core/let
    [v12048
     (:price-class m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setPriceClass (cloudfront/price-class v12048))))
   (clojure.core/let
    [v12048
     (:origins m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setOrigins (cloudfront/origins v12048))))
   (clojure.core/let
    [v12048
     (:caller-reference
      m12047
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setCallerReference (clojure.core/str v12048))))
   (clojure.core/let
    [v12048
     (:logging m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setLogging (cloudfront/logging-config v12048))))
   (clojure.core/let
    [v12048
     (:web-aclid m12047 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (. bean12046 setWebACLId (clojure.core/str v12048))))
   (clojure.core/let
    [v12048
     (:custom-error-responses
      m12047
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12048 :com.palletops.awaze.client-builder/undef)
     (.
      bean12046
      setCustomErrorResponses
      (cloudfront/custom-error-responses v12048))))
   bean12046))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig}
cloud-front-origin-access-identity-config
  [m12050]
  (clojure.core/let
   [bean12049
    (new
     com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig)]
   (clojure.core/let
    [v12051
     (:comment m12050 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setComment (clojure.core/str v12051))))
   (clojure.core/let
    [v12051
     (:caller-reference
      m12050
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12051 :com.palletops.awaze.client-builder/undef)
     (. bean12049 setCallerReference (clojure.core/str v12051))))
   bean12049))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.StreamingDistributionConfig}
streaming-distribution-config
  [m12053]
  (clojure.core/let
   [bean12052
    (new
     com.amazonaws.services.cloudfront.model.StreamingDistributionConfig)]
   (clojure.core/let
    [v12054
     (:comment m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setComment (clojure.core/str v12054))))
   (clojure.core/let
    [v12054
     (:caller-reference
      m12053
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setCallerReference (clojure.core/str v12054))))
   (clojure.core/let
    [v12054
     (:aliases m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setAliases (cloudfront/aliases v12054))))
   (clojure.core/let
    [v12054
     (:logging m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (.
      bean12052
      setLogging
      (cloudfront/streaming-logging-config v12054))))
   (clojure.core/let
    [v12054
     (:trusted-signers
      m12053
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (.
      bean12052
      setTrustedSigners
      (cloudfront/trusted-signers v12054))))
   (clojure.core/let
    [v12054
     (:s3origin m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setS3Origin (cloudfront/s3origin v12054))))
   (clojure.core/let
    [v12054
     (:price-class m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setPriceClass (clojure.core/str v12054))))
   (clojure.core/let
    [v12054
     (:enabled m12053 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12054 :com.palletops.awaze.client-builder/undef)
     (. bean12052 setEnabled (clojure.core/boolean v12054))))
   bean12052))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest}
get-streaming-distribution-request
  [m12056]
  (clojure.core/let
   [bean12055
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionRequest)]
   (clojure.core/let
    [v12057 (:id m12056 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12057 :com.palletops.awaze.client-builder/undef)
     (. bean12055 setId (clojure.core/str v12057))))
   bean12055))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateInvalidationRequest}
create-invalidation-request
  [m12059]
  (clojure.core/let
   [bean12058
    (new
     com.amazonaws.services.cloudfront.model.CreateInvalidationRequest)]
   (clojure.core/let
    [v12060
     (:distribution-id
      m12059
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12060 :com.palletops.awaze.client-builder/undef)
     (. bean12058 setDistributionId (clojure.core/str v12060))))
   (clojure.core/let
    [v12060
     (:invalidation-batch
      m12059
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12060 :com.palletops.awaze.client-builder/undef)
     (.
      bean12058
      setInvalidationBatch
      (cloudfront/invalidation-batch v12060))))
   bean12058))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteDistributionRequest}
delete-distribution-request
  [m12062]
  (clojure.core/let
   [bean12061
    (new
     com.amazonaws.services.cloudfront.model.DeleteDistributionRequest)]
   (clojure.core/let
    [v12063
     (:if-match m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setIfMatch (clojure.core/str v12063))))
   (clojure.core/let
    [v12063 (:id m12062 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12063 :com.palletops.awaze.client-builder/undef)
     (. bean12061 setId (clojure.core/str v12063))))
   bean12061))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest}
delete-cloud-front-origin-access-identity-request
  [m12065]
  (clojure.core/let
   [bean12064
    (new
     com.amazonaws.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12066
     (:if-match m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setIfMatch (clojure.core/str v12066))))
   (clojure.core/let
    [v12066 (:id m12065 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12066 :com.palletops.awaze.client-builder/undef)
     (. bean12064 setId (clojure.core/str v12066))))
   bean12064))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateDistributionRequest}
create-distribution-request
  [m12068]
  (clojure.core/let
   [bean12067
    (new
     com.amazonaws.services.cloudfront.model.CreateDistributionRequest)]
   (clojure.core/let
    [v12069
     (:distribution-config
      m12068
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12069 :com.palletops.awaze.client-builder/undef)
     (.
      bean12067
      setDistributionConfig
      (cloudfront/distribution-config v12069))))
   bean12067))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListInvalidationsRequest}
list-invalidations-request
  [m12071]
  (clojure.core/let
   [bean12070
    (new
     com.amazonaws.services.cloudfront.model.ListInvalidationsRequest)]
   (clojure.core/let
    [v12072
     (:distribution-id
      m12071
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setDistributionId (clojure.core/str v12072))))
   (clojure.core/let
    [v12072
     (:marker m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setMarker (clojure.core/str v12072))))
   (clojure.core/let
    [v12072
     (:max-items m12071 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12072 :com.palletops.awaze.client-builder/undef)
     (. bean12070 setMaxItems (clojure.core/str v12072))))
   bean12070))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest}
list-streaming-distributions-request
  [m12074]
  (clojure.core/let
   [bean12073
    (new
     com.amazonaws.services.cloudfront.model.ListStreamingDistributionsRequest)]
   (clojure.core/let
    [v12075
     (:marker m12074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12075 :com.palletops.awaze.client-builder/undef)
     (. bean12073 setMarker (clojure.core/str v12075))))
   (clojure.core/let
    [v12075
     (:max-items m12074 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12075 :com.palletops.awaze.client-builder/undef)
     (. bean12073 setMaxItems (clojure.core/str v12075))))
   bean12073))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest}
get-cloud-front-origin-access-identity-config-request
  [m12077]
  (clojure.core/let
   [bean12076
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest)]
   (clojure.core/let
    [v12078 (:id m12077 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12078 :com.palletops.awaze.client-builder/undef)
     (. bean12076 setId (clojure.core/str v12078))))
   bean12076))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsRequest}
list-distributions-request
  [m12080]
  (clojure.core/let
   [bean12079
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsRequest)]
   (clojure.core/let
    [v12081
     (:marker m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setMarker (clojure.core/str v12081))))
   (clojure.core/let
    [v12081
     (:max-items m12080 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12081 :com.palletops.awaze.client-builder/undef)
     (. bean12079 setMaxItems (clojure.core/str v12081))))
   bean12079))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest}
create-cloud-front-origin-access-identity-request
  [m12083]
  (clojure.core/let
   [bean12082
    (new
     com.amazonaws.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12084
     (:cloud-front-origin-access-identity-config
      m12083
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12084 :com.palletops.awaze.client-builder/undef)
     (.
      bean12082
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12084))))
   bean12082))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest}
update-streaming-distribution-request
  [m12086]
  (clojure.core/let
   [bean12085
    (new
     com.amazonaws.services.cloudfront.model.UpdateStreamingDistributionRequest)]
   (clojure.core/let
    [v12087
     (:streaming-distribution-config
      m12086
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (.
      bean12085
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12087))))
   (clojure.core/let
    [v12087
     (:if-match m12086 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (. bean12085 setIfMatch (clojure.core/str v12087))))
   (clojure.core/let
    [v12087 (:id m12086 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12087 :com.palletops.awaze.client-builder/undef)
     (. bean12085 setId (clojure.core/str v12087))))
   bean12085))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest}
list-distributions-by-web-aclid-request
  [m12089]
  (clojure.core/let
   [bean12088
    (new
     com.amazonaws.services.cloudfront.model.ListDistributionsByWebACLIdRequest)]
   (clojure.core/let
    [v12090
     (:web-aclid m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setWebACLId (clojure.core/str v12090))))
   (clojure.core/let
    [v12090
     (:marker m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setMarker (clojure.core/str v12090))))
   (clojure.core/let
    [v12090
     (:max-items m12089 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12090 :com.palletops.awaze.client-builder/undef)
     (. bean12088 setMaxItems (clojure.core/str v12090))))
   bean12088))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest}
list-cloud-front-origin-access-identities-request
  [m12092]
  (clojure.core/let
   [bean12091
    (new
     com.amazonaws.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest)]
   (clojure.core/let
    [v12093
     (:marker m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setMarker (clojure.core/str v12093))))
   (clojure.core/let
    [v12093
     (:max-items m12092 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12093 :com.palletops.awaze.client-builder/undef)
     (. bean12091 setMaxItems (clojure.core/str v12093))))
   bean12091))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionRequest}
get-distribution-request
  [m12095]
  (clojure.core/let
   [bean12094
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionRequest)]
   (clojure.core/let
    [v12096 (:id m12095 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12096 :com.palletops.awaze.client-builder/undef)
     (. bean12094 setId (clojure.core/str v12096))))
   bean12094))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest}
delete-streaming-distribution-request
  [m12098]
  (clojure.core/let
   [bean12097
    (new
     com.amazonaws.services.cloudfront.model.DeleteStreamingDistributionRequest)]
   (clojure.core/let
    [v12099
     (:if-match m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setIfMatch (clojure.core/str v12099))))
   (clojure.core/let
    [v12099 (:id m12098 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12099 :com.palletops.awaze.client-builder/undef)
     (. bean12097 setId (clojure.core/str v12099))))
   bean12097))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest}
get-distribution-config-request
  [m12101]
  (clojure.core/let
   [bean12100
    (new
     com.amazonaws.services.cloudfront.model.GetDistributionConfigRequest)]
   (clojure.core/let
    [v12102 (:id m12101 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12102 :com.palletops.awaze.client-builder/undef)
     (. bean12100 setId (clojure.core/str v12102))))
   bean12100))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateDistributionRequest}
update-distribution-request
  [m12104]
  (clojure.core/let
   [bean12103
    (new
     com.amazonaws.services.cloudfront.model.UpdateDistributionRequest)]
   (clojure.core/let
    [v12105
     (:distribution-config
      m12104
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (.
      bean12103
      setDistributionConfig
      (cloudfront/distribution-config v12105))))
   (clojure.core/let
    [v12105
     (:if-match m12104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setIfMatch (clojure.core/str v12105))))
   (clojure.core/let
    [v12105 (:id m12104 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12105 :com.palletops.awaze.client-builder/undef)
     (. bean12103 setId (clojure.core/str v12105))))
   bean12103))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest}
get-cloud-front-origin-access-identity-request
  [m12107]
  (clojure.core/let
   [bean12106
    (new
     com.amazonaws.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12108 (:id m12107 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12108 :com.palletops.awaze.client-builder/undef)
     (. bean12106 setId (clojure.core/str v12108))))
   bean12106))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest}
get-streaming-distribution-config-request
  [m12110]
  (clojure.core/let
   [bean12109
    (new
     com.amazonaws.services.cloudfront.model.GetStreamingDistributionConfigRequest)]
   (clojure.core/let
    [v12111 (:id m12110 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12111 :com.palletops.awaze.client-builder/undef)
     (. bean12109 setId (clojure.core/str v12111))))
   bean12109))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest}
update-cloud-front-origin-access-identity-request
  [m12113]
  (clojure.core/let
   [bean12112
    (new
     com.amazonaws.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest)]
   (clojure.core/let
    [v12114
     (:cloud-front-origin-access-identity-config
      m12113
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12114 :com.palletops.awaze.client-builder/undef)
     (.
      bean12112
      setCloudFrontOriginAccessIdentityConfig
      (cloudfront/cloud-front-origin-access-identity-config v12114))))
   (clojure.core/let
    [v12114
     (:if-match m12113 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12114 :com.palletops.awaze.client-builder/undef)
     (. bean12112 setIfMatch (clojure.core/str v12114))))
   (clojure.core/let
    [v12114 (:id m12113 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12114 :com.palletops.awaze.client-builder/undef)
     (. bean12112 setId (clojure.core/str v12114))))
   bean12112))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest}
create-streaming-distribution-request
  [m12116]
  (clojure.core/let
   [bean12115
    (new
     com.amazonaws.services.cloudfront.model.CreateStreamingDistributionRequest)]
   (clojure.core/let
    [v12117
     (:streaming-distribution-config
      m12116
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12117 :com.palletops.awaze.client-builder/undef)
     (.
      bean12115
      setStreamingDistributionConfig
      (cloudfront/streaming-distribution-config v12117))))
   bean12115))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudfront.model.GetInvalidationRequest}
get-invalidation-request
  [m12119]
  (clojure.core/let
   [bean12118
    (new
     com.amazonaws.services.cloudfront.model.GetInvalidationRequest)]
   (clojure.core/let
    [v12120
     (:distribution-id
      m12119
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12120 :com.palletops.awaze.client-builder/undef)
     (. bean12118 setDistributionId (clojure.core/str v12120))))
   (clojure.core/let
    [v12120 (:id m12119 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v12120 :com.palletops.awaze.client-builder/undef)
     (. bean12118 setId (clojure.core/str v12120))))
   bean12118))
 (clojure.core/defmulti
  cloudfront
  (clojure.core/fn cloudfront [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution
   [m12134]
   (clojure.core/let
    [credentials12135 (:credentials m12134) args12136 (:args m12134)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12137
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12135)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12137
       getStreamingDistribution
       (cloudfront/get-streaming-distribution-request
        (clojure.core/nth args12136 0)))))))
  (clojure.core/defn
   get-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistribution"}
   [credentials12139 & args12140]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12141
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12139)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12141
      getStreamingDistribution
      (cloudfront/get-streaming-distribution-request
       (clojure.core/nth args12140 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-invalidation
   [m12142]
   (clojure.core/let
    [credentials12143 (:credentials m12142) args12144 (:args m12142)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12145
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12143)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12145
       createInvalidation
       (cloudfront/create-invalidation-request
        (clojure.core/nth args12144 0)))))))
  (clojure.core/defn
   create-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [invalidation-batch
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createInvalidation"}
   [credentials12147 & args12148]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12149
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12147)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12149
      createInvalidation
      (cloudfront/create-invalidation-request
       (clojure.core/nth args12148 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-distribution
   [m12150]
   (clojure.core/let
    [credentials12151 (:credentials m12150) args12152 (:args m12150)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12153
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12151)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12153
       deleteDistribution
       (cloudfront/delete-distribution-request
        (clojure.core/nth args12152 0)))))))
  (clojure.core/defn
   delete-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDistribution"}
   [credentials12155 & args12156]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12157
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12155)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12157
      deleteDistribution
      (cloudfront/delete-distribution-request
       (clojure.core/nth args12156 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-cloud-front-origin-access-identity
   [m12158]
   (clojure.core/let
    [credentials12159 (:credentials m12158) args12160 (:args m12158)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12161
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12159)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12161
       deleteCloudFrontOriginAccessIdentity
       (cloudfront/delete-cloud-front-origin-access-identity-request
        (clojure.core/nth args12160 0)))))))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteCloudFrontOriginAccessIdentity"}
   [credentials12163 & args12164]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12165
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12163)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12165
      deleteCloudFrontOriginAccessIdentity
      (cloudfront/delete-cloud-front-origin-access-identity-request
       (clojure.core/nth args12164 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-distribution
   [m12166]
   (clojure.core/let
    [credentials12167 (:credentials m12166) args12168 (:args m12166)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12169
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12167)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12169
       createDistribution
       (cloudfront/create-distribution-request
        (clojure.core/nth args12168 0)))))))
  (clojure.core/defn
   create-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDistribution"}
   [credentials12171 & args12172]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12173
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12171)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12173
      createDistribution
      (cloudfront/create-distribution-request
       (clojure.core/nth args12172 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-invalidations
   [m12174]
   (clojure.core/let
    [credentials12175 (:credentials m12174) args12176 (:args m12174)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12177
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12175)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12177
       listInvalidations
       (cloudfront/list-invalidations-request
        (clojure.core/nth args12176 0)))))))
  (clojure.core/defn
   list-invalidations-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listInvalidations"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-invalidations,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-invalidations
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         distribution-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listInvalidations"}
   [credentials12179 & args12180]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12181
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12179)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12181
      listInvalidations
      (cloudfront/list-invalidations-request
       (clojure.core/nth args12180 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-streaming-distributions
   [m12182]
   (clojure.core/let
    [credentials12183 (:credentials m12182) args12184 (:args m12182)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12185
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12183)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12185
       listStreamingDistributions
       (cloudfront/list-streaming-distributions-request
        (clojure.core/nth args12184 0)))))))
  (clojure.core/defn
   list-streaming-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listStreamingDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-streaming-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-streaming-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listStreamingDistributions"}
   [credentials12187 & args12188]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12189
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12187)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12189
      listStreamingDistributions
      (cloudfront/list-streaming-distributions-request
       (clojure.core/nth args12188 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity-config
   [m12190]
   (clojure.core/let
    [credentials12191 (:credentials m12190) args12192 (:args m12190)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12193
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12191)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12193
       getCloudFrontOriginAccessIdentityConfig
       (cloudfront/get-cloud-front-origin-access-identity-config-request
        (clojure.core/nth args12192 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentityConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentityConfig"}
   [credentials12195 & args12196]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12197
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12195)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12197
      getCloudFrontOriginAccessIdentityConfig
      (cloudfront/get-cloud-front-origin-access-identity-config-request
       (clojure.core/nth args12196 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions
   [m12198]
   (clojure.core/let
    [credentials12199 (:credentials m12198) args12200 (:args m12198)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12201
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12199)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12201
       listDistributions
       (cloudfront/list-distributions-request
        (clojure.core/nth args12200 0)))))))
  (clojure.core/defn
   list-distributions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributions"}
   [credentials12203 & args12204]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12205
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12203)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12205
      listDistributions
      (cloudfront/list-distributions-request
       (clojure.core/nth args12204 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-cloud-front-origin-access-identity
   [m12206]
   (clojure.core/let
    [credentials12207 (:credentials m12206) args12208 (:args m12206)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12209
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12207)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12209
       createCloudFrontOriginAccessIdentity
       (cloudfront/create-cloud-front-origin-access-identity-request
        (clojure.core/nth args12208 0)))))))
  (clojure.core/defn
   create-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createCloudFrontOriginAccessIdentity"}
   [credentials12211 & args12212]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12213
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12211)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12213
      createCloudFrontOriginAccessIdentity
      (cloudfront/create-cloud-front-origin-access-identity-request
       (clojure.core/nth args12212 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-streaming-distribution
   [m12214]
   (clojure.core/let
    [credentials12215 (:credentials m12214) args12216 (:args m12214)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12217
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12215)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12217
       updateStreamingDistribution
       (cloudfront/update-streaming-distribution-request
        (clojure.core/nth args12216 0)))))))
  (clojure.core/defn
   update-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStreamingDistribution"}
   [credentials12219 & args12220]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12221
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12219)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12221
      updateStreamingDistribution
      (cloudfront/update-streaming-distribution-request
       (clojure.core/nth args12220 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-distributions-by-web-aclid
   [m12222]
   (clojure.core/let
    [credentials12223 (:credentials m12222) args12224 (:args m12222)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12225
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12223)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12225
       listDistributionsByWebACLId
       (cloudfront/list-distributions-by-web-aclid-request
        (clojure.core/nth args12224 0)))))))
  (clojure.core/defn
   list-distributions-by-web-aclid-map
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listDistributionsByWebACLId"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-distributions-by-web-aclid,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-distributions-by-web-aclid
   {:arglists (quote
               [[credentials
                 {:keys [web-aclid
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listDistributionsByWebACLId"}
   [credentials12227 & args12228]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12229
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12227)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12229
      listDistributionsByWebACLId
      (cloudfront/list-distributions-by-web-aclid-request
       (clojure.core/nth args12228 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :list-cloud-front-origin-access-identities
   [m12230]
   (clojure.core/let
    [credentials12231 (:credentials m12230) args12232 (:args m12230)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12233
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12231)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12233
       listCloudFrontOriginAccessIdentities
       (cloudfront/list-cloud-front-origin-access-identities-request
        (clojure.core/nth args12232 0)))))))
  (clojure.core/defn
   list-cloud-front-origin-access-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listCloudFrontOriginAccessIdentities"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-cloud-front-origin-access-identities,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   list-cloud-front-origin-access-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listCloudFrontOriginAccessIdentities"}
   [credentials12235 & args12236]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12237
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12235)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12237
      listCloudFrontOriginAccessIdentities
      (cloudfront/list-cloud-front-origin-access-identities-request
       (clojure.core/nth args12236 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution
   [m12238]
   (clojure.core/let
    [credentials12239 (:credentials m12238) args12240 (:args m12238)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12241
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12239)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12241
       getDistribution
       (cloudfront/get-distribution-request
        (clojure.core/nth args12240 0)))))))
  (clojure.core/defn
   get-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistribution"}
   [credentials12243 & args12244]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12245
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12243)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12245
      getDistribution
      (cloudfront/get-distribution-request
       (clojure.core/nth args12244 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :delete-streaming-distribution
   [m12246]
   (clojure.core/let
    [credentials12247 (:credentials m12246) args12248 (:args m12246)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12249
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12247)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12249
       deleteStreamingDistribution
       (cloudfront/delete-streaming-distribution-request
        (clojure.core/nth args12248 0)))))))
  (clojure.core/defn
   delete-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   delete-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteStreamingDistribution"}
   [credentials12251 & args12252]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12253
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12251)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12253
      deleteStreamingDistribution
      (cloudfront/delete-streaming-distribution-request
       (clojure.core/nth args12252 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-distribution-config
   [m12254]
   (clojure.core/let
    [credentials12255 (:credentials m12254) args12256 (:args m12254)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12257
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12255)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12257
       getDistributionConfig
       (cloudfront/get-distribution-config-request
        (clojure.core/nth args12256 0)))))))
  (clojure.core/defn
   get-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDistributionConfig"}
   [credentials12259 & args12260]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12261
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12259)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12261
      getDistributionConfig
      (cloudfront/get-distribution-config-request
       (clojure.core/nth args12260 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-distribution
   [m12262]
   (clojure.core/let
    [credentials12263 (:credentials m12262) args12264 (:args m12262)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12265
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12263)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12265
       updateDistribution
       (cloudfront/update-distribution-request
        (clojure.core/nth args12264 0)))))))
  (clojure.core/defn
   update-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         custom-query-parameters
                         distribution-config
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateDistribution"}
   [credentials12267 & args12268]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12269
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12267)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12269
      updateDistribution
      (cloudfront/update-distribution-request
       (clojure.core/nth args12268 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-cloud-front-origin-access-identity
   [m12270]
   (clojure.core/let
    [credentials12271 (:credentials m12270) args12272 (:args m12270)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12273
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12271)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12273
       getCloudFrontOriginAccessIdentity
       (cloudfront/get-cloud-front-origin-access-identity-request
        (clojure.core/nth args12272 0)))))))
  (clojure.core/defn
   get-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getCloudFrontOriginAccessIdentity"}
   [credentials12275 & args12276]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12277
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12275)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12277
      getCloudFrontOriginAccessIdentity
      (cloudfront/get-cloud-front-origin-access-identity-request
       (clojure.core/nth args12276 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-streaming-distribution-config
   [m12278]
   (clojure.core/let
    [credentials12279 (:credentials m12278) args12280 (:args m12278)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12281
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12279)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12281
       getStreamingDistributionConfig
       (cloudfront/get-streaming-distribution-config-request
        (clojure.core/nth args12280 0)))))))
  (clojure.core/defn
   get-streaming-distribution-config-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getStreamingDistributionConfig"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-streaming-distribution-config,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-streaming-distribution-config
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getStreamingDistributionConfig"}
   [credentials12283 & args12284]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12285
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12283)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12285
      getStreamingDistributionConfig
      (cloudfront/get-streaming-distribution-config-request
       (clojure.core/nth args12284 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :update-cloud-front-origin-access-identity
   [m12286]
   (clojure.core/let
    [credentials12287 (:credentials m12286) args12288 (:args m12286)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12289
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12287)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12289
       updateCloudFrontOriginAccessIdentity
       (cloudfront/update-cloud-front-origin-access-identity-request
        (clojure.core/nth args12288 0)))))))
  (clojure.core/defn
   update-cloud-front-origin-access-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateCloudFrontOriginAccessIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-cloud-front-origin-access-identity,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   update-cloud-front-origin-access-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         if-match
                         cloud-front-origin-access-identity-config
                         custom-query-parameters
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateCloudFrontOriginAccessIdentity"}
   [credentials12291 & args12292]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12293
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12291)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12293
      updateCloudFrontOriginAccessIdentity
      (cloudfront/update-cloud-front-origin-access-identity-request
       (clojure.core/nth args12292 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :create-streaming-distribution
   [m12294]
   (clojure.core/let
    [credentials12295 (:credentials m12294) args12296 (:args m12294)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12297
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12295)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12297
       createStreamingDistribution
       (cloudfront/create-streaming-distribution-request
        (clojure.core/nth args12296 0)))))))
  (clojure.core/defn
   create-streaming-distribution-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createStreamingDistribution"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-streaming-distribution,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   create-streaming-distribution
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         streaming-distribution-config
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createStreamingDistribution"}
   [credentials12299 & args12300]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12301
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12299)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12301
      createStreamingDistribution
      (cloudfront/create-streaming-distribution-request
       (clojure.core/nth args12300 0)))))))
 (do
  (clojure.core/defmethod
   cloudfront
   :get-invalidation
   [m12302]
   (clojure.core/let
    [credentials12303 (:credentials m12302) args12304 (:args m12302)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
      client12305
      (com.palletops.awaze.common/aws-client
       :cloudfront
       credentials12303)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12305
       getInvalidation
       (cloudfront/get-invalidation-request
        (clojure.core/nth args12304 0)))))))
  (clojure.core/defn
   get-invalidation-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getInvalidation"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-invalidation,
     :credentials credentials__1842__auto__,
     :client :cloudfront}))
  (clojure.core/defn
   get-invalidation
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         distribution-id
                         read-limit
                         id
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getInvalidation"}
   [credentials12307 & args12308]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
     client12309
     (com.palletops.awaze.common/aws-client
      :cloudfront
      credentials12307)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudfront.AmazonCloudFrontClient}
client12309
      getInvalidation
      (cloudfront/get-invalidation-request
       (clojure.core/nth args12308 0))))))))
