(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m7873]
  (clojure.core/let
   [bean7872
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/let
    [v7874
     (:default-value m7873 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7874 :com.palletops.awaze.client-builder/undef)
     (. bean7872 setDefaultValue (clojure.core/str v7874))))
   (clojure.core/let
    [v7874
     (:source-name m7873 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7874 :com.palletops.awaze.client-builder/undef)
     (. bean7872 setSourceName (clojure.core/str v7874))))
   bean7872))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m7876]
  (clojure.core/let
   [bean7875
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/let
    [v7877
     (:default-value m7876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7877 :com.palletops.awaze.client-builder/undef)
     (. bean7875 setDefaultValue (clojure.core/str v7877))))
   (clojure.core/let
    [v7877
     (:source-name m7876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7877 :com.palletops.awaze.client-builder/undef)
     (. bean7875 setSourceName (clojure.core/str v7877))))
   (clojure.core/let
    [v7877
     (:separator m7876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7877 :com.palletops.awaze.client-builder/undef)
     (. bean7875 setSeparator (clojure.core/str v7877))))
   (clojure.core/let
    [v7877
     (:language m7876 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7877 :com.palletops.awaze.client-builder/undef)
     (. bean7875 setLanguage (clojure.core/str v7877))))
   bean7875))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m7879]
  (clojure.core/let
   [bean7878
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/let
    [v7880
     (:default-value m7879 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7880 :com.palletops.awaze.client-builder/undef)
     (. bean7878 setDefaultValue (clojure.core/str v7880))))
   (clojure.core/let
    [v7880
     (:source-name m7879 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7880 :com.palletops.awaze.client-builder/undef)
     (. bean7878 setSourceName (clojure.core/str v7880))))
   (clojure.core/let
    [v7880 (:cases m7879 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7880 :com.palletops.awaze.client-builder/undef)
     (.
      bean7878
      setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg7971] (clojure.core/str arg7971))
  (clojure.core/keys v7880))
 (clojure.core/map
  (clojure.core/fn [arg7971] (clojure.core/str arg7971))
  (clojure.core/vals v7880))))))
   bean7878))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataFunction}
source-data-function
  [m7882]
  (.
   com.amazonaws.services.cloudsearch.model.SourceDataFunction
   fromValue
   (clojure.core/name m7882)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexFieldType}
index-field-type
  [m7885]
  (.
   com.amazonaws.services.cloudsearch.model.IndexFieldType
   fromValue
   (clojure.core/name m7885)))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m7888]
  (clojure.core/let
   [bean7887
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/let
    [v7889
     (:default-value m7888 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7889 :com.palletops.awaze.client-builder/undef)
     (. bean7887 setDefaultValue (clojure.core/int v7889))))
   bean7887))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m7891]
  (clojure.core/let
   [bean7890
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/let
    [v7892
     (:default-value m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setDefaultValue (clojure.core/str v7892))))
   (clojure.core/let
    [v7892
     (:search-enabled m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setSearchEnabled (clojure.core/boolean v7892))))
   (clojure.core/let
    [v7892
     (:facet-enabled m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setFacetEnabled (clojure.core/boolean v7892))))
   (clojure.core/let
    [v7892
     (:result-enabled m7891 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7892 :com.palletops.awaze.client-builder/undef)
     (. bean7890 setResultEnabled (clojure.core/boolean v7892))))
   bean7890))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m7894]
  (clojure.core/let
   [bean7893
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/let
    [v7895
     (:default-value m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setDefaultValue (clojure.core/str v7895))))
   (clojure.core/let
    [v7895
     (:facet-enabled m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setFacetEnabled (clojure.core/boolean v7895))))
   (clojure.core/let
    [v7895
     (:result-enabled m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setResultEnabled (clojure.core/boolean v7895))))
   (clojure.core/let
    [v7895
     (:text-processor m7894 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7895 :com.palletops.awaze.client-builder/undef)
     (. bean7893 setTextProcessor (clojure.core/str v7895))))
   bean7893))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m7897]
  (clojure.core/let
   [bean7896
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/let
    [v7898
     (:source-data-copy
      m7897
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (. bean7896 setSourceDataCopy (cloudsearch/source-data v7898))))
   (clojure.core/let
    [v7898
     (:source-data-trim-title
      m7897
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (.
      bean7896
      setSourceDataTrimTitle
      (cloudsearch/source-data-trim-title v7898))))
   (clojure.core/let
    [v7898
     (:source-data-map
      m7897
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (. bean7896 setSourceDataMap (cloudsearch/source-data-map v7898))))
   (clojure.core/let
    [v7898
     (:source-data-function
      m7897
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7898 :com.palletops.awaze.client-builder/undef)
     (.
      bean7896
      setSourceDataFunction
      (cloudsearch/source-data-function v7898))))
   bean7896))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m7900]
  (clojure.core/let
   [bean7899
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/let
    [v7901
     (:rank-name m7900 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7901 :com.palletops.awaze.client-builder/undef)
     (. bean7899 setRankName (clojure.core/str v7901))))
   (clojure.core/let
    [v7901
     (:rank-expression
      m7900
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7901 :com.palletops.awaze.client-builder/undef)
     (. bean7899 setRankExpression (clojure.core/str v7901))))
   bean7899))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m7903]
  (clojure.core/let
   [bean7902
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/let
    [v7904
     (:index-field-name
      m7903
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (. bean7902 setIndexFieldName (clojure.core/str v7904))))
   (clojure.core/let
    [v7904
     (:index-field-type
      m7903
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (.
      bean7902
      setIndexFieldType
      (cloudsearch/index-field-type v7904))))
   (clojure.core/let
    [v7904
     (:uint-options m7903 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (. bean7902 setUIntOptions (cloudsearch/uint-options v7904))))
   (clojure.core/let
    [v7904
     (:literal-options
      m7903
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (.
      bean7902
      setLiteralOptions
      (cloudsearch/literal-options v7904))))
   (clojure.core/let
    [v7904
     (:text-options m7903 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (. bean7902 setTextOptions (cloudsearch/text-options v7904))))
   (clojure.core/let
    [v7904
     (:source-attributes
      m7903
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7904 :com.palletops.awaze.client-builder/undef)
     (.
      bean7902
      setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7972] (cloudsearch/source-attribute arg7972))
 v7904))))
   bean7902))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m7906]
  (clojure.core/let
   [bean7905
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/let
    [v7907
     (:domain-name m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setDomainName (clojure.core/str v7907))))
   (clojure.core/let
    [v7907 (:stems m7906 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7907 :com.palletops.awaze.client-builder/undef)
     (. bean7905 setStems (clojure.core/str v7907))))
   bean7905))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m7909]
  (clojure.core/let
   [bean7908
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/let
    [v7910
     (:domain-name m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setDomainName (clojure.core/str v7910))))
   (clojure.core/let
    [v7910
     (:synonyms m7909 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7910 :com.palletops.awaze.client-builder/undef)
     (. bean7908 setSynonyms (clojure.core/str v7910))))
   bean7908))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m7912]
  (clojure.core/let
   [bean7911
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/let
    [v7913
     (:domain-name m7912 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7913 :com.palletops.awaze.client-builder/undef)
     (. bean7911 setDomainName (clojure.core/str v7913))))
   bean7911))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m7915]
  (clojure.core/let
   [bean7914
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/let
    [v7916
     (:domain-name m7915 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7916 :com.palletops.awaze.client-builder/undef)
     (. bean7914 setDomainName (clojure.core/str v7916))))
   (clojure.core/let
    [v7916
     (:rank-expression
      m7915
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7916 :com.palletops.awaze.client-builder/undef)
     (.
      bean7914
      setRankExpression
      (cloudsearch/named-rank-expression v7916))))
   bean7914))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m7918]
  (clojure.core/let
   [bean7917
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/let
    [v7919
     (:domain-name m7918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (. bean7917 setDomainName (clojure.core/str v7919))))
   (clojure.core/let
    [v7919
     (:stopwords m7918 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7919 :com.palletops.awaze.client-builder/undef)
     (. bean7917 setStopwords (clojure.core/str v7919))))
   bean7917))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m7921]
  (clojure.core/let
   [bean7920
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/let
    [v7922
     (:domain-names m7921 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7922 :com.palletops.awaze.client-builder/undef)
     (.
      bean7920
      setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7973] (clojure.core/str arg7973))
 v7922))))
   bean7920))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m7924]
  (clojure.core/let
   [bean7923
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/let
    [v7925
     (:domain-name m7924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7925 :com.palletops.awaze.client-builder/undef)
     (. bean7923 setDomainName (clojure.core/str v7925))))
   (clojure.core/let
    [v7925
     (:rank-names m7924 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7925 :com.palletops.awaze.client-builder/undef)
     (.
      bean7923
      setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7974] (clojure.core/str arg7974))
 v7925))))
   bean7923))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m7927]
  (clojure.core/let
   [bean7926
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/let
    [v7928
     (:domain-name m7927 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7928 :com.palletops.awaze.client-builder/undef)
     (. bean7926 setDomainName (clojure.core/str v7928))))
   bean7926))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m7930]
  (clojure.core/let
   [bean7929
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/let
    [v7931
     (:domain-name m7930 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7931 :com.palletops.awaze.client-builder/undef)
     (. bean7929 setDomainName (clojure.core/str v7931))))
   bean7929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m7933]
  (clojure.core/let
   [bean7932
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/let
    [v7934
     (:domain-name m7933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7934 :com.palletops.awaze.client-builder/undef)
     (. bean7932 setDomainName (clojure.core/str v7934))))
   (clojure.core/let
    [v7934
     (:index-field m7933 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7934 :com.palletops.awaze.client-builder/undef)
     (. bean7932 setIndexField (cloudsearch/index-field v7934))))
   bean7932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m7936]
  (clojure.core/let
   [bean7935
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7937
     (:domain-name m7936 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7937 :com.palletops.awaze.client-builder/undef)
     (. bean7935 setDomainName (clojure.core/str v7937))))
   bean7935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m7939]
  (clojure.core/let
   [bean7938
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/let
    [v7940
     (:domain-name m7939 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7940 :com.palletops.awaze.client-builder/undef)
     (. bean7938 setDomainName (clojure.core/str v7940))))
   (clojure.core/let
    [v7940
     (:default-search-field
      m7939
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7940 :com.palletops.awaze.client-builder/undef)
     (. bean7938 setDefaultSearchField (clojure.core/str v7940))))
   bean7938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m7942]
  (clojure.core/let
   [bean7941
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/let
    [v7943
     (:domain-name m7942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7943 :com.palletops.awaze.client-builder/undef)
     (. bean7941 setDomainName (clojure.core/str v7943))))
   (clojure.core/let
    [v7943
     (:field-names m7942 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7943 :com.palletops.awaze.client-builder/undef)
     (.
      bean7941
      setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7975] (clojure.core/str arg7975))
 v7943))))
   bean7941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m7945]
  (clojure.core/let
   [bean7944
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7946
     (:domain-name m7945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7946 :com.palletops.awaze.client-builder/undef)
     (. bean7944 setDomainName (clojure.core/str v7946))))
   (clojure.core/let
    [v7946
     (:multi-az m7945 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7946 :com.palletops.awaze.client-builder/undef)
     (. bean7944 setMultiAZ (clojure.core/boolean v7946))))
   bean7944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m7948]
  (clojure.core/let
   [bean7947
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7949
     (:domain-name m7948 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7949 :com.palletops.awaze.client-builder/undef)
     (. bean7947 setDomainName (clojure.core/str v7949))))
   (clojure.core/let
    [v7949
     (:access-policies
      m7948
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7949 :com.palletops.awaze.client-builder/undef)
     (. bean7947 setAccessPolicies (clojure.core/str v7949))))
   bean7947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m7951]
  (clojure.core/let
   [bean7950
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/let
    [v7952
     (:domain-name m7951 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7952 :com.palletops.awaze.client-builder/undef)
     (. bean7950 setDomainName (clojure.core/str v7952))))
   bean7950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m7954]
  (clojure.core/let
   [bean7953
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/let
    [v7955
     (:domain-name m7954 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7955 :com.palletops.awaze.client-builder/undef)
     (. bean7953 setDomainName (clojure.core/str v7955))))
   bean7953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m7957]
  (clojure.core/let
   [bean7956
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/let
    [v7958
     (:domain-name m7957 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7958 :com.palletops.awaze.client-builder/undef)
     (. bean7956 setDomainName (clojure.core/str v7958))))
   bean7956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m7960]
  (clojure.core/let
   [bean7959
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/let
    [v7961
     (:domain-name m7960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7961 :com.palletops.awaze.client-builder/undef)
     (. bean7959 setDomainName (clojure.core/str v7961))))
   (clojure.core/let
    [v7961
     (:rank-name m7960 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7961 :com.palletops.awaze.client-builder/undef)
     (. bean7959 setRankName (clojure.core/str v7961))))
   bean7959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m7963]
  (clojure.core/let
   [bean7962
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/let
    [v7964
     (:domain-name m7963 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7964 :com.palletops.awaze.client-builder/undef)
     (. bean7962 setDomainName (clojure.core/str v7964))))
   (clojure.core/let
    [v7964
     (:index-field-name
      m7963
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7964 :com.palletops.awaze.client-builder/undef)
     (. bean7962 setIndexFieldName (clojure.core/str v7964))))
   bean7962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m7966]
  (clojure.core/let
   [bean7965
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/let
    [v7967
     (:domain-name m7966 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7967 :com.palletops.awaze.client-builder/undef)
     (. bean7965 setDomainName (clojure.core/str v7967))))
   bean7965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m7969]
  (clojure.core/let
   [bean7968
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/let
    [v7970
     (:domain-name m7969 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7970 :com.palletops.awaze.client-builder/undef)
     (. bean7968 setDomainName (clojure.core/str v7970))))
   bean7968))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m7976]
   (clojure.core/let
    [credentials7977 (:credentials m7976) args7978 (:args m7976)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7979
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7977)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7979
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args7978 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stemming-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         stems
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials7981 & args7982]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7983
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7981)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7983
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args7982 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m7984]
   (clojure.core/let
    [credentials7985 (:credentials m7984) args7986 (:args m7984)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7987
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7985)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7987
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args7986 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-synonym-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         synonyms
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials7989 & args7990]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7991
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7989)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7991
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args7990 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m7992]
   (clojure.core/let
    [credentials7993 (:credentials m7992) args7994 (:args m7992)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client7995
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials7993)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7995
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args7994 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials7997 & args7998]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client7999
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials7997)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client7999
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args7998 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m8000]
   (clojure.core/let
    [credentials8001 (:credentials m8000) args8002 (:args m8000)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8003
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8001)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8003
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args8002 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :define-rank-expression,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-expression
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineRankExpression"}
   [credentials8005 & args8006]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8007
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8005)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8007
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args8006 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m8008]
   (clojure.core/let
    [credentials8009 (:credentials m8008) args8010 (:args m8008)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8011
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8009)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8011
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args8010 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-stopword-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         stopwords
                         clone-root]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials8013 & args8014]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8015
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8013)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8015
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args8014 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m8016]
   (clojure.core/let
    [credentials8017 (:credentials m8016) args8018 (:args m8016)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8019
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8017)]
     (clojure.core/case
      (clojure.core/count args8018)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8019
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args8018 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8019
        describeDomains))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-domains,
     :credentials credentials__1842__auto__,
     :client :cloudsearch})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-domains,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         domain-names
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials8021 & args8022]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8023
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8021)]
    (clojure.core/case
     (clojure.core/count args8022)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8023
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args8022 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8023
       describeDomains))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m8024]
   (clojure.core/let
    [credentials8025 (:credentials m8024) args8026 (:args m8024)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8027
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8025)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8027
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args8026 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-rank-expressions,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         rank-names
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeRankExpressions"}
   [credentials8029 & args8030]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8031
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8029)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8031
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args8030 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m8032]
   (clojure.core/let
    [credentials8033 (:credentials m8032) args8034 (:args m8032)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8035
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8033)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8035
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args8034 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :index-documents,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call indexDocuments"}
   [credentials8037 & args8038]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8039
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8037)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8039
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args8038 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m8040]
   (clojure.core/let
    [credentials8041 (:credentials m8040) args8042 (:args m8040)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8043
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8041)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8043
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args8042 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stemming-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials8045 & args8046]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8047
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8045)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8047
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args8046 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m8048]
   (clojure.core/let
    [credentials8049 (:credentials m8048) args8050 (:args m8048)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8051
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8049)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8051
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args8050 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :define-index-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call defineIndexField"}
   [credentials8053 & args8054]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8055
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8053)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8055
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args8054 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m8056]
   (clojure.core/let
    [credentials8057 (:credentials m8056) args8058 (:args m8056)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8059
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8057)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8059
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args8058 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-default-search-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials8061 & args8062]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8063
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8061)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8063
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args8062 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m8064]
   (clojure.core/let
    [credentials8065 (:credentials m8064) args8066 (:args m8064)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8067
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8065)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8067
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args8066 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-default-search-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials8069 & args8070]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8071
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8069)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8071
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args8070 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m8072]
   (clojure.core/let
    [credentials8073 (:credentials m8072) args8074 (:args m8072)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8075
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8073)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8075
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args8074 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-index-fields,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         field-names
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeIndexFields"}
   [credentials8077 & args8078]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8079
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8077)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8079
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args8078 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m8080]
   (clojure.core/let
    [credentials8081 (:credentials m8080) args8082 (:args m8080)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8083
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8081)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8083
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args8082 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-availability-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         multi-az
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials8085 & args8086]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8087
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8085)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8087
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args8086 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m8088]
   (clojure.core/let
    [credentials8089 (:credentials m8088) args8090 (:args m8088)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8091
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8089)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8091
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args8090 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-service-access-policies,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         access-policies
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials8093 & args8094]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8095
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8093)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8095
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args8094 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m8096]
   (clojure.core/let
    [credentials8097 (:credentials m8096) args8098 (:args m8096)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8099
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8097)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8099
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args8098 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-service-access-policies,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials8101 & args8102]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8103
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8101)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8103
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args8102 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m8104]
   (clojure.core/let
    [credentials8105 (:credentials m8104) args8106 (:args m8104)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8107
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8105)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8107
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args8106 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-stopword-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials8109 & args8110]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8111
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8109)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8111
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args8110 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m8112]
   (clojure.core/let
    [credentials8113 (:credentials m8112) args8114 (:args m8112)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8115
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8113)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8115
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args8114 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-synonym-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials8117 & args8118]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8119
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8117)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8119
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args8118 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m8120]
   (clojure.core/let
    [credentials8121 (:credentials m8120) args8122 (:args m8120)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8123
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8121)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8123
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args8122 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-rank-expression,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         rank-name
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteRankExpression"}
   [credentials8125 & args8126]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8127
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8125)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8127
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args8126 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m8128]
   (clojure.core/let
    [credentials8129 (:credentials m8128) args8130 (:args m8128)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8131
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8129)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8131
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args8130 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-index-field,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         index-field-name
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIndexField"}
   [credentials8133 & args8134]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8135
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8133)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8135
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args8134 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m8136]
   (clojure.core/let
    [credentials8137 (:credentials m8136) args8138 (:args m8136)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8139
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8137)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8139
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args8138 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-availability-options,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials8141 & args8142]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8143
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8141)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8143
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args8142 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m8144]
   (clojure.core/let
    [credentials8145 (:credentials m8144) args8146 (:args m8144)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client8147
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials8145)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8147
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args8146 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :cloudsearch}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8149 & args8150]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client8151
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials8149)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client8151
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args8150 0))))))))
