(ns
 com.palletops.awaze.datapipeline
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.datapipeline :as datapipeline]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :datapipeline
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.datapipeline.DataPipelineClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.OperatorType}
operator-type
  [m7610]
  (.
   com.amazonaws.services.datapipeline.model.OperatorType
   fromValue
   (clojure.core/name m7610)))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Operator}
operator
  [m7613]
  (clojure.core/let
   [bean7612 (new com.amazonaws.services.datapipeline.model.Operator)]
   (clojure.core/let
    [v7614 (:values m7613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7614 :com.palletops.awaze.client-builder/undef)
     (.
      bean7612
      setValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7702] (clojure.core/str arg7702))
 v7614))))
   (clojure.core/let
    [v7614 (:type m7613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7614 :com.palletops.awaze.client-builder/undef)
     (. bean7612 setType (datapipeline/operator-type v7614))))
   bean7612))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Field}
field
  [m7616]
  (clojure.core/let
   [bean7615 (new com.amazonaws.services.datapipeline.model.Field)]
   (clojure.core/let
    [v7617
     (:ref-value m7616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7617 :com.palletops.awaze.client-builder/undef)
     (. bean7615 setRefValue (clojure.core/str v7617))))
   (clojure.core/let
    [v7617
     (:string-value m7616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7617 :com.palletops.awaze.client-builder/undef)
     (. bean7615 setStringValue (clojure.core/str v7617))))
   (clojure.core/let
    [v7617 (:key m7616 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7617 :com.palletops.awaze.client-builder/undef)
     (. bean7615 setKey (clojure.core/str v7617))))
   bean7615))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterAttribute}
parameter-attribute
  [m7619]
  (clojure.core/let
   [bean7618
    (new com.amazonaws.services.datapipeline.model.ParameterAttribute)]
   (clojure.core/let
    [v7620
     (:string-value m7619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7620 :com.palletops.awaze.client-builder/undef)
     (. bean7618 setStringValue (clojure.core/str v7620))))
   (clojure.core/let
    [v7620 (:key m7619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7620 :com.palletops.awaze.client-builder/undef)
     (. bean7618 setKey (clojure.core/str v7620))))
   bean7618))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Selector}
selector
  [m7622]
  (clojure.core/let
   [bean7621 (new com.amazonaws.services.datapipeline.model.Selector)]
   (clojure.core/let
    [v7623
     (:field-name m7622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7623 :com.palletops.awaze.client-builder/undef)
     (. bean7621 setFieldName (clojure.core/str v7623))))
   (clojure.core/let
    [v7623
     (:operator m7622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7623 :com.palletops.awaze.client-builder/undef)
     (. bean7621 setOperator (datapipeline/operator v7623))))
   bean7621))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PipelineObject}
pipeline-object
  [m7625]
  (clojure.core/let
   [bean7624
    (new com.amazonaws.services.datapipeline.model.PipelineObject)]
   (clojure.core/let
    [v7626 (:fields m7625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7626 :com.palletops.awaze.client-builder/undef)
     (.
      bean7624
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7703] (datapipeline/field arg7703))
 v7626))))
   (clojure.core/let
    [v7626 (:id m7625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7626 :com.palletops.awaze.client-builder/undef)
     (. bean7624 setId (clojure.core/str v7626))))
   (clojure.core/let
    [v7626 (:name m7625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7626 :com.palletops.awaze.client-builder/undef)
     (. bean7624 setName (clojure.core/str v7626))))
   bean7624))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterObject}
parameter-object
  [m7628]
  (clojure.core/let
   [bean7627
    (new com.amazonaws.services.datapipeline.model.ParameterObject)]
   (clojure.core/let
    [v7629 (:id m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (. bean7627 setId (clojure.core/str v7629))))
   (clojure.core/let
    [v7629
     (:attributes m7628 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7629 :com.palletops.awaze.client-builder/undef)
     (.
      bean7627
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg7704]
  (datapipeline/parameter-attribute arg7704))
 v7629))))
   bean7627))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ParameterValue}
parameter-value
  [m7631]
  (clojure.core/let
   [bean7630
    (new com.amazonaws.services.datapipeline.model.ParameterValue)]
   (clojure.core/let
    [v7632 (:id m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setId (clojure.core/str v7632))))
   (clojure.core/let
    [v7632
     (:string-value m7631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7632 :com.palletops.awaze.client-builder/undef)
     (. bean7630 setStringValue (clojure.core/str v7632))))
   bean7630))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.InstanceIdentity}
instance-identity
  [m7634]
  (clojure.core/let
   [bean7633
    (new com.amazonaws.services.datapipeline.model.InstanceIdentity)]
   (clojure.core/let
    [v7635
     (:document m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setDocument (clojure.core/str v7635))))
   (clojure.core/let
    [v7635
     (:signature m7634 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7635 :com.palletops.awaze.client-builder/undef)
     (. bean7633 setSignature (clojure.core/str v7635))))
   bean7633))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Tag}
tag
  [m7637]
  (clojure.core/let
   [bean7636 (new com.amazonaws.services.datapipeline.model.Tag)]
   (clojure.core/let
    [v7638 (:key m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setKey (clojure.core/str v7638))))
   (clojure.core/let
    [v7638 (:value m7637 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7638 :com.palletops.awaze.client-builder/undef)
     (. bean7636 setValue (clojure.core/str v7638))))
   bean7636))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.Query}
query
  [m7640]
  (clojure.core/let
   [bean7639 (new com.amazonaws.services.datapipeline.model.Query)]
   (clojure.core/let
    [v7641
     (:selectors m7640 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7641 :com.palletops.awaze.client-builder/undef)
     (.
      bean7639
      setSelectors
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7705] (datapipeline/selector arg7705))
 v7641))))
   bean7639))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.TaskStatus}
task-status
  [m7643]
  (.
   com.amazonaws.services.datapipeline.model.TaskStatus
   fromValue
   (clojure.core/name m7643)))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest}
get-pipeline-definition-request
  [m7646]
  (clojure.core/let
   [bean7645
    (new
     com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest)]
   (clojure.core/let
    [v7647 (:version m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (. bean7645 setVersion (clojure.core/str v7647))))
   (clojure.core/let
    [v7647
     (:pipeline-id m7646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7647 :com.palletops.awaze.client-builder/undef)
     (. bean7645 setPipelineId (clojure.core/str v7647))))
   bean7645))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest}
validate-pipeline-definition-request
  [m7649]
  (clojure.core/let
   [bean7648
    (new
     com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest)]
   (clojure.core/let
    [v7650
     (:pipeline-id m7649 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (. bean7648 setPipelineId (clojure.core/str v7650))))
   (clojure.core/let
    [v7650
     (:pipeline-objects
      m7649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (.
      bean7648
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7706] (datapipeline/pipeline-object arg7706))
 v7650))))
   (clojure.core/let
    [v7650
     (:parameter-objects
      m7649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (.
      bean7648
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7707] (datapipeline/parameter-object arg7707))
 v7650))))
   (clojure.core/let
    [v7650
     (:parameter-values
      m7649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7650 :com.palletops.awaze.client-builder/undef)
     (.
      bean7648
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7708] (datapipeline/parameter-value arg7708))
 v7650))))
   bean7648))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest}
report-task-progress-request
  [m7652]
  (clojure.core/let
   [bean7651
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest)]
   (clojure.core/let
    [v7653 (:fields m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (.
      bean7651
      setFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7709] (datapipeline/field arg7709))
 v7653))))
   (clojure.core/let
    [v7653 (:task-id m7652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7653 :com.palletops.awaze.client-builder/undef)
     (. bean7651 setTaskId (clojure.core/str v7653))))
   bean7651))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.RemoveTagsRequest}
remove-tags-request
  [m7655]
  (clojure.core/let
   [bean7654
    (new com.amazonaws.services.datapipeline.model.RemoveTagsRequest)]
   (clojure.core/let
    [v7656
     (:pipeline-id m7655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7656 :com.palletops.awaze.client-builder/undef)
     (. bean7654 setPipelineId (clojure.core/str v7656))))
   (clojure.core/let
    [v7656
     (:tag-keys m7655 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7656 :com.palletops.awaze.client-builder/undef)
     (.
      bean7654
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7710] (clojure.core/str arg7710))
 v7656))))
   bean7654))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribePipelinesRequest}
describe-pipelines-request
  [m7658]
  (clojure.core/let
   [bean7657
    (new
     com.amazonaws.services.datapipeline.model.DescribePipelinesRequest)]
   (clojure.core/let
    [v7659
     (:pipeline-ids m7658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7659 :com.palletops.awaze.client-builder/undef)
     (.
      bean7657
      setPipelineIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7711] (clojure.core/str arg7711))
 v7659))))
   bean7657))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PollForTaskRequest}
poll-for-task-request
  [m7661]
  (clojure.core/let
   [bean7660
    (new com.amazonaws.services.datapipeline.model.PollForTaskRequest)]
   (clojure.core/let
    [v7662
     (:worker-group m7661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (. bean7660 setWorkerGroup (clojure.core/str v7662))))
   (clojure.core/let
    [v7662
     (:hostname m7661 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (. bean7660 setHostname (clojure.core/str v7662))))
   (clojure.core/let
    [v7662
     (:instance-identity
      m7661
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7662 :com.palletops.awaze.client-builder/undef)
     (.
      bean7660
      setInstanceIdentity
      (datapipeline/instance-identity v7662))))
   bean7660))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.AddTagsRequest}
add-tags-request
  [m7664]
  (clojure.core/let
   [bean7663
    (new com.amazonaws.services.datapipeline.model.AddTagsRequest)]
   (clojure.core/let
    [v7665 (:tags m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (.
      bean7663
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7712] (datapipeline/tag arg7712))
 v7665))))
   (clojure.core/let
    [v7665
     (:pipeline-id m7664 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7665 :com.palletops.awaze.client-builder/undef)
     (. bean7663 setPipelineId (clojure.core/str v7665))))
   bean7663))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.QueryObjectsRequest}
query-objects-request
  [m7667]
  (clojure.core/let
   [bean7666
    (new
     com.amazonaws.services.datapipeline.model.QueryObjectsRequest)]
   (clojure.core/let
    [v7668 (:limit m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setLimit (clojure.core/int v7668))))
   (clojure.core/let
    [v7668 (:marker m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setMarker (clojure.core/str v7668))))
   (clojure.core/let
    [v7668
     (:pipeline-id m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setPipelineId (clojure.core/str v7668))))
   (clojure.core/let
    [v7668 (:query m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setQuery (datapipeline/query v7668))))
   (clojure.core/let
    [v7668 (:sphere m7667 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7668 :com.palletops.awaze.client-builder/undef)
     (. bean7666 setSphere (clojure.core/str v7668))))
   bean7666))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ListPipelinesRequest}
list-pipelines-request
  [m7670]
  (clojure.core/let
   [bean7669
    (new
     com.amazonaws.services.datapipeline.model.ListPipelinesRequest)]
   (clojure.core/let
    [v7671 (:marker m7670 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7671 :com.palletops.awaze.client-builder/undef)
     (. bean7669 setMarker (clojure.core/str v7671))))
   bean7669))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest}
report-task-runner-heartbeat-request
  [m7673]
  (clojure.core/let
   [bean7672
    (new
     com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest)]
   (clojure.core/let
    [v7674
     (:taskrunner-id m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (. bean7672 setTaskrunnerId (clojure.core/str v7674))))
   (clojure.core/let
    [v7674
     (:worker-group m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (. bean7672 setWorkerGroup (clojure.core/str v7674))))
   (clojure.core/let
    [v7674
     (:hostname m7673 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7674 :com.palletops.awaze.client-builder/undef)
     (. bean7672 setHostname (clojure.core/str v7674))))
   bean7672))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetTaskStatusRequest}
set-task-status-request
  [m7676]
  (clojure.core/let
   [bean7675
    (new
     com.amazonaws.services.datapipeline.model.SetTaskStatusRequest)]
   (clojure.core/let
    [v7677
     (:error-message m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setErrorMessage (clojure.core/str v7677))))
   (clojure.core/let
    [v7677
     (:task-status m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setTaskStatus (datapipeline/task-status v7677))))
   (clojure.core/let
    [v7677 (:task-id m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setTaskId (clojure.core/str v7677))))
   (clojure.core/let
    [v7677
     (:error-id m7676 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setErrorId (clojure.core/str v7677))))
   (clojure.core/let
    [v7677
     (:error-stack-trace
      m7676
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7677 :com.palletops.awaze.client-builder/undef)
     (. bean7675 setErrorStackTrace (clojure.core/str v7677))))
   bean7675))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.CreatePipelineRequest}
create-pipeline-request
  [m7679]
  (clojure.core/let
   [bean7678
    (new
     com.amazonaws.services.datapipeline.model.CreatePipelineRequest)]
   (clojure.core/let
    [v7680
     (:unique-id m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setUniqueId (clojure.core/str v7680))))
   (clojure.core/let
    [v7680
     (:description m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setDescription (clojure.core/str v7680))))
   (clojure.core/let
    [v7680 (:tags m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (.
      bean7678
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7713] (datapipeline/tag arg7713))
 v7680))))
   (clojure.core/let
    [v7680 (:name m7679 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7680 :com.palletops.awaze.client-builder/undef)
     (. bean7678 setName (clojure.core/str v7680))))
   bean7678))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeletePipelineRequest}
delete-pipeline-request
  [m7682]
  (clojure.core/let
   [bean7681
    (new
     com.amazonaws.services.datapipeline.model.DeletePipelineRequest)]
   (clojure.core/let
    [v7683
     (:pipeline-id m7682 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7683 :com.palletops.awaze.client-builder/undef)
     (. bean7681 setPipelineId (clojure.core/str v7683))))
   bean7681))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest}
put-pipeline-definition-request
  [m7685]
  (clojure.core/let
   [bean7684
    (new
     com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest)]
   (clojure.core/let
    [v7686
     (:pipeline-id m7685 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (. bean7684 setPipelineId (clojure.core/str v7686))))
   (clojure.core/let
    [v7686
     (:pipeline-objects
      m7685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (.
      bean7684
      setPipelineObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7714] (datapipeline/pipeline-object arg7714))
 v7686))))
   (clojure.core/let
    [v7686
     (:parameter-objects
      m7685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (.
      bean7684
      setParameterObjects
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7715] (datapipeline/parameter-object arg7715))
 v7686))))
   (clojure.core/let
    [v7686
     (:parameter-values
      m7685
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7686 :com.palletops.awaze.client-builder/undef)
     (.
      bean7684
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7716] (datapipeline/parameter-value arg7716))
 v7686))))
   bean7684))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest}
deactivate-pipeline-request
  [m7688]
  (clojure.core/let
   [bean7687
    (new
     com.amazonaws.services.datapipeline.model.DeactivatePipelineRequest)]
   (clojure.core/let
    [v7689
     (:pipeline-id m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setPipelineId (clojure.core/str v7689))))
   (clojure.core/let
    [v7689
     (:cancel-active m7688 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7689 :com.palletops.awaze.client-builder/undef)
     (. bean7687 setCancelActive (clojure.core/boolean v7689))))
   bean7687))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.SetStatusRequest}
set-status-request
  [m7691]
  (clojure.core/let
   [bean7690
    (new com.amazonaws.services.datapipeline.model.SetStatusRequest)]
   (clojure.core/let
    [v7692 (:status m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setStatus (clojure.core/str v7692))))
   (clojure.core/let
    [v7692
     (:pipeline-id m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (. bean7690 setPipelineId (clojure.core/str v7692))))
   (clojure.core/let
    [v7692
     (:object-ids m7691 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7692 :com.palletops.awaze.client-builder/undef)
     (.
      bean7690
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7717] (clojure.core/str arg7717))
 v7692))))
   bean7690))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest}
evaluate-expression-request
  [m7694]
  (clojure.core/let
   [bean7693
    (new
     com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest)]
   (clojure.core/let
    [v7695
     (:pipeline-id m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setPipelineId (clojure.core/str v7695))))
   (clojure.core/let
    [v7695
     (:object-id m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setObjectId (clojure.core/str v7695))))
   (clojure.core/let
    [v7695
     (:expression m7694 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7695 :com.palletops.awaze.client-builder/undef)
     (. bean7693 setExpression (clojure.core/str v7695))))
   bean7693))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.DescribeObjectsRequest}
describe-objects-request
  [m7697]
  (clojure.core/let
   [bean7696
    (new
     com.amazonaws.services.datapipeline.model.DescribeObjectsRequest)]
   (clojure.core/let
    [v7698 (:marker m7697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (. bean7696 setMarker (clojure.core/str v7698))))
   (clojure.core/let
    [v7698
     (:pipeline-id m7697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (. bean7696 setPipelineId (clojure.core/str v7698))))
   (clojure.core/let
    [v7698
     (:object-ids m7697 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (.
      bean7696
      setObjectIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7718] (clojure.core/str arg7718))
 v7698))))
   (clojure.core/let
    [v7698
     (:evaluate-expressions
      m7697
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7698 :com.palletops.awaze.client-builder/undef)
     (. bean7696 setEvaluateExpressions (clojure.core/boolean v7698))))
   bean7696))
 (clojure.core/defn
^{:tag com.amazonaws.services.datapipeline.model.ActivatePipelineRequest}
activate-pipeline-request
  [m7700]
  (clojure.core/let
   [bean7699
    (new
     com.amazonaws.services.datapipeline.model.ActivatePipelineRequest)]
   (clojure.core/let
    [v7701
     (:pipeline-id m7700 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (. bean7699 setPipelineId (clojure.core/str v7701))))
   (clojure.core/let
    [v7701
     (:parameter-values
      m7700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (.
      bean7699
      setParameterValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg7839] (datapipeline/parameter-value arg7839))
 v7701))))
   (clojure.core/let
    [v7701
     (:start-timestamp
      m7700
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v7701 :com.palletops.awaze.client-builder/undef)
     (.
      bean7699
      setStartTimestamp
      (com.palletops.awaze.common/to-date v7701))))
   bean7699))
 (clojure.core/defmulti
  datapipeline
  (clojure.core/fn
   datapipeline
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   datapipeline
   :get-pipeline-definition
   [m7719]
   (clojure.core/let
    [credentials7720 (:credentials m7719) args7721 (:args m7719)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7722
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7720)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7722
       getPipelineDefinition
       (datapipeline/get-pipeline-definition-request
        (clojure.core/nth args7721 0)))))))
  (clojure.core/defn
   get-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for getPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   get-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         version
                         pipeline-id
                         clone-root]}]]),
    :doc "Call getPipelineDefinition"}
   [credentials7724 & args7725]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7726
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7724)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7726
      getPipelineDefinition
      (datapipeline/get-pipeline-definition-request
       (clojure.core/nth args7725 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :validate-pipeline-definition
   [m7727]
   (clojure.core/let
    [credentials7728 (:credentials m7727) args7729 (:args m7727)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7730
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7728)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7730
       validatePipelineDefinition
       (datapipeline/validate-pipeline-definition-request
        (clojure.core/nth args7729 0)))))))
  (clojure.core/defn
   validate-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for validatePipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   validate-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call validatePipelineDefinition"}
   [credentials7732 & args7733]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7734
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7732)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7734
      validatePipelineDefinition
      (datapipeline/validate-pipeline-definition-request
       (clojure.core/nth args7733 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-progress
   [m7735]
   (clojure.core/let
    [credentials7736 (:credentials m7735) args7737 (:args m7735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7738
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7736)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7738
       reportTaskProgress
       (datapipeline/report-task-progress-request
        (clojure.core/nth args7737 0)))))))
  (clojure.core/defn
   report-task-progress-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskProgress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-progress,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-progress
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         fields
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskProgress"}
   [credentials7740 & args7741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7742
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7740)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7742
      reportTaskProgress
      (datapipeline/report-task-progress-request
       (clojure.core/nth args7741 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :remove-tags
   [m7743]
   (clojure.core/let
    [credentials7744 (:credentials m7743) args7745 (:args m7743)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7746
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7744)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7746
       removeTags
       (datapipeline/remove-tags-request
        (clojure.core/nth args7745 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         tag-keys
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials7748 & args7749]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7750
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7748)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7750
      removeTags
      (datapipeline/remove-tags-request (clojure.core/nth args7749 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-pipelines
   [m7751]
   (clojure.core/let
    [credentials7752 (:credentials m7751) args7753 (:args m7751)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7754
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7752)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7754
       describePipelines
       (datapipeline/describe-pipelines-request
        (clojure.core/nth args7753 0)))))))
  (clojure.core/defn
   describe-pipelines-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Generate map for describePipelines"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-pipelines
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         pipeline-ids]}]]),
    :doc "Call describePipelines"}
   [credentials7756 & args7757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7758
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7756)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7758
      describePipelines
      (datapipeline/describe-pipelines-request
       (clojure.core/nth args7757 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :poll-for-task
   [m7759]
   (clojure.core/let
    [credentials7760 (:credentials m7759) args7761 (:args m7759)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7762
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7760)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7762
       pollForTask
       (datapipeline/poll-for-task-request
        (clojure.core/nth args7761 0)))))))
  (clojure.core/defn
   poll-for-task-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Generate map for pollForTask"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :poll-for-task,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   poll-for-task
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root
                         instance-identity]}]]),
    :doc "Call pollForTask"}
   [credentials7764 & args7765]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7766
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7764)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7766
      pollForTask
      (datapipeline/poll-for-task-request
       (clojure.core/nth args7765 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :add-tags
   [m7767]
   (clojure.core/let
    [credentials7768 (:credentials m7767) args7769 (:args m7767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7770
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7770
       addTags
       (datapipeline/add-tags-request (clojure.core/nth args7769 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials7772 & args7773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7774
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7774
      addTags
      (datapipeline/add-tags-request (clojure.core/nth args7773 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :query-objects
   [m7775]
   (clojure.core/let
    [credentials7776 (:credentials m7775) args7777 (:args m7775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7778
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7776)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7778
       queryObjects
       (datapipeline/query-objects-request
        (clojure.core/nth args7777 0)))))))
  (clojure.core/defn
   query-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for queryObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :query-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   query-objects
   {:arglists (quote
               [[credentials
                 {:keys [sphere
                         custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         query
                         pipeline-id
                         clone-root]}]]),
    :doc "Call queryObjects"}
   [credentials7780 & args7781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7782
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7780)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7782
      queryObjects
      (datapipeline/query-objects-request
       (clojure.core/nth args7781 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :list-pipelines
   [m7783]
   (clojure.core/let
    [credentials7784 (:credentials m7783) args7785 (:args m7783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7786
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7784)]
     (clojure.core/case
      (clojure.core/count args7785)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7786
        listPipelines))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7786
        listPipelines
        (datapipeline/list-pipelines-request
         (clojure.core/nth args7785 0))))))))
  (clojure.core/defn
   list-pipelines-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listPipelines, listPipelines"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-pipelines,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   list-pipelines
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listPipelines, listPipelines"}
   [credentials7788 & args7789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7790
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7788)]
    (clojure.core/case
     (clojure.core/count args7789)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7790
       listPipelines))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7790
       listPipelines
       (datapipeline/list-pipelines-request
        (clojure.core/nth args7789 0))))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :report-task-runner-heartbeat
   [m7791]
   (clojure.core/let
    [credentials7792 (:credentials m7791) args7793 (:args m7791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7794
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7792)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7794
       reportTaskRunnerHeartbeat
       (datapipeline/report-task-runner-heartbeat-request
        (clojure.core/nth args7793 0)))))))
  (clojure.core/defn
   report-task-runner-heartbeat-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reportTaskRunnerHeartbeat"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :report-task-runner-heartbeat,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   report-task-runner-heartbeat
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         hostname
                         taskrunner-id
                         read-limit
                         general-progress-listener
                         worker-group
                         clone-source
                         clone-root]}]]),
    :doc "Call reportTaskRunnerHeartbeat"}
   [credentials7796 & args7797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7798
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7796)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7798
      reportTaskRunnerHeartbeat
      (datapipeline/report-task-runner-heartbeat-request
       (clojure.core/nth args7797 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-task-status
   [m7799]
   (clojure.core/let
    [credentials7800 (:credentials m7799) args7801 (:args m7799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7802
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7800)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7802
       setTaskStatus
       (datapipeline/set-task-status-request
        (clojure.core/nth args7801 0)))))))
  (clojure.core/defn
   set-task-status-map
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTaskStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-task-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-task-status
   {:arglists (quote
               [[credentials
                 {:keys [task-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         error-stack-trace
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         task-status
                         error-id
                         error-message
                         clone-source
                         clone-root]}]]),
    :doc "Call setTaskStatus"}
   [credentials7804 & args7805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7806
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7804)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7806
      setTaskStatus
      (datapipeline/set-task-status-request
       (clojure.core/nth args7805 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :create-pipeline
   [m7807]
   (clojure.core/let
    [credentials7808 (:credentials m7807) args7809 (:args m7807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7810
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7808)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7810
       createPipeline
       (datapipeline/create-pipeline-request
        (clojure.core/nth args7809 0)))))))
  (clojure.core/defn
   create-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createPipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   create-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         unique-id
                         clone-source
                         clone-root]}]]),
    :doc "Call createPipeline"}
   [credentials7812 & args7813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7814
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7812)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7814
      createPipeline
      (datapipeline/create-pipeline-request
       (clojure.core/nth args7813 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :delete-pipeline
   [m7815]
   (clojure.core/let
    [credentials7816 (:credentials m7815) args7817 (:args m7815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7818
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7816)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7818
       deletePipeline
       (datapipeline/delete-pipeline-request
        (clojure.core/nth args7817 0)))))))
  (clojure.core/defn
   delete-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deletePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   delete-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deletePipeline"}
   [credentials7820 & args7821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7822
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7820)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7822
      deletePipeline
      (datapipeline/delete-pipeline-request
       (clojure.core/nth args7821 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :put-pipeline-definition
   [m7823]
   (clojure.core/let
    [credentials7824 (:credentials m7823) args7825 (:args m7823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7826
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7824)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7826
       putPipelineDefinition
       (datapipeline/put-pipeline-definition-request
        (clojure.core/nth args7825 0)))))))
  (clojure.core/defn
   put-pipeline-definition-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for putPipelineDefinition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-pipeline-definition,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   put-pipeline-definition
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         parameter-objects
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         pipeline-objects
                         general-progress-listener
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call putPipelineDefinition"}
   [credentials7828 & args7829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7830
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7828)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7830
      putPipelineDefinition
      (datapipeline/put-pipeline-definition-request
       (clojure.core/nth args7829 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :deactivate-pipeline
   [m7831]
   (clojure.core/let
    [credentials7832 (:credentials m7831) args7833 (:args m7831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7834
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7834
       deactivatePipeline
       (datapipeline/deactivate-pipeline-request
        (clojure.core/nth args7833 0)))))))
  (clojure.core/defn
   deactivate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for deactivatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deactivate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   deactivate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cancel-active
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call deactivatePipeline"}
   [credentials7836 & args7837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7838
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7838
      deactivatePipeline
      (datapipeline/deactivate-pipeline-request
       (clojure.core/nth args7837 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :set-status
   [m7840]
   (clojure.core/let
    [credentials7841 (:credentials m7840) args7842 (:args m7840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7843
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7841)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7843
       setStatus
       (datapipeline/set-status-request (clojure.core/nth args7842 0)))))))
  (clojure.core/defn
   set-status-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for setStatus"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-status,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   set-status
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         status
                         general-progress-listener
                         object-ids
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call setStatus"}
   [credentials7845 & args7846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7847
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7847
      setStatus
      (datapipeline/set-status-request (clojure.core/nth args7846 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :evaluate-expression
   [m7848]
   (clojure.core/let
    [credentials7849 (:credentials m7848) args7850 (:args m7848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7851
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7849)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7851
       evaluateExpression
       (datapipeline/evaluate-expression-request
        (clojure.core/nth args7850 0)))))))
  (clojure.core/defn
   evaluate-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for evaluateExpression"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :evaluate-expression,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   evaluate-expression
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         expression
                         object-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         pipeline-id
                         clone-root]}]]),
    :doc "Call evaluateExpression"}
   [credentials7853 & args7854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7855
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7853)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7855
      evaluateExpression
      (datapipeline/evaluate-expression-request
       (clojure.core/nth args7854 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :describe-objects
   [m7856]
   (clojure.core/let
    [credentials7857 (:credentials m7856) args7858 (:args m7856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7859
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7857)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7859
       describeObjects
       (datapipeline/describe-objects-request
        (clojure.core/nth args7858 0)))))))
  (clojure.core/defn
   describe-objects-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Generate map for describeObjects"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-objects,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   describe-objects
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         object-ids
                         clone-source
                         evaluate-expressions
                         pipeline-id
                         clone-root]}]]),
    :doc "Call describeObjects"}
   [credentials7861 & args7862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7863
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7861)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7863
      describeObjects
      (datapipeline/describe-objects-request
       (clojure.core/nth args7862 0)))))))
 (do
  (clojure.core/defmethod
   datapipeline
   :activate-pipeline
   [m7864]
   (clojure.core/let
    [credentials7865 (:credentials m7864) args7866 (:args m7864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
      client7867
      (com.palletops.awaze.common/aws-client
       :datapipeline
       credentials7865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7867
       activatePipeline
       (datapipeline/activate-pipeline-request
        (clojure.core/nth args7866 0)))))))
  (clojure.core/defn
   activate-pipeline-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Generate map for activatePipeline"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :activate-pipeline,
     :credentials credentials__1842__auto__,
     :client :datapipeline}))
  (clojure.core/defn
   activate-pipeline
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         start-timestamp
                         clone-source
                         pipeline-id
                         parameter-values
                         clone-root]}]]),
    :doc "Call activatePipeline"}
   [credentials7869 & args7870]
   (clojure.core/let
    [^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
     client7871
     (com.palletops.awaze.common/aws-client
      :datapipeline
      credentials7869)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.datapipeline.DataPipelineClient}
client7871
      activatePipeline
      (datapipeline/activate-pipeline-request
       (clojure.core/nth args7870 0))))))))
