(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m11731]
  (clojure.core/let
   [bean11730
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/let
    [v11732 (:cidr m11731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11732 :com.palletops.awaze.client-builder/undef)
     (. bean11730 setCidr (clojure.core/str v11732))))
   bean11730))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m11734]
  (clojure.core/let
   [bean11733
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11735 (:vlan m11734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setVlan (clojure.core/int v11735))))
   (clojure.core/let
    [v11735 (:asn m11734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setAsn (clojure.core/int v11735))))
   (clojure.core/let
    [v11735
     (:virtual-interface-name
      m11734
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setVirtualInterfaceName (clojure.core/str v11735))))
   (clojure.core/let
    [v11735
     (:auth-key m11734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setAuthKey (clojure.core/str v11735))))
   (clojure.core/let
    [v11735
     (:amazon-address
      m11734
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setAmazonAddress (clojure.core/str v11735))))
   (clojure.core/let
    [v11735
     (:customer-address
      m11734
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11735 :com.palletops.awaze.client-builder/undef)
     (. bean11733 setCustomerAddress (clojure.core/str v11735))))
   bean11733))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m11737]
  (clojure.core/let
   [bean11736
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/let
    [v11738 (:vlan m11737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setVlan (clojure.core/int v11738))))
   (clojure.core/let
    [v11738 (:asn m11737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setAsn (clojure.core/int v11738))))
   (clojure.core/let
    [v11738
     (:route-filter-prefixes
      m11737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (.
      bean11736
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11802]
  (directconnect/route-filter-prefix arg11802))
 v11738))))
   (clojure.core/let
    [v11738
     (:virtual-interface-name
      m11737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setVirtualInterfaceName (clojure.core/str v11738))))
   (clojure.core/let
    [v11738
     (:auth-key m11737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setAuthKey (clojure.core/str v11738))))
   (clojure.core/let
    [v11738
     (:amazon-address
      m11737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setAmazonAddress (clojure.core/str v11738))))
   (clojure.core/let
    [v11738
     (:customer-address
      m11737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11738 :com.palletops.awaze.client-builder/undef)
     (. bean11736 setCustomerAddress (clojure.core/str v11738))))
   bean11736))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m11740]
  (clojure.core/let
   [bean11739
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/let
    [v11741
     (:virtual-gateway-id
      m11740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setVirtualGatewayId (clojure.core/str v11741))))
   (clojure.core/let
    [v11741 (:vlan m11740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setVlan (clojure.core/int v11741))))
   (clojure.core/let
    [v11741 (:asn m11740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setAsn (clojure.core/int v11741))))
   (clojure.core/let
    [v11741
     (:virtual-interface-name
      m11740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setVirtualInterfaceName (clojure.core/str v11741))))
   (clojure.core/let
    [v11741
     (:auth-key m11740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setAuthKey (clojure.core/str v11741))))
   (clojure.core/let
    [v11741
     (:amazon-address
      m11740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setAmazonAddress (clojure.core/str v11741))))
   (clojure.core/let
    [v11741
     (:customer-address
      m11740
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11741 :com.palletops.awaze.client-builder/undef)
     (. bean11739 setCustomerAddress (clojure.core/str v11741))))
   bean11739))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m11743]
  (clojure.core/let
   [bean11742
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/let
    [v11744 (:vlan m11743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setVlan (clojure.core/int v11744))))
   (clojure.core/let
    [v11744 (:asn m11743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setAsn (clojure.core/int v11744))))
   (clojure.core/let
    [v11744
     (:route-filter-prefixes
      m11743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (.
      bean11742
      setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg11803]
  (directconnect/route-filter-prefix arg11803))
 v11744))))
   (clojure.core/let
    [v11744
     (:virtual-interface-name
      m11743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setVirtualInterfaceName (clojure.core/str v11744))))
   (clojure.core/let
    [v11744
     (:auth-key m11743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setAuthKey (clojure.core/str v11744))))
   (clojure.core/let
    [v11744
     (:amazon-address
      m11743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setAmazonAddress (clojure.core/str v11744))))
   (clojure.core/let
    [v11744
     (:customer-address
      m11743
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11744 :com.palletops.awaze.client-builder/undef)
     (. bean11742 setCustomerAddress (clojure.core/str v11744))))
   bean11742))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m11746]
  (clojure.core/let
   [bean11745
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/let
    [v11747
     (:interconnect-id
      m11746
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11747 :com.palletops.awaze.client-builder/undef)
     (. bean11745 setInterconnectId (clojure.core/str v11747))))
   bean11745))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m11749]
  (clojure.core/let
   [bean11748
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11750
     (:connection-id m11749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setConnectionId (clojure.core/str v11750))))
   (clojure.core/let
    [v11750
     (:new-private-virtual-interface-allocation
      m11749
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (.
      bean11748
      setNewPrivateVirtualInterfaceAllocation
      (directconnect/new-private-virtual-interface-allocation v11750))))
   (clojure.core/let
    [v11750
     (:owner-account m11749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11750 :com.palletops.awaze.client-builder/undef)
     (. bean11748 setOwnerAccount (clojure.core/str v11750))))
   bean11748))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m11752]
  (clojure.core/let
   [bean11751
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/let
    [v11753
     (:connection-id m11752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setConnectionId (clojure.core/str v11753))))
   (clojure.core/let
    [v11753
     (:virtual-interface-id
      m11752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11753 :com.palletops.awaze.client-builder/undef)
     (. bean11751 setVirtualInterfaceId (clojure.core/str v11753))))
   bean11751))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m11755]
  (clojure.core/let
   [bean11754
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11756
     (:connection-id m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setConnectionId (clojure.core/str v11756))))
   (clojure.core/let
    [v11756
     (:new-public-virtual-interface-allocation
      m11755
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (.
      bean11754
      setNewPublicVirtualInterfaceAllocation
      (directconnect/new-public-virtual-interface-allocation v11756))))
   (clojure.core/let
    [v11756
     (:owner-account m11755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11756 :com.palletops.awaze.client-builder/undef)
     (. bean11754 setOwnerAccount (clojure.core/str v11756))))
   bean11754))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m11758]
  (clojure.core/let
   [bean11757
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/let
    [v11759
     (:interconnect-id
      m11758
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11759 :com.palletops.awaze.client-builder/undef)
     (. bean11757 setInterconnectId (clojure.core/str v11759))))
   bean11757))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m11761]
  (clojure.core/let
   [bean11760
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/let
    [v11762
     (:virtual-interface-id
      m11761
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11762 :com.palletops.awaze.client-builder/undef)
     (. bean11760 setVirtualInterfaceId (clojure.core/str v11762))))
   bean11760))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m11764]
  (clojure.core/let
   [bean11763
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean11763))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m11767]
  (clojure.core/let
   [bean11766
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/let
    [v11768
     (:bandwidth m11767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setBandwidth (clojure.core/str v11768))))
   (clojure.core/let
    [v11768
     (:connection-name
      m11767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setConnectionName (clojure.core/str v11768))))
   (clojure.core/let
    [v11768
     (:interconnect-id
      m11767
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setInterconnectId (clojure.core/str v11768))))
   (clojure.core/let
    [v11768 (:vlan m11767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setVlan (clojure.core/int v11768))))
   (clojure.core/let
    [v11768
     (:owner-account m11767 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11768 :com.palletops.awaze.client-builder/undef)
     (. bean11766 setOwnerAccount (clojure.core/str v11768))))
   bean11766))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m11770]
  (clojure.core/let
   [bean11769
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/let
    [v11771
     (:bandwidth m11770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setBandwidth (clojure.core/str v11771))))
   (clojure.core/let
    [v11771
     (:interconnect-name
      m11770
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setInterconnectName (clojure.core/str v11771))))
   (clojure.core/let
    [v11771
     (:location m11770 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11771 :com.palletops.awaze.client-builder/undef)
     (. bean11769 setLocation (clojure.core/str v11771))))
   bean11769))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m11773]
  (clojure.core/let
   [bean11772
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/let
    [v11774
     (:connection-id m11773 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11774 :com.palletops.awaze.client-builder/undef)
     (. bean11772 setConnectionId (clojure.core/str v11774))))
   bean11772))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m11776]
  (clojure.core/let
   [bean11775
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11777
     (:connection-id m11776 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (. bean11775 setConnectionId (clojure.core/str v11777))))
   (clojure.core/let
    [v11777
     (:new-private-virtual-interface
      m11776
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11777 :com.palletops.awaze.client-builder/undef)
     (.
      bean11775
      setNewPrivateVirtualInterface
      (directconnect/new-private-virtual-interface v11777))))
   bean11775))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m11779]
  (clojure.core/let
   [bean11778
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/let
    [v11780
     (:interconnect-id
      m11779
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11780 :com.palletops.awaze.client-builder/undef)
     (. bean11778 setInterconnectId (clojure.core/str v11780))))
   bean11778))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m11782]
  (clojure.core/let
   [bean11781
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11783
     (:connection-id m11782 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (. bean11781 setConnectionId (clojure.core/str v11783))))
   (clojure.core/let
    [v11783
     (:new-public-virtual-interface
      m11782
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11783 :com.palletops.awaze.client-builder/undef)
     (.
      bean11781
      setNewPublicVirtualInterface
      (directconnect/new-public-virtual-interface v11783))))
   bean11781))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m11785]
  (clojure.core/let
   [bean11784
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/let
    [v11786
     (:bandwidth m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setBandwidth (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:connection-name
      m11785
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setConnectionName (clojure.core/str v11786))))
   (clojure.core/let
    [v11786
     (:location m11785 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11786 :com.palletops.awaze.client-builder/undef)
     (. bean11784 setLocation (clojure.core/str v11786))))
   bean11784))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m11788]
  (clojure.core/let
   [bean11787
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/let
    [v11789
     (:connection-id m11788 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11789 :com.palletops.awaze.client-builder/undef)
     (. bean11787 setConnectionId (clojure.core/str v11789))))
   bean11787))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m11791]
  (clojure.core/let
   [bean11790
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean11790))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m11794]
  (clojure.core/let
   [bean11793
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/let
    [v11795
     (:connection-id m11794 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11795 :com.palletops.awaze.client-builder/undef)
     (. bean11793 setConnectionId (clojure.core/str v11795))))
   bean11793))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m11797]
  (clojure.core/let
   [bean11796
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/let
    [v11798
     (:virtual-interface-id
      m11797
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11798 :com.palletops.awaze.client-builder/undef)
     (. bean11796 setVirtualInterfaceId (clojure.core/str v11798))))
   bean11796))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m11800]
  (clojure.core/let
   [bean11799
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/let
    [v11801
     (:virtual-interface-id
      m11800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11801 :com.palletops.awaze.client-builder/undef)
     (. bean11799 setVirtualInterfaceId (clojure.core/str v11801))))
   (clojure.core/let
    [v11801
     (:virtual-gateway-id
      m11800
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v11801 :com.palletops.awaze.client-builder/undef)
     (. bean11799 setVirtualGatewayId (clojure.core/str v11801))))
   bean11799))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m11804]
   (clojure.core/let
    [credentials11805 (:credentials m11804) args11806 (:args m11804)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11807
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11805)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11807
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args11806 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials11809 & args11810]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11811
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11809)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11811
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args11810 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m11812]
   (clojure.core/let
    [credentials11813 (:credentials m11812) args11814 (:args m11812)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11815
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11813)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11815
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args11814 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root
                         new-private-virtual-interface-allocation]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials11817 & args11818]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11819
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11817)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11819
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args11818 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m11820]
   (clojure.core/let
    [credentials11821 (:credentials m11820) args11822 (:args m11820)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11823
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11821)]
     (clojure.core/case
      (clojure.core/count args11822)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11823
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args11822 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11823
        describeVirtualInterfaces))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-interfaces,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         virtual-interface-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials11825 & args11826]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11827
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11825)]
    (clojure.core/case
     (clojure.core/count args11826)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11827
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args11826 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11827
       describeVirtualInterfaces))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m11828]
   (clojure.core/let
    [credentials11829 (:credentials m11828) args11830 (:args m11828)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11831
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11829)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11831
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args11830 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         new-public-virtual-interface-allocation
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         owner-account
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials11833 & args11834]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11835
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11833)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11835
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args11834 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m11836]
   (clojure.core/let
    [credentials11837 (:credentials m11836) args11838 (:args m11836)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11839
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11837)]
     (clojure.core/case
      (clojure.core/count args11838)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11839
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11839
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args11838 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-interconnects,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials11841 & args11842]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11843
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11841)]
    (clojure.core/case
     (clojure.core/count args11842)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11843
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11843
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args11842 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m11844]
   (clojure.core/let
    [credentials11845 (:credentials m11844) args11846 (:args m11844)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11847
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11845)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11847
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args11846 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials11849 & args11850]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11851
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11849)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11851
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args11850 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m11852]
   (clojure.core/let
    [credentials11853 (:credentials m11852) args11854 (:args m11852)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11855
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11853)]
     (clojure.core/case
      (clojure.core/count args11854)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11855
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11855
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args11854 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-locations,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials11857 & args11858]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11859
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11857)]
    (clojure.core/case
     (clojure.core/count args11858)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11859
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11859
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args11858 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m11860]
   (clojure.core/let
    [credentials11861 (:credentials m11860) args11862 (:args m11860)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11863
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11861)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11863
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args11862 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         owner-account
                         vlan
                         clone-source
                         connection-name
                         clone-root]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials11865 & args11866]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11867
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11865)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11867
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args11866 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m11868]
   (clojure.core/let
    [credentials11869 (:credentials m11868) args11870 (:args m11868)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11871
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11869)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11871
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args11870 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         interconnect-name
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         location
                         clone-root]}]]),
    :doc "Call createInterconnect"}
   [credentials11873 & args11874]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11875
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11873)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11875
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args11874 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m11876]
   (clojure.core/let
    [credentials11877 (:credentials m11876) args11878 (:args m11876)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11879
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11877)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11879
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args11878 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConnection"}
   [credentials11881 & args11882]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11883
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11881)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11883
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args11882 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m11884]
   (clojure.core/let
    [credentials11885 (:credentials m11884) args11886 (:args m11884)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11887
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11885)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11887
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args11886 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         new-private-virtual-interface
                         clone-root]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials11889 & args11890]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11891
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11889)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11891
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args11890 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m11892]
   (clojure.core/let
    [credentials11893 (:credentials m11892) args11894 (:args m11892)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11895
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11893)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11895
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args11894 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-interconnect,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteInterconnect"}
   [credentials11897 & args11898]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11899
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11897)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11899
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args11898 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m11900]
   (clojure.core/let
    [credentials11901 (:credentials m11900) args11902 (:args m11900)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11903
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11901)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11903
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args11902 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root
                         new-public-virtual-interface]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials11905 & args11906]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11907
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11905)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11907
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args11906 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m11908]
   (clojure.core/let
    [credentials11909 (:credentials m11908) args11910 (:args m11908)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11911
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11909)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11911
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args11910 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bandwidth
                         read-limit
                         general-progress-listener
                         clone-source
                         connection-name
                         location
                         clone-root]}]]),
    :doc "Call createConnection"}
   [credentials11913 & args11914]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11915
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11913)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11915
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args11914 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m11916]
   (clojure.core/let
    [credentials11917 (:credentials m11916) args11918 (:args m11916)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11919
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11917)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11919
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args11918 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-connection,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmConnection"}
   [credentials11921 & args11922]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11923
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11921)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11923
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args11922 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m11924]
   (clojure.core/let
    [credentials11925 (:credentials m11924) args11926 (:args m11924)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11927
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11925)]
     (clojure.core/case
      (clojure.core/count args11926)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11927
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11927
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args11926 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-virtual-gateways,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials11929 & args11930]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11931
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11929)]
    (clojure.core/case
     (clojure.core/count args11930)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11931
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11931
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args11930 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m11932]
   (clojure.core/let
    [credentials11933 (:credentials m11932) args11934 (:args m11932)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11935
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11933)]
     (clojure.core/case
      (clojure.core/count args11934)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11935
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args11934 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11935
        describeConnections))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-connections,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         connection-id
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials11937 & args11938]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11939
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11937)]
    (clojure.core/case
     (clojure.core/count args11938)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11939
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args11938 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11939
       describeConnections))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m11940]
   (clojure.core/let
    [credentials11941 (:credentials m11940) args11942 (:args m11940)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11943
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11941)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11943
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args11942 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials11945 & args11946]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11947
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11945)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11947
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args11946 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m11948]
   (clojure.core/let
    [credentials11949 (:credentials m11948) args11950 (:args m11948)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client11951
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials11949)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11951
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args11950 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1842__auto__,
     :client :directconnect}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         virtual-gateway-id
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         virtual-interface-id
                         clone-source
                         clone-root]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials11953 & args11954]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client11955
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials11953)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client11955
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args11954 0))))))))
