(ns
 com.palletops.awaze.elasticbeanstalk
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticbeanstalk :as elasticbeanstalk]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticbeanstalk
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EventSeverity}
event-severity
  [m10702]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EventSeverity
   fromValue
   (clojure.core/name m10702)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.OptionSpecification}
option-specification
  [m10705]
  (clojure.core/let
   [bean10704
    (new
     com.amazonaws.services.elasticbeanstalk.model.OptionSpecification)]
   (clojure.core/let
    [v10706
     (:namespace m10705 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10706 :com.palletops.awaze.client-builder/undef)
     (. bean10704 setNamespace (clojure.core/str v10706))))
   (clojure.core/let
    [v10706
     (:resource-name m10705 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10706 :com.palletops.awaze.client-builder/undef)
     (. bean10704 setResourceName (clojure.core/str v10706))))
   (clojure.core/let
    [v10706
     (:option-name m10705 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10706 :com.palletops.awaze.client-builder/undef)
     (. bean10704 setOptionName (clojure.core/str v10706))))
   bean10704))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration}
source-configuration
  [m10708]
  (clojure.core/let
   [bean10707
    (new
     com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration)]
   (clojure.core/let
    [v10709
     (:application-name
      m10708
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10709 :com.palletops.awaze.client-builder/undef)
     (. bean10707 setApplicationName (clojure.core/str v10709))))
   (clojure.core/let
    [v10709
     (:template-name m10708 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10709 :com.palletops.awaze.client-builder/undef)
     (. bean10707 setTemplateName (clojure.core/str v10709))))
   bean10707))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting}
configuration-option-setting
  [m10711]
  (clojure.core/let
   [bean10710
    (new
     com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting)]
   (clojure.core/let
    [v10712
     (:namespace m10711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (. bean10710 setNamespace (clojure.core/str v10712))))
   (clojure.core/let
    [v10712
     (:resource-name m10711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (. bean10710 setResourceName (clojure.core/str v10712))))
   (clojure.core/let
    [v10712
     (:option-name m10711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (. bean10710 setOptionName (clojure.core/str v10712))))
   (clojure.core/let
    [v10712 (:value m10711 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10712 :com.palletops.awaze.client-builder/undef)
     (. bean10710 setValue (clojure.core/str v10712))))
   bean10710))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier}
environment-tier
  [m10714]
  (clojure.core/let
   [bean10713
    (new
     com.amazonaws.services.elasticbeanstalk.model.EnvironmentTier)]
   (clojure.core/let
    [v10715
     (:version m10714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setVersion (clojure.core/str v10715))))
   (clojure.core/let
    [v10715 (:type m10714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setType (clojure.core/str v10715))))
   (clojure.core/let
    [v10715 (:name m10714 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10715 :com.palletops.awaze.client-builder/undef)
     (. bean10713 setName (clojure.core/str v10715))))
   bean10713))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType}
environment-info-type
  [m10717]
  (.
   com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType
   fromValue
   (clojure.core/name m10717)))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.S3Location}
s3location
  [m10720]
  (clojure.core/let
   [bean10719
    (new com.amazonaws.services.elasticbeanstalk.model.S3Location)]
   (clojure.core/let
    [v10721
     (:s3bucket m10720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10721 :com.palletops.awaze.client-builder/undef)
     (. bean10719 setS3Bucket (clojure.core/str v10721))))
   (clojure.core/let
    [v10721 (:s3key m10720 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10721 :com.palletops.awaze.client-builder/undef)
     (. bean10719 setS3Key (clojure.core/str v10721))))
   bean10719))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.Tag}
tag
  [m10723]
  (clojure.core/let
   [bean10722 (new com.amazonaws.services.elasticbeanstalk.model.Tag)]
   (clojure.core/let
    [v10724 (:key m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setKey (clojure.core/str v10724))))
   (clojure.core/let
    [v10724 (:value m10723 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10724 :com.palletops.awaze.client-builder/undef)
     (. bean10722 setValue (clojure.core/str v10724))))
   bean10722))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest}
describe-application-versions-request
  [m10726]
  (clojure.core/let
   [bean10725
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest)]
   (clojure.core/let
    [v10727
     (:application-name
      m10726
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10727 :com.palletops.awaze.client-builder/undef)
     (. bean10725 setApplicationName (clojure.core/str v10727))))
   (clojure.core/let
    [v10727
     (:version-labels
      m10726
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10727 :com.palletops.awaze.client-builder/undef)
     (.
      bean10725
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10824] (clojure.core/str arg10824))
 v10727))))
   bean10725))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest}
compose-environments-request
  [m10729]
  (clojure.core/let
   [bean10728
    (new
     com.amazonaws.services.elasticbeanstalk.model.ComposeEnvironmentsRequest)]
   (clojure.core/let
    [v10730
     (:group-name m10729 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setGroupName (clojure.core/str v10730))))
   (clojure.core/let
    [v10730
     (:application-name
      m10729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (. bean10728 setApplicationName (clojure.core/str v10730))))
   (clojure.core/let
    [v10730
     (:version-labels
      m10729
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10730 :com.palletops.awaze.client-builder/undef)
     (.
      bean10728
      setVersionLabels
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10825] (clojure.core/str arg10825))
 v10730))))
   bean10728))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest}
rebuild-environment-request
  [m10732]
  (clojure.core/let
   [bean10731
    (new
     com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest)]
   (clojure.core/let
    [v10733
     (:environment-id
      m10732
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setEnvironmentId (clojure.core/str v10733))))
   (clojure.core/let
    [v10733
     (:environment-name
      m10732
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10733 :com.palletops.awaze.client-builder/undef)
     (. bean10731 setEnvironmentName (clojure.core/str v10733))))
   bean10731))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest}
update-application-version-request
  [m10735]
  (clojure.core/let
   [bean10734
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest)]
   (clojure.core/let
    [v10736
     (:description m10735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setDescription (clojure.core/str v10736))))
   (clojure.core/let
    [v10736
     (:application-name
      m10735
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setApplicationName (clojure.core/str v10736))))
   (clojure.core/let
    [v10736
     (:version-label m10735 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10736 :com.palletops.awaze.client-builder/undef)
     (. bean10734 setVersionLabel (clojure.core/str v10736))))
   bean10734))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest}
delete-environment-configuration-request
  [m10738]
  (clojure.core/let
   [bean10737
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest)]
   (clojure.core/let
    [v10739
     (:environment-name
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setEnvironmentName (clojure.core/str v10739))))
   (clojure.core/let
    [v10739
     (:application-name
      m10738
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10739 :com.palletops.awaze.client-builder/undef)
     (. bean10737 setApplicationName (clojure.core/str v10739))))
   bean10737))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest}
describe-events-request
  [m10741]
  (clojure.core/let
   [bean10740
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest)]
   (clojure.core/let
    [v10742
     (:start-time m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (.
      bean10740
      setStartTime
      (com.palletops.awaze.common/to-date v10742))))
   (clojure.core/let
    [v10742
     (:version-label m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setVersionLabel (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:template-name m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setTemplateName (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:environment-name
      m10741
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setEnvironmentName (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:max-records m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setMaxRecords (clojure.core/int v10742))))
   (clojure.core/let
    [v10742
     (:severity m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (.
      bean10740
      setSeverity
      (elasticbeanstalk/event-severity v10742))))
   (clojure.core/let
    [v10742
     (:end-time m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (.
      bean10740
      setEndTime
      (com.palletops.awaze.common/to-date v10742))))
   (clojure.core/let
    [v10742
     (:request-id m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setRequestId (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:environment-id
      m10741
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setEnvironmentId (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:next-token m10741 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setNextToken (clojure.core/str v10742))))
   (clojure.core/let
    [v10742
     (:application-name
      m10741
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10742 :com.palletops.awaze.client-builder/undef)
     (. bean10740 setApplicationName (clojure.core/str v10742))))
   bean10740))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest}
describe-configuration-settings-request
  [m10744]
  (clojure.core/let
   [bean10743
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest)]
   (clojure.core/let
    [v10745
     (:environment-name
      m10744
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10745 :com.palletops.awaze.client-builder/undef)
     (. bean10743 setEnvironmentName (clojure.core/str v10745))))
   (clojure.core/let
    [v10745
     (:application-name
      m10744
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10745 :com.palletops.awaze.client-builder/undef)
     (. bean10743 setApplicationName (clojure.core/str v10745))))
   (clojure.core/let
    [v10745
     (:template-name m10744 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10745 :com.palletops.awaze.client-builder/undef)
     (. bean10743 setTemplateName (clojure.core/str v10745))))
   bean10743))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest}
terminate-environment-request
  [m10747]
  (clojure.core/let
   [bean10746
    (new
     com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest)]
   (clojure.core/let
    [v10748
     (:environment-id
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setEnvironmentId (clojure.core/str v10748))))
   (clojure.core/let
    [v10748
     (:environment-name
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setEnvironmentName (clojure.core/str v10748))))
   (clojure.core/let
    [v10748
     (:terminate-resources
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setTerminateResources (clojure.core/boolean v10748))))
   (clojure.core/let
    [v10748
     (:force-terminate
      m10747
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10748 :com.palletops.awaze.client-builder/undef)
     (. bean10746 setForceTerminate (clojure.core/boolean v10748))))
   bean10746))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest}
describe-configuration-options-request
  [m10750]
  (clojure.core/let
   [bean10749
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest)]
   (clojure.core/let
    [v10751
     (:options m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (.
      bean10749
      setOptions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10826]
  (elasticbeanstalk/option-specification arg10826))
 v10751))))
   (clojure.core/let
    [v10751
     (:environment-name
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setEnvironmentName (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:application-name
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setApplicationName (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:template-name m10750 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setTemplateName (clojure.core/str v10751))))
   (clojure.core/let
    [v10751
     (:solution-stack-name
      m10750
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10751 :com.palletops.awaze.client-builder/undef)
     (. bean10749 setSolutionStackName (clojure.core/str v10751))))
   bean10749))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest}
create-configuration-template-request
  [m10753]
  (clojure.core/let
   [bean10752
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10754
     (:description m10753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setDescription (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:environment-id
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setEnvironmentId (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:application-name
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setApplicationName (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:template-name m10753 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setTemplateName (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:solution-stack-name
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (. bean10752 setSolutionStackName (clojure.core/str v10754))))
   (clojure.core/let
    [v10754
     (:source-configuration
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (.
      bean10752
      setSourceConfiguration
      (elasticbeanstalk/source-configuration v10754))))
   (clojure.core/let
    [v10754
     (:option-settings
      m10753
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10754 :com.palletops.awaze.client-builder/undef)
     (.
      bean10752
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10827]
  (elasticbeanstalk/configuration-option-setting arg10827))
 v10754))))
   bean10752))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest}
update-environment-request
  [m10756]
  (clojure.core/let
   [bean10755
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest)]
   (clojure.core/let
    [v10757
     (:option-settings
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (.
      bean10755
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10828]
  (elasticbeanstalk/configuration-option-setting arg10828))
 v10757))))
   (clojure.core/let
    [v10757
     (:description m10756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setDescription (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:solution-stack-name
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setSolutionStackName (clojure.core/str v10757))))
   (clojure.core/let
    [v10757 (:tier m10756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setTier (elasticbeanstalk/environment-tier v10757))))
   (clojure.core/let
    [v10757
     (:version-label m10756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setVersionLabel (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:template-name m10756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setTemplateName (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:environment-name
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setEnvironmentName (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:options-to-remove
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (.
      bean10755
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10829]
  (elasticbeanstalk/option-specification arg10829))
 v10757))))
   (clojure.core/let
    [v10757
     (:group-name m10756 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setGroupName (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:environment-id
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setEnvironmentId (clojure.core/str v10757))))
   (clojure.core/let
    [v10757
     (:application-name
      m10756
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10757 :com.palletops.awaze.client-builder/undef)
     (. bean10755 setApplicationName (clojure.core/str v10757))))
   bean10755))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest}
describe-applications-request
  [m10759]
  (clojure.core/let
   [bean10758
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest)]
   (clojure.core/let
    [v10760
     (:application-names
      m10759
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10760 :com.palletops.awaze.client-builder/undef)
     (.
      bean10758
      setApplicationNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10830] (clojure.core/str arg10830))
 v10760))))
   bean10758))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest}
create-storage-location-request
  [m10762]
  (clojure.core/let
   [bean10761
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest)]
   bean10761))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest}
restart-app-server-request
  [m10765]
  (clojure.core/let
   [bean10764
    (new
     com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest)]
   (clojure.core/let
    [v10766
     (:environment-id
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setEnvironmentId (clojure.core/str v10766))))
   (clojure.core/let
    [v10766
     (:environment-name
      m10765
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10766 :com.palletops.awaze.client-builder/undef)
     (. bean10764 setEnvironmentName (clojure.core/str v10766))))
   bean10764))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest}
delete-application-request
  [m10768]
  (clojure.core/let
   [bean10767
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest)]
   (clojure.core/let
    [v10769
     (:application-name
      m10768
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10769 :com.palletops.awaze.client-builder/undef)
     (. bean10767 setApplicationName (clojure.core/str v10769))))
   (clojure.core/let
    [v10769
     (:terminate-env-by-force
      m10768
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10769 :com.palletops.awaze.client-builder/undef)
     (.
      bean10767
      setTerminateEnvByForce
      (clojure.core/boolean v10769))))
   bean10767))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest}
create-application-request
  [m10771]
  (clojure.core/let
   [bean10770
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest)]
   (clojure.core/let
    [v10772
     (:description m10771 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10772 :com.palletops.awaze.client-builder/undef)
     (. bean10770 setDescription (clojure.core/str v10772))))
   (clojure.core/let
    [v10772
     (:application-name
      m10771
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10772 :com.palletops.awaze.client-builder/undef)
     (. bean10770 setApplicationName (clojure.core/str v10772))))
   bean10770))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest}
delete-configuration-template-request
  [m10774]
  (clojure.core/let
   [bean10773
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest)]
   (clojure.core/let
    [v10775
     (:application-name
      m10774
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setApplicationName (clojure.core/str v10775))))
   (clojure.core/let
    [v10775
     (:template-name m10774 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10775 :com.palletops.awaze.client-builder/undef)
     (. bean10773 setTemplateName (clojure.core/str v10775))))
   bean10773))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest}
swap-environment-cnames-request
  [m10777]
  (clojure.core/let
   [bean10776
    (new
     com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest)]
   (clojure.core/let
    [v10778
     (:source-environment-id
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (. bean10776 setSourceEnvironmentId (clojure.core/str v10778))))
   (clojure.core/let
    [v10778
     (:source-environment-name
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (. bean10776 setSourceEnvironmentName (clojure.core/str v10778))))
   (clojure.core/let
    [v10778
     (:destination-environment-id
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (.
      bean10776
      setDestinationEnvironmentId
      (clojure.core/str v10778))))
   (clojure.core/let
    [v10778
     (:destination-environment-name
      m10777
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10778 :com.palletops.awaze.client-builder/undef)
     (.
      bean10776
      setDestinationEnvironmentName
      (clojure.core/str v10778))))
   bean10776))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest}
describe-environment-health-request
  [m10780]
  (clojure.core/let
   [bean10779
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest)]
   (clojure.core/let
    [v10781
     (:attribute-names
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (.
      bean10779
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10831] (clojure.core/str arg10831))
 v10781))))
   (clojure.core/let
    [v10781
     (:environment-id
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setEnvironmentId (clojure.core/str v10781))))
   (clojure.core/let
    [v10781
     (:environment-name
      m10780
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10781 :com.palletops.awaze.client-builder/undef)
     (. bean10779 setEnvironmentName (clojure.core/str v10781))))
   bean10779))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest}
abort-environment-update-request
  [m10783]
  (clojure.core/let
   [bean10782
    (new
     com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest)]
   (clojure.core/let
    [v10784
     (:environment-id
      m10783
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10784 :com.palletops.awaze.client-builder/undef)
     (. bean10782 setEnvironmentId (clojure.core/str v10784))))
   (clojure.core/let
    [v10784
     (:environment-name
      m10783
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10784 :com.palletops.awaze.client-builder/undef)
     (. bean10782 setEnvironmentName (clojure.core/str v10784))))
   bean10782))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest}
check-dnsavailability-request
  [m10786]
  (clojure.core/let
   [bean10785
    (new
     com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest)]
   (clojure.core/let
    [v10787
     (:cnameprefix m10786 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10787 :com.palletops.awaze.client-builder/undef)
     (. bean10785 setCNAMEPrefix (clojure.core/str v10787))))
   bean10785))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest}
retrieve-environment-info-request
  [m10789]
  (clojure.core/let
   [bean10788
    (new
     com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest)]
   (clojure.core/let
    [v10790
     (:environment-id
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setEnvironmentId (clojure.core/str v10790))))
   (clojure.core/let
    [v10790
     (:environment-name
      m10789
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (. bean10788 setEnvironmentName (clojure.core/str v10790))))
   (clojure.core/let
    [v10790
     (:info-type m10789 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10790 :com.palletops.awaze.client-builder/undef)
     (.
      bean10788
      setInfoType
      (elasticbeanstalk/environment-info-type v10790))))
   bean10788))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest}
create-application-version-request
  [m10792]
  (clojure.core/let
   [bean10791
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest)]
   (clojure.core/let
    [v10793
     (:description m10792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setDescription (clojure.core/str v10793))))
   (clojure.core/let
    [v10793
     (:application-name
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setApplicationName (clojure.core/str v10793))))
   (clojure.core/let
    [v10793
     (:version-label m10792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setVersionLabel (clojure.core/str v10793))))
   (clojure.core/let
    [v10793
     (:auto-create-application
      m10792
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (.
      bean10791
      setAutoCreateApplication
      (clojure.core/boolean v10793))))
   (clojure.core/let
    [v10793
     (:source-bundle m10792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (.
      bean10791
      setSourceBundle
      (elasticbeanstalk/s3location v10793))))
   (clojure.core/let
    [v10793
     (:process m10792 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10793 :com.palletops.awaze.client-builder/undef)
     (. bean10791 setProcess (clojure.core/boolean v10793))))
   bean10791))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest}
describe-environments-request
  [m10795]
  (clojure.core/let
   [bean10794
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest)]
   (clojure.core/let
    [v10796
     (:application-name
      m10795
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (. bean10794 setApplicationName (clojure.core/str v10796))))
   (clojure.core/let
    [v10796
     (:version-label m10795 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (. bean10794 setVersionLabel (clojure.core/str v10796))))
   (clojure.core/let
    [v10796
     (:environment-ids
      m10795
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (.
      bean10794
      setEnvironmentIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10872] (clojure.core/str arg10872))
 v10796))))
   (clojure.core/let
    [v10796
     (:environment-names
      m10795
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (.
      bean10794
      setEnvironmentNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10873] (clojure.core/str arg10873))
 v10796))))
   (clojure.core/let
    [v10796
     (:include-deleted
      m10795
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (. bean10794 setIncludeDeleted (clojure.core/boolean v10796))))
   (clojure.core/let
    [v10796
     (:included-deleted-back-to
      m10795
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10796 :com.palletops.awaze.client-builder/undef)
     (.
      bean10794
      setIncludedDeletedBackTo
      (com.palletops.awaze.common/to-date v10796))))
   bean10794))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest}
update-configuration-template-request
  [m10798]
  (clojure.core/let
   [bean10797
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest)]
   (clojure.core/let
    [v10799
     (:options-to-remove
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (.
      bean10797
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10874]
  (elasticbeanstalk/option-specification arg10874))
 v10799))))
   (clojure.core/let
    [v10799
     (:description m10798 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setDescription (clojure.core/str v10799))))
   (clojure.core/let
    [v10799
     (:application-name
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setApplicationName (clojure.core/str v10799))))
   (clojure.core/let
    [v10799
     (:template-name m10798 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (. bean10797 setTemplateName (clojure.core/str v10799))))
   (clojure.core/let
    [v10799
     (:option-settings
      m10798
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10799 :com.palletops.awaze.client-builder/undef)
     (.
      bean10797
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10875]
  (elasticbeanstalk/configuration-option-setting arg10875))
 v10799))))
   bean10797))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest}
describe-environment-resources-request
  [m10801]
  (clojure.core/let
   [bean10800
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest)]
   (clojure.core/let
    [v10802
     (:environment-id
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setEnvironmentId (clojure.core/str v10802))))
   (clojure.core/let
    [v10802
     (:environment-name
      m10801
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10802 :com.palletops.awaze.client-builder/undef)
     (. bean10800 setEnvironmentName (clojure.core/str v10802))))
   bean10800))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest}
list-available-solution-stacks-request
  [m10804]
  (clojure.core/let
   [bean10803
    (new
     com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest)]
   bean10803))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest}
validate-configuration-settings-request
  [m10807]
  (clojure.core/let
   [bean10806
    (new
     com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest)]
   (clojure.core/let
    [v10808
     (:environment-name
      m10807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (. bean10806 setEnvironmentName (clojure.core/str v10808))))
   (clojure.core/let
    [v10808
     (:application-name
      m10807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (. bean10806 setApplicationName (clojure.core/str v10808))))
   (clojure.core/let
    [v10808
     (:template-name m10807 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (. bean10806 setTemplateName (clojure.core/str v10808))))
   (clojure.core/let
    [v10808
     (:option-settings
      m10807
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10808 :com.palletops.awaze.client-builder/undef)
     (.
      bean10806
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10876]
  (elasticbeanstalk/configuration-option-setting arg10876))
 v10808))))
   bean10806))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest}
describe-instances-health-request
  [m10810]
  (clojure.core/let
   [bean10809
    (new
     com.amazonaws.services.elasticbeanstalk.model.DescribeInstancesHealthRequest)]
   (clojure.core/let
    [v10811
     (:attribute-names
      m10810
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10811 :com.palletops.awaze.client-builder/undef)
     (.
      bean10809
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10877] (clojure.core/str arg10877))
 v10811))))
   (clojure.core/let
    [v10811
     (:next-token m10810 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10811 :com.palletops.awaze.client-builder/undef)
     (. bean10809 setNextToken (clojure.core/str v10811))))
   (clojure.core/let
    [v10811
     (:environment-id
      m10810
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10811 :com.palletops.awaze.client-builder/undef)
     (. bean10809 setEnvironmentId (clojure.core/str v10811))))
   (clojure.core/let
    [v10811
     (:environment-name
      m10810
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10811 :com.palletops.awaze.client-builder/undef)
     (. bean10809 setEnvironmentName (clojure.core/str v10811))))
   bean10809))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest}
update-application-request
  [m10813]
  (clojure.core/let
   [bean10812
    (new
     com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest)]
   (clojure.core/let
    [v10814
     (:description m10813 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10814 :com.palletops.awaze.client-builder/undef)
     (. bean10812 setDescription (clojure.core/str v10814))))
   (clojure.core/let
    [v10814
     (:application-name
      m10813
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10814 :com.palletops.awaze.client-builder/undef)
     (. bean10812 setApplicationName (clojure.core/str v10814))))
   bean10812))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest}
request-environment-info-request
  [m10816]
  (clojure.core/let
   [bean10815
    (new
     com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest)]
   (clojure.core/let
    [v10817
     (:environment-id
      m10816
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (. bean10815 setEnvironmentId (clojure.core/str v10817))))
   (clojure.core/let
    [v10817
     (:environment-name
      m10816
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (. bean10815 setEnvironmentName (clojure.core/str v10817))))
   (clojure.core/let
    [v10817
     (:info-type m10816 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10817 :com.palletops.awaze.client-builder/undef)
     (.
      bean10815
      setInfoType
      (elasticbeanstalk/environment-info-type v10817))))
   bean10815))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest}
create-environment-request
  [m10819]
  (clojure.core/let
   [bean10818
    (new
     com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest)]
   (clojure.core/let
    [v10820
     (:option-settings
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (.
      bean10818
      setOptionSettings
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10878]
  (elasticbeanstalk/configuration-option-setting arg10878))
 v10820))))
   (clojure.core/let
    [v10820
     (:description m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setDescription (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:cnameprefix m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setCNAMEPrefix (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:solution-stack-name
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setSolutionStackName (clojure.core/str v10820))))
   (clojure.core/let
    [v10820 (:tier m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setTier (elasticbeanstalk/environment-tier v10820))))
   (clojure.core/let
    [v10820
     (:version-label m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setVersionLabel (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:template-name m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setTemplateName (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:environment-name
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setEnvironmentName (clojure.core/str v10820))))
   (clojure.core/let
    [v10820 (:tags m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (.
      bean10818
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg10879] (elasticbeanstalk/tag arg10879))
 v10820))))
   (clojure.core/let
    [v10820
     (:options-to-remove
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (.
      bean10818
      setOptionsToRemove
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg10880]
  (elasticbeanstalk/option-specification arg10880))
 v10820))))
   (clojure.core/let
    [v10820
     (:group-name m10819 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setGroupName (clojure.core/str v10820))))
   (clojure.core/let
    [v10820
     (:application-name
      m10819
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10820 :com.palletops.awaze.client-builder/undef)
     (. bean10818 setApplicationName (clojure.core/str v10820))))
   bean10818))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest}
delete-application-version-request
  [m10822]
  (clojure.core/let
   [bean10821
    (new
     com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest)]
   (clojure.core/let
    [v10823
     (:application-name
      m10822
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10823 :com.palletops.awaze.client-builder/undef)
     (. bean10821 setApplicationName (clojure.core/str v10823))))
   (clojure.core/let
    [v10823
     (:version-label m10822 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10823 :com.palletops.awaze.client-builder/undef)
     (. bean10821 setVersionLabel (clojure.core/str v10823))))
   (clojure.core/let
    [v10823
     (:delete-source-bundle
      m10822
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v10823 :com.palletops.awaze.client-builder/undef)
     (. bean10821 setDeleteSourceBundle (clojure.core/boolean v10823))))
   bean10821))
 (clojure.core/defmulti
  elasticbeanstalk
  (clojure.core/fn
   elasticbeanstalk
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-application-versions
   [m10832]
   (clojure.core/let
    [credentials10833 (:credentials m10832) args10834 (:args m10832)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10835
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10833)]
     (clojure.core/case
      (clojure.core/count args10834)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10835
        describeApplicationVersions
        (elasticbeanstalk/describe-application-versions-request
         (clojure.core/nth args10834 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10835
        describeApplicationVersions))))))
  (clojure.core/defn
   describe-application-versions-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeApplicationVersions, describeApplicationVersions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-application-versions,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-application-versions
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeApplicationVersions, describeApplicationVersions"}
   [credentials10837 & args10838]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10839
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10837)]
    (clojure.core/case
     (clojure.core/count args10838)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10839
       describeApplicationVersions
       (elasticbeanstalk/describe-application-versions-request
        (clojure.core/nth args10838 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10839
       describeApplicationVersions))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :compose-environments
   [m10840]
   (clojure.core/let
    [credentials10841 (:credentials m10840) args10842 (:args m10840)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10843
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10841)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10843
       composeEnvironments
       (elasticbeanstalk/compose-environments-request
        (clojure.core/nth args10842 0)))))))
  (clojure.core/defn
   compose-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for composeEnvironments"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :compose-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   compose-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         version-labels
                         sdk-request-timeout
                         custom-query-parameters
                         group-name
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call composeEnvironments"}
   [credentials10845 & args10846]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10847
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10845)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10847
      composeEnvironments
      (elasticbeanstalk/compose-environments-request
       (clojure.core/nth args10846 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :rebuild-environment
   [m10848]
   (clojure.core/let
    [credentials10849 (:credentials m10848) args10850 (:args m10848)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10851
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10849)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10851
       rebuildEnvironment
       (elasticbeanstalk/rebuild-environment-request
        (clojure.core/nth args10850 0)))))))
  (clojure.core/defn
   rebuild-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for rebuildEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :rebuild-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   rebuild-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call rebuildEnvironment"}
   [credentials10853 & args10854]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10855
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10853)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10855
      rebuildEnvironment
      (elasticbeanstalk/rebuild-environment-request
       (clojure.core/nth args10854 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application-version
   [m10856]
   (clojure.core/let
    [credentials10857 (:credentials m10856) args10858 (:args m10856)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10859
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10857)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10859
       updateApplicationVersion
       (elasticbeanstalk/update-application-version-request
        (clojure.core/nth args10858 0)))))))
  (clojure.core/defn
   update-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplicationVersion"}
   [credentials10861 & args10862]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10863
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10861)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10863
      updateApplicationVersion
      (elasticbeanstalk/update-application-version-request
       (clojure.core/nth args10862 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-environment-configuration
   [m10864]
   (clojure.core/let
    [credentials10865 (:credentials m10864) args10866 (:args m10864)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10867
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10865)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10867
       deleteEnvironmentConfiguration
       (elasticbeanstalk/delete-environment-configuration-request
        (clojure.core/nth args10866 0)))))))
  (clojure.core/defn
   delete-environment-configuration-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for deleteEnvironmentConfiguration"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-environment-configuration,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-environment-configuration
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call deleteEnvironmentConfiguration"}
   [credentials10869 & args10870]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10871
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10869)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10871
      deleteEnvironmentConfiguration
      (elasticbeanstalk/delete-environment-configuration-request
       (clojure.core/nth args10870 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-events
   [m10881]
   (clojure.core/let
    [credentials10882 (:credentials m10881) args10883 (:args m10881)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10884
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10882)]
     (clojure.core/case
      (clojure.core/count args10883)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10884
        describeEvents
        (elasticbeanstalk/describe-events-request
         (clojure.core/nth args10883 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10884
        describeEvents))))))
  (clojure.core/defn
   describe-events-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for describeEvents, describeEvents"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-events,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-events
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         request-id
                         application-name
                         sdk-request-timeout
                         start-time
                         custom-query-parameters
                         end-time
                         version-label
                         read-limit
                         general-progress-listener
                         severity
                         max-records
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call describeEvents, describeEvents"}
   [credentials10886 & args10887]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10888
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10886)]
    (clojure.core/case
     (clojure.core/count args10887)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10888
       describeEvents
       (elasticbeanstalk/describe-events-request
        (clojure.core/nth args10887 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10888
       describeEvents))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-settings
   [m10889]
   (clojure.core/let
    [credentials10890 (:credentials m10889) args10891 (:args m10889)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10892
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10890)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10892
       describeConfigurationSettings
       (elasticbeanstalk/describe-configuration-settings-request
        (clojure.core/nth args10891 0)))))))
  (clojure.core/defn
   describe-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationSettings"}
   [credentials10894 & args10895]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10896
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10894)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10896
      describeConfigurationSettings
      (elasticbeanstalk/describe-configuration-settings-request
       (clojure.core/nth args10895 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :terminate-environment
   [m10897]
   (clojure.core/let
    [credentials10898 (:credentials m10897) args10899 (:args m10897)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10900
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10898)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10900
       terminateEnvironment
       (elasticbeanstalk/terminate-environment-request
        (clojure.core/nth args10899 0)))))))
  (clojure.core/defn
   terminate-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for terminateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :terminate-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   terminate-environment
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         terminate-resources
                         custom-query-parameters
                         force-terminate
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call terminateEnvironment"}
   [credentials10902 & args10903]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10904
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10902)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10904
      terminateEnvironment
      (elasticbeanstalk/terminate-environment-request
       (clojure.core/nth args10903 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-configuration-options
   [m10905]
   (clojure.core/let
    [credentials10906 (:credentials m10905) args10907 (:args m10905)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10908
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10906)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10908
       describeConfigurationOptions
       (elasticbeanstalk/describe-configuration-options-request
        (clojure.core/nth args10907 0)))))))
  (clojure.core/defn
   describe-configuration-options-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeConfigurationOptions"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-configuration-options,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-configuration-options
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         options
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeConfigurationOptions"}
   [credentials10910 & args10911]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10912
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10910)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10912
      describeConfigurationOptions
      (elasticbeanstalk/describe-configuration-options-request
       (clojure.core/nth args10911 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-configuration-template
   [m10913]
   (clojure.core/let
    [credentials10914 (:credentials m10913) args10915 (:args m10913)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10916
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10914)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10916
       createConfigurationTemplate
       (elasticbeanstalk/create-configuration-template-request
        (clojure.core/nth args10915 0)))))))
  (clojure.core/defn
   create-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         source-configuration
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call createConfigurationTemplate"}
   [credentials10918 & args10919]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10920
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10918)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10920
      createConfigurationTemplate
      (elasticbeanstalk/create-configuration-template-request
       (clojure.core/nth args10919 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-environment
   [m10921]
   (clojure.core/let
    [credentials10922 (:credentials m10921) args10923 (:args m10921)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10924
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10922)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10924
       updateEnvironment
       (elasticbeanstalk/update-environment-request
        (clojure.core/nth args10923 0)))))))
  (clojure.core/defn
   update-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for updateEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         tier
                         environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call updateEnvironment"}
   [credentials10926 & args10927]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10928
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10926)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10928
      updateEnvironment
      (elasticbeanstalk/update-environment-request
       (clojure.core/nth args10927 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-applications
   [m10929]
   (clojure.core/let
    [credentials10930 (:credentials m10929) args10931 (:args m10929)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10932
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10930)]
     (clojure.core/case
      (clojure.core/count args10931)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10932
        describeApplications))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10932
        describeApplications
        (elasticbeanstalk/describe-applications-request
         (clojure.core/nth args10931 0))))))))
  (clojure.core/defn
   describe-applications-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Generate map for describeApplications, describeApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-applications,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-applications
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         application-names]}]]),
    :doc "Call describeApplications, describeApplications"}
   [credentials10934 & args10935]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10936
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10934)]
    (clojure.core/case
     (clojure.core/count args10935)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10936
       describeApplications))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10936
       describeApplications
       (elasticbeanstalk/describe-applications-request
        (clojure.core/nth args10935 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-storage-location
   [m10937]
   (clojure.core/let
    [credentials10938 (:credentials m10937) args10939 (:args m10937)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10940
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10938)]
     (clojure.core/case
      (clojure.core/count args10939)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10940
        createStorageLocation))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10940
        createStorageLocation
        (elasticbeanstalk/create-storage-location-request
         (clojure.core/nth args10939 0))))))))
  (clojure.core/defn
   create-storage-location-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createStorageLocation, createStorageLocation"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-storage-location,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-storage-location
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createStorageLocation, createStorageLocation"}
   [credentials10942 & args10943]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10944
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10942)]
    (clojure.core/case
     (clojure.core/count args10943)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10944
       createStorageLocation))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10944
       createStorageLocation
       (elasticbeanstalk/create-storage-location-request
        (clojure.core/nth args10943 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :restart-app-server
   [m10945]
   (clojure.core/let
    [credentials10946 (:credentials m10945) args10947 (:args m10945)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10948
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10946)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10948
       restartAppServer
       (elasticbeanstalk/restart-app-server-request
        (clojure.core/nth args10947 0)))))))
  (clojure.core/defn
   restart-app-server-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for restartAppServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :restart-app-server,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   restart-app-server
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call restartAppServer"}
   [credentials10950 & args10951]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10952
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10950)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10952
      restartAppServer
      (elasticbeanstalk/restart-app-server-request
       (clojure.core/nth args10951 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application
   [m10953]
   (clojure.core/let
    [credentials10954 (:credentials m10953) args10955 (:args m10953)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10956
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10954)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10956
       deleteApplication
       (elasticbeanstalk/delete-application-request
        (clojure.core/nth args10955 0)))))))
  (clojure.core/defn
   delete-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         terminate-env-by-force
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplication"}
   [credentials10958 & args10959]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10960
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10958)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10960
      deleteApplication
      (elasticbeanstalk/delete-application-request
       (clojure.core/nth args10959 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application
   [m10961]
   (clojure.core/let
    [credentials10962 (:credentials m10961) args10963 (:args m10961)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10964
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10962)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10964
       createApplication
       (elasticbeanstalk/create-application-request
        (clojure.core/nth args10963 0)))))))
  (clojure.core/defn
   create-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createApplication"}
   [credentials10966 & args10967]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10968
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10966)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10968
      createApplication
      (elasticbeanstalk/create-application-request
       (clojure.core/nth args10967 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-configuration-template
   [m10969]
   (clojure.core/let
    [credentials10970 (:credentials m10969) args10971 (:args m10969)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10972
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10970)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10972
       deleteConfigurationTemplate
       (elasticbeanstalk/delete-configuration-template-request
        (clojure.core/nth args10971 0)))))))
  (clojure.core/defn
   delete-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteConfigurationTemplate"}
   [credentials10974 & args10975]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10976
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10974)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10976
      deleteConfigurationTemplate
      (elasticbeanstalk/delete-configuration-template-request
       (clojure.core/nth args10975 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :swap-environment-cnames
   [m10977]
   (clojure.core/let
    [credentials10978 (:credentials m10977) args10979 (:args m10977)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10980
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10978)]
     (clojure.core/case
      (clojure.core/count args10979)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10980
        swapEnvironmentCNAMEs))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10980
        swapEnvironmentCNAMEs
        (elasticbeanstalk/swap-environment-cnames-request
         (clojure.core/nth args10979 0))))))))
  (clojure.core/defn
   swap-environment-cnames-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]]),
    :doc "Generate map for swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :swap-environment-cnames,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   swap-environment-cnames
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [source-environment-id
                         source-environment-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         destination-environment-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         destination-environment-id]}]]),
    :doc "Call swapEnvironmentCNAMEs, swapEnvironmentCNAMEs"}
   [credentials10982 & args10983]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10984
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10982)]
    (clojure.core/case
     (clojure.core/count args10983)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10984
       swapEnvironmentCNAMEs))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10984
       swapEnvironmentCNAMEs
       (elasticbeanstalk/swap-environment-cnames-request
        (clojure.core/nth args10983 0))))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-health
   [m10985]
   (clojure.core/let
    [credentials10986 (:credentials m10985) args10987 (:args m10985)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10988
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10986)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10988
       describeEnvironmentHealth
       (elasticbeanstalk/describe-environment-health-request
        (clojure.core/nth args10987 0)))))))
  (clojure.core/defn
   describe-environment-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentHealth"}
   [credentials10990 & args10991]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client10992
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10990)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10992
      describeEnvironmentHealth
      (elasticbeanstalk/describe-environment-health-request
       (clojure.core/nth args10991 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :abort-environment-update
   [m10993]
   (clojure.core/let
    [credentials10994 (:credentials m10993) args10995 (:args m10993)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client10996
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials10994)]
     (clojure.core/case
      (clojure.core/count args10995)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10996
        abortEnvironmentUpdate
        (elasticbeanstalk/abort-environment-update-request
         (clojure.core/nth args10995 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client10996
        abortEnvironmentUpdate))))))
  (clojure.core/defn
   abort-environment-update-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for abortEnvironmentUpdate, abortEnvironmentUpdate"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-environment-update,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   abort-environment-update
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]
                [credentials]]),
    :doc "Call abortEnvironmentUpdate, abortEnvironmentUpdate"}
   [credentials10998 & args10999]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11000
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials10998)]
    (clojure.core/case
     (clojure.core/count args10999)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11000
       abortEnvironmentUpdate
       (elasticbeanstalk/abort-environment-update-request
        (clojure.core/nth args10999 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11000
       abortEnvironmentUpdate))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :check-dnsavailability
   [m11001]
   (clojure.core/let
    [credentials11002 (:credentials m11001) args11003 (:args m11001)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11004
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11002)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11004
       checkDNSAvailability
       (elasticbeanstalk/check-dnsavailability-request
        (clojure.core/nth args11003 0)))))))
  (clojure.core/defn
   check-dnsavailability-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for checkDNSAvailability"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :check-dnsavailability,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   check-dnsavailability
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cnameprefix
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call checkDNSAvailability"}
   [credentials11006 & args11007]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11008
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11006)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11008
      checkDNSAvailability
      (elasticbeanstalk/check-dnsavailability-request
       (clojure.core/nth args11007 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :retrieve-environment-info
   [m11009]
   (clojure.core/let
    [credentials11010 (:credentials m11009) args11011 (:args m11009)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11012
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11010)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11012
       retrieveEnvironmentInfo
       (elasticbeanstalk/retrieve-environment-info-request
        (clojure.core/nth args11011 0)))))))
  (clojure.core/defn
   retrieve-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for retrieveEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :retrieve-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   retrieve-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call retrieveEnvironmentInfo"}
   [credentials11014 & args11015]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11016
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11014)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11016
      retrieveEnvironmentInfo
      (elasticbeanstalk/retrieve-environment-info-request
       (clojure.core/nth args11015 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-application-version
   [m11017]
   (clojure.core/let
    [credentials11018 (:credentials m11017) args11019 (:args m11017)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11020
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11018)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11020
       createApplicationVersion
       (elasticbeanstalk/create-application-version-request
        (clojure.core/nth args11019 0)))))))
  (clojure.core/defn
   create-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Generate map for createApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-application-version
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         process
                         custom-query-parameters
                         source-bundle
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         auto-create-application]}]]),
    :doc "Call createApplicationVersion"}
   [credentials11022 & args11023]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11024
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11022)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11024
      createApplicationVersion
      (elasticbeanstalk/create-application-version-request
       (clojure.core/nth args11023 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environments
   [m11025]
   (clojure.core/let
    [credentials11026 (:credentials m11025) args11027 (:args m11025)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11028
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11026)]
     (clojure.core/case
      (clojure.core/count args11027)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11028
        describeEnvironments
        (elasticbeanstalk/describe-environments-request
         (clojure.core/nth args11027 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11028
        describeEnvironments))))))
  (clojure.core/defn
   describe-environments-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]
                [credentials]]),
    :doc "Generate map for describeEnvironments, describeEnvironments"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environments,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environments
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         include-deleted
                         application-name
                         environment-ids
                         sdk-request-timeout
                         included-deleted-back-to
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         environment-names]}]
                [credentials]]),
    :doc "Call describeEnvironments, describeEnvironments"}
   [credentials11030 & args11031]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11032
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11030)]
    (clojure.core/case
     (clojure.core/count args11031)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11032
       describeEnvironments
       (elasticbeanstalk/describe-environments-request
        (clojure.core/nth args11031 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11032
       describeEnvironments))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-configuration-template
   [m11033]
   (clojure.core/let
    [credentials11034 (:credentials m11033) args11035 (:args m11033)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11036
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11034)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11036
       updateConfigurationTemplate
       (elasticbeanstalk/update-configuration-template-request
        (clojure.core/nth args11035 0)))))))
  (clojure.core/defn
   update-configuration-template-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateConfigurationTemplate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-configuration-template,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-configuration-template
   {:arglists (quote
               [[credentials
                 {:keys [description
                         template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         clone-root]}]]),
    :doc "Call updateConfigurationTemplate"}
   [credentials11038 & args11039]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11040
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11038)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11040
      updateConfigurationTemplate
      (elasticbeanstalk/update-configuration-template-request
       (clojure.core/nth args11039 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-environment-resources
   [m11041]
   (clojure.core/let
    [credentials11042 (:credentials m11041) args11043 (:args m11041)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11044
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11042)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11044
       describeEnvironmentResources
       (elasticbeanstalk/describe-environment-resources-request
        (clojure.core/nth args11043 0)))))))
  (clojure.core/defn
   describe-environment-resources-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for describeEnvironmentResources"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-environment-resources,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-environment-resources
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call describeEnvironmentResources"}
   [credentials11046 & args11047]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11048
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11046)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11048
      describeEnvironmentResources
      (elasticbeanstalk/describe-environment-resources-request
       (clojure.core/nth args11047 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :list-available-solution-stacks
   [m11049]
   (clojure.core/let
    [credentials11050 (:credentials m11049) args11051 (:args m11049)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11052
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11050)]
     (clojure.core/case
      (clojure.core/count args11051)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11052
        listAvailableSolutionStacks
        (elasticbeanstalk/list-available-solution-stacks-request
         (clojure.core/nth args11051 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11052
        listAvailableSolutionStacks))))))
  (clojure.core/defn
   list-available-solution-stacks-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listAvailableSolutionStacks, listAvailableSolutionStacks"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-available-solution-stacks,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   list-available-solution-stacks
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listAvailableSolutionStacks, listAvailableSolutionStacks"}
   [credentials11054 & args11055]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11056
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11054)]
    (clojure.core/case
     (clojure.core/count args11055)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11056
       listAvailableSolutionStacks
       (elasticbeanstalk/list-available-solution-stacks-request
        (clojure.core/nth args11055 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11056
       listAvailableSolutionStacks))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :validate-configuration-settings
   [m11057]
   (clojure.core/let
    [credentials11058 (:credentials m11057) args11059 (:args m11057)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11060
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11058)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11060
       validateConfigurationSettings
       (elasticbeanstalk/validate-configuration-settings-request
        (clojure.core/nth args11059 0)))))))
  (clojure.core/defn
   validate-configuration-settings-map
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for validateConfigurationSettings"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :validate-configuration-settings,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   validate-configuration-settings
   {:arglists (quote
               [[credentials
                 {:keys [template-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call validateConfigurationSettings"}
   [credentials11062 & args11063]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11064
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11062)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11064
      validateConfigurationSettings
      (elasticbeanstalk/validate-configuration-settings-request
       (clojure.core/nth args11063 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :describe-instances-health
   [m11065]
   (clojure.core/let
    [credentials11066 (:credentials m11065) args11067 (:args m11065)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11068
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11066)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11068
       describeInstancesHealth
       (elasticbeanstalk/describe-instances-health-request
        (clojure.core/nth args11067 0)))))))
  (clojure.core/defn
   describe-instances-health-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Generate map for describeInstancesHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instances-health,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   describe-instances-health
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root
                         next-token]}]]),
    :doc "Call describeInstancesHealth"}
   [credentials11070 & args11071]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11072
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11070)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11072
      describeInstancesHealth
      (elasticbeanstalk/describe-instances-health-request
       (clojure.core/nth args11071 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :update-application
   [m11073]
   (clojure.core/let
    [credentials11074 (:credentials m11073) args11075 (:args m11073)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11076
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11074)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11076
       updateApplication
       (elasticbeanstalk/update-application-request
        (clojure.core/nth args11075 0)))))))
  (clojure.core/defn
   update-application-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-application,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   update-application
   {:arglists (quote
               [[credentials
                 {:keys [description
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateApplication"}
   [credentials11078 & args11079]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11080
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11078)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11080
      updateApplication
      (elasticbeanstalk/update-application-request
       (clojure.core/nth args11079 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :request-environment-info
   [m11081]
   (clojure.core/let
    [credentials11082 (:credentials m11081) args11083 (:args m11081)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11084
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11082)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11084
       requestEnvironmentInfo
       (elasticbeanstalk/request-environment-info-request
        (clojure.core/nth args11083 0)))))))
  (clojure.core/defn
   request-environment-info-map
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for requestEnvironmentInfo"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :request-environment-info,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   request-environment-info
   {:arglists (quote
               [[credentials
                 {:keys [environment-id
                         custom-request-headers
                         info-type
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call requestEnvironmentInfo"}
   [credentials11086 & args11087]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11088
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11086)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11088
      requestEnvironmentInfo
      (elasticbeanstalk/request-environment-info-request
       (clojure.core/nth args11087 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :create-environment
   [m11089]
   (clojure.core/let
    [credentials11090 (:credentials m11089) args11091 (:args m11089)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11092
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11090)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11092
       createEnvironment
       (elasticbeanstalk/create-environment-request
        (clojure.core/nth args11091 0)))))))
  (clojure.core/defn
   create-environment-map
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Generate map for createEnvironment"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-environment,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   create-environment
   {:arglists (quote
               [[credentials
                 {:keys [description
                         tags
                         template-name
                         tier
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         options-to-remove
                         cnameprefix
                         custom-query-parameters
                         version-label
                         group-name
                         read-limit
                         solution-stack-name
                         general-progress-listener
                         option-settings
                         clone-source
                         environment-name
                         clone-root]}]]),
    :doc "Call createEnvironment"}
   [credentials11094 & args11095]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11096
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11094)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11096
      createEnvironment
      (elasticbeanstalk/create-environment-request
       (clojure.core/nth args11095 0)))))))
 (do
  (clojure.core/defmethod
   elasticbeanstalk
   :delete-application-version
   [m11097]
   (clojure.core/let
    [credentials11098 (:credentials m11097) args11099 (:args m11097)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
      client11100
      (com.palletops.awaze.common/aws-client
       :elasticbeanstalk
       credentials11098)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11100
       deleteApplicationVersion
       (elasticbeanstalk/delete-application-version-request
        (clojure.core/nth args11099 0)))))))
  (clojure.core/defn
   delete-application-version-map
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteApplicationVersion"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-application-version,
     :credentials credentials__1842__auto__,
     :client :elasticbeanstalk}))
  (clojure.core/defn
   delete-application-version
   {:arglists (quote
               [[credentials
                 {:keys [delete-source-bundle
                         custom-request-headers
                         sdk-client-execution-timeout
                         application-name
                         sdk-request-timeout
                         custom-query-parameters
                         version-label
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteApplicationVersion"}
   [credentials11102 & args11103]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
     client11104
     (com.palletops.awaze.common/aws-client
      :elasticbeanstalk
      credentials11102)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient}
client11104
      deleteApplicationVersion
      (elasticbeanstalk/delete-application-version-request
       (clojure.core/nth args11103 0))))))))
