(ns
 com.palletops.awaze.elasticloadbalancing
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.elasticloadbalancing :as elasticloadbalancing]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :elasticloadbalancing
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing}
cross-zone-load-balancing
  [m4541]
  (clojure.core/let
   [bean4540
    (new
     com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing)]
   (clojure.core/let
    [v4542 (:enabled m4541 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4542 :com.palletops.awaze.client-builder/undef)
     (. bean4540 setEnabled (clojure.core/boolean v4542))))
   bean4540))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AccessLog}
access-log
  [m4544]
  (clojure.core/let
   [bean4543
    (new com.amazonaws.services.elasticloadbalancing.model.AccessLog)]
   (clojure.core/let
    [v4545
     (:s3bucket-name m4544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (. bean4543 setS3BucketName (clojure.core/str v4545))))
   (clojure.core/let
    [v4545
     (:emit-interval m4544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (. bean4543 setEmitInterval (clojure.core/int v4545))))
   (clojure.core/let
    [v4545
     (:s3bucket-prefix
      m4544
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (. bean4543 setS3BucketPrefix (clojure.core/str v4545))))
   (clojure.core/let
    [v4545 (:enabled m4544 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4545 :com.palletops.awaze.client-builder/undef)
     (. bean4543 setEnabled (clojure.core/boolean v4545))))
   bean4543))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining}
connection-draining
  [m4547]
  (clojure.core/let
   [bean4546
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionDraining)]
   (clojure.core/let
    [v4548 (:timeout m4547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4548 :com.palletops.awaze.client-builder/undef)
     (. bean4546 setTimeout (clojure.core/int v4548))))
   (clojure.core/let
    [v4548 (:enabled m4547 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4548 :com.palletops.awaze.client-builder/undef)
     (. bean4546 setEnabled (clojure.core/boolean v4548))))
   bean4546))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings}
connection-settings
  [m4550]
  (clojure.core/let
   [bean4549
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConnectionSettings)]
   (clojure.core/let
    [v4551
     (:idle-timeout m4550 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4551 :com.palletops.awaze.client-builder/undef)
     (. bean4549 setIdleTimeout (clojure.core/int v4551))))
   bean4549))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute}
additional-attribute
  [m4553]
  (clojure.core/let
   [bean4552
    (new
     com.amazonaws.services.elasticloadbalancing.model.AdditionalAttribute)]
   (clojure.core/let
    [v4554 (:key m4553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setKey (clojure.core/str v4554))))
   (clojure.core/let
    [v4554 (:value m4553 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4554 :com.palletops.awaze.client-builder/undef)
     (. bean4552 setValue (clojure.core/str v4554))))
   bean4552))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Tag}
tag
  [m4556]
  (clojure.core/let
   [bean4555
    (new com.amazonaws.services.elasticloadbalancing.model.Tag)]
   (clojure.core/let
    [v4557 (:key m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setKey (clojure.core/str v4557))))
   (clojure.core/let
    [v4557 (:value m4556 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4557 :com.palletops.awaze.client-builder/undef)
     (. bean4555 setValue (clojure.core/str v4557))))
   bean4555))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Listener}
listener
  [m4559]
  (clojure.core/let
   [bean4558
    (new com.amazonaws.services.elasticloadbalancing.model.Listener)]
   (clojure.core/let
    [v4560
     (:sslcertificate-id
      m4559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setSSLCertificateId (clojure.core/str v4560))))
   (clojure.core/let
    [v4560
     (:load-balancer-port
      m4559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setLoadBalancerPort (clojure.core/int v4560))))
   (clojure.core/let
    [v4560
     (:protocol m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setProtocol (clojure.core/str v4560))))
   (clojure.core/let
    [v4560
     (:instance-port m4559 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setInstancePort (clojure.core/int v4560))))
   (clojure.core/let
    [v4560
     (:instance-protocol
      m4559
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4560 :com.palletops.awaze.client-builder/undef)
     (. bean4558 setInstanceProtocol (clojure.core/str v4560))))
   bean4558))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly}
tag-key-only
  [m4562]
  (clojure.core/let
   [bean4561
    (new com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly)]
   (clojure.core/let
    [v4563 (:key m4562 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4563 :com.palletops.awaze.client-builder/undef)
     (. bean4561 setKey (clojure.core/str v4563))))
   bean4561))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute}
policy-attribute
  [m4565]
  (clojure.core/let
   [bean4564
    (new
     com.amazonaws.services.elasticloadbalancing.model.PolicyAttribute)]
   (clojure.core/let
    [v4566
     (:attribute-name m4565 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setAttributeName (clojure.core/str v4566))))
   (clojure.core/let
    [v4566
     (:attribute-value
      m4565
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4566 :com.palletops.awaze.client-builder/undef)
     (. bean4564 setAttributeValue (clojure.core/str v4566))))
   bean4564))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.Instance}
instance
  [m4568]
  (clojure.core/let
   [bean4567
    (new com.amazonaws.services.elasticloadbalancing.model.Instance)]
   (clojure.core/let
    [v4569
     (:instance-id m4568 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4569 :com.palletops.awaze.client-builder/undef)
     (. bean4567 setInstanceId (clojure.core/str v4569))))
   bean4567))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes}
load-balancer-attributes
  [m4571]
  (clojure.core/let
   [bean4570
    (new
     com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes)]
   (clojure.core/let
    [v4572
     (:cross-zone-load-balancing
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setCrossZoneLoadBalancing
      (elasticloadbalancing/cross-zone-load-balancing v4572))))
   (clojure.core/let
    [v4572
     (:access-log m4571 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (. bean4570 setAccessLog (elasticloadbalancing/access-log v4572))))
   (clojure.core/let
    [v4572
     (:connection-draining
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setConnectionDraining
      (elasticloadbalancing/connection-draining v4572))))
   (clojure.core/let
    [v4572
     (:connection-settings
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setConnectionSettings
      (elasticloadbalancing/connection-settings v4572))))
   (clojure.core/let
    [v4572
     (:additional-attributes
      m4571
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4572 :com.palletops.awaze.client-builder/undef)
     (.
      bean4570
      setAdditionalAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4660]
  (elasticloadbalancing/additional-attribute arg4660))
 v4572))))
   bean4570))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.HealthCheck}
health-check
  [m4574]
  (clojure.core/let
   [bean4573
    (new
     com.amazonaws.services.elasticloadbalancing.model.HealthCheck)]
   (clojure.core/let
    [v4575 (:timeout m4574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setTimeout (clojure.core/int v4575))))
   (clojure.core/let
    [v4575
     (:unhealthy-threshold
      m4574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setUnhealthyThreshold (clojure.core/int v4575))))
   (clojure.core/let
    [v4575
     (:healthy-threshold
      m4574
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setHealthyThreshold (clojure.core/int v4575))))
   (clojure.core/let
    [v4575
     (:interval m4574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setInterval (clojure.core/int v4575))))
   (clojure.core/let
    [v4575 (:target m4574 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4575 :com.palletops.awaze.client-builder/undef)
     (. bean4573 setTarget (clojure.core/str v4575))))
   bean4573))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest}
create-load-balancer-request
  [m4577]
  (clojure.core/let
   [bean4576
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest)]
   (clojure.core/let
    [v4578
     (:load-balancer-name
      m4577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (. bean4576 setLoadBalancerName (clojure.core/str v4578))))
   (clojure.core/let
    [v4578
     (:security-groups
      m4577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (.
      bean4576
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4661] (clojure.core/str arg4661))
 v4578))))
   (clojure.core/let
    [v4578 (:tags m4577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (.
      bean4576
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4662] (elasticloadbalancing/tag arg4662))
 v4578))))
   (clojure.core/let
    [v4578
     (:listeners m4577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (.
      bean4576
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4663] (elasticloadbalancing/listener arg4663))
 v4578))))
   (clojure.core/let
    [v4578 (:scheme m4577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (. bean4576 setScheme (clojure.core/str v4578))))
   (clojure.core/let
    [v4578
     (:availability-zones
      m4577
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (.
      bean4576
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4664] (clojure.core/str arg4664))
 v4578))))
   (clojure.core/let
    [v4578 (:subnets m4577 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4578 :com.palletops.awaze.client-builder/undef)
     (.
      bean4576
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4665] (clojure.core/str arg4665))
 v4578))))
   bean4576))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest}
delete-load-balancer-listeners-request
  [m4580]
  (clojure.core/let
   [bean4579
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4581
     (:load-balancer-name
      m4580
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (. bean4579 setLoadBalancerName (clojure.core/str v4581))))
   (clojure.core/let
    [v4581
     (:load-balancer-ports
      m4580
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4581 :com.palletops.awaze.client-builder/undef)
     (.
      bean4579
      setLoadBalancerPorts
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4666] (clojure.core/int arg4666))
 v4581))))
   bean4579))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest}
enable-availability-zones-for-load-balancer-request
  [m4583]
  (clojure.core/let
   [bean4582
    (new
     com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4584
     (:load-balancer-name
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (. bean4582 setLoadBalancerName (clojure.core/str v4584))))
   (clojure.core/let
    [v4584
     (:availability-zones
      m4583
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4584 :com.palletops.awaze.client-builder/undef)
     (.
      bean4582
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4667] (clojure.core/str arg4667))
 v4584))))
   bean4582))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest}
describe-load-balancers-request
  [m4586]
  (clojure.core/let
   [bean4585
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest)]
   (clojure.core/let
    [v4587 (:marker m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setMarker (clojure.core/str v4587))))
   (clojure.core/let
    [v4587
     (:load-balancer-names
      m4586
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (.
      bean4585
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4668] (clojure.core/str arg4668))
 v4587))))
   (clojure.core/let
    [v4587
     (:page-size m4586 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4587 :com.palletops.awaze.client-builder/undef)
     (. bean4585 setPageSize (clojure.core/int v4587))))
   bean4585))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest}
delete-load-balancer-policy-request
  [m4589]
  (clojure.core/let
   [bean4588
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4590
     (:load-balancer-name
      m4589
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setLoadBalancerName (clojure.core/str v4590))))
   (clojure.core/let
    [v4590
     (:policy-name m4589 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4590 :com.palletops.awaze.client-builder/undef)
     (. bean4588 setPolicyName (clojure.core/str v4590))))
   bean4588))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest}
describe-load-balancer-policies-request
  [m4592]
  (clojure.core/let
   [bean4591
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest)]
   (clojure.core/let
    [v4593
     (:load-balancer-name
      m4592
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (. bean4591 setLoadBalancerName (clojure.core/str v4593))))
   (clojure.core/let
    [v4593
     (:policy-names m4592 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4593 :com.palletops.awaze.client-builder/undef)
     (.
      bean4591
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4669] (clojure.core/str arg4669))
 v4593))))
   bean4591))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest}
remove-tags-request
  [m4595]
  (clojure.core/let
   [bean4594
    (new
     com.amazonaws.services.elasticloadbalancing.model.RemoveTagsRequest)]
   (clojure.core/let
    [v4596
     (:load-balancer-names
      m4595
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (.
      bean4594
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4670] (clojure.core/str arg4670))
 v4596))))
   (clojure.core/let
    [v4596 (:tags m4595 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4596 :com.palletops.awaze.client-builder/undef)
     (.
      bean4594
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4671]
  (elasticloadbalancing/tag-key-only arg4671))
 v4596))))
   bean4594))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest}
create-load-balancer-policy-request
  [m4598]
  (clojure.core/let
   [bean4597
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest)]
   (clojure.core/let
    [v4599
     (:policy-type-name
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setPolicyTypeName (clojure.core/str v4599))))
   (clojure.core/let
    [v4599
     (:load-balancer-name
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setLoadBalancerName (clojure.core/str v4599))))
   (clojure.core/let
    [v4599
     (:policy-name m4598 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (. bean4597 setPolicyName (clojure.core/str v4599))))
   (clojure.core/let
    [v4599
     (:policy-attributes
      m4598
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4599 :com.palletops.awaze.client-builder/undef)
     (.
      bean4597
      setPolicyAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg4672]
  (elasticloadbalancing/policy-attribute arg4672))
 v4599))))
   bean4597))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest}
create-load-balancer-listeners-request
  [m4601]
  (clojure.core/let
   [bean4600
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest)]
   (clojure.core/let
    [v4602
     (:load-balancer-name
      m4601
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (. bean4600 setLoadBalancerName (clojure.core/str v4602))))
   (clojure.core/let
    [v4602
     (:listeners m4601 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4602 :com.palletops.awaze.client-builder/undef)
     (.
      bean4600
      setListeners
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4673] (elasticloadbalancing/listener arg4673))
 v4602))))
   bean4600))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest}
set-load-balancer-policies-for-backend-server-request
  [m4604]
  (clojure.core/let
   [bean4603
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest)]
   (clojure.core/let
    [v4605
     (:load-balancer-name
      m4604
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (. bean4603 setLoadBalancerName (clojure.core/str v4605))))
   (clojure.core/let
    [v4605
     (:policy-names m4604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (.
      bean4603
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4674] (clojure.core/str arg4674))
 v4605))))
   (clojure.core/let
    [v4605
     (:instance-port m4604 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4605 :com.palletops.awaze.client-builder/undef)
     (. bean4603 setInstancePort (clojure.core/int v4605))))
   bean4603))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest}
describe-instance-health-request
  [m4607]
  (clojure.core/let
   [bean4606
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest)]
   (clojure.core/let
    [v4608
     (:load-balancer-name
      m4607
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (. bean4606 setLoadBalancerName (clojure.core/str v4608))))
   (clojure.core/let
    [v4608
     (:instances m4607 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4608 :com.palletops.awaze.client-builder/undef)
     (.
      bean4606
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4675] (elasticloadbalancing/instance arg4675))
 v4608))))
   bean4606))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest}
delete-load-balancer-request
  [m4610]
  (clojure.core/let
   [bean4609
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest)]
   (clojure.core/let
    [v4611
     (:load-balancer-name
      m4610
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4611 :com.palletops.awaze.client-builder/undef)
     (. bean4609 setLoadBalancerName (clojure.core/str v4611))))
   bean4609))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest}
detach-load-balancer-from-subnets-request
  [m4613]
  (clojure.core/let
   [bean4612
    (new
     com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest)]
   (clojure.core/let
    [v4614
     (:load-balancer-name
      m4613
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (. bean4612 setLoadBalancerName (clojure.core/str v4614))))
   (clojure.core/let
    [v4614 (:subnets m4613 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4614 :com.palletops.awaze.client-builder/undef)
     (.
      bean4612
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4676] (clojure.core/str arg4676))
 v4614))))
   bean4612))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest}
disable-availability-zones-for-load-balancer-request
  [m4616]
  (clojure.core/let
   [bean4615
    (new
     com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest)]
   (clojure.core/let
    [v4617
     (:load-balancer-name
      m4616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (. bean4615 setLoadBalancerName (clojure.core/str v4617))))
   (clojure.core/let
    [v4617
     (:availability-zones
      m4616
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4617 :com.palletops.awaze.client-builder/undef)
     (.
      bean4615
      setAvailabilityZones
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4677] (clojure.core/str arg4677))
 v4617))))
   bean4615))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest}
set-load-balancer-policies-of-listener-request
  [m4619]
  (clojure.core/let
   [bean4618
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest)]
   (clojure.core/let
    [v4620
     (:load-balancer-port
      m4619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (. bean4618 setLoadBalancerPort (clojure.core/int v4620))))
   (clojure.core/let
    [v4620
     (:load-balancer-name
      m4619
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (. bean4618 setLoadBalancerName (clojure.core/str v4620))))
   (clojure.core/let
    [v4620
     (:policy-names m4619 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4620 :com.palletops.awaze.client-builder/undef)
     (.
      bean4618
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4678] (clojure.core/str arg4678))
 v4620))))
   bean4618))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest}
add-tags-request
  [m4622]
  (clojure.core/let
   [bean4621
    (new
     com.amazonaws.services.elasticloadbalancing.model.AddTagsRequest)]
   (clojure.core/let
    [v4623
     (:load-balancer-names
      m4622
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4623 :com.palletops.awaze.client-builder/undef)
     (.
      bean4621
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4679] (clojure.core/str arg4679))
 v4623))))
   (clojure.core/let
    [v4623 (:tags m4622 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4623 :com.palletops.awaze.client-builder/undef)
     (.
      bean4621
      setTags
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4680] (elasticloadbalancing/tag arg4680))
 v4623))))
   bean4621))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest}
register-instances-with-load-balancer-request
  [m4625]
  (clojure.core/let
   [bean4624
    (new
     com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest)]
   (clojure.core/let
    [v4626
     (:load-balancer-name
      m4625
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (. bean4624 setLoadBalancerName (clojure.core/str v4626))))
   (clojure.core/let
    [v4626
     (:instances m4625 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4626 :com.palletops.awaze.client-builder/undef)
     (.
      bean4624
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4681] (elasticloadbalancing/instance arg4681))
 v4626))))
   bean4624))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest}
describe-tags-request
  [m4628]
  (clojure.core/let
   [bean4627
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeTagsRequest)]
   (clojure.core/let
    [v4629
     (:load-balancer-names
      m4628
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4629 :com.palletops.awaze.client-builder/undef)
     (.
      bean4627
      setLoadBalancerNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4682] (clojure.core/str arg4682))
 v4629))))
   bean4627))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest}
create-app-cookie-stickiness-policy-request
  [m4631]
  (clojure.core/let
   [bean4630
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4632
     (:load-balancer-name
      m4631
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setLoadBalancerName (clojure.core/str v4632))))
   (clojure.core/let
    [v4632
     (:policy-name m4631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setPolicyName (clojure.core/str v4632))))
   (clojure.core/let
    [v4632
     (:cookie-name m4631 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4632 :com.palletops.awaze.client-builder/undef)
     (. bean4630 setCookieName (clojure.core/str v4632))))
   bean4630))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest}
modify-load-balancer-attributes-request
  [m4634]
  (clojure.core/let
   [bean4633
    (new
     com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4635
     (:load-balancer-name
      m4634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (. bean4633 setLoadBalancerName (clojure.core/str v4635))))
   (clojure.core/let
    [v4635
     (:load-balancer-attributes
      m4634
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4635 :com.palletops.awaze.client-builder/undef)
     (.
      bean4633
      setLoadBalancerAttributes
      (elasticloadbalancing/load-balancer-attributes v4635))))
   bean4633))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest}
set-load-balancer-listener-sslcertificate-request
  [m4637]
  (clojure.core/let
   [bean4636
    (new
     com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest)]
   (clojure.core/let
    [v4638
     (:sslcertificate-id
      m4637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (. bean4636 setSSLCertificateId (clojure.core/str v4638))))
   (clojure.core/let
    [v4638
     (:load-balancer-port
      m4637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (. bean4636 setLoadBalancerPort (clojure.core/int v4638))))
   (clojure.core/let
    [v4638
     (:load-balancer-name
      m4637
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4638 :com.palletops.awaze.client-builder/undef)
     (. bean4636 setLoadBalancerName (clojure.core/str v4638))))
   bean4636))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest}
describe-load-balancer-attributes-request
  [m4640]
  (clojure.core/let
   [bean4639
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest)]
   (clojure.core/let
    [v4641
     (:load-balancer-name
      m4640
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4641 :com.palletops.awaze.client-builder/undef)
     (. bean4639 setLoadBalancerName (clojure.core/str v4641))))
   bean4639))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest}
configure-health-check-request
  [m4643]
  (clojure.core/let
   [bean4642
    (new
     com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest)]
   (clojure.core/let
    [v4644
     (:load-balancer-name
      m4643
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (. bean4642 setLoadBalancerName (clojure.core/str v4644))))
   (clojure.core/let
    [v4644
     (:health-check m4643 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4644 :com.palletops.awaze.client-builder/undef)
     (.
      bean4642
      setHealthCheck
      (elasticloadbalancing/health-check v4644))))
   bean4642))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest}
attach-load-balancer-to-subnets-request
  [m4646]
  (clojure.core/let
   [bean4645
    (new
     com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest)]
   (clojure.core/let
    [v4647
     (:load-balancer-name
      m4646
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (. bean4645 setLoadBalancerName (clojure.core/str v4647))))
   (clojure.core/let
    [v4647 (:subnets m4646 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4647 :com.palletops.awaze.client-builder/undef)
     (.
      bean4645
      setSubnets
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4731] (clojure.core/str arg4731))
 v4647))))
   bean4645))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest}
describe-load-balancer-policy-types-request
  [m4649]
  (clojure.core/let
   [bean4648
    (new
     com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest)]
   (clojure.core/let
    [v4650
     (:policy-type-names
      m4649
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4650 :com.palletops.awaze.client-builder/undef)
     (.
      bean4648
      setPolicyTypeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4732] (clojure.core/str arg4732))
 v4650))))
   bean4648))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest}
deregister-instances-from-load-balancer-request
  [m4652]
  (clojure.core/let
   [bean4651
    (new
     com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest)]
   (clojure.core/let
    [v4653
     (:load-balancer-name
      m4652
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (. bean4651 setLoadBalancerName (clojure.core/str v4653))))
   (clojure.core/let
    [v4653
     (:instances m4652 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4653 :com.palletops.awaze.client-builder/undef)
     (.
      bean4651
      setInstances
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4733] (elasticloadbalancing/instance arg4733))
 v4653))))
   bean4651))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest}
apply-security-groups-to-load-balancer-request
  [m4655]
  (clojure.core/let
   [bean4654
    (new
     com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest)]
   (clojure.core/let
    [v4656
     (:load-balancer-name
      m4655
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4656 :com.palletops.awaze.client-builder/undef)
     (. bean4654 setLoadBalancerName (clojure.core/str v4656))))
   (clojure.core/let
    [v4656
     (:security-groups
      m4655
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4656 :com.palletops.awaze.client-builder/undef)
     (.
      bean4654
      setSecurityGroups
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg4734] (clojure.core/str arg4734))
 v4656))))
   bean4654))
 (clojure.core/defn
^{:tag com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest}
create-lbcookie-stickiness-policy-request
  [m4658]
  (clojure.core/let
   [bean4657
    (new
     com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest)]
   (clojure.core/let
    [v4659
     (:load-balancer-name
      m4658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (. bean4657 setLoadBalancerName (clojure.core/str v4659))))
   (clojure.core/let
    [v4659
     (:policy-name m4658 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (. bean4657 setPolicyName (clojure.core/str v4659))))
   (clojure.core/let
    [v4659
     (:cookie-expiration-period
      m4658
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v4659 :com.palletops.awaze.client-builder/undef)
     (. bean4657 setCookieExpirationPeriod (clojure.core/long v4659))))
   bean4657))
 (clojure.core/defmulti
  elasticloadbalancing
  (clojure.core/fn
   elasticloadbalancing
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer
   [m4683]
   (clojure.core/let
    [credentials4684 (:credentials m4683) args4685 (:args m4683)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4686
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4684)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4686
       createLoadBalancer
       (elasticloadbalancing/create-load-balancer-request
        (clojure.core/nth args4685 0)))))))
  (clojure.core/defn
   create-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Generate map for createLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root
                         scheme]}]]),
    :doc "Call createLoadBalancer"}
   [credentials4688 & args4689]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4690
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4688)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4690
      createLoadBalancer
      (elasticloadbalancing/create-load-balancer-request
       (clojure.core/nth args4689 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-listeners
   [m4691]
   (clojure.core/let
    [credentials4692 (:credentials m4691) args4693 (:args m4691)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4694
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4692)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4694
       deleteLoadBalancerListeners
       (elasticloadbalancing/delete-load-balancer-listeners-request
        (clojure.core/nth args4693 0)))))))
  (clojure.core/defn
   delete-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-ports
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerListeners"}
   [credentials4696 & args4697]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4698
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4696)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4698
      deleteLoadBalancerListeners
      (elasticloadbalancing/delete-load-balancer-listeners-request
       (clojure.core/nth args4697 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :enable-availability-zones-for-load-balancer
   [m4699]
   (clojure.core/let
    [credentials4700 (:credentials m4699) args4701 (:args m4699)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4702
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4700)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4702
       enableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4701 0)))))))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for enableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :enable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   enable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call enableAvailabilityZonesForLoadBalancer"}
   [credentials4704 & args4705]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4706
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4704)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4706
      enableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/enable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4705 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancers
   [m4707]
   (clojure.core/let
    [credentials4708 (:credentials m4707) args4709 (:args m4707)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4710
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4708)]
     (clojure.core/case
      (clojure.core/count args4709)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4710
        describeLoadBalancers))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4710
        describeLoadBalancers
        (elasticloadbalancing/describe-load-balancers-request
         (clojure.core/nth args4709 0))))))))
  (clojure.core/defn
   describe-load-balancers-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancers, describeLoadBalancers"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancers,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancers
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         marker
                         page-size
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancers, describeLoadBalancers"}
   [credentials4712 & args4713]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4714
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4712)]
    (clojure.core/case
     (clojure.core/count args4713)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4714
       describeLoadBalancers))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4714
       describeLoadBalancers
       (elasticloadbalancing/describe-load-balancers-request
        (clojure.core/nth args4713 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer-policy
   [m4715]
   (clojure.core/let
    [credentials4716 (:credentials m4715) args4717 (:args m4715)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4718
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4716)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4718
       deleteLoadBalancerPolicy
       (elasticloadbalancing/delete-load-balancer-policy-request
        (clojure.core/nth args4717 0)))))))
  (clojure.core/defn
   delete-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancerPolicy"}
   [credentials4720 & args4721]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4722
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4720)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4722
      deleteLoadBalancerPolicy
      (elasticloadbalancing/delete-load-balancer-policy-request
       (clojure.core/nth args4721 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policies
   [m4723]
   (clojure.core/let
    [credentials4724 (:credentials m4723) args4725 (:args m4723)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4726
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4724)]
     (clojure.core/case
      (clojure.core/count args4725)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4726
        describeLoadBalancerPolicies))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4726
        describeLoadBalancerPolicies
        (elasticloadbalancing/describe-load-balancer-policies-request
         (clojure.core/nth args4725 0))))))))
  (clojure.core/defn
   describe-load-balancer-policies-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policies,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policies
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerPolicies, describeLoadBalancerPolicies"}
   [credentials4728 & args4729]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4730
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4728)]
    (clojure.core/case
     (clojure.core/count args4729)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4730
       describeLoadBalancerPolicies))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4730
       describeLoadBalancerPolicies
       (elasticloadbalancing/describe-load-balancer-policies-request
        (clojure.core/nth args4729 0))))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :remove-tags
   [m4735]
   (clojure.core/let
    [credentials4736 (:credentials m4735) args4737 (:args m4735)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4738
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4736)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4738
       removeTags
       (elasticloadbalancing/remove-tags-request
        (clojure.core/nth args4737 0)))))))
  (clojure.core/defn
   remove-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   remove-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTags"}
   [credentials4740 & args4741]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4742
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4740)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4742
      removeTags
      (elasticloadbalancing/remove-tags-request
       (clojure.core/nth args4741 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-policy
   [m4743]
   (clojure.core/let
    [credentials4744 (:credentials m4743) args4745 (:args m4743)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4746
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4744)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4746
       createLoadBalancerPolicy
       (elasticloadbalancing/create-load-balancer-policy-request
        (clojure.core/nth args4745 0)))))))
  (clojure.core/defn
   create-load-balancer-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         policy-type-name
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         policy-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call createLoadBalancerPolicy"}
   [credentials4748 & args4749]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4750
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4748)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4750
      createLoadBalancerPolicy
      (elasticloadbalancing/create-load-balancer-policy-request
       (clojure.core/nth args4749 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-load-balancer-listeners
   [m4751]
   (clojure.core/let
    [credentials4752 (:credentials m4751) args4753 (:args m4751)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4754
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4752)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4754
       createLoadBalancerListeners
       (elasticloadbalancing/create-load-balancer-listeners-request
        (clojure.core/nth args4753 0)))))))
  (clojure.core/defn
   create-load-balancer-listeners-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Generate map for createLoadBalancerListeners"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-load-balancer-listeners,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-load-balancer-listeners
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         listeners
                         clone-root]}]]),
    :doc "Call createLoadBalancerListeners"}
   [credentials4756 & args4757]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4758
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4756)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4758
      createLoadBalancerListeners
      (elasticloadbalancing/create-load-balancer-listeners-request
       (clojure.core/nth args4757 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-for-backend-server
   [m4759]
   (clojure.core/let
    [credentials4760 (:credentials m4759) args4761 (:args m4759)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4762
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4760)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4762
       setLoadBalancerPoliciesForBackendServer
       (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
        (clojure.core/nth args4761 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setLoadBalancerPoliciesForBackendServer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-for-backend-server,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-for-backend-server
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         instance-port
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setLoadBalancerPoliciesForBackendServer"}
   [credentials4764 & args4765]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4766
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4764)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4766
      setLoadBalancerPoliciesForBackendServer
      (elasticloadbalancing/set-load-balancer-policies-for-backend-server-request
       (clojure.core/nth args4765 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-instance-health
   [m4767]
   (clojure.core/let
    [credentials4768 (:credentials m4767) args4769 (:args m4767)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4770
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4768)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4770
       describeInstanceHealth
       (elasticloadbalancing/describe-instance-health-request
        (clojure.core/nth args4769 0)))))))
  (clojure.core/defn
   describe-instance-health-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeInstanceHealth"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-instance-health,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-instance-health
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeInstanceHealth"}
   [credentials4772 & args4773]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4774
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4772)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4774
      describeInstanceHealth
      (elasticloadbalancing/describe-instance-health-request
       (clojure.core/nth args4773 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :delete-load-balancer
   [m4775]
   (clojure.core/let
    [credentials4776 (:credentials m4775) args4777 (:args m4775)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4778
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4776)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4778
       deleteLoadBalancer
       (elasticloadbalancing/delete-load-balancer-request
        (clojure.core/nth args4777 0)))))))
  (clojure.core/defn
   delete-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   delete-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteLoadBalancer"}
   [credentials4780 & args4781]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4782
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4780)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4782
      deleteLoadBalancer
      (elasticloadbalancing/delete-load-balancer-request
       (clojure.core/nth args4781 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :detach-load-balancer-from-subnets
   [m4783]
   (clojure.core/let
    [credentials4784 (:credentials m4783) args4785 (:args m4783)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4786
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4784)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4786
       detachLoadBalancerFromSubnets
       (elasticloadbalancing/detach-load-balancer-from-subnets-request
        (clojure.core/nth args4785 0)))))))
  (clojure.core/defn
   detach-load-balancer-from-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for detachLoadBalancerFromSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :detach-load-balancer-from-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   detach-load-balancer-from-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call detachLoadBalancerFromSubnets"}
   [credentials4788 & args4789]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4790
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4788)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4790
      detachLoadBalancerFromSubnets
      (elasticloadbalancing/detach-load-balancer-from-subnets-request
       (clojure.core/nth args4789 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :disable-availability-zones-for-load-balancer
   [m4791]
   (clojure.core/let
    [credentials4792 (:credentials m4791) args4793 (:args m4791)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4794
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4792)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4794
       disableAvailabilityZonesForLoadBalancer
       (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
        (clojure.core/nth args4793 0)))))))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for disableAvailabilityZonesForLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :disable-availability-zones-for-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   disable-availability-zones-for-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         availability-zones
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call disableAvailabilityZonesForLoadBalancer"}
   [credentials4796 & args4797]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4798
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4796)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4798
      disableAvailabilityZonesForLoadBalancer
      (elasticloadbalancing/disable-availability-zones-for-load-balancer-request
       (clojure.core/nth args4797 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-policies-of-listener
   [m4799]
   (clojure.core/let
    [credentials4800 (:credentials m4799) args4801 (:args m4799)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4802
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4800)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4802
       setLoadBalancerPoliciesOfListener
       (elasticloadbalancing/set-load-balancer-policies-of-listener-request
        (clojure.core/nth args4801 0)))))))
  (clojure.core/defn
   set-load-balancer-policies-of-listener-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerPoliciesOfListener"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-policies-of-listener,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-policies-of-listener
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerPoliciesOfListener"}
   [credentials4804 & args4805]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4806
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4804)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4806
      setLoadBalancerPoliciesOfListener
      (elasticloadbalancing/set-load-balancer-policies-of-listener-request
       (clojure.core/nth args4805 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :add-tags
   [m4807]
   (clojure.core/let
    [credentials4808 (:credentials m4807) args4809 (:args m4807)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4810
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4808)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4810
       addTags
       (elasticloadbalancing/add-tags-request
        (clojure.core/nth args4809 0)))))))
  (clojure.core/defn
   add-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   add-tags
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTags"}
   [credentials4812 & args4813]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4814
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4812)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4814
      addTags
      (elasticloadbalancing/add-tags-request
       (clojure.core/nth args4813 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :register-instances-with-load-balancer
   [m4815]
   (clojure.core/let
    [credentials4816 (:credentials m4815) args4817 (:args m4815)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4818
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4816)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4818
       registerInstancesWithLoadBalancer
       (elasticloadbalancing/register-instances-with-load-balancer-request
        (clojure.core/nth args4817 0)))))))
  (clojure.core/defn
   register-instances-with-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for registerInstancesWithLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :register-instances-with-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   register-instances-with-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call registerInstancesWithLoadBalancer"}
   [credentials4820 & args4821]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4822
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4820)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4822
      registerInstancesWithLoadBalancer
      (elasticloadbalancing/register-instances-with-load-balancer-request
       (clojure.core/nth args4821 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-tags
   [m4823]
   (clojure.core/let
    [credentials4824 (:credentials m4823) args4825 (:args m4823)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4826
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4824)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4826
       describeTags
       (elasticloadbalancing/describe-tags-request
        (clojure.core/nth args4825 0)))))))
  (clojure.core/defn
   describe-tags-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeTags"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-tags,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-tags
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         load-balancer-names
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeTags"}
   [credentials4828 & args4829]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4830
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4828)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4830
      describeTags
      (elasticloadbalancing/describe-tags-request
       (clojure.core/nth args4829 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-app-cookie-stickiness-policy
   [m4831]
   (clojure.core/let
    [credentials4832 (:credentials m4831) args4833 (:args m4831)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4834
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4832)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4834
       createAppCookieStickinessPolicy
       (elasticloadbalancing/create-app-cookie-stickiness-policy-request
        (clojure.core/nth args4833 0)))))))
  (clojure.core/defn
   create-app-cookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createAppCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-app-cookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-app-cookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         cookie-name
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createAppCookieStickinessPolicy"}
   [credentials4836 & args4837]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4838
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4836)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4838
      createAppCookieStickinessPolicy
      (elasticloadbalancing/create-app-cookie-stickiness-policy-request
       (clojure.core/nth args4837 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :modify-load-balancer-attributes
   [m4839]
   (clojure.core/let
    [credentials4840 (:credentials m4839) args4841 (:args m4839)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4842
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4840)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4842
       modifyLoadBalancerAttributes
       (elasticloadbalancing/modify-load-balancer-attributes-request
        (clojure.core/nth args4841 0)))))))
  (clojure.core/defn
   modify-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for modifyLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :modify-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   modify-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         load-balancer-attributes
                         clone-source
                         clone-root]}]]),
    :doc "Call modifyLoadBalancerAttributes"}
   [credentials4844 & args4845]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4846
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4844)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4846
      modifyLoadBalancerAttributes
      (elasticloadbalancing/modify-load-balancer-attributes-request
       (clojure.core/nth args4845 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :set-load-balancer-listener-sslcertificate
   [m4847]
   (clojure.core/let
    [credentials4848 (:credentials m4847) args4849 (:args m4847)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4850
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4848)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4850
       setLoadBalancerListenerSSLCertificate
       (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
        (clojure.core/nth args4849 0)))))))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Generate map for setLoadBalancerListenerSSLCertificate"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-load-balancer-listener-sslcertificate,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   set-load-balancer-listener-sslcertificate
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sslcertificate-id
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         load-balancer-port]}]]),
    :doc "Call setLoadBalancerListenerSSLCertificate"}
   [credentials4852 & args4853]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4854
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4852)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4854
      setLoadBalancerListenerSSLCertificate
      (elasticloadbalancing/set-load-balancer-listener-sslcertificate-request
       (clojure.core/nth args4853 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-attributes
   [m4855]
   (clojure.core/let
    [credentials4856 (:credentials m4855) args4857 (:args m4855)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4858
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4856)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4858
       describeLoadBalancerAttributes
       (elasticloadbalancing/describe-load-balancer-attributes-request
        (clojure.core/nth args4857 0)))))))
  (clojure.core/defn
   describe-load-balancer-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeLoadBalancerAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-attributes,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeLoadBalancerAttributes"}
   [credentials4860 & args4861]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4862
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4860)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4862
      describeLoadBalancerAttributes
      (elasticloadbalancing/describe-load-balancer-attributes-request
       (clojure.core/nth args4861 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :configure-health-check
   [m4863]
   (clojure.core/let
    [credentials4864 (:credentials m4863) args4865 (:args m4863)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4866
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4864)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4866
       configureHealthCheck
       (elasticloadbalancing/configure-health-check-request
        (clojure.core/nth args4865 0)))))))
  (clojure.core/defn
   configure-health-check-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for configureHealthCheck"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :configure-health-check,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   configure-health-check
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         health-check
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call configureHealthCheck"}
   [credentials4868 & args4869]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4870
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4868)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4870
      configureHealthCheck
      (elasticloadbalancing/configure-health-check-request
       (clojure.core/nth args4869 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :attach-load-balancer-to-subnets
   [m4871]
   (clojure.core/let
    [credentials4872 (:credentials m4871) args4873 (:args m4871)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4874
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4872)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4874
       attachLoadBalancerToSubnets
       (elasticloadbalancing/attach-load-balancer-to-subnets-request
        (clojure.core/nth args4873 0)))))))
  (clojure.core/defn
   attach-load-balancer-to-subnets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for attachLoadBalancerToSubnets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :attach-load-balancer-to-subnets,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   attach-load-balancer-to-subnets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         subnets
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call attachLoadBalancerToSubnets"}
   [credentials4876 & args4877]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4878
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4876)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4878
      attachLoadBalancerToSubnets
      (elasticloadbalancing/attach-load-balancer-to-subnets-request
       (clojure.core/nth args4877 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :describe-load-balancer-policy-types
   [m4879]
   (clojure.core/let
    [credentials4880 (:credentials m4879) args4881 (:args m4879)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4882
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4880)]
     (clojure.core/case
      (clojure.core/count args4881)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4882
        describeLoadBalancerPolicyTypes
        (elasticloadbalancing/describe-load-balancer-policy-types-request
         (clojure.core/nth args4881 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4882
        describeLoadBalancerPolicyTypes))))))
  (clojure.core/defn
   describe-load-balancer-policy-types-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-load-balancer-policy-types,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   describe-load-balancer-policy-types
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-type-names
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call describeLoadBalancerPolicyTypes, describeLoadBalancerPolicyTypes"}
   [credentials4884 & args4885]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4886
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4884)]
    (clojure.core/case
     (clojure.core/count args4885)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4886
       describeLoadBalancerPolicyTypes
       (elasticloadbalancing/describe-load-balancer-policy-types-request
        (clojure.core/nth args4885 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4886
       describeLoadBalancerPolicyTypes))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :deregister-instances-from-load-balancer
   [m4887]
   (clojure.core/let
    [credentials4888 (:credentials m4887) args4889 (:args m4887)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4890
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4888)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4890
       deregisterInstancesFromLoadBalancer
       (elasticloadbalancing/deregister-instances-from-load-balancer-request
        (clojure.core/nth args4889 0)))))))
  (clojure.core/defn
   deregister-instances-from-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deregisterInstancesFromLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :deregister-instances-from-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   deregister-instances-from-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         instances
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deregisterInstancesFromLoadBalancer"}
   [credentials4892 & args4893]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4894
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4892)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4894
      deregisterInstancesFromLoadBalancer
      (elasticloadbalancing/deregister-instances-from-load-balancer-request
       (clojure.core/nth args4893 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :apply-security-groups-to-load-balancer
   [m4895]
   (clojure.core/let
    [credentials4896 (:credentials m4895) args4897 (:args m4895)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4898
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4896)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4898
       applySecurityGroupsToLoadBalancer
       (elasticloadbalancing/apply-security-groups-to-load-balancer-request
        (clojure.core/nth args4897 0)))))))
  (clojure.core/defn
   apply-security-groups-to-load-balancer-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for applySecurityGroupsToLoadBalancer"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :apply-security-groups-to-load-balancer,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   apply-security-groups-to-load-balancer
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         security-groups
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call applySecurityGroupsToLoadBalancer"}
   [credentials4900 & args4901]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4902
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4900)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4902
      applySecurityGroupsToLoadBalancer
      (elasticloadbalancing/apply-security-groups-to-load-balancer-request
       (clojure.core/nth args4901 0)))))))
 (do
  (clojure.core/defmethod
   elasticloadbalancing
   :create-lbcookie-stickiness-policy
   [m4903]
   (clojure.core/let
    [credentials4904 (:credentials m4903) args4905 (:args m4903)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
      client4906
      (com.palletops.awaze.common/aws-client
       :elasticloadbalancing
       credentials4904)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4906
       createLBCookieStickinessPolicy
       (elasticloadbalancing/create-lbcookie-stickiness-policy-request
        (clojure.core/nth args4905 0)))))))
  (clojure.core/defn
   create-lbcookie-stickiness-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createLBCookieStickinessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-lbcookie-stickiness-policy,
     :credentials credentials__1842__auto__,
     :client :elasticloadbalancing}))
  (clojure.core/defn
   create-lbcookie-stickiness-policy
   {:arglists (quote
               [[credentials
                 {:keys [cookie-expiration-period
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         load-balancer-name
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createLBCookieStickinessPolicy"}
   [credentials4908 & args4909]
   (clojure.core/let
    [^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
     client4910
     (com.palletops.awaze.common/aws-client
      :elasticloadbalancing
      credentials4908)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancingClient}
client4910
      createLBCookieStickinessPolicy
      (elasticloadbalancing/create-lbcookie-stickiness-policy-request
       (clojure.core/nth args4909 0))))))))
