(ns
 com.palletops.awaze.glacier
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.glacier :as glacier]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :glacier
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.glacier.AmazonGlacierClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InventoryRetrievalJobInput}
inventory-retrieval-job-input
  [m5745]
  (clojure.core/let
   [bean5744
    (new
     com.amazonaws.services.glacier.model.InventoryRetrievalJobInput)]
   (clojure.core/let
    [v5746 (:limit m5745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5746 :com.palletops.awaze.client-builder/undef)
     (. bean5744 setLimit (clojure.core/str v5746))))
   (clojure.core/let
    [v5746 (:marker m5745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5746 :com.palletops.awaze.client-builder/undef)
     (. bean5744 setMarker (clojure.core/str v5746))))
   (clojure.core/let
    [v5746
     (:end-date m5745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5746 :com.palletops.awaze.client-builder/undef)
     (. bean5744 setEndDate (clojure.core/str v5746))))
   (clojure.core/let
    [v5746
     (:start-date m5745 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5746 :com.palletops.awaze.client-builder/undef)
     (. bean5744 setStartDate (clojure.core/str v5746))))
   bean5744))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalRule}
data-retrieval-rule
  [m5748]
  (clojure.core/let
   [bean5747
    (new com.amazonaws.services.glacier.model.DataRetrievalRule)]
   (clojure.core/let
    [v5749
     (:strategy m5748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5749 :com.palletops.awaze.client-builder/undef)
     (. bean5747 setStrategy (clojure.core/str v5749))))
   (clojure.core/let
    [v5749
     (:bytes-per-hour m5748 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5749 :com.palletops.awaze.client-builder/undef)
     (. bean5747 setBytesPerHour (clojure.core/long v5749))))
   bean5747))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.JobParameters}
job-parameters
  [m5751]
  (clojure.core/let
   [bean5750 (new com.amazonaws.services.glacier.model.JobParameters)]
   (clojure.core/let
    [v5752 (:format m5751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setFormat (clojure.core/str v5752))))
   (clojure.core/let
    [v5752
     (:description m5751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setDescription (clojure.core/str v5752))))
   (clojure.core/let
    [v5752 (:type m5751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setType (clojure.core/str v5752))))
   (clojure.core/let
    [v5752
     (:archive-id m5751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setArchiveId (clojure.core/str v5752))))
   (clojure.core/let
    [v5752
     (:snstopic m5751 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setSNSTopic (clojure.core/str v5752))))
   (clojure.core/let
    [v5752
     (:retrieval-byte-range
      m5751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (. bean5750 setRetrievalByteRange (clojure.core/str v5752))))
   (clojure.core/let
    [v5752
     (:inventory-retrieval-parameters
      m5751
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5752 :com.palletops.awaze.client-builder/undef)
     (.
      bean5750
      setInventoryRetrievalParameters
      (glacier/inventory-retrieval-job-input v5752))))
   bean5750))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultNotificationConfig}
vault-notification-config
  [m5754]
  (clojure.core/let
   [bean5753
    (new com.amazonaws.services.glacier.model.VaultNotificationConfig)]
   (clojure.core/let
    [v5755 (:events m5754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5755 :com.palletops.awaze.client-builder/undef)
     (.
      bean5753
      setEvents
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5858] (clojure.core/str arg5858))
 v5755))))
   (clojure.core/let
    [v5755
     (:snstopic m5754 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5755 :com.palletops.awaze.client-builder/undef)
     (. bean5753 setSNSTopic (clojure.core/str v5755))))
   bean5753))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultAccessPolicy}
vault-access-policy
  [m5757]
  (clojure.core/let
   [bean5756
    (new com.amazonaws.services.glacier.model.VaultAccessPolicy)]
   (clojure.core/let
    [v5758 (:policy m5757 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5758 :com.palletops.awaze.client-builder/undef)
     (. bean5756 setPolicy (clojure.core/str v5758))))
   bean5756))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.VaultLockPolicy}
vault-lock-policy
  [m5760]
  (clojure.core/let
   [bean5759
    (new com.amazonaws.services.glacier.model.VaultLockPolicy)]
   (clojure.core/let
    [v5761 (:policy m5760 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5761 :com.palletops.awaze.client-builder/undef)
     (. bean5759 setPolicy (clojure.core/str v5761))))
   bean5759))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DataRetrievalPolicy}
data-retrieval-policy
  [m5763]
  (clojure.core/let
   [bean5762
    (new com.amazonaws.services.glacier.model.DataRetrievalPolicy)]
   (clojure.core/let
    [v5764 (:rules m5763 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5764 :com.palletops.awaze.client-builder/undef)
     (.
      bean5762
      setRules
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5859] (glacier/data-retrieval-rule arg5859))
 v5764))))
   bean5762))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListMultipartUploadsRequest}
list-multipart-uploads-request
  [m5766]
  (clojure.core/let
   [bean5765
    (new
     com.amazonaws.services.glacier.model.ListMultipartUploadsRequest)]
   (clojure.core/let
    [v5767 (:limit m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setLimit (clojure.core/str v5767))))
   (clojure.core/let
    [v5767
     (:account-id m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setAccountId (clojure.core/str v5767))))
   (clojure.core/let
    [v5767
     (:vault-name m5766 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setVaultName (clojure.core/str v5767))))
   (clojure.core/let
    [v5767
     (:upload-id-marker
      m5766
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5767 :com.palletops.awaze.client-builder/undef)
     (. bean5765 setUploadIdMarker (clojure.core/str v5767))))
   bean5765))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultRequest}
delete-vault-request
  [m5769]
  (clojure.core/let
   [bean5768
    (new com.amazonaws.services.glacier.model.DeleteVaultRequest)]
   (clojure.core/let
    [v5770
     (:account-id m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setAccountId (clojure.core/str v5770))))
   (clojure.core/let
    [v5770
     (:vault-name m5769 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5770 :com.palletops.awaze.client-builder/undef)
     (. bean5768 setVaultName (clojure.core/str v5770))))
   bean5768))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteVaultLockRequest}
complete-vault-lock-request
  [m5772]
  (clojure.core/let
   [bean5771
    (new
     com.amazonaws.services.glacier.model.CompleteVaultLockRequest)]
   (clojure.core/let
    [v5773
     (:account-id m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (. bean5771 setAccountId (clojure.core/str v5773))))
   (clojure.core/let
    [v5773
     (:vault-name m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (. bean5771 setVaultName (clojure.core/str v5773))))
   (clojure.core/let
    [v5773 (:lock-id m5772 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5773 :com.palletops.awaze.client-builder/undef)
     (. bean5771 setLockId (clojure.core/str v5773))))
   bean5771))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest}
delete-vault-notifications-request
  [m5775]
  (clojure.core/let
   [bean5774
    (new
     com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest)]
   (clojure.core/let
    [v5776
     (:account-id m5775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5776 :com.palletops.awaze.client-builder/undef)
     (. bean5774 setAccountId (clojure.core/str v5776))))
   (clojure.core/let
    [v5776
     (:vault-name m5775 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5776 :com.palletops.awaze.client-builder/undef)
     (. bean5774 setVaultName (clojure.core/str v5776))))
   bean5774))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest}
delete-vault-access-policy-request
  [m5778]
  (clojure.core/let
   [bean5777
    (new
     com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5779
     (:account-id m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setAccountId (clojure.core/str v5779))))
   (clojure.core/let
    [v5779
     (:vault-name m5778 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5779 :com.palletops.awaze.client-builder/undef)
     (. bean5777 setVaultName (clojure.core/str v5779))))
   bean5777))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest}
remove-tags-from-vault-request
  [m5781]
  (clojure.core/let
   [bean5780
    (new
     com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest)]
   (clojure.core/let
    [v5782
     (:account-id m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (. bean5780 setAccountId (clojure.core/str v5782))))
   (clojure.core/let
    [v5782
     (:vault-name m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (. bean5780 setVaultName (clojure.core/str v5782))))
   (clojure.core/let
    [v5782
     (:tag-keys m5781 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5782 :com.palletops.awaze.client-builder/undef)
     (.
      bean5780
      setTagKeys
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5860] (clojure.core/str arg5860))
 v5782))))
   bean5780))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortMultipartUploadRequest}
abort-multipart-upload-request
  [m5784]
  (clojure.core/let
   [bean5783
    (new
     com.amazonaws.services.glacier.model.AbortMultipartUploadRequest)]
   (clojure.core/let
    [v5785
     (:account-id m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setAccountId (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:vault-name m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setVaultName (clojure.core/str v5785))))
   (clojure.core/let
    [v5785
     (:upload-id m5784 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5785 :com.palletops.awaze.client-builder/undef)
     (. bean5783 setUploadId (clojure.core/str v5785))))
   bean5783))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadMultipartPartRequest}
upload-multipart-part-request
  [m5787]
  (clojure.core/let
   [bean5786
    (new
     com.amazonaws.services.glacier.model.UploadMultipartPartRequest)]
   (clojure.core/let
    [v5788
     (:account-id m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setAccountId (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:vault-name m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setVaultName (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:upload-id m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setUploadId (clojure.core/str v5788))))
   (clojure.core/let
    [v5788 (:range m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setRange (clojure.core/str v5788))))
   (clojure.core/let
    [v5788
     (:checksum m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setChecksum (clojure.core/str v5788))))
   (clojure.core/let
    [v5788 (:body m5787 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5788 :com.palletops.awaze.client-builder/undef)
     (. bean5786 setBody (clojure.java.io/input-stream v5788))))
   bean5786))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListVaultsRequest}
list-vaults-request
  [m5790]
  (clojure.core/let
   [bean5789
    (new com.amazonaws.services.glacier.model.ListVaultsRequest)]
   (clojure.core/let
    [v5791 (:limit m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setLimit (clojure.core/str v5791))))
   (clojure.core/let
    [v5791
     (:account-id m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setAccountId (clojure.core/str v5791))))
   (clojure.core/let
    [v5791 (:marker m5790 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5791 :com.palletops.awaze.client-builder/undef)
     (. bean5789 setMarker (clojure.core/str v5791))))
   bean5789))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateJobRequest}
initiate-job-request
  [m5793]
  (clojure.core/let
   [bean5792
    (new com.amazonaws.services.glacier.model.InitiateJobRequest)]
   (clojure.core/let
    [v5794
     (:account-id m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setAccountId (clojure.core/str v5794))))
   (clojure.core/let
    [v5794
     (:vault-name m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setVaultName (clojure.core/str v5794))))
   (clojure.core/let
    [v5794
     (:job-parameters m5793 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5794 :com.palletops.awaze.client-builder/undef)
     (. bean5792 setJobParameters (glacier/job-parameters v5794))))
   bean5792))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListPartsRequest}
list-parts-request
  [m5796]
  (clojure.core/let
   [bean5795
    (new com.amazonaws.services.glacier.model.ListPartsRequest)]
   (clojure.core/let
    [v5797 (:limit m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setLimit (clojure.core/str v5797))))
   (clojure.core/let
    [v5797
     (:account-id m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setAccountId (clojure.core/str v5797))))
   (clojure.core/let
    [v5797
     (:vault-name m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setVaultName (clojure.core/str v5797))))
   (clojure.core/let
    [v5797 (:marker m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setMarker (clojure.core/str v5797))))
   (clojure.core/let
    [v5797
     (:upload-id m5796 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5797 :com.palletops.awaze.client-builder/undef)
     (. bean5795 setUploadId (clojure.core/str v5797))))
   bean5795))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultNotificationsRequest}
get-vault-notifications-request
  [m5799]
  (clojure.core/let
   [bean5798
    (new
     com.amazonaws.services.glacier.model.GetVaultNotificationsRequest)]
   (clojure.core/let
    [v5800
     (:account-id m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (. bean5798 setAccountId (clojure.core/str v5800))))
   (clojure.core/let
    [v5800
     (:vault-name m5799 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5800 :com.palletops.awaze.client-builder/undef)
     (. bean5798 setVaultName (clojure.core/str v5800))))
   bean5798))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetJobOutputRequest}
get-job-output-request
  [m5802]
  (clojure.core/let
   [bean5801
    (new com.amazonaws.services.glacier.model.GetJobOutputRequest)]
   (clojure.core/let
    [v5803
     (:account-id m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setAccountId (clojure.core/str v5803))))
   (clojure.core/let
    [v5803
     (:vault-name m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setVaultName (clojure.core/str v5803))))
   (clojure.core/let
    [v5803 (:job-id m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setJobId (clojure.core/str v5803))))
   (clojure.core/let
    [v5803 (:range m5802 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5803 :com.palletops.awaze.client-builder/undef)
     (. bean5801 setRange (clojure.core/str v5803))))
   bean5801))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeJobRequest}
describe-job-request
  [m5805]
  (clojure.core/let
   [bean5804
    (new com.amazonaws.services.glacier.model.DescribeJobRequest)]
   (clojure.core/let
    [v5806
     (:account-id m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setAccountId (clojure.core/str v5806))))
   (clojure.core/let
    [v5806
     (:vault-name m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setVaultName (clojure.core/str v5806))))
   (clojure.core/let
    [v5806 (:job-id m5805 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5806 :com.palletops.awaze.client-builder/undef)
     (. bean5804 setJobId (clojure.core/str v5806))))
   bean5804))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultNotificationsRequest}
set-vault-notifications-request
  [m5808]
  (clojure.core/let
   [bean5807
    (new
     com.amazonaws.services.glacier.model.SetVaultNotificationsRequest)]
   (clojure.core/let
    [v5809
     (:account-id m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setAccountId (clojure.core/str v5809))))
   (clojure.core/let
    [v5809
     (:vault-name m5808 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (. bean5807 setVaultName (clojure.core/str v5809))))
   (clojure.core/let
    [v5809
     (:vault-notification-config
      m5808
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5809 :com.palletops.awaze.client-builder/undef)
     (.
      bean5807
      setVaultNotificationConfig
      (glacier/vault-notification-config v5809))))
   bean5807))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DescribeVaultRequest}
describe-vault-request
  [m5811]
  (clojure.core/let
   [bean5810
    (new com.amazonaws.services.glacier.model.DescribeVaultRequest)]
   (clojure.core/let
    [v5812
     (:account-id m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setAccountId (clojure.core/str v5812))))
   (clojure.core/let
    [v5812
     (:vault-name m5811 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5812 :com.palletops.awaze.client-builder/undef)
     (. bean5810 setVaultName (clojure.core/str v5812))))
   bean5810))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AbortVaultLockRequest}
abort-vault-lock-request
  [m5814]
  (clojure.core/let
   [bean5813
    (new com.amazonaws.services.glacier.model.AbortVaultLockRequest)]
   (clojure.core/let
    [v5815
     (:account-id m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setAccountId (clojure.core/str v5815))))
   (clojure.core/let
    [v5815
     (:vault-name m5814 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5815 :com.palletops.awaze.client-builder/undef)
     (. bean5813 setVaultName (clojure.core/str v5815))))
   bean5813))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.AddTagsToVaultRequest}
add-tags-to-vault-request
  [m5817]
  (clojure.core/let
   [bean5816
    (new com.amazonaws.services.glacier.model.AddTagsToVaultRequest)]
   (clojure.core/let
    [v5818
     (:account-id m5817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5818 :com.palletops.awaze.client-builder/undef)
     (. bean5816 setAccountId (clojure.core/str v5818))))
   (clojure.core/let
    [v5818
     (:vault-name m5817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5818 :com.palletops.awaze.client-builder/undef)
     (. bean5816 setVaultName (clojure.core/str v5818))))
   (clojure.core/let
    [v5818 (:tags m5817 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5818 :com.palletops.awaze.client-builder/undef)
     (.
      bean5816
      setTags
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg5861] (clojure.core/str arg5861))
  (clojure.core/keys v5818))
 (clojure.core/map
  (clojure.core/fn [arg5861] (clojure.core/str arg5861))
  (clojure.core/vals v5818))))))
   bean5816))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest}
set-vault-access-policy-request
  [m5820]
  (clojure.core/let
   [bean5819
    (new
     com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5821 (:policy m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setPolicy (glacier/vault-access-policy v5821))))
   (clojure.core/let
    [v5821
     (:account-id m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setAccountId (clojure.core/str v5821))))
   (clojure.core/let
    [v5821
     (:vault-name m5820 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5821 :com.palletops.awaze.client-builder/undef)
     (. bean5819 setVaultName (clojure.core/str v5821))))
   bean5819))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest}
complete-multipart-upload-request
  [m5823]
  (clojure.core/let
   [bean5822
    (new
     com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest)]
   (clojure.core/let
    [v5824
     (:account-id m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setAccountId (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:vault-name m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setVaultName (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:upload-id m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setUploadId (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:checksum m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setChecksum (clojure.core/str v5824))))
   (clojure.core/let
    [v5824
     (:archive-size m5823 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5824 :com.palletops.awaze.client-builder/undef)
     (. bean5822 setArchiveSize (clojure.core/str v5824))))
   bean5822))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest}
get-data-retrieval-policy-request
  [m5826]
  (clojure.core/let
   [bean5825
    (new
     com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5827
     (:account-id m5826 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5827 :com.palletops.awaze.client-builder/undef)
     (. bean5825 setAccountId (clojure.core/str v5827))))
   bean5825))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateVaultLockRequest}
initiate-vault-lock-request
  [m5829]
  (clojure.core/let
   [bean5828
    (new
     com.amazonaws.services.glacier.model.InitiateVaultLockRequest)]
   (clojure.core/let
    [v5830 (:policy m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setPolicy (glacier/vault-lock-policy v5830))))
   (clojure.core/let
    [v5830
     (:account-id m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setAccountId (clojure.core/str v5830))))
   (clojure.core/let
    [v5830
     (:vault-name m5829 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5830 :com.palletops.awaze.client-builder/undef)
     (. bean5828 setVaultName (clojure.core/str v5830))))
   bean5828))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.DeleteArchiveRequest}
delete-archive-request
  [m5832]
  (clojure.core/let
   [bean5831
    (new com.amazonaws.services.glacier.model.DeleteArchiveRequest)]
   (clojure.core/let
    [v5833
     (:account-id m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setAccountId (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:vault-name m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setVaultName (clojure.core/str v5833))))
   (clojure.core/let
    [v5833
     (:archive-id m5832 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5833 :com.palletops.awaze.client-builder/undef)
     (. bean5831 setArchiveId (clojure.core/str v5833))))
   bean5831))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest}
set-data-retrieval-policy-request
  [m5835]
  (clojure.core/let
   [bean5834
    (new
     com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest)]
   (clojure.core/let
    [v5836 (:policy m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setPolicy (glacier/data-retrieval-policy v5836))))
   (clojure.core/let
    [v5836
     (:account-id m5835 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5836 :com.palletops.awaze.client-builder/undef)
     (. bean5834 setAccountId (clojure.core/str v5836))))
   bean5834))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultLockRequest}
get-vault-lock-request
  [m5838]
  (clojure.core/let
   [bean5837
    (new com.amazonaws.services.glacier.model.GetVaultLockRequest)]
   (clojure.core/let
    [v5839
     (:account-id m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setAccountId (clojure.core/str v5839))))
   (clojure.core/let
    [v5839
     (:vault-name m5838 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5839 :com.palletops.awaze.client-builder/undef)
     (. bean5837 setVaultName (clojure.core/str v5839))))
   bean5837))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListJobsRequest}
list-jobs-request
  [m5841]
  (clojure.core/let
   [bean5840
    (new com.amazonaws.services.glacier.model.ListJobsRequest)]
   (clojure.core/let
    [v5842 (:limit m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setLimit (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:account-id m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setAccountId (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:vault-name m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setVaultName (clojure.core/str v5842))))
   (clojure.core/let
    [v5842 (:marker m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setMarker (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:statuscode m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setStatuscode (clojure.core/str v5842))))
   (clojure.core/let
    [v5842
     (:completed m5841 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5842 :com.palletops.awaze.client-builder/undef)
     (. bean5840 setCompleted (clojure.core/str v5842))))
   bean5840))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest}
initiate-multipart-upload-request
  [m5844]
  (clojure.core/let
   [bean5843
    (new
     com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest)]
   (clojure.core/let
    [v5845
     (:account-id m5844 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setAccountId (clojure.core/str v5845))))
   (clojure.core/let
    [v5845
     (:vault-name m5844 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setVaultName (clojure.core/str v5845))))
   (clojure.core/let
    [v5845
     (:archive-description
      m5844
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setArchiveDescription (clojure.core/str v5845))))
   (clojure.core/let
    [v5845
     (:part-size m5844 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5845 :com.palletops.awaze.client-builder/undef)
     (. bean5843 setPartSize (clojure.core/str v5845))))
   bean5843))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.ListTagsForVaultRequest}
list-tags-for-vault-request
  [m5847]
  (clojure.core/let
   [bean5846
    (new com.amazonaws.services.glacier.model.ListTagsForVaultRequest)]
   (clojure.core/let
    [v5848
     (:account-id m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setAccountId (clojure.core/str v5848))))
   (clojure.core/let
    [v5848
     (:vault-name m5847 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5848 :com.palletops.awaze.client-builder/undef)
     (. bean5846 setVaultName (clojure.core/str v5848))))
   bean5846))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.CreateVaultRequest}
create-vault-request
  [m5850]
  (clojure.core/let
   [bean5849
    (new com.amazonaws.services.glacier.model.CreateVaultRequest)]
   (clojure.core/let
    [v5851
     (:account-id m5850 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5851 :com.palletops.awaze.client-builder/undef)
     (. bean5849 setAccountId (clojure.core/str v5851))))
   (clojure.core/let
    [v5851
     (:vault-name m5850 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5851 :com.palletops.awaze.client-builder/undef)
     (. bean5849 setVaultName (clojure.core/str v5851))))
   bean5849))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest}
get-vault-access-policy-request
  [m5853]
  (clojure.core/let
   [bean5852
    (new
     com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest)]
   (clojure.core/let
    [v5854
     (:account-id m5853 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5854 :com.palletops.awaze.client-builder/undef)
     (. bean5852 setAccountId (clojure.core/str v5854))))
   (clojure.core/let
    [v5854
     (:vault-name m5853 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5854 :com.palletops.awaze.client-builder/undef)
     (. bean5852 setVaultName (clojure.core/str v5854))))
   bean5852))
 (clojure.core/defn
^{:tag com.amazonaws.services.glacier.model.UploadArchiveRequest}
upload-archive-request
  [m5856]
  (clojure.core/let
   [bean5855
    (new com.amazonaws.services.glacier.model.UploadArchiveRequest)]
   (clojure.core/let
    [v5857
     (:content-length m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setContentLength (clojure.core/long v5857))))
   (clojure.core/let
    [v5857
     (:account-id m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setAccountId (clojure.core/str v5857))))
   (clojure.core/let
    [v5857
     (:vault-name m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setVaultName (clojure.core/str v5857))))
   (clojure.core/let
    [v5857
     (:archive-description
      m5856
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setArchiveDescription (clojure.core/str v5857))))
   (clojure.core/let
    [v5857
     (:checksum m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setChecksum (clojure.core/str v5857))))
   (clojure.core/let
    [v5857 (:body m5856 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5857 :com.palletops.awaze.client-builder/undef)
     (. bean5855 setBody (clojure.java.io/input-stream v5857))))
   bean5855))
 (clojure.core/defmulti
  glacier
  (clojure.core/fn glacier [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   glacier
   :list-multipart-uploads
   [m5862]
   (clojure.core/let
    [credentials5863 (:credentials m5862) args5864 (:args m5862)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5865
      (com.palletops.awaze.common/aws-client :glacier credentials5863)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5865
       listMultipartUploads
       (glacier/list-multipart-uploads-request
        (clojure.core/nth args5864 0)))))))
  (clojure.core/defn
   list-multipart-uploads-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listMultipartUploads"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-multipart-uploads,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-multipart-uploads
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         upload-id-marker
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listMultipartUploads"}
   [credentials5867 & args5868]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5869
     (com.palletops.awaze.common/aws-client :glacier credentials5867)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5869
      listMultipartUploads
      (glacier/list-multipart-uploads-request
       (clojure.core/nth args5868 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault
   [m5870]
   (clojure.core/let
    [credentials5871 (:credentials m5870) args5872 (:args m5870)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5873
      (com.palletops.awaze.common/aws-client :glacier credentials5871)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5873
       deleteVault
       (glacier/delete-vault-request (clojure.core/nth args5872 0)))))))
  (clojure.core/defn
   delete-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVault"}
   [credentials5875 & args5876]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5877
     (com.palletops.awaze.common/aws-client :glacier credentials5875)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5877
      deleteVault
      (glacier/delete-vault-request (clojure.core/nth args5876 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-vault-lock
   [m5878]
   (clojure.core/let
    [credentials5879 (:credentials m5878) args5880 (:args m5878)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5881
      (com.palletops.awaze.common/aws-client :glacier credentials5879)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5881
       completeVaultLock
       (glacier/complete-vault-lock-request
        (clojure.core/nth args5880 0)))))))
  (clojure.core/defn
   complete-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for completeVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         lock-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call completeVaultLock"}
   [credentials5883 & args5884]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5885
     (com.palletops.awaze.common/aws-client :glacier credentials5883)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5885
      completeVaultLock
      (glacier/complete-vault-lock-request
       (clojure.core/nth args5884 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-notifications
   [m5886]
   (clojure.core/let
    [credentials5887 (:credentials m5886) args5888 (:args m5886)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5889
      (com.palletops.awaze.common/aws-client :glacier credentials5887)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5889
       deleteVaultNotifications
       (glacier/delete-vault-notifications-request
        (clojure.core/nth args5888 0)))))))
  (clojure.core/defn
   delete-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultNotifications"}
   [credentials5891 & args5892]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5893
     (com.palletops.awaze.common/aws-client :glacier credentials5891)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5893
      deleteVaultNotifications
      (glacier/delete-vault-notifications-request
       (clojure.core/nth args5892 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-vault-access-policy
   [m5894]
   (clojure.core/let
    [credentials5895 (:credentials m5894) args5896 (:args m5894)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5897
      (com.palletops.awaze.common/aws-client :glacier credentials5895)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5897
       deleteVaultAccessPolicy
       (glacier/delete-vault-access-policy-request
        (clojure.core/nth args5896 0)))))))
  (clojure.core/defn
   delete-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVaultAccessPolicy"}
   [credentials5899 & args5900]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5901
     (com.palletops.awaze.common/aws-client :glacier credentials5899)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5901
      deleteVaultAccessPolicy
      (glacier/delete-vault-access-policy-request
       (clojure.core/nth args5900 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :remove-tags-from-vault
   [m5902]
   (clojure.core/let
    [credentials5903 (:credentials m5902) args5904 (:args m5902)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5905
      (com.palletops.awaze.common/aws-client :glacier credentials5903)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5905
       removeTagsFromVault
       (glacier/remove-tags-from-vault-request
        (clojure.core/nth args5904 0)))))))
  (clojure.core/defn
   remove-tags-from-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removeTagsFromVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-tags-from-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   remove-tags-from-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         tag-keys
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removeTagsFromVault"}
   [credentials5907 & args5908]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5909
     (com.palletops.awaze.common/aws-client :glacier credentials5907)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5909
      removeTagsFromVault
      (glacier/remove-tags-from-vault-request
       (clojure.core/nth args5908 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-multipart-upload
   [m5910]
   (clojure.core/let
    [credentials5911 (:credentials m5910) args5912 (:args m5910)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5913
      (com.palletops.awaze.common/aws-client :glacier credentials5911)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5913
       abortMultipartUpload
       (glacier/abort-multipart-upload-request
        (clojure.core/nth args5912 0)))))))
  (clojure.core/defn
   abort-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortMultipartUpload"}
   [credentials5915 & args5916]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5917
     (com.palletops.awaze.common/aws-client :glacier credentials5915)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5917
      abortMultipartUpload
      (glacier/abort-multipart-upload-request
       (clojure.core/nth args5916 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-multipart-part
   [m5918]
   (clojure.core/let
    [credentials5919 (:credentials m5918) args5920 (:args m5918)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5921
      (com.palletops.awaze.common/aws-client :glacier credentials5919)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5921
       uploadMultipartPart
       (glacier/upload-multipart-part-request
        (clojure.core/nth args5920 0)))))))
  (clojure.core/defn
   upload-multipart-part-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Generate map for uploadMultipartPart"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-multipart-part,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-multipart-part
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root
                         range]}]]),
    :doc "Call uploadMultipartPart"}
   [credentials5923 & args5924]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5925
     (com.palletops.awaze.common/aws-client :glacier credentials5923)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5925
      uploadMultipartPart
      (glacier/upload-multipart-part-request
       (clojure.core/nth args5924 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-vaults
   [m5926]
   (clojure.core/let
    [credentials5927 (:credentials m5926) args5928 (:args m5926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5929
      (com.palletops.awaze.common/aws-client :glacier credentials5927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5929
       listVaults
       (glacier/list-vaults-request (clojure.core/nth args5928 0)))))))
  (clojure.core/defn
   list-vaults-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listVaults"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-vaults,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-vaults
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listVaults"}
   [credentials5931 & args5932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5933
     (com.palletops.awaze.common/aws-client :glacier credentials5931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5933
      listVaults
      (glacier/list-vaults-request (clojure.core/nth args5932 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-job
   [m5934]
   (clojure.core/let
    [credentials5935 (:credentials m5934) args5936 (:args m5934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5937
      (com.palletops.awaze.common/aws-client :glacier credentials5935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5937
       initiateJob
       (glacier/initiate-job-request (clojure.core/nth args5936 0)))))))
  (clojure.core/defn
   initiate-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Generate map for initiateJob"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-job,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         job-parameters]}]]),
    :doc "Call initiateJob"}
   [credentials5939 & args5940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5941
     (com.palletops.awaze.common/aws-client :glacier credentials5939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5941
      initiateJob
      (glacier/initiate-job-request (clojure.core/nth args5940 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-parts
   [m5942]
   (clojure.core/let
    [credentials5943 (:credentials m5942) args5944 (:args m5942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5945
      (com.palletops.awaze.common/aws-client :glacier credentials5943)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5945
       listParts
       (glacier/list-parts-request (clojure.core/nth args5944 0)))))))
  (clojure.core/defn
   list-parts-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listParts"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-parts,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-parts
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listParts"}
   [credentials5947 & args5948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5949
     (com.palletops.awaze.common/aws-client :glacier credentials5947)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5949
      listParts
      (glacier/list-parts-request (clojure.core/nth args5948 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-notifications
   [m5950]
   (clojure.core/let
    [credentials5951 (:credentials m5950) args5952 (:args m5950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5953
      (com.palletops.awaze.common/aws-client :glacier credentials5951)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5953
       getVaultNotifications
       (glacier/get-vault-notifications-request
        (clojure.core/nth args5952 0)))))))
  (clojure.core/defn
   get-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultNotifications"}
   [credentials5955 & args5956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5957
     (com.palletops.awaze.common/aws-client :glacier credentials5955)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5957
      getVaultNotifications
      (glacier/get-vault-notifications-request
       (clojure.core/nth args5956 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-job-output
   [m5958]
   (clojure.core/let
    [credentials5959 (:credentials m5958) args5960 (:args m5958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5961
      (com.palletops.awaze.common/aws-client :glacier credentials5959)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5961
       getJobOutput
       (glacier/get-job-output-request (clojure.core/nth args5960 0)))))))
  (clojure.core/defn
   get-job-output-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Generate map for getJobOutput"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-job-output,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-job-output
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         range]}]]),
    :doc "Call getJobOutput"}
   [credentials5963 & args5964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5965
     (com.palletops.awaze.common/aws-client :glacier credentials5963)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5965
      getJobOutput
      (glacier/get-job-output-request (clojure.core/nth args5964 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-job
   [m5966]
   (clojure.core/let
    [credentials5967 (:credentials m5966) args5968 (:args m5966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5969
      (com.palletops.awaze.common/aws-client :glacier credentials5967)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5969
       describeJob
       (glacier/describe-job-request (clojure.core/nth args5968 0)))))))
  (clojure.core/defn
   describe-job-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeJob"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-job,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-job
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         job-id
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeJob"}
   [credentials5971 & args5972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5973
     (com.palletops.awaze.common/aws-client :glacier credentials5971)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5973
      describeJob
      (glacier/describe-job-request (clojure.core/nth args5972 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-notifications
   [m5974]
   (clojure.core/let
    [credentials5975 (:credentials m5974) args5976 (:args m5974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5977
      (com.palletops.awaze.common/aws-client :glacier credentials5975)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5977
       setVaultNotifications
       (glacier/set-vault-notifications-request
        (clojure.core/nth args5976 0)))))))
  (clojure.core/defn
   set-vault-notifications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultNotifications"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-vault-notifications,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-notifications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         vault-notification-config
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultNotifications"}
   [credentials5979 & args5980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5981
     (com.palletops.awaze.common/aws-client :glacier credentials5979)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5981
      setVaultNotifications
      (glacier/set-vault-notifications-request
       (clojure.core/nth args5980 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :describe-vault
   [m5982]
   (clojure.core/let
    [credentials5983 (:credentials m5982) args5984 (:args m5982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5985
      (com.palletops.awaze.common/aws-client :glacier credentials5983)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5985
       describeVault
       (glacier/describe-vault-request (clojure.core/nth args5984 0)))))))
  (clojure.core/defn
   describe-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   describe-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeVault"}
   [credentials5987 & args5988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5989
     (com.palletops.awaze.common/aws-client :glacier credentials5987)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5989
      describeVault
      (glacier/describe-vault-request (clojure.core/nth args5988 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :abort-vault-lock
   [m5990]
   (clojure.core/let
    [credentials5991 (:credentials m5990) args5992 (:args m5990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client5993
      (com.palletops.awaze.common/aws-client :glacier credentials5991)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5993
       abortVaultLock
       (glacier/abort-vault-lock-request
        (clojure.core/nth args5992 0)))))))
  (clojure.core/defn
   abort-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for abortVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :abort-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   abort-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call abortVaultLock"}
   [credentials5995 & args5996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client5997
     (com.palletops.awaze.common/aws-client :glacier credentials5995)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client5997
      abortVaultLock
      (glacier/abort-vault-lock-request (clojure.core/nth args5996 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :add-tags-to-vault
   [m5998]
   (clojure.core/let
    [credentials5999 (:credentials m5998) args6000 (:args m5998)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6001
      (com.palletops.awaze.common/aws-client :glacier credentials5999)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6001
       addTagsToVault
       (glacier/add-tags-to-vault-request
        (clojure.core/nth args6000 0)))))))
  (clojure.core/defn
   add-tags-to-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for addTagsToVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-tags-to-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   add-tags-to-vault
   {:arglists (quote
               [[credentials
                 {:keys [tags
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call addTagsToVault"}
   [credentials6003 & args6004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6005
     (com.palletops.awaze.common/aws-client :glacier credentials6003)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6005
      addTagsToVault
      (glacier/add-tags-to-vault-request
       (clojure.core/nth args6004 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-vault-access-policy
   [m6006]
   (clojure.core/let
    [credentials6007 (:credentials m6006) args6008 (:args m6006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6009
      (com.palletops.awaze.common/aws-client :glacier credentials6007)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6009
       setVaultAccessPolicy
       (glacier/set-vault-access-policy-request
        (clojure.core/nth args6008 0)))))))
  (clojure.core/defn
   set-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setVaultAccessPolicy"}
   [credentials6011 & args6012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6013
     (com.palletops.awaze.common/aws-client :glacier credentials6011)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6013
      setVaultAccessPolicy
      (glacier/set-vault-access-policy-request
       (clojure.core/nth args6012 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :complete-multipart-upload
   [m6014]
   (clojure.core/let
    [credentials6015 (:credentials m6014) args6016 (:args m6014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6017
      (com.palletops.awaze.common/aws-client :glacier credentials6015)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6017
       completeMultipartUpload
       (glacier/complete-multipart-upload-request
        (clojure.core/nth args6016 0)))))))
  (clojure.core/defn
   complete-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Generate map for completeMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :complete-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   complete-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         upload-id
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         checksum
                         general-progress-listener
                         clone-source
                         clone-root
                         archive-size]}]]),
    :doc "Call completeMultipartUpload"}
   [credentials6019 & args6020]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6021
     (com.palletops.awaze.common/aws-client :glacier credentials6019)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6021
      completeMultipartUpload
      (glacier/complete-multipart-upload-request
       (clojure.core/nth args6020 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-data-retrieval-policy
   [m6022]
   (clojure.core/let
    [credentials6023 (:credentials m6022) args6024 (:args m6022)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6025
      (com.palletops.awaze.common/aws-client :glacier credentials6023)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6025
       getDataRetrievalPolicy
       (glacier/get-data-retrieval-policy-request
        (clojure.core/nth args6024 0)))))))
  (clojure.core/defn
   get-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getDataRetrievalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-data-retrieval-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getDataRetrievalPolicy"}
   [credentials6027 & args6028]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6029
     (com.palletops.awaze.common/aws-client :glacier credentials6027)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6029
      getDataRetrievalPolicy
      (glacier/get-data-retrieval-policy-request
       (clojure.core/nth args6028 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-vault-lock
   [m6030]
   (clojure.core/let
    [credentials6031 (:credentials m6030) args6032 (:args m6030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6033
      (com.palletops.awaze.common/aws-client :glacier credentials6031)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6033
       initiateVaultLock
       (glacier/initiate-vault-lock-request
        (clojure.core/nth args6032 0)))))))
  (clojure.core/defn
   initiate-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for initiateVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call initiateVaultLock"}
   [credentials6035 & args6036]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6037
     (com.palletops.awaze.common/aws-client :glacier credentials6035)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6037
      initiateVaultLock
      (glacier/initiate-vault-lock-request
       (clojure.core/nth args6036 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :delete-archive
   [m6038]
   (clojure.core/let
    [credentials6039 (:credentials m6038) args6040 (:args m6038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6041
      (com.palletops.awaze.common/aws-client :glacier credentials6039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6041
       deleteArchive
       (glacier/delete-archive-request (clojure.core/nth args6040 0)))))))
  (clojure.core/defn
   delete-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-archive,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   delete-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         archive-id
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteArchive"}
   [credentials6043 & args6044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6045
     (com.palletops.awaze.common/aws-client :glacier credentials6043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6045
      deleteArchive
      (glacier/delete-archive-request (clojure.core/nth args6044 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :set-data-retrieval-policy
   [m6046]
   (clojure.core/let
    [credentials6047 (:credentials m6046) args6048 (:args m6046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6049
      (com.palletops.awaze.common/aws-client :glacier credentials6047)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6049
       setDataRetrievalPolicy
       (glacier/set-data-retrieval-policy-request
        (clojure.core/nth args6048 0)))))))
  (clojure.core/defn
   set-data-retrieval-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setDataRetrievalPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-data-retrieval-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   set-data-retrieval-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setDataRetrievalPolicy"}
   [credentials6051 & args6052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6053
     (com.palletops.awaze.common/aws-client :glacier credentials6051)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6053
      setDataRetrievalPolicy
      (glacier/set-data-retrieval-policy-request
       (clojure.core/nth args6052 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-lock
   [m6054]
   (clojure.core/let
    [credentials6055 (:credentials m6054) args6056 (:args m6054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6057
      (com.palletops.awaze.common/aws-client :glacier credentials6055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6057
       getVaultLock
       (glacier/get-vault-lock-request (clojure.core/nth args6056 0)))))))
  (clojure.core/defn
   get-vault-lock-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultLock"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-lock,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-lock
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultLock"}
   [credentials6059 & args6060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6061
     (com.palletops.awaze.common/aws-client :glacier credentials6059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6061
      getVaultLock
      (glacier/get-vault-lock-request (clojure.core/nth args6060 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-jobs
   [m6062]
   (clojure.core/let
    [credentials6063 (:credentials m6062) args6064 (:args m6062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6065
      (com.palletops.awaze.common/aws-client :glacier credentials6063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6065
       listJobs
       (glacier/list-jobs-request (clojure.core/nth args6064 0)))))))
  (clojure.core/defn
   list-jobs-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listJobs"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-jobs,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-jobs
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         limit
                         sdk-request-timeout
                         marker
                         completed
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         statuscode
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listJobs"}
   [credentials6067 & args6068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6069
     (com.palletops.awaze.common/aws-client :glacier credentials6067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6069
      listJobs
      (glacier/list-jobs-request (clojure.core/nth args6068 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :initiate-multipart-upload
   [m6070]
   (clojure.core/let
    [credentials6071 (:credentials m6070) args6072 (:args m6070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6073
      (com.palletops.awaze.common/aws-client :glacier credentials6071)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6073
       initiateMultipartUpload
       (glacier/initiate-multipart-upload-request
        (clojure.core/nth args6072 0)))))))
  (clojure.core/defn
   initiate-multipart-upload-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Generate map for initiateMultipartUpload"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :initiate-multipart-upload,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   initiate-multipart-upload
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         part-size
                         clone-root]}]]),
    :doc "Call initiateMultipartUpload"}
   [credentials6075 & args6076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6077
     (com.palletops.awaze.common/aws-client :glacier credentials6075)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6077
      initiateMultipartUpload
      (glacier/initiate-multipart-upload-request
       (clojure.core/nth args6076 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :list-tags-for-vault
   [m6078]
   (clojure.core/let
    [credentials6079 (:credentials m6078) args6080 (:args m6078)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6081
      (com.palletops.awaze.common/aws-client :glacier credentials6079)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6081
       listTagsForVault
       (glacier/list-tags-for-vault-request
        (clojure.core/nth args6080 0)))))))
  (clojure.core/defn
   list-tags-for-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listTagsForVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-tags-for-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   list-tags-for-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listTagsForVault"}
   [credentials6083 & args6084]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6085
     (com.palletops.awaze.common/aws-client :glacier credentials6083)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6085
      listTagsForVault
      (glacier/list-tags-for-vault-request
       (clojure.core/nth args6084 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :create-vault
   [m6086]
   (clojure.core/let
    [credentials6087 (:credentials m6086) args6088 (:args m6086)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6089
      (com.palletops.awaze.common/aws-client :glacier credentials6087)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6089
       createVault
       (glacier/create-vault-request (clojure.core/nth args6088 0)))))))
  (clojure.core/defn
   create-vault-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createVault"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-vault,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   create-vault
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createVault"}
   [credentials6091 & args6092]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6093
     (com.palletops.awaze.common/aws-client :glacier credentials6091)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6093
      createVault
      (glacier/create-vault-request (clojure.core/nth args6092 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :get-vault-access-policy
   [m6094]
   (clojure.core/let
    [credentials6095 (:credentials m6094) args6096 (:args m6094)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6097
      (com.palletops.awaze.common/aws-client :glacier credentials6095)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6097
       getVaultAccessPolicy
       (glacier/get-vault-access-policy-request
        (clojure.core/nth args6096 0)))))))
  (clojure.core/defn
   get-vault-access-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getVaultAccessPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-vault-access-policy,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   get-vault-access-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getVaultAccessPolicy"}
   [credentials6099 & args6100]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6101
     (com.palletops.awaze.common/aws-client :glacier credentials6099)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6101
      getVaultAccessPolicy
      (glacier/get-vault-access-policy-request
       (clojure.core/nth args6100 0)))))))
 (do
  (clojure.core/defmethod
   glacier
   :upload-archive
   [m6102]
   (clojure.core/let
    [credentials6103 (:credentials m6102) args6104 (:args m6102)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
      client6105
      (com.palletops.awaze.common/aws-client :glacier credentials6103)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6105
       uploadArchive
       (glacier/upload-archive-request (clojure.core/nth args6104 0)))))))
  (clojure.core/defn
   upload-archive-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Generate map for uploadArchive"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :upload-archive,
     :credentials credentials__1842__auto__,
     :client :glacier}))
  (clojure.core/defn
   upload-archive
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         archive-description
                         sdk-request-timeout
                         vault-name
                         custom-query-parameters
                         account-id
                         read-limit
                         content-length
                         checksum
                         general-progress-listener
                         clone-source
                         body
                         clone-root]}]]),
    :doc "Call uploadArchive"}
   [credentials6107 & args6108]
   (clojure.core/let
    [^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
     client6109
     (com.palletops.awaze.common/aws-client :glacier credentials6107)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.glacier.AmazonGlacierClient}
client6109
      uploadArchive
      (glacier/upload-archive-request (clojure.core/nth args6108 0))))))))
