(ns
 com.palletops.awaze.simpledb
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpledb :as simpledb]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpledb
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpledb.AmazonSimpleDBClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableAttribute}
replaceable-attribute
  [m8722]
  (clojure.core/let
   [bean8721
    (new com.amazonaws.services.simpledb.model.ReplaceableAttribute)]
   (clojure.core/let
    [v8723 (:replace m8722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8723 :com.palletops.awaze.client-builder/undef)
     (. bean8721 setReplace (clojure.core/boolean v8723))))
   (clojure.core/let
    [v8723 (:name m8722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8723 :com.palletops.awaze.client-builder/undef)
     (. bean8721 setName (clojure.core/str v8723))))
   (clojure.core/let
    [v8723 (:value m8722 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8723 :com.palletops.awaze.client-builder/undef)
     (. bean8721 setValue (clojure.core/str v8723))))
   bean8721))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.Attribute}
attribute
  [m8725]
  (clojure.core/let
   [bean8724 (new com.amazonaws.services.simpledb.model.Attribute)]
   (clojure.core/let
    [v8726
     (:alternate-name-encoding
      m8725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setAlternateNameEncoding (clojure.core/str v8726))))
   (clojure.core/let
    [v8726
     (:alternate-value-encoding
      m8725
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setAlternateValueEncoding (clojure.core/str v8726))))
   (clojure.core/let
    [v8726 (:name m8725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setName (clojure.core/str v8726))))
   (clojure.core/let
    [v8726 (:value m8725 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8726 :com.palletops.awaze.client-builder/undef)
     (. bean8724 setValue (clojure.core/str v8726))))
   bean8724))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ReplaceableItem}
replaceable-item
  [m8728]
  (clojure.core/let
   [bean8727
    (new com.amazonaws.services.simpledb.model.ReplaceableItem)]
   (clojure.core/let
    [v8729
     (:attributes m8728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (.
      bean8727
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8766] (simpledb/replaceable-attribute arg8766))
 v8729))))
   (clojure.core/let
    [v8729 (:name m8728 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8729 :com.palletops.awaze.client-builder/undef)
     (. bean8727 setName (clojure.core/str v8729))))
   bean8727))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeletableItem}
deletable-item
  [m8731]
  (clojure.core/let
   [bean8730
    (new com.amazonaws.services.simpledb.model.DeletableItem)]
   (clojure.core/let
    [v8732
     (:attributes m8731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (.
      bean8730
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8767] (simpledb/attribute arg8767))
 v8732))))
   (clojure.core/let
    [v8732 (:name m8731 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8732 :com.palletops.awaze.client-builder/undef)
     (. bean8730 setName (clojure.core/str v8732))))
   bean8730))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.UpdateCondition}
update-condition
  [m8734]
  (clojure.core/let
   [bean8733
    (new com.amazonaws.services.simpledb.model.UpdateCondition)]
   (clojure.core/let
    [v8735 (:exists m8734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8735 :com.palletops.awaze.client-builder/undef)
     (. bean8733 setExists (clojure.core/boolean v8735))))
   (clojure.core/let
    [v8735 (:name m8734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8735 :com.palletops.awaze.client-builder/undef)
     (. bean8733 setName (clojure.core/str v8735))))
   (clojure.core/let
    [v8735 (:value m8734 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8735 :com.palletops.awaze.client-builder/undef)
     (. bean8733 setValue (clojure.core/str v8735))))
   bean8733))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.ListDomainsRequest}
list-domains-request
  [m8737]
  (clojure.core/let
   [bean8736
    (new com.amazonaws.services.simpledb.model.ListDomainsRequest)]
   (clojure.core/let
    [v8738
     (:next-token m8737 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (. bean8736 setNextToken (clojure.core/str v8738))))
   (clojure.core/let
    [v8738
     (:max-number-of-domains
      m8737
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8738 :com.palletops.awaze.client-builder/undef)
     (. bean8736 setMaxNumberOfDomains (clojure.core/int v8738))))
   bean8736))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteDomainRequest}
delete-domain-request
  [m8740]
  (clojure.core/let
   [bean8739
    (new com.amazonaws.services.simpledb.model.DeleteDomainRequest)]
   (clojure.core/let
    [v8741
     (:domain-name m8740 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8741 :com.palletops.awaze.client-builder/undef)
     (. bean8739 setDomainName (clojure.core/str v8741))))
   bean8739))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DomainMetadataRequest}
domain-metadata-request
  [m8743]
  (clojure.core/let
   [bean8742
    (new com.amazonaws.services.simpledb.model.DomainMetadataRequest)]
   (clojure.core/let
    [v8744
     (:domain-name m8743 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8744 :com.palletops.awaze.client-builder/undef)
     (. bean8742 setDomainName (clojure.core/str v8744))))
   bean8742))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchPutAttributesRequest}
batch-put-attributes-request
  [m8746]
  (clojure.core/let
   [bean8745
    (new
     com.amazonaws.services.simpledb.model.BatchPutAttributesRequest)]
   (clojure.core/let
    [v8747
     (:domain-name m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (. bean8745 setDomainName (clojure.core/str v8747))))
   (clojure.core/let
    [v8747 (:items m8746 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8747 :com.palletops.awaze.client-builder/undef)
     (.
      bean8745
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8768] (simpledb/replaceable-item arg8768))
 v8747))))
   bean8745))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest}
batch-delete-attributes-request
  [m8749]
  (clojure.core/let
   [bean8748
    (new
     com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest)]
   (clojure.core/let
    [v8750
     (:domain-name m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (. bean8748 setDomainName (clojure.core/str v8750))))
   (clojure.core/let
    [v8750 (:items m8749 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8750 :com.palletops.awaze.client-builder/undef)
     (.
      bean8748
      setItems
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8769] (simpledb/deletable-item arg8769))
 v8750))))
   bean8748))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.GetAttributesRequest}
get-attributes-request
  [m8752]
  (clojure.core/let
   [bean8751
    (new com.amazonaws.services.simpledb.model.GetAttributesRequest)]
   (clojure.core/let
    [v8753
     (:domain-name m8752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (. bean8751 setDomainName (clojure.core/str v8753))))
   (clojure.core/let
    [v8753
     (:attribute-names
      m8752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (.
      bean8751
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8770] (clojure.core/str arg8770))
 v8753))))
   (clojure.core/let
    [v8753
     (:item-name m8752 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (. bean8751 setItemName (clojure.core/str v8753))))
   (clojure.core/let
    [v8753
     (:consistent-read
      m8752
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8753 :com.palletops.awaze.client-builder/undef)
     (. bean8751 setConsistentRead (clojure.core/boolean v8753))))
   bean8751))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.PutAttributesRequest}
put-attributes-request
  [m8755]
  (clojure.core/let
   [bean8754
    (new com.amazonaws.services.simpledb.model.PutAttributesRequest)]
   (clojure.core/let
    [v8756
     (:domain-name m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setDomainName (clojure.core/str v8756))))
   (clojure.core/let
    [v8756
     (:attributes m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (.
      bean8754
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8771] (simpledb/replaceable-attribute arg8771))
 v8756))))
   (clojure.core/let
    [v8756
     (:item-name m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setItemName (clojure.core/str v8756))))
   (clojure.core/let
    [v8756
     (:expected m8755 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8756 :com.palletops.awaze.client-builder/undef)
     (. bean8754 setExpected (simpledb/update-condition v8756))))
   bean8754))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.DeleteAttributesRequest}
delete-attributes-request
  [m8758]
  (clojure.core/let
   [bean8757
    (new
     com.amazonaws.services.simpledb.model.DeleteAttributesRequest)]
   (clojure.core/let
    [v8759
     (:domain-name m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setDomainName (clojure.core/str v8759))))
   (clojure.core/let
    [v8759
     (:attributes m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (.
      bean8757
      setAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8772] (simpledb/attribute arg8772))
 v8759))))
   (clojure.core/let
    [v8759
     (:item-name m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setItemName (clojure.core/str v8759))))
   (clojure.core/let
    [v8759
     (:expected m8758 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8759 :com.palletops.awaze.client-builder/undef)
     (. bean8757 setExpected (simpledb/update-condition v8759))))
   bean8757))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.CreateDomainRequest}
create-domain-request
  [m8761]
  (clojure.core/let
   [bean8760
    (new com.amazonaws.services.simpledb.model.CreateDomainRequest)]
   (clojure.core/let
    [v8762
     (:domain-name m8761 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8762 :com.palletops.awaze.client-builder/undef)
     (. bean8760 setDomainName (clojure.core/str v8762))))
   bean8760))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpledb.model.SelectRequest}
select-request
  [m8764]
  (clojure.core/let
   [bean8763
    (new com.amazonaws.services.simpledb.model.SelectRequest)]
   (clojure.core/let
    [v8765
     (:next-token m8764 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setNextToken (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:select-expression
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setSelectExpression (clojure.core/str v8765))))
   (clojure.core/let
    [v8765
     (:consistent-read
      m8764
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8765 :com.palletops.awaze.client-builder/undef)
     (. bean8763 setConsistentRead (clojure.core/boolean v8765))))
   bean8763))
 (clojure.core/defmulti
  simpledb
  (clojure.core/fn simpledb [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpledb
   :list-domains
   [m8773]
   (clojure.core/let
    [credentials8774 (:credentials m8773) args8775 (:args m8773)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8776
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8774)]
     (clojure.core/case
      (clojure.core/count args8775)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8776
        listDomains
        (simpledb/list-domains-request (clojure.core/nth args8775 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8776
        listDomains))))))
  (clojure.core/defn
   list-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listDomains, listDomains"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-domains,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   list-domains
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         max-number-of-domains
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listDomains, listDomains"}
   [credentials8778 & args8779]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8780
     (com.palletops.awaze.common/aws-client :simpledb credentials8778)]
    (clojure.core/case
     (clojure.core/count args8779)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8780
       listDomains
       (simpledb/list-domains-request (clojure.core/nth args8779 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8780
       listDomains))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-domain
   [m8781]
   (clojure.core/let
    [credentials8782 (:credentials m8781) args8783 (:args m8781)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8784
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8782)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8784
       deleteDomain
       (simpledb/delete-domain-request (clojure.core/nth args8783 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteDomain"}
   [credentials8786 & args8787]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8788
     (com.palletops.awaze.common/aws-client :simpledb credentials8786)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8788
      deleteDomain
      (simpledb/delete-domain-request (clojure.core/nth args8787 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :domain-metadata
   [m8789]
   (clojure.core/let
    [credentials8790 (:credentials m8789) args8791 (:args m8789)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8792
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8790)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8792
       domainMetadata
       (simpledb/domain-metadata-request
        (clojure.core/nth args8791 0)))))))
  (clojure.core/defn
   domain-metadata-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for domainMetadata"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :domain-metadata,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   domain-metadata
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call domainMetadata"}
   [credentials8794 & args8795]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8796
     (com.palletops.awaze.common/aws-client :simpledb credentials8794)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8796
      domainMetadata
      (simpledb/domain-metadata-request (clojure.core/nth args8795 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-put-attributes
   [m8797]
   (clojure.core/let
    [credentials8798 (:credentials m8797) args8799 (:args m8797)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8800
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8798)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8800
       batchPutAttributes
       (simpledb/batch-put-attributes-request
        (clojure.core/nth args8799 0)))))))
  (clojure.core/defn
   batch-put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchPutAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchPutAttributes"}
   [credentials8802 & args8803]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8804
     (com.palletops.awaze.common/aws-client :simpledb credentials8802)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8804
      batchPutAttributes
      (simpledb/batch-put-attributes-request
       (clojure.core/nth args8803 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :batch-delete-attributes
   [m8805]
   (clojure.core/let
    [credentials8806 (:credentials m8805) args8807 (:args m8805)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8808
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8806)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8808
       batchDeleteAttributes
       (simpledb/batch-delete-attributes-request
        (clojure.core/nth args8807 0)))))))
  (clojure.core/defn
   batch-delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Generate map for batchDeleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :batch-delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   batch-delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         items
                         clone-root]}]]),
    :doc "Call batchDeleteAttributes"}
   [credentials8810 & args8811]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8812
     (com.palletops.awaze.common/aws-client :simpledb credentials8810)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8812
      batchDeleteAttributes
      (simpledb/batch-delete-attributes-request
       (clojure.core/nth args8811 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :get-attributes
   [m8813]
   (clojure.core/let
    [credentials8814 (:credentials m8813) args8815 (:args m8813)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8816
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8814)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8816
       getAttributes
       (simpledb/get-attributes-request (clojure.core/nth args8815 0)))))))
  (clojure.core/defn
   get-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   get-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         item-name
                         consistent-read
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getAttributes"}
   [credentials8818 & args8819]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8820
     (com.palletops.awaze.common/aws-client :simpledb credentials8818)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8820
      getAttributes
      (simpledb/get-attributes-request (clojure.core/nth args8819 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :put-attributes
   [m8821]
   (clojure.core/let
    [credentials8822 (:credentials m8821) args8823 (:args m8821)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8824
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8822)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8824
       putAttributes
       (simpledb/put-attributes-request (clojure.core/nth args8823 0)))))))
  (clojure.core/defn
   put-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for putAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   put-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call putAttributes"}
   [credentials8826 & args8827]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8828
     (com.palletops.awaze.common/aws-client :simpledb credentials8826)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8828
      putAttributes
      (simpledb/put-attributes-request (clojure.core/nth args8827 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :delete-attributes
   [m8829]
   (clojure.core/let
    [credentials8830 (:credentials m8829) args8831 (:args m8829)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8832
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8830)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8832
       deleteAttributes
       (simpledb/delete-attributes-request
        (clojure.core/nth args8831 0)))))))
  (clojure.core/defn
   delete-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for deleteAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-attributes,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   delete-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         item-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         expected
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call deleteAttributes"}
   [credentials8834 & args8835]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8836
     (com.palletops.awaze.common/aws-client :simpledb credentials8834)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8836
      deleteAttributes
      (simpledb/delete-attributes-request
       (clojure.core/nth args8835 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :create-domain
   [m8837]
   (clojure.core/let
    [credentials8838 (:credentials m8837) args8839 (:args m8837)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8840
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8838)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8840
       createDomain
       (simpledb/create-domain-request (clojure.core/nth args8839 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-domain,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         domain-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createDomain"}
   [credentials8842 & args8843]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8844
     (com.palletops.awaze.common/aws-client :simpledb credentials8842)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8844
      createDomain
      (simpledb/create-domain-request (clojure.core/nth args8843 0)))))))
 (do
  (clojure.core/defmethod
   simpledb
   :select
   [m8845]
   (clojure.core/let
    [credentials8846 (:credentials m8845) args8847 (:args m8845)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
      client8848
      (com.palletops.awaze.common/aws-client
       :simpledb
       credentials8846)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8848
       select
       (simpledb/select-request (clojure.core/nth args8847 0)))))))
  (clojure.core/defn
   select-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for select"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :select,
     :credentials credentials__1842__auto__,
     :client :simpledb}))
  (clojure.core/defn
   select
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         consistent-read
                         sdk-request-timeout
                         select-expression
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call select"}
   [credentials8850 & args8851]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
     client8852
     (com.palletops.awaze.common/aws-client :simpledb credentials8850)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpledb.AmazonSimpleDBClient}
client8852
      select
      (simpledb/select-request (clojure.core/nth args8851 0))))))))
