(ns
 com.palletops.awaze.simpleemail
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.simpleemail :as simpleemail]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :simpleemail
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopScope}
stop-scope
  [m5206]
  (.
   com.amazonaws.services.simpleemail.model.StopScope
   fromValue
   (clojure.core/name m5206)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptFilterPolicy}
receipt-filter-policy
  [m5209]
  (.
   com.amazonaws.services.simpleemail.model.ReceiptFilterPolicy
   fromValue
   (clojure.core/name m5209)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ExtensionField}
extension-field
  [m5212]
  (clojure.core/let
   [bean5211
    (new com.amazonaws.services.simpleemail.model.ExtensionField)]
   (clojure.core/let
    [v5213 (:name m5212 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5213 :com.palletops.awaze.client-builder/undef)
     (. bean5211 setName (clojure.core/str v5213))))
   (clojure.core/let
    [v5213 (:value m5212 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5213 :com.palletops.awaze.client-builder/undef)
     (. bean5211 setValue (clojure.core/str v5213))))
   bean5211))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.StopAction}
stop-action
  [m5215]
  (clojure.core/let
   [bean5214
    (new com.amazonaws.services.simpleemail.model.StopAction)]
   (clojure.core/let
    [v5216
     (:topic-arn m5215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5216 :com.palletops.awaze.client-builder/undef)
     (. bean5214 setTopicArn (clojure.core/str v5216))))
   (clojure.core/let
    [v5216 (:scope m5215 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5216 :com.palletops.awaze.client-builder/undef)
     (. bean5214 setScope (simpleemail/stop-scope v5216))))
   bean5214))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.AddHeaderAction}
add-header-action
  [m5218]
  (clojure.core/let
   [bean5217
    (new com.amazonaws.services.simpleemail.model.AddHeaderAction)]
   (clojure.core/let
    [v5219
     (:header-name m5218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5219 :com.palletops.awaze.client-builder/undef)
     (. bean5217 setHeaderName (clojure.core/str v5219))))
   (clojure.core/let
    [v5219
     (:header-value m5218 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5219 :com.palletops.awaze.client-builder/undef)
     (. bean5217 setHeaderValue (clojure.core/str v5219))))
   bean5217))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SNSAction}
snsaction
  [m5221]
  (clojure.core/let
   [bean5220 (new com.amazonaws.services.simpleemail.model.SNSAction)]
   (clojure.core/let
    [v5222
     (:topic-arn m5221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5222 :com.palletops.awaze.client-builder/undef)
     (. bean5220 setTopicArn (clojure.core/str v5222))))
   (clojure.core/let
    [v5222
     (:encoding m5221 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5222 :com.palletops.awaze.client-builder/undef)
     (. bean5220 setEncoding (clojure.core/str v5222))))
   bean5220))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.S3Action}
s3action
  [m5224]
  (clojure.core/let
   [bean5223 (new com.amazonaws.services.simpleemail.model.S3Action)]
   (clojure.core/let
    [v5225
     (:topic-arn m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setTopicArn (clojure.core/str v5225))))
   (clojure.core/let
    [v5225
     (:kms-key-arn m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setKmsKeyArn (clojure.core/str v5225))))
   (clojure.core/let
    [v5225
     (:object-key-prefix
      m5224
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setObjectKeyPrefix (clojure.core/str v5225))))
   (clojure.core/let
    [v5225
     (:bucket-name m5224 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5225 :com.palletops.awaze.client-builder/undef)
     (. bean5223 setBucketName (clojure.core/str v5225))))
   bean5223))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BounceAction}
bounce-action
  [m5227]
  (clojure.core/let
   [bean5226
    (new com.amazonaws.services.simpleemail.model.BounceAction)]
   (clojure.core/let
    [v5228
     (:status-code m5227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setStatusCode (clojure.core/str v5228))))
   (clojure.core/let
    [v5228
     (:smtp-reply-code
      m5227
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setSmtpReplyCode (clojure.core/str v5228))))
   (clojure.core/let
    [v5228 (:message m5227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setMessage (clojure.core/str v5228))))
   (clojure.core/let
    [v5228
     (:topic-arn m5227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setTopicArn (clojure.core/str v5228))))
   (clojure.core/let
    [v5228 (:sender m5227 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5228 :com.palletops.awaze.client-builder/undef)
     (. bean5226 setSender (clojure.core/str v5228))))
   bean5226))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.WorkmailAction}
workmail-action
  [m5230]
  (clojure.core/let
   [bean5229
    (new com.amazonaws.services.simpleemail.model.WorkmailAction)]
   (clojure.core/let
    [v5231
     (:organization-arn
      m5230
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5231 :com.palletops.awaze.client-builder/undef)
     (. bean5229 setOrganizationArn (clojure.core/str v5231))))
   (clojure.core/let
    [v5231
     (:topic-arn m5230 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5231 :com.palletops.awaze.client-builder/undef)
     (. bean5229 setTopicArn (clojure.core/str v5231))))
   bean5229))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.LambdaAction}
lambda-action
  [m5233]
  (clojure.core/let
   [bean5232
    (new com.amazonaws.services.simpleemail.model.LambdaAction)]
   (clojure.core/let
    [v5234
     (:topic-arn m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setTopicArn (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:function-arn m5233 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setFunctionArn (clojure.core/str v5234))))
   (clojure.core/let
    [v5234
     (:invocation-type
      m5233
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5234 :com.palletops.awaze.client-builder/undef)
     (. bean5232 setInvocationType (clojure.core/str v5234))))
   bean5232))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Content}
content
  [m5236]
  (clojure.core/let
   [bean5235 (new com.amazonaws.services.simpleemail.model.Content)]
   (clojure.core/let
    [v5237 (:data m5236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5237 :com.palletops.awaze.client-builder/undef)
     (. bean5235 setData (clojure.core/str v5237))))
   (clojure.core/let
    [v5237 (:charset m5236 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5237 :com.palletops.awaze.client-builder/undef)
     (. bean5235 setCharset (clojure.core/str v5237))))
   bean5235))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptIpFilter}
receipt-ip-filter
  [m5239]
  (clojure.core/let
   [bean5238
    (new com.amazonaws.services.simpleemail.model.ReceiptIpFilter)]
   (clojure.core/let
    [v5240 (:policy m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setPolicy (simpleemail/receipt-filter-policy v5240))))
   (clojure.core/let
    [v5240 (:cidr m5239 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5240 :com.palletops.awaze.client-builder/undef)
     (. bean5238 setCidr (clojure.core/str v5240))))
   bean5238))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RecipientDsnFields}
recipient-dsn-fields
  [m5242]
  (clojure.core/let
   [bean5241
    (new com.amazonaws.services.simpleemail.model.RecipientDsnFields)]
   (clojure.core/let
    [v5243 (:status m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setStatus (clojure.core/str v5243))))
   (clojure.core/let
    [v5243
     (:extension-fields
      m5242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (.
      bean5241
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5400] (simpleemail/extension-field arg5400))
 v5243))))
   (clojure.core/let
    [v5243 (:action m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setAction (clojure.core/str v5243))))
   (clojure.core/let
    [v5243
     (:final-recipient
      m5242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setFinalRecipient (clojure.core/str v5243))))
   (clojure.core/let
    [v5243
     (:remote-mta m5242 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setRemoteMta (clojure.core/str v5243))))
   (clojure.core/let
    [v5243
     (:diagnostic-code
      m5242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (. bean5241 setDiagnosticCode (clojure.core/str v5243))))
   (clojure.core/let
    [v5243
     (:last-attempt-date
      m5242
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5243 :com.palletops.awaze.client-builder/undef)
     (.
      bean5241
      setLastAttemptDate
      (com.palletops.awaze.common/to-date v5243))))
   bean5241))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptAction}
receipt-action
  [m5245]
  (clojure.core/let
   [bean5244
    (new com.amazonaws.services.simpleemail.model.ReceiptAction)]
   (clojure.core/let
    [v5246
     (:stop-action m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setStopAction (simpleemail/stop-action v5246))))
   (clojure.core/let
    [v5246
     (:add-header-action
      m5245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (.
      bean5244
      setAddHeaderAction
      (simpleemail/add-header-action v5246))))
   (clojure.core/let
    [v5246
     (:snsaction m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setSNSAction (simpleemail/snsaction v5246))))
   (clojure.core/let
    [v5246
     (:s3action m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setS3Action (simpleemail/s3action v5246))))
   (clojure.core/let
    [v5246
     (:bounce-action m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setBounceAction (simpleemail/bounce-action v5246))))
   (clojure.core/let
    [v5246
     (:workmail-action
      m5245
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (.
      bean5244
      setWorkmailAction
      (simpleemail/workmail-action v5246))))
   (clojure.core/let
    [v5246
     (:lambda-action m5245 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5246 :com.palletops.awaze.client-builder/undef)
     (. bean5244 setLambdaAction (simpleemail/lambda-action v5246))))
   bean5244))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Body}
body
  [m5248]
  (clojure.core/let
   [bean5247 (new com.amazonaws.services.simpleemail.model.Body)]
   (clojure.core/let
    [v5249 (:html m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setHtml (simpleemail/content v5249))))
   (clojure.core/let
    [v5249 (:text m5248 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5249 :com.palletops.awaze.client-builder/undef)
     (. bean5247 setText (simpleemail/content v5249))))
   bean5247))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.NotificationType}
notification-type
  [m5251]
  (.
   com.amazonaws.services.simpleemail.model.NotificationType
   fromValue
   (clojure.core/name m5251)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptFilter}
receipt-filter
  [m5254]
  (clojure.core/let
   [bean5253
    (new com.amazonaws.services.simpleemail.model.ReceiptFilter)]
   (clojure.core/let
    [v5255
     (:ip-filter m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setIpFilter (simpleemail/receipt-ip-filter v5255))))
   (clojure.core/let
    [v5255 (:name m5254 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5255 :com.palletops.awaze.client-builder/undef)
     (. bean5253 setName (clojure.core/str v5255))))
   bean5253))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.MessageDsn}
message-dsn
  [m5257]
  (clojure.core/let
   [bean5256
    (new com.amazonaws.services.simpleemail.model.MessageDsn)]
   (clojure.core/let
    [v5258
     (:reporting-mta m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (. bean5256 setReportingMta (clojure.core/str v5258))))
   (clojure.core/let
    [v5258
     (:arrival-date m5257 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setArrivalDate
      (com.palletops.awaze.common/to-date v5258))))
   (clojure.core/let
    [v5258
     (:extension-fields
      m5257
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5258 :com.palletops.awaze.client-builder/undef)
     (.
      bean5256
      setExtensionFields
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5401] (simpleemail/extension-field arg5401))
 v5258))))
   bean5256))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.BouncedRecipientInfo}
bounced-recipient-info
  [m5260]
  (clojure.core/let
   [bean5259
    (new
     com.amazonaws.services.simpleemail.model.BouncedRecipientInfo)]
   (clojure.core/let
    [v5261
     (:recipient m5260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5261 :com.palletops.awaze.client-builder/undef)
     (. bean5259 setRecipient (clojure.core/str v5261))))
   (clojure.core/let
    [v5261
     (:recipient-arn m5260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5261 :com.palletops.awaze.client-builder/undef)
     (. bean5259 setRecipientArn (clojure.core/str v5261))))
   (clojure.core/let
    [v5261
     (:bounce-type m5260 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5261 :com.palletops.awaze.client-builder/undef)
     (. bean5259 setBounceType (clojure.core/str v5261))))
   (clojure.core/let
    [v5261
     (:recipient-dsn-fields
      m5260
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5261 :com.palletops.awaze.client-builder/undef)
     (.
      bean5259
      setRecipientDsnFields
      (simpleemail/recipient-dsn-fields v5261))))
   bean5259))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReceiptRule}
receipt-rule
  [m5263]
  (clojure.core/let
   [bean5262
    (new com.amazonaws.services.simpleemail.model.ReceiptRule)]
   (clojure.core/let
    [v5264 (:enabled m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setEnabled (clojure.core/boolean v5264))))
   (clojure.core/let
    [v5264
     (:tls-policy m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setTlsPolicy (clojure.core/str v5264))))
   (clojure.core/let
    [v5264
     (:recipients m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (.
      bean5262
      setRecipients
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5402] (clojure.core/str arg5402))
 v5264))))
   (clojure.core/let
    [v5264 (:actions m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (.
      bean5262
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5403] (simpleemail/receipt-action arg5403))
 v5264))))
   (clojure.core/let
    [v5264
     (:scan-enabled m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setScanEnabled (clojure.core/boolean v5264))))
   (clojure.core/let
    [v5264 (:name m5263 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5264 :com.palletops.awaze.client-builder/undef)
     (. bean5262 setName (clojure.core/str v5264))))
   bean5262))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Destination}
destination
  [m5266]
  (clojure.core/let
   [bean5265
    (new com.amazonaws.services.simpleemail.model.Destination)]
   (clojure.core/let
    [v5267
     (:to-addresses m5266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5267 :com.palletops.awaze.client-builder/undef)
     (.
      bean5265
      setToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5404] (clojure.core/str arg5404))
 v5267))))
   (clojure.core/let
    [v5267
     (:cc-addresses m5266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5267 :com.palletops.awaze.client-builder/undef)
     (.
      bean5265
      setCcAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5405] (clojure.core/str arg5405))
 v5267))))
   (clojure.core/let
    [v5267
     (:bcc-addresses m5266 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5267 :com.palletops.awaze.client-builder/undef)
     (.
      bean5265
      setBccAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5406] (clojure.core/str arg5406))
 v5267))))
   bean5265))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.Message}
message
  [m5269]
  (clojure.core/let
   [bean5268 (new com.amazonaws.services.simpleemail.model.Message)]
   (clojure.core/let
    [v5270 (:subject m5269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5270 :com.palletops.awaze.client-builder/undef)
     (. bean5268 setSubject (simpleemail/content v5270))))
   (clojure.core/let
    [v5270 (:body m5269 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5270 :com.palletops.awaze.client-builder/undef)
     (. bean5268 setBody (simpleemail/body v5270))))
   bean5268))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.RawMessage}
raw-message
  [m5272]
  (clojure.core/let
   [bean5271
    (new com.amazonaws.services.simpleemail.model.RawMessage)]
   (clojure.core/let
    [v5273 (:data m5272 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5273 :com.palletops.awaze.client-builder/undef)
     (. bean5271 setData (clojure.core/identity v5273))))
   bean5271))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.IdentityType}
identity-type
  [m5275]
  (.
   com.amazonaws.services.simpleemail.model.IdentityType
   fromValue
   (clojure.core/name m5275)))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest}
list-receipt-rule-sets-request
  [m5278]
  (clojure.core/let
   [bean5277
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptRuleSetsRequest)]
   (clojure.core/let
    [v5279
     (:next-token m5278 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5279 :com.palletops.awaze.client-builder/undef)
     (. bean5277 setNextToken (clojure.core/str v5279))))
   bean5277))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest}
verify-email-address-request
  [m5281]
  (clojure.core/let
   [bean5280
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest)]
   (clojure.core/let
    [v5282
     (:email-address m5281 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5282 :com.palletops.awaze.client-builder/undef)
     (. bean5280 setEmailAddress (clojure.core/str v5282))))
   bean5280))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest}
describe-active-receipt-rule-set-request
  [m5284]
  (clojure.core/let
   [bean5283
    (new
     com.amazonaws.services.simpleemail.model.DescribeActiveReceiptRuleSetRequest)]
   bean5283))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest}
list-receipt-filters-request
  [m5287]
  (clojure.core/let
   [bean5286
    (new
     com.amazonaws.services.simpleemail.model.ListReceiptFiltersRequest)]
   bean5286))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityRequest}
delete-identity-request
  [m5290]
  (clojure.core/let
   [bean5289
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityRequest)]
   (clojure.core/let
    [v5291
     (:identity m5290 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5291 :com.palletops.awaze.client-builder/undef)
     (. bean5289 setIdentity (clojure.core/str v5291))))
   bean5289))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest}
verify-email-identity-request
  [m5293]
  (clojure.core/let
   [bean5292
    (new
     com.amazonaws.services.simpleemail.model.VerifyEmailIdentityRequest)]
   (clojure.core/let
    [v5294
     (:email-address m5293 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5294 :com.palletops.awaze.client-builder/undef)
     (. bean5292 setEmailAddress (clojure.core/str v5294))))
   bean5292))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest}
list-verified-email-addresses-request
  [m5296]
  (clojure.core/let
   [bean5295
    (new
     com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest)]
   bean5295))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest}
describe-receipt-rule-request
  [m5299]
  (clojure.core/let
   [bean5298
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleRequest)]
   (clojure.core/let
    [v5300
     (:rule-set-name m5299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5300 :com.palletops.awaze.client-builder/undef)
     (. bean5298 setRuleSetName (clojure.core/str v5300))))
   (clojure.core/let
    [v5300
     (:rule-name m5299 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5300 :com.palletops.awaze.client-builder/undef)
     (. bean5298 setRuleName (clojure.core/str v5300))))
   bean5298))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest}
delete-receipt-filter-request
  [m5302]
  (clojure.core/let
   [bean5301
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptFilterRequest)]
   (clojure.core/let
    [v5303
     (:filter-name m5302 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5303 :com.palletops.awaze.client-builder/undef)
     (. bean5301 setFilterName (clojure.core/str v5303))))
   bean5301))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest}
get-identity-verification-attributes-request
  [m5305]
  (clojure.core/let
   [bean5304
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityVerificationAttributesRequest)]
   (clojure.core/let
    [v5306
     (:identities m5305 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5306 :com.palletops.awaze.client-builder/undef)
     (.
      bean5304
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5407] (clojure.core/str arg5407))
 v5306))))
   bean5304))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendQuotaRequest}
get-send-quota-request
  [m5308]
  (clojure.core/let
   [bean5307
    (new com.amazonaws.services.simpleemail.model.GetSendQuotaRequest)]
   bean5307))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest}
create-receipt-rule-set-request
  [m5311]
  (clojure.core/let
   [bean5310
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleSetRequest)]
   (clojure.core/let
    [v5312
     (:rule-set-name m5311 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5312 :com.palletops.awaze.client-builder/undef)
     (. bean5310 setRuleSetName (clojure.core/str v5312))))
   bean5310))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest}
set-identity-notification-topic-request
  [m5314]
  (clojure.core/let
   [bean5313
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityNotificationTopicRequest)]
   (clojure.core/let
    [v5315
     (:identity m5314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5315 :com.palletops.awaze.client-builder/undef)
     (. bean5313 setIdentity (clojure.core/str v5315))))
   (clojure.core/let
    [v5315
     (:notification-type
      m5314
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5315 :com.palletops.awaze.client-builder/undef)
     (.
      bean5313
      setNotificationType
      (simpleemail/notification-type v5315))))
   (clojure.core/let
    [v5315
     (:sns-topic m5314 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5315 :com.palletops.awaze.client-builder/undef)
     (. bean5313 setSnsTopic (clojure.core/str v5315))))
   bean5313))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest}
verify-domain-identity-request
  [m5317]
  (clojure.core/let
   [bean5316
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainIdentityRequest)]
   (clojure.core/let
    [v5318 (:domain m5317 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5318 :com.palletops.awaze.client-builder/undef)
     (. bean5316 setDomain (clojure.core/str v5318))))
   bean5316))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest}
list-identity-policies-request
  [m5320]
  (clojure.core/let
   [bean5319
    (new
     com.amazonaws.services.simpleemail.model.ListIdentityPoliciesRequest)]
   (clojure.core/let
    [v5321
     (:identity m5320 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5321 :com.palletops.awaze.client-builder/undef)
     (. bean5319 setIdentity (clojure.core/str v5321))))
   bean5319))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest}
create-receipt-filter-request
  [m5323]
  (clojure.core/let
   [bean5322
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptFilterRequest)]
   (clojure.core/let
    [v5324 (:filter m5323 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5324 :com.palletops.awaze.client-builder/undef)
     (. bean5322 setFilter (simpleemail/receipt-filter v5324))))
   bean5322))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest}
put-identity-policy-request
  [m5326]
  (clojure.core/let
   [bean5325
    (new
     com.amazonaws.services.simpleemail.model.PutIdentityPolicyRequest)]
   (clojure.core/let
    [v5327 (:policy m5326 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5327 :com.palletops.awaze.client-builder/undef)
     (. bean5325 setPolicy (clojure.core/str v5327))))
   (clojure.core/let
    [v5327
     (:identity m5326 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5327 :com.palletops.awaze.client-builder/undef)
     (. bean5325 setIdentity (clojure.core/str v5327))))
   (clojure.core/let
    [v5327
     (:policy-name m5326 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5327 :com.palletops.awaze.client-builder/undef)
     (. bean5325 setPolicyName (clojure.core/str v5327))))
   bean5325))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest}
verify-domain-dkim-request
  [m5329]
  (clojure.core/let
   [bean5328
    (new
     com.amazonaws.services.simpleemail.model.VerifyDomainDkimRequest)]
   (clojure.core/let
    [v5330 (:domain m5329 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5330 :com.palletops.awaze.client-builder/undef)
     (. bean5328 setDomain (clojure.core/str v5330))))
   bean5328))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest}
set-identity-mail-from-domain-request
  [m5332]
  (clojure.core/let
   [bean5331
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityMailFromDomainRequest)]
   (clojure.core/let
    [v5333
     (:identity m5332 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (. bean5331 setIdentity (clojure.core/str v5333))))
   (clojure.core/let
    [v5333
     (:behavior-on-mxfailure
      m5332
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (. bean5331 setBehaviorOnMXFailure (clojure.core/str v5333))))
   (clojure.core/let
    [v5333
     (:mail-from-domain
      m5332
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5333 :com.palletops.awaze.client-builder/undef)
     (. bean5331 setMailFromDomain (clojure.core/str v5333))))
   bean5331))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest}
get-identity-notification-attributes-request
  [m5335]
  (clojure.core/let
   [bean5334
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityNotificationAttributesRequest)]
   (clojure.core/let
    [v5336
     (:identities m5335 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5336 :com.palletops.awaze.client-builder/undef)
     (.
      bean5334
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5408] (clojure.core/str arg5408))
 v5336))))
   bean5334))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest}
delete-receipt-rule-request
  [m5338]
  (clojure.core/let
   [bean5337
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleRequest)]
   (clojure.core/let
    [v5339
     (:rule-set-name m5338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5339 :com.palletops.awaze.client-builder/undef)
     (. bean5337 setRuleSetName (clojure.core/str v5339))))
   (clojure.core/let
    [v5339
     (:rule-name m5338 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5339 :com.palletops.awaze.client-builder/undef)
     (. bean5337 setRuleName (clojure.core/str v5339))))
   bean5337))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest}
reorder-receipt-rule-set-request
  [m5341]
  (clojure.core/let
   [bean5340
    (new
     com.amazonaws.services.simpleemail.model.ReorderReceiptRuleSetRequest)]
   (clojure.core/let
    [v5342
     (:rule-set-name m5341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (. bean5340 setRuleSetName (clojure.core/str v5342))))
   (clojure.core/let
    [v5342
     (:rule-names m5341 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5342 :com.palletops.awaze.client-builder/undef)
     (.
      bean5340
      setRuleNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5409] (clojure.core/str arg5409))
 v5342))))
   bean5340))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest}
delete-receipt-rule-set-request
  [m5344]
  (clojure.core/let
   [bean5343
    (new
     com.amazonaws.services.simpleemail.model.DeleteReceiptRuleSetRequest)]
   (clojure.core/let
    [v5345
     (:rule-set-name m5344 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5345 :com.palletops.awaze.client-builder/undef)
     (. bean5343 setRuleSetName (clojure.core/str v5345))))
   bean5343))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest}
clone-receipt-rule-set-request
  [m5347]
  (clojure.core/let
   [bean5346
    (new
     com.amazonaws.services.simpleemail.model.CloneReceiptRuleSetRequest)]
   (clojure.core/let
    [v5348
     (:rule-set-name m5347 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5348 :com.palletops.awaze.client-builder/undef)
     (. bean5346 setRuleSetName (clojure.core/str v5348))))
   (clojure.core/let
    [v5348
     (:original-rule-set-name
      m5347
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5348 :com.palletops.awaze.client-builder/undef)
     (. bean5346 setOriginalRuleSetName (clojure.core/str v5348))))
   bean5346))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendBounceRequest}
send-bounce-request
  [m5350]
  (clojure.core/let
   [bean5349
    (new com.amazonaws.services.simpleemail.model.SendBounceRequest)]
   (clojure.core/let
    [v5351
     (:bounce-sender m5350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setBounceSender (clojure.core/str v5351))))
   (clojure.core/let
    [v5351
     (:explanation m5350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setExplanation (clojure.core/str v5351))))
   (clojure.core/let
    [v5351
     (:message-dsn m5350 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setMessageDsn (simpleemail/message-dsn v5351))))
   (clojure.core/let
    [v5351
     (:bounced-recipient-info-list
      m5350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (.
      bean5349
      setBouncedRecipientInfoList
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg5410]
  (simpleemail/bounced-recipient-info arg5410))
 v5351))))
   (clojure.core/let
    [v5351
     (:bounce-sender-arn
      m5350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setBounceSenderArn (clojure.core/str v5351))))
   (clojure.core/let
    [v5351
     (:original-message-id
      m5350
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5351 :com.palletops.awaze.client-builder/undef)
     (. bean5349 setOriginalMessageId (clojure.core/str v5351))))
   bean5349))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest}
delete-identity-policy-request
  [m5353]
  (clojure.core/let
   [bean5352
    (new
     com.amazonaws.services.simpleemail.model.DeleteIdentityPolicyRequest)]
   (clojure.core/let
    [v5354
     (:identity m5353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5354 :com.palletops.awaze.client-builder/undef)
     (. bean5352 setIdentity (clojure.core/str v5354))))
   (clojure.core/let
    [v5354
     (:policy-name m5353 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5354 :com.palletops.awaze.client-builder/undef)
     (. bean5352 setPolicyName (clojure.core/str v5354))))
   bean5352))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest}
get-send-statistics-request
  [m5356]
  (clojure.core/let
   [bean5355
    (new
     com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest)]
   bean5355))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest}
get-identity-dkim-attributes-request
  [m5359]
  (clojure.core/let
   [bean5358
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityDkimAttributesRequest)]
   (clojure.core/let
    [v5360
     (:identities m5359 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5360 :com.palletops.awaze.client-builder/undef)
     (.
      bean5358
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5411] (clojure.core/str arg5411))
 v5360))))
   bean5358))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest}
get-identity-mail-from-domain-attributes-request
  [m5362]
  (clojure.core/let
   [bean5361
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityMailFromDomainAttributesRequest)]
   (clojure.core/let
    [v5363
     (:identities m5362 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5363 :com.palletops.awaze.client-builder/undef)
     (.
      bean5361
      setIdentities
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5412] (clojure.core/str arg5412))
 v5363))))
   bean5361))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest}
delete-verified-email-address-request
  [m5365]
  (clojure.core/let
   [bean5364
    (new
     com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest)]
   (clojure.core/let
    [v5366
     (:email-address m5365 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5366 :com.palletops.awaze.client-builder/undef)
     (. bean5364 setEmailAddress (clojure.core/str v5366))))
   bean5364))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest}
create-receipt-rule-request
  [m5368]
  (clojure.core/let
   [bean5367
    (new
     com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest)]
   (clojure.core/let
    [v5369
     (:rule-set-name m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setRuleSetName (clojure.core/str v5369))))
   (clojure.core/let
    [v5369 (:after m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setAfter (clojure.core/str v5369))))
   (clojure.core/let
    [v5369 (:rule m5368 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5369 :com.palletops.awaze.client-builder/undef)
     (. bean5367 setRule (simpleemail/receipt-rule v5369))))
   bean5367))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest}
describe-receipt-rule-set-request
  [m5371]
  (clojure.core/let
   [bean5370
    (new
     com.amazonaws.services.simpleemail.model.DescribeReceiptRuleSetRequest)]
   (clojure.core/let
    [v5372
     (:rule-set-name m5371 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5372 :com.palletops.awaze.client-builder/undef)
     (. bean5370 setRuleSetName (clojure.core/str v5372))))
   bean5370))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest}
get-identity-policies-request
  [m5374]
  (clojure.core/let
   [bean5373
    (new
     com.amazonaws.services.simpleemail.model.GetIdentityPoliciesRequest)]
   (clojure.core/let
    [v5375
     (:identity m5374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5375 :com.palletops.awaze.client-builder/undef)
     (. bean5373 setIdentity (clojure.core/str v5375))))
   (clojure.core/let
    [v5375
     (:policy-names m5374 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5375 :com.palletops.awaze.client-builder/undef)
     (.
      bean5373
      setPolicyNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5413] (clojure.core/str arg5413))
 v5375))))
   bean5373))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest}
update-receipt-rule-request
  [m5377]
  (clojure.core/let
   [bean5376
    (new
     com.amazonaws.services.simpleemail.model.UpdateReceiptRuleRequest)]
   (clojure.core/let
    [v5378
     (:rule-set-name m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setRuleSetName (clojure.core/str v5378))))
   (clojure.core/let
    [v5378 (:rule m5377 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5378 :com.palletops.awaze.client-builder/undef)
     (. bean5376 setRule (simpleemail/receipt-rule v5378))))
   bean5376))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest}
set-receipt-rule-position-request
  [m5380]
  (clojure.core/let
   [bean5379
    (new
     com.amazonaws.services.simpleemail.model.SetReceiptRulePositionRequest)]
   (clojure.core/let
    [v5381
     (:rule-set-name m5380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5381 :com.palletops.awaze.client-builder/undef)
     (. bean5379 setRuleSetName (clojure.core/str v5381))))
   (clojure.core/let
    [v5381
     (:rule-name m5380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5381 :com.palletops.awaze.client-builder/undef)
     (. bean5379 setRuleName (clojure.core/str v5381))))
   (clojure.core/let
    [v5381 (:after m5380 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5381 :com.palletops.awaze.client-builder/undef)
     (. bean5379 setAfter (clojure.core/str v5381))))
   bean5379))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest}
set-identity-dkim-enabled-request
  [m5383]
  (clojure.core/let
   [bean5382
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityDkimEnabledRequest)]
   (clojure.core/let
    [v5384
     (:identity m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setIdentity (clojure.core/str v5384))))
   (clojure.core/let
    [v5384
     (:dkim-enabled m5383 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5384 :com.palletops.awaze.client-builder/undef)
     (. bean5382 setDkimEnabled (clojure.core/boolean v5384))))
   bean5382))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendEmailRequest}
send-email-request
  [m5386]
  (clojure.core/let
   [bean5385
    (new com.amazonaws.services.simpleemail.model.SendEmailRequest)]
   (clojure.core/let
    [v5387 (:source m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setSource (clojure.core/str v5387))))
   (clojure.core/let
    [v5387
     (:source-arn m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setSourceArn (clojure.core/str v5387))))
   (clojure.core/let
    [v5387
     (:return-path-arn
      m5386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setReturnPathArn (clojure.core/str v5387))))
   (clojure.core/let
    [v5387
     (:destination m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setDestination (simpleemail/destination v5387))))
   (clojure.core/let
    [v5387
     (:reply-to-addresses
      m5386
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (.
      bean5385
      setReplyToAddresses
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5414] (clojure.core/str arg5414))
 v5387))))
   (clojure.core/let
    [v5387
     (:return-path m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setReturnPath (clojure.core/str v5387))))
   (clojure.core/let
    [v5387 (:message m5386 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5387 :com.palletops.awaze.client-builder/undef)
     (. bean5385 setMessage (simpleemail/message v5387))))
   bean5385))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest}
set-identity-feedback-forwarding-enabled-request
  [m5389]
  (clojure.core/let
   [bean5388
    (new
     com.amazonaws.services.simpleemail.model.SetIdentityFeedbackForwardingEnabledRequest)]
   (clojure.core/let
    [v5390
     (:identity m5389 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5390 :com.palletops.awaze.client-builder/undef)
     (. bean5388 setIdentity (clojure.core/str v5390))))
   (clojure.core/let
    [v5390
     (:forwarding-enabled
      m5389
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5390 :com.palletops.awaze.client-builder/undef)
     (. bean5388 setForwardingEnabled (clojure.core/boolean v5390))))
   bean5388))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SendRawEmailRequest}
send-raw-email-request
  [m5392]
  (clojure.core/let
   [bean5391
    (new com.amazonaws.services.simpleemail.model.SendRawEmailRequest)]
   (clojure.core/let
    [v5393 (:source m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (. bean5391 setSource (clojure.core/str v5393))))
   (clojure.core/let
    [v5393
     (:destinations m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (.
      bean5391
      setDestinations
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg5519] (clojure.core/str arg5519))
 v5393))))
   (clojure.core/let
    [v5393
     (:raw-message m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (. bean5391 setRawMessage (simpleemail/raw-message v5393))))
   (clojure.core/let
    [v5393
     (:from-arn m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (. bean5391 setFromArn (clojure.core/str v5393))))
   (clojure.core/let
    [v5393
     (:source-arn m5392 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (. bean5391 setSourceArn (clojure.core/str v5393))))
   (clojure.core/let
    [v5393
     (:return-path-arn
      m5392
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5393 :com.palletops.awaze.client-builder/undef)
     (. bean5391 setReturnPathArn (clojure.core/str v5393))))
   bean5391))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest}
set-active-receipt-rule-set-request
  [m5395]
  (clojure.core/let
   [bean5394
    (new
     com.amazonaws.services.simpleemail.model.SetActiveReceiptRuleSetRequest)]
   (clojure.core/let
    [v5396
     (:rule-set-name m5395 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5396 :com.palletops.awaze.client-builder/undef)
     (. bean5394 setRuleSetName (clojure.core/str v5396))))
   bean5394))
 (clojure.core/defn
^{:tag com.amazonaws.services.simpleemail.model.ListIdentitiesRequest}
list-identities-request
  [m5398]
  (clojure.core/let
   [bean5397
    (new
     com.amazonaws.services.simpleemail.model.ListIdentitiesRequest)]
   (clojure.core/let
    [v5399
     (:identity-type m5398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5399 :com.palletops.awaze.client-builder/undef)
     (. bean5397 setIdentityType (simpleemail/identity-type v5399))))
   (clojure.core/let
    [v5399
     (:max-items m5398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5399 :com.palletops.awaze.client-builder/undef)
     (. bean5397 setMaxItems (clojure.core/int v5399))))
   (clojure.core/let
    [v5399
     (:next-token m5398 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v5399 :com.palletops.awaze.client-builder/undef)
     (. bean5397 setNextToken (clojure.core/str v5399))))
   bean5397))
 (clojure.core/defmulti
  simpleemail
  (clojure.core/fn
   simpleemail
   [m__1874__auto__]
   (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-rule-sets
   [m5415]
   (clojure.core/let
    [credentials5416 (:credentials m5415) args5417 (:args m5415)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5418
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5416)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5418
       listReceiptRuleSets
       (simpleemail/list-receipt-rule-sets-request
        (clojure.core/nth args5417 0)))))))
  (clojure.core/defn
   list-receipt-rule-sets-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listReceiptRuleSets"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-receipt-rule-sets,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-rule-sets
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listReceiptRuleSets"}
   [credentials5420 & args5421]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5422
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5420)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5422
      listReceiptRuleSets
      (simpleemail/list-receipt-rule-sets-request
       (clojure.core/nth args5421 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-address
   [m5423]
   (clojure.core/let
    [credentials5424 (:credentials m5423) args5425 (:args m5423)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5426
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5424)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5426
       verifyEmailAddress
       (simpleemail/verify-email-address-request
        (clojure.core/nth args5425 0)))))))
  (clojure.core/defn
   verify-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-email-address,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailAddress"}
   [credentials5428 & args5429]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5430
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5428)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5430
      verifyEmailAddress
      (simpleemail/verify-email-address-request
       (clojure.core/nth args5429 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-active-receipt-rule-set
   [m5431]
   (clojure.core/let
    [credentials5432 (:credentials m5431) args5433 (:args m5431)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5434
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5432)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5434
       describeActiveReceiptRuleSet
       (simpleemail/describe-active-receipt-rule-set-request
        (clojure.core/nth args5433 0)))))))
  (clojure.core/defn
   describe-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeActiveReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-active-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeActiveReceiptRuleSet"}
   [credentials5436 & args5437]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5438
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5436)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5438
      describeActiveReceiptRuleSet
      (simpleemail/describe-active-receipt-rule-set-request
       (clojure.core/nth args5437 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-receipt-filters
   [m5439]
   (clojure.core/let
    [credentials5440 (:credentials m5439) args5441 (:args m5439)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5442
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5440)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5442
       listReceiptFilters
       (simpleemail/list-receipt-filters-request
        (clojure.core/nth args5441 0)))))))
  (clojure.core/defn
   list-receipt-filters-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listReceiptFilters"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-receipt-filters,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-receipt-filters
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listReceiptFilters"}
   [credentials5444 & args5445]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5446
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5444)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5446
      listReceiptFilters
      (simpleemail/list-receipt-filters-request
       (clojure.core/nth args5445 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity
   [m5447]
   (clojure.core/let
    [credentials5448 (:credentials m5447) args5449 (:args m5447)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5450
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5448)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5450
       deleteIdentity
       (simpleemail/delete-identity-request
        (clojure.core/nth args5449 0)))))))
  (clojure.core/defn
   delete-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentity"}
   [credentials5452 & args5453]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5454
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5452)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5454
      deleteIdentity
      (simpleemail/delete-identity-request
       (clojure.core/nth args5453 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-email-identity
   [m5455]
   (clojure.core/let
    [credentials5456 (:credentials m5455) args5457 (:args m5455)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5458
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5456)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5458
       verifyEmailIdentity
       (simpleemail/verify-email-identity-request
        (clojure.core/nth args5457 0)))))))
  (clojure.core/defn
   verify-email-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyEmailIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-email-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-email-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyEmailIdentity"}
   [credentials5460 & args5461]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5462
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5460)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5462
      verifyEmailIdentity
      (simpleemail/verify-email-identity-request
       (clojure.core/nth args5461 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-verified-email-addresses
   [m5463]
   (clojure.core/let
    [credentials5464 (:credentials m5463) args5465 (:args m5463)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5466
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5464)]
     (clojure.core/case
      (clojure.core/count args5465)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5466
        listVerifiedEmailAddresses
        (simpleemail/list-verified-email-addresses-request
         (clojure.core/nth args5465 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5466
        listVerifiedEmailAddresses))))))
  (clojure.core/defn
   list-verified-email-addresses-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Generate map for listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-verified-email-addresses,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-verified-email-addresses,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-verified-email-addresses
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]]),
    :doc "Call listVerifiedEmailAddresses, listVerifiedEmailAddresses"}
   [credentials5468 & args5469]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5470
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5468)]
    (clojure.core/case
     (clojure.core/count args5469)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5470
       listVerifiedEmailAddresses
       (simpleemail/list-verified-email-addresses-request
        (clojure.core/nth args5469 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5470
       listVerifiedEmailAddresses))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule
   [m5471]
   (clojure.core/let
    [credentials5472 (:credentials m5471) args5473 (:args m5471)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5474
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5472)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5474
       describeReceiptRule
       (simpleemail/describe-receipt-rule-request
        (clojure.core/nth args5473 0)))))))
  (clojure.core/defn
   describe-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for describeReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call describeReceiptRule"}
   [credentials5476 & args5477]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5478
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5476)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5478
      describeReceiptRule
      (simpleemail/describe-receipt-rule-request
       (clojure.core/nth args5477 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-filter
   [m5479]
   (clojure.core/let
    [credentials5480 (:credentials m5479) args5481 (:args m5479)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5482
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5480)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5482
       deleteReceiptFilter
       (simpleemail/delete-receipt-filter-request
        (clojure.core/nth args5481 0)))))))
  (clojure.core/defn
   delete-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptFilter"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-filter,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         filter-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptFilter"}
   [credentials5484 & args5485]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5486
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5484)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5486
      deleteReceiptFilter
      (simpleemail/delete-receipt-filter-request
       (clojure.core/nth args5485 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-verification-attributes
   [m5487]
   (clojure.core/let
    [credentials5488 (:credentials m5487) args5489 (:args m5487)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5490
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5488)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5490
       getIdentityVerificationAttributes
       (simpleemail/get-identity-verification-attributes-request
        (clojure.core/nth args5489 0)))))))
  (clojure.core/defn
   get-identity-verification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityVerificationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-verification-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-verification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityVerificationAttributes"}
   [credentials5492 & args5493]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5494
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5492)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5494
      getIdentityVerificationAttributes
      (simpleemail/get-identity-verification-attributes-request
       (clojure.core/nth args5493 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-quota
   [m5495]
   (clojure.core/let
    [credentials5496 (:credentials m5495) args5497 (:args m5495)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5498
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5496)]
     (clojure.core/case
      (clojure.core/count args5497)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5498
        getSendQuota))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5498
        getSendQuota
        (simpleemail/get-send-quota-request
         (clojure.core/nth args5497 0))))))))
  (clojure.core/defn
   get-send-quota-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSendQuota, getSendQuota"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-send-quota,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-send-quota,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-quota
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSendQuota, getSendQuota"}
   [credentials5500 & args5501]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5502
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5500)]
    (clojure.core/case
     (clojure.core/count args5501)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5502
       getSendQuota))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5502
       getSendQuota
       (simpleemail/get-send-quota-request
        (clojure.core/nth args5501 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule-set
   [m5503]
   (clojure.core/let
    [credentials5504 (:credentials m5503) args5505 (:args m5503)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5506
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5504)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5506
       createReceiptRuleSet
       (simpleemail/create-receipt-rule-set-request
        (clojure.core/nth args5505 0)))))))
  (clojure.core/defn
   create-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRuleSet"}
   [credentials5508 & args5509]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5510
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5508)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5510
      createReceiptRuleSet
      (simpleemail/create-receipt-rule-set-request
       (clojure.core/nth args5509 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-notification-topic
   [m5511]
   (clojure.core/let
    [credentials5512 (:credentials m5511) args5513 (:args m5511)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5514
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5512)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5514
       setIdentityNotificationTopic
       (simpleemail/set-identity-notification-topic-request
        (clojure.core/nth args5513 0)))))))
  (clojure.core/defn
   set-identity-notification-topic-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityNotificationTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-notification-topic,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-notification-topic
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         sns-topic
                         notification-type
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityNotificationTopic"}
   [credentials5516 & args5517]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5518
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5516)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5518
      setIdentityNotificationTopic
      (simpleemail/set-identity-notification-topic-request
       (clojure.core/nth args5517 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-identity
   [m5520]
   (clojure.core/let
    [credentials5521 (:credentials m5520) args5522 (:args m5520)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5523
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5521)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5523
       verifyDomainIdentity
       (simpleemail/verify-domain-identity-request
        (clojure.core/nth args5522 0)))))))
  (clojure.core/defn
   verify-domain-identity-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainIdentity"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-domain-identity,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-identity
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainIdentity"}
   [credentials5525 & args5526]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5527
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5525)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5527
      verifyDomainIdentity
      (simpleemail/verify-domain-identity-request
       (clojure.core/nth args5526 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identity-policies
   [m5528]
   (clojure.core/let
    [credentials5529 (:credentials m5528) args5530 (:args m5528)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5531
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5529)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5531
       listIdentityPolicies
       (simpleemail/list-identity-policies-request
        (clojure.core/nth args5530 0)))))))
  (clojure.core/defn
   list-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for listIdentityPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-identity-policies,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call listIdentityPolicies"}
   [credentials5533 & args5534]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5535
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5533)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5535
      listIdentityPolicies
      (simpleemail/list-identity-policies-request
       (clojure.core/nth args5534 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-filter
   [m5536]
   (clojure.core/let
    [credentials5537 (:credentials m5536) args5538 (:args m5536)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5539
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5537)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5539
       createReceiptFilter
       (simpleemail/create-receipt-filter-request
        (clojure.core/nth args5538 0)))))))
  (clojure.core/defn
   create-receipt-filter-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptFilter"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-filter,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-filter
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         filter
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptFilter"}
   [credentials5541 & args5542]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5543
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5541)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5543
      createReceiptFilter
      (simpleemail/create-receipt-filter-request
       (clojure.core/nth args5542 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :put-identity-policy
   [m5544]
   (clojure.core/let
    [credentials5545 (:credentials m5544) args5546 (:args m5544)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5547
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5545)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5547
       putIdentityPolicy
       (simpleemail/put-identity-policy-request
        (clojure.core/nth args5546 0)))))))
  (clojure.core/defn
   put-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for putIdentityPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :put-identity-policy,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   put-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         policy
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call putIdentityPolicy"}
   [credentials5549 & args5550]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5551
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5549)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5551
      putIdentityPolicy
      (simpleemail/put-identity-policy-request
       (clojure.core/nth args5550 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :verify-domain-dkim
   [m5552]
   (clojure.core/let
    [credentials5553 (:credentials m5552) args5554 (:args m5552)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5555
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5553)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5555
       verifyDomainDkim
       (simpleemail/verify-domain-dkim-request
        (clojure.core/nth args5554 0)))))))
  (clojure.core/defn
   verify-domain-dkim-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for verifyDomainDkim"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :verify-domain-dkim,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   verify-domain-dkim
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         domain
                         clone-source
                         clone-root]}]]),
    :doc "Call verifyDomainDkim"}
   [credentials5557 & args5558]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5559
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5557)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5559
      verifyDomainDkim
      (simpleemail/verify-domain-dkim-request
       (clojure.core/nth args5558 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-mail-from-domain
   [m5560]
   (clojure.core/let
    [credentials5561 (:credentials m5560) args5562 (:args m5560)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5563
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5561)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5563
       setIdentityMailFromDomain
       (simpleemail/set-identity-mail-from-domain-request
        (clojure.core/nth args5562 0)))))))
  (clojure.core/defn
   set-identity-mail-from-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Generate map for setIdentityMailFromDomain"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-mail-from-domain,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-mail-from-domain
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         behavior-on-mxfailure
                         clone-root
                         mail-from-domain]}]]),
    :doc "Call setIdentityMailFromDomain"}
   [credentials5565 & args5566]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5567
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5565)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5567
      setIdentityMailFromDomain
      (simpleemail/set-identity-mail-from-domain-request
       (clojure.core/nth args5566 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-notification-attributes
   [m5568]
   (clojure.core/let
    [credentials5569 (:credentials m5568) args5570 (:args m5568)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5571
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5569)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5571
       getIdentityNotificationAttributes
       (simpleemail/get-identity-notification-attributes-request
        (clojure.core/nth args5570 0)))))))
  (clojure.core/defn
   get-identity-notification-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityNotificationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-notification-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-notification-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityNotificationAttributes"}
   [credentials5573 & args5574]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5575
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5573)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5575
      getIdentityNotificationAttributes
      (simpleemail/get-identity-notification-attributes-request
       (clojure.core/nth args5574 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule
   [m5576]
   (clojure.core/let
    [credentials5577 (:credentials m5576) args5578 (:args m5576)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5579
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5577)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5579
       deleteReceiptRule
       (simpleemail/delete-receipt-rule-request
        (clojure.core/nth args5578 0)))))))
  (clojure.core/defn
   delete-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for deleteReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call deleteReceiptRule"}
   [credentials5581 & args5582]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5583
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5581)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5583
      deleteReceiptRule
      (simpleemail/delete-receipt-rule-request
       (clojure.core/nth args5582 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :reorder-receipt-rule-set
   [m5584]
   (clojure.core/let
    [credentials5585 (:credentials m5584) args5586 (:args m5584)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5587
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5585)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5587
       reorderReceiptRuleSet
       (simpleemail/reorder-receipt-rule-set-request
        (clojure.core/nth args5586 0)))))))
  (clojure.core/defn
   reorder-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for reorderReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :reorder-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   reorder-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         rule-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call reorderReceiptRuleSet"}
   [credentials5589 & args5590]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5591
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5589)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5591
      reorderReceiptRuleSet
      (simpleemail/reorder-receipt-rule-set-request
       (clojure.core/nth args5590 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-receipt-rule-set
   [m5592]
   (clojure.core/let
    [credentials5593 (:credentials m5592) args5594 (:args m5592)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5595
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5593)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5595
       deleteReceiptRuleSet
       (simpleemail/delete-receipt-rule-set-request
        (clojure.core/nth args5594 0)))))))
  (clojure.core/defn
   delete-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteReceiptRuleSet"}
   [credentials5597 & args5598]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5599
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5597)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5599
      deleteReceiptRuleSet
      (simpleemail/delete-receipt-rule-set-request
       (clojure.core/nth args5598 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :clone-receipt-rule-set
   [m5600]
   (clojure.core/let
    [credentials5601 (:credentials m5600) args5602 (:args m5600)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5603
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5601)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5603
       cloneReceiptRuleSet
       (simpleemail/clone-receipt-rule-set-request
        (clojure.core/nth args5602 0)))))))
  (clojure.core/defn
   clone-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for cloneReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :clone-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   clone-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         original-rule-set-name
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call cloneReceiptRuleSet"}
   [credentials5605 & args5606]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5607
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5605)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5607
      cloneReceiptRuleSet
      (simpleemail/clone-receipt-rule-set-request
       (clojure.core/nth args5606 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-bounce
   [m5608]
   (clojure.core/let
    [credentials5609 (:credentials m5608) args5610 (:args m5608)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5611
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5609)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5611
       sendBounce
       (simpleemail/send-bounce-request (clojure.core/nth args5610 0)))))))
  (clojure.core/defn
   send-bounce-map
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Generate map for sendBounce"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-bounce,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-bounce
   {:arglists (quote
               [[credentials
                 {:keys [explanation
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         bounce-sender
                         read-limit
                         bounced-recipient-info-list
                         general-progress-listener
                         message-dsn
                         original-message-id
                         clone-source
                         clone-root
                         bounce-sender-arn]}]]),
    :doc "Call sendBounce"}
   [credentials5613 & args5614]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5615
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5613)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5615
      sendBounce
      (simpleemail/send-bounce-request (clojure.core/nth args5614 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-identity-policy
   [m5616]
   (clojure.core/let
    [credentials5617 (:credentials m5616) args5618 (:args m5616)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5619
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5617)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5619
       deleteIdentityPolicy
       (simpleemail/delete-identity-policy-request
        (clojure.core/nth args5618 0)))))))
  (clojure.core/defn
   delete-identity-policy-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteIdentityPolicy"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-identity-policy,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-identity-policy
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         policy-name
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteIdentityPolicy"}
   [credentials5621 & args5622]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5623
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5621)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5623
      deleteIdentityPolicy
      (simpleemail/delete-identity-policy-request
       (clojure.core/nth args5622 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-send-statistics
   [m5624]
   (clojure.core/let
    [credentials5625 (:credentials m5624) args5626 (:args m5624)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5627
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5625)]
     (clojure.core/case
      (clojure.core/count args5626)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5627
        getSendStatistics))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5627
        getSendStatistics
        (simpleemail/get-send-statistics-request
         (clojure.core/nth args5626 0))))))))
  (clojure.core/defn
   get-send-statistics-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getSendStatistics, getSendStatistics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :get-send-statistics,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-send-statistics,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-send-statistics
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getSendStatistics, getSendStatistics"}
   [credentials5629 & args5630]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5631
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5629)]
    (clojure.core/case
     (clojure.core/count args5630)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5631
       getSendStatistics))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5631
       getSendStatistics
       (simpleemail/get-send-statistics-request
        (clojure.core/nth args5630 0))))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-dkim-attributes
   [m5632]
   (clojure.core/let
    [credentials5633 (:credentials m5632) args5634 (:args m5632)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5635
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5633)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5635
       getIdentityDkimAttributes
       (simpleemail/get-identity-dkim-attributes-request
        (clojure.core/nth args5634 0)))))))
  (clojure.core/defn
   get-identity-dkim-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityDkimAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-dkim-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-dkim-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityDkimAttributes"}
   [credentials5637 & args5638]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5639
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5637)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5639
      getIdentityDkimAttributes
      (simpleemail/get-identity-dkim-attributes-request
       (clojure.core/nth args5638 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-mail-from-domain-attributes
   [m5640]
   (clojure.core/let
    [credentials5641 (:credentials m5640) args5642 (:args m5640)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5643
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5641)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5643
       getIdentityMailFromDomainAttributes
       (simpleemail/get-identity-mail-from-domain-attributes-request
        (clojure.core/nth args5642 0)))))))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Generate map for getIdentityMailFromDomainAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-mail-from-domain-attributes,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-mail-from-domain-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         identities
                         clone-root]}]]),
    :doc "Call getIdentityMailFromDomainAttributes"}
   [credentials5645 & args5646]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5647
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5645)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5647
      getIdentityMailFromDomainAttributes
      (simpleemail/get-identity-mail-from-domain-attributes-request
       (clojure.core/nth args5646 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :delete-verified-email-address
   [m5648]
   (clojure.core/let
    [credentials5649 (:credentials m5648) args5650 (:args m5648)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5651
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5649)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5651
       deleteVerifiedEmailAddress
       (simpleemail/delete-verified-email-address-request
        (clojure.core/nth args5650 0)))))))
  (clojure.core/defn
   delete-verified-email-address-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteVerifiedEmailAddress"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-verified-email-address,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   delete-verified-email-address
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         email-address
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteVerifiedEmailAddress"}
   [credentials5653 & args5654]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5655
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5653)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5655
      deleteVerifiedEmailAddress
      (simpleemail/delete-verified-email-address-request
       (clojure.core/nth args5654 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :create-receipt-rule
   [m5656]
   (clojure.core/let
    [credentials5657 (:credentials m5656) args5658 (:args m5656)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5659
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5657)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5659
       createReceiptRule
       (simpleemail/create-receipt-rule-request
        (clojure.core/nth args5658 0)))))))
  (clojure.core/defn
   create-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   create-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createReceiptRule"}
   [credentials5661 & args5662]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5663
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5661)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5663
      createReceiptRule
      (simpleemail/create-receipt-rule-request
       (clojure.core/nth args5662 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :describe-receipt-rule-set
   [m5664]
   (clojure.core/let
    [credentials5665 (:credentials m5664) args5666 (:args m5664)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5667
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5665)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5667
       describeReceiptRuleSet
       (simpleemail/describe-receipt-rule-set-request
        (clojure.core/nth args5666 0)))))))
  (clojure.core/defn
   describe-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for describeReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :describe-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   describe-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call describeReceiptRuleSet"}
   [credentials5669 & args5670]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5671
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5669)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5671
      describeReceiptRuleSet
      (simpleemail/describe-receipt-rule-set-request
       (clojure.core/nth args5670 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :get-identity-policies
   [m5672]
   (clojure.core/let
    [credentials5673 (:credentials m5672) args5674 (:args m5672)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5675
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5673)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5675
       getIdentityPolicies
       (simpleemail/get-identity-policies-request
        (clojure.core/nth args5674 0)))))))
  (clojure.core/defn
   get-identity-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getIdentityPolicies"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-identity-policies,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   get-identity-policies
   {:arglists (quote
               [[credentials
                 {:keys [policy-names
                         custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getIdentityPolicies"}
   [credentials5677 & args5678]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5679
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5677)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5679
      getIdentityPolicies
      (simpleemail/get-identity-policies-request
       (clojure.core/nth args5678 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :update-receipt-rule
   [m5680]
   (clojure.core/let
    [credentials5681 (:credentials m5680) args5682 (:args m5680)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5683
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5681)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5683
       updateReceiptRule
       (simpleemail/update-receipt-rule-request
        (clojure.core/nth args5682 0)))))))
  (clojure.core/defn
   update-receipt-rule-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for updateReceiptRule"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :update-receipt-rule,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   update-receipt-rule
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         rule
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call updateReceiptRule"}
   [credentials5685 & args5686]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5687
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5685)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5687
      updateReceiptRule
      (simpleemail/update-receipt-rule-request
       (clojure.core/nth args5686 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-receipt-rule-position
   [m5688]
   (clojure.core/let
    [credentials5689 (:credentials m5688) args5690 (:args m5688)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5691
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5689)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5691
       setReceiptRulePosition
       (simpleemail/set-receipt-rule-position-request
        (clojure.core/nth args5690 0)))))))
  (clojure.core/defn
   set-receipt-rule-position-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Generate map for setReceiptRulePosition"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-receipt-rule-position,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-receipt-rule-position
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         after
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         rule-name]}]]),
    :doc "Call setReceiptRulePosition"}
   [credentials5693 & args5694]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5695
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5693)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5695
      setReceiptRulePosition
      (simpleemail/set-receipt-rule-position-request
       (clojure.core/nth args5694 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-dkim-enabled
   [m5696]
   (clojure.core/let
    [credentials5697 (:credentials m5696) args5698 (:args m5696)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5699
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5697)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5699
       setIdentityDkimEnabled
       (simpleemail/set-identity-dkim-enabled-request
        (clojure.core/nth args5698 0)))))))
  (clojure.core/defn
   set-identity-dkim-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Generate map for setIdentityDkimEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-dkim-enabled,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-dkim-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         dkim-enabled
                         clone-root]}]]),
    :doc "Call setIdentityDkimEnabled"}
   [credentials5701 & args5702]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5703
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5701)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5703
      setIdentityDkimEnabled
      (simpleemail/set-identity-dkim-enabled-request
       (clojure.core/nth args5702 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-email
   [m5704]
   (clojure.core/let
    [credentials5705 (:credentials m5704) args5706 (:args m5704)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5707
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5705)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5707
       sendEmail
       (simpleemail/send-email-request (clojure.core/nth args5706 0)))))))
  (clojure.core/defn
   send-email-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Generate map for sendEmail"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-email,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-email
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         reply-to-addresses
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         clone-root
                         destination
                         return-path
                         message]}]]),
    :doc "Call sendEmail"}
   [credentials5709 & args5710]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5711
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5709)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5711
      sendEmail
      (simpleemail/send-email-request (clojure.core/nth args5710 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-identity-feedback-forwarding-enabled
   [m5712]
   (clojure.core/let
    [credentials5713 (:credentials m5712) args5714 (:args m5712)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5715
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5713)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5715
       setIdentityFeedbackForwardingEnabled
       (simpleemail/set-identity-feedback-forwarding-enabled-request
        (clojure.core/nth args5714 0)))))))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setIdentityFeedbackForwardingEnabled"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-identity-feedback-forwarding-enabled,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-identity-feedback-forwarding-enabled
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         identity
                         sdk-request-timeout
                         forwarding-enabled
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setIdentityFeedbackForwardingEnabled"}
   [credentials5717 & args5718]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5719
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5717)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5719
      setIdentityFeedbackForwardingEnabled
      (simpleemail/set-identity-feedback-forwarding-enabled-request
       (clojure.core/nth args5718 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :send-raw-email
   [m5720]
   (clojure.core/let
    [credentials5721 (:credentials m5720) args5722 (:args m5720)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5723
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5721)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5723
       sendRawEmail
       (simpleemail/send-raw-email-request
        (clojure.core/nth args5722 0)))))))
  (clojure.core/defn
   send-raw-email-map
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Generate map for sendRawEmail"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-raw-email,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   send-raw-email
   {:arglists (quote
               [[credentials
                 {:keys [destinations
                         custom-request-headers
                         sdk-client-execution-timeout
                         from-arn
                         sdk-request-timeout
                         custom-query-parameters
                         source
                         read-limit
                         source-arn
                         general-progress-listener
                         return-path-arn
                         clone-source
                         raw-message
                         clone-root]}]]),
    :doc "Call sendRawEmail"}
   [credentials5725 & args5726]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5727
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5725)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5727
      sendRawEmail
      (simpleemail/send-raw-email-request
       (clojure.core/nth args5726 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :set-active-receipt-rule-set
   [m5728]
   (clojure.core/let
    [credentials5729 (:credentials m5728) args5730 (:args m5728)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5731
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5729)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5731
       setActiveReceiptRuleSet
       (simpleemail/set-active-receipt-rule-set-request
        (clojure.core/nth args5730 0)))))))
  (clojure.core/defn
   set-active-receipt-rule-set-map
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setActiveReceiptRuleSet"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-active-receipt-rule-set,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   set-active-receipt-rule-set
   {:arglists (quote
               [[credentials
                 {:keys [rule-set-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setActiveReceiptRuleSet"}
   [credentials5733 & args5734]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5735
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5733)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5735
      setActiveReceiptRuleSet
      (simpleemail/set-active-receipt-rule-set-request
       (clojure.core/nth args5734 0)))))))
 (do
  (clojure.core/defmethod
   simpleemail
   :list-identities
   [m5736]
   (clojure.core/let
    [credentials5737 (:credentials m5736) args5738 (:args m5736)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
      client5739
      (com.palletops.awaze.common/aws-client
       :simpleemail
       credentials5737)]
     (clojure.core/case
      (clojure.core/count args5738)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5739
        listIdentities
        (simpleemail/list-identities-request
         (clojure.core/nth args5738 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5739
        listIdentities))))))
  (clojure.core/defn
   list-identities-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listIdentities, listIdentities"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-identities,
     :credentials credentials__1842__auto__,
     :client :simpleemail})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-identities,
     :credentials credentials__1842__auto__,
     :client :simpleemail}))
  (clojure.core/defn
   list-identities
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         max-items
                         read-limit
                         general-progress-listener
                         clone-source
                         identity-type
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listIdentities, listIdentities"}
   [credentials5741 & args5742]
   (clojure.core/let
    [^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
     client5743
     (com.palletops.awaze.common/aws-client
      :simpleemail
      credentials5741)]
    (clojure.core/case
     (clojure.core/count args5742)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5743
       listIdentities
       (simpleemail/list-identities-request
        (clojure.core/nth args5742 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient}
client5743
       listIdentities)))))))
