(ns
 com.palletops.awaze.sns
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sns :as sns]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sns
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sns.AmazonSNSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.MessageAttributeValue}
message-attribute-value
  [m6111]
  (clojure.core/let
   [bean6110
    (new com.amazonaws.services.sns.model.MessageAttributeValue)]
   (clojure.core/let
    [v6112
     (:data-type m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (. bean6110 setDataType (clojure.core/str v6112))))
   (clojure.core/let
    [v6112
     (:string-value m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (. bean6110 setStringValue (clojure.core/str v6112))))
   (clojure.core/let
    [v6112
     (:binary-value m6111 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6112 :com.palletops.awaze.client-builder/undef)
     (. bean6110 setBinaryValue (clojure.core/identity v6112))))
   bean6110))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
list-topics-request
  [m6114]
  (clojure.core/let
   [bean6113 (new com.amazonaws.services.sns.model.ListTopicsRequest)]
   (clojure.core/let
    [v6115
     (:next-token m6114 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6115 :com.palletops.awaze.client-builder/undef)
     (. bean6113 setNextToken (clojure.core/str v6115))))
   bean6113))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetTopicAttributesRequest}
set-topic-attributes-request
  [m6117]
  (clojure.core/let
   [bean6116
    (new com.amazonaws.services.sns.model.SetTopicAttributesRequest)]
   (clojure.core/let
    [v6118
     (:attribute-name m6117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6118 :com.palletops.awaze.client-builder/undef)
     (. bean6116 setAttributeName (clojure.core/str v6118))))
   (clojure.core/let
    [v6118
     (:attribute-value
      m6117
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6118 :com.palletops.awaze.client-builder/undef)
     (. bean6116 setAttributeValue (clojure.core/str v6118))))
   (clojure.core/let
    [v6118
     (:topic-arn m6117 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6118 :com.palletops.awaze.client-builder/undef)
     (. bean6116 setTopicArn (clojure.core/str v6118))))
   bean6116))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.RemovePermissionRequest}
remove-permission-request
  [m6120]
  (clojure.core/let
   [bean6119
    (new com.amazonaws.services.sns.model.RemovePermissionRequest)]
   (clojure.core/let
    [v6121 (:label m6120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6121 :com.palletops.awaze.client-builder/undef)
     (. bean6119 setLabel (clojure.core/str v6121))))
   (clojure.core/let
    [v6121
     (:topic-arn m6120 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6121 :com.palletops.awaze.client-builder/undef)
     (. bean6119 setTopicArn (clojure.core/str v6121))))
   bean6119))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
unsubscribe-request
  [m6123]
  (clojure.core/let
   [bean6122
    (new com.amazonaws.services.sns.model.UnsubscribeRequest)]
   (clojure.core/let
    [v6124
     (:subscription-arn
      m6123
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6124 :com.palletops.awaze.client-builder/undef)
     (. bean6122 setSubscriptionArn (clojure.core/str v6124))))
   bean6122))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeletePlatformApplicationRequest}
delete-platform-application-request
  [m6126]
  (clojure.core/let
   [bean6125
    (new
     com.amazonaws.services.sns.model.DeletePlatformApplicationRequest)]
   (clojure.core/let
    [v6127
     (:platform-application-arn
      m6126
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6127 :com.palletops.awaze.client-builder/undef)
     (. bean6125 setPlatformApplicationArn (clojure.core/str v6127))))
   bean6125))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteEndpointRequest}
delete-endpoint-request
  [m6129]
  (clojure.core/let
   [bean6128
    (new com.amazonaws.services.sns.model.DeleteEndpointRequest)]
   (clojure.core/let
    [v6130
     (:endpoint-arn m6129 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6130 :com.palletops.awaze.client-builder/undef)
     (. bean6128 setEndpointArn (clojure.core/str v6130))))
   bean6128))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
get-subscription-attributes-request
  [m6132]
  (clojure.core/let
   [bean6131
    (new
     com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6133
     (:subscription-arn
      m6132
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6133 :com.palletops.awaze.client-builder/undef)
     (. bean6131 setSubscriptionArn (clojure.core/str v6133))))
   bean6131))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformApplicationRequest}
create-platform-application-request
  [m6135]
  (clojure.core/let
   [bean6134
    (new
     com.amazonaws.services.sns.model.CreatePlatformApplicationRequest)]
   (clojure.core/let
    [v6136
     (:platform m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setPlatform (clojure.core/str v6136))))
   (clojure.core/let
    [v6136
     (:attributes m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (.
      bean6134
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6188] (clojure.core/str arg6188))
  (clojure.core/keys v6136))
 (clojure.core/map
  (clojure.core/fn [arg6188] (clojure.core/str arg6188))
  (clojure.core/vals v6136))))))
   (clojure.core/let
    [v6136 (:name m6135 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6136 :com.palletops.awaze.client-builder/undef)
     (. bean6134 setName (clojure.core/str v6136))))
   bean6134))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest}
set-platform-application-attributes-request
  [m6138]
  (clojure.core/let
   [bean6137
    (new
     com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6139
     (:platform-application-arn
      m6138
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (. bean6137 setPlatformApplicationArn (clojure.core/str v6139))))
   (clojure.core/let
    [v6139
     (:attributes m6138 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6139 :com.palletops.awaze.client-builder/undef)
     (.
      bean6137
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6189] (clojure.core/str arg6189))
  (clojure.core/keys v6139))
 (clojure.core/map
  (clojure.core/fn [arg6189] (clojure.core/str arg6189))
  (clojure.core/vals v6139))))))
   bean6137))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ConfirmSubscriptionRequest}
confirm-subscription-request
  [m6141]
  (clojure.core/let
   [bean6140
    (new com.amazonaws.services.sns.model.ConfirmSubscriptionRequest)]
   (clojure.core/let
    [v6142 (:token m6141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (. bean6140 setToken (clojure.core/str v6142))))
   (clojure.core/let
    [v6142
     (:authenticate-on-unsubscribe
      m6141
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (.
      bean6140
      setAuthenticateOnUnsubscribe
      (clojure.core/str v6142))))
   (clojure.core/let
    [v6142
     (:topic-arn m6141 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6142 :com.palletops.awaze.client-builder/undef)
     (. bean6140 setTopicArn (clojure.core/str v6142))))
   bean6140))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreatePlatformEndpointRequest}
create-platform-endpoint-request
  [m6144]
  (clojure.core/let
   [bean6143
    (new
     com.amazonaws.services.sns.model.CreatePlatformEndpointRequest)]
   (clojure.core/let
    [v6145
     (:platform-application-arn
      m6144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (. bean6143 setPlatformApplicationArn (clojure.core/str v6145))))
   (clojure.core/let
    [v6145 (:token m6144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (. bean6143 setToken (clojure.core/str v6145))))
   (clojure.core/let
    [v6145
     (:custom-user-data
      m6144
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (. bean6143 setCustomUserData (clojure.core/str v6145))))
   (clojure.core/let
    [v6145
     (:attributes m6144 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6145 :com.palletops.awaze.client-builder/undef)
     (.
      bean6143
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6190] (clojure.core/str arg6190))
  (clojure.core/keys v6145))
 (clojure.core/map
  (clojure.core/fn [arg6190] (clojure.core/str arg6190))
  (clojure.core/vals v6145))))))
   bean6143))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListPlatformApplicationsRequest}
list-platform-applications-request
  [m6147]
  (clojure.core/let
   [bean6146
    (new
     com.amazonaws.services.sns.model.ListPlatformApplicationsRequest)]
   (clojure.core/let
    [v6148
     (:next-token m6147 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6148 :com.palletops.awaze.client-builder/undef)
     (. bean6146 setNextToken (clojure.core/str v6148))))
   bean6146))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
create-topic-request
  [m6150]
  (clojure.core/let
   [bean6149
    (new com.amazonaws.services.sns.model.CreateTopicRequest)]
   (clojure.core/let
    [v6151 (:name m6150 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6151 :com.palletops.awaze.client-builder/undef)
     (. bean6149 setName (clojure.core/str v6151))))
   bean6149))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest}
list-endpoints-by-platform-application-request
  [m6153]
  (clojure.core/let
   [bean6152
    (new
     com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest)]
   (clojure.core/let
    [v6154
     (:next-token m6153 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setNextToken (clojure.core/str v6154))))
   (clojure.core/let
    [v6154
     (:platform-application-arn
      m6153
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6154 :com.palletops.awaze.client-builder/undef)
     (. bean6152 setPlatformApplicationArn (clojure.core/str v6154))))
   bean6152))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest}
get-platform-application-attributes-request
  [m6156]
  (clojure.core/let
   [bean6155
    (new
     com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest)]
   (clojure.core/let
    [v6157
     (:platform-application-arn
      m6156
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6157 :com.palletops.awaze.client-builder/undef)
     (. bean6155 setPlatformApplicationArn (clojure.core/str v6157))))
   bean6155))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest}
set-subscription-attributes-request
  [m6159]
  (clojure.core/let
   [bean6158
    (new
     com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest)]
   (clojure.core/let
    [v6160
     (:subscription-arn
      m6159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setSubscriptionArn (clojure.core/str v6160))))
   (clojure.core/let
    [v6160
     (:attribute-name m6159 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setAttributeName (clojure.core/str v6160))))
   (clojure.core/let
    [v6160
     (:attribute-value
      m6159
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6160 :com.palletops.awaze.client-builder/undef)
     (. bean6158 setAttributeValue (clojure.core/str v6160))))
   bean6158))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.AddPermissionRequest}
add-permission-request
  [m6162]
  (clojure.core/let
   [bean6161
    (new com.amazonaws.services.sns.model.AddPermissionRequest)]
   (clojure.core/let
    [v6163 (:label m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setLabel (clojure.core/str v6163))))
   (clojure.core/let
    [v6163
     (:awsaccount-ids m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (.
      bean6161
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6223] (clojure.core/str arg6223))
 v6163))))
   (clojure.core/let
    [v6163
     (:action-names m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (.
      bean6161
      setActionNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg6224] (clojure.core/str arg6224))
 v6163))))
   (clojure.core/let
    [v6163
     (:topic-arn m6162 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6163 :com.palletops.awaze.client-builder/undef)
     (. bean6161 setTopicArn (clojure.core/str v6163))))
   bean6161))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
list-subscriptions-request
  [m6165]
  (clojure.core/let
   [bean6164
    (new com.amazonaws.services.sns.model.ListSubscriptionsRequest)]
   (clojure.core/let
    [v6166
     (:next-token m6165 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6166 :com.palletops.awaze.client-builder/undef)
     (. bean6164 setNextToken (clojure.core/str v6166))))
   bean6164))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
get-topic-attributes-request
  [m6168]
  (clojure.core/let
   [bean6167
    (new com.amazonaws.services.sns.model.GetTopicAttributesRequest)]
   (clojure.core/let
    [v6169
     (:topic-arn m6168 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6169 :com.palletops.awaze.client-builder/undef)
     (. bean6167 setTopicArn (clojure.core/str v6169))))
   bean6167))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.GetEndpointAttributesRequest}
get-endpoint-attributes-request
  [m6171]
  (clojure.core/let
   [bean6170
    (new
     com.amazonaws.services.sns.model.GetEndpointAttributesRequest)]
   (clojure.core/let
    [v6172
     (:endpoint-arn m6171 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6172 :com.palletops.awaze.client-builder/undef)
     (. bean6170 setEndpointArn (clojure.core/str v6172))))
   bean6170))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
delete-topic-request
  [m6174]
  (clojure.core/let
   [bean6173
    (new com.amazonaws.services.sns.model.DeleteTopicRequest)]
   (clojure.core/let
    [v6175
     (:topic-arn m6174 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6175 :com.palletops.awaze.client-builder/undef)
     (. bean6173 setTopicArn (clojure.core/str v6175))))
   bean6173))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SubscribeRequest}
subscribe-request
  [m6177]
  (clojure.core/let
   [bean6176 (new com.amazonaws.services.sns.model.SubscribeRequest)]
   (clojure.core/let
    [v6178
     (:endpoint m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setEndpoint (clojure.core/str v6178))))
   (clojure.core/let
    [v6178
     (:protocol m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setProtocol (clojure.core/str v6178))))
   (clojure.core/let
    [v6178
     (:topic-arn m6177 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6178 :com.palletops.awaze.client-builder/undef)
     (. bean6176 setTopicArn (clojure.core/str v6178))))
   bean6176))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
list-subscriptions-by-topic-request
  [m6180]
  (clojure.core/let
   [bean6179
    (new
     com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest)]
   (clojure.core/let
    [v6181
     (:next-token m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setNextToken (clojure.core/str v6181))))
   (clojure.core/let
    [v6181
     (:topic-arn m6180 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6181 :com.palletops.awaze.client-builder/undef)
     (. bean6179 setTopicArn (clojure.core/str v6181))))
   bean6179))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.PublishRequest}
publish-request
  [m6183]
  (clojure.core/let
   [bean6182 (new com.amazonaws.services.sns.model.PublishRequest)]
   (clojure.core/let
    [v6184
     (:target-arn m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setTargetArn (clojure.core/str v6184))))
   (clojure.core/let
    [v6184
     (:message-structure
      m6183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setMessageStructure (clojure.core/str v6184))))
   (clojure.core/let
    [v6184
     (:message-attributes
      m6183
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (.
      bean6182
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6225] (clojure.core/str arg6225))
  (clojure.core/keys v6184))
 (clojure.core/map
  (clojure.core/fn [arg6225] (sns/message-attribute-value arg6225))
  (clojure.core/vals v6184))))))
   (clojure.core/let
    [v6184 (:message m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setMessage (clojure.core/str v6184))))
   (clojure.core/let
    [v6184 (:subject m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setSubject (clojure.core/str v6184))))
   (clojure.core/let
    [v6184
     (:topic-arn m6183 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6184 :com.palletops.awaze.client-builder/undef)
     (. bean6182 setTopicArn (clojure.core/str v6184))))
   bean6182))
 (clojure.core/defn
^{:tag com.amazonaws.services.sns.model.SetEndpointAttributesRequest}
set-endpoint-attributes-request
  [m6186]
  (clojure.core/let
   [bean6185
    (new
     com.amazonaws.services.sns.model.SetEndpointAttributesRequest)]
   (clojure.core/let
    [v6187
     (:attributes m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (.
      bean6185
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg6226] (clojure.core/str arg6226))
  (clojure.core/keys v6187))
 (clojure.core/map
  (clojure.core/fn [arg6226] (clojure.core/str arg6226))
  (clojure.core/vals v6187))))))
   (clojure.core/let
    [v6187
     (:endpoint-arn m6186 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v6187 :com.palletops.awaze.client-builder/undef)
     (. bean6185 setEndpointArn (clojure.core/str v6187))))
   bean6185))
 (clojure.core/defmulti
  sns
  (clojure.core/fn sns [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sns
   :list-topics
   [m6191]
   (clojure.core/let
    [credentials6192 (:credentials m6191) args6193 (:args m6191)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6194
      (com.palletops.awaze.common/aws-client :sns credentials6192)]
     (clojure.core/case
      (clojure.core/count args6193)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6193 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6194
           listTopics
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListTopicsRequest
               (clojure.core/nth args6193 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6194
               listTopics
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listTopics")
                {:args args6193}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6194
        listTopics))))))
  (clojure.core/defn
   list-topics-map
   {:arglists (quote
               [[credentials string-0]
                [credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listTopics, listTopics, listTopics"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-topics,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-topics,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-topics
   {:arglists (quote
               [[credentials string-0]
                [credentials]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listTopics, listTopics, listTopics"}
   [credentials6196 & args6197]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6198
     (com.palletops.awaze.common/aws-client :sns credentials6196)]
    (clojure.core/case
     (clojure.core/count args6197)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6197 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6198
          listTopics
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListTopicsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListTopicsRequest
              (clojure.core/nth args6197 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6198
              listTopics
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listTopics")
               {:args args6197}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6198
       listTopics))))))
 (do
  (clojure.core/defmethod
   sns
   :set-topic-attributes
   [m6199]
   (clojure.core/let
    [credentials6200 (:credentials m6199) args6201 (:args m6199)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6202
      (com.palletops.awaze.common/aws-client :sns credentials6200)]
     (clojure.core/case
      (clojure.core/count args6201)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6202
        setTopicAttributes
        (clojure.core/str (clojure.core/nth args6201 0))
        (clojure.core/str (clojure.core/nth args6201 1))
        (clojure.core/str (clojure.core/nth args6201 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6202
        setTopicAttributes
        (sns/set-topic-attributes-request
         (clojure.core/nth args6201 0))))))))
  (clojure.core/defn
   set-topic-attributes-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for setTopicAttributes, setTopicAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-topic-attributes
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call setTopicAttributes, setTopicAttributes"}
   [credentials6204 & args6205]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6206
     (com.palletops.awaze.common/aws-client :sns credentials6204)]
    (clojure.core/case
     (clojure.core/count args6205)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6206
       setTopicAttributes
       (clojure.core/str (clojure.core/nth args6205 0))
       (clojure.core/str (clojure.core/nth args6205 1))
       (clojure.core/str (clojure.core/nth args6205 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6206
       setTopicAttributes
       (sns/set-topic-attributes-request
        (clojure.core/nth args6205 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :remove-permission
   [m6207]
   (clojure.core/let
    [credentials6208 (:credentials m6207) args6209 (:args m6207)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6210
      (com.palletops.awaze.common/aws-client :sns credentials6208)]
     (clojure.core/case
      (clojure.core/count args6209)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6210
        removePermission
        (clojure.core/str (clojure.core/nth args6209 0))
        (clojure.core/str (clojure.core/nth args6209 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6210
        removePermission
        (sns/remove-permission-request (clojure.core/nth args6209 0))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call removePermission, removePermission"}
   [credentials6212 & args6213]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6214
     (com.palletops.awaze.common/aws-client :sns credentials6212)]
    (clojure.core/case
     (clojure.core/count args6213)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6214
       removePermission
       (clojure.core/str (clojure.core/nth args6213 0))
       (clojure.core/str (clojure.core/nth args6213 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6214
       removePermission
       (sns/remove-permission-request (clojure.core/nth args6213 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :unsubscribe
   [m6215]
   (clojure.core/let
    [credentials6216 (:credentials m6215) args6217 (:args m6215)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6218
      (com.palletops.awaze.common/aws-client :sns credentials6216)]
     (clojure.core/case
      (clojure.core/count args6217)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6217 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6218
           unsubscribe
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.UnsubscribeRequest
               (clojure.core/nth args6217 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6218
               unsubscribe
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "unsubscribe")
                {:args args6217}))))))))))))))
  (clojure.core/defn
   unsubscribe-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Generate map for unsubscribe, unsubscribe"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :unsubscribe,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   unsubscribe
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Call unsubscribe, unsubscribe"}
   [credentials6220 & args6221]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6222
     (com.palletops.awaze.common/aws-client :sns credentials6220)]
    (clojure.core/case
     (clojure.core/count args6221)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6221 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6222
          unsubscribe
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.UnsubscribeRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.UnsubscribeRequest
              (clojure.core/nth args6221 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6222
              unsubscribe
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "unsubscribe")
               {:args args6221}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-platform-application
   [m6227]
   (clojure.core/let
    [credentials6228 (:credentials m6227) args6229 (:args m6227)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6230
      (com.palletops.awaze.common/aws-client :sns credentials6228)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6230
       deletePlatformApplication
       (sns/delete-platform-application-request
        (clojure.core/nth args6229 0)))))))
  (clojure.core/defn
   delete-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deletePlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deletePlatformApplication"}
   [credentials6232 & args6233]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6234
     (com.palletops.awaze.common/aws-client :sns credentials6232)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6234
      deletePlatformApplication
      (sns/delete-platform-application-request
       (clojure.core/nth args6233 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-endpoint
   [m6235]
   (clojure.core/let
    [credentials6236 (:credentials m6235) args6237 (:args m6235)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6238
      (com.palletops.awaze.common/aws-client :sns credentials6236)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6238
       deleteEndpoint
       (sns/delete-endpoint-request (clojure.core/nth args6237 0)))))))
  (clojure.core/defn
   delete-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-endpoint,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteEndpoint"}
   [credentials6240 & args6241]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6242
     (com.palletops.awaze.common/aws-client :sns credentials6240)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6242
      deleteEndpoint
      (sns/delete-endpoint-request (clojure.core/nth args6241 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-subscription-attributes
   [m6243]
   (clojure.core/let
    [credentials6244 (:credentials m6243) args6245 (:args m6243)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6246
      (com.palletops.awaze.common/aws-client :sns credentials6244)]
     (clojure.core/case
      (clojure.core/count args6245)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6245 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6246
           getSubscriptionAttributes
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
               (clojure.core/nth args6245 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6246
               getSubscriptionAttributes
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getSubscriptionAttributes")
                {:args args6245}))))))))))))))
  (clojure.core/defn
   get-subscription-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Generate map for getSubscriptionAttributes, getSubscriptionAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-subscription-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]]),
    :doc "Call getSubscriptionAttributes, getSubscriptionAttributes"}
   [credentials6248 & args6249]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6250
     (com.palletops.awaze.common/aws-client :sns credentials6248)]
    (clojure.core/case
     (clojure.core/count args6249)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6249 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6250
          getSubscriptionAttributes
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest
              (clojure.core/nth args6249 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6250
              getSubscriptionAttributes
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getSubscriptionAttributes")
               {:args args6249}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-application
   [m6251]
   (clojure.core/let
    [credentials6252 (:credentials m6251) args6253 (:args m6251)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6254
      (com.palletops.awaze.common/aws-client :sns credentials6252)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6254
       createPlatformApplication
       (sns/create-platform-application-request
        (clojure.core/nth args6253 0)))))))
  (clojure.core/defn
   create-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Generate map for createPlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         platform]}]]),
    :doc "Call createPlatformApplication"}
   [credentials6256 & args6257]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6258
     (com.palletops.awaze.common/aws-client :sns credentials6256)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6258
      createPlatformApplication
      (sns/create-platform-application-request
       (clojure.core/nth args6257 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-platform-application-attributes
   [m6259]
   (clojure.core/let
    [credentials6260 (:credentials m6259) args6261 (:args m6259)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6262
      (com.palletops.awaze.common/aws-client :sns credentials6260)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6262
       setPlatformApplicationAttributes
       (sns/set-platform-application-attributes-request
        (clojure.core/nth args6261 0)))))))
  (clojure.core/defn
   set-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setPlatformApplicationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-platform-application-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setPlatformApplicationAttributes"}
   [credentials6264 & args6265]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6266
     (com.palletops.awaze.common/aws-client :sns credentials6264)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6266
      setPlatformApplicationAttributes
      (sns/set-platform-application-attributes-request
       (clojure.core/nth args6265 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :confirm-subscription
   [m6267]
   (clojure.core/let
    [credentials6268 (:credentials m6267) args6269 (:args m6267)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6270
      (com.palletops.awaze.common/aws-client :sns credentials6268)]
     (clojure.core/case
      (clojure.core/count args6269)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6270
        confirmSubscription
        (sns/confirm-subscription-request
         (clojure.core/nth args6269 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6270
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6269 0))
        (clojure.core/str (clojure.core/nth args6269 1))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6270
        confirmSubscription
        (clojure.core/str (clojure.core/nth args6269 0))
        (clojure.core/str (clojure.core/nth args6269 1))
        (clojure.core/str (clojure.core/nth args6269 2))))))))
  (clojure.core/defn
   confirm-subscription-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for confirmSubscription, confirmSubscription, confirmSubscription"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :confirm-subscription,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   confirm-subscription
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         authenticate-on-unsubscribe
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1]
                [credentials string-0 string-1 string-2]]),
    :doc "Call confirmSubscription, confirmSubscription, confirmSubscription"}
   [credentials6272 & args6273]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6274
     (com.palletops.awaze.common/aws-client :sns credentials6272)]
    (clojure.core/case
     (clojure.core/count args6273)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6274
       confirmSubscription
       (sns/confirm-subscription-request
        (clojure.core/nth args6273 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6274
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6273 0))
       (clojure.core/str (clojure.core/nth args6273 1))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6274
       confirmSubscription
       (clojure.core/str (clojure.core/nth args6273 0))
       (clojure.core/str (clojure.core/nth args6273 1))
       (clojure.core/str (clojure.core/nth args6273 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :create-platform-endpoint
   [m6275]
   (clojure.core/let
    [credentials6276 (:credentials m6275) args6277 (:args m6275)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6278
      (com.palletops.awaze.common/aws-client :sns credentials6276)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6278
       createPlatformEndpoint
       (sns/create-platform-endpoint-request
        (clojure.core/nth args6277 0)))))))
  (clojure.core/defn
   create-platform-endpoint-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createPlatformEndpoint"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-platform-endpoint,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-platform-endpoint
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-user-data
                         custom-query-parameters
                         token
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call createPlatformEndpoint"}
   [credentials6280 & args6281]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6282
     (com.palletops.awaze.common/aws-client :sns credentials6280)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6282
      createPlatformEndpoint
      (sns/create-platform-endpoint-request
       (clojure.core/nth args6281 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :list-platform-applications
   [m6283]
   (clojure.core/let
    [credentials6284 (:credentials m6283) args6285 (:args m6283)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6286
      (com.palletops.awaze.common/aws-client :sns credentials6284)]
     (clojure.core/case
      (clojure.core/count args6285)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6286
        listPlatformApplications
        (sns/list-platform-applications-request
         (clojure.core/nth args6285 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6286
        listPlatformApplications))))))
  (clojure.core/defn
   list-platform-applications-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listPlatformApplications, listPlatformApplications"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-platform-applications,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-platform-applications,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-platform-applications
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listPlatformApplications, listPlatformApplications"}
   [credentials6288 & args6289]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6290
     (com.palletops.awaze.common/aws-client :sns credentials6288)]
    (clojure.core/case
     (clojure.core/count args6289)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6290
       listPlatformApplications
       (sns/list-platform-applications-request
        (clojure.core/nth args6289 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6290
       listPlatformApplications))))))
 (do
  (clojure.core/defmethod
   sns
   :create-topic
   [m6291]
   (clojure.core/let
    [credentials6292 (:credentials m6291) args6293 (:args m6291)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6294
      (com.palletops.awaze.common/aws-client :sns credentials6292)]
     (clojure.core/case
      (clojure.core/count args6293)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6293 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6294
           createTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.CreateTopicRequest
               (clojure.core/nth args6293 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6294
               createTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createTopic")
                {:args args6293}))))))))))))))
  (clojure.core/defn
   create-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for createTopic, createTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   create-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         name
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call createTopic, createTopic"}
   [credentials6296 & args6297]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6298
     (com.palletops.awaze.common/aws-client :sns credentials6296)]
    (clojure.core/case
     (clojure.core/count args6297)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6297 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6298
          createTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.CreateTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.CreateTopicRequest
              (clojure.core/nth args6297 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6298
              createTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createTopic")
               {:args args6297}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-endpoints-by-platform-application
   [m6299]
   (clojure.core/let
    [credentials6300 (:credentials m6299) args6301 (:args m6299)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6302
      (com.palletops.awaze.common/aws-client :sns credentials6300)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6302
       listEndpointsByPlatformApplication
       (sns/list-endpoints-by-platform-application-request
        (clojure.core/nth args6301 0)))))))
  (clojure.core/defn
   list-endpoints-by-platform-application-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listEndpointsByPlatformApplication"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-endpoints-by-platform-application,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-endpoints-by-platform-application
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listEndpointsByPlatformApplication"}
   [credentials6304 & args6305]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6306
     (com.palletops.awaze.common/aws-client :sns credentials6304)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6306
      listEndpointsByPlatformApplication
      (sns/list-endpoints-by-platform-application-request
       (clojure.core/nth args6305 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :get-platform-application-attributes
   [m6307]
   (clojure.core/let
    [credentials6308 (:credentials m6307) args6309 (:args m6307)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6310
      (com.palletops.awaze.common/aws-client :sns credentials6308)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6310
       getPlatformApplicationAttributes
       (sns/get-platform-application-attributes-request
        (clojure.core/nth args6309 0)))))))
  (clojure.core/defn
   get-platform-application-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getPlatformApplicationAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-platform-application-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-platform-application-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         platform-application-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getPlatformApplicationAttributes"}
   [credentials6312 & args6313]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6314
     (com.palletops.awaze.common/aws-client :sns credentials6312)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6314
      getPlatformApplicationAttributes
      (sns/get-platform-application-attributes-request
       (clojure.core/nth args6313 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :set-subscription-attributes
   [m6315]
   (clojure.core/let
    [credentials6316 (:credentials m6315) args6317 (:args m6315)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6318
      (com.palletops.awaze.common/aws-client :sns credentials6316)]
     (clojure.core/case
      (clojure.core/count args6317)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6318
        setSubscriptionAttributes
        (sns/set-subscription-attributes-request
         (clojure.core/nth args6317 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6318
        setSubscriptionAttributes
        (clojure.core/str (clojure.core/nth args6317 0))
        (clojure.core/str (clojure.core/nth args6317 1))
        (clojure.core/str (clojure.core/nth args6317 2))))))))
  (clojure.core/defn
   set-subscription-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Generate map for setSubscriptionAttributes, setSubscriptionAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :set-subscription-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-subscription-attributes
   {:arglists (quote
               [[credentials
                 {:keys [attribute-name
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         attribute-value
                         general-progress-listener
                         clone-source
                         clone-root
                         subscription-arn]}]
                [credentials string-0 string-1 string-2]]),
    :doc "Call setSubscriptionAttributes, setSubscriptionAttributes"}
   [credentials6320 & args6321]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6322
     (com.palletops.awaze.common/aws-client :sns credentials6320)]
    (clojure.core/case
     (clojure.core/count args6321)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6322
       setSubscriptionAttributes
       (sns/set-subscription-attributes-request
        (clojure.core/nth args6321 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6322
       setSubscriptionAttributes
       (clojure.core/str (clojure.core/nth args6321 0))
       (clojure.core/str (clojure.core/nth args6321 1))
       (clojure.core/str (clojure.core/nth args6321 2))))))))
 (do
  (clojure.core/defmethod
   sns
   :add-permission
   [m6323]
   (clojure.core/let
    [credentials6324 (:credentials m6323) args6325 (:args m6323)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6326
      (com.palletops.awaze.common/aws-client :sns credentials6324)]
     (clojure.core/case
      (clojure.core/count args6325)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6326
        addPermission
        (sns/add-permission-request (clojure.core/nth args6325 0))))
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6326
        addPermission
        (clojure.core/str (clojure.core/nth args6325 0))
        (clojure.core/str (clojure.core/nth args6325 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6355] (clojure.core/str arg6355))
 (clojure.core/nth args6325 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6356] (clojure.core/str arg6356))
 (clojure.core/nth args6325 3))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         action-names
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials string-0 string-1 list-2 list-3]]),
    :doc "Call addPermission, addPermission"}
   [credentials6328 & args6329]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6330
     (com.palletops.awaze.common/aws-client :sns credentials6328)]
    (clojure.core/case
     (clojure.core/count args6329)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6330
       addPermission
       (sns/add-permission-request (clojure.core/nth args6329 0))))
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6330
       addPermission
       (clojure.core/str (clojure.core/nth args6329 0))
       (clojure.core/str (clojure.core/nth args6329 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6357] (clojure.core/str arg6357))
 (clojure.core/nth args6329 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg6358] (clojure.core/str arg6358))
 (clojure.core/nth args6329 3))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions
   [m6331]
   (clojure.core/let
    [credentials6332 (:credentials m6331) args6333 (:args m6331)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6334
      (com.palletops.awaze.common/aws-client :sns credentials6332)]
     (clojure.core/case
      (clojure.core/count args6333)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6333 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6334
           listSubscriptions
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsRequest
               (clojure.core/nth args6333 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6334
               listSubscriptions
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptions")
                {:args args6333}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6334
        listSubscriptions))))))
  (clojure.core/defn
   list-subscriptions-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Generate map for listSubscriptions, listSubscriptions, listSubscriptions"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-subscriptions,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-subscriptions,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]
                [credentials]]),
    :doc "Call listSubscriptions, listSubscriptions, listSubscriptions"}
   [credentials6336 & args6337]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6338
     (com.palletops.awaze.common/aws-client :sns credentials6336)]
    (clojure.core/case
     (clojure.core/count args6337)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6337 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6338
          listSubscriptions
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsRequest
              (clojure.core/nth args6337 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6338
              listSubscriptions
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptions")
               {:args args6337}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6338
       listSubscriptions))))))
 (do
  (clojure.core/defmethod
   sns
   :get-topic-attributes
   [m6339]
   (clojure.core/let
    [credentials6340 (:credentials m6339) args6341 (:args m6339)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6342
      (com.palletops.awaze.common/aws-client :sns credentials6340)]
     (clojure.core/case
      (clojure.core/count args6341)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6341 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6342
           getTopicAttributes
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.GetTopicAttributesRequest
               (clojure.core/nth args6341 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6342
               getTopicAttributes
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getTopicAttributes")
                {:args args6341}))))))))))))))
  (clojure.core/defn
   get-topic-attributes-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getTopicAttributes, getTopicAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-topic-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-topic-attributes
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call getTopicAttributes, getTopicAttributes"}
   [credentials6344 & args6345]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6346
     (com.palletops.awaze.common/aws-client :sns credentials6344)]
    (clojure.core/case
     (clojure.core/count args6345)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6345 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6346
          getTopicAttributes
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.GetTopicAttributesRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.GetTopicAttributesRequest
              (clojure.core/nth args6345 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6346
              getTopicAttributes
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getTopicAttributes")
               {:args args6345}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :get-endpoint-attributes
   [m6347]
   (clojure.core/let
    [credentials6348 (:credentials m6347) args6349 (:args m6347)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6350
      (com.palletops.awaze.common/aws-client :sns credentials6348)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6350
       getEndpointAttributes
       (sns/get-endpoint-attributes-request
        (clojure.core/nth args6349 0)))))))
  (clojure.core/defn
   get-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for getEndpointAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-endpoint-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   get-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         clone-root]}]]),
    :doc "Call getEndpointAttributes"}
   [credentials6352 & args6353]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6354
     (com.palletops.awaze.common/aws-client :sns credentials6352)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6354
      getEndpointAttributes
      (sns/get-endpoint-attributes-request
       (clojure.core/nth args6353 0)))))))
 (do
  (clojure.core/defmethod
   sns
   :delete-topic
   [m6359]
   (clojure.core/let
    [credentials6360 (:credentials m6359) args6361 (:args m6359)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6362
      (com.palletops.awaze.common/aws-client :sns credentials6360)]
     (clojure.core/case
      (clojure.core/count args6361)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6361 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6362
           deleteTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.DeleteTopicRequest
               (clojure.core/nth args6361 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6362
               deleteTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteTopic")
                {:args args6361}))))))))))))))
  (clojure.core/defn
   delete-topic-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Generate map for deleteTopic, deleteTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   delete-topic
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]]),
    :doc "Call deleteTopic, deleteTopic"}
   [credentials6364 & args6365]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6366
     (com.palletops.awaze.common/aws-client :sns credentials6364)]
    (clojure.core/case
     (clojure.core/count args6365)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6365 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6366
          deleteTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.DeleteTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.DeleteTopicRequest
              (clojure.core/nth args6365 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6366
              deleteTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteTopic")
               {:args args6365}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :subscribe
   [m6367]
   (clojure.core/let
    [credentials6368 (:credentials m6367) args6369 (:args m6367)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6370
      (com.palletops.awaze.common/aws-client :sns credentials6368)]
     (clojure.core/case
      (clojure.core/count args6369)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6370
        subscribe
        (clojure.core/str (clojure.core/nth args6369 0))
        (clojure.core/str (clojure.core/nth args6369 1))
        (clojure.core/str (clojure.core/nth args6369 2))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6370
        subscribe
        (sns/subscribe-request (clojure.core/nth args6369 0))))))))
  (clojure.core/defn
   subscribe-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]]),
    :doc "Generate map for subscribe, subscribe"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :subscribe,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :subscribe,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   subscribe
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         protocol
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         endpoint
                         clone-root]}]]),
    :doc "Call subscribe, subscribe"}
   [credentials6372 & args6373]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6374
     (com.palletops.awaze.common/aws-client :sns credentials6372)]
    (clojure.core/case
     (clojure.core/count args6373)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6374
       subscribe
       (clojure.core/str (clojure.core/nth args6373 0))
       (clojure.core/str (clojure.core/nth args6373 1))
       (clojure.core/str (clojure.core/nth args6373 2))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6374
       subscribe
       (sns/subscribe-request (clojure.core/nth args6373 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :list-subscriptions-by-topic
   [m6375]
   (clojure.core/let
    [credentials6376 (:credentials m6375) args6377 (:args m6375)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6378
      (com.palletops.awaze.common/aws-client :sns credentials6376)]
     (clojure.core/case
      (clojure.core/count args6377)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6378
        listSubscriptionsByTopic
        (clojure.core/str (clojure.core/nth args6377 0))
        (clojure.core/str (clojure.core/nth args6377 1))))
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args6377 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6378
           listSubscriptionsByTopic
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
               (clojure.core/nth args6377 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6378
               listSubscriptionsByTopic
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listSubscriptionsByTopic")
                {:args args6377}))))))))))))))
  (clojure.core/defn
   list-subscriptions-by-topic-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Generate map for listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :list-subscriptions-by-topic,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   list-subscriptions-by-topic
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         next-token]}]]),
    :doc "Call listSubscriptionsByTopic, listSubscriptionsByTopic, listSubscriptionsByTopic"}
   [credentials6380 & args6381]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6382
     (com.palletops.awaze.common/aws-client :sns credentials6380)]
    (clojure.core/case
     (clojure.core/count args6381)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6382
       listSubscriptionsByTopic
       (clojure.core/str (clojure.core/nth args6381 0))
       (clojure.core/str (clojure.core/nth args6381 1))))
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args6381 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6382
          listSubscriptionsByTopic
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest
              (clojure.core/nth args6381 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6382
              listSubscriptionsByTopic
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listSubscriptionsByTopic")
               {:args args6381}))))))))))))))
 (do
  (clojure.core/defmethod
   sns
   :publish
   [m6383]
   (clojure.core/let
    [credentials6384 (:credentials m6383) args6385 (:args m6383)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6386
      (com.palletops.awaze.common/aws-client :sns credentials6384)]
     (clojure.core/case
      (clojure.core/count args6385)
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6386
        publish
        (clojure.core/str (clojure.core/nth args6385 0))
        (clojure.core/str (clojure.core/nth args6385 1))
        (clojure.core/str (clojure.core/nth args6385 2))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6386
        publish
        (clojure.core/str (clojure.core/nth args6385 0))
        (clojure.core/str (clojure.core/nth args6385 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6386
        publish
        (sns/publish-request (clojure.core/nth args6385 0))))))))
  (clojure.core/defn
   publish-map
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]]),
    :doc "Generate map for publish, publish, publish"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :publish,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   publish
   {:arglists (quote
               [[credentials string-0 string-1 string-2]
                [credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         topic-arn
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-structure
                         clone-source
                         subject
                         clone-root
                         message
                         target-arn]}]]),
    :doc "Call publish, publish, publish"}
   [credentials6388 & args6389]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6390
     (com.palletops.awaze.common/aws-client :sns credentials6388)]
    (clojure.core/case
     (clojure.core/count args6389)
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6390
       publish
       (clojure.core/str (clojure.core/nth args6389 0))
       (clojure.core/str (clojure.core/nth args6389 1))
       (clojure.core/str (clojure.core/nth args6389 2))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6390
       publish
       (clojure.core/str (clojure.core/nth args6389 0))
       (clojure.core/str (clojure.core/nth args6389 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6390
       publish
       (sns/publish-request (clojure.core/nth args6389 0))))))))
 (do
  (clojure.core/defmethod
   sns
   :set-endpoint-attributes
   [m6391]
   (clojure.core/let
    [credentials6392 (:credentials m6391) args6393 (:args m6391)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
      client6394
      (com.palletops.awaze.common/aws-client :sns credentials6392)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6394
       setEndpointAttributes
       (sns/set-endpoint-attributes-request
        (clojure.core/nth args6393 0)))))))
  (clojure.core/defn
   set-endpoint-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Generate map for setEndpointAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-endpoint-attributes,
     :credentials credentials__1842__auto__,
     :client :sns}))
  (clojure.core/defn
   set-endpoint-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         endpoint-arn
                         clone-source
                         attributes
                         clone-root]}]]),
    :doc "Call setEndpointAttributes"}
   [credentials6396 & args6397]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sns.AmazonSNSClient}
     client6398
     (com.palletops.awaze.common/aws-client :sns credentials6396)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sns.AmazonSNSClient}
client6398
      setEndpointAttributes
      (sns/set-endpoint-attributes-request
       (clojure.core/nth args6397 0))))))))
