(ns
 com.palletops.awaze.sqs
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.sqs :as sqs]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :sqs
  [___1791__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1792__auto__]
  (new
   com.amazonaws.services.sqs.AmazonSQSClient
   credentials__1792__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.MessageAttributeValue}
message-attribute-value
  [m8495]
  (clojure.core/let
   [bean8494
    (new com.amazonaws.services.sqs.model.MessageAttributeValue)]
   (clojure.core/let
    [v8496
     (:data-type m8495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (. bean8494 setDataType (clojure.core/str v8496))))
   (clojure.core/let
    [v8496
     (:string-value m8495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (. bean8494 setStringValue (clojure.core/str v8496))))
   (clojure.core/let
    [v8496
     (:binary-value m8495 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (. bean8494 setBinaryValue (clojure.core/identity v8496))))
   (clojure.core/let
    [v8496
     (:string-list-values
      m8495
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (.
      bean8494
      setStringListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8557] (clojure.core/str arg8557))
 v8496))))
   (clojure.core/let
    [v8496
     (:binary-list-values
      m8495
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8496 :com.palletops.awaze.client-builder/undef)
     (.
      bean8494
      setBinaryListValues
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8558] (clojure.core/identity arg8558))
 v8496))))
   bean8494))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry}
change-message-visibility-batch-request-entry
  [m8498]
  (clojure.core/let
   [bean8497
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry)]
   (clojure.core/let
    [v8499 (:id m8498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8499 :com.palletops.awaze.client-builder/undef)
     (. bean8497 setId (clojure.core/str v8499))))
   (clojure.core/let
    [v8499
     (:receipt-handle m8498 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8499 :com.palletops.awaze.client-builder/undef)
     (. bean8497 setReceiptHandle (clojure.core/str v8499))))
   (clojure.core/let
    [v8499
     (:visibility-timeout
      m8498
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8499 :com.palletops.awaze.client-builder/undef)
     (. bean8497 setVisibilityTimeout (clojure.core/int v8499))))
   bean8497))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry}
delete-message-batch-request-entry
  [m8501]
  (clojure.core/let
   [bean8500
    (new
     com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry)]
   (clojure.core/let
    [v8502 (:id m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (. bean8500 setId (clojure.core/str v8502))))
   (clojure.core/let
    [v8502
     (:receipt-handle m8501 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8502 :com.palletops.awaze.client-builder/undef)
     (. bean8500 setReceiptHandle (clojure.core/str v8502))))
   bean8500))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry}
send-message-batch-request-entry
  [m8504]
  (clojure.core/let
   [bean8503
    (new
     com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry)]
   (clojure.core/let
    [v8505 (:id m8504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setId (clojure.core/str v8505))))
   (clojure.core/let
    [v8505
     (:message-attributes
      m8504
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (.
      bean8503
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8559] (clojure.core/str arg8559))
  (clojure.core/keys v8505))
 (clojure.core/map
  (clojure.core/fn [arg8559] (sqs/message-attribute-value arg8559))
  (clojure.core/vals v8505))))))
   (clojure.core/let
    [v8505
     (:message-body m8504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setMessageBody (clojure.core/str v8505))))
   (clojure.core/let
    [v8505
     (:delay-seconds m8504 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8505 :com.palletops.awaze.client-builder/undef)
     (. bean8503 setDelaySeconds (clojure.core/int v8505))))
   bean8503))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
get-queue-url-request
  [m8507]
  (clojure.core/let
   [bean8506
    (new com.amazonaws.services.sqs.model.GetQueueUrlRequest)]
   (clojure.core/let
    [v8508
     (:queue-name m8507 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8508 :com.palletops.awaze.client-builder/undef)
     (. bean8506 setQueueName (clojure.core/str v8508))))
   (clojure.core/let
    [v8508
     (:queue-owner-awsaccount-id
      m8507
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8508 :com.palletops.awaze.client-builder/undef)
     (. bean8506 setQueueOwnerAWSAccountId (clojure.core/str v8508))))
   bean8506))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
create-queue-request
  [m8510]
  (clojure.core/let
   [bean8509
    (new com.amazonaws.services.sqs.model.CreateQueueRequest)]
   (clojure.core/let
    [v8511
     (:attributes m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (.
      bean8509
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8560] (clojure.core/str arg8560))
  (clojure.core/keys v8511))
 (clojure.core/map
  (clojure.core/fn [arg8560] (clojure.core/str arg8560))
  (clojure.core/vals v8511))))))
   (clojure.core/let
    [v8511
     (:queue-name m8510 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8511 :com.palletops.awaze.client-builder/undef)
     (. bean8509 setQueueName (clojure.core/str v8511))))
   bean8509))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest}
list-dead-letter-source-queues-request
  [m8513]
  (clojure.core/let
   [bean8512
    (new
     com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest)]
   (clojure.core/let
    [v8514
     (:queue-url m8513 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8514 :com.palletops.awaze.client-builder/undef)
     (. bean8512 setQueueUrl (clojure.core/str v8514))))
   bean8512))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.RemovePermissionRequest}
remove-permission-request
  [m8516]
  (clojure.core/let
   [bean8515
    (new com.amazonaws.services.sqs.model.RemovePermissionRequest)]
   (clojure.core/let
    [v8517
     (:queue-url m8516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8517 :com.palletops.awaze.client-builder/undef)
     (. bean8515 setQueueUrl (clojure.core/str v8517))))
   (clojure.core/let
    [v8517 (:label m8516 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8517 :com.palletops.awaze.client-builder/undef)
     (. bean8515 setLabel (clojure.core/str v8517))))
   bean8515))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SetQueueAttributesRequest}
set-queue-attributes-request
  [m8519]
  (clojure.core/let
   [bean8518
    (new com.amazonaws.services.sqs.model.SetQueueAttributesRequest)]
   (clojure.core/let
    [v8520
     (:queue-url m8519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (. bean8518 setQueueUrl (clojure.core/str v8520))))
   (clojure.core/let
    [v8520
     (:attributes m8519 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8520 :com.palletops.awaze.client-builder/undef)
     (.
      bean8518
      setAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8561] (clojure.core/str arg8561))
  (clojure.core/keys v8520))
 (clojure.core/map
  (clojure.core/fn [arg8561] (clojure.core/str arg8561))
  (clojure.core/vals v8520))))))
   bean8518))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
receive-message-request
  [m8522]
  (clojure.core/let
   [bean8521
    (new com.amazonaws.services.sqs.model.ReceiveMessageRequest)]
   (clojure.core/let
    [v8523
     (:queue-url m8522 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setQueueUrl (clojure.core/str v8523))))
   (clojure.core/let
    [v8523
     (:attribute-names
      m8522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (.
      bean8521
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8562] (clojure.core/str arg8562))
 v8523))))
   (clojure.core/let
    [v8523
     (:visibility-timeout
      m8522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setVisibilityTimeout (clojure.core/int v8523))))
   (clojure.core/let
    [v8523
     (:message-attribute-names
      m8522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (.
      bean8521
      setMessageAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8563] (clojure.core/str arg8563))
 v8523))))
   (clojure.core/let
    [v8523
     (:max-number-of-messages
      m8522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setMaxNumberOfMessages (clojure.core/int v8523))))
   (clojure.core/let
    [v8523
     (:wait-time-seconds
      m8522
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8523 :com.palletops.awaze.client-builder/undef)
     (. bean8521 setWaitTimeSeconds (clojure.core/int v8523))))
   bean8521))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageRequest}
delete-message-request
  [m8525]
  (clojure.core/let
   [bean8524
    (new com.amazonaws.services.sqs.model.DeleteMessageRequest)]
   (clojure.core/let
    [v8526
     (:queue-url m8525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (. bean8524 setQueueUrl (clojure.core/str v8526))))
   (clojure.core/let
    [v8526
     (:receipt-handle m8525 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8526 :com.palletops.awaze.client-builder/undef)
     (. bean8524 setReceiptHandle (clojure.core/str v8526))))
   bean8524))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageRequest}
send-message-request
  [m8528]
  (clojure.core/let
   [bean8527
    (new com.amazonaws.services.sqs.model.SendMessageRequest)]
   (clojure.core/let
    [v8529
     (:queue-url m8528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setQueueUrl (clojure.core/str v8529))))
   (clojure.core/let
    [v8529
     (:message-attributes
      m8528
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (.
      bean8527
      setMessageAttributes
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8564] (clojure.core/str arg8564))
  (clojure.core/keys v8529))
 (clojure.core/map
  (clojure.core/fn [arg8564] (sqs/message-attribute-value arg8564))
  (clojure.core/vals v8529))))))
   (clojure.core/let
    [v8529
     (:message-body m8528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setMessageBody (clojure.core/str v8529))))
   (clojure.core/let
    [v8529
     (:delay-seconds m8528 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8529 :com.palletops.awaze.client-builder/undef)
     (. bean8527 setDelaySeconds (clojure.core/int v8529))))
   bean8527))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest}
change-message-visibility-batch-request
  [m8531]
  (clojure.core/let
   [bean8530
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest)]
   (clojure.core/let
    [v8532
     (:queue-url m8531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8532 :com.palletops.awaze.client-builder/undef)
     (. bean8530 setQueueUrl (clojure.core/str v8532))))
   (clojure.core/let
    [v8532 (:entries m8531 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8532 :com.palletops.awaze.client-builder/undef)
     (.
      bean8530
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8565]
  (sqs/change-message-visibility-batch-request-entry arg8565))
 v8532))))
   bean8530))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest}
change-message-visibility-request
  [m8534]
  (clojure.core/let
   [bean8533
    (new
     com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest)]
   (clojure.core/let
    [v8535
     (:queue-url m8534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setQueueUrl (clojure.core/str v8535))))
   (clojure.core/let
    [v8535
     (:receipt-handle m8534 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setReceiptHandle (clojure.core/str v8535))))
   (clojure.core/let
    [v8535
     (:visibility-timeout
      m8534
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8535 :com.palletops.awaze.client-builder/undef)
     (. bean8533 setVisibilityTimeout (clojure.core/int v8535))))
   bean8533))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
list-queues-request
  [m8537]
  (clojure.core/let
   [bean8536 (new com.amazonaws.services.sqs.model.ListQueuesRequest)]
   (clojure.core/let
    [v8538
     (:queue-name-prefix
      m8537
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8538 :com.palletops.awaze.client-builder/undef)
     (. bean8536 setQueueNamePrefix (clojure.core/str v8538))))
   bean8536))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteMessageBatchRequest}
delete-message-batch-request
  [m8540]
  (clojure.core/let
   [bean8539
    (new com.amazonaws.services.sqs.model.DeleteMessageBatchRequest)]
   (clojure.core/let
    [v8541
     (:queue-url m8540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8541 :com.palletops.awaze.client-builder/undef)
     (. bean8539 setQueueUrl (clojure.core/str v8541))))
   (clojure.core/let
    [v8541 (:entries m8540 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8541 :com.palletops.awaze.client-builder/undef)
     (.
      bean8539
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8638]
  (sqs/delete-message-batch-request-entry arg8638))
 v8541))))
   bean8539))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
delete-queue-request
  [m8543]
  (clojure.core/let
   [bean8542
    (new com.amazonaws.services.sqs.model.DeleteQueueRequest)]
   (clojure.core/let
    [v8544
     (:queue-url m8543 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8544 :com.palletops.awaze.client-builder/undef)
     (. bean8542 setQueueUrl (clojure.core/str v8544))))
   bean8542))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.AddPermissionRequest}
add-permission-request
  [m8546]
  (clojure.core/let
   [bean8545
    (new com.amazonaws.services.sqs.model.AddPermissionRequest)]
   (clojure.core/let
    [v8547
     (:queue-url m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (. bean8545 setQueueUrl (clojure.core/str v8547))))
   (clojure.core/let
    [v8547 (:label m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (. bean8545 setLabel (clojure.core/str v8547))))
   (clojure.core/let
    [v8547
     (:awsaccount-ids m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (.
      bean8545
      setAWSAccountIds
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8639] (clojure.core/str arg8639))
 v8547))))
   (clojure.core/let
    [v8547 (:actions m8546 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8547 :com.palletops.awaze.client-builder/undef)
     (.
      bean8545
      setActions
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8640] (clojure.core/str arg8640))
 v8547))))
   bean8545))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.PurgeQueueRequest}
purge-queue-request
  [m8549]
  (clojure.core/let
   [bean8548 (new com.amazonaws.services.sqs.model.PurgeQueueRequest)]
   (clojure.core/let
    [v8550
     (:queue-url m8549 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8550 :com.palletops.awaze.client-builder/undef)
     (. bean8548 setQueueUrl (clojure.core/str v8550))))
   bean8548))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.GetQueueAttributesRequest}
get-queue-attributes-request
  [m8552]
  (clojure.core/let
   [bean8551
    (new com.amazonaws.services.sqs.model.GetQueueAttributesRequest)]
   (clojure.core/let
    [v8553
     (:queue-url m8552 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8553 :com.palletops.awaze.client-builder/undef)
     (. bean8551 setQueueUrl (clojure.core/str v8553))))
   (clojure.core/let
    [v8553
     (:attribute-names
      m8552
      :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8553 :com.palletops.awaze.client-builder/undef)
     (.
      bean8551
      setAttributeNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg8641] (clojure.core/str arg8641))
 v8553))))
   bean8551))
 (clojure.core/defn
^{:tag com.amazonaws.services.sqs.model.SendMessageBatchRequest}
send-message-batch-request
  [m8555]
  (clojure.core/let
   [bean8554
    (new com.amazonaws.services.sqs.model.SendMessageBatchRequest)]
   (clojure.core/let
    [v8556
     (:queue-url m8555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8556 :com.palletops.awaze.client-builder/undef)
     (. bean8554 setQueueUrl (clojure.core/str v8556))))
   (clojure.core/let
    [v8556 (:entries m8555 :com.palletops.awaze.client-builder/undef)]
    (clojure.core/when-not
     (clojure.core/= v8556 :com.palletops.awaze.client-builder/undef)
     (.
      bean8554
      setEntries
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg8642]
  (sqs/send-message-batch-request-entry arg8642))
 v8556))))
   bean8554))
 (clojure.core/defmulti
  sqs
  (clojure.core/fn sqs [m__1874__auto__] (:fn m__1874__auto__)))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-url
   [m8566]
   (clojure.core/let
    [credentials8567 (:credentials m8566) args8568 (:args m8566)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8569
      (com.palletops.awaze.common/aws-client :sqs credentials8567)]
     (clojure.core/case
      (clojure.core/count args8568)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.GetQueueUrlRequest
           (clojure.core/nth args8568 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8569
           getQueueUrl
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8568 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8569
               getQueueUrl
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "getQueueUrl")
                {:args args8568}))))))))))))))
  (clojure.core/defn
   get-queue-url-map
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Generate map for getQueueUrl, getQueueUrl"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-url,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-url
   {:arglists (quote
               [[credentials
                 {:keys [queue-owner-awsaccount-id
                         custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         clone-root]}]
                [credentials string-0]]),
    :doc "Call getQueueUrl, getQueueUrl"}
   [credentials8571 & args8572]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8573
     (com.palletops.awaze.common/aws-client :sqs credentials8571)]
    (clojure.core/case
     (clojure.core/count args8572)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.GetQueueUrlRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.GetQueueUrlRequest
          (clojure.core/nth args8572 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8573
          getQueueUrl
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8572 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8573
              getQueueUrl
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "getQueueUrl")
               {:args args8572}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :create-queue
   [m8574]
   (clojure.core/let
    [credentials8575 (:credentials m8574) args8576 (:args m8574)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8577
      (com.palletops.awaze.common/aws-client :sqs credentials8575)]
     (clojure.core/case
      (clojure.core/count args8576)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8576 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8577
           createQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.CreateQueueRequest
               (clojure.core/nth args8576 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8577
               createQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "createQueue")
                {:args args8576}))))))))))))))
  (clojure.core/defn
   create-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]]),
    :doc "Generate map for createQueue, createQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :create-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   create-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         queue-name
                         attributes
                         clone-root]}]]),
    :doc "Call createQueue, createQueue"}
   [credentials8579 & args8580]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8581
     (com.palletops.awaze.common/aws-client :sqs credentials8579)]
    (clojure.core/case
     (clojure.core/count args8580)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8580 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8581
          createQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.CreateQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.CreateQueueRequest
              (clojure.core/nth args8580 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8581
              createQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "createQueue")
               {:args args8580}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-dead-letter-source-queues
   [m8582]
   (clojure.core/let
    [credentials8583 (:credentials m8582) args8584 (:args m8582)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8585
      (com.palletops.awaze.common/aws-client :sqs credentials8583)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8585
       listDeadLetterSourceQueues
       (sqs/list-dead-letter-source-queues-request
        (clojure.core/nth args8584 0)))))))
  (clojure.core/defn
   list-dead-letter-source-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for listDeadLetterSourceQueues"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-dead-letter-source-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-dead-letter-source-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call listDeadLetterSourceQueues"}
   [credentials8587 & args8588]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8589
     (com.palletops.awaze.common/aws-client :sqs credentials8587)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8589
      listDeadLetterSourceQueues
      (sqs/list-dead-letter-source-queues-request
       (clojure.core/nth args8588 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :remove-permission
   [m8590]
   (clojure.core/let
    [credentials8591 (:credentials m8590) args8592 (:args m8590)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8593
      (com.palletops.awaze.common/aws-client :sqs credentials8591)]
     (clojure.core/case
      (clojure.core/count args8592)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8593
        removePermission
        (sqs/remove-permission-request (clojure.core/nth args8592 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8593
        removePermission
        (clojure.core/str (clojure.core/nth args8592 0))
        (clojure.core/str (clojure.core/nth args8592 1))))))))
  (clojure.core/defn
   remove-permission-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for removePermission, removePermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :remove-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   remove-permission
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Call removePermission, removePermission"}
   [credentials8595 & args8596]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8597
     (com.palletops.awaze.common/aws-client :sqs credentials8595)]
    (clojure.core/case
     (clojure.core/count args8596)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8597
       removePermission
       (sqs/remove-permission-request (clojure.core/nth args8596 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8597
       removePermission
       (clojure.core/str (clojure.core/nth args8596 0))
       (clojure.core/str (clojure.core/nth args8596 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :set-queue-attributes
   [m8598]
   (clojure.core/let
    [credentials8599 (:credentials m8598) args8600 (:args m8598)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8601
      (com.palletops.awaze.common/aws-client :sqs credentials8599)]
     (clojure.core/case
      (clojure.core/count args8600)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8601
        setQueueAttributes
        (sqs/set-queue-attributes-request
         (clojure.core/nth args8600 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8601
        setQueueAttributes
        (clojure.core/str (clojure.core/nth args8600 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8643] (clojure.core/str arg8643))
  (clojure.core/keys (clojure.core/nth args8600 1)))
 (clojure.core/map
  (clojure.core/fn [arg8643] (clojure.core/str arg8643))
  (clojure.core/vals (clojure.core/nth args8600 1))))))))))
  (clojure.core/defn
   set-queue-attributes-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]
                [credentials string-0 map-1]]),
    :doc "Generate map for setQueueAttributes, setQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :set-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   set-queue-attributes
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         attributes
                         clone-root
                         queue-url]}]
                [credentials string-0 map-1]]),
    :doc "Call setQueueAttributes, setQueueAttributes"}
   [credentials8603 & args8604]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8605
     (com.palletops.awaze.common/aws-client :sqs credentials8603)]
    (clojure.core/case
     (clojure.core/count args8604)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8605
       setQueueAttributes
       (sqs/set-queue-attributes-request
        (clojure.core/nth args8604 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8605
       setQueueAttributes
       (clojure.core/str (clojure.core/nth args8604 0))
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg8644] (clojure.core/str arg8644))
  (clojure.core/keys (clojure.core/nth args8604 1)))
 (clojure.core/map
  (clojure.core/fn [arg8644] (clojure.core/str arg8644))
  (clojure.core/vals (clojure.core/nth args8604 1))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :receive-message
   [m8606]
   (clojure.core/let
    [credentials8607 (:credentials m8606) args8608 (:args m8606)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8609
      (com.palletops.awaze.common/aws-client :sqs credentials8607)]
     (clojure.core/case
      (clojure.core/count args8608)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ReceiveMessageRequest
           (clojure.core/nth args8608 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8609
           receiveMessage
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8608 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8609
               receiveMessage
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "receiveMessage")
                {:args args8608}))))))))))))))
  (clojure.core/defn
   receive-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Generate map for receiveMessage, receiveMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :receive-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   receive-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         max-number-of-messages
                         sdk-request-timeout
                         message-attribute-names
                         wait-time-seconds
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0]]),
    :doc "Call receiveMessage, receiveMessage"}
   [credentials8611 & args8612]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8613
     (com.palletops.awaze.common/aws-client :sqs credentials8611)]
    (clojure.core/case
     (clojure.core/count args8612)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ReceiveMessageRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ReceiveMessageRequest
          (clojure.core/nth args8612 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8613
          receiveMessage
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8612 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8613
              receiveMessage
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "receiveMessage")
               {:args args8612}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message
   [m8614]
   (clojure.core/let
    [credentials8615 (:credentials m8614) args8616 (:args m8614)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8617
      (com.palletops.awaze.common/aws-client :sqs credentials8615)]
     (clojure.core/case
      (clojure.core/count args8616)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8617
        deleteMessage
        (clojure.core/str (clojure.core/nth args8616 0))
        (clojure.core/str (clojure.core/nth args8616 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8617
        deleteMessage
        (sqs/delete-message-request (clojure.core/nth args8616 0))))))))
  (clojure.core/defn
   delete-message-map
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessage, deleteMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message
   {:arglists (quote
               [[credentials string-0 string-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessage, deleteMessage"}
   [credentials8619 & args8620]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8621
     (com.palletops.awaze.common/aws-client :sqs credentials8619)]
    (clojure.core/case
     (clojure.core/count args8620)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8621
       deleteMessage
       (clojure.core/str (clojure.core/nth args8620 0))
       (clojure.core/str (clojure.core/nth args8620 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8621
       deleteMessage
       (sqs/delete-message-request (clojure.core/nth args8620 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message
   [m8622]
   (clojure.core/let
    [credentials8623 (:credentials m8622) args8624 (:args m8622)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8625
      (com.palletops.awaze.common/aws-client :sqs credentials8623)]
     (clojure.core/case
      (clojure.core/count args8624)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8625
        sendMessage
        (sqs/send-message-request (clojure.core/nth args8624 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8625
        sendMessage
        (clojure.core/str (clojure.core/nth args8624 0))
        (clojure.core/str (clojure.core/nth args8624 1))))))))
  (clojure.core/defn
   send-message-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Generate map for sendMessage, sendMessage"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         delay-seconds
                         sdk-request-timeout
                         message-attributes
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         message-body
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1]]),
    :doc "Call sendMessage, sendMessage"}
   [credentials8627 & args8628]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8629
     (com.palletops.awaze.common/aws-client :sqs credentials8627)]
    (clojure.core/case
     (clojure.core/count args8628)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8629
       sendMessage
       (sqs/send-message-request (clojure.core/nth args8628 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8629
       sendMessage
       (clojure.core/str (clojure.core/nth args8628 0))
       (clojure.core/str (clojure.core/nth args8628 1))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility-batch
   [m8630]
   (clojure.core/let
    [credentials8631 (:credentials m8630) args8632 (:args m8630)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8633
      (com.palletops.awaze.common/aws-client :sqs credentials8631)]
     (clojure.core/case
      (clojure.core/count args8632)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8633
        changeMessageVisibilityBatch
        (clojure.core/str (clojure.core/nth args8632 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8709]
  (sqs/change-message-visibility-batch-request-entry arg8709))
 (clojure.core/nth args8632 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8633
        changeMessageVisibilityBatch
        (sqs/change-message-visibility-batch-request
         (clojure.core/nth args8632 0))))))))
  (clojure.core/defn
   change-message-visibility-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :change-message-visibility-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call changeMessageVisibilityBatch, changeMessageVisibilityBatch"}
   [credentials8635 & args8636]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8637
     (com.palletops.awaze.common/aws-client :sqs credentials8635)]
    (clojure.core/case
     (clojure.core/count args8636)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8637
       changeMessageVisibilityBatch
       (clojure.core/str (clojure.core/nth args8636 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8710]
  (sqs/change-message-visibility-batch-request-entry arg8710))
 (clojure.core/nth args8636 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8637
       changeMessageVisibilityBatch
       (sqs/change-message-visibility-batch-request
        (clojure.core/nth args8636 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :change-message-visibility
   [m8645]
   (clojure.core/let
    [credentials8646 (:credentials m8645) args8647 (:args m8645)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8648
      (com.palletops.awaze.common/aws-client :sqs credentials8646)]
     (clojure.core/case
      (clojure.core/count args8647)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8648
        changeMessageVisibility
        (sqs/change-message-visibility-request
         (clojure.core/nth args8647 0))))
      3
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8648
        changeMessageVisibility
        (clojure.core/str (clojure.core/nth args8647 0))
        (clojure.core/str (clojure.core/nth args8647 1))
        (clojure.core/int (clojure.core/nth args8647 2))))))))
  (clojure.core/defn
   change-message-visibility-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Generate map for changeMessageVisibility, changeMessageVisibility"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c]
    {:args [a b c],
     :fn :change-message-visibility,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   change-message-visibility
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         receipt-handle
                         sdk-request-timeout
                         custom-query-parameters
                         visibility-timeout
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 string-1 integer-2]]),
    :doc "Call changeMessageVisibility, changeMessageVisibility"}
   [credentials8650 & args8651]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8652
     (com.palletops.awaze.common/aws-client :sqs credentials8650)]
    (clojure.core/case
     (clojure.core/count args8651)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8652
       changeMessageVisibility
       (sqs/change-message-visibility-request
        (clojure.core/nth args8651 0))))
     3
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8652
       changeMessageVisibility
       (clojure.core/str (clojure.core/nth args8651 0))
       (clojure.core/str (clojure.core/nth args8651 1))
       (clojure.core/int (clojure.core/nth args8651 2))))))))
 (do
  (clojure.core/defmethod
   sqs
   :list-queues
   [m8653]
   (clojure.core/let
    [credentials8654 (:credentials m8653) args8655 (:args m8653)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8656
      (com.palletops.awaze.common/aws-client :sqs credentials8654)]
     (clojure.core/case
      (clojure.core/count args8655)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
          a
          (com.palletops.awaze.common/coerce-value-form
           com.amazonaws.services.sqs.model.ListQueuesRequest
           (clojure.core/nth args8655 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8656
           listQueues
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag java.lang.String}
              a
              (com.palletops.awaze.common/coerce-value-form
               java.lang.String
               (clojure.core/nth args8655 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8656
               listQueues
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "listQueues")
                {:args args8655}))))))))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8656
        listQueues))))))
  (clojure.core/defn
   list-queues-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]
                [credentials string-0]]),
    :doc "Generate map for listQueues, listQueues, listQueues"}
   ([credentials__1842__auto__]
    {:args [],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :list-queues,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   list-queues
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         queue-name-prefix
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root]}]
                [credentials]
                [credentials string-0]]),
    :doc "Call listQueues, listQueues, listQueues"}
   [credentials8658 & args8659]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8660
     (com.palletops.awaze.common/aws-client :sqs credentials8658)]
    (clojure.core/case
     (clojure.core/count args8659)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag com.amazonaws.services.sqs.model.ListQueuesRequest}
         a
         (com.palletops.awaze.common/coerce-value-form
          com.amazonaws.services.sqs.model.ListQueuesRequest
          (clojure.core/nth args8659 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8660
          listQueues
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag java.lang.String}
             a
             (com.palletops.awaze.common/coerce-value-form
              java.lang.String
              (clojure.core/nth args8659 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8660
              listQueues
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "listQueues")
               {:args args8659}))))))))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8660
       listQueues))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-message-batch
   [m8661]
   (clojure.core/let
    [credentials8662 (:credentials m8661) args8663 (:args m8661)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8664
      (com.palletops.awaze.common/aws-client :sqs credentials8662)]
     (clojure.core/case
      (clojure.core/count args8663)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8664
        deleteMessageBatch
        (clojure.core/str (clojure.core/nth args8663 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8711]
  (sqs/delete-message-batch-request-entry arg8711))
 (clojure.core/nth args8663 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8664
        deleteMessageBatch
        (sqs/delete-message-batch-request
         (clojure.core/nth args8663 0))))))))
  (clojure.core/defn
   delete-message-batch-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteMessageBatch, deleteMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :delete-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-message-batch
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteMessageBatch, deleteMessageBatch"}
   [credentials8666 & args8667]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8668
     (com.palletops.awaze.common/aws-client :sqs credentials8666)]
    (clojure.core/case
     (clojure.core/count args8667)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8668
       deleteMessageBatch
       (clojure.core/str (clojure.core/nth args8667 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8712]
  (sqs/delete-message-batch-request-entry arg8712))
 (clojure.core/nth args8667 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8668
       deleteMessageBatch
       (sqs/delete-message-batch-request
        (clojure.core/nth args8667 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :delete-queue
   [m8669]
   (clojure.core/let
    [credentials8670 (:credentials m8669) args8671 (:args m8669)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8672
      (com.palletops.awaze.common/aws-client :sqs credentials8670)]
     (clojure.core/case
      (clojure.core/count args8671)
      1
      (clojure.core/let
       [a__1817__auto__ (clojure.core/atom nil)]
       (try
        (clojure.core/let
         [^{:tag java.lang.String}
          a
          (com.palletops.awaze.common/coerce-value-form
           java.lang.String
           (clojure.core/nth args8671 0))]
         (clojure.core/reset! a__1817__auto__ true)
         (com.palletops.awaze.common/to-data
          (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8672
           deleteQueue
           a)))
        (catch
         java.lang.Exception
         e__1818__auto__
         (if
          (clojure.core/deref a__1817__auto__)
          (throw e__1818__auto__)
          (clojure.core/let
           [a__1817__auto__ (clojure.core/atom nil)]
           (try
            (clojure.core/let
             [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
              a
              (com.palletops.awaze.common/coerce-value-form
               com.amazonaws.services.sqs.model.DeleteQueueRequest
               (clojure.core/nth args8671 0))]
             (clojure.core/reset! a__1817__auto__ true)
             (com.palletops.awaze.common/to-data
              (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8672
               deleteQueue
               a)))
            (catch
             java.lang.Exception
             e__1818__auto__
             (if
              (clojure.core/deref a__1817__auto__)
              (throw e__1818__auto__)
              (throw
               (clojure.core/ex-info
                (clojure.core/str
                 "No Matching overloads for function "
                 "deleteQueue")
                {:args args8671}))))))))))))))
  (clojure.core/defn
   delete-queue-map
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for deleteQueue, deleteQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :delete-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   delete-queue
   {:arglists (quote
               [[credentials string-0]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call deleteQueue, deleteQueue"}
   [credentials8674 & args8675]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8676
     (com.palletops.awaze.common/aws-client :sqs credentials8674)]
    (clojure.core/case
     (clojure.core/count args8675)
     1
     (clojure.core/let
      [a__1817__auto__ (clojure.core/atom nil)]
      (try
       (clojure.core/let
        [^{:tag java.lang.String}
         a
         (com.palletops.awaze.common/coerce-value-form
          java.lang.String
          (clojure.core/nth args8675 0))]
        (clojure.core/reset! a__1817__auto__ true)
        (com.palletops.awaze.common/to-data
         (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8676
          deleteQueue
          a)))
       (catch
        java.lang.Exception
        e__1818__auto__
        (if
         (clojure.core/deref a__1817__auto__)
         (throw e__1818__auto__)
         (clojure.core/let
          [a__1817__auto__ (clojure.core/atom nil)]
          (try
           (clojure.core/let
            [^{:tag com.amazonaws.services.sqs.model.DeleteQueueRequest}
             a
             (com.palletops.awaze.common/coerce-value-form
              com.amazonaws.services.sqs.model.DeleteQueueRequest
              (clojure.core/nth args8675 0))]
            (clojure.core/reset! a__1817__auto__ true)
            (com.palletops.awaze.common/to-data
             (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8676
              deleteQueue
              a)))
           (catch
            java.lang.Exception
            e__1818__auto__
            (if
             (clojure.core/deref a__1817__auto__)
             (throw e__1818__auto__)
             (throw
              (clojure.core/ex-info
               (clojure.core/str
                "No Matching overloads for function "
                "deleteQueue")
               {:args args8675}))))))))))))))
 (do
  (clojure.core/defmethod
   sqs
   :add-permission
   [m8677]
   (clojure.core/let
    [credentials8678 (:credentials m8677) args8679 (:args m8677)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8680
      (com.palletops.awaze.common/aws-client :sqs credentials8678)]
     (clojure.core/case
      (clojure.core/count args8679)
      4
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8680
        addPermission
        (clojure.core/str (clojure.core/nth args8679 0))
        (clojure.core/str (clojure.core/nth args8679 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8713] (clojure.core/str arg8713))
 (clojure.core/nth args8679 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8714] (clojure.core/str arg8714))
 (clojure.core/nth args8679 3))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8680
        addPermission
        (sqs/add-permission-request (clojure.core/nth args8679 0))))))))
  (clojure.core/defn
   add-permission-map
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for addPermission, addPermission"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b c d]
    {:args [a b c d],
     :fn :add-permission,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   add-permission
   {:arglists (quote
               [[credentials string-0 string-1 list-2 list-3]
                [credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         awsaccount-ids
                         sdk-request-timeout
                         custom-query-parameters
                         actions
                         read-limit
                         label
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call addPermission, addPermission"}
   [credentials8682 & args8683]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8684
     (com.palletops.awaze.common/aws-client :sqs credentials8682)]
    (clojure.core/case
     (clojure.core/count args8683)
     4
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8684
       addPermission
       (clojure.core/str (clojure.core/nth args8683 0))
       (clojure.core/str (clojure.core/nth args8683 1))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8715] (clojure.core/str arg8715))
 (clojure.core/nth args8683 2))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8716] (clojure.core/str arg8716))
 (clojure.core/nth args8683 3))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8684
       addPermission
       (sqs/add-permission-request (clojure.core/nth args8683 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :purge-queue
   [m8685]
   (clojure.core/let
    [credentials8686 (:credentials m8685) args8687 (:args m8685)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8688
      (com.palletops.awaze.common/aws-client :sqs credentials8686)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8688
       purgeQueue
       (sqs/purge-queue-request (clojure.core/nth args8687 0)))))))
  (clojure.core/defn
   purge-queue-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for purgeQueue"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :purge-queue,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   purge-queue
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call purgeQueue"}
   [credentials8690 & args8691]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8692
     (com.palletops.awaze.common/aws-client :sqs credentials8690)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8692
      purgeQueue
      (sqs/purge-queue-request (clojure.core/nth args8691 0)))))))
 (do
  (clojure.core/defmethod
   sqs
   :get-queue-attributes
   [m8693]
   (clojure.core/let
    [credentials8694 (:credentials m8693) args8695 (:args m8693)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8696
      (com.palletops.awaze.common/aws-client :sqs credentials8694)]
     (clojure.core/case
      (clojure.core/count args8695)
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8696
        getQueueAttributes
        (clojure.core/str (clojure.core/nth args8695 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8717] (clojure.core/str arg8717))
 (clojure.core/nth args8695 1))))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8696
        getQueueAttributes
        (sqs/get-queue-attributes-request
         (clojure.core/nth args8695 0))))))))
  (clojure.core/defn
   get-queue-attributes-map
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Generate map for getQueueAttributes, getQueueAttributes"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :get-queue-attributes,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   get-queue-attributes
   {:arglists (quote
               [[credentials string-0 list-1]
                [credentials
                 {:keys [custom-request-headers
                         attribute-names
                         sdk-client-execution-timeout
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]]),
    :doc "Call getQueueAttributes, getQueueAttributes"}
   [credentials8698 & args8699]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8700
     (com.palletops.awaze.common/aws-client :sqs credentials8698)]
    (clojure.core/case
     (clojure.core/count args8699)
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8700
       getQueueAttributes
       (clojure.core/str (clojure.core/nth args8699 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn [arg8718] (clojure.core/str arg8718))
 (clojure.core/nth args8699 1))))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8700
       getQueueAttributes
       (sqs/get-queue-attributes-request
        (clojure.core/nth args8699 0))))))))
 (do
  (clojure.core/defmethod
   sqs
   :send-message-batch
   [m8701]
   (clojure.core/let
    [credentials8702 (:credentials m8701) args8703 (:args m8701)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
      client8704
      (com.palletops.awaze.common/aws-client :sqs credentials8702)]
     (clojure.core/case
      (clojure.core/count args8703)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8704
        sendMessageBatch
        (sqs/send-message-batch-request (clojure.core/nth args8703 0))))
      2
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8704
        sendMessageBatch
        (clojure.core/str (clojure.core/nth args8703 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8719]
  (sqs/send-message-batch-request-entry arg8719))
 (clojure.core/nth args8703 1))))))))
  (clojure.core/defn
   send-message-batch-map
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Generate map for sendMessageBatch, sendMessageBatch"}
   ([credentials__1842__auto__ a]
    {:args [a],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs})
   ([credentials__1842__auto__ a b]
    {:args [a b],
     :fn :send-message-batch,
     :credentials credentials__1842__auto__,
     :client :sqs}))
  (clojure.core/defn
   send-message-batch
   {:arglists (quote
               [[credentials
                 {:keys [custom-request-headers
                         sdk-client-execution-timeout
                         entries
                         sdk-request-timeout
                         custom-query-parameters
                         read-limit
                         general-progress-listener
                         clone-source
                         clone-root
                         queue-url]}]
                [credentials string-0 list-1]]),
    :doc "Call sendMessageBatch, sendMessageBatch"}
   [credentials8706 & args8707]
   (clojure.core/let
    [^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
     client8708
     (com.palletops.awaze.common/aws-client :sqs credentials8706)]
    (clojure.core/case
     (clojure.core/count args8707)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8708
       sendMessageBatch
       (sqs/send-message-batch-request (clojure.core/nth args8707 0))))
     2
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.sqs.AmazonSQSClient}
client8708
       sendMessageBatch
       (clojure.core/str (clojure.core/nth args8707 0))
^{:tag java.util.List}
(clojure.core/map
 (clojure.core/fn
  [arg8720]
  (sqs/send-message-batch-request-entry arg8720))
 (clojure.core/nth args8707 1)))))))))
