(ns org.domaindrivenarchitecture.build.image.domain
  (:require [clojure.spec.alpha :as s]
            [orchestra.core :refer [defn-spec]]
            [org.domaindrivenarchitecture.build.devops.domain :as d]))

(defn-spec copy-image-command seq?
  [devops ::d/devops]
  (let [{:keys [name]} devops]
    ["cp" "-r" "image" (d/build-path devops)]))

(defn-spec dbuild-command seq?
  [devops ::d/devops]
  (let [{:keys [name]} devops]
    ["docker" "build" "-t" name "--file"
     (str (d/build-path devops) "/image/Dockerfile")
     (str (d/build-path devops) "/image")]))
